# Contribution Guidelines

Please note that this project is released with a [Contributor Code of Conduct](code-of-conduct.md). By participating in this project, you agree to abide by its terms.

Thank you in advance for your contribution!

## General Guidelines

Ensure that your pull request adheres to the following general guidelines:

- Include only actual awesome content on the list. As every awesome list, it is meant to be a curation, not a collection.
- Only put content on the list that you can personally recommend.
- Ensure your contribution is grammatically correct, typo-free and has no Markdown formatting errors.
- Ensure your entries are consistent with the existing styling:

    - The link and description are separated by a dash.
    - The description starts with an uppercase character and ends with a period.
    - Naming is consistent and correct. For example, Node.js, not NodeJS or node.js.

Guidelines specific to each section are listed in the below chapters.

## Books

- The book can be both printed or ebook.
- The book must be fully finished and published. For example, a still-in-progress book on [Leanpub](https://leanpub.com) is not suitable to be added to the list before it is fully completed.
- Books are ordered by the recommended reading order, in increasing level of difficulty. Try to place your entry accordingly, even if it is just your best guess.

## Tutorials

- The tutorial must be free.
- Tutorials are ordered by the recommended learning order, in increasing level of difficulty. Try to place your entry accordingly, even if it is just your best guess.

## Open Source Projects

- The project has to have a well-written README page (see [Awesome README](https://github.com/matiassingers/awesome-readme)). It has to be clear out of the README page what the project is about.
- The project has to reach a certain level of maturity. Here are some good indicators of a mature project:

    - It is older than 30 days (counting from the first relevant commit).
    - It has 30 or more stars on GitHub.
    - It is maintained and developed regularly.

- If the project has a dedicated website, use the website address as the link, and not the project's GitHub repository.
- The projects are listed alphabetically by the project name. Place your entry accordingly.

Note that some awesome projects do not fulfill the above maturity criteria. For example, [Microsoft.CodeAnalysis.CSharp.PatternMatching](https://github.com/pvginkel/Microsoft.CodeAnalysis.CSharp.PatternMatching) provides a groundbreaking and inspiring approach to pattern matching on Roslyn syntax trees. As such it fully deserves to be on the list, although the author clearly stated that he does not plan to maintain it actively.

## Open Source Analyzers, Code Fixes, and Refactorings

Same as for [Open Source Projects](#open-source-projects).

## Libraries and Frameworks for Testing Analyzers, Code Fixes, and Refactorings

Same as for [Open Source Projects](#open-source-projects).

## Source Generators

Same as for [Open Source Projects](#open-source-projects).

## Blog Posts and Articles

- Blog posts and articles are meant for more in-depth technical topics like performance, Roslyn internals and similar. Do not put here general tutorials.

## Talks

- The talk must be free and publicly available. Paid tutorials do not qualify.
- The recording must be of decent quality.

## Updating your Pull Request

Sometimes, making a pull request adhere to the standards above can be difficult. If the maintainers notice anything that we'd like changed, we'll maybe ask you to edit your pull request before we merge it. There's no need to open a new pull request, just edit the existing one. If you're not sure how to do that, [here is a guide](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md) on the different ways you can update your pull request so that we can merge it.

Note however that updating pull requests can sometimes be an unnecessary overhead. In practice, if your contribution points to an awesome resource it will be accepted. Eventual smaller issues will be fixed by maintainers. Also, keep in mind that the descriptions evolve over time as we find a better way to express them. It might be that your original description will change over time. That's fine. It's a sign of a healthy and living awesome list :-)

Thanks once again for your contribution!