import { List } from "./types";

export const list: List = [
	{
		title: "Creative Technology",
		// eslint-disable-next-line sort-keys-fix/sort-keys-fix
		rows: {
			"1024 Architecture": {
				careerLink: "job@1024architecture.net",
				keywords: "architectural and digital works, orchestrated sound and light scores",
				link: "https://www.1024architecture.net/",
				locations: ["Paris"],
			},
			"Acrylicize": {
				careerLink: "work@acrylicize.com",
				keywords: "harness the power of art and creativity to help people fall in love with spaces",
				link: "https://www.acrylicize.com/",
				locations: ["London", "NYC", "Seattle"],
			},
			"Ada": {
				keywords:
					"experience innovation and design agency that partners with the world's most ambitious visionaries and brands in the culture, arts and social impact space",
				link: "https://a-da.co/",
				locations: ["NYC"],
			},
			"Adirondack Studios": {
				careerLink: "https://www.adkstudios.com/team/#careers",
				keywords: "concept, schematic, design, construction, fabrication, installation, support",
				link: "https://www.adkstudios.com/",
				locations: ["Glens Falls, NY", "Dubai", "Orlando", "Shanghai", "LA", "Singapore"],
			},
			"Alt Ethos": {
				keywords: "experiential, metaverse, and event design agency",
				link: "https://altethos.com/",
				locations: ["Denver"],
			},
			"Art + Com": {
				careerLink: "https://artcom.de/en/jobs/",
				keywords: "media sculptures, data installations, new media",
				link: "https://artcom.de/en/",
				locations: ["Berlin"],
			},
			"Art Processors": {
				careerLink: "https://www.artprocessors.net/job-opportunities",
				keywords:
					"partner with cultural and tourism organisations to invent new realities of human experience",
				link: "https://www.artprocessors.net",
				locations: ["Melbourne", "NYC"],
			},
			"Artists & Engineers": {
				keywords: "production and technology studio, showrooms, concerts, art installations",
				link: "https://www.artistsandengineers.co.uk/",
				locations: ["London"],
			},
			"Augmented Magic": {
				careerLink: "contact@augmented-magic.com",
				keywords: "augmented magic shows, digital installations",
				link: "https://www.augmented-magic.com/",
				locations: ["Paris"],
			},
			"AV Controls": {
				careerLink: "https://www.av-controls.com/jobs-current",
				keywords: "site-specific technology installations, digital landmarks",
				link: "https://www.av-controls.com/",
				locations: ["NYC"],
			},
			"Barbarian": {
				careerLink: "https://wearebarbarian.hire.trakstar.com/jobs?",
				keywords: "marketing and advertising, new media",
				link: "https://wearebarbarian.com/",
				locations: ["NYC"],
			},
			"batwin + robin productions": {
				keywords: "environments, interactives, theaters, events",
				link: "https://www.batwinandrobin.com/",
				locations: ["NYC"],
			},
			"Beaudry Interactive": {
				keywords: "themed entertainment, museum exhibitions, live shows, and branded experiences",
				link: "https://www.binteractive.com/",
				locations: ["LA"],
			},
			"Blackbow": {
				careerLink: "https://www.blackbow.cn/career/",
				keywords: "projection mapping, digital art and cultural experiences",
				link: "https://www.blackbow.cn/",
				locations: ["Beijing"],
			},
			"Blublu": {
				careerLink: "blu@blu-blu.com",
				keywords: "projection mapping, immersive experiences for museums and workspace",
				link: "http://www.blu-blu.com/",
				locations: ["Hangzhou"],
			},
			"Bluecadet": {
				careerLink: "https://www.bluecadet.com/contact/careers/#custom-shortcode-4",
				keywords: "experience design across digital and physical environments, visitor centers",
				link: "https://www.bluecadet.com/",
				locations: ["Philadelphia", "NYC"],
			},
			"Brain": {
				keywords: "s very serious art studio",
				link: "https://brain.wtf",
				locations: ["LA"],
			},
			"BRC Imagination Arts": {
				keywords: "brand and cultural stories, strategy, animation, digital and hybrid experiences",
				link: "https://www.brcweb.com/",
				locations: ["Burbank, CA", "Edinburgh", "Amsterdam"],
			},
			"BRDG Studios": {
				careerLink: "https://brdg.co/careers/",
				keywords: "digital moments in physical spaces, retail environments, art galleries, events",
				link: "https://www.brdg.co/",
				locations: ["Philadelphia"],
			},
			"BREAKFAST": {
				careerLink: "https://breakfaststudio.com/jobs",
				keywords: "software-/hardware-driven artworks, flip discs",
				link: "https://breakfastny.com/",
				locations: ["NYC"],
			},
			"Breeze Creative": {
				keywords:
					"interactive experience design, family entertainment, museums, playgrounds, educational institutions",
				link: "https://www.breezecreative.com/",
				locations: ["NYC", "Miami"],
			},
			"Bright": {
				careerLink: "https://brig.ht/contact",
				keywords: "data visualization, digital installations, experiential sites, video games",
				link: "https://brig.ht/",
				locations: ["Paris"],
			},
			"C&G Partners": {
				careerLink: "https://www.cgpartnersllc.com/about/careers/",
				keywords:
					"branding, digital installations, exhibits and environments, signage, wayfinding, websites",
				link: "https://www.cgpartnersllc.com/",
				locations: ["NYC"],
			},
			"Charcoalblue": {
				careerLink: "https://www.charcoalblue.com/work-with-us",
				keywords: "amazing spaces where stories are told and experiences are shared",
				link: "https://www.charcoalblue.com/",
				locations: ["NYC", "Melbourne", "Chicago", "UK", "London"],
			},
			"Cinimod Studio": {
				careerLink: "https://www.cinimodstudio.com/about",
				keywords:
					"location based work where technology, environment, content and real life interaction meet",
				link: "https://www.cinimodstudio.com",
				locations: ["London"],
			},
			"Cocolab": {
				keywords:
					"multimedia experiences, immersive walk, exhibitions, installations, multimedia museography",
				link: "https://cocolab.mx/en/",
				locations: ["Mexico City"],
			},
			"Code and Theory": {
				careerLink: "https://www.codeandtheory.com/careers",
				keywords:
					"strategically driven, digital-first agency that lives at the intersection of creativity and technology",
				link: "https://www.codeandtheory.com/",
				locations: ["NYC", "San Francisco", "London", "Manila"],
			},
			"Cognition": {
				careerLink: "https://www.codeandtheory.com/careers",
				keywords:
					"an interactive studio designed to enrich experiences by building creative technology with human empathy",
				link: "https://cognitionlabs.io/",
				locations: ["LA"],
			},
			"Comuzi": {
				keywords: "explore and imagine and prototyp and creatr future-forward creative concepts",
				link: "https://www.comuzi.xyz/",
				locations: ["London"],
			},
			"Cosm": {
				careerLink: "https://www.cosm.com/careers",
				keywords: "immersive entertainment and media, planetariums, LED domes",
				link: "https://www.cosm.com/",
				locations: ["Dallas", "LA", "City", "Pittsburgh", "Gurgaon"],
			},
			"DE-YAN": {
				careerLink: "CAREERS@DE-YAN.COM",
				keywords:
					"creative concepting, experiential, motion, graphic & interactive design within luxury, fashion, beauty, & lifestyle",
				link: "https://de-yan.com/",
				locations: ["NYC"],
			},
			"Deeplocal": {
				careerLink: "https://deeplocal.applytojob.com/",
				keywords: "creative engineers, inventors, interactive experiences, human stories",
				link: "https://www.deeplocal.com/",
				locations: ["Pittsburgh"],
			},
			"Design I/O": {
				keywords:
					"immersive, interactive installations, storytelling, events, galleries, museums, exhibitions and public space",
				link: "https://www.design-io.com/",
				locations: ["NYC", "San Francisco"],
			},
			"Digifun": {
				keywords: "projection mapping, new media art education",
				link: "http://www.digitalfun.net/",
				locations: ["Shanghai"],
			},
			"Digital Ambiance": {
				careerLink: "https://www.digitalambiance.com/careers/",
				keywords: "lighting design, projection mapping, interactive design",
				link: "https://www.digitalambiance.com/",
				locations: ["Berkeley, CA"],
			},
			"Digital Kitchen": {
				keywords:
					"iconic main titles, multimedia content, imaginative experiences, and immersive spaces",
				link: "https://www.thisisdk.com",
				locations: ["LA"],
			},
			"Dimensional Innovations": {
				careerLink: "https://dimin.com/about/careers",
				keywords: "experience design, interactive experiences, brand activation",
				link: "https://dimin.com/",
				locations: ["Kansas City", "Atlanta", "Minneapolis", "Denver", "LA", "Pittsburgh"],
			},
			"Dome": {
				keywords:
					"experience design studio that gathers designers, technologists, and strategists to solve unusual problems",
				link: "http://www.domecollective.com",
				locations: ["NYC"],
			},
			"Domestic Data Streamers": {
				keywords: "fighting indifference towards data",
				link: "https://domesticstreamers.com/",
				locations: ["Barcelona"],
			},
			"DOTDOT": {
				keywords: "AR, music videos, interactive installations, games",
				link: "https://dotdot.studio/about/",
				locations: ["Auckland", "NYC", "Brisbane"],
			},
			"dotdotdash": {
				careerLink: "https://www.dotdotdash.io/careers",
				keywords: "innovation agency that seamlessly blends the physical and digital",
				link: "https://dotdotdash.io/",
				locations: ["Portland", "LA", "NYC"],
			},
			"Downstream": {
				careerLink: "https://downstream.com/careers",
				keywords: "strategy + design + content + technology",
				link: "https://downstream.com/",
				locations: ["Portland", "Amsterdam", "Melbourne"],
			},
			"Dpt.": {
				careerLink: "https://dpt.co/en/contact-us/",
				keywords: "generating wonder with immersive platforms, AR, & VR",
				link: "https://dpt.co/",
				locations: ["Montreal"],
			},
			"EMMA Co-op": {
				keywords: "We develop software for clients in the video game, theater, public installation and media arts spaces among others.",
				link: "https://emma.coop",
				locations: ["NYC"],
			},
			"Eness": {
				careerLink: "https://www.eness.com/jobs",
				keywords: "evocative interactive experiences for public, commercial and cultural entities",
				link: "https://www.eness.com/",
				locations: ["Melbourne"],
			},
			"Envoy": {
				careerLink: "https://www.weareenvoy.com/careers",
				keywords: "transform environments into exceptional experiences, formerly Leviathan",
				link: "https://www.weareenvoy.com/",
				locations: ["Chicago", "LA", "San Diego"],
			},
			"Eos Lightmedia": {
				keywords:
					"lighting and audiovisual design, themed attractions, museums, architecture, public spaces, building facades, presentation centers, and public art installations",
				link: "https://www.eoslightmedia.com/",
				locations: ["Vancouver", "NYC", "Orlando"],
			},
			"ESI Design": {
				careerLink: "https://esidesign.nbbj.com/jobs/",
				keywords: "transforms places into experiences, immersive deisgn, architectural scale",
				link: "https://esidesign.nbbj.com/",
				locations: ["NYC"],
			},
			"Extrapolation Factory": {
				keywords: "research studio, futures studies, collaborative prototyping",
				link: "https://extrapolationfactory.com/",
				locations: ["NYC"],
			},
			"Fake Love (New York Times)": {
				closureReason: "COVID-19",
				keywords: "experiential design, real emotional connections, marketing",
				link: "https://www.nytco.com/products/fake-love/",
				locations: ["NYC"],
			},
			"Fast Horse": {
				careerLink: "https://www.fasthorseinc.com/careers/",
				keywords: "a truly integrated creative agency",
				link: "https://www.fasthorseinc.com/",
				locations: ["Minneapolis"],
			},
			"Five Stone Studios": {
				keywords: "Our creative arsenal spans design, live action, animation, & experiential storytelling",
				link: "https://fivestonestudios.com/",
				locations: ["Nashville"],
			},
			"FIELD": {
				careerLink: "https://field.systems/join-us",
				keywords: "future aesthetics for design, motion, experiential",
				link: "https://www.field.io/",
				locations: ["London"],
			},
			"Float4": {
				careerLink: "https://float4.com/en/life-at-float4/",
				keywords: "integrates digital experiences into physical spaces to amplify their identity",
				link: "https://float4.com/en/",
				locations: ["Montreal", "NYC"],
			},
			"fuse": {
				keywords: "live-media performances, experimentation, electronic music, digital arts",
				link: "https://www.fuseworks.it/en/",
				locations: ["Modena, Italy"],
			},
			"Future Colossal": {
				careerLink: "https://www.futurecolossal.com/contact",
				keywords: "experiential technologies in advertising and entertainment and art",
				link: "https://www.futurecolossal.com/",
				locations: ["NYC"],
			},
			"Gallagher & Associates": {
				careerLink: "https://www.futurecolossal.com/contact",
				keywords: "harmony between technology, narrative, and physical design",
				link: "https://www.gallagherdesign.com/",
				locations: ["DC", "NYC", "Portland", "Singapore"],
			},
			"Game Seven": {
				careerLink: "https://www.gameseven.agency/careers",
				keywords: "intersection of sport and culture, brand stories",
				link: "https://www.gamesevenmktg.com/",
				locations: ["NYC", "LA"],
			},
			"Geeksart": {
				careerLink: "http://geeks-art.com/join-us/",
				keywords: "media sculptures, new media exhibition",
				link: "http://geeks-art.com/",
				locations: ["Guangzhou", "Shanghai"],
			},
			"Giant Spoon": {
				careerLink: "https://giantspoon.com/#careers",
				keywords: "translate cultural trends into big ideas, experiential, gaming",
				link: "https://giantspoon.com/",
				locations: ["NYC", "LA"],
			},
			"Groove Jones": {
				careerLink: "https://groovejones.com/workwithus/",
				keywords: "XR, AR, VR, volumetric scanning, popups",
				link: "https://groovejones.com/",
				locations: ["Dallas"],
			},
			"Hirsch & Mann": {
				careerLink: "https://www.hirschandmann.com/jobs/",
				keywords:
					"digital and physical experiences for premium brands worldwide, experiential retail marketing, installation design",
				link: "https://www.hirschandmann.com/",
				locations: ["London"],
			},
			"Hotel Creative": {
				careerLink: "jobs@hotelcreative.com",
				keywords: "retail, branding, exhibitions, events",
				link: "https://hotelcreative.com/",
				locations: ["London"],
			},
			"Hovercraft": {
				careerLink: "https://hovercraftstudio.com/careers?job=freelance-creative-partners",
				keywords: "interactive installations, site-specific content, retail, sports",
				link: "https://www.hovercraftstudio.com/",
				locations: ["Denver", "Portland"],
			},
			"HUSH": {
				careerLink: "https://www.heyhush.com/people",
				keywords: "marketing and advertising, retail and DTC, architecture",
				link: "https://heyhush.com/",
				locations: ["NYC"],
			},
			"iart": {
				careerLink: "https://iart.ch/en/jobs",
				keywords:
					"studio for media architectures, enhancing physical spaces with digital technology",
				link: "https://iart.ch/en/",
				locations: ["Basel"],
			},
			"IMG SRC": {
				careerLink: "https://www.imgsrc.co.jp/en/careers/",
				keywords: "full-service communication agency focusing on websites, installations, and R&D",
				link: "https://www.imgsrc.co.jp/",
				locations: ["Tokyo"],
			},
			"Immersive International": {
				careerLink: "https://careers.immersive.international/#jobs",
				keywords: "live experiences and art installations in public, private and commercial spaces",
				link: "https://www.immersive.international/",
				locations: ["London", "Shanghai", "Ottawa", "Hong Kong", "Cape Town"],
			},
			"Intergalactic": {
				careerLink: "https://intergalactic.com/careers",
				keywords:
					"mobile apps, interactive screens, web development, application design and visualization",
				link: "https://intergalactic.com",
				locations: ["Vancouver", "London"],
			},
			"Invisible North": {
				careerLink: "jobs@invisiblenorth.com",
				keywords: "culturally fluent, thoughtful experiences, bring brands to life",
				link: "https://www.invisiblenorth.com/",
				locations: ["NYC"],
			},
			"Jam3": {
				careerLink: "https://media.monks.com/careers",
				keywords: "create modern experiences for tomorrow's brands",
				link: "https://www.jam3.com",
				locations: ["Toronto", "LA", "Montevideo", "Amsterdam"],
			},
			"Jason Sherwood Design": {
				keywords: "television and broadway and concert stage design",
				link: "http://jasonsherwooddesign.com/",
				locations: ["NYC"],
			},
			"Left Field Labs": {
				careerLink: "talent@leftfieldlabs.com",
				keywords: "products, platforms, and services that solve fundamental human challenges",
				link: "https://www.leftfieldlabs.com/",
				locations: ["LA"],
			},
			"Listen": {
				keywords: "sensory-driven brand assets, modern cultural landscape, sound, experiences",
				link: "https://wearelisten.com/",
				locations: ["NYC"],
			},
			"Lorem Ipsum": {
				keywords: "experience design, narrative, physical and digital environments",
				link: "https://loremipsumcorp.com/",
				locations: ["NYC", "Moscow", "London"],
			},
			"m ss ng p eces": {
				keywords:
					"new wave production and entertainment partner for content and immersive experiences that inspire culture",
				link: "https://mssngpeces.com/",
				locations: ["NYC", "LA"],
			},
			"Magnopus": {
				careerLink: "https://www.magnopus.com/current-openings",
				keywords: "unite the physical and digital worlds with extraordinary experiences",
				link: "https://www.magnopus.com/",
				locations: ["LA", "London"],
			},
			"Manifold": {
				careerLink: "https://www.wearemanifold.com/contact/",
				keywords: "we hire smart people and get out of their way",
				link: "https://www.wearemanifold.com/",
				locations: ["San Francisco", "LA", "Portland"],
			},
			"Map": {
				careerLink: "https://universal.pinpointhq.com/",
				keywords: "industrial designers who believe great design can solve problems",
				link: "http://mapprojectoffice.com/",
				locations: ["London"],
			},
			"Marshmallow Laser Feast": {
				careerLink: "jobs@marshmallowlaserfeast.com",
				keywords: "leaving a slug trail of sensory nuggets as we journey through the cosmos",
				link: "https://www.marshmallowlaserfeast.com/",
				locations: ["London"],
			},
			"Master of Shapes": {
				keywords: "a space surfing, geometry taming, buffalo riding, Future House",
				link: "https://masterofshapes.com/",
				locations: ["LA"],
			},
			"Midnight Commercial": {
				keywords: "unite the disparate digital and physical worlds",
				link: "http://midnightcommercial.com/",
				locations: ["NYC"],
			},
			"Midwest Immersive": {
				keywords:
					"immersive experiences for brands and agencies, projection mapping, LED lighting, games and app development",
				link: "https://www.mwimmersive.com/",
				locations: ["Chicago"],
			},
			"MindBuffer": {
				keywords: "audiovisual research and digital design studio",
				link: "https://mindbuffer.net/",
				locations: ["Berlin"],
			},
			"Moment Factory": {
				careerLink: "https://momentfactory.com/careers",
				keywords: "shows, destinations, content, interactive, scenography",
				link: "https://momentfactory.com/home",
				locations: ["Montreal", "LA", "London", "Tokyo", "Paris", "NYC"],
			},
			"Momentum Worldwide": {
				careerLink: "https://www.momentumww.com/opportunities/",
				keywords:
					"disruptive, entertaining, shareable, unforgettable experiences for clients and their fans",
				link: "https://www.momentumww.com/",
				locations: [
					"NYC",
					"Athens",
					"Atlanta",
					"Bogota",
					"Bucharest",
					"Cairo",
					"Chicago",
					"Dubai",
					"Frankfurt",
					"Gothenburg",
					"Lima",
					"London",
					"Madrid",
					"Manchester",
					"Mexico City",
					"Milan",
					"New Delhi",
					"Santiago",
					"Sao Paulo",
					"Seattle",
					"Seoul",
					"St. Louis",
					"Sydney",
					"Toronto",
					"Tokyo",
				],
			},
			"Motse": {
				careerLink: "lixuanjie@silkroadcg.com",
				keywords: "digital art",
				link: "https://www.behance.net/motseart/projects",
				locations: ["Shenzhen"],
			},
			"Mousetrappe Media": {
				careerLink: "https://www.mousetrappe.com/244-2/jobs/",
				keywords:
					"media design and production, architecturally mapped projection, immersive films, exhibits, attractions, and live events",
				link: "https://www.mousetrappe.com/",
				locations: ["LA"],
			},
			"MSCHF": {
				keywords: "viral stunts and products, trying to do stuff that the world can't even define",
				link: "https://mschf.xyz/",
				locations: ["NYC"],
			},
			"mycotoo": {
				keywords:
					"entertainment development company specializing in theme park design, immersive experiences, and best-in-class events worldwide",
				link: "https://mycotoo.com/",
				locations: ["LA", "Barcelona"],
			},
			"NCompass": {
				keywords:
					"brand and marketing solutions creating experiences that integrate the latest technology and creative",
				link: "https://ncompassonline.com/",
				locations: ["LA"],
			},
			"Neon Global": {
				careerLink: "https://www.neonglobal.com/en/connect/",
				keywords: "world class and epic experiences that are innovative, creative and exciting",
				link: "https://www.neonglobal.com/",
				locations: ["Singapore"],
			},
			"NeoPangea": {
				keywords: "microsites, games, VR/AR, digital, social",
				link: "https://www.neopangea.com/",
				locations: ["Reading, PA"],
			},
			"NEXT/NOW": {
				careerLink: "https://www.nextnowagency.com/careers",
				keywords: "brand activations, immersive environments, emerging technologies",
				link: "https://www.nextnowagency.com/",
				locations: ["Chicago"],
			},
			"Nexus Studios": {
				careerLink: "https://apply.workable.com/nexusstudios/",
				keywords: "film, experiential, AR",
				link: "https://nexusstudios.com/",
				locations: ["London", "Los Angeles"],
			},
			"NGX Interactive": {
				careerLink: "https://ngxinteractive.recruitee.com/",
				keywords: "pushing new technologies to create experiences that are vivid and meaningful",
				link: "https://ngxinteractive.com/",
				locations: ["Vancouver"],
			},
			"Night Kitchen": {
				careerLink: "jobs@whatscookin.com",
				keywords: "dynamic digital experiences, online exhibitions, digital strategy, storytelling",
				link: "https://www.whatscookin.com/",
				locations: ["Philadelphia"],
			},
			"Nohlab": {
				careerLink: "apply@nohlab.com",
				keywords: "producing interdisciplinary experiences around art, design and technology",
				link: "https://nohlab.com/works",
				locations: ["Istanbul"],
			},
			"Normal": {
				careerLink: "cv@normal.studio",
				keywords: "public installations, entertainment, performing arts, stage design",
				link: "https://normal.studio/en/",
				locations: ["Montreal"],
			},
			"Nowhere": {
				keywords: "marketing events, interactive experiences",
				link: "https://studionowhere.com/",
				locations: ["Shanghai"],
			},
			"Oat Foundry": {
				careerLink: "https://www.oatfoundry.com/careers/",
				keywords: "split-flap displays, electromechanical stuff, think tank, products, experiences",
				link: "https://www.oatfoundry.com/",
				locations: ["Philadelphia"],
			},
			"OIO": {
				keywords: "creative company working on future products and tools for a less boring future",
				link: "https://oio.studio/",
				locations: ["London"],
			},
			"Onformative": {
				careerLink: "https://onformative.com/jobs",
				keywords:
					"studio for digital art and design, challenge the boundaries between art and design and technology",
				link: "https://onformative.com/",
				locations: ["Berlin"],
			},
			"Optimist": {
				careerLink: "https://optimistinc.com/job-openings.html",
				keywords:
					"architects of subculture, creative, design, strategy, production, content, brand experience",
				link: "https://optimistinc.com/",
				locations: ["LA", "NYC", "London", "Amsterdam", "Hamburg", "Berlin", "Prague"],
			},
			"Ouchhh Studio": {
				keywords: "public art, poetic public experiences, data as a paint, algorithm as a brush",
				link: "https://ouchhh.tv/",
				locations: ["Istanbul"],
			},
			"Patten Studio": {
				careerLink: "https://www.pattenstudio.com/about/",
				keywords: "informed by research at the MIT Media Lab, experiences that connect people",
				link: "https://www.pattenstudio.com/",
				locations: ["NYC"],
			},
			"Pneuhaus": {
				keywords:
					"using inflatables to investigate the fundamental properties of perceptual experience in order to incite curiosity and wonder",
				link: "https://pneu.haus",
				locations: ["Island"],
			},
			"Potion Design": {
				careerLink: "https://www.potiondesign.com/work-with-us",
				keywords: "design and technology studio, interactive, musuems",
				link: "https://www.potiondesign.com/",
				locations: ["NYC"],
			},
			"pretty bloody simple": {
				keywords: "interactive experiences, analog and digital, musuems",
				link: "https://www.prettybloodysimple.com",
				locations: ["Munich"],
			},
			"RadicalMedia": {
				careerLink: "careers@radicalmedia.com",
				keywords:
					"commercials, documentaries, music videos, branded experiences, & immersive environments",
				link: "https://www.radicalmedia.com/",
				locations: ["NYC", "LA"],
			},
			"Rare Volume": {
				careerLink: "https://rarevolume.com/about/",
				keywords: "design and technology studio, interactive video walls",
				link: "https://rarevolume.com/",
				locations: ["NYC"],
			},
			"Recursive": {
				careerLink: "https://recursive.digital/career",
				keywords:
					"AV, Lighting, Content and Software to transform spaces for brands, venues, and people",
				link: "https://recursive.digital/",
				locations: ["Eastbourne, UK"],
			},
			"Red Paper Heart": {
				careerLink: "jobs@redpaperheart.com",
				keywords: "art from real world interaction",
				link: "https://redpaperheart.com",
				locations: ["NYC"],
			},
			"Relative Scale": {
				keywords: "bespoke digital products and experiences for brands and institutions",
				link: "https://relativescale.com/",
				locations: ["Raleigh"],
			},
			"RGI Creative": {
				careerLink: "https://www.rgicreative.com/contactform",
				keywords: "corporate experience design, museums exhibits and displays",
				link: "https://www.rgicreative.com/",
				locations: ["Cleveland"],
			},
			"Rosie Lee Creative": {
				careerLink: "https://rosieleecreative.com/jobs",
				keywords: "design, creative, digital and consultancy",
				link: "https://rosieleecreative.com/",
				locations: ["London", "Amsterdam", "NYC"],
			},
			"S1T2": {
				keywords:
					"We create interactive experiences that immerse audiences in the future of storytelling through technology.",
				link: "https://s1t2.com/",
				locations: ["Sydney", "Melbourne", "Shanghai"],
			},
			"Second Story": {
				careerLink: "https://careers.smartrecruiters.com/PublicisGroupe/razorfish",
				keywords: "exhibition, interactive, software, experience, hardware, VR, AR, projection",
				link: "https://secondstory.com/",
				locations: ["Atlanta", "Portland", "NYC"],
			},
			"Seeeklab": {
				keywords: "marketing events, interactive installation",
				link: "https://www.seeeklab.com/en/",
				locations: ["Xiamen"],
			},
			"Set Reset": {
				keywords:
					"transforming data into compelling stories that fuel growth and create opportunity",
				link: "https://set-reset.com/",
				locations: ["London"],
			},
			"Sitara Systems": {
				keywords:
					"we create interactive and immersive experiences that break down complex ideas, inspire reflection, and ignite curiosity.",
				link: "https://sitara.systems",
				locations: ["Las Vegas"],
			},
			"SOSO": {
				careerLink: "https://www.sosolimited.com/careers/",
				keywords:
					"delivering real human impact across physical and virtual space, placemaking and storytelling",
				link: "https://www.sosolimited.com/",
				locations: ["Boston", "San Diego"],
			},
			"space150": {
				careerLink: "https://www.space150.com/careers",
				keywords: "a tech-driven creative agency",
				link: "https://www.space150.com/",
				locations: ["Minneapolis", "LA", "NYC"],
			},
			"Sparks": {
				keywords: "conferences, popups, event production, fabrication",
				link: "https://www.wearesparks.com/",
				locations: ["Philadelphia", "Shanghai", "Paris", "Berlin", "Amsterdam"],
			},
			"Special Projects": {
				careerLink: "careers@specialprojects.studio",
				keywords:
					"design and innovation agency that reveals user needs and transforms them into experiences and products",
				link: "https://specialprojects.studio/",
				locations: ["London"],
			},
			"Spectacle": {
				keywords: "expertise in fabricating experiences that drive engagement and wow participants",
				link: "https://spectacle.works/",
				locations: ["Phoenix"],
			},
			"Spectra Studio": {
				keywords: "installations, projection, sculpture, robotics, light and sound",
				link: "https://spectra.studio/",
				locations: ["LA"],
			},
			"Squint/Opera": {
				keywords: "experience design for the built environment and musuems and attractions",
				link: "https://www.squintopera.com/about/",
				locations: ["London", "NYC", "Dubai"],
			},
			"Staat": {
				careerLink: "jobs@staat.com",
				keywords:
					"branding, editorial, event, film, graphic design, illustration, installation, interactive, interior design, production, retail",
				link: "https://www.staat.com/",
				locations: ["Amsterdam"],
			},
			"Stimulant": {
				keywords:
					"experience design and interactive installation, human-scale, site-specific digital experiences and touchscreen applications",
				link: "https://stimulant.com/",
				locations: ["San Francisco"],
			},
			"StoreyStudio": {
				careerLink: "https://www.storeystudio.com/content/vacancies",
				keywords: "spatial design, set design, window displays, moving image",
				link: "https://www.storeystudio.com/",
				locations: ["London"],
			},
			"Studio Black": {
				keywords: "technical production, design advisory, content management, digital content",
				link: "https://www.studioblack.org/",
				locations: ["LA", "NYC"],
			},
			"Studio Elsewhere": {
				keywords: "bio-experiential design and technology to support brain health",
				link: "https://www.studioelsewhere.co/",
				locations: ["NYC"],
			},
			"Studio TheGreenEyl": {
				keywords: "exhibitions, installations, objects, images, interactions and algorithms",
				link: "https://thegreeneyl.com/",
				locations: ["Berlin", "NYC"],
			},
			"Super A-OK": {
				keywords: "A multi-modal service bureau for the 21st century, fabrication, electronics",
				link: "https://superaok.com/",
				locations: ["NYC"],
			},
			"SUPERBIEN": {
				careerLink: "https://www.superbien.studio/career",
				keywords:
					"Creative studio for visually extended experiences, merging digital & physical environments.",
				link: "https://www.superbien.studio",
				locations: ["Paris", "NYC", "Dubai"],
			},
			"Superfly": {
				careerLink: "https://superflypresents.applytojob.com/apply",
				keywords: "create shared experiences that shape how the world plays & connects",
				link: "https://superf.ly/",
				locations: ["NYC"],
			},
			"TAD": {
				careerLink: "https://technologyarchitecturedesign.com/home/opportunities",
				keywords: "digital experiences, technology and architecture, designed to inspire people.",
				link: "https://technologyarchitecturedesign.com/",
				locations: ["NYC", "London"],
			},
			"tamschick": {
				careerLink: "https://tamschick.factorialhr.com/",
				keywords: "media and architectural narrative design, exhibitions, branded space, musuems",
				link: "https://tamschick.com/",
				locations: ["Berlin"],
			},
			"Team Epiphany": {
				careerLink: "info@teamepiphany.com",
				keywords: "influencer marketing, IRL, vertical integration",
				link: "https://www.teamepiphany.com/",
				locations: ["NYC", "LA"],
			},
			"Tellart": {
				careerLink: "careers@tellart.com",
				keywords:
					"transformative experiences, invention, physical & digital experiences, new technologies",
				link: "https://www.tellart.com/",
				locations: ["Providence", "Amsterdam", "San Francisco"],
			},
			"The Gathery": {
				careerLink: "https://www.thegathery.com/careers",
				keywords:
					"editorially-born creative agency specializing in brand marketing and content creation",
				link: "http://www.thegathery.com/",
				locations: ["NYC"],
			},
			"The Lab at Rockwell Group": {
				keywords: "architecture and design, branded experiences, immersive environments, pop ups",
				link: "https://www.labatrockwellgroup.com",
				locations: ["NYC"],
			},
			"The Projects": {
				keywords: "brand consultancy, meaningful experiences, tell stories",
				link: "http://theprojects.com/",
				locations: ["London", "LA", "NYC", "Sydney"],
			},
			"THG": {
				keywords: "experiential, exhibit, live shows, theme parks, retail, dining, museums",
				link: "https://thehettemagroup.com/",
				locations: ["LA"],
			},
			"Thinkwell": {
				careerLink: "https://thinkwellgroup.com/careers/",
				keywords:
					"strategy, experience design, production, master planning, entertainment destinations, branded attractions, interactive media installations, events, museums, expos",
				link: "https://thinkwellgroup.com/",
				locations: ["LA", "Montreal", "Abu Dhabi", "Riyadh"],
			},
			"Tinker": {
				keywords: "narrative spaces, musuems, experience design, consultancy",
				link: "https://tinker.nl/en",
				locations: ["Utrecht"],
			},
			"Tool": {
				keywords:
					"help brands and agencies with ideation, content, and experience production that generate buzz",
				link: "https://www.toolofna.com/",
				locations: ["LA"],
			},
			"Trivium Interactive": {
				careerLink: "https://www.triviuminteractive.com/careers",
				keywords: "experience design and production",
				link: "https://www.triviuminteractive.com/",
				locations: ["Boston"],
			},
			"Two Goats": {
				keywords: "AR, interactive branded experiences",
				link: "https://www.twogoats.us/",
				locations: ["NYC", "LA", "London"],
			},
			"Unified Field": {
				careerLink: "career@unifiedfield.com",
				keywords:
					"content-rich, experiential and interactive media for digital branding, media environments, and exhibits in public spaces",
				link: "https://www.unifiedfield.com/",
				locations: ["NYC"],
			},
			"UNIT9": {
				careerLink: "https://www.unit9.com/jobs",
				keywords:
					"innovation architects, product designers, software engineers, gaming experts, creatives, art directors, designers, producers and film directors",
				link: "https://www.unit9.com/",
				locations: ["London", "LA", "NYC", "Berlin"],
			},
			"Upswell": {
				careerLink: "https://upswell.studio/contact",
				keywords: "digital and physical content first experiences",
				link: "https://hello-upswell.com/",
				locations: ["Portland"],
			},
			"VTProDesign": {
				careerLink: "jobs@vtprodesign.com",
				keywords: "high tech robotics and projection mapping",
				link: "https://vtprodesign.com/",
				locations: ["LA"],
			},
			"Volvox Labs": {
				careerLink: "https://volvoxlabs.com/contact/",
				keywords: "high-end design, code, fabrication, sound, robotics",
				link: "https://volvoxlabs.com/",
				locations: ["NYC", "LA"],
			},
			"We Are Royale": {
				careerLink: "jobs@weareroyale.com",
				keywords:
					"frontlines of design & technology to arm brands with the creative to turn audiences into advocates",
				link: "https://weareroyale.com/",
				locations: ["LA", "Seattle"],
			},
			"We're Magnetic": {
				closureReason: "COVID-19",
				keywords: "immersive, authentic, culturally relevant experiences",
				link: "https://weremagnetic.com/",
				locations: ["NYC", "London", "LA"],
			},
			"WHITEvoid": {
				keywords:
					"public or brand spaces and events, trade fair stands, shows and exhibitions, museums and festivals",
				link: "https://www.whitevoid.com/",
				locations: ["Berlin", "Shanghai"],
			},
			"WOA STUDIO": {
				keywords: "immersive experiences, multimedia, video mapping, digital artistry",
				link: "https://www.woastudio.it/",
				locations: ["Milan"],
			},
			"Wonderlabs": {
				careerLink: "https://www.wonderlabsstudio.com/channels/219.html",
				keywords: "marketing events, interactive installation",
				link: "https://www.wonderlabsstudio.com/",
				locations: ["Shanghai"],
			},
			"XORXOR": {
				careerLink: "https://www.xorxor.hu/jobs.html",
				keywords:
					"collaboration between scientists, engineers, artists and robots, real-time visuals meet complex design",
				link: "https://www.xorxor.hu",
				locations: ["Budapest"],
			},
			"y=f(x)": {
				keywords:
					"creative technology studio focused on the creation of overarching multimedia experiences, with specially crafted software and design",
				link: "https://www.yfxlab.com/",
				locations: ["Amsterdam"],
			},
			"Yellow Studio": {
				careerLink: "join our team link broken",
				keywords: "artistically-minded design, tv/concert/event production design, set design",
				link: "https://yellowstudio.com/",
				locations: ["NYC"],
			},
			"Zebradog": {
				keywords: "communication design and the built environment, higher education",
				link: "https://www.zebradog.com/",
				locations: ["Madison"],
			},
			"Zebrar": {
				keywords: "immersive technology & interactive design, AR, VR, digital activations",
				link: "https://www.zebrar.com/",
				locations: ["Sydney"],
			},
		},
	},
	{
		title: "Collectives & Practices",
		// eslint-disable-next-line sort-keys-fix/sort-keys-fix
		description:
			"Established artist collectives/practices that work with creative technology (here primarily for reference, not necessarily for career opportunities).",
		rows: {
			"3-Legged Dog": {
				keywords: "original works in theater, performance, dance, media and hybrid forms",
				link: "https://www.3ld.org/",
				locations: ["NYC"],
			},
			"Brooklyn Research": {
				keywords:
					"we build interactive systems for a range of clients including museums, artists, and leading technology firms",
				link: "https://brooklynresearch.com/",
				locations: ["NYC"],
			},
			"Dave + Gabe": {
				keywords: "interactive installation studio, real-time animation, generative 3D sound",
				link: "https://www.daveandgabe.care/",
				locations: ["NYC"],
			},
			"Hypersonic": {
				keywords: "groundbreaking new media sculptures and physical installations",
				link: "https://www.hypersonic.cc/",
				locations: ["NYC"],
			},
			"Jen Lewin Studio": {
				keywords: "interactive light landscapes",
				link: "https://www.jenlewinstudio.com/",
				locations: ["NYC"],
			},
			"Kimchi and Chips": {
				keywords:
					"intersection of art, science and philosophy through ambitious large-scale installations",
				link: "https://www.kimchiandchips.com/",
				locations: ["South Korea"],
			},
			"NightLight Labs": {
				keywords: "installations, activations, narrative experiences",
				link: "https://nightlight.io/",
				locations: ["LA"],
			},
			"NONOTAK Studio": {
				keywords: "light and sound installations, ethereal, immersive, dreamlike",
				link: "https://www.nonotak.com/",
				locations: ["Paris"],
			},
			"panGenerator": {
				keywords: "new media art and design collective, mixing bits & atoms",
				link: "https://pangenerator.com/",
				locations: ["Warsaw"],
			},
			"Random International": {
				keywords:
					"experimental practice within contemporary art, human condition in an increasingly mechanised world",
				link: "https://www.random-international.com/",
				locations: ["London", "Berlin"],
			},
			"Smooth Technology": {
				keywords:
					"cutting-edge technology and artistic sensibility, wireless wearables, create the impossible",
				link: "https://smooth.technology/",
				locations: ["NYC"],
			},
			"Taller Estampa": {
				keywords:
					"group of filmmakers, programmers and researchers who work in the fields of experimental audiovisual and digital environments.",
				link: "https://www.tallerestampa.com",
				locations: ["Barcelona"],
			},
			"teamLab": {
				keywords:
					"full-room interactive projection mapping, interdisciplinary group of ultratechnologists",
				link: "https://www.teamlab.art/",
				locations: ["Tokyo"],
			},
			"The Cuttlefish": {
				keywords: "explore and imagine and prototyp and creatr future-forward creative concepts",
				link: "https://www.thecuttlefish.com/",
				locations: ["USA"],
			},
			"TUNDRA": {
				keywords: "In our artworks, we blend light, sound, space and use technology as a tool to interact with rapidly-changing environmental context.",
				link: "https://www.wearetundra.com/",
				locations: ["St. Petersburg"],
			},
			"Ultravioletto": {
				keywords: "exhibitions, fairs, museums, brand experiences and events",
				link: "https://ultraviolet.to/",
				locations: ["Rome"],
			},
			"United Visual Artists": {
				keywords:
					"new technologies with traditional media, site-specific, instruments that manipulate perception",
				link: "https://www.uva.co.uk/",
				locations: ["London"],
			},
			"WHYIXD": {
				keywords: "cross-disciplinary art installations, dance, architecture, music",
				link: "https://www.whyixd.com/",
				locations: ["Taiwan"],
			},
		},
	},
	{
		title: "Experiential Spaces & Experiences",
		// eslint-disable-next-line sort-keys-fix/sort-keys-fix
		description: "Groups that create experential spaces & experiences full of creative technology.",
		rows: {
			"29 Rooms (Vice Media Group)": {
				keywords: "multi-sensory installations, performances, and workshops",
				link: "https://www.29rooms.com/",
				locations: ["USA"],
			},
			"Cascade": {
				keywords: "interactive art experience",
				link: "https://cascadeshow.com/",
				locations: ["LA"],
			},
			"Color Factory": {
				keywords: "collaborative interactive exhibit",
				link: "https://www.colorfactory.co/",
				locations: ["NYC", "Houston"],
			},
			"Meow Wolf": {
				keywords:
					"immersive and interactive experiences that transport audiences of all ages into fantastic realms of story and exploration",
				link: "https://meowwolf.com/",
				locations: ["Santa Fe", "Las Vegas", "Denver"],
			},
			"Museum of Ice Cream": {
				keywords:
					"transforms concepts and dreams into spaces that provoke imagination and creativity",
				link: "https://www.museumoficecream.com/",
				locations: ["San Francisco", "NYC"],
			},
			"PopUpMob": {
				keywords: "one-stop shop for pop up experiences",
				link: "https://popupmob.com/",
				locations: ["NYC", "LA", "London", "Paris"],
			},
			"Studio Daguet": {
				keywords: "staging stories, show, music, theme parks, museums, hotels",
				link: "http://www.daguet.com/",
				locations: ["Nantes", "Paris"],
			},
		},
	},
	{
		title: "Fabricators",
		// eslint-disable-next-line sort-keys-fix/sort-keys-fix
		description: "Groups that mostly fabricate pieces for creative technology companies.",
		rows: {
			"5 Ten": {
				keywords: "LED technology design, fabrication, and integration",
				link: "https://www.510visuals.com/",
				locations: ["NYC"],
			},
			"Bednark": {
				keywords: "full-service fabrication, production, install",
				link: "https://builtbybednark.com/",
				locations: ["NYC"],
			},
			"Bridgewater Studio": {
				careerLink: "https://www.bridgewaterstudio.net/about",
				keywords: "full service design and fabrication",
				link: "https://www.bridgewaterstudio.net",
				locations: ["Chicago"],
			},
			"Eventscape": {
				keywords: "building the extraordinary, full service",
				link: "https://eventscape.com/",
				locations: ["Toronto"],
			},
			"Gamma": {
				keywords: "large scale robotic cnc, install, sculptures",
				link: "https://gamma.nyc/",
				locations: ["NYC"],
			},
			"Pink Sparrow": {
				keywords: "environmental design, project management",
				link: "https://www.pinksparrow.com/",
				locations: ["NYC", "LA"],
			},
			"Visionary Effects": {
				keywords: "old-school manufacturing processes with digital design and fabrication",
				link: "http://www.visionaryeffects.com/",
				locations: ["Pittsburgh"],
			},
		},
	},
	{
		title: "Event Production",
		// eslint-disable-next-line sort-keys-fix/sort-keys-fix
		description:
			"Groups that specialize in event production, often with a creative technology twist.",
		rows: {
			"Dera Lee Productions": {
				keywords: "theatre arts, story-telling",
				link: "http://www.deralee.com/",
				locations: ["NYC"],
			},
			"GPJ": {
				keywords: "immersive events and experiences",
				link: "https://www.gpj.com/",
				locations: [
					"Austin",
					"Boston",
					"Dallas",
					"Detroit",
					"LA",
					"Nashville",
					"NYC",
					"San Francisco",
					"Silicon Valley",
				],
			},
			"SAT": {
				keywords: "immersive experiences, concerts, workshops, conferences, exhibitions",
				link: "https://sat.qc.ca/en",
				locations: ["Montreal"],
			},
			"Sparks": {
				keywords: "trade show, experiential, retail",
				link: "https://wearesparks.com/",
				locations: [
					"Philadelphia",
					"Detroit",
					"Connecticut",
					"Atlanta",
					"LA",
					"Las Vegas",
					"NYC",
					"San Francisco",
					"Shanghai",
				],
			},
		},
	},
	{
		title: "Architecture",
		// eslint-disable-next-line sort-keys-fix/sort-keys-fix
		description:
			"Groups that generally design architecture often incorporating creative technology.",
		rows: {
			"Carlo Ratti Associatti": {
				keywords: "design and innovation office, MIT Media Lab: Senseable City Lab",
				link: "https://carloratti.com/",
				locations: ["Torino, Italy", "NYC", "UK"],
			},
			"Gensler DXD": {
				keywords:
					"built environment with integrated capabilities in strategy, design, technology, data, and architecture",
				link: "https://dxd.gensler.com/",
				locations: ["Worldwide"],
			},
			"Olson Kundig": {
				keywords:
					"architecture, vessel that supports specific art installations, seamless spatial experience",
				link: "https://olsonkundig.com/",
				locations: ["Seattle", "NYC"],
			},
			"SOFTlab": {
				keywords:
					"mixes research and creativity and technology with a strong desire to make working fun",
				link: "https://softlabnyc.com/",
				locations: ["NYC"],
			},
			"Universal Design Studio": {
				keywords:
					"driven by a deeply held belief in the transformative power of well designed and finely crafted spaces",
				link: "http://www.universaldesignstudio.com/",
				locations: ["London", "NYC"],
			},
		},
	},
	{
		title: "Creative Agencies",
		// eslint-disable-next-line sort-keys-fix/sort-keys-fix
		description:
			"Groups that are have a more general focus, but have a knack for projects imbued with creative technology.",
		rows: {
			"&Walsh": {
				keywords: "brand strategy, art direction, design and production across all platforms",
				link: "https://andwalsh.com/",
				locations: ["NYC"],
			},
			"AKQA": {
				keywords: "the most powerful force in the universe isn’t technology, it’s imagination",
				link: "https://www.akqa.com/",
				locations: [
					"London",
					"SF",
					"São Paulo",
					"Melbourne",
					"Aarhus",
					"Miami",
					"Amsterdam",
					"Atlanta",
					"Auckland",
					"Berlin",
					"Cairo",
					"Cape Town",
					"Copenhagen",
					"Dubai",
					"Gothenburg",
					"Gurgaon",
					"Johannesburg",
					"Milan",
					"NYC",
					"Paris",
					"Portland, OR",
					"Riyadh",
					"Shanghai",
					"Stockholm",
					"Sydney",
					"Tokyo",
					"Venice",
					"DC",
					"Wellington",
				],
			},
			"BUCK": {
				keywords: "VR, AR, installation, real-time animation, 3D, experiential",
				link: "https://buck.co/",
				locations: ["LA", "NYC", "Sydney", "Amsterdam"],
			},
			"Framestore": {
				keywords:
					"virtual, augmented and mixed realities, location-based entertainment, and theme park rides",
				link: "https://www.framestore.com/",
				locations: ["London", "NYC", "Montreal"],
			},
			"ManvsMachine": {
				keywords: "multidimensional creative studio",
				link: "https://mvsm.com/",
				locations: ["London", "LA"],
			},
			"Media Monks": {
				keywords: "creative production",
				link: "https://www.mediamonks.com/",
				locations: [
					"Amsterdam",
					"London",
					"Dubai",
					"Stockholm",
					"NYC",
					"LA",
					"San Francisco",
					"Mexico City",
					"São Paulo",
					"Buenos Aires",
					"Shanghai",
					"Singapore",
				],
			},
			"R/GA": {
				keywords: "business, experience, and marketing transformation",
				link: "https://www.rga.com/",
				locations: [
					"Austin",
					"Chicago",
					"LA",
					"NYC",
					"Portland",
					"San Francisco",
					"Berlin",
					"Bucharest",
					"London",
					"Buenos Aires",
					"Santiago",
					"São Paulo",
					"Melbourne",
					"Shanghai",
					"Singapore",
					"Sydney",
					"Tokyo",
				],
			},
			"SuperUber": {
				keywords: "experiences that blend art, technology, architecture and design",
				link: "https://www.superuber.com/",
				locations: ["Rio de Janeiro", "São Paulo"],
			},
			"The Mill": {
				keywords:
					"experience makers, media and brand activation, innovative design, and inventive technologies",
				link: "https://www.themill.com/",
				locations: ["London", "NYC", "LA", "Chicago", "Bangalore", "Berlin"],
			},
			"Weber Shandwick": {
				keywords:
					"we work at the intersection of technology, society, policy and media, adding value to culture — to shape and re-shape it",
				link: "https://www.webershandwick.com/",
				locations: [
					"Atlanta",
					"Baltimore",
					"Bogotá",
					"Boston",
					"Brasilia",
					"Buenos Aires",
					"Buffalo",
					"Chicago",
					"Dallas",
					"Detroit",
					"Lima",
					"LA",
					"Mexico City",
					"Minneapolis",
					"Montreal",
					"Nashville, TN",
					"NYC",
					"Philadelphia",
					"Rio de Janeiro",
					"SF",
					"Santiago",
					"Seattle",
					"St. Louis",
					"São Paulo",
					"Toronto",
					"Vancouver",
					"DC",
				],
			},
		},
	},
	{
		title: "Museums",
		// eslint-disable-next-line sort-keys-fix/sort-keys-fix
		description:
			"Groups that generally focus on designing museums and similar experiences using creative technology.",
		rows: {
			"Art Processors": {
				keywords: "specialist interactive media and exhibition design",
				link: "https://www.artprocessors.net/",
				locations: ["Melbourne"],
			},
			"Cortina Productions": {
				keywords:
					"artistry, content, and technology, we render the word to the story, the story to the medium, and the medium to the space.",
				link: "https://www.cortinaproductions.com/",
				locations: ["McLean, VA"],
			},
			"Exploratorium": {
				keywords: "exhibits made in-house, public-facing workshop",
				link: "https://www.exploratorium.edu/",
				locations: ["San Francisco"],
			},
			"Gagarin": {
				keywords: "weaving education, information and data into compelling stories",
				link: "https://gagarin.is/",
				locations: ["Reykjavík"],
			},
			"Grumpy Sailor": {
				keywords: "digital experiences, exhibit design, brands",
				link: "https://www.grumpysailor.com/",
				locations: ["Sydney", "Melbourne"],
			},
			"GSM Project": {
				keywords: "content first, exhibitions",
				link: "https://gsmproject.com/en/",
				locations: ["Montreal", "Singapore", "Dubai"],
			},
			"Ideum": {
				keywords: "interactive exhibits and exhibitions, integrated hardware products",
				link: "https://www.ideum.com/",
				locations: ["Albuquerque"],
			},
			"Iglhaut + von Grote": {
				keywords: "scenography, spatial mise-en-scène",
				link: "http://iglhaut-vongrote.de/en/",
				locations: ["Berlin"],
			},
			"Local Projects": {
				keywords: "experience Designers pushing the boundaries of human interaction",
				link: "https://localprojects.com/",
				locations: ["NYC"],
			},
			"Monadnock Media": {
				keywords: "multimedia experiences for museums, historic sites and public places",
				link: "https://monadnock.org/",
				locations: ["Massachusetts"],
			},
			"Northern Light Productions": {
				keywords: "immersive media environments, interactive experiences, or documentary films.",
				link: "https://nlprod.com/",
				locations: ["Boston"],
			},
			"Riggs Ward Design": {
				keywords:
					"exhibition and interactive design, strategic master planning, research, content analysis, and storyline development for museums, visitor centers, and cultural institutions",
				link: "https://riggsward.com/",
				locations: ["Richmond, Virginia"],
			},
			"RLMG": {
				keywords:
					"story-driven, interactive, dynamic, immersive, and educational installations for public spaces.",
				link: "https://www.rlmg.com/",
				locations: ["Boston"],
			},
			"Roto": {
				keywords:
					"experience design, immersive media, interactive engineering, and custom fabrication for museums, brands, attractions and architectural placemaking.",
				link: "https://roto.com/",
				locations: ["Columbus, OH"],
			},
			"Thinc": {
				keywords: "provoke meaningful conversations about the world in which we live",
				link: "https://www.thincdesign.com/",
				locations: ["NYC"],
			},
			"TKNL": {
				keywords: "immersive shows, projection, visitor experience design",
				link: "https://www.tknl.com/en/experiences",
				locations: ["Montreal"],
			},
		},
	},
	{
		title: "Festivals & Conferences",
		// eslint-disable-next-line sort-keys-fix/sort-keys-fix
		description: "Meetups for creative technologists.",
		rows: {
			Eyeo: {
				closureReason: "Likely discontinued in 2022",
				keywords: "a gathering for the creative technology community",
				link: "https://www.eyeofestival.com/",
				locations: ["Minneapolis"],
			},
			ISEA: {
				keywords: "the crossroads where art, design, science, technology and society meet",
				link: "https://isea2022.isea-international.org/",
				locations: ["Barcelona", "Paris"],
			},
			MUTEK: {
				keywords: "electronic music, audiovisual performance, digital art",
				link: "https://montreal.mutek.org/",
				locations: ["Montreal"],
			},
			SXSW: {
				keywords: "film, music, interactive arts",
				link: "https://www.sxsw.com/",
				locations: ["Austin"],
			},
		},
	},
	{
		title: "Education",
		// eslint-disable-next-line sort-keys-fix/sort-keys-fix
		description:
			"Undergrad programs, masters and open course teaching and researching creative technologies",
		rows: {
			"Goldsmiths": {
				keywords:
					"a degree which develops your arts practice through the expressive world of creative computation",
				link: "https://www.gold.ac.uk/pg/ma-computational-arts/",
				locations: ["London"],
			},
			"ITP": {
				keywords:
					"ITP/IMA offers four programs focused on creative and meaningful application of interactive tools and media.",
				link: "https://tisch.nyu.edu/itp",
				locations: ["NYC"],
			},
			"MIT Medialab": {
				keywords:
					"art, science, design, and technology build and play off one another in an environment designed for collaboration and inspiration",
				link: "https://media.mit.edu/",
				locations: ["Boston"],
			},
			"Paris College of Art": {
				keywords:
					"designed for those who are interested in exploring the wide-ranging creative field of New Media",
				link: "https://www.paris.edu/programs/graduate/master-transdisciplinary-new-media/",
				locations: ["Paris"],
			},
			"University of the Arts": {
				keywords: "computational technologies in the context of creative computing research",
				link: "https://www.arts.ac.uk/subjects/creative-computing/postgraduate/mres-creative-computing",
				locations: ["London"],
			},
		},
	},
];
