# Contributing Guidelines

Please note that this project is released with a [Contributor Code of Conduct](CODE-OF-CONDUCT.md). By participating in this project, you agree to abide by its terms.

## Table of Contents

- [Pull Request Guidelines](#pull-request-guidelines)
- [How to add to this list](#how-to-add-to-this-list)
- [Updating your Pull Request](#updating-your-pull-request)

## Pull Request Guidelines

Please ensure your pull request adheres to the following guidelines:

- Search previous suggestions to make sure your suggestion isn't a duplicate.
- Make sure each list item is useful before adding it.
- Create individual pull requests/issues for each suggestion.
- Use [title-casing](http://titlecapitalization.com) (AP style) in the following format: `[List Name](link)`
- Link additions should be added in alphabetical order in the relevant category.
- New categories or changes to the existing categorization are welcome.
- Check your spelling and grammar.
- Make sure your text editor is set to remove trailing whitespace.
- The pull request and commit should have a useful title.
- Annotate your PR to clarify what you did if the diff is confusing.

Thank you for your suggestions!

## How to add to this list

If you have something awesome to contribute to this list, this is how you do it.

If you have a GitHub account:

1. Fork this repo.
2. Make changes under correct section in `README.md`
3. Update `Contents` (if applicable)
4. Commit and open a Pull Request

If you don't have a [GitHub account](https://github.com/join), make one!

1. Access the awesome list's GitHub page. For example: https://github.com/sindresorhus/awesome
2. Click on the `readme.md` file: ![Step 2 Click on Readme.md](https://cloud.githubusercontent.com/assets/170270/9402920/53a7e3ea-480c-11e5-9d81-aecf64be55eb.png)
3. Now click on the edit icon. ![Step 3 - Click on Edit](https://cloud.githubusercontent.com/assets/170270/9402927/6506af22-480c-11e5-8c18-7ea823530099.png)
4. You can start editing the text of the file in the in-browser editor. Make sure you follow guidelines above. You can use [GitHub Flavored Markdown](https://help.github.com/articles/github-flavored-markdown/). ![Step 4 - Edit the file](https://cloud.githubusercontent.com/assets/170270/9402932/7301c3a0-480c-11e5-81f5-7e343b71674f.png)
5. Say why you're proposing the changes, and then click on "Propose file change". ![Step 5 - Propose Changes](https://cloud.githubusercontent.com/assets/170270/9402937/7dd0652a-480c-11e5-9138-bd14244593d5.png)
6. Submit the [pull request](https://help.github.com/articles/using-pull-requests/)!

## Updating your Pull Request

Sometimes, a maintainer of an awesome list will ask you to edit your Pull Request before it is included. This is normally due to spelling errors or because your PR didn't match the awesome-* list guidelines.

[Here](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md) is a write up on how to change a Pull Request, and the different ways you can do that.
