<div align="center" markdown="1">
  <sup>Special thanks to:</sup>
  <br>
  <br>
  <a href="https://www.warp.dev/awesome-mac">
    <img alt="Warp sponsorship" width="400" src="https://jaywcjlove.github.io/sponsor/warp-banner.png">
  </a>
  <br>
  <a href="https://warp.dev/awesome-mac"><b>Warp, the intelligent terminal for developers!</b></a><br>
  <a href="https://warp.dev/awesome-mac">Available for MacOS, Linux, & Windows</a><br><br>

  <a href="https://zenquery.app/?utm_source=github&utm_medium=referral&utm_campaign=awesome-mac">
    <img alt="Zenquery sponsorship" width="400" src="https://jaywcjlove.github.io/sponsor/zenquery.png">
  </a>
  <br>
  <a href="https://zenquery.app/?utm_source=github&utm_medium=referral&utm_campaign=awesome-mac"><b>ZenQuery</b></a><br>
  <a href="https://zenquery.app/?utm_source=github&utm_medium=referral&utm_campaign=awesome-mac">Instant Q/A on your data files (CSV, JSON, Excel, Parquet)</a>
  
  <br><br>
</div>
<hr>

编辑器插件
===
<!--rehype:style=font-size: 38px; border-bottom: 0; display: flex; min-height: 260px; align-items: center; justify-content: center;--> 

[![jaywcjlove/sb](https://jaywcjlove.github.io/sb/ico/awesome.svg)](https://github.com/jaywcjlove/awesome-mac) [![jaywcjlove/sb](https://jaywcjlove.github.io/sb/lang/english.svg)](editor-plugin.md) [![Gitter](https://jaywcjlove.github.io/sb/ico/gitter.svg)](https://gitter.im/awesome-mac/cn?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)
<!--rehype:style=text-align: center;--> 

## Atom Plugin

* 通用
  * [relative-numbers](https://atom.io/packages/relative-numbers) - 显示相对行号。
  * [trailing-spaces](https://atom.io/packages/trailing-spaces) - 高亮多余的空格。
  * [terminal-plus](https://atom.io/packages/terminal-plus) - 内嵌式全功能控制台。
  * [vim-mode-plus](https://atom.io/packages/vim-mode-plus) - Vim 模式。
  * [ex-mode](https://atom.io/packages/ex-mode) - Vim 模式的拓展。
  * [minimap](https://atom.io/packages/minimap) - 右侧小地图。
  * [autocomplete-paths](https://atom.io/packages/autocomplete-paths) - 对路径选择进行增强。
  * [docblockr](https://atom.io/packages/docblockr) - 编写注释好帮手。
  * [file-icons](https://atom.io/packages/file-icons) - 美化编辑器图标。
  * [atom-beautify](https://atom.io/packages/atom-beautify) - 自动美化代码格式。
  * [imdone-atom](https://atom.io/packages/imdone-atom) - 任务列表插件。
  * [open-terminal-here](https://atom.io/packages/open-terminal-here) - 在编辑器里快速打开终端。
  * [proton-mode](https://atom.io/packages/proton-mode) - 与 Spacemacs 相同的快捷键，非常棒。
  * [dracula-syntax](https://atom.io/packages/dracula-syntax) - Dracula 漂亮的配色。
  * [filecolor](https://atom.io/packages/filecolor) - 不同文件类型，不同颜色显示，方便查找文件。
  * [golden-ratio](https://atom.io/packages/golden-ratio) - 自动调整窗口大小。
  * [local-history](https://atom.io/packages/local-history) - 本地文件历史，可以返回任何时间保存的文件。
  * [project-plus](https://atom.io/packages/project-plus) - 项目管理，可以快速切换不同项目，多项目同时工作利器。
  * [regex-railroad-diagram](https://atom.io/packages/regex-railroad-diagram) - 可以图形化显示正则表达式。
  * [tree-view-search-bar](https://atom.io/packages/tree-view-search-bar/) - 文件列表快速查找工具。
* 前端
  * [Nuclide](http://nuclide.io) - 用于编写 React Native，代码提示各种很厉害的样子。[![Open-Source Software][OSS Icon]](https://github.com/facebook/nuclide)
  * [TypeScript](https://github.com/TypeStrong/atom-typescript) - 支持 TypeScript 编译。
  * [Emmet](https://atom.io/packages/emmet) - 快速编写 HTML。
  * [tag](https://atom.io/packages/tag) - Sublime 风格的 HTML 标签自动闭合。
  * [color-picker](https://atom.io/packages/color-picker) - CSS 颜色取色器。
  * [autoprefixer](https://atom.io/packages/autoprefixer) - 自动补全 CSS 前缀。
  * [linter-jshint](https://atom.io/packages/linter-jshint) - JavaScript 语法检查。
  * [pigments](https://atom.io/packages/pigments) - 把你文件中的颜色代码展示出来。
  * [atom-html-preview](https://atom.io/packages/atom-html-preview) - 内置 Chrome 浏览器写移动端非常棒。
  * [tree-view-copy-relative-path](https://atom.io/packages/tree-view-copy-relative-path) - 可以跟当前文件输出目标文件的相对路径，适合多文件相互调用。
* Python
  * [autocomplete-python](https://atom.io/packages/autocomplete-python) - 对 Python 提示进行增强。
  * [linter-flake8](https://atom.io/packages/linter-flake8) - Python 语法检查。
  * [python-tools](https://atom.io/packages/python-tools) - 一些有用的 Python 开发工具集。

## Sublime Text Plugin

* [PlainTasks](https://packagecontrol.io/packages/PlainTasks) - 一个自以为是的待办事项列表插件。
* [Emmet](https://github.com/sergeche/emmet-sublime) - Zen Coding 的升级版，对于前端来说，可是必备插件。
* [sublimelint](https://github.com/lunixbochs/sublimelint) - 用于代码的校验，支持 HTML、CSS、JS、PHP、Java、C++ 等 16 种语言。
* [JsFormat](https://packagecontrol.io/packages/JsFormat) - 用于 JavaScript 格式化。
* [jQuery](https://packagecontrol.io/packages/jQuery) - jQuery 语法提示。
* [Underscore](https://packagecontrol.io/packages/Underscore.js%20Snippets) - Underscore 语法提示。
* [DocBlockr](https://packagecontrol.io/packages/DocBlockr) - 快速编写注释。
* [SublimeCodeIntel](https://packagecontrol.io/packages/SublimeCodeIntel) - 智能语法分析提示。
* [ColorPicker](https://packagecontrol.io/packages/ColorPicker) - 快速选取颜色。
* [HTML-CSS-JS Prettify](https://packagecontrol.io/packages/HTML-CSS-JS%20Prettify) - HTML/CSS/JS 格式化。
* [Alignment](https://packagecontrol.io/packages/Alignment) - 用于代码对齐。
* [WakaTime](https://packagecontrol.io/packages/WakaTime) - 用于记录编程时间。
* [Seti_UI](https://packagecontrol.io/packages/Seti_UI) - 好看的主题，包括文件 icon。
* [OmniMarkupPreviewer](https://packagecontrol.io/packages/OmniMarkupPreviewer) - 实时预览 markdown、rst、creol、textile 等文件。
* [GitGutter](https://packagecontrol.io/packages/GitGutter) - 显示比对 Git 的状态。
* [BracketHighlighter](https://packagecontrol.io/packages/BracketHighlighter) - 高亮显示标签括号。
* [SideBarEnhancements](https://packagecontrol.io/packages/SideBarEnhancements) - 扩展文件编辑右键菜单。
* [Markdown Extended](https://packagecontrol.io/packages/Markdown%20Extended) -  Markdown 语法高亮。
* [Babel](https://packagecontrol.io/packages/Babel) - ES6 语法高亮。
* [AutoFileName](https://packagecontrol.io/packages/AutoFileName) - 自动完成文件名。
* [FTPSync](https://packagecontrol.io/packages/FTPSync) - FTP 同步插件，本地与虚拟机做文件同步非常方便。
* [Color Highlighter](https://packagecontrol.io/packages/Color%20Highlighter) - 高亮颜色关键字，非常适合 CSS 编写。
* [File History](https://packagecontrol.io/packages/File%20History) - 本地文件历史，每次修改文件都会有历史。
* [JavaScript Completions](https://packagecontrol.io/packages/JavaScript%20Completions) - 原生 JavaScript 补全。
* [Json Reindent](https://packagecontrol.io/packages/JSON%20Reindent) - JSON 格式化。
* [Git](https://packagecontrol.io/packages/Git) - Sublime Text Git 插件功能比较全面。
* [GitStatus](https://packagecontrol.io/packages/GitStatus) - 监控更改的文件和项目状态实时提示。
* [Gitignore](https://packagecontrol.io/packages/Gitignore) - Git的 .gitignore 文件生成，内置常用过滤文件。


## VSCode Plugin

* 通用

  * [vscode-icons](https://github.com/vscode-icons/vscode-icons) -  设置 VS Code 图标。
  * [Bracket Pair Colorizer](https://github.com/CoenraadS/Bracket-Pair-Colorizer-2) - 着色匹配括号。
  * [Indent-Rainbow](https://github.com/oderwat/vscode-indent-rainbow) - 对缩进显示彩虹色作色，使得更加易读。
  * [Trailing Spaces](https://github.com/shardulm94/vscode-trailingspaces) - 检测多余空格并高亮。
  * [TODO Highlight](https://github.com/wayou/vscode-todo-highlight) - TODO 备忘插件。
  * [Code Spell Checker](https://github.com/Jason-Rev/vscode-spell-checker) - JavaScript 或  TypeScript 代码拼写检查。
  * [Document This](https://github.com/joelday/vscode-docthis) - 自动生成 JavaScript 和 TypeScript 文档注释。
  * [Sublime Text Keymap](https://github.com/Microsoft/vscode-sublime-keybindings) - 在 VScode 中添加 Sublime Text 热门快捷键。
  * [Git Lens](https://github.com/eamodio/vscode-gitlens) - 增强了内置的 Visual Studio 代码 Git 功能。
  * [View In Browser](https://github.com/hellopao/view-in-browser) - 在 VScode 内预览浏览器。
  * [SVG Viewer](https://github.com/cssho/vscode-svgviewer) - 在 VScode 内查看 svg 图标。
  * [Auto-Open Markdown Preview](https://github.com/hnw/vscode-auto-open-markdown-preview) - 实时预览 Markdown。
  * [Markdown PDF](https://github.com/yzane/vscode-markdown-pdf) - 将 Markdown 文档转为 pdf、html、png 或 jpeg。
  * [ESlint](https://github.com/Microsoft/vscode-eslint) - VSCode ，帮助校验 ES 语法等。
  * [TSLint](https://github.com/Microsoft/vscode-eslint) - TSLint 在 VScode 工具，帮助校验 TS 语法等。
  * [Typora](https://marketplace.visualstudio.com/items?itemName=cweijan.vscode-typora) - 让你的VSCode拥有Typora级Markdown编辑体验。

* HTML
  * [Auto Close Tag](https://github.com/formulahendry/vscode-auto-close-tag) - 自动闭合标签。
  * [Auto Rename Tag](https://github.com/formulahendry/vscode-auto-rename-tag) - 自动重命名标签。
  * [HTML Snippets](https://marketplace.visualstudio.com/items?itemName=abusaidm.html-snippets) -   HTML 代码片段。
  * [IntelliSense for CSS class names in HTML](https://github.com/Zignd/HTML-CSS-Class-Completion) - 基于当前项目 CSS 文件，在html中智能提示CSS类名。
  * [HTML CSS Support](https://github.com/ecmel/vscode-html-css) - 在  HTML 中智能提示 CSS 样式。

* JS
  * [npm Intellisense](https://github.com/ChristianKohler/NpmIntellisense) - 自动提示 NPM 包的导入。
  * [Path Intellisense](https://github.com/ChristianKohler/PathIntellisense) - 自动提示文件路径。
  * [Auto Import](https://github.com/soates/Auto-Import) - 自动识别解析导入。
  * [Code Runner](https://github.com/formulahendry/vscode-code-runner) - 支持执行多语言测试代码。
  * [Import Cost](https://github.com/wix/import-cost) - 在编辑器中显示 import/require 包大小。
  * [Regex Previewer](https://github.com/chrmarti/vscode-regex) - 测试写的正则表达式。

* React/Vue
  * [react-beautify](https://github.com/taichi/react-beautify) - 这个扩展封保存自动美化 JS、JSX、TypeScript、TSX 文件。
  * [Reactjs code snippets](https://github.com/xabikos/vscode-react) - ES6 语法高亮，Reactjs 开发的代码提示。
  * [Vetur](https://github.com/vuejs/vetur) - Vue-VSCode 工具，支持高亮代码，自动补全，代码片段等。

## Vim Plugin

* [Vundle.vim](https://github.com/VundleVim/Vundle.vim) - Vim 插件管理工具。[![Open-Source Software][OSS Icon] ![Freeware][Freeware Icon]](https://github.com/VundleVim/Vundle.vim)
* [vim-plug](https://github.com/junegunn/vim-plug) - 一个简约的 Vim 插件管理器。[![Open-Source Software][OSS Icon] ![Freeware][Freeware Icon]](https://github.com/junegunn/vim-plug)
* [WebVim](https://github.com/krampstudio/webvim) - 倾向于开发 JavaScript 和 Web 的 Vim。
* [vim-web](https://github.com/jaywcjlove/vim-web) - 一个前端开发工程师的 Vim。[![Open-Source Software][OSS Icon] ![Freeware][Freeware Icon]](https://github.com/jaywcjlove/vim-web)
* [Neovim](https://neovim.io/) -  提高 Vim 可扩张灵活性。[![Open-Source Software][OSS Icon]](https://github.com/neovim/neovim) ![Freeware][Freeware Icon]
* [Spacevim](https://github.com/ctjhoa/spacevim) -  模仿 Spacemacs 的使用方式。
* [Spf13](http://vim.spf13.com/) - 一套全方位的配置项目。
* [vimplus](https://github.com/chxuan/vimplus) - 一套完全自动化打造 Vim 开发环境的项目。[![Open-Source Software][OSS Icon] ![Freeware][Freeware Icon]](https://github.com/chxuan/vimplus)
* [ivim](https://github.com/kepbod/ivim) - 一套简单易用，高可定制化 Vim 配置方案。
* [7th-vim](https://github.com/dofy/7th-vim) - 轻量级，可定制化的 Vim 配置方案。

[OSS Icon]: https://jaywcjlove.github.io/sb/ico/min-oss.svg
[Freeware Icon]: https://jaywcjlove.github.io/sb/ico/min-free.svg
[app-store Icon]: https://jaywcjlove.github.io/sb/ico/min-app-store.svg


<!--idoc:config:
title: Editors Plugin 分享推荐 -
description: Editors Plugin 分享推荐 - Awesome Mac
-->
