<div align="center" markdown="1">
  <sup>Special thanks to:</sup>
  <br>
  <br>
  <a href="https://www.warp.dev/awesome-mac">
    <img alt="Warp sponsorship" width="400" src="https://jaywcjlove.github.io/sponsor/warp-banner.png">
  </a>
  <br>
  <a href="https://warp.dev/awesome-mac"><b>Warp, the intelligent terminal for developers!</b></a><br>
  <a href="https://warp.dev/awesome-mac">Available for MacOS, Linux, & Windows</a><br><br>

  <a href="https://zenquery.app/?utm_source=github&utm_medium=referral&utm_campaign=awesome-mac">
    <img alt="Zenquery sponsorship" width="400" src="https://jaywcjlove.github.io/sponsor/zenquery.png">
  </a>
  <br>
  <a href="https://zenquery.app/?utm_source=github&utm_medium=referral&utm_campaign=awesome-mac"><b>ZenQuery</b></a><br>
  <a href="https://zenquery.app/?utm_source=github&utm_medium=referral&utm_campaign=awesome-mac">Instant Q/A on your data files (CSV, JSON, Excel, Parquet)</a>
  
  <br><br>
</div>
<hr>

Editors Plugin
===
<!--rehype:style=font-size: 38px; border-bottom: 0; display: flex; min-height: 260px; align-items: center; justify-content: center;-->

[![jaywcjlove/sb](https://jaywcjlove.github.io/sb/ico/awesome.svg)](https://github.com/jaywcjlove/awesome-mac) [![jaywcjlove/sb](https://jaywcjlove.github.io/sb/lang/chinese.svg)](editor-plugin-zh.md) [![Gitter](https://jaywcjlove.github.io/sb/ico/gitter.svg)](https://gitter.im/awesome-mac/en?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)
<!--rehype:style=text-align: center;-->

## Sublime Text Plugin

* [PlainTasks](https://packagecontrol.io/packages/PlainTasks) - An opinionated todo-list plugin.
* [sublimelint](https://github.com/lunixbochs/sublimelint) - A framework for error highlighting. Support AppleScript, C, C++, CSS, CoffeeScript, Go, HAML, HTML, Java, JavaScript, Lua, NASM, PHP, Perl, Python, Puppet, Ruby, XML.
* [jQuery](https://packagecontrol.io/packages/jQuery) - Sublime Text package bundle for jQuery.
* [Underscore](https://packagecontrol.io/packages/Underscore.js%20Snippets) - Underscore 1.4 snippets for Sublime Text 2.
* [DocBlockr](https://packagecontrol.io/packages/DocBlockr) - Simplifies writing DocBlock comments in Javascript, PHP, CoffeeScript, ActionScript, C & C++.
* [SublimeCodeIntel](https://packagecontrol.io/packages/SublimeCodeIntel) - Full-featured code intelligence and smart autocomplete engine.
* [ColorPicker](https://packagecontrol.io/packages/ColorPicker) - A multi-platform color picker plugin.
* [HTML-CSS-JS Prettify](https://packagecontrol.io/packages/HTML-CSS-JS%20Prettify) - HTML, CSS, JavaScript and JSON code formatter for Sublime Text 2 and 3 via `node.js`.
* [WakaTime](https://packagecontrol.io/packages/WakaTime) - A plugin for metrics, insights, and time tracking automatically generated from your programming activity.
* [Seti_UI](https://packagecontrol.io/packages/Seti_UI) - A beautiful theme, including file icons.
* [OmniMarkupPreviewer](https://packagecontrol.io/packages/OmniMarkupPreviewer) - Live previewer/exporter for markup files (markdown, rst, creole, textile...).
* [BracketHighlighter](https://packagecontrol.io/packages/BracketHighlighter) - Bracket and tag highlighter.
* [Markdown Extended](https://packagecontrol.io/packages/Markdown%20Extended) - Markdown syntax highlighter.
* [Babel](https://packagecontrol.io/packages/Babel) - Syntax definitions for ES6 JavaScript with React JSX extensions.
* [AutoFileName](https://packagecontrol.io/packages/AutoFileName) - Automatically complete the file name。
* [FTPSync](https://packagecontrol.io/packages/FTPSync) - FTP sync plug-in, local file synchronization with the virtual machine is very convenient。
* [Color Highlighter](https://packagecontrol.io/packages/Color%20Highlighter) - Highlight color key word, very suitable for CSS code。
* [File History](https://packagecontrol.io/packages/File%20History) - Local file history, every time modify the file will be history。
* [JavaScript Completions](https://packagecontrol.io/packages/JavaScript%20Completions) - Native Javascript completion。
* [JSON Reindent](https://packagecontrol.io/packages/JSON%20Reindent) - JSON formatting。
* [Git](https://packagecontrol.io/packages/Git) - Comprehensive Sublime does Text Git plug-in function。
* [GitStatus](https://packagecontrol.io/packages/GitStatus) - Monitoring changes of files and project status in real time。
* [Gitignore](https://packagecontrol.io/packages/Gitignore) - The Git Gitignore files are generated, commonly used built-in filter file。


## VSCode Plugin

* Common

  * [Auto-Open Markdown Preview](https://github.com/hnw/vscode-auto-open-markdown-preview) - Opening Markdown-preview automatically when opening a Markdown file
  * [Bracket Pair Colorizer](https://github.com/CoenraadS/Bracket-Pair-Colorizer-2) - Bracket Colorizer Extension for VSCode
  * [Code Spell Checker](https://github.com/Jason-Rev/vscode-spell-checker) - A simple source code spell checker for typescript and javascript
  * [Debugger for Chrome](https://github.com/Microsoft/vscode-chrome-debug) - Debug your JavaScript code in the Google Chrome browser.
  * [Document This](https://github.com/joelday/vscode-docthis) - JSDoc generator extension for Visual Studio Code
  * [ESlint](https://github.com/Microsoft/vscode-eslint) - Integrate eslint into VSCode.
  * [Git Lens](https://github.com/eamodio/vscode-gitlens) - Supercharge the Git capabilities built into Visual Studio Code
  * [Indent-Rainbow](https://github.com/oderwat/vscode-indent-rainbow) - Shows indentation with a faint rainbow colored background to make them more readable
  * [Markdown PDF](https://github.com/yzane/vscode-markdown-pdf) - Convert Markdown file to pdf, html, png or jpeg file.
  * [Sublime Text Keymap](https://github.com/Microsoft/vscode-sublime-keybindings) - Popular Sublime Text keybindings for VS Code.
  * [SVG Viewer](https://github.com/cssho/vscode-svgviewer) - SVG Viewer for Visual Studio
  * [TODO Highlight](https://github.com/wayou/vscode-todo-highlight) - Highlighting todos, fixmes, and any annotations
  * [Trailing Spaces](https://github.com/shardulm94/vscode-trailingspaces) - Allows you to highlight trailing spaces and delete them in a flash
  * [TSLint](https://github.com/microsoft/vscode-tslint) - Integrate tslint into VSCode.
  * [Typora](https://marketplace.visualstudio.com/items?itemName=cweijan.vscode-typora) - Provides a Typora-like Markdown editing experience in VSCode.
  * [View In Browser](https://github.com/hellopao/view-in-browser) - View a html file in system's default browser
  * [vscode-icons](https://github.com/vscode-icons/vscode-icons) - Icons for Visual Studio

* HTML
  * [Auto Close Tag](https://github.com/formulahendry/vscode-auto-close-tag) - Auto Close Tag
  * [Auto Rename Tag](https://github.com/formulahendry/vscode-auto-rename-tag) - Automatically rename paired HTML/XML tag
  * [HTML Snippets](https://marketplace.visualstudio.com/items?itemName=abusaidm.html-snippets) - Html snippets
  * [IntelliSense for CSS class names in HTML](https://github.com/Zignd/HTML-CSS-Class-Completion) - Provides CSS class name completion for the HTML class attribute based on the CSS files in your workspace
  * [HTML CSS Support](https://github.com/ecmel/vscode-html-css) - CSS support for HTML documents

* JS
  * [Auto Import](https://github.com/soates/Auto-Import) - Automatically finds, parses and provides code actions for all available imports.
  * [Code Runner](https://github.com/formulahendry/vscode-code-runner) - Run code snippet or code file for multiple languages.
  * [Import Cost](https://github.com/wix/import-cost) - Display import/require package size in the editor.
  * [npm Intellisense](https://github.com/ChristianKohler/NpmIntellisense) - Autocompletes npm modules in import statements.
  * [Path Intellisense](https://github.com/ChristianKohler/PathIntellisense) - Autocompletes filenames.
  * [Regex Previewer](https://github.com/chrmarti/vscode-regex) - Test regex and preview.

* React/Vue
  * [react-beautify](https://github.com/taichi/react-beautify) -  This extension wraps prettydiff/esformatter to format your javascript, JSX, typescript, TSX file.
  * [Reactjs code snippets](https://github.com/xabikos/vscode-react) - Code snippets for Reactjs development in ES6 syntax.
  * [Vetur](https://github.com/vuejs/vetur) - Vue tooling for VS Code，support Syntax-highlighting，Auto Completion，Snippet...

## Vim Plugin

* [WebVim](https://github.com/krampstudio/webvim) - Vim-based distribution targeting JavaScript and Web development
* [Neovim](https://neovim.io/) - Vim-fork focused on extensibility and agility. [![Open-Source Software][OSS Icon]](https://github.com/neovim/neovim) ![Freeware][Freeware Icon]
* [ivim](https://github.com/kepbod/ivim) - An easy & highly customizable vim configuration.
* [7th-vim](https://github.com/dofy/7th-vim) - Lightweight & Customizable Vim configuration options.

## Cross Platform Plugins

* [TabNine](https://tabnine.com) - Code autocompletion based on deep learning for all major IDEs / Text Editors for a variety of programming languages and syntax extensions (like JSX)

[OSS Icon]: https://jaywcjlove.github.io/sb/ico/min-oss.svg
[Freeware Icon]: https://jaywcjlove.github.io/sb/ico/min-free.svg
[app-store Icon]: https://jaywcjlove.github.io/sb/ico/min-app-store.svg

<!--idoc:config:
title: Editors Plugin Sharing Recommendation -
description: Editors Plugin Sharing Recommendation - Awesome Mac
-->