###############################################################################
#
# Tests for XlsxWriter.
#
# SPDX-License-Identifier: BSD-2-Clause
#
# Copyright (c), 2013-2025, John McNamara, jmcnamara@cpan.org
#

from xlsxwriter.workbook import Workbook

from ..excel_comparison_test import ExcelComparisonTest


class TestCompareXLSXFiles(ExcelComparisonTest):
    """
    Test file created by XlsxWriter against a file created by Excel.

    """

    def setUp(self):
        self.set_filename("default_format15.xlsx")

    def test_create_file(self):
        """Test the creation of a file with user defined default format"""

        workbook = Workbook(
            self.got_filename,
            {
                "default_format_properties": {"font_name": "Arial", "font_size": 10},
                "default_row_height": 17,
                "default_column_width": 64,
            },
        )

        worksheet = workbook.add_worksheet()

        worksheet.write(0, 0, "https://www.cpan.org/")

        workbook.close()

        self.assertExcelEqual()

    def test_create_file_with_character_units(self):
        """Test the creation of a file with user defined default format"""

        # Same as
        workbook = Workbook(
            self.got_filename,
            {
                "default_format_properties": {"font_name": "Arial", "font_size": 10},
                "default_row_height": 17,
                "default_column_width": 64,
            },
        )

        worksheet = workbook.add_worksheet()

        worksheet.write(0, 0, "https://www.cpan.org/")

        workbook.close()

        self.assertExcelEqual()
