<br/>
<br/>
<br/>

<p align="center">
    <img alt="awesome" src="arn.svg" width="480" />
</p><br/>
<br/>
<br/>
Awesome React Native is an awesome style list that curates the best React Native libraries,
tools, tutorials, articles and more. PRs are welcome!

<br/>
<br/>

<p align="center">
<a href="https://bit.ly/arn-wkly">Don't miss out! Subscribe to our weekly newsletter</a>
</p>
<br/>
<br/>

<img
src="https://travis-ci.org/jondot/awesome-react-native.svg?branch=master"
alt="Build Status" />



## Sponsors

### _Never leave your command line for secrets_

<a href="https://github.com/spectralops/teller"><img src="https://github.com/SpectralOps/teller/raw/master/media/cover.png"/></a>

_Teller is an OSS and FREE productivity secret manager for developers made by [SpectralOps](https://github.com/spectralops/teller), supporting cloud-native apps and multiple cloud providers. Mix and match all vaults and other key stores and safely use secrets as you code, test, and build applications. It's quick, easy, and safe._

[Get Started Now!](https://github.com/spectralops/teller)




# Categories

<!-- START doctoc generated TOC please keep comment here to allow auto update -->

<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
- [Buzzing](#buzzing)
  - [Instabug](#instabug)
- [Categories](#categories)
  - [Conferences](#conferences)
    - [Chain React - Portland, OR USA](#chain-react---portland-or-usa)
    - [React Native EU - Wroclaw, Poland](#react-native-eu---wroclaw-poland)
    - [React Alicante - Alicante, Spain](#react-alicante---alicante-spain)
    - [ReactNext - Tel Aviv, Israel](#reactnext---tel-aviv-israel)
    - [React Berlin - Berlin, Germany](#react-berlin---berlin-germany)
    - [App.js Conf - Krakow, Poland](#appjs-conf---krakow-poland)
    - [Chain React - Portland, OR USA](#chain-react---portland-or-usa-1)
    - [React Native EU - Wroclaw, Poland](#react-native-eu---wroclaw-poland-1)
    - [React Berlin - Berlin, Germany](#react-berlin---berlin-germany-1)
    - [ReactEurope - Paris, France](#reacteurope---paris-france)
  - [Articles](#articles)
    - [Reference](#reference)
    - [Howtos](#howtos)
    - [Assorted](#assorted)
    - [Continuous Integration](#continuous-integration)
    - [Internals](#internals)
  - [Components](#components)
    - [UI](#ui)
    - [Navigation](#navigation)
      - [Navigation/Routing Articles](#navigationrouting-articles)
      - [Navigation Demos](#navigation-demos)
    - [Deep Linking](#deep-linking)
    - [Text & Rich Content](#text--rich-content)
    - [Analytics](#analytics)
    - [Utils & Infra](#utils--infra)
    - [Forms](#forms)
    - [Geolocation](#geolocation)
    - [Internationalization](#internationalization)
    - [Build & Development](#build--development)
    - [Styling](#styling)
    - [System](#system)
    - [Web](#web)
    - [Media](#media)
    - [Storage](#storage)
    - [Backend](#backend)
    - [Integrations](#integrations)
    - [Monetization](#monetization)
    - [Animation](#animation)
    - [Extension](#extension)
    - [Other Platforms](#other-platforms)
  - [Utilities](#utilities)
  - [Seeds](#seeds)
  - [Libraries](#libraries)
  - [Open Source Apps](#open-source-apps)
  - [Frameworks](#frameworks)
  - [Tutorials](#tutorials)
  - [Books](#books)
  - [Videos](#videos)
    - [Talks](#talks)
    - [Training & tutorials](#training--tutorials)
  - [Blogs](#blogs)
  - [Newsletters](#newsletters)
  - [Releases](#releases)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

Many thanks to everyone on the [contributor
list](https://github.com/jondot/awesome-react-native/graphs/contributors)\\:)

## Conferences

Conferences dedicated to React Native specifically. A listing of React
general conferences can be found on the [ReactJS
site](https://facebook.github.io/react/docs/conferences.html).

### Chain React - Portland, OR USA

<http://chainreactconf.com>

Workshops - July 11th, 2018\\
Conference - July 12-13th, 2018

### React Native EU - Wroclaw, Poland

<http://react-native.eu/>

Workshops - September 3-4th, 2018\\
Conference - September 5-6th, 2018

### React Alicante - Alicante, Spain

<http://reactalicante.es/>

Workshops - September 13th, 2018\\
Conference - September 14-15th, 2018

### ReactNext - Tel Aviv, Israel

<https://react-next.com/>

Conference - November 4th, 2018

### App.js Conf - Krakow, Poland

<https://appjs.co/>

Conference - April 4th, 2019
Workshops - April 5th, 2019

### Chain React - Portland, OR USA

<https://infinite.red/ChainReactConf>

Workshops - July 10th, 2019
Conference - July 11th-12th, 2019

### React Native EU - Wroclaw, Poland

<https://react-native.eu/>

Workshops - September 4th, 2019
Conference - September 5th-6th, 2019

### React Berlin - Berlin, Germany

<https://reactday.berlin/>

Workshops - December 4th-5th, 2019
Conference - December 6th, 2019

### ReactEurope - Paris, France

<https://www.react-europe.org/>

Conference - May 14th-15, 2020
Workshops - May 12th-13th, 2020


## Articles

Content published on the Web.

### Reference

* [React Native Styling Cheatsheet ★2679](https://github.com/vhpoet/react-native-styling-cheat-sheet)

### Howtos

* [Add client-side indecent content checking to your React Native app using NSFWJS and TensorFlowJS](https://shift.infinite.red/nsfw-js-for-react-native-a37c9ba45fe9)
* [How to add Firebase Auth with React Native ★4](https://github.com/g6ling/React-Native-Tips/tree/master/How_to_add_Firebase_Auth_with_react_native)
* [How to get started with Cloud Firestore on React Native](https://invertase.io/blog/getting-started-with-cloud-firestore-on-react-native)
* [How to upgrade React Navigation 1.x to 2.x](https://shift.infinite.red/upgrading-from-react-navigation-v1-to-v2-312d932329ba)
* [How to use React Native Navigation v2 with Redux and Google Analytics](https://www.codingsavvy.com/2018/08/react-native-navigation-v2-with-redux.html)
* [React-Navigation Drawer](https://shift.infinite.red/react-navigation-drawer-tutorial-a802fc3ee6dc)
* [Getting Started with React Native Development on Windows](https://shift.infinite.red/getting-started-with-react-native-development-on-windows-90d85a72ae65#.lygadl38g)
* [Getting Started with React Native Development for Windows](https://shift.infinite.red/getting-started-with-react-native-development-for-windows-ba23a4be90b6#.n6vtqtikh)
* [Blueprint to becoming a React Native Developer](https://medium.com/@spencer_carli/blueprint-to-becoming-a-react-native-developer-6cad2b894887#.t3uw4j4u8)
* [How to Use the ListView Component](https://medium.com/@spencer_carli/react-native-basics-how-to-use-the-listview-component-a0ec44cf1fe8#.ur0hyi3h9)
* [How to upload photo/file in react-native](https://github.com/g6ling/React-Native-Tips/tree/master/How_to_upload_photo%2Cfile_in%20react-native)
* [Change splash screen in React Native Android app](https://android.jlelse.eu/change-splash-screen-in-react-native-android-app-d3f99ac1ebd1#.pgjimxpgg)
* [Remote Push Notifications with OneSignal](https://medium.com/differential/react-native-push-notifications-with-onesignal-9db6a7d75e1e#.d0zob0pdw)
* [Release React Native App to Android Play Store](https://shift.infinite.red/simple-react-native-android-releases-319dc5e29605)
* [React Native & Apple TV today](https://medium.com/@7ynk3r/react-native-apple-tv-today-48beb398a1ab#.5pp5drlyy)
* [Record and Upload Videos with React Native](https://medium.com/react-native-training/uploading-videos-from-react-native-c79f520b9ae1)
* [How to Setup your First React Native app](https://hackernoon.com/react-native-how-to-setup-your-first-app-a36c450a8a2f)
* [Using React Native With TypeScript](https://medium.com/@jan.hesters/using-typescript-with-react-native-946aa4b4ae6f)
* [How To Build a News Reader App with React Native and NewsAPI](https://medium.com/crowdbotics/how-to-build-a-news-reader-app-with-react-native-and-newsapi-8508f48f2b43)
* [How to Build a Real Time Logo Detection App with React Native](https://medium.com/crowdbotics/how-to-build-a-real-time-logo-detection-app-with-react-native-google-vision-api-and-crowdbotics-9ed65fbcd15)
* [Build a Chatbot with Dialogflow and React Native](https://blog.jscrambler.com/build-a-chatbot-with-dialogflow-and-react-native/)
* [How To Build Your First VR App with ViroReact and React Native](https://medium.com/crowdbotics/how-to-build-your-first-vr-app-with-viroreact-react-native-and-crowdboticsp-a376b49e1e1d)
* [React Hooks Basics— Building a React Native App with React Hooks](https://medium.com/crowdbotics/build-a-react-native-app-with-react-hooks-5498e1d5fdf6)
* [How to Build a Web App with React Native](https://heartbeat.fritz.ai/how-to-build-a-web-app-with-react-native-b93575a16a5e)
* [Building a React Native Mobile App with AWS Amplify and Expo](https://heartbeat.fritz.ai/building-a-react-native-mobile-app-with-aws-amplify-and-expo-fcab6ee0555e)
* [User Authentication with Amplify in a React Native and Expo app](https://heartbeat.fritz.ai/user-authentication-with-amplify-in-a-react-native-and-expo-app-d00cdaf1ac28)
* [How to build an Email Authentication app with Firebase, Firestore and React Native](https://heartbeat.fritz.ai/how-to-build-an-email-authentication-app-with-firebase-firestore-and-react-native-a18a8ba78574)
* [How to Gracefully Use Environment Variables in a React Native App](https://levelup.gitconnected.com/how-to-gracefully-use-environment-variables-in-a-react-native-app-7f1600446116)
* [How to build a xylophone app with Audio API, React Native, and Expo](https://heartbeat.fritz.ai/how-to-build-a-xylophone-app-with-audio-api-react-native-and-expo-7d6754a0603c)
* [How To Use WebViews in a React Native App](https://blog.jscrambler.com/how-to-use-webviews-in-a-react-native-app/)

### Assorted

* [React Native Twitter Clone](https://www.cosmicjs.com/apps/react-native-twitter-clone) - React Native Twitter Clone powered by the Cosmic Headless CMS. [Read about how it was built](https://www.cosmicjs.com/blog/how-to-make-a-simple-twitter-clone-with-react-native).
* [Versioning React Native Application in elegant way (cross-platformely) ★10](https://github.com/szhigunov/react-native-npm-version)
* [Best Practices for Building a Large Scale React Application](https://buttercms.com/blog/best-practices-for-building-a-large-scale-react-application)
* [React Native - Nic or Not App](https://shift.infinite.red/cage-against-the-machine-a419b6980424)
* [React and React Native State Museum](https://hackernoon.com/the-react-state-museum-a278c726315)
* [Top 15 React Native libraries that I use in my apps](https://codingislove.com/top-15-react-native-libraries/)
* [Building 3 React Native Apps in One Summer](https://medium.com/@rpastorelle/building-3-react-native-apps-in-one-summer-dcd0c31454ff)
* [React Native: Bringing modern web techniques to mobile](https://code.facebook.com/posts/1014532261909640/react-native-bringing-modern-web-techniques-to-mobile/)
* [First impressions using React Native](http://jlongster.com/First-Impressions-using-React-Native)
* [Wrapping Cocoapods for React Native](https://shift.infinite.red/beginner-s-guide-to-using-cocoapods-with-react-native-46cb4d372995#.wzp2qq1hn)
* [React Native: Initial Thoughts (opinion)](https://redalemeden.com/blog/2015/initial-thoughts-about-react-native)
* [A Dynamic Crazy Native Mobile Future Powered by Javascript](https://medium.com/@clayallsopp/a-dynamic-crazy-native-mobile-future-powered-by-javascript-70f2d56b1987)
* [ReactNative NES & More](https://moduscreate.com/blog/react-native-has-landed/)
* [React Native Installation and Setup](https://github.com/checkraiser/beginning-react-native/blob/master/1.Installation_and_setup.md)
* [Diary of Building an iOS App with React Native](http://herman.asia/building-a-flashcard-app-with-react-native)
* [Reflecting on React Native development](http://habd.as/reflecting-on-react-native-development/)
* [React-Native layout examples](http://browniefed.com/blog/2015/06/07/react-native-layout-examples/)
* [React Native in Production](https://medium.com/@clayallsopp/react-native-in-production-2b3c6e6078ad) - notes from Clay Allsop
* [An iOS Developer on React Native](https://medium.com/ios-os-x-development/an-ios-developer-on-react-native-1f24786c29f0)
* [React Native and WebRTC](https://webrtchacks.com/reacting-to-react-native-for-native-webrtc-apps-alexey-aylarov/)
* [How to bridge a Swift view](http://browniefed.com/blog/2015/11/28/react-native-how-to-bridge-a-swift-view/)
* [How to select the right React Native database](https://www.simform.com/react-native-database-selection-guide/)
* [Building a Native SoundCloud Android app with Redux](https://wiredcraft.com/blog/native-soundcloud-android-app/) - discussing redux, code reuse and performance on Android.
* [React Native Twitter exploding heart](http://browniefed.com/blog/2015/11/07/react-native-how-to-create-twitter-exploding-hearts/) - hardcore animations with Animation and ReactART
* [Using AI to discover UI components](https://www.youtube.com/watch?v=_iiKl0BB6ho) - fun image processing / AI assisted process to discover and generate React Native UI
* [Writing Android Components](https://medium.com/@sejoker/writing-android-component-for-react-native-e34802bf3377)
* [Unit Testing React Native with Mocha and Enzyme](https://formidable.com/blog/2016/02/08/unit-testing-react-native-with-mocha-and-enzyme/)
* [React Native's Layout Animation is Awesome](https://medium.com/@Jpoliachik/react-native-s-layoutanimation-is-awesome-4a4d317afd3e)
* [Avoiding the Keyboard](https://shift.infinite.red/avoiding-the-keyboard-in-react-native-56d05b9a1e81#.g1lwixck6)
* [How To Use OpenCV In React Native For Image Processing](https://brainhub.eu/blog/opencv-react-native-image-processing/)
* [Using Styled Components with React Native](https://medium.com/swlh/using-styled-components-with-react-native-de645fcf4787)
* [Create a React Native Image Recognition App with Google Vision API](https://blog.jscrambler.com/create-a-react-native-image-recognition-app-with-google-vision-api/)
* [A comprehensive guide on building offline React Native apps with AsyncStorage](https://heartbeat.fritz.ai/building-offline-react-native-apps-with-asyncstorage-dcb4b0657f93)
* [Build a Chat App with Firebase and React Native](https://blog.jscrambler.com/build-a-chat-app-with-firebase-and-react-native/)
* [Building Stylistic UIs with Emotion-JS for React Native](https://heartbeat.fritz.ai/how-to-use-emotion-js-with-react-native-fccac9c78779)
* [Getting Started with Firestore and React Native](https://blog.jscrambler.com/getting-started-with-firestore-and-react-native/)
* [React Native: Native Modules made for React developers](https://blog.photoeditorsdk.com/react-native-native-modules-made-for-react-developers-59ca93c41541) - on the developer experience with 3rd-party libraries for RN 0.60+
* [Flutter vs React Native - Choosing your approach](https://buttercms.com/blog/flutter-vs-react-native-choosing-your-approach) - Comparison article to help you choose the best approach depending on your project and experience.

### Continuous Integration

* [How to build and deploy React Native apps for iOS and Android automatically with Appcircle CI/CD](https://appcircle.io/blog/guide-to-automated-mobile-ci-cd-for-react-native-appcircle/)
* [Distributing beta builds with Fastlane on Android and iOS](https://github.com/thecodingmachine/react-native-boilerplate/blob/master/docs/beta%20builds.md)
* [Deploying a React Native App with Fastlane](https://dbanck.svbtle.com/deploying-a-react-native-app-with-fastlane)
* [Continuous Integration for React Native Apps With Fastlane and Bitrise (iOS)](http://blog.thebakery.io/continuous-integration-for-react-native-applications-with-fastlane-and-bitrise-ios-version/)
* [How to automate Android build process on Bitrise CI](https://medium.com/@hesam.kamalan/how-to-automate-android-build-process-on-bitrise-ci-71ae3a94362e#.fryuiays4)
* [fastlane for React Native iOS & Android app DevOps](https://medium.com/react-native-training/fastlane-for-react-native-ios-android-app-devops-8ca85bee614e)
* [The simplest way to automate delivery of your React Native Application](https://jtway.co/the-simplest-way-to-automate-delivery-of-your-react-native-application-f37f2c71eb1d)
* [21 Useful Open Source Packages for React Native](https://medium.com/crowdbotics/21-useful-open-source-packages-for-react-native-807f65a818a1)

### Internals

* [Performance](https://facebook.github.io/react-native/docs/performance.html#common-sources-of-performance-problems)
* [React Native Debugger Internals](https://medium.com/@shaheenghiassy/deep-diving-react-native-debugging-ea406ed3a691)
* [Dirty-up and execute top-down](http://blog.vjeux.com/2015/javascript/dirty-up-and-execute-top-down.html) - @vjeux on React's optimizations for background color, layout, and more
* [Optimizing React Native](https://www.youtube.com/watch?v=0MlT74erp60)
* [Diving into React Native Performance](https://code.facebook.com/posts/895897210527114/)
* [Wait… What Happens When my React Native Application Starts? — An In-depth Look Inside React Native](https://levelup.gitconnected.com/wait-what-happens-when-my-react-native-application-starts-an-in-depth-look-inside-react-native-5f306ef3250f)

## Components

Components and native modules.

### UI

* [lottie-react-native ★10415](https://github.com/airbnb/lottie-react-native) - A mobile library for Android and iOS that parses Adobe After Effects animations exported as JSON with bodymovin and renders them natively on mobile!
* [react-icomoon](https://github.com/aykutkardas/react-icomoon) - With React-Icomoon you can easily use the icons you have selected or created in icomoon. 📦 Zero Dependencies and Lightweight. 
* [react-native-vector-icons ★9985](https://github.com/oblador/react-native-vector-icons) - Customizable Icons for React Native with support for NavBar/TabBar, image source and full styling. Choose from 3000+ bundled icons or use your own.
* [react-native-maps ★8388](https://github.com/lelandrichardson/react-native-maps) - React Native Map components for iOS + Android
* [react-native-swiper ★6955](https://github.com/leecade/react-native-swiper) - The best Swiper component for React Native.
* [react-native-gifted-chat ★6546](https://github.com/FaridSafi/react-native-gifted-chat) - The most complete chat UI for React Native (formerly known as Gifted Messenger)
* [react-native-scrollable-tab-view ★5664](https://github.com/brentvatne/react-native-scrollable-tab-view) - A scrollable tab-view for React Native
* [react-native-image-picker ★4709](https://github.com/marcshilling/react-native-image-picker) - A React Native module that allows you to use the native UIImagePickerController UI to select a photo from the device library or directly from the camera.
* [react-native-material-kit ★4124](https://github.com/xinthink/react-native-material-kit) - Bringing Material Design to React Native
* [react-native-snap-carousel ★3959](https://github.com/archriss/react-native-snap-carousel) - Swiper component for React Native with previews, multiple layouts, parallax images, performant handling of huge numbers of items, and RTL support
* [react-native-calendars ★3402](https://github.com/wix/react-native-calendars) - React Native Calendar Components 📆
* [react-native-ui-kitten ★3140](https://github.com/akveo/react-native-ui-kitten) - Customizable and reusable react-native component kit
* [react-native-svg ★2982](https://github.com/magicismight/react-native-svg) - SVG library that works on both iOS & Android
* [react-native-image-crop-picker ★2736](https://github.com/ivpusic/react-native-image-crop-picker) - iOS/Android image picker with support for multiple images and cropping
* [react-native-splash-screen ★2663](https://github.com/crazycodeboy/react-native-splash-screen) - A splash screen for react-native, hide when application loaded, it works on iOS and Android.
* [react-native-material-ui ★2536](https://github.com/xotahal/react-native-material-ui) - Highly customizable material design components for React Native
* [react-native-app-intro ★2433](https://github.com/FuYaoDe/react-native-app-intro) - A React Native parallax effect app intro
* [react-native-drawer ★2276](https://github.com/root-two/react-native-drawer) - React Native Drawer
* [react-native-typography ★2260](https://github.com/hectahertz/react-native-typography) Pixel–perfect, native–looking typographic styles for React Native
* [react-native-fast-image ★2240](https://github.com/DylanVann/react-native-fast-image) - FastImage, performant React Native image component.
* [react-native-blurhash ★105](https://github.com/mrousavy/react-native-blurhash) - Give your users the loading experience they want.
* [react-native-paper ★2218](https://github.com/callstack/react-native-paper) - Material design for React Native
* [react-native-swipeout ★2194](https://github.com/dancormier/react-native-swipeout) - iOS-style swipeout buttons behind component
* [react-native-blur ★2172](https://github.com/Kureev/react-native-blur) - React Native Blur component
* [react-native-progress ★2069](https://github.com/oblador/react-native-progress) - Progress indicators and spinners for React Native using ReactART.
* [react-native-textinput-effects ★2062](https://github.com/halilb/react-native-textinput-effects) - Text inputs with custom label and icon animations for iOS and Android. Built by react native and inspired by Codrops.
* [react-native-modalbox ★2043](https://github.com/maxs15/react-native-modalbox) - A component for react-native
* [react-native-lightbox ★1917](https://github.com/oblador/react-native-lightbox) - A very Slick and modern mobile lightbox implementation
* [react-native-action-button ★1762](https://github.com/mastermoo/react-native-action-button) - A customizable Float Button Component for React Native
* [gl-react-native ★1750](https://github.com/ProjectSeptemberInc/gl-react-native) - Use OpenGL for performant effects on images and videos
* [react-native-modal ★1728](https://github.com/react-native-community/react-native-modal) - An enhanced, animated and customizable react-native modal
* [nachos-ui ★1684](https://github.com/avocode/nachos-ui) - NACHOS UI kit for React Native. Pick from a bunch of pre-coded UI components ready for your next kick-ass app in JavaScript or React.
* [react-native-mapbox-gl ★1663](https://github.com/mapbox/react-native-mapbox-gl) - A Mapbox GL react native module for creating custom maps
* [react-native-foldview ★1616](https://github.com/jmurzy/react-native-foldview) - Animated FoldingCell implementation in React Native
* [react-native-modern-datepicker ★12](https://github.com/HosseinShabani/react-native-modern-datepicker) - React Native Modern Datepicker
* [react-native-spinkit ★1585](https://github.com/maxs15/react-native-spinkit) - A collection of animated loading indicators for React Native
* [react-native-recyclerlist ★1515](https://github.com/Flipkart/recyclerlistview) - High performance listview for React Native and Web with support for complex layouts.
* [react-native-parallax-scroll-view ★1486](https://github.com/jaysoo/react-native-parallax-scroll-view) - A ScrollView-like component with parallax and sticky header support.
* [react-native-chart ★1464](https://github.com/onefold/react-native-chart) - React-native-chart is a simple module for adding line charts, area charts, or bar charts to your React Native app.
* [react-native-gifted-listview ★1443](https://github.com/FaridSafi/react-native-gifted-listview) - A ListView that embed some recurrent features like pull-to-refresh, infinite scrolling and more for Android and iOS React-Native apps
* [react-native-datepicker ★1365](https://github.com/xgfe/react-native-datepicker) - React Native date, datetime and time picker for both Android and IOS
* [react-native-viewpager ★1350](https://github.com/race604/react-native-viewpager) - ViewPager component for React Native
* [react-virgin ★1319](https://github.com/Trixieapp/react-virgin) The react-native UI Kit you've been looking for.
* [react-native-easy-grid ★1304](https://github.com/GeekyAnts/react-native-easy-grid) - Easy Responsive Grid Layout for React Native.
* [victory-native ★1264](https://github.com/FormidableLabs/victory-native) - Victory-native is a collection of components to help you create charts, bar graphs etc.
* [react-native-picker ★1238](https://github.com/beefe/react-native-picker) - react-native-picker
* [react-native-collapsible ★1174](https://github.com/oblador/react-native-collapsible) - Animated collapsible component for React Native using the new Animated API with fallback. Good for accordions, toggles etc
* [react-native-icons ★1168](https://github.com/corymsmith/react-native-icons) - Quick and easy icons in React Native [video](https://www.youtube.com/watch?v=TEdM7IwTT1g#t=50)
* [react-native-orientation ★1162](https://github.com/yamill/react-native-orientation) - Listen to device orientation changes in react-native and set preferred orientation on screen to screen basis
* [react-native-tableview ★1105](https://github.com/aksonov/react-native-tableview) - Native iOS TableView wrapper for React Native
* [react-native-keyboard-spacer ★1103](https://github.com/Andr3wHur5t/react-native-keyboard-spacer) - Plug and play react-Native keyboard spacer view.
* [react-native-looped-carousel ★1094](https://github.com/appintheair/react-native-looped-carousel) - Create looped carousel of views or images
* [react-native-circular-progress ★1088](https://github.com/bgryszko/react-native-circular-progress) - React Native component for creating animated, circular progress with ReactART
* [react-native-popup-dialog ★1088](https://github.com/jacklam718/react-native-popup-dialog) - A React Native Popup Dialog Easy Use & Support Use Custom Animation. For IOS & Android
* [react-native-largelist ★1054](https://github.com/bolan9999/react-native-largelist) - The best performance large list component for React Native (iOS & Android)
* [react-native-offline ★977](https://github.com/rauliyohmc/react-native-offline) - Handy toolbelt to deal nicely with offline/online connectivity in a React Native app. Smooth redux integration.
* [react-native-root-toast ★971](https://github.com/magicismight/react-native-root-toast) - React native toast like component, pure javascript solution
* [react-native-dropdownalert ★894](https://github.com/testshallpass/react-native-dropdownalert) - A simple drop down alert with 4 pre-defined types.
* [react-native-loading-spinner-overlay ★885](https://github.com/niftylettuce/react-native-loading-spinner-overlay) - The only pure React Native, Native iOS and Android loading spinner (progress bar indicator) overlay
* [react-native-tinder-swipe-cards ★881](https://github.com/meteor-factory/react-native-tinder-swipe-cards) - Tinder card style swiping.
* [react-native-slider ★845](https://github.com/jeanregisser/react-native-slider) - A pure JavaScript component for react-native
* [react-native-pathjs-charts ★842](https://github.com/capitalone/react-native-pathjs-charts) - Android and iOS charts based on react-native-svg and paths-js
* [react-native-flash-message ★810](https://github.com/lucasferreira/react-native-flash-message#readme) - React Native flashbar and top notification alert utility
* [react-native-svg-charts ★764](https://github.com/JesperLekland/react-native-svg-charts) - One library to rule all charts for React Native
* [react-native-masonry ★758](https://github.com/brh55/react-native-masonry) - A masonry~ish layout for rendering images.
* [react-native-credit-card-input ★742](https://github.com/sbycrosz/react-native-credit-card-input) - 💳 💳 Easy (and good looking) credit-card input for your React Native Project
* [rn-placeholder ★1139](https://github.com/mfrachet/rn-placeholder) - Display some placeholder stuff before rendering your text or media content in React Native (+ React Native Web!)
* [action-sheet-rn ★1](https://github.com/mfrachet/action-sheet-rn) - Probably the most declarative API for ActionSheets in React Native
* [react-native-sglistview ★731](https://github.com/sghiassy/react-native-sglistview) - A memory minded implementation of React Native's ListView
* [react-native-modal-dropdown ★708](https://github.com/sohobloo/react-native-modal-dropdown) - A react-native dropdown/picker/selector component for both Android & iOS.
* [react-native-button ★707](https://github.com/ide/react-native-button)
* [react-native-bottom-sheet-behavior ★701](https://github.com/cesardeazevedo/react-native-bottom-sheet-behavior) - A react native wrapper for android BottomSheetBehavior.
* [react-native-tabs ★687](https://github.com/aksonov/react-native-tabs) - React Native platform-independent tabs. Could be used for bottom tab bars as well as sectioned views (with tab buttons)
* [react-native-search-bar ★671](https://github.com/umhan35/react-native-search-bar) - The native search bar for react native.
* [react-native-timeline-listview ★665](https://github.com/thegamenicorus/react-native-timeline-listview) - Timeline component for React Native App
* [react-native-toastboard](https://github.com/MAKARD/react-native-toastboard) - The simplest way to show notification.
* [apsl-react-native-button ★653](https://github.com/APSL/react-native-button) - React Native button component with rounded corners.
* [react-native-popup-menu ★653](https://github.com/instea/react-native-popup-menu) - Extensible popup menu component for React Native.
* [react-native-qrcode ★644](https://github.com/cssivision/react-native-qrcode) - react-native qrcode generator
* [react-native-easy-toast ★616](https://github.com/crazycodeboy/react-native-easy-toast) - A react native module to show toast like android, it works on iOS and Android.
* [react-router-native ★612](https://github.com/jmurzy/react-router-native) - A routing library for React Native that strives for sensible API parity with [React Router](https://github.com/reactjs/react-router)
* [react-native-copilot ★595](https://github.com/okgrow/react-native-copilot) - Step-by-step walkthrough for your react native app
* [react-native-photo-browser ★565](https://github.com/halilb/react-native-photo-browser) - Local and remote photo browser with captions, selections and grid view support.
* [react-native-calendar ★559](https://github.com/christopherdro/react-native-calendar) - Calendar Component for React Native
* [react-native-calendar-events ★510](https://github.com/wmcmahan/react-native-calendar-events)
* [react-native-parsed-text ★552](https://github.com/taskrabbit/react-native-parsed-text) - Parse text and make them into multiple React Native Text elements
* [react-native-step-indicator ★538](https://github.com/24ark/react-native-step-indicator) - A simple react-native implementation of step indicator widget compatible with the ViewPager and ListView.
* [react-native-popover-haobtc ★514](https://github.com/jeanregisser/react-native-popover) - A component for react-native
* [react-native-dropdown ★507](https://github.com/alinz/react-native-dropdown) - A better Select dropdown menu for react-native
* [react-native-star-rating ★489](https://github.com/djchie/react-native-star-rating) - A React Native component for generating and displaying interactive star ratings
* [react-native-rating-element ★8](https://github.com/ui-ninja/react-native-rating-element) - A react native rating system supporting: decimal point's rating, direction aware icons like bottom to top or right to left etc, custom icons from Ionicons, custom images and record rating given by users.
* [react-native-parallax ★479](https://github.com/oblador/react-native-parallax) - Parallax effects for React Native using Animated API
* [react-native-sketch ★467](https://github.com/jgrancher/react-native-sketch) - A react-native &lt;Sketch /> component to draw with touch events.
* [react-native-dialogs ★463](https://github.com/aakashns/react-native-dialogs) - React Native wrappers for <https://github.com/afollestad/material-dialogs>
* [galio ★458](https://github.com/galio-org/galio) - A fresh react native UI framework.
* [react-native-root-siblings ★452](https://github.com/magicismight/react-native-root-siblings) - Add sibling elements after your app root element.
* [react-native-size-matters ★436](https://github.com/nirsky/react-native-size-matters) - A React-Native utility belt for scaling the size your apps UI across different sized devices.
* [react-native-button-component ★434](https://github.com/jacklam718/react-native-button-component) - A Beautiful, Customizable React Native Button component for iOS & Android
* [react-native-super-grid ★434](https://github.com/saleel/react-native-super-grid) - Responsive Grid View for React Native.
* [react-native-activity-view ★427](https://github.com/naoufal/react-native-activity-view) - iOS share and action sheets for React Native
* [react-native-canvas ★421](https://github.com/lwansbrough/react-native-canvas) - A Canvas element for React Native
* [react-native-refresher ★419](https://github.com/syrusakbary/react-native-refresher) - A React Native pull to refresh ListView completely written in js. Also supports custom animations.
* [react-native-sortable-list ★412](https://github.com/gitim/react-native-sortable-list) A sortable list for react native with both vertical and horizontal direction support.
* [react-native-gesture-password ★410](https://github.com/spikef/react-native-gesture-password) - A gesture password component for React Native
* [react-native-carousel ★406](https://github.com/nick/react-native-carousel) - Simple carousel component for react-native
* [react-native-country-picker-modal ★403](https://github.com/xcarpentier/react-native-country-picker-modal) - Country picker provides a modal allowing a user to select a country from a list. It display a flag next to each country name.
* [react-native-radio-buttons ★399](https://github.com/ArnaudRinquin/react-native-radio-buttons) - A react component to implement custom radio buttons-like behaviors: multiple options, only on can be selected at once.
* [react-native-masked-text ★392](https://github.com/benhurott/react-native-masked-text) - A simple masked text and input text component for React Native.
* [react-native-accordion ★390](https://github.com/naoufal/react-native-accordion) - An Accordion Component for React Native
* [react-native-invertible-scroll-view ★388](https://github.com/exponentjs/react-native-invertible-scroll-view) - An invertible ScrollView for React Native
* [react-native-message-bar ★384](https://github.com/KBLNY/react-native-message-bar) - A module for presenting notifications via an animated message bar at the top/bottom of the screen, highly customizable, for React Native (Android and iOS) projects.
* [react-native-fit-image ★383](https://github.com/huiseoul/react-native-fit-image) - Responsive image component to fit perfectly itself.
* [react-native-text-input-mask ★383](https://github.com/ivanzotov/react-native-text-input-mask) - Text input mask for Android and iOS, native implementation RedMadRobot libraries
* [react-native-alphabetlistview ★372](https://github.com/sunnylqm/react-native-alphabetlistview) - A ListView with a sidebar to jump to sections directly, based on johanneslumpe's react-native-selectablesectionlistview
* [react-native-check-box ★372](https://github.com/crazycodeboy/react-native-check-box) - Checkbox component for react native, it works on iOS and Android.
* [react-native-really-awesome-button ★370](https://github.com/rcaferati/react-native-really-awesome-button) - RNRAB is a 3D at 60fps, progress enabled, extendable, production ready component that renders an awesome animated set of UI buttons.
* [react-native-autocomplete-input ★366](https://github.com/l-urence/react-native-autocomplete-input) - Pure javascript autocomplete input for react-native
* [react-native-splashscreen ★358](https://github.com/remobile/react-native-splashscreen) - A splash screen for react-native
* [react-native-responsive-image ★344](https://github.com/Dharmoslap/react-native-responsive-image) - Most elegant Responsive Image component
* [react-native-pdf-view ★338](https://github.com/cnjon/react-native-pdf-view) - View pdf file using react-native
* [react-native-image-header-scroll-view ★338](https://github.com/bamlab/react-native-image-header-scroll-view) - ScrollView with an image in header which become a navbar
* [react-native-toast ★336](https://github.com/remobile/react-native-toast) - An android like toast for react-native support for iOS and Android
* [react-native-modal-picker ★333](https://github.com/d-a-n/react-native-modal-picker) - A cross-platform (iOS / Android), selector/picker component for React Native that is highly customizable and supports sections.
* [react-native-off-canvas-menu ★327](https://github.com/shoumma/react-native-off-canvas-menu) - Beautifully crafted off canvas menu components for React native applications.
* [rn-sliding-up-panel ★321](https://github.com/octopitus/rn-sliding-up-panel) - React Native draggable sliding up panel purly implemented in Javascript. Works nicely on both iOS and Android.
* [react-native-search-box ★319](https://github.com/crabstudio/react-native-search-box) - A simple search box with animation, inspired from ios search bar.
* [react-native-parallax-swiper ★315](https://github.com/zachgibson/react-native-parallax-swiper) - Configurable parallax swiper based on an iOS pattern. Uses Native Driver for super smooth parallax.
* [react-native-gesture-recognizers ★313](https://github.com/johanneslumpe/react-native-gesture-recognizers) - Gesture recognizer decorators for react-native
* [react-native-searchbar ★313](https://github.com/localz/react-native-searchbar) - An animated search bar for react native with inbuilt search (iOS and Android)
* [react-native-app-auth ★310](https://github.com/FormidableLabs/react-native-app-auth) - React Native bridge for AppAuth - a PKCE-compliant SDK for communicating with OAuth2 providers
* [react-native-circular-action-menu ★305](https://github.com/geremih/react-native-circular-action-menu) - An animated and customizable circular floating menu.
* [react-native-effects-view ★304](https://github.com/voronianski/react-native-effects-view) - React Native Component that makes easy to use iOS8 UIVisualEffect
* [react-native-root-modal ★304](https://github.com/magicismight/react-native-root-modal) - React native modal component
* [react-native-timeago ★278](https://github.com/TylerLH/react-native-timeago) - Auto-updating timeago component for React Native
* [react-native-grid-view ★276](https://github.com/lucholaf/react-native-grid-view) - React Native Grid/Collection View component
* [react-native-md-textinput ★275](https://github.com/evblurbs/react-native-md-textinput) - React Native TextInput styled with Material Design.
* [react-native-timer-mixin ★274](https://github.com/reactjs/react-timer-mixin) - TimerMixin provides timer functions for executing code in the future that are safely cleaned up when the component unmounts. This is a fork that includes react-native InteractionManager support.
* [react-native-tableview-simple ★267](https://github.com/Purii/react-native-tableview-simple) - React Native component for TableView made with pure CSS
* [react-native-keyboard-manager ★267](https://github.com/douglasjunior/react-native-keyboard-manager) - Library that allows to prevent issues of keyboard sliding up and cover on React-Native iOS projects.
* [react-native-tabbar ★261](https://github.com/alinz/react-native-tabbar) - Tab bar with more freedom
* [react-native-simple-router ★255](https://github.com/react-native-simple-router-community/react-native-simple-router) - A community maintained router component for React Native
* [react-native-cacheable-image ★255](https://github.com/jayesbe/react-native-cacheable-image) - A filesystem cacheable image component for react-native
* [react-native-segmented-control-tab ★252](https://github.com/kirankalyan5/react-native-segmented-control-tab) react-native-segmented-control-tab (for Android/iOS)
* [react-native-modal-selector ★249](https://github.com/peacechen/react-native-modal-selector) - A cross-platform (iOS / Android), selector/picker component for React Native that is highly customizable and supports sections. 
* [react-native-keyboardevents ★247](https://github.com/johanneslumpe/react-native-keyboardevents) - Monitors keyboard show/hide notifications
* [react-native-multiselect ★246](https://github.com/toystars/react-native-multiple-select) - Simple multi-select component for react-native.
* [react-native-cardview ★239](https://github.com/Kishanjvaghela/react-native-cardview) - CardView for react-native (All Android version and iOS)
* [react-native-shimmer-placeholder ★231](https://github.com/tomzaku/react-native-shimmer-placeholder) - Placeholder of React Native
* [react-native-progress-hud ★228](https://github.com/naoufal/react-native-progress-hud) - A clean and lightweight progress HUD for your React Native app
* [react-native-qrcode-svg ★228](https://github.com/awesomejerry/react-native-qrcode-svg) - A QR Code generator for React Native based on react-native-svg and node-qrcode.
* [react-native-bottom-action-sheet ★226](https://github.com/prscX/react-native-bottom-action-sheet) - React Native: Native Bottom Action Sheet
* [react-native-awesome-button ★222](https://github.com/larsvinter/react-native-awesome-button) - A React Native component rendering a button supporting showing different appearances and functionality given the passed props
* [react-native-mobx ★220](https://github.com/aksonov/react-native-mobx) - Make your app reactive with MobX and react-native-router-flux
* [react-native-egg ★220](https://github.com/FuYaoDe/react-native-egg) - An easter egg component implementation simple gestures detection achieve trigger can make your react native app infinitely more fun.
* [react-native-progress-bar ★218](https://github.com/lwansbrough/react-native-progress-bar) - An animated progress bar component for React Native
* [react-native-tooltip ★217](https://github.com/chirag04/react-native-tooltip) - A react-native wrapper for showing tooltips
* [react-native-emoji ★216](https://github.com/jorilallo/react-native-emoji) - Emoji component for React Native
* [react-native-image-cache-hoc ★211](https://github.com/billmalarky/react-native-image-cache-hoc) - Higher Order Component that adds advanced caching and persistence functionality to standard Image component.
* [react-native-parallax-scroll ★209](https://github.com/monterosalondon/react-native-parallax-scroll) - Parallax Scroll component with sticky header, foreground, native-driver and all scrollable components (FlatList, ListView, SectionList, ScrollView) support.
* [react-native-shine-button ★205](https://github.com/prscX/react-native-shine-button) - React Native for Effects like shining
* [autoresponsive-react-native ★201](https://github.com/xudafeng/autoresponsive-react-native) - A Magical Layout Library For React
* [react-native-autolink ★201](https://github.com/joshswan/react-native-autolink) - Autolinking component for React Native
* [react-native-carousel-control ★199](https://github.com/machadogj/react-native-carousel-control) - React Native Carousel control with support for iOS and Android.
* [react-native-picker-select ★199](https://github.com/lawnstarter/react-native-picker-select) - A Picker component for React Native which emulates the native `<select>` interfaces for iOS and Android
* [react-native-calendar-select ★195](https://github.com/Tinysymphony/react-native-calendar-select) - A component to select a date period from calendar modal, like Airbnb.
* [react-native-wheel-picker ★190](https://github.com/lesliesam/react-native-wheel-picker) - React native cross platform picker.
* [react-native-grid-component ★188](https://github.com/phil-r/react-native-grid-component) - Easy to use grid component for your react-native project. Supports iOS and Android.
* [react-native-popover-menu ★188](https://github.com/prscX/react-native-popover-menu) - React Native: Native Popover Menu
* [react-native-collapsing-toolbar ★185](https://github.com/cesardeazevedo/react-native-collapsing-toolbar) - wrapper for android CollapsingToolbarLayout
* [react-native-pagination ★182](https://github.com/garrettmac/react-native-pagination) - A Beautiful Pagination Plugin For Lists.
* [react-native-hero ★180](https://github.com/brh55/react-native-hero) - A hero/banner component with support for dynamic or static images, dynamic sizing, color overlays, and more.
* [react-native-selectme ★178](https://github.com/gs-akhan/react-native-select) - A better Select dropdown menu for react-native
* [react-native-swiper-animated ★176](https://github.com/chitezh/react-native-swiper-animated) - Tinder-like swiper for react-native
* [react-native-tab ★171](https://github.com/vczero/react-native-tab) - react-native-tab is a simple module for add a "Tab Menu" to your React Native app.
* [react-native-webbrowser ★167](https://github.com/d-a-n/react-native-webbrowser) - A cross-platform (iOS / Android), full-featured, highly customizable web browser module for React Native apps.
* [react-native-autocomplete ★163](https://github.com/nulrich/RCTAutoComplete) - React Native Component for MLPAutoCompleteTextField
* [react-native-segmented-view ★159](https://github.com/lelandrichardson/react-native-segmented-view) - Segmented View for React Native (with animation)
* [react-native-cache-image ★158](https://github.com/remobile/react-native-cache-image) - A cache-image for react-native
* [react-native-pulse-loader ★158](https://github.com/mastermoo/react-native-pulse-loader) - Tinder like loader for your React Native app
* [stacks ★156](https://github.com/mobily/stacks) - Stacks: a set of layout components for building RN views blazingly fast ⚡, and with debug mode and design system grid you can investigate non-trivial visual issues.
* [react-native-display ★155](https://github.com/sundayhd/react-native-display) - This module brings "Display: none" (css style) to turn on/off components from render. Using this module will improve your app performance and appearance with the enter/exit animations.
* [RNParallax ★155](https://github.com/kyaroru/RNParallax) - A react native scroll view component with Parallax header
* [react-native-checkbox ★154](https://github.com/sconxu/react-native-checkbox) - Checkbox component for React native
* [react-native-phone-input ★154](https://github.com/thegamenicorus/react-native-phone-input) - Phone input box for React Native
* [react-native-switch-pro ★153](https://github.com/poberwong/react-native-switch-pro) - A pretty nice switch for Android and iOS that have same performance on two platforms and clean code in the library.
* [react-native-popup ★153](https://github.com/beefe/react-native-popup) - Popup for react-native
* [react-native-radial-menu ★153](https://github.com/omulet/react-native-radial-menu) - A Radial Menu optimized for touch interfaces
* [react-native-gestures ★152](https://github.com/kiddkai/react-native-gestures) - Composable gesture system in react native
* [react-native-page-control ★151](https://github.com/silentcloud/react-native-page-control) - React native page control, like ios UIPageControl
* [react-native-iconic ★149](https://github.com/prscX/react-native-iconic) - React Native - Animated Icons with different states
* [react-native-google-place-picker ★148](https://github.com/q6112345/react-native-google-place-picker) - React Native Wrapper of Google Place Picker for both Android and iOS.
* [react-native-scaling-drawer ★148](https://github.com/melihberberolu/react-native-scaling-drawer) - React native scaling drawer.
* [react-native-image-carousel ★148](https://github.com/anvilabs/react-native-image-carousel) - Image carousel with support for fullscreen mode, image swiping and pinch-to-zoom in fullscreen mode.
* [react-native-offline-mode ★144](https://github.com/rauchy/react-native-offline-mode) - Swap your app with an offline version while there's no connectivity
* [react-native-orientation-listener ★141](https://github.com/walmartreact/react-native-orientation-listener) - A react-native library for obtaining current device orientation
* [react-native-multi-slider ★137](https://github.com/JackDanielsAndCode/react-native-multi-slider) - Pure JS slider component with multiple markers for React Native
* [react-native-color-picker ★137](https://github.com/instea/react-native-color-picker) - React Native implementation of color picker for both Android and iOS.
* [react-native-android-statusbar ★135](https://github.com/NishanthShankar/react-native-android-statusbar) - A react native android package to control the status bar.
* [react-native-privacy-snapshot ★133](https://github.com/kayla-tech/react-native-privacy-snapshot) - Obscure passwords and other sensitive personal information when a react-native app transitions to the background
* [react-native-custom-segmented-control ★132](https://github.com/wix/react-native-custom-segmented-control) - Native UI iOS component for Segmented Control with custom style
* [react-native-map-link ★131](https://github.com/includable/react-native-map-link) - Open a location in the maps app of the user's choice.
* [react-native-sketch-canvas ★129](https://github.com/terrylinla/react-native-sketch-canvas) - A React Native component for drawing by touching on iOS and Android. (support drawing on image, text)
* [react-native-floating-labels ★126](https://github.com/mayank-patel/react-native-floating-labels) - Reusabe floating lable component for react native
* [react-native-beautiful-video-recorder ★125](https://github.com/phuochau/react-native-beautiful-video-recorder) - The video recorder component that extends from react-native-camera. It works for both iOS & Android.
* [react-native-cell-components ★125](https://github.com/lodev09/react-native-cell-components) - Awesome react-native cell components! From a Cell to more complex & awesome components.
* [react-native-material-menu ★119](https://github.com/mxck/react-native-material-menu) - Pure JavaScript material menu component for React Native.
* [react-native-bouncy-drawer ★116](https://github.com/SoftZen/react-native-bouncy-drawer) - Highly customizable Bouncy Drawer
* [react-native-taptargetview ★114](https://github.com/prscX/react-native-taptargetview) - React Native Bridge for Android KeepSafe/TapTargetView. An implementation of tap targets from the Material Design guidelines for feature discovery.
* [photo-viewer ★114](https://github.com/merryjs/photo-viewer) - A photo viewer for react native build on top of NYTPhotoViewer and FrescoImageViewer
* [react-native-switch-selector ★112](https://github.com/App2Sales/react-native-switch-selector) - A custom Switch Selector component for Android and iOS.
* [react-native-flexi-radio-button ★111](https://github.com/thegamenicorus/react-native-flexi-radio-button) - Simple and flexible Radio button for React Native
* [react-native-triangle ★108](https://github.com/Jpoliachik/react-native-triangle) - Draw triangle views in react native
* [react-native-viewport-units ★107](https://github.com/jmstout/react-native-viewport-units) - Incredibly simple utility for (sort of) using viewport units with React Native.
* [react-native-wheel-picker-android ★186](https://github.com/ElekenAgency/ReactNativeWheelPicker) - Simple and flexible React native wheel picker for Android, including DatePicker and TimePicker.
* [react-native-device-display ★105](https://github.com/kkjdaniel/react-native-display-view) - A simple way to create dynamic views through device and display detection, allowing the creation of adaptable and universal apps.
* [react-native-android-kit ★104](https://github.com/ayoubdev/react-native-android-kit) - A set of native Android UI components and modules for React Native framework (Android Design Support Library, TabLayout, Floating Action Button and more...).
* [react-native-fading-slides ★103](https://github.com/chagasaway/react-native-fading-slides) - Simple looped fading slides carousel for React Native
* [react-native-scl-alert ★102](https://github.com/rafaelmotta/react-native-scl-alert) - React Native implementation of the package SCLAlertView-Swift
* [react-native-card-view ★101](https://github.com/jacklam718/react-native-card-view) - A react native card component
* [react-native-marquee-label ★100](https://github.com/remobile/react-native-marquee-label) - A marquee label for react-native
* [react-native-drawer-menu ★97](https://github.com/Tinysymphony/react-native-drawer-menu) - React Native Drawer Menu
* [react-native-simple-dialogs ★97](https://github.com/douglasjunior/react-native-simple-dialogs) - Cross-platform simple dialogs for React Native based on the Modal component.
* [react-native-swipe-a-lot ★96](https://github.com/nickjanssen/react-native-swipe-a-lot) - A swipe component for React Native that works on iOS and Android.
* [react-native-submit-button ★96](https://github.com/ronak301/react-native-submit-button) - Animated Submit button. Works on both android and ios
* [react-native-actions-sheet ★94](https://github.com/ammarahm-ed/react-native-actions-sheet) - A Cross Platform(Android & iOS) ActionSheet with a flexible api, native performance and zero dependency code
* [react-native-dialog ★92](https://github.com/mmazzarolo/react-native-dialog) - Pure JavaScript React-Native dialog
* [react-native-scrollable-mixin ★91](https://github.com/exponentjs/react-native-scrollable-mixin) - A standard interface for your scrollable React Native components, making it easier to compose components
* [react-native-open-maps ★90](https://github.com/brh55/react-native-open-maps) - A simple lib to open up the corresponding map application (Google or Apple Maps) from a set of coordinates (latitude & longitude) within react-native
* [react-native-swiper2 ★86](https://github.com/sunnylqm/react-native-swiper2) - Swiper component for React Native. Supersede react-native-swiper
* [react-native-listitem ★86](https://github.com/dancormier/react-native-listitem) - iOS-style listitem component for React Native
* [react-native-progressive-input ★86](https://github.com/khaiql/react-native-progressive-input) - TextInput with clear button and activity indicator, used as part of autocomplete list.
* [react-native-in-app-notification ★86](https://github.com/robcalcroft/react-native-in-app-notification) - Customisable in-app notification component for React Native
* [react-native-shared-preferences ★85](https://github.com/sriraman/react-native-shared-preferences) - Android's Native key value storage system in React Native
* [react-native-emoji-picker ★85](https://github.com/yonahforst/react-native-emoji-picker) - Simple Emoji picker for react-native with optional modal-like component
* [react-native-scalable-image ★85](https://github.com/ihor/react-native-scalable-image) - React Native Image component which scales width or height automatically to keep the original aspect ratio.
* [react-native-page-swiper ★83](https://github.com/fixt/react-native-page-swiper) - Page Swiper component for React Native.
* [react-native-material-showcase-ios ★81](https://github.com/prscX/react-native-material-showcase-ios) - React Native Bridge for iOS aromajoin/material-showcase-ios. An elegant and beautiful showcase for iOS apps.
* [react-native-label-select ★81](https://github.com/Tinysymphony/react-native-label-select) - A modal selector for React Native with selected items displayed as labels.
* [react-native-3dcube-navigation ★80](https://github.com/zehfernandes/react-native-3dcube-navigation) - Page Swiper component with 3D cube transition (horizontal and vertical)
* [react-native-keyboard-accessory ★80](https://github.com/ardaogulcan/react-native-keyboard-accessory) - Keyboard Accessory (View, Navigation) Component. Sticky views on keyboard.
* [react-native-draggable-grid ★79](https://github.com/SHISME/react-native-draggable-grid) - A React Native draggable and sortable grid component write by typescript.
* [react-native-textinput-utils ★79](https://github.com/DickyT/react-native-textinput-utils) - A react native extension which allows you to control TextInput better.
* [react-native-idle-timer ★79](https://github.com/marcshilling/react-native-idle-timer) - An Objective-C bridge that allows you to enable and disable the screen idle timer in your React Native app
* [react-native-snackbar-component ★77](https://github.com/SiDevesh/React-Native-SnackBar-Component) - A snackbar component for Android and iOS, customizable and simple.
* [react-native-charts ★76](https://github.com/PrazAs/react-native-charts) - Delightfully-animated data visualization.
* [react-native-android-blurryoverlay ★75](https://github.com/kwaak/react-native-android-blurryoverlay) - A react native android package to show a blurry overlay.
* [react-native-calendar-datepicker ★75](https://github.com/vlad-doru/react-native-calendar-datepicker) - A cross-platform calendar datepicker
* [react-native-scrollview-smart ★75](https://github.com/bolket/react-native-scrollview-smart) - A Smart ScrollView component for IOS and Android.
* [react-native-zoom-image ★75](https://github.com/Tinysymphony/react-native-zoom-image) - An image viewer component for react-native, like twitter's image viewer.
* [react-native-picker-xg ★74](https://github.com/xgfe/react-native-picker-xg) - A picker for both Android and iOS
* [react-native-status-bar-height ★73](https://github.com/ovr/react-native-status-bar-height) - A small library that helps you to get status bar height easily. It also support iPhone X.
* [react-native-color-wheel ★72](https://github.com/netbeast/react-native-color-wheel) - A react native reusable color picker wheel
* [react-native-scrollview-lazyload ★71](https://github.com/IskenHuang/react-native-scrollview-lazyload) - react-native scrollview with image lazy load
* [react-native-pure-navigation-bar ★71](https://github.com/gaoxiaosong/react-native-pure-navigation-bar) - A fully customizable navigation bar in React Native.
* [react-native-material-cards ★70](https://github.com/SiDevesh/React-Native-Material-Cards) - A material design card component, customizable and versatile.
* [react-native-item-cell ★69](https://github.com/APSL/react-native-item-cell) - React Native default style iOS item cell
* [react-native-calendario ★69](https://github.com/maggialejandro/react-native-calendario) - React Native Calendar DatePicker
* [react-native-picker-android ★67](https://github.com/beefe/react-native-picker-android) - react-native-picker-android
* [react-native-nested-stylesheet ★67](https://github.com/pjjanak/react-native-nested-stylesheets) - Nestable stylesheets for react-native.
* [react-native-dropdown-android ★65](https://github.com/chymtt/ReactNativeDropdownAndroid) - Simple wrapper for Android's Spinner to use with react-native
* [react-native-slot-machine ★65](https://github.com/atlanteh/react-native-slot-machine) - A text slot machine component for react-native
* [react-native-swipeview ★65](https://github.com/rishabhbhatia/react-native-swipeview) - SwipeView component used to perform actions like swipe to delete, works on iOS and Android
* [react-native-download-button ★64](https://github.com/prscX/react-native-download-button) - React Native Download Button: with pretty cool animation
* [react-native-siri-wave-view ★64](https://github.com/prscX/react-native-siri-wave-view) - React Native: Native Siri Wave View
* [react-native-card-media ★63](https://github.com/dondoko-susumu/react-native-card-media) - Card media component & Support multiple image layout
* [react-native-simple-picker ★62](https://github.com/puredazzle/react-native-simple-picker) - A simple react-native select picker
* [react-native-view-pdf ★62](https://github.com/rumax/react-native-PDFView) - PDF viewer for React Native
* [react-native-touchable-bounce ★62](https://github.com/grabbou/react-native-touchable-bounce) - React Native Touchable Bounce
* [react-native-streetview ★61](https://github.com/nesterapp/react-native-streetview) - Google's Panorama/StreetView component for iOS and Android.
* [react-native-thumbnail ★60](https://github.com/phuochau/react-native-thumbnail) - Get thumbnail from local media.
* [react-native-simple-stepper ★60](https://github.com/testshallpass/react-native-simple-stepper) - A super simple react-native implementation of the UIStepper iOS control.
* [react-native-phone-picker ★58](https://github.com/Spikef/react-native-phone-picker) - a quick phone picker control
* [react-native-infinite-scrollview ★58](https://github.com/baspellis/react-native-infinite-scrollview) - ScrollView with infinite paged scrolling (no looping)
* [react-native-select-multiple  ★58](https://github.com/tableflip/react-native-select-multiple) -A simple and easy to use component for multiple selection of item from List.
* [react-native-easy-content-loader ★57](https://github.com/sarmad1995/react-native-easy-content-loader) - React-Native light weight skeleton content loading.
* [react-native-multiple-choice ★57](https://github.com/d-a-n/react-native-multiple-choice) - A cross-platform (iOS / Android) single and multiple-choice React Native component.
* [k-react-native-swipe-unlocker ★55](https://github.com/leowang721/k-react-native-swipe-unlocker) - A simple swipe unlock for React Native
* [react-native-walkthrough-tooltip ★55](https://github.com/CompanyCam/react-native-walkthrough-tooltip) - Highlight a component via tooltip/popover
* [react-native-adbannerview ★52](https://github.com/Purii/react-native-adbannerview) - React Native Bridge for ADBannerView
* [react-native-fxblurview ★52](https://github.com/magus/react-native-fxblurview) - React Native wrapper for popular FXBlurView library for realtime, fine-tuned blur effects
* [react-native-beautiful-image ★52](https://github.com/phuochau/react-native-beautiful-image) - The Beautiful Image component that supports fadeIn animation and shows placeholderSource if the main source can't be loaded.
* [react-native-360-image-viewer ★100](https://github.com/phuochau/react-native-360-image-viewer) - The component helps to simulate 360 degrees image from multiple images.
* [react-native-fs-modal ★51](https://github.com/kirkness/react-native-fs-modal) - React native full screen modal component.
* [react-native-toast-native ★51](https://github.com/onemolegames/react-native-toast-native) React Native Toast component for both Android and iOS.
* [react-native-masked-view ★50](https://github.com/gilbox/react-native-masked-view) - A element for react-native
* [react-native-md-motion-buttons ★50](https://github.com/zecaptus/react-native-md-motion-buttons) - Material design motion button inspired by inVision app.
* [react-native-drop-refresh ★49](https://github.com/Obooman/RCTRefreshControl) - A pull down to refresh control for react native.
* [react-native-pin-view ★48](https://github.com/talut/react-native-pin-view) - Easy, convenient, quick-forming PinView component. It runs smoothly for both IOS and Android.
* [react-native-radio-button-classic ★47](https://github.com/pressly/react-native-radio-button-classic) - Bring Classic Radio to React-Native
* [react-native-image-intent ★47](https://github.com/sonnylazuardi/react-native-image-intent) - Image intent receiver for React Native android
* [react-native-dial ★47](https://github.com/netbeast/react-native-dial) - A react native reusable and efficient dial knob element.
* [react-native-date ★46](https://github.com/nucleartux/react-native-date) - React Native date and time pickers for Android
* [react-native-draggable-drawer ★46](https://github.com/llanox/react-native-draggable-drawer) - DraggableDrawer component for React Native.
* [react-native-date-picker ★46](https://github.com/henninghall/react-native-date-picker) - A date picker component for Android and iOS
* [react-native-message-composer ★45](https://github.com/anarchicknight/react-native-message-composer) - React Native module bridge to iOS MFMessageComposeViewController
* [react-native-layout ★45](https://github.com/jerolimov/react-native-layout) - Semantic JSX layout components for react-native
* [react-native-touch-visualizer ★45](https://github.com/zachgibson/react-native-touch-visualizer) - Visualize touches and drags on React Native apps for iOS.
* [react-native-calendar-android ★44](https://github.com/chymtt/ReactNativeCalendarAndroid) - A simple material-themed calendar for react native android
* [react-native-air-progress-bar ★44](https://github.com/kis/react-native-air-progress-bar) - React Native progress-bar component, customizable and animated
* [react-native-full-screen ★44](https://github.com/Anthonyzou/react-native-full-screen) - React Native FullScreen api and element
* [react-native-full-image-picker ★44](https://github.com/gaoxiaosong/react-native-full-image-picker) - Support taking photo, video recording or selecting from photo library.
* [react-native-viewport ★43](https://github.com/pjjanak/react-native-viewport) - Viewport dimensions for react-native

* [react-native-progress-circular ★43](https://github.com/andy9775/React-Native-CircularProgress) - A pure React Native Component for circular progress bars for both iOS and Android.
* [react-native-tween-animation ★43](https://github.com/kirkness/react-native-tween-animation) - A simple react native state tween animation module.
* [react-native-flanimatedimage ★43](https://github.com/nihgwu/react-native-flanimatedimage) - FLAnimatedImage for React Native.
* [react-native-grading ★43](https://github.com/Tinysymphony/react-native-grading) - React Native Component for grading scores using ReactART.
* [react-native-auto-typing-text ★43](https://github.com/phuongla/react-native-auto-typing-text) - An auto typing text component for react-native
* [react-native-slack-webhook ★42](https://github.com/xcarpentier/react-native-slack-webhook) - Follow some activities (new user, payment,...) from your app via Slack and this webhook lib.
* [react-native-responsive-linechart ★41](https://github.com/N1ghtly/react-native-responsive-linechart) - Draw Line and Area charts easily. Works responsively.
* [react-native-simpledialog-android ★41](https://github.com/lucasferreira/react-native-simpledialog-android) - React Native Android module to use Android's AlertDialog - same idea of AlertIOS
* [react-native-toolkit ★41](https://github.com/marty-wang/react-native-toolkit) - A collection of common UI components for react native mobile apps.
* [react-native-draggable-grid ★41](https://github.com/SHISME/react-native-draggable-grid) - A React Native draggable and sortable grid component write by typescript.
* [react-native-sortable-gridview ★4](https://github.com/ge6285790/react-native-sortable-gridview) - A React Native sortable and draggable Grid View Component.
* [react-native-elastic-stack ★41](https://github.com/monterosalondon/react-native-elastic-stack) - ReactNative component that implements [elastic stack effect](https://tympanus.net/Development/ElasticStack/)
* [react-native-big-slider ★41](https://github.com/netbeast/react-native-big-slider) - Yet another, big one, pure JS easily customisable and hackable react-native slider component.
* [react-native-custom-actsheet ★40](https://www.npmjs.com/package/react-native-custom-actsheet) - A custom ActionSheet for react-native
* [rn-render-perfs ★40](https://github.com/mfrachet/rn-render-perfs) - Measure React rendering lifecycles using UI controls
* [react-native-animated-check-mark ★40](https://github.com/AppliKeySolutions/RocketButton) - A small react component for animated cross-mark transformation.
* [react-native-easy-dnd ★39](https://github.com/mohebifar/react-native-easy-dnd) - Drag and drop component for react-native
* [react-native-fab ★39](https://github.com/SiDevesh/React-Native-FAB) - A FAB button component for Android and iOS, customizable, simple and as per material design specs.
* [react-native-popupwindow ★38](https://github.com/beefe/react-native-popupwindow) - Android PopupWindow for react-native module
* [react-native-wheel ★38](https://github.com/shexiaoheng/react-native-wheel) - android wheel view for react-native
* [react-native-bar-collapsible ★38](https://github.com/caroaguilar/react-native-bar-collapsible) - A Bar component that can be collapsible (toggle/accordion), clickable or text-only.
* [react-native-circle-view ★37](https://github.com/nucleartux/react-native-circle-view) - circle progress for react native android using CircleView
* [react-native-slidable-tab-bar ★37](https://github.com/pwbrown/react-native-slidable-tab-bar) - Slidable tab bar for instant view rendering(react-native)
* [react-native-scrollable-decorator ★37](https://github.com/exponentjs/react-native-scrollable-decorator) - A standard interface for your scrollable React Native components, making it easier to compose components
* [react-native-circle-checkbox ★37](https://github.com/ParamoshkinAndrew/ReactNativeCircleCheckbox) - Circle checkbox component for React Native
* [react-native-newsticker ★35](https://github.com/moschan/react-native-newsticker) - The News Ticker component for React Native
* [react-native-awesome-alert ★35](https://github.com/heyman333/react-native-awesome-alert) - Customizable modal components with ✔️check options in React Native
* [react-native-view ★34](https://github.com/i6mi6/react-native-view) - Lightweight View component for quick styling.
* [react-native-draggable-calendar ★34](https://github.com/SmallStoneSK/react-native-draggable-calendar) - A calendar component supporting dragging.
* [react-native-countdown ★33](https://github.com/buhe/react-native-countdown) - react native countdown button
* [react-native-dashed-border ★33](https://github.com/chirag04/react-native-dashed-border) - A element for react-native
* [react-native-writebox ★33](https://github.com/bdryanovski/react-native-writebox) - (iOS / Android) Facebook/Twitter textarea that autogrow and count characters.
* [react-native-ibeacon-simulator ★32](https://github.com/williamtran29/react-native-ibeacon-simulator) - React Native Library to simulate device act as an iBeacon
* [react-native-suggester ★32](https://github.com/xcarpentier/react-native-suggester) - React-Native package to decorate TextInput and get suggestions with good UX.
* [react-native-photo-grid ★31](https://github.com/christopherabouabdo/react-native-photo-grid) - React Native component that handles the complexities of building a grid of photos with a flexible number of photos per row.
* [react-native-android-iconify ★30](https://github.com/lwhiteley/react-native-android-iconify) - icons for react native android using android-iconify
* [react-native-touchable-set-active ★30](https://github.com/jmstout/react-native-TouchableSetActive) - Touchable component for React Native that enables more advanced styling by setting an active state. Most useful for building your own touchable/button components on top of.
* [react-native-telephone-input ★30](https://github.com/kundigo/react-native-telephone-input) - React Native Telephone Input, discover country and mask telephone Input
* [react-native-nmrangeslider-ios ★29](https://github.com/Enrise/react-native-nmrangeslider-ios) - The NMRangeSlider component for React Native
* [react-native-fade-in-view ★29](https://github.com/robcalcroft/react-native-fade-in-view) - A simple and lightweight RN component that fades in its children
* [react-native-gl-image-filters ★27](https://github.com/GregoryNative/react-native-gl-image-filters) - React Native GL Filters for Image implementation.
* [react-native-focus-scroll ★26](https://github.com/c-bata/react-native-focus-scroll) - react-native-focus-scroll can detect which children are focused when scrolling.
* [react-native-about-libraries ★26](https://github.com/prscX/react-native-about-libraries) - React Native: It offers information about install packages
* [react-native-actionsheet-native ★25](https://github.com/slowpath/react-native-actionsheet) - Android ActionSheet support for React Native
* [react-native-comparison-slider ★25](https://github.com/charlot567/react-native-comparison-slider) - A simple component to display two image in comparison with a slide-over feature.
* [react-native-selectmultiple-button ★25](https://github.com/danceyoung/react-native-selectmultiple-button) - A button (or a grouped buttons) supporting multiple or radio selection
* [react-native-timeline-theme ★25](https://github.com/tomzaku/react-native-timeline-theme) - Collection of TimeLine theme. This package only use flexbox(without absolute) & FlatList
* [react-native-date-range-picker ★25](https://github.com/lazaronixon/react-native-date-range-picker) - Simple date range picker extended from react-native-calendars 📆
* [react-native-circle-progress ★24](https://www.npmjs.com/package/react-native-circle-progress) - A custom Circle Progress Indicator for React Native
* [react-native-app-intro-v2 ★24](https://github.com/Sh1n1x/react-native-app-intro) - Latest App intro
* [react-native-starrating ★24](https://github.com/bluesky0109/react-native-starRating) - a react-native component for display interactive star ratings
* [react-native-echarts-wrapper ★24](https://github.com/tomLadder/react-native-echarts-wrapper) - Powerful ECharts wrapper build for React Native
* [react-native-orientation-controller ★23](https://github.com/inProgress-team/react-native-orientation-controller) - A react-native library for obtaining and controlling the current device and application orientation
* [react-native-match-media ★23](https://github.com/tuckerconnelly/match-media-mocks) - window.matchMedia mock for React Native
* [react-native-simple-card-view ★23](https://github.com/talut/react-native-simple-card-view) - Easiest way to adding a card view on your screen.
* [monalisa-ui ★22](https://github.com/tuantvk/monalisa-ui) - MonalisaUI is UI component library for React Native to build native mobile apps for iOS and Android platforms
* [react-native-square-view ★22](https://github.com/Shuangzuan/react-native-square-view) - A square view component for react native.
* [react-native-ichart ★22](https://github.com/AdonRain/react-native-ichart) - ichart for react-native
* [react-native-dropbox-chooser ★21](https://github.com/tinycreative/react-native-dropbox-chooser) - React Native dropbox chooser module
* [react-native-compress ★21](https://github.com/phuochau/react-native-compress) - Compress video for react native. Only for iOS, Android will be coming.
* [react-native-custom-actionsheet ★21](https://github.com/valerybugakov/react-native-custom-actionsheet) - Fully customizable ActionSheet for React Native.
* [react-native-timepicker ★20](https://github.com/milasevicius/react-native-timepicker) - React Native timepicker for iOS
* [react-native-custom-checkbox ★20](https://github.com/caroaguilar/react-native-custom-checkbox) - React Native checkbox that can be customize. Works for both Android and iOS.
* [react-native-tilt ★20](https://github.com/psicotropicos/react-native-tilt) - Tilt effect with accelerometer for React Native components.
* [react-native-drawpad ★20](https://github.com/Partido-Asia/react-native-drawpad) - A pad for users to draw by touching
* [rn-ab-hoc ★19](https://github.com/mfrachet/rn-ab-hoc) - Poor intrusive way to make A/B Testing by using an HoC instead of components.
* [react-native-expand ★19](https://github.com/hejiaji/react-native-expand) - A react-native expandable component for both Android and iOS
* [react-native-modal-loader ★19](https://github.com/kdastan/react-native-modal-loader) - Customizable animated modal progress hud for react apps.
* [react-native-images-collage ★19](https://github.com/lukebrandonfarrell/react-native-images-collage) - Robust interactive image collage component for React Native.
* [react-native-avatar-gravatar ★18](https://github.com/niborb/react-native-gravatar) - React Native Gravatar component
* [react-native-image-modal ★16](https://github.com/dev-yakuza/react-native-image-modal) -  simple full size modal image for iOS and Android. supports zoom-in/out, double-tap zoom-in/out, move and swipe-to-dismiss
* [react-native-notifier ★16](https://github.com/seniv/react-native-notifier) - Fast and simple in-app notifications for React Native
* [react-native-grid ★15](https://github.com/thewei/react-native-grid) - The 24-column grid component for react-native
* [react-native-search ★15](https://github.com/StevenIseki/react-native-search) - Native Search component for react native.
* [rn-displayable ★15](https://github.com/mfrachet/rn-displayable) - Display your components based on props or a set of rules
* [react-native-custom-picker ★15](https://github.com/budiadiono/react-native-custom-picker) - React native customizable picker component.
* [react-native-confirmation-code-field ★15](https://github.com/retyui/react-native-confirmation-code-field) - A React Native component to input confirmation code for both Android and IOS
* [react-native-android-circles ★14](https://github.com/kwaak/react-native-android-circles) - A react native android package to show a circle progress view.
* [react-native-anchor-point ★14](https://github.com/sueLan/react-native-anchor-point) - Make the fancy 3D transform easier in react native
* [react-native-code-verification ★13](https://github.com/danchokobo/react-native-code-verification) - An UI module for user-side pincode verification.
* [react-native-hijri-date-picker ★13](https://github.com/Codelabsys/react-native-hijri-date-picker-android) - Date Picker Dialog for Hijri calendar for android.
* [react-native-imagewand ★13](https://github.com/NorthFoxz/react-native-imagewand) - image wand for react native
* [react-native-gravatar ★13](https://github.com/lwhiteley/react-native-gravatar) - react-native wrapper for gravatar-api
* [react-native-rebound-scrollview ★12](https://github.com/jaxchow/react-native-rebound-scrollview) - React Native Android ReboundScrollView implementation.
* [react-native-calculator ★12](https://github.com/budiadiono/react-native-calculator) - React Native Calculator and Calculator Input Component.
* [react-native-navbar-color ★12](https://github.com/BhavanPatel/react-native-navbar-color) - Change Navigationbar Color in Android
* [radio-buttons-react-native ★11](https://github.com/sramezani/radio-buttons-react-native) - Animated radio buttons component for react native
* [react-native-piechart ★10](https://github.com/frostney/react-native-piechart) - A component for React Native
* [react-native-seekbar-android ★10](https://github.com/DispatcherInc/react-native-seekbar-android) - A React Native wrapper Android's SeekBar
* [react-native-coachmasks ★10](https://github.com/TranLuongTuanAnh/react-native-coachmasks) - react-native-coachmark! It helps you easily create Coach Marks to enhance user experience!
* [react-native-progress-button ★10](https://github.com/xinghui0000/react-native-progress-button) - A react native button component that can show progress.
* [react-native-quiltview ★9](https://github.com/mmslate/react-native-quiltview) - Native iOS UICollectionView wrapper with RFQuiltLayout for React Native
* [react-native-relative-units ★9](https://github.com/benzhe/react-native-relative-units) - Relative units for React Native
* [react-native-simple-button ★9](https://github.com/remobile/react-native-simple-button) - A simple react-native button
* [react-native-styled-toast ★9](https://github.com/jeanverster/react-native-styled-toast) - A themeable toast component for React Native.
* [react-native-frame-loading ★9](https://github.com/heyman333/react-native-frame-loading) - The Loading indicator with frame by frame view animation
* [react-native-rheostat ★9](https://github.com/DrChai/react-native-rheostat) - Inspired by Airbnb's [rheostat](https://github.com/airbnb/rheostat), a powerful slider with assorted data visualized charts.
* [react-native-country-picker ★8](https://github.com/tofugear/react-native-country-picker) - React Native Country Picker
* [react-native-flex-label ★8](https://github.com/eccolabs/react-native-flex-label) - A text label for React Native that handles multiple lines of text with ellipses truncation as well as vertical alignment within it's view container.
* [react-native-link ★8](https://github.com/650Industries/react-native-link) - A link component
* [react-native-stylesheet-xg ★8](https://github.com/xgfe/react-native-stylesheet-xg) - extension stylesheet for cross platforms and responsive
* [react-native-censored ★8](https://github.com/redpandatronicsuk/react-native-censored) - React Native component to censor content.
* [react-native-bouncing-ball ★8](https://github.com/hankzhuo/react-native-bouncing-ball) - React Native component bouncing ball for both iOS and Android.
* [react-native-loading ★7](https://github.com/alcat2008/react-native-loading) - A lightweight loading for your React Native app.
* [react-native-segment-control ★7](https://github.com/ainurb/react-native-segment-control) - A swipeable SegmentedControl component for React Native apps.
* [react-native-animated-styles ★7](https://github.com/ericpkerr/react-native-animated-styles) - Easily animate/transition react components between two style states.
* [react-native-hide-modal ★6](https://github.com/heyman333/react-native-hide-modal) - Modal component that can be hidden
* [react-native-hole-view ★6](https://github.com/ibitcy/react-native-hole-view) - Component for cutting out click-through holes in any view. Perfect for making tutorial-like overlay
* [react-native-masonry-brick-list ★5](https://github.com/lvlrSajjad/react-native-masonry-brick-list) - Staggered Or Masonary List View For React Native Written in pure js
* [react-native-blur-overlay ★5](https://github.com/lvlrSajjad/react-native-blur-overlay) - React Native Blur Overlay Library For Ios And Android
* [react-native-rate-modal ★5](https://github.com/omergulen/react-native-rate-modal) - Hackable "rate us" component for React Native.
* [react-native-fancy-carousel-viewpager ★4](https://github.com/lvlrSajjad/react-native-fancy-carousel-viewpager) - React Native Designed View Pager Library (pure js)
* [pinar ★4](https://github.com/kristerkari/pinar) - Customizable, lightweight React Native carousel component with accessibility support.
* [react-native-svg-transformer ★4](https://github.com/kristerkari/react-native-svg-transformer) - Import SVG files inside React Native components. Uses the react-native-svg library to render SVG images.
* [react-native-progress-steps ★4](https://github.com/colbymillerdev/react-native-progress-steps) - A simple and fully customizable React Native component that implements a progress stepper UI.
* [react-native-loader-hud ★3](https://github.com/EdgeJay/react-native-loader-hud) - Loader animation library for React Native
* [react-native-double-buffer ★3](https://github.com/alinz/react-native-double-buffer) - Simple React Native Double Buffer View
* [react-native-fontbase ★3](https://github.com/frostney/react-native-fontbase) - Defining font sizes in React Native
* [react-native-units ★2](https://github.com/alexfoxy/react-native-units) - A collection of useful units and a simple grid implementation for responsive layouts in React Native.
* [react-native-easy-checkbox ★2](https://github.com/BhavanPatel/react-native-easy-checkbox) - Simple CheckBox for react-native
* [react-native-scene-manager ★2](https://github.com/alinz/react-native-scene-manager) - Simple Scene Manager for React-Native
* [react-native-rounded-navigation-drawer ★2](https://github.com/lvlrSajjad/react-native-rounded-navigation-drawer) - React Native Designed Navigation Drawer Library (Pure Js)
* [react-native-expandable-fab-menu ★2](https://github.com/lvlrSajjad/react-native-expandable-fab-menu) - React Native Expandable Fab Menu Component (pure js)
* [react-native-animated-bottom-tabbar ★2](https://github.com/lvlrSajjad/react-native-animated-bottom-tabbar) - Animated bottom Tab bar for react native
* [react-native-create-new-file-ios ★1](https://github.com/rhaker/react-native-create-new-file-ios) - A react-native interface for creating a blank new file on ios. File must not already exist.
* [react-native-picker-module ★1](https://github.com/talut/react-native-picker-module) - A different approach for React Native Picker.
* [react-native-countries ★1](https://github.com/talut/react-native-countries) - This package is provide you directly native countries name & code list from device.
* [react-native-scrubber ★1](https://github.com/repodio/react-native-scrubber/tree/master) - A simple audio/video Scrubber for both iOS and Android.
* [react-native-loader-kit ★1](https://github.com/maitrungduc1410/react-native-loader-kit) - Purely native loading animations for React Native.
* [react-native-new-feature ★1](https://github.com/maitrungduc1410/react-native-new-feature) - A simple and lightweight What's New component to show your latest React native Features.
* [react-native-sdr](https://github.com/i6mi6/react-native-sdr) - Server Driven Rendering (SDR) component for React Native
* [react-native-store-view ★19](https://github.com/rh389/react-native-store-view) - Wraps SKStoreProductViewController for use in react-native projects
* [react-native-image-container ★0](https://github.com/frostney/react-native-image-container) - Image container for React Native
* [react-native-counters ★0](https://github.com/yasaricli/react-native-counters) - Minus Plus Counter for React Native
* [react-native-gradient-buttons](https://github.com/thomaswangio/react-native-gradient-buttons) - A lightweight, customizable and haptic Gradient Button component for React Native.
* [react-native-auth-screens](https://github.com/thomaswangio/auth-screens) - A series of Authentication Views for React Native: Sign In, Social Sign In Sign Up, and Forgot Password. Uses `react-native-gradient-buttons`.
* [react-native-animated-flatlist](https://github.com/shakogegia/react-native-animated-flatlist) - Animated Flatlist for React Native.
* [swipeable-modal-react-native](https://github.com/bzurkow/swipeable-modal-react-native) - A 'pop-up' modal that can be swiped away left or right to run different functions.
* [react-native-countdown-text](https://github.com/realKfiros/react-native-countdown-text) - A React Native component that converts a timestamp of a future date to a readable countdown clock, based on a format.
* [rn-actionsheet-module ★0](https://github.com/talut/rn-actionsheet-module) - BottomsheetDialog & ActionSheetIOS with same props and usage.
* [react-native-animated-loader](https://github.com/vikrantnegi/react-native-animated-loader) - A React Native Loader Component which uses Airbnb's Lottie for beautiful loader animations.
* [rn-verifcode](https://github.com/xcarpentier/rn-verifcode) - React-Native component to input confirmation code for both Android and IOS
* [react-native-picker-modal-view](https://github.com/pankod/react-native-picker-modal-view) - React Native Module to select item picker modal.
* [rn-material-textinput](https://github.com/akshit5230/React-Native-Material-TextInput) - A simple TextInput wrapper for material styling in iOS and Android with Customizable styles & Animated label.
* [rn-action-picker](https://github.com/akshit5230/rn-action-picker) - A simple action picker for iOS and Android. Renders Native ActionSheetIOS Component in iOS and custom ActionSheet lookalike component in Android.
* [rn-collapsible-section](https://github.com/akshit5230/React-Native-Collapsible-Section) - A collapsible section / section list with customizable section body and child body. Supports both iOS and Android.
* [view-on-steroids](https://github.com/vko-online/pane) - React-Native View component with inline styles
* [react-native-eva-icons](https://github.com/artyorsh/react-native-eva-icons) - [Eva Icons](https://github.com/akveo/eva-icons) implementation for React Native based on react-native-svg elements.
* [react-native-dots-pagination ★3](https://github.com/tsepeti/react-native-dots-pagination) - A simple dot paging for React Native.
* [react-native-gesture-detector](https://github.com/mxmzb/react-native-gesture-detector) - Easily create and detect custom, complex gestures on React Native.
* [react-native-scrollview-header ★5](https://github.com/weifxn/react-native-scrollview-header) - An animated ScrollView header that transitions from transparent background to opaque upon scrolling.
* [react-native-wizard](https://github.com/talut/react-native-wizard) - Easily navigate your user for next step. Quick-forming Wizard component.
* [react-native-timetable](https://github.com/gomjellie/react-native-timetable) - 📆 timetable library for React Native
* [react-native-material-drawer](https://github.com/codypearce/react-native-material-drawer) - React Native Material Drawer for iOS, Android, Web, and Electron

### Navigation

* [react-navigation ★14233](https://github.com/react-community/react-navigation) - Easy to use Navigation for React Native
* [react-native-navigation ★9325](https://github.com/wix/react-native-navigation) - App-wide support for 100% native navigation with an easy cross-platform interface.
- [react-native-navigation-hooks ★109](https://github.com/underscopeio/react-native-navigation-hooks) - A set of React hooks for React Native Navigation.
* [react-native-router-flux ★7720](https://github.com/aksonov/react-native-router-flux) - React Native Router based on new React Native Navigation API
* [kittenTricks ★4227](https://github.com/akveo/kittenTricks) - A react native mobile starter kit with over 40 screens and theme hot reload support
* [native-navigation ★3060](https://github.com/airbnb/native-navigation) - Native navigation library for React Native applications
* [react-native-navbar ★1824](https://github.com/Kureev/react-native-navbar) - Simple customizable navbar component for react-native
* [react-native-router ★1203](https://github.com/t4t5/react-native-router) - Awesome navigation for your native app.
* [ex-navigation ★1019](https://github.com/exponentjs/ex-navigation) - A route-centric, batteries-included navigation library for Exponent and React Native that works seamlessly on Android and iOS.
* [react-native-controllers ★580](https://github.com/wix/react-native-controllers) - Truly native no-compromise iOS navigation for React Native.
* [ex-navigator ★531](https://github.com/exponentjs/ex-navigator) - Route-centric navigation built on top of React Native's Navigator
* [react-native-nav ★262](https://github.com/jineshshah36/react-native-nav) - A cross-platform (iOS / Android), fully customizable, React Native Navigation Bar component
* [react-native-navigation-drawer ★98](https://github.com/ilansas/react-native-navigation-drawer) - A slide menu inspired from Android for React-Native
* [react-native-ya-navigator ★88](https://github.com/xxsnakerxx/react-native-ya-navigator) - Yet another react native navigator component
* [navbar-native ★86](https://github.com/redbaron76/navbar-native) - A new, fully customizable Navbar component for React-Native
* [react-native-swiper-flatlist ★★ ★81](https://github.com/gusgard/react-native-swiper-flatlist) - 👆 React Native Swiper component implemented with FlatList
* [react-native-easy-router ★78](https://github.com/sergeyshpadyrev/react-native-easy-router) - React Native router with easy-to-use API
* [react-native-navigator ★74](https://github.com/thewei/react-native-navigator) - A simple router for react native
* [react-navigation-magic-move ★62](https://github.com/IjzerenHein/react-navigation-magic-move) - Bindings for using react-navigation with react-native-magic-move 🐰🎩✨ (shared element transitions)
* [react-native-navigation-bar ★59](https://github.com/beefe/react-native-navigation-bar) - react-native-navigation-bar
* [react-native-url-handler ★37](https://github.com/exponentjs/react-native-url-handler) - Navigate to external URLs, handle in-app URLs, and access system URLs
* [react-native-grid-list ★ ★28](https://github.com/gusgard/react-native-grid-list) - React Native Grid List component
* [react-native-route-navigator ★27](https://github.com/Andr3wHur5t/react-native-route-navigator) - React-Native page navigation using URIs.
* [react-native-transparent-bar ★16](https://github.com/23c/react-native-transparent-bar) - react native navigator transparent bar
* [react-native-email-chip ★8](https://github.com/arelstone/react-native-email-chip) - A simple yet customizable component to display a chip list of emails
* [react-native-invoke-app ★8](https://github.com/vicke4/react-native-invoke-app) - Bring React Native App to foreground from Headless JS
* [react-native-keyboard-sticky-view ★7](https://github.com/melihberberolu/React-Native-Keyboard-Sticky-View) - Keyboar Sticky View with animation and renderProps
* [sajjad-brick-list ★5](https://github.com/lvlrSajjad/sajjad-brick-list) - Staggered Or Masonary List View For React Native Written in pure js
* [react-native-router-sinux ★ ★4](https://github.com/jbpin/react-native-router-sinux) - React Native Router based on new NavigationExperimental that use Sinux as Flux implementation.
* [react-native-simple-slider ★3](https://github.com/NesChaiyapon/react-native-simple-slider) - This is a simple javascript slider component for react native
* [react-native-header-scroll-view ★3](https://github.com/jonsamp/react-native-header-scroll-view) - iOS-style large header scroll view.
* [react-native-navigation-buttons ★2](https://github.com/shayne/react-native-navigation-buttons) - iOS navigation buttons for the React Native Navigator
* [react-native-hotspot ★2](https://github.com/lawnstarter/react-native-hotspot) - A React Native component that displays hotspots over desired components to help lead your users through an onboarding flow or direct them towards new UI elements
* [react-native-pointer-interactions ★2](https://github.com/thefunbots/react-native-pointer-interactions) - Expose iPad mouse & trackpads interactions to React Native. 
* [react-native-yynavigator ★1](https://github.com/yiyangest/react-native-yynavigator) - custom navigation bar for react-native
* [react-native-telegraph ★1](https://github.com/robertherber/react-native-telegraph) - In-app message orchestration supporting Snackbars, Banners and Dialogs


#### Navigation/Routing Articles

* [Basics of using react-native-router-flux](https://medium.com/@spencer_carli/react-native-basics-using-react-native-router-flux-f11e5128aff9#.di5mvrbdr)
* [Routing and Navigation in React Native](http://blog.paracode.com/2016/01/05/routing-and-navigation-in-react-native/)
* [NavigatorIOS: Accessing onRightButtonPress from within child component](https://github.com/facebook/react-native/issues/31)

#### Navigation Demos

* [movieapp ★1441](https://github.com/JuneDomingo/movieapp) – Discover Movies and TV shows - it uses redux and wix/react-native-navigation
* [ExNavRelay ★23](https://github.com/sibelius/ExNavRelay) - React Native + Ex-navigation + Relay integration template
* [React Native Drawer & Bottom-Tab Navigation ★6](https://github.com/tassdr/react-native-template)
* [React Native Example App: Navigation](http://tech.taskrabbit.com/blog/2015/09/21/react-native-example-app/)

### Deep Linking

* [react-native-deep-link ★36](https://github.com/Starotitorov/react-native-deep-link) - React Native library to handle deep links

### Text & Rich Content

* [react-native-hyperlink ★354](https://github.com/obipawan/hyperlink) - A `<Hyperlink />` component for react-native that makes urls, fuzzy links, emails etc clickable and stylable
* [react-native-draftjs-render ★253](https://github.com/globocom/react-native-draftjs-render) - A React Native render for Draft.js model
* [react-native-html-to-pdf ★171](https://github.com/christopherdro/react-native-html-to-pdf) - Convert html strings to PDF documents using React Native
* [react-native-htmltext ★132](https://github.com/siuying/react-native-htmltext) - Use HTML like markup to create stylized text in react-native.
* [react-native-html-webview ★102](https://github.com/almost/react-native-html-webview) - Display (possibly untrusted) HTML using a UIWebView in React Native.
* [react-native-html-render ★98](https://github.com/soliury/react-native-html-render) - A html render for react-native
* [react-native-markdown-display ★57](https://github.com/iamacup/react-native-markdown-display/) - Highly customizable Markdown renderer using native components for all its elements without any web-view.
* [react-native-measure-text ★48](https://github.com/airamrguez/react-native-measure-text) - Measure text height without laying it out.
* [react-native-markdown-editor ★47](https://github.com/kunall17/react-native-markdown-editor) - Markdown editor like github comment editor (contains preview, markdown buttons)
* [react-native-showdown ★43](https://github.com/jerolimov/react-native-showdown) - React-native component which renders markdown into a webview!
* [react-native-file-viewer ★33](https://github.com/vinzscam/react-native-file-viewer) - Preview any type of file supported by the mobile device
* [react-native-responsive-fontsize ★22](https://github.com/heyman333/react-native-responsive-fontsize) - Provide responsive fontsize based on device height in React-Native
* [react-native-text-size ★21](https://github.com/aMarCruz/react-native-text-size) - Measure text accurately before laying it out and get font information from your App.
* [react-native-hypertext ★20](https://github.com/agentcooper/react-native-hypertext) - React Native module to render hypertext (text with links)
* [react-native-asciimage ★17](https://github.com/turley/react-native-asciimage) - An ASCIImage component for React Native
* [react-native-universal-modal ★16](https://github.com/bokuweb/react-native-universal-modal) - Universal simple modal component for React Native
* [react-native-html ★11](https://github.com/turingou/react-native-html) - render html as react native custom elements
* [react-native-responsive-fontsize ★83](https://github.com/heyman333/react-native-responsive-fontsize) - Provide responsive fontsize based on device height in React-Native
* [rn-pdf-reader-js ★6](https://github.com/xcarpentier/rn-pdf-reader-js/blob/master/README.md) - A PDF reader, in JavaScript only, for Expo, Android capable, PDF.JS
* [@typeskill/typer ★4](https://github.com/typeskill/typer) - The Operational-Transform Based (React) Native Rich Text Library

### Analytics

* [react-native-fabric ★1097](https://github.com/corymsmith/react-native-fabric) - A React Native library for Fabric, Crashlytics and Answers
* [react-native-google-analytics-bridge ★1071](https://github.com/idehub/react-native-google-analytics-bridge) - A native Google Analytics bridge for React Native. Uses the official libraries on both iOS and Android.
* [react-native-google-analytics ★325](https://github.com/lwansbrough/react-native-google-analytics) - Google Analytics for React Native!
* [react-native-mixpanel ★307](https://github.com/davodesign84/react-native-mixpanel) - A React Native wrapper for Mixpanel tracking
* [react-native-ab ★160](https://github.com/lwansbrough/react-native-ab) - A component for rendering A/B tests in React Native
* [react-native-segment-io-analytics ★68](https://github.com/smore-inc/react-native-segment-io-analytics) - A React Native Segment wrapper!
* [react-native-ux-cam ★32](https://github.com/negativetwelve/react-native-ux-cam) - React Native wrapper for uxcam.com.
* [react-native-td ★26](https://github.com/quipper/react-native-td) - An unofficial React Native SDK for Treasure Data.
* [react-native-flurry-sdk ★15](https://github.com/flurry/react-native-flurry-sdk) - Official React Native wrapper for Flurry SDK. Supports Android, iOS and tvOS.

### Utils & Infra

* [detox ★3566](https://github.com/wix/detox) - Graybox End-to-End (functional) Tests and Automation Library for Mobile with first class support for React Native
* [react-native-workers ★616](https://github.com/devfd/react-native-workers) - Background services and web workers for react-native
* [react-native-mock ★504](https://github.com/RealOrangeOne/react-native-mock) - A fully mocked and test-friendly version of react native
* [loki ★395](https://github.com/oblador/loki) - Visual Regression Testing for Storybook
* [react-native-slowlog ★271](https://github.com/jondot/react-native-slowlog) - A high-performance timer based profiler for React Native that helps you track big performance problems
* [react-native-zip-archive ★173](https://github.com/plrthink/react-native-zip-archive) - Zip / Unzip archive utility
* [react-native-tips ★160](https://github.com/frichti/react-native-tips) - This module is used to create easily some tips to help your new users to understand how works your app.
* [codemod-RN24-to-RN25 ★104](https://github.com/sibeliusseraphini/codemod-RN24-to-RN25) - a simple codemod to handle the new import style on >=RN25
* [react-native-linkedin ★101](https://github.com/xcarpentier/react-native-linkedin) React-Native LinkedIn, a simple LinkedIn login library for React-Native or Expo with WebView and Modal
* [react-native-eval ★75](https://github.com/artemyarulin/react-native-eval) - Call any JS functions from your native code
* [react-native-device-log ★73](https://github.com/olofd/react-native-device-log) - A UI and service for displaying dev-logs on devices.
* [react-native-call-detection ★73](https://github.com/priteshrnandgaonkar/react-native-call-detection) - Helps to detect different call states like Incoming, Disconnected, Dialing and Connected
* [react-native-userdefaults-ios ★66](https://github.com/dsibiski/react-native-userdefaults-ios) - React Native Module for NSUserDefaults
* [react-native-webp ★56](https://github.com/dbasedow/react-native-webp) - react-native-webp adds support for WebP images for react-native components.
* [react-native-global-event-emitter ★50](https://github.com/paramaggarwal/react-native-global-event-emitter) - Shared event emitter between native and JS for React Native.
* [react-native-user-defaults ★48](https://github.com/wwayne/react-native-user-defaults) - ios UserDefaults used by react-native
* [react-native-console-time-polyfill ★45](https://github.com/MaxGraey/react-native-console-time-polyfill) - console.time and console.timeEnd polyfill for react-native
* [react-native-aws-signature ★42](https://github.com/leimd/react-native-aws-signature) - help generate signature required for using AWS API. Necessary to use S3, ec2, or other services.
* [react-native-rsa ★41](https://github.com/z-hao-wang/react-native-rsa) - RSA crypto lib for react native
* [react-native-html-parser ★38](https://github.com/g6ling/react-native-html-parser) - parse html in react-native
* [pixels-catcher ★26](https://github.com/rumax/react-native-PixelsCatcher) - Library for testing React Native UI components and screens
* [react-native-aes ★24](https://github.com/mvayngrib/react-native-aes) - AES in react-native
* [react-native-network-logger ★20](https://github.com/alexbrazier/react-native-network-logger) - An HTTP network request monitor for React Native including an in-app interface.
* [eslint-config-kingstinct-react-native ★23](https://github.com/robertherber/eslint-config-kingstinct-react-native) - Opinionated ESLint configurarition for React Native and TypeScript
* [react-native-hour-format ★20](https://github.com/SoftwareMansion/react-native-hour-format) - Get hour format from OS settings.
* [react-native-des ★20](https://github.com/remobile/react-native-des) - A des crypto for react-native
* [react-native-babel-jest ★15](https://github.com/apentle/react-native-babel-jest) - Simple testing configuration for React Native with Jest
* [react-native-simple-encryption ★14](https://github.com/BhavanPatel/react-native-simple-encryption) - Simple XOR and base_64 encryption decryption for react-native
* [react-native-immutable ★12](https://github.com/thewei/react-native-immutable) - using immutable.js library with react-native
* [react-native-util ★12](https://github.com/exponentjs/react-native-util) - A fork of io.js's util module that works with React Native
* [react-native-referrer ★11](https://github.com/JeandeCampredon/react-native-referrer) - React Native android only library to retrieve campaign referrer.
* [react-native-webpackager-server ★6](https://github.com/changfuguo/react-native-webpackager-server) - react native webpackager server
* [react-native-crypto ★6](https://github.com/mvayngrib/react-native-crypto) - implementation of crypto for React Native
* [react-native-fluxbone ★5](https://github.com/jgable/react-native-fluxbone) - A group of libraries that help with the FluxBone pattern in React Native
* [react-native-cross-settings ★5](https://github.com/aMarCruz/react-native-cross-settings) - React Native Settings module for both Android & iOS.
* [react-native-HsvToRgb ★3](https://github.com/Copypeng/react-native-HsvToRgb) - a helper to convert HSV(HSB) color to RGB.
* [react-native-use-persist-storage ★3](https://github.com/visuallylab/react-native-use-persist-storage) - Persist and rehydrate your context(state) using React Hooks
* [react-native-tools ★0](https://github.com/kkennis/react-native-tools) - Tools for react native project development
* [react-native-call-observer](https://github.com/liamse/react-native-call-observer) - Helps to observe call status like incoming, ended, and connected (iOS).
* [react-native-iphone-se-helper ★0](https://github.com/heyman333/react-native-iphone-se-helper) - utils for developing iphone SE size.
* [react-native-native-log ★0](https://github.com/JessicaYeh/react-native-native-log) - A React Native log function that under the hood calls native logs.
* [react-native-mov-to-mp4 ★44](https://github.com/taltultc/react-native-mov-to-mp4) - utils for Converting mov file to mp4 for cross-platform playback compatibility.
* [react-native-test-runner ★1](https://github.com/acostalima/react-native-test-runner) - Run unit and integration tests in React Native's environment.

### Forms

* [formik ★10633](https://github.com/jaredpalmer/formik) - Forms in React, without tears.
* [react-hook-form ★9346](https://github.com/react-hook-form/react-hook-form) - React hooks for forms validation without the hassle.
* [redux-form ★4829](http://redux-form.com) - Redux form state management (Web and Native)
* [redux-hook-form ★2700](https://github.com/react-hook-form/react-hook-form) - React hooks for form validation without the hassle. (Web and Native)
* [tcomb-form-native ★2831](https://github.com/gcanti/tcomb-form-native) - Generate React Native forms
* [react-native-gifted-form ★1317](https://github.com/FaridSafi/react-native-gifted-form) - Form component for react-native
* [react-native-clean-form ★414](https://github.com/esbenp/react-native-clean-form) - Good looking form elements with redux-form integration. Stylable with styled-components.
* [react-native-form-generator ★354](https://github.com/MichaelCereda/react-native-form-generator) - Generate amazing React Native forms in a breeze
* [react-native-form ★138](https://github.com/julianocomg/react-native-form) - A simple react-native component to wrap your form fields!
* [react-reactive-forms ★106](https://github.com/bietkul/react-reactive-form) - Angular like reactive forms in React.
* [react-native-forms ★86](https://github.com/michaelhelvey/react-native-forms) - A declarative API for creating, validating, and serializing native-looking forms.
* [react-native-formawesome](https://github.com/MAKARD/react-native-formawesome) - Complex and simple forms builder.
* [react-native-from-builder ★69](https://github.com/bietkul/react-native-form-builder) - Handle your forms in a smart way.
* [foect ★37](https://github.com/unexge/foect) - Simple form validation library for React Native
* [react-native-fm-form ★13](https://github.com/peter4k/react-native-fm-form) - Generate list view form of React Native in few line of codes
* [react-native-form-flux ★2](https://github.com/aksonov/react-native-form-flux) - React Native Form management using Flux architecture
* [react-native-form-validator ★0](https://github.com/srfaytkn/react-native-form-validator) - A simple validation library for react native

### Geolocation

* [react-native-background-geolocation ★1316](https://github.com/transistorsoft/react-native-background-geolocation) - Sophisticated cross-platform background location-tracking & geofencing module with battery-conscious motion-detection intelligence (Android requires paid license).
* [react-native-mauron85-background-geolocation ★657](https://github.com/mauron85/react-native-background-geolocation) - React Native Android and iOS module for background and foreground geolocation with battery-saving "circular region monitoring" and "stop detection"
* [react-native-geocoder ★344](https://github.com/devfd/react-native-geocoder) - react native geocoding and reverse geocoding
* [react-native-geo-fencing ★100](https://github.com/surialabs/react-native-geo-fencing) - Native modules to determine if a location is within defined geographical boundaries using Google Geometry library
* [react-native-fused-location ★82](https://github.com/MustansirZia/react-native-fused-location) - Finest location for react-native on Android using the new Fused API.
* [react-native-android-geolocation ★19](https://github.com/garysye/react-native-android-geolocation) - React Native Module to use Android Geolocation via Google Play API
* [react-native-reverse-geo ★18](https://github.com/aaronksaunders/react-native-reverse-geo) - React Native module bridge to convert address to geo coordinates.
* [react-native-boundary ★12](https://github.com/eddieowens/react-native-boundary) - React Native module to use geofences. Native implementation for iOS and Android.
* [react-native-geolocation-android ★3](https://github.com/lxsameer/react-native-geolocation-android) - Geolocation module for react native android

### Internationalization

* [fbt ★3202](https://github.com/facebookincubator/fbt) - A JavaScript Internationalization Framework
* [react-native-localize ★603](https://github.com/react-native-community/react-native-localize) - React Native Localize
* [react-native-globalize ★192](https://github.com/joshswan/react-native-globalize) - Globalization helper for React Native

* [redux-react-native-i18n ★40](https://github.com/derzunov/redux-react-native-i18n) - An i18n solution for React Native apps on Redux
* [react-native-intl ★37](https://github.com/taggon/react-native-intl) - React Native module shipped native Intl implementation and Translation extension
* [rn-translate-template ★18](https://github.com/hiaw/rn-translate-template) - I18n template for all iOS and Android supported languages
* ~~[react-native-i18n ★1778](https://github.com/AlexanderZaytsev/react-native-i18n) - React Native + i18n.js~~ Deprecated for react-native-localize
* ~~[react-native-languages ★246](https://github.com/react-community/react-native-languages) - React Native properties and methods related to the language of the device~~ Now called react-native-localize

### Build & Development

* [reactotron ★9198](https://github.com/skellock/reactotron) - Control, monitor, and instrument your React Native apps from the comfort of your terminal.
* [react-native-code-push ★5184](https://github.com/Microsoft/react-native-code-push) - React Native plugin for the CodePush service
* [react-native-webpack-server ★935](https://github.com/mjohnston/react-native-webpack-server) - Build React Native apps with Webpack
* [generator-rn-toolbox ★800](https://github.com/bamlab/generator-rn-toolbox) - Yeoman generators to kickstart your project and setup continuous deployment.
* [babel-preset-react-native-stage-0 ★97](https://github.com/skevy/babel-preset-react-native-stage-0) - a Babel preset with latest Javascript goodies
* [react-native-debug-stylesheet ★75](https://github.com/brentvatne/react-native-debug-stylesheet) - Add coloured borders or backgrounds to all views to make it easier to debug layout issues
* [react-native-console-panel ★73](https://github.com/sospartan/react-native-console-panel) - react native component for display console messages.
* [react-native-css-loader ★39](https://github.com/thewei/react-native-css-loader) - You can use react-native-css-loader with react-native-webpack-server, which can use webpack to built react-native app better.
* [react-native-assets ★31](https://github.com/llanox/react-native-assests) - Module to manage assets. It allows you download assets from a network and store into a specific local folder on iOS
* [react-native-cosmos ★18](https://github.com/jerolimov/react-native-cosmos) - DX tool to test react-native components with defined props/state fixtures.
* [react-native-kill-packager ★15](https://github.com/livioso/react-native-kill-packager) - kill running react native packager.
* [react-native-build-cli ★3](https://github.com/adonpro/react-native-build-cli) - a cli tool for react-native build
* [react-native-react-bridge](https://github.com/inokawa/react-native-react-bridge) - A toolset to run React web app in React Native and handle communication between them.

### Styling

* [styled-components ★20064](https://github.com/styled-components/styled-components) - Style React and React Native with utilising tagged template literals.
* [emotion ★5627](https://github.com/emotion-js/emotion) - Style as a function of state.
* [react-native-extended-stylesheet ★1689](https://github.com/vitalets/react-native-extended-stylesheet) - Extend React Native stylesheet with variables, relative units, percents, math operations, scaling and other stuff.
* [react-native-css ★755](https://github.com/sabeurthabti/react-native-css) - Style React-Native components with css and built in support for SASS.
* [react-native-style-tachyons ★525](https://github.com/tachyons-css/react-native-style-tachyons) - functional, maintainable design for everyone based on tachyons.css.
* [glamorous-native ★454](https://github.com/robinpowered/glamorous-native) - A React Native version of glamorous - a component styling library.
* [react-native-responsive ★295](https://github.com/ayoubdev/react-native-responsive) - The power of Media Queries now in your React Native project (ios and android) ! Responsive Design can now be easily managed !
* [cairn ★110](https://github.com/adamterlson/cairn) - Simple, string-based style selector engine with support for basic inheritance.
* [react-native-theme ★104](https://github.com/apentle/react-native-theme) - Theme manager for react native project!
* [react-native-css-modules ★44](https://github.com/kristerkari/react-native-css-modules) - Style React-Native components using CSS, Sass, Less or Stylus.
* [rn-less ★15](https://github.com/blackmiaool/rn-less) - Style react-native with less (with VS Code extension support)
* [react-native-prism ★10](https://github.com/tmpfs/prism) - Minimal, idiomatic style management for React Native
* [react-native-paint ★5](https://github.com/brankeye/react-native-paint) - A themeable abstraction over React Native StyleSheet. Read about it [here](https://medium.com/@brankeye/making-easily-themeable-react-native-stylesheets-bd8782b4e685).
* [binstorm ★5](https://github.com/binbytes/binstorm) - BinStorm is a React Native styling utility for rapidly building custom user interfaces. Read about it [here](https://docs-binstorm.binbytes.com/).
* [styled-react-native](https://github.com/jsifalda/styled-react-native) - Advanced react native styling with simple method (style overwrites, component composition, enhanced style property). Full intro in [this Medium article](https://medium.com/@JSifalda/advanced-react-native-styling-with-a-few-lines-of-code-4b6a94385015).
* [react-native-tailwindcss](https://github.com/TVke/react-native-tailwindcss) - A react native styling system based on TailwindCSS.

### System

* [react-native-firebase ★4192](https://github.com/invertase/react-native-firebase) - A well tested feature rich Firebase implementation for React Native, supporting both iOS & Android platforms for 10+ Firebase modules (including Cloud Firestore).
* [react-native-push-notification ★3431](https://github.com/zo0r/react-native-push-notification) - React Native Local and Remote Notifications
* [react-native-device-info ★3145](https://github.com/rebeccahughes/react-native-device-info) - Get device information using react-native
* [react-native-fs ★2465](https://github.com/johanneslumpe/react-native-fs) - Native filesystem access for react-native
* [react-native-config ★1894](https://github.com/luggit/react-native-config) - Config variables for React Native apps
* [react-native-ultimate-config](https://github.com/maxkomarychev/react-native-ultimate-config) - Configure all levels of your react-native app with a single file
* [react-native-fcm ★1564](https://github.com/evollu/react-native-fcm) - react native module for firebase cloud messaging and local notification
* [react-native-notifications ★1396](https://github.com/wix/react-native-notifications) - React native notifications
* [react-native-arkit ★1290](https://github.com/HippoAR/react-native-arkit) - React Native binding for iOS ARKit
* [react-native-permissions ★1118](https://github.com/yonahforst/react-native-permissions) - Check and request all permissions with a single api
* [react-native-keychain ★992](https://github.com/oblador/react-native-keychain) - Keychain Access for React Native
* [react-native-touch-id ★902](https://github.com/naoufal/react-native-touch-id) - React Native authentication with the native Touch ID popup.
* [react-native-contacts ★882](https://github.com/rt2zz/react-native-contacts) - React Native Contacts (android & ios)
* [react-native-communications ★871](https://github.com/anarchicknight/react-native-communications) - Easily call, email, text or iMessage someone in React Native
* [react-native-onesignal ★871](https://github.com/geektimecoil/react-native-onesignal) - React Native Library for OneSignal Push Notifications Service (iOS + Android)
* [react-native-in-app-utils ★743](https://github.com/chirag04/react-native-in-app-utils) - A react-native wrapper for handling in-app payments.
* [react-native-image-resizer ★636](https://github.com/bamlab/react-native-image-resizer) - Rescale local image files with React Native.
* [react-native-quick-actions ★593](https://github.com/madriska/react-native-quick-actions) - A react-native interface for 3D Touch home screen quick actions
* [react-native-billing ★534](https://github.com/idehub/react-native-billing) - In-app purchase implementation for React Native on Android.
* [react-native-barcodescanner ★491](https://github.com/ideacreation/react-native-barcodescanner) - A barcode scanner component for react native - not maintained anymore - use react-native-camera.
* [react-native-iap ★450](https://github.com/dooboolab/react-native-iap) - React-native native module for In-App Purchase.
* [react-native-dotenv ★450](https://github.com/zetachang/react-native-dotenv) - A Babel preset let you import application configs from .env file (zero runtime dependency)
* [react-native-location ★425](https://github.com/timfpark/react-native-location) - Native GPS location support for React Native.
* [react-native-background-fetch ★373](https://github.com/transistorsoft/react-native-background-fetch) - iOS BackgroundFetch API implementation. Awakens a suspended iOS app in the background to execute a `callbackFn` about every 15 min.
* [react-native-queue ★359](https://github.com/billmalarky/react-native-queue) - Your swiss army knife for task management in React Native - easily manage background tasks that run periodically when app is closed and dedicated worker threads.
* [react-native-sensors ★355](https://github.com/react-native-sensors/react-native-sensors) - Platform independent wrapper for sensors like Gyroscope, Accelerometer and Magnetometer with RxJS interface
* [react-native-social-share ★347](https://github.com/doefler/react-native-social-share) - Use the iOS native Twitter and Facebook share view from react native
* [react-native-ibeacon ★334](https://github.com/geniuxconsulting/react-native-ibeacon) - iBeacon support for React Native. The API is very similar to the CoreLocation Objective-C one with the only major difference that regions are plain JavaScript objects. Beacons don't work in the iOS simulator.
* [react-native-lock-ios ★291](https://github.com/auth0/react-native-lock-ios) - Auth0 Lock for React Native (iOS)
* [react-native-motion-manager ★223](https://github.com/pwmckenna/react-native-motion-manager) - A react-native interface for using the Gyroscope, Accelerometer and Magnetometer
* [react-native-android-sms-listener ★194](https://github.com/CentaurWarchief/react-native-android-sms-listener) - Allows you to listen for incoming SMS messages
* [react-native-device ★185](https://github.com/GertjanReynaert/react-native-device) - UIDevice wrapper for React Native
* [react-native-gcm-android ★174](https://github.com/oney/react-native-gcm-android) - GCM for Android
* [react-native-sensor-manager ★172](https://github.com/kprimice/react-native-sensor-manager) - Wrapper for react-native providing native sensors access. (Gyroscope, accelerometer, magnetometer, thermometer...)
* [react-native-ble ★157](https://github.com/jacobrosenthal/react-native-ble) - React Native BLE using noble api surface
* [react-native-haptic ★137](https://github.com/charlesvinette/react-native-haptic) - iOS 10 + haptic feedback for React Native applications
* [react-native-pinch ★130](https://github.com/localz/react-native-pinch) - SSL pinning for react native
* [react-native-unified-contacts ★120](https://github.com/joshuapinter/react-native-unified-contacts) - React Native iOS 9+ Contacts (ios)
* [react-native-callkit ★94](https://github.com/ianlin/react-native-callkit) - iOS 10 CallKit framework for React Native
* [react-native-discovery ★89](https://github.com/yonahforst/react-native-discovery) - Discover nearby devics using BLE. Turn iOS and Android devices into beacons
* [react-native-passcode-auth ★87](https://github.com/naoufal/react-native-passcode-auth) - React Native authentication with iOS Passcode.
* [react-native-addressbook ★81](https://github.com/rt2zz/react-native-addressbook) - AddressBook module for react-native
* [react-native-fingerprint-identify ★79](https://github.com/williamtran29/react-native-fingerprint-identify) - React Native authentication with the Fingerprint on Android, fingerprint API compatible lib, which also combines Samsung, Xiaomi and MeiZu's official Fingerprint API.
* [react-native-phone-call ★76](https://github.com/tiaanduplessis/react-native-phone-call) - A simple way to initiate a phone call in React Native
* [react-native-calendar-reminders ★69](https://github.com/wmcmahan/React-Native-CalendarReminders) - React Native module for IOS EventKit Reminders
* [react-native-bluetooth-state ★61](https://github.com/frostney/react-native-bluetooth-state) - Answering the question of "Is my bluetooth on?" in React Native
* [react-native-google-nearby-messages ★14](https://github.com/mrousavy/react-native-google-nearby-messages) - Communicate with nearby devices using Bluetooth, BLE, WiFi and near-ultrasonic audio by using the Google Nearby Messages API
* [react-native-barcode-scanner ★60](https://github.com/lifuzu/ReactNativeBarcodeScanner) - Barcode scanner for React Native
* [react-native-haptic-feedback ★60](https://github.com/mkuczera/react-native-haptic-feedback) - Trigger Haptic Native Feedback on iOS and Android
* [react-native-clipboard ★58](https://github.com/silentcloud/react-native-clipboard) - React Native component for getting or setting clipboard content
* [react-native-media-clipboard](https://github.com/Jarred-Sumner/react-native-media-clipboard) - React Native module for getting images, URLs, and strings from the clipboard
* [react-native-nfc-ios ★52](https://github.com/barodeur/react-native-nfc-ios) - Easy to use CoreNFC for React Native
* [react-native-android-sms ★48](https://github.com/msmakhlouf/react-native-android-sms) - A react native android module to list/send sms.
* [react-native-voip-push-notification ★48](https://github.com/ianlin/react-native-voip-push-notification) - iOS prioritized VoIP Push Notification
* [react-native-android-speech ★47](https://github.com/mihirsoni/react-native-android-speech) - A text-to-speech library for Android React Native.
* [react-native-app-info ★42](https://github.com/Iragne/react-native-app-info) - React Native app info and version
* [react-native-icloud-sync ★41](https://github.com/chirag04/react-native-icloud-sync) - A react-native wrapper for syncing with icloud
* [react-native-carrier-info ★41](https://github.com/anarchicknight/react-native-carrier-info) - React Native module bridge to obtain information about the user’s home cellular service provider.
* [react-native-sms-android ★40](https://github.com/rhaker/react-native-sms-android) - A react-native module for sending a sms message to a phone number.
* [react-native-touch-id-android ★32](https://github.com/ElekenAgency/react-native-touch-id-android) - React Native authentication with the Fingerprint on Android.
* [react-native-heading ★31](https://github.com/yonahforst/react-native-heading) - Get device heading (compass) information on iOS or Android
* [react-native-battery ★30](https://github.com/oojr/react-native-battery) - A React Native module that returns the battery level/status of a device
* [react-native-device-battery ★30](https://github.com/robinpowered/react-native-device-battery) - Observe battery state changes in your react native application
* [react-native-device-motion ★29](https://github.com/paramaggarwal/react-native-device-motion) - iOS device motion wrapper for React Native.
* [react-native-wifi-manager ★29](https://github.com/skierkowski/react-native-wifi-manager) - Wifi Connection Manager for React Native on Android
* [react-native-android-sqlite ★28](https://github.com/jbrodriguez/react-native-android-sqlite) - A react native android wrapper for SQLite
* [react-native-search-api ★27](https://github.com/ombori/react-native-search-api) - The SearchApi module gives you a general React Native interface to interact with the iOS Search API, Core Spotlight.
* [react-native-ssl-pinning ★20](https://github.com/MaxToyberman/react-native-ssl-pinning) - React Native SSL pinning using OkHttp 3 on Android, and AFNetworking on iOS
* [react-native-localsearch ★17](https://github.com/wmcmahan/React-Native-LocalSearch) - React Native Module for MapKit Local Search
* [rn-secure-storage ★17](https://github.com/talut/rn-secure-storage) - Secure Storage for React Native (Android & iOS)
* [react-native-contacts-rx ★14](https://github.com/JeanLebrument/react-native-contacts-rx) - react-native-contacts counterpart that include the support of RxJS.
* [react-native-mipush ★13](https://github.com/cpunion/react-native-mipush) - MiPush for React Native
* [react-native-device-angles ★12](https://github.com/cristianszwarc/RNDeviceAngles) - Get rotation information in degrees (pitch, yaw, roll) - ios
* [react-native-detect-device ★11](https://github.com/peachmeco/react-native-detect-device) - Detect a device on iOS or android in react-native.
* [react-native-battery-status ★11](https://github.com/remobile/react-native-battery-status) - A battery-status for react-native
* [react-native-system-notification ★10](https://github.com/Neson/react-native-system-notification) - Notification for React Native
* [react-native-home-pressed ★8](https://github.com/evanjmg/react-native-home-pressed) - Listen to home and recent app events for Android
* [react-native-lock-android ★7](https://github.com/auth0/react-native-lock-android) - Auth0 Lock for React Native (Android)
* [react-native-push-with-gcm ★6](https://github.com/lilach/react-native-push-with-gcm) - Register device for GCM push notifications services (supported only for iOS)
* [react-native-device-info-pod ★3](https://github.com/mchinyakov/react-native-device-info) - Get device information using react-native
* [react-native-sms-retriever](https://github.com/Bruno-Furtado/react-native-sms-retriever) - SMS Retriever API (Android).
* [react-native-background-downloader ★93](https://github.com/EkoLabs/react-native-background-downloader) - Help you download large files on iOS and Android both in the foreground and most importantly in the background.
* [rn-in-app-review](https://github.com/ravirupareliya/rn-in-app-review) - Help you to integrate in-app review for android and iOS
* [react-native-system-setting](https://github.com/c19354837/react-native-system-setting)- Provides some system setting APIs iOS and Android.

### Web

* [react-native-webrtc ★1805](https://github.com/oney/react-native-webrtc) - A WebRTC module for React Native.
* [react-native-webview-bridge ★1112](https://github.com/alinz/react-native-webview-bridge) - React Native WebView Javascript Bridge
* [react-native-safari-view ★387](https://github.com/naoufal/react-native-safari-view) - A React Native wrapper for Safari View Controller
* [react-native-webview-android ★305](https://github.com/lucasferreira/react-native-webview-android) - Simple React Native Android module to use Android's WebView inside your app
* [react-native-for-web ★247](https://github.com/KodersLab/react-native-for-web) - A set of classes and react components to make work your react-native app in a browser. (with some limitations obviously)
* [react-native-browser ★107](https://github.com/PrestoDoctor/react-native-browser) - Full-featured web browser module for React Native apps, based on TOWebViewController
* [react-native-webview-crosswalk ★88](https://github.com/jordansexton/react-native-webview-crosswalk) - Crosswalk's WebView for React Native on Android
* [react-native-turbolinks ★72](https://github.com/lazaronixon/react-native-turbolinks) - React Native adapter for building hybrid apps with Turbolinks 5
* [react-native-webintent ★53](https://github.com/ivanph/react-native-webintent) - React native android module to open links in the default browser
* [react-native-web-container ★36](https://github.com/danrigsby/react-native-web-container) - A wrapper around the react native WebView to add autoHeight, scrub html, etc
* [react-native-inappbrowser-reborn ★30](https://github.com/proyecto26/react-native-inappbrowser) - InAppBrowser for React Native (Android & iOS)
* [react-native-browser-polyfill ★29](https://github.com/johanneslumpe/react-native-browser-polyfill) - A collection of polyfills for the react-native Javascript environment.
* [react-native-cookiemanager ★19](https://github.com/beefe/react-native-cookiemanager) - react-native cookie manager library.
* [react-native-bridgeable-webview ★16](https://github.com/Intellicode/react-native-bridgeable-webview) - A react-native webview with bridge to react-native code
* [react-native-html2native ★3](https://github.com/labithiotis/react-native-html-render) - A html render for react-native
* [react-native-webview ★3](https://github.com/beefe/react-native-webview) - android webview for react-native

### Media

* [react-native-camera ★6227](https://github.com/lwansbrough/react-native-camera) - Camera component
* [react-native-video ★3470](https://github.com/brentvatne/react-native-video) - A Video component for react-native
* [react-native-sound ★1556](https://github.com/zmxv/react-native-sound) - React Native module for playing sound clips
* [react-native-audio ★798](https://github.com/jsierles/react-native-audio) - Record and play back audio in your iOS or Android React Native apps. (no longer maintained)
* [react-native-audio-toolkit ★764](https://github.com/react-native-community/react-native-audio-toolkit) - Audio playback and recording for react-native. In addition to basic functionality, many useful features are implemented such as seeking, looping and streaming audio files over the network.
* [react-native-camera-kit ★701](https://github.com/wix/react-native-camera-kit) - Advanced native camera and gallery components and device photos API.
* [react-native-audio-streaming ★679](https://github.com/tlenclos/react-native-audio-streaming) - iOS & Android module to play an audio stream, with background support and media controls :speaker:
* [react-native-video-processing ★712](https://github.com/shahen94/react-native-video-processing) - Native Video editing/trimming/filtering library for React-Native
* [react-native-track-player ★441](https://github.com/react-native-kit/react-native-track-player) - A fully fledged audio module created for music apps. Provides audio playback, external media controls, chromecast support and background mode for Android, iOS and Windows.
* [react-native-music-control](https://github.com/tanguyantoine/react-native-music-control/) - React Native module to display Now playing Info on lockscreen and handle control events
* [react-native-camera-roll-picker ★312](https://github.com/jeanpan/react-native-camera-roll-picker) - A React Native component providing images selection from camera roll
* [react-native-incall-manager ★272](https://github.com/zxcpoiu/react-native-incall-manager) - Handling media-routes/sensors/events during a audio/video chat like webrtc
* [react-native-speech ★246](https://github.com/naoufal/react-native-speech) - A text-to-speech library for React Native.
* [react-native-screcorder ★214](https://github.com/maxs15/react-native-screcorder) - Capture pictures and record Video with Vine-like tap to record
* [react-native-photos-framework ★154](https://github.com/olofd/react-native-photos-framework) - A modern and comprehensive CameraRoll/iCloud-library for React Native
* [react-native-audioplayer ★99](https://github.com/andreaskeller/react-native-audioplayer) - Small audio player library for react native
* [react-native-player ★81](https://github.com/xeodou/react-native-player) - Media player for react-native
* [react-native-vlc-player ★80](https://github.com/ghondar/react-native-vlc-player) - VLC Player for react-native
* [react-native-volume-slider ★69](https://github.com/IFours/react-native-volume-slider) - React Native VolumeView component
* [react-native-sound-demo ★63](https://github.com/zmxv/react-native-sound-demo) - react-native-sound demo project
* [react-native-interactive-image-gallery ★60](https://github.com/InterfaceKit/react-native-interactive-image-gallery) - A React Native component to display a gallery of images.
* [react-native-color-grabber ★57](https://github.com/bsudekum/react-native-color-grabber) - React native component for finding dominant colors in an image
* [react-native-hue-player ★43](https://github.com/App2Sales/react-native-hue-player) - Audio Player to offline/local and online/streaming audio.
* [react-native-media-meta ★41](https://github.com/mybigday/react-native-media-meta) - Get media file metadata in your React Native app
* [react-native-sound-recorder ★41](https://github.com/kevinresol/react-native-sound-recorder) - No-hassle Sound Recorder for React Native.
* [react-native-fullscreen-video ★39](https://github.com/mostafa/react-native-fullscreen-video) - A full-screen video component on top of react-native-video
* [react-native-android-audio-streaming-aac ★25](https://github.com/EstebanFuentealba/react-native-android-audio-streaming-aac) - A react native streaming player
* [react-native-photoeditorsdk ★24](https://github.com/imgly/pesdk-react-native) - React Native module for [PhotoEditor SDK](https://www.photoeditorsdk.com) (Android & iOS)
* [react-native-videoeditorsdk ★18](https://github.com/imgly/vesdk-react-native) - React Native module for [VideoEditor SDK](https://www.videoeditorsdk.com) (Android & iOS)
* [react-native-true-sight ★18](https://github.com/ScreamZ/react-native-true-sight) - A cross-platform video player with customizable controls for React Native.
* [react-native-audio-manager ★15](https://github.com/Tricy/react-native-audio-manager) - Audio player library for react native Android
* [react-native-safe-image ★13](https://github.com/xcarpentier/react-native-safe-image) - Really light React-Native package to handle fallback when image is on error
* [react-native-audio-player ★12](https://github.com/sh3rawi/react-native-audio-player) - A React Native module to play audio on Android
* [react-native-mediaplayer ★12](https://github.com/chriselly/react-native-mediaplayer) - Simple full screen media player for React Native.
* [react-native-simple-sound ★11](https://github.com/mikehedman/react-native-simple-sound) - Start, stop, and pause a sound. iOS only. Derived from `react-native-sound`
* [react-native-tone ★7](https://github.com/oliviachang29/react-native-tone) - Generates simple sine wave, specify a frequency and amplitude. Play sound indefinitely or for a specified time interval (iOS only).
* [react-native-media-capture ★6](https://github.com/remobile/react-native-media-capture) - A media-capture for react-native
* [react-native-android-video ★8](https://github.com/Cherrypick-Consulting/react-native-android-video) - Android ExoPlayer Video component for react-native.
* [react-native-airplay-button](https://github.com/CBCNewMedia/react-native-airplay-button) - Native iOS Airplay button component

### Storage

* [RxDB ★12797](https://github.com/pubkey/rxdb) - A realtime Database for JavaScript Applications.
* [WatermelonDB ★4649](https://github.com/Nozbe/WatermelonDB) - 🍉 Next-gen database for powerful React and React Native apps that scales to 10,000s of records and remains fast.
* [realm ★3184](https://github.com/realm/realm-js) - An alternative mobile database to SQLite & key-value stores.
* [react-native-storage ★2115](https://github.com/sunnylqm/react-native-storage) - This is a local storage wrapper for both react-native(AsyncStorage) and browser(localStorage). ES6/babel is needed.
* [react-native-sqlite-storage ★1508](https://github.com/andpor/react-native-sqlite-storage) - SQLite3 bindings for React Native (Android & iOS)
* [react-native-simple-store ★731](https://github.com/jasonmerino/react-native-simple-store) - A minimalistic wrapper around React Native's AsyncStorage.
* [react-native-store ★561](https://github.com/thewei/react-native-store) - A simple database base on react-native AsyncStorage.
* [react-native-db-models ★168](https://github.com/darkrishabh/react-native-db-models) - Local DB Models for React Native Apps
* [react-native-sqlite-2 ★106](https://github.com/noradaiko/react-native-sqlite-2) - SQLite3 Native Plugin for React Native for both Android and iOS
* [react-native-couchbase-lite ★105](https://github.com/fraserxu/react-native-couchbase-lite) - couchbase lite binding for react-native
* [react-native-persistent-job ★72](https://github.com/Gabrn/react-native-persistent-job) - Run async tasks that retry after a crash, connection loss or exception
* [pouchdb-adapter-react-native-sqlite ★49](https://github.com/noradaiko/pouchdb-adapter-react-native-sqlite) - PouchDB adapter using ReactNative SQLite as its backing store
* [react-native-pouchdb ★38](https://github.com/carbureted/react-native-pouchdb) - Run pouchdb in React Native!
* [react-native-level-fs ★20](https://github.com/tradle/react-native-level-fs) - fs for react-native using level-filesystem and asyncstorage-down
* [react-native-mongoose ★17](https://github.com/remobile/react-native-mongoose) - A AsyncStorage based mongoose like storage for react-native
* [react-native-leveldown](https://github.com/andymatuschak/react-native-leveldown) - Native LevelDB bindings for React Native
* [typed-async-storage](https://github.com/artxty/typed-async-storage) - A wrapper for creating a schema for AsyncStorage and validation using React prop-types.

### Backend

* [react-native-fetch-blob ★2299](https://github.com/wkh237/react-native-fetch-blob) - A module integrates network and file system. Supports file stream.
* [reactivesearch-native ★1218](https://github.com/appbaseio/reactivesearch/tree/dev/packages/native) - appbase.io and Elasticsearch UI components for React Native.
* [react-native-meteor ★673](https://github.com/inProgress-team/react-native-meteor) - Full Meteor Client
* [aws-sdk-react-native ★650](https://github.com/awslabs/aws-sdk-react-native) - AWS SDK for React Native (Official developer preview)
* [react-native-simple-auth ★592](https://github.com/adamjmcgrath/react-native-simple-auth) - Native social authentication for React Native on iOS
* [react-native-uploader ★455](https://github.com/aroth/react-native-uploader) - A React Native module to upload files and camera roll assets. Supports progress notification.
* [react-native-lazyload ★342](https://github.com/magicismight/react-native-lazyload) - lazyload for react native
* [react-native-aws3 ★293](https://github.com/benjreinhart/react-native-aws3) - Pure JavaScript React Native library for uploading to AWS S3
* [react-native-background-upload ★270](https://github.com/Vydia/react-native-background-upload) - Upload files in your React Native app even while it's backgrounded. Supports Android and iOS, including iOS Camera Roll assets.
* [react-native-xmpp ★256](https://github.com/aksonov/react-native-xmpp) - XMPP Library for React Native
* [react-native-tcp ★199](https://github.com/PeelTechnologies/react-native-tcp) - node's net API for react-native
* [react-native-udp ★147](https://github.com/tradle/react-native-udp) - node's dgram API for react-native
* [react-native-aws-cognito-js ★131](https://github.com/AirLabsTeam/react-native-aws-cognito-js) - An adaptation of Amazon Cognito Identity SDK for JavaScript in combination with AWS SDK for JavaScript for React Native.
* [feathers-client ★121](https://github.com/feathersjs/feathers-client) - Feathers client that works with React Native, NodeJS and any client framework.
* [react-native-multipeer ★117](https://github.com/lwansbrough/react-native-multipeer) - Communicate over ad hoc wifi using Multipeer Connectivity
* [react-native-swift-socketio ★105](https://github.com/kirkness/react-native-swift-socketio) - A react native wrapper for socket.io-client-swift
* [react-native-file-upload ★103](https://github.com/booxood/react-native-file-upload) - A file upload plugin for react-native
* [react-native-networking ★99](https://github.com/eduedix/react-native-networking) - react-native module to download and upload files with AFNetworking
* [react-native-s3 ★80](https://github.com/mybigday/react-native-s3) - A React Native wrapper for AWS iOS/Android S3 SDK (TransferUtility)
* [react-native-rest-kit ★65](https://github.com/peter4k/react-native-rest-kit) - A React Native RESTful API kit that use the fetch method
* [react-native-cognito ★63](https://github.com/morcmarc/react-native-cognito) - AWS Cognito-based authentication module for React Native.
* [react-native-file-download ★45](https://github.com/plrthink/react-native-file-download) - A simple file download module for react-native
* [react-native-jwt ★37](https://github.com/StanScates/react-native-jwt) - React native compatible JSON web token utility
* [react-native-sync ★28](https://github.com/pervasync/react-native-sync) - Two way, incremental sync between React Native realmjs database and MySQL, Oracle, MS SQL Server and PostgreSQL
* [react-native-ssdp ★26](https://github.com/netbeast/react-native-ssdp) - A React Native fork of the SSDP protocol to discover plug and play devices.
* [react-native-http ★13](https://github.com/iktw/react-native-jwt) - React native http
* [react-native-async-http ★5](https://github.com/szq4119/react-native-async-http) - React Native component for async-http
* [react-native-nchan ★3](https://github.com/indatawetrust/react-native-nchan) - Nchan (pub/sub server) module for React Native
* [react-native-blob-courier ★8](https://github.com/edeckers/react-native-blob-courier) - Efficiently download and upload blobs on native thread
* [fetch ★10](https://github.com/react-native-community/fetch) - A fetch API polyfill for React Native with text streaming support.

### Integrations

* [react-native-wechat ★2016](https://github.com/weflex/react-native-wechat) - react-native library for wechat app
* [react-native-facebook-login ★1141](https://github.com/magus/react-native-facebook-login) - React Native wrapper for native iOS Facebook SDK login button and manager
* [react-native-google-signin ★1123](https://github.com/apptailor/react-native-google-signin) - Google Signin for your react native applications
* [react-native-google-places-autocomplete ★846](https://github.com/FaridSafi/react-native-google-places-autocomplete) - Customizable Google Places autocomplete component for iOS and Android React-Native apps
* [react-instantsearch ★644](https://github.com/algolia/react-instantsearch) - Lightning-fast search for React and React Native apps, by Algolia
* [react-native-awesome-card-io ★331](https://github.com/Kerumen/react-native-awesome-card-io) - A complete and cross-platform card.io component for React Native (iOS and Android)
* [react-native-qq ★278](https://github.com/reactnativecn/react-native-qq) - QQ Login&Share support in React Native.
* [react-native-facebook-account-kit ★227](https://github.com/underscopeio/react-native-facebook-account-kit) - A Facebook Account Kit SDK wrapper for React Native.
* [react-native-wechat-ios ★199](https://github.com/beefe/react-native-wechat-ios) - Wechat SDK for React Native(iOS).
* [react-native-card-io ★171](https://github.com/kayla-tech/react-native-card-io) - React Native component for card.io
* [react-native-voximplant ★126](https://github.com/voximplant/react-native-voximplant) - VoxImplant Mobile SDK for embedding voice and video communication into React Native apps.
* [instabug-reactnative ★122](https://github.com/Instabug/instabug-reactnative) - A React Native wrapper for Bug reporting Instabug SDK.
* [react-native-fabric-digits ★112](https://github.com/JeanLebrument/react-native-fabric-digits) Fabric Digits wrapper for React-Native
* [react-native-braintree ★104](https://github.com/alawong/react-native-braintree) - A react native interface for integrating payments using Braintree's v.zero SDK (currently iOS only)
* [react-native-dialogflow ★104](https://github.com/innFactory/react-native-dialogflow) - A React-Native bridge for Google's Dialogflow (api.ai)
* [react-native-signalr ★100](https://github.com/olofd/react-native-signalr) - SignalR-client for react-native
* [react-native-twilio ★87](https://github.com/rogchap/react-native-twilio) - A React Native wrapper for the Twilio Client SDK.
* [react-native-twilio-programmable-voice ★86](https://github.com/hoxfon/react-native-twilio-programmable-voice) - A React Native wrapper for the Twilio Programmable Voice SDK.
* [react-native-qqsdk ★83](https://github.com/iVanPan/react-native-qqsdk) - A React Native wrapper around the Tencent QQ SDK for Android and iOS. Provides access to QQ ssoLogin, QQ Sharing, QQ Zone Sharing etc.
* [react-native-braintree-xplat ★81](https://github.com/kraffslol/react-native-braintree-xplat) - Cross-platform Braintree v.zero module.
* [react-native-android-vitamio ★72](https://github.com/sejoker/react-native-android-vitamio) - React-native component for android Vitamio video player
* [react-native-linkedin-login ★69](https://github.com/jodybrewster/react-native-linkedin-login) - Linkedin Login for your react native applications
* [react-native-twitter-signin ★140](https://github.com/GoldenOwlAsia/react-native-twitter-signin) - Login for your react native applications with client Twitter account
* [react-native-spring-scrollview ★64](https://github.com/bolan9999/react-native-spring-scrollview) - React Native Spring ScrollView V2 is a high performance cross-platform native bounces ScrollView for React Native.(iOS & Android)
* [react-native-instagram-oauth ★63](https://github.com/watzak/react-native-instagram-oauth) - react-native instagram login
* [react-native-digits ★60](https://github.com/fixt/react-native-digits) - Digits wrapper to use in React Native
* [react-native-realtimemessaging-android ★53](https://github.com/realtime-framework/RCTRealtimeMessagingAndroid) - The Realtime Framework Cloud Messaging Pub/Sub client for React-Native Android
* [react-native-new-relic ★53](https://github.com/wix/react-native-newrelic) - New Relic event reporting for react-native.
* [react-native-onepassword ★52](https://github.com/DriveWealth/react-native-onepassword) - React Native integration with the OnePassword extension.
* [react-native-level ★38](https://github.com/tradle/react-native-level) - levelup API for react-native AsyncStorage.
* [react-native-instagram-share ★28](https://github.com/watzak/react-native-instagram-share) - A react-native interface to share images and videos within instagram (iOS)
* [react-native-braintree-android ★24](https://github.com/surialabs/react-native-braintree-android) - Braintree's native Drop-in Payment UI for Android
* [react-native-amap ★21](https://github.com/laoqiu/react-native-amap) - A React Native component for building maps with the AMap Android SDK
* [react-native-realtime-pusher ★19](https://github.com/gijoehosaphat/react-native-realtime-pusher) - React Native module implementing the Pusher Realtime API
* [react-native-conekta ★17](https://github.com/zo0r/react-native-conekta) - Conekta SDK for React Native
* [react-native-fitness ★17](https://github.com/OvalMoney/react-native-fitness) - A React Native module to interact with Apple Healthkit and Google Fit
* [react-native-woopra ★14](https://github.com/isair/react-native-woopra) - Promise based Woopra library for react-native
* [react-native-sinch-verification ★14](https://github.com/kevinresol/react-native-sinch-verification) - Sinch verification for react native
* [react-native-testfairy ★13](https://github.com/testfairy/react-native-testfairy) - TestFairy for React Native
* [react-native-leancloud ★10](https://github.com/turingou/react-native-leancloud) - a react native LeanCloud component
* [react-native-flurry ★9](https://github.com/amitkothari/react-native-flurry) - React Native wrapper for Flurry
* [react-native-realtimemessaging-ios ★8](https://github.com/realtime-framework/RCTRealtimeMessaging) - The Realtime Framework Cloud Messaging Pub/Sub client for React-Native
* [react-native-realtimestorage-ios ★8](https://github.com/realtime-framework/RCTRealtimeCloudStorage) - The Realtime Framework Cloud Storage client for React-Native
* [react-native-axmall-alipay ★7](https://github.com/szq4119/react-native-alipay) - react-native alipay
* [react-native-youtube-oauth ★7](https://github.com/indatawetrust/react-native-youtube-oauth) - react-native interface to login to youtube (iOS)
* [react-native-intercom-native ★7](https://github.com/mateioprea/react-native-intercom) - native based Intercom implementation for React Native
* [react-native-hawk ★5](https://github.com/andyscott/react-native-hawk) - Hawk wrapper for react-native
* [react-native-sumup ★5](https://github.com/APSL/react-native-sumup) - A React Native implementation of SumupSDK.
* [react-native-instagram ★5](https://github.com/watzak/react-native-instagram) - react-native instagram wrapper api (iOS)
* [react-native-realtimestorage-android ★4](https://github.com/realtime-framework/RCTRealtimeStorageAndroid) - The Realtime Cloud Storage client for React-Native Android
* [react-native-fbintent ★4](https://github.com/syarul/react-native-fbintent) - A React Native intent for Android Facebook App
* [react-native-onfido ★2](https://github.com/React-Native-Nation/react-native-onfido) - A React Native wrapper for the Onfido Library.
* [react-native-heyzap](https://github.com/react-native-contrib/react-native-heyzap)- Heyzap plugin for React Native
* [react-native-launch-navigator](https://github.com/dpa99c/react-native-launch-navigator) - React Native module to launch popular navigation/ride apps from a single API (Android & iOS)
* [react-native-agora +190](https://github.com/syanbo/react-native-agora) - A React Native Agora WebRTC Wrapper.
* [agora-react-native-rtm +5](https://github.com/agoraio/agora-react-native-rtm) - A React Native Agora RealTime-Message Cloud Service Wrapper.
* [react-native-intercom *323](https://github.com/tinycreative/react-native-intercom) - A React Native Intercom Wrapper.
* [react-native-bugfender *7](https://github.com/bugfender/rn-bugfender) - A React Native wrapper for Bugfender log and error reporting.

### Monetization

* [react-native-admob ★713](https://github.com/sbugert/react-native-admob) - A react-native component for Google AdMob banners.
* [react-native-stripe-api ★155](https://github.com/xcarpentier/react-native-stripe-api) - A small React Native library for Stripe Rest API
* [react-native-revmob ★15](https://github.com/RevMob/react-native-revmob) - RevMob wrapper for React Native.
* [react-native-google-pay ★2](https://github.com/busfor/react-native-google-pay) - Accept Payments with Google Pay for React Native apps.
* [react-native-apay ★2](https://github.com/busfor/react-native-apay) - React Native bridge for Apple Pay
* [react-native-square-in-app-payments ★18](https://github.com/square/in-app-payments-react-native-plugin) - Square React Native plugin for In-App Payments SDK.

### Animation

* [react-native-animatable ★5787](https://github.com/oblador/react-native-animatable) - Standard set of easy to use animations and declarative transitions for React Native
* [react-native-interactable ★4148](https://github.com/wix/react-native-interactable) - experimental implementation of high performance interactable views in React Native
* [react-native-reanimated ★680](https://github.com/kmagiera/react-native-reanimated) - React Native's Animated library reimplemented
* [react-native-spruce ★412](https://github.com/prscX/react-native-spruce) - React Native Bridge for Spruce Animation Library
* [react-native-magic-move ★402](https://github.com/IjzerenHein/react-native-magic-move) - Create magical move transitions between scenes in react-native 🐰🎩✨ (shared element transitions)
* [react-native-gl-model-view ★210](https://github.com/rastapasta/react-native-gl-model-view) - Display and animate textured Wavefront .OBJ 3D models with 60fps (iOS)
* [react-native-animated-sprite ★104](https://github.com/micahrye/react-native-animated-sprite) - A feature rich declarative component for animation, tweening, and dragging sprites.
* [react-native-animated-math ★54](https://github.com/rastapasta/react-native-animated-math) - An Animated API math extension - implements sin, cos, tan and pow as Animated Nodes with full Native Driver support

### Extension

* [React Native Today Widget ★190](https://github.com/matejkriz/react-native-today-widget) - iOS Today Widget Extension in React Native
* [React Native Android Widget Proof of Concept ★127](https://github.com/netbeast/react-native-android-widget-poc) - Android Widget Proof of Concept in React Native
* [React Native Floating Bubble ★14](https://github.com/hybriteq/react-native-floating-bubble) - A simple Facebook Chat Head like bubble for react native
* [React Native WidgetKit](https://github.com/fasky-software/react-native-widgetkit) - React Native Library for the iOS WidgetKit Framework

### Other Platforms

* [react-native-web ★10904](https://github.com/necolas/react-native-web) - React Native for Web
* [react-native-macos ★10453](http://github.com/ptmt/react-native-macos) - React Native for OS X
* [reactxp ★7268](https://github.com/Microsoft/reactxp) - Library for cross-platform app development
* [react-native-windows ★5547](https://github.com/ReactWindows/react-native-windows) - React Native for Universal Windows Platform
* [@areslabs/alita ★392](https://github.com/areslabs/alita) - react native for mini-program(微信小程序)
* [react-native-tvos-controller ★15](https://github.com/ycinfinity/react-native-tvos-controller) - TvOS remote controller module for react native.
* [react-native-watchkit ★1](https://github.com/MystK/react-native-watchkit) - react native for WatchKit

## Utilities

Useful React Native tooling.

* [upgrade-helper ★398](https://github.com/react-native-community/upgrade-helper) - ⚛️ A web interface to support React Native developers in upgrading their apps. [Link to tool](https://react-native-community.github.io/upgrade-helper)
* [react-native-debugger ★4017](https://github.com/jhen0409/react-native-debugger) - The standalone app for React Native Debugger, with React DevTools / Redux DevTools
* [haul ★2711](https://github.com/callstack-io/haul) - command line tool for developing React Native apps
* [rnpm ★2408](https://github.com/rnpm/rnpm) - react native package manager
* [generact ★1125](https://github.com/diegohaz/generact) - CLI that generates components based on existing ones no matter how you structure your app
* [react-native-rename ★901](https://github.com/junedomingo/react-native-rename) - Rename react-native app with just one command
* [react-native-exception-handler ★504](https://github.com/master-atul/react-native-exception-handler) – Avoid silent crash and errors on the production build of your app
* [Electrode Native ★439](https://github.com/electrode-io/electrode-native) - A platform to ease the integration of React Native components in existing mobile applications.
* [Ruby React Native (via Opal) ★391](https://github.com/zetachang/opal-native) - Use Ruby for building React Native apps
* [rn-snoopy ★329](https://github.com/jondot/rn-snoopy) - Profiling, monitoring and alerting over the React Native bridge. [More here](https://medium.com/@jondot/debugging-react-native-performance-snoopy-and-the-messagequeue-fe014cd047ac).
* [react-native-snippets ★249](https://github.com/Shrugs/react-native-snippets) - A collection of Sublime Text Snippets for react-native
* [react-native-bundle-visualizer ★141](https://github.com/IjzerenHein/react-native-bundle-visualizer) - See what's inside your RN bundle; useful for optimizing the bundle size
* [Makeicon ★70](https://github.com/beplus/makeicon) - Generates mobile app icons in all resolutions for both iOS and Android
* [AsyncStorage Dev Menu Item ★67](https://github.com/jsoendermann/react-native-async-storage-dev-menu-item) - Adds an option to your dev menu to log the content of your AsyncStorage.
* [rn-diff-purge ★64](https://github.com/react-native-community/rn-diff-purge) - The easiest way to upgrade React Native versions. You can find diffs for every React Native version, that are created by diffing the previous version with a newly created app in the new version.
* [React Native Actions ★55](https://github.com/lucasbento/react-native-actions) - Run React Native actions from within VSCode.
* [rsx ★29](https://github.com/react-native-contrib/rsx) - An alternative to the `react-native` CLI tool
* [ADB Auto Restarter ★8](https://github.com/mahanhaz/adb-auto-restarter) - Restart ADB service Automatically in case of crashing while debugging app with device .
* [rn-nodeify ★6](https://github.com/mvayngrib/rn-nodeify) - hack to allow react-native projects to use node core modules
* [react-native-ruler ★3](https://github.com/lfkwtz/react-native-ruler) - A devtool for measuring pixel dimensions on your React Native screens
* [BuilderX](https://builderx.io/) - A design tool which writes React Native code for you , Desktop Mac app to replace your traditional UX design tools.
* [CodePush](http://microsoft.github.io/code-push/) - Push code updates to your apps, instantly
* [Storybook](https://storybook.js.org) - UI development environment for your React components
* [BugSnag](https://www.bugsnag.com/platforms/react-native-error-reporting/) - A tool that logs native & JS errors. Has a free tier. Includes useful data about the user, environment, session, release, etc.
* [React Native Playground](https://rnplay.org/) - Run React Native apps in your browser via real time simulator
* [exponent](https://expo.io/) - Use React Native without XCode (a previewer app + local server infrastructure)
* [Deco IDE](https://www.decosoftware.com/) - React Native IDE with components manager
* [react-hook-hooker](https://github.com/fjcaetano/react-hook-hooker) - A nifty little HOC to add hooks to your React components.
* [React Native Elements Playground 🚀](https://react-native-elements.js.org/) - Tinker with `react-native-elements` components in the web.
* [SimpleLocalize CLI](https://github.com/simplelocalize/simplelocalize-cli) - An open source Localization CLI tool for finding i18n keys in project files.

## Seeds

Get a head start on development with an existing seed.

* [🔥 Ignite ★8832](https://github.com/infinitered/ignite) - An unfair start for React Native - Generator CLI for redux/sagas and more.
* [Pepperoni ★4383](https://github.com/futurice/pepperoni-app-kit) - **(deprecated)** Starter kit for Android & iOS, Redux, Immutable.js, disk-persisted app state
* [Snowflake ★4321](https://github.com/bartonhammond/snowflake) - Android & iOS, Redux, Jest (88% coverage), Immutable, Parse.com
* [native-starter-kit ★1506](https://github.com/start-react/native-starter-kit) - A Starter Kit for React Native + NativeBase + React Navigation + Redux + CodePush Apps (iOS & Android)
* [React Native Hackathon Starter ★732](https://github.com/dabit3/react-native-hackathon-starter) - React Native Starter Project, great for hackathons or rapid prototyping. Includes tabs, navigation, Redux, React Native Vector Icons, & React Native Elements
* [React Native Boilerplate Typescript](https://github.com/mengheangrat/react-native-boilerplate) - React Native Boilerplate - Redux + Saga + Reselect + redux-persist + react-navigation + TypeScript 
* [React Native Meteor Boilerplate ★615](https://github.com/spencercarli/react-native-meteor-boilerplate)
* [:octopus: React Native Boilerplate ★551](https://github.com/thecodingmachine/react-native-boilerplate) - React Native boilerplate that promotes a solid architecture via separation of concerns.
* [React Native Seed ★504](https://github.com/GeekyAnts/react-native-seed) - A set of React Native Boilerplates to choose from. MobX or Redux for state-management, TypeScript or Flow for static type checking and CRNA or plain React Native for the stack - By the creators of Native Base.
* [🚀 React Native Starter ★388](https://github.com/flatlogic/react-native-starter) - A powerful starter template that bootstraps development of your mobile application.
* [ReactNativeTS ★353](https://github.com/mrpatiwi/ReactNativeTS) - Boilerplate of a React Native project in Typescript.
* [react-native-starter by Ueno ★311](https://github.com/ueno-llc/react-native-starter) - Professional react-native starter kit with everything you'll ever need to deploy rock solid apps
* [react-native-babel ★241](https://github.com/roman01la/react-native-babel)
* [react-native-vanilla ★185](https://github.com/pavjacko/react-native-vanilla) - 🚀🚀🚀 Build universal cross-platform apps with React Native. Includes latest `iOS`, `tvOS`, `Android`, `Android TV`, `Android Wear`, `Web`, `Tizen TV`, `Tizen Watch`, `LG webOS`, `macOS/OSX`, `Windows` and `KaiOS` platforms
* [react-native-template-typescript ★183](https://github.com/emin93/react-native-template-typescript) - Clean and minimalist React Native template for a quick start with TypeScript.
* [react-native-template-airbnb](https://github.com/iboldurev/react-native-template-airbnb) - Clean and minimalist React Native template for a quick start with Airbnb (Flow, Prettier).
* [react-native-redux ★160](https://github.com/sibelius/react-native-redux) - React Native + Redux + Redux Saga
* [react-native-es6-reflux ★145](https://github.com/filp/react-native-es6-reflux)
* [react-native-hot-redux-starter ★135](https://github.com/adampash/react-native-hot-redux-starter)
* [react-native-typescript-boilerplate ★129](https://github.com/AmitM30/react-native-typescript-boilerplate) - An opinionated boilerplate built with React Native Navigation v3 + Redux + Thunk, in TypeScript. Follows industry best practices.
* [Rhinos-app ★81](https://github.com/rhinos-app/rhinos-app-dev) - Cross-platform React Native boilerplate (iOS, Android, Web) built on react-native-web.
* [react-native-web-boilerplate ★72](https://github.com/agrcrobles/react-native-web-boilerplate) - A react-native-web stateless hmr boilerplate
* [react-native-boilerplate ★61](https://github.com/pcofilada/react-native-boilerplate) - Simple boilerplate for mobile development using React Native and Redux
* [react-native-easy-starter ★50](https://github.com/HarishJangra/react-native-easy-starter) - A React-native starter kit using latest react and react-native [0.60.5](https://github.com/react-native-community/releases/blob/master/CHANGELOG.md#v0605), easy-peasy state management, hooks workflow, hermes, codepush ready-to-use custom hooks, react-native-paper, contextapis, theming support and much more (android + ios)
* [react-native-web-workspace ★58](https://github.com/agrcrobles/react-native-web-workspace) - A cross platform app with react in a monorepo
* [🍞 Baker ★46](http://baker.thebakery.io/) - An opinionated MVP toolkit that helps you build mobile apps crazy fast using React Native and Parse Server
* [React-Native-Starter-Pack ★40](https://github.com/iSimar/React-Native-Starter-Pack) - React Native 0.34 + React-Redux (w/ Redux-Storage) + Native Base + Code Push
* [react-native-relay-example ★38](https://github.com/sibelius/react-native-relay-example) - React Native working with Relay
* [MeteorNative Boilerplate ★23](https://github.com/redbaron76/MeteorNative) - a React Native and Meteor boilerplate with Redux.
* [rn-mobx-template ★17](https://github.com/hiaw/rn_mobx_template) - React Native with MobX template
* [react-native-boilerplate-chucknorris ★15](https://github.com/Ali-Ayyad/react-native-boilerplate-chucknorris) - A boilerplate for React Native + React Navigation + React Native Elements (iOS & Android)
* [react-native-template-super ★7](https://github.com/lohanitech/react-native-template-super) - A turbo starter template for react-native + React Navigation + Redux + Redux Persist
* [rn-relay-drawer-template ★4](https://github.com/hiaw/rn-relay-drawer-template) - React Native working with RNRF, drawer and relay
* [react-native-community-maps ★3](https://github.com/yonahforst/react-native-community-maps) - Boilerplate app for browsing user-generated photos on a map
* [React Native Starter Kit](https://github.com/instamobile/react-native-starter-kit) - React Native starter kit with user onboarding elements, including Firebase Auth and Facebook Login integration.
* [Awesome React Native Boilerplates](https://github.com/appitr/awesome-react-native-boilerplates) - Effective start for your development with the most popular react-native navigation and UI libraries
* [react-int](https://github.com/leafOfTree/react-int) - A simple way to use react/react-native with redux and redux-saga.
* [RNStarter](https://github.com/i-mighty/RNStarter) - ✨ A React Native Starter with 10+ commonly used libraries ✨

## Libraries

Libraries / SDK type additions for React Native development.

* [React Native Elements ★13599](https://github.com/dabit3/React-Native-Elements) - a collection of React Native UI Elements and components.
* [Shoutem UI ★3802](https://github.com/shoutem/ui) - a complete UI toolkit for React Native from Shoutem.
* [Panza ★243](https://github.com/bmcmahen/panza) - a collection of stateless, functional, cross-platform ui components for react-native.
* [BlankApp UI ★78](https://github.com/blankapp/ui) - Highly customizable and theming components for React Native.
* [react-native-easy-app ★220](https://github.com/chende008/react-native-easy-app) - React Native one-stop solution.
* [React Native Common ★49](https://github.com/rghorbani/react-native-common) - UI & API Components Library for React Native.
* [react-native-colibri ★5](https://github.com/nidorx/react-native-colibri) - React Native Generic UI Components.
* [Statek ★3](https://statek.dev) - Simple & Reactive state management library for React & React Native

## Open Source Apps

Open source React Native apps and other examples.

* [Artsy](https://github.com/artsy/eigen) - The mobile app for [artsy.net](https://artsy.net). Discover fine Art. The Art world in your Pocket.
* [f8app ★13070](https://github.com/fbsamples/f8app) - Official F8 (Facebook Developer Conference) app of 2017. See [blog post](http://makeitopen.com/blog/2017/12/04/blog-post-f82017-open-source.html).
* [30-days-of-react-native ★5192](https://github.com/fangwei716/30-days-of-react-native) - 30 days of React Native examples (inspired by 30DaysofSwift)
* [react-native-nw-react-calculator ★4624](https://github.com/benoitvallon/react-native-nw-react-calculator) - A mobile, desktop and website App with the same code
* [GitPoint ★3833](https://github.com/gitpoint/git-point) - A mobile GitHub client for both iOS and Android.
* [Hacker News (iOS & Android) ★3460](https://github.com/iSimar/HackerNews-React-Native)
* [reading ★2947](https://github.com/attentiveness/reading) - Reading App Write In React-Native.
* [Status.im ★2470](https://github.com/status-im/status-react) - Ethereum client.
* [GitHub Popular ★2452](https://github.com/crazycodeboy/GitHubPopular) - This is a GitHub most popular repositories viewer with React Native.
* [Dribbble React Native ★1927](https://github.com/catalinmiron/react-native-dribbble-app)
* [react-native-gitfeed ★1709](https://github.com/xiekw2010/react-native-gitfeed) - Yet another Github client written with react-native(iOS & android)
* [Finance React Native ★1680](https://github.com/7kfpun/FinanceReactNative) - iOS's stocks app clone written in React Native for demo purpose.
* [Quirk 🐙 ★965](https://github.com/flaque/quirk) - Cognitive Behavioral Therapy for iOS and Android.
* [TaskRabbit's Sample App ★802](https://github.com/taskrabbit/ReactNativeSampleApp) - a testing ground for Task Rabbit's app making
* [React Weather ★702](https://github.com/stage88/react-weather) - A simple weather app built with React Native
* [Boostnote ★630](https://github.com/BoostIO/boostnote-mobile) - Boostnote: open source note taking.
* [react-native-sudoku ★540](https://github.com/nihgwu/react-native-sudoku) - a sudoku game written in React Native
* [react-native-hiapp ★513](https://github.com/BelinChung/react-native-hiapp) - A simple and Twitter like demo app written in react-native
* [React Native Netflix ★489](https://github.com/mariodev12/react-native-netflix) - A Netflix-like app.
* [what the thing? ★430](https://github.com/vigzmv/what_the_thing) - Point camera at things to learn how to say them in a different language.
* [react-native-basketball ★425](https://github.com/FaridSafi/react-native-basketball) - a clone of the Facebook Basketball game
* [Surmon.me.native ★406](https://github.com/surmon-china/surmon.me.native) A react-native applaction for surmon.me
* [An example React Native project for client login authentication ★402](https://github.com/ryanmcdermott/react-native-login)
* [GitterMobile ★387](https://github.com/terrysahaidak/GitterMobile) - Gitter (chat for github) client for iOS and Android
* [ReactNativeRedditReader ★345](https://github.com/akveo/react-native-reddit-reader)
* [Assemblies ★322](https://github.com/buildreactnative/assemblies) - a Meetup clone
* [DuckDuckGo App (Unofficial) ★273](https://github.com/kiok46/duckduckgo)
* [Ziliun React Native ★266](https://github.com/sonnylazuardi/ziliun-react-native) - Wordpress based article reader built with react native
* [Luno ★266](https://github.com/alwx/luno-react-native) - A ClojureScript React Native app demonstration
* [ReactNativeHackerNews ★241](https://github.com/jsdf/ReactNativeHackerNews)
* [iOS Conference App made with React Native ★234](https://github.com/mikkoj/NortalTechDay)
* [MagicMirror ★232](https://github.com/ajwhite/MagicMirror)
* [Redux Demo ★226](https://github.com/chentsulin/react-native-counter-ios-android) - Minimal implement of redux counter example on ReactNative iOS and Android
* [React Native Embedded App ★218](https://github.com/dsibiski/react-native-embedded-app-example) -A collection of examples for using React Native in an existing iOS application
* [React Native Example, Geo and Location ★216](https://github.com/bgryszko/react-native-example)
* [uestc-bbs-react-native ★216](https://github.com/just4fun/uestc-bbs-react-native) - An iOS client for <http://bbs.uestc.edu.cn/> written in React Native with Redux
* [Sh\*\*t! I Smoke ★209](https://github.com/amaurymartiny/shoot-i-smoke) - Know how many cigarettes you smoke based on the pollution of your location.
* [PxView ★198](https://github.com/alphasp/pxview) - An unofficial Pixiv app client for Android and iOS
* [BBC News (Unofficial) ★187](https://github.com/joeltrew/BBCNews-React-Native) - a BBC news app
* [HackerBuzz ★179](https://github.com/RCiesielczuk/HackerBuzz-ReactNative) - a Hacker News reader.
* [Vecihi App ★170](https://github.com/yasintoy/vecihi) – Build your own photo sharing app.
* [Rocket.Chat ★161](https://github.com/RocketChat/Rocket.Chat.ReactNative) - Open Source Team Communication
* [HackerWeb ★158](https://github.com/cheeaun/hackerweb-native) - A simply readable Hacker News web app for iOS & Android.
* [Buyscreen sample ★151](https://github.com/appintheair/react-native-buyscreen)
* [NewsWatch video viewer ★150](https://github.com/bradoyler/newswatch-react-native)
* [YouTrack Mobile ★136](https://github.com/JetBrains/youtrack-mobile) – a client for YouTrack – issue tracker from JetBrains.
* [ndash ★129](https://github.com/alexindigo/ndash) - npm dashboard.
* [Look Lock ★126](https://github.com/7kfpun/PhotosReactNative) - An app for showing photos without worries.
* [Kakapo - ambient sound mixer ★126](https://github.com/bluedaniel/Kakapo-native)
* [Appointments ★116](https://github.com/iZaL/my-appointment) - Full-fledged ReactNative App for Booking Appointments
* [Alt/Flux Demo ★106](https://github.com/mrblueblue/react-native-alt-demo)
* [Buttercup Mobile ★103](https://github.com/buttercup/buttercup-mobile) - Mobile password manager
* [Insta Snap ★102](https://github.com/iZaL/insta-snap) - Image Sharing App
* [live translator ★94](https://github.com/agrcrobles/react-native-live-translator) - An app that translates in real time what you see from your mobile.
* [Finance MacOS React Native ★88](https://github.com/7kfpun/FinanceMacOSReactNative) - iOS's Stocks App clone written for MacOS with Touch Bar support. Data is pulled from Yahoo Finance.
* [NBAreact ★88](https://github.com/jbkuczma/NBAreact)
* [Urban Dictionary ★83](https://github.com/edwinbosire/Urbandict) - Mobile implementation of the popular Urban Dictionary website.
* [ASOS ★83](https://github.com/edwinbosire/ASOS) - E-commerce app for ASOS (clone)
* [Reddit made with React Native and Redux ★81](https://github.com/KevinOfNeu/xReddit)
* [react-native-redux-facebook ★79](https://github.com/bkspace/react-native-redux-facebook) - A simple React Redux Facebook authentication demo app.
* [Hekla for Hacker News ★77](https://github.com/birkir/hekla) - Hackernews client with TypeScript, mobx-state-tree, native navigation and css modules.
* [QRCode App ★74](https://github.com/insiderdev/react-native-qrcode-app) - application for scanning and generating QR codes.
* [Nearby Live ★72](https://github.com/N3TC4T/Nearby-Live) - An unofficial NearbyLive app for Android and iOS
* [SoundcloudMboX ★67](https://github.com/trazyn/SoundcloudMboX) SoundcloudMobX is the Soundcloud for iOS, Build with React-Native and MobX.
* [Native iOS font list ★60](https://github.com/yayolius/react-native-font-list)
* [React Native Chromecast App ★56](https://github.com/holoed/ChromeCast_ReactNative)
* [MoeFM ★54](https://github.com/codeestX/MoeFM) - A light MusicPlayer build with React Native & Redux for both Android and iOS.
* [iTunesConnect ★53](https://github.com/oney/iTunesConnect) - Unofficial iTunes Connect App
* [Sequent ★52](https://github.com/sobstel/sequent) - short-term memory training game (W/ Redux).
* [AudienceNetworkReactNative ★50](https://github.com/7kfpun/AudienceNetworkReactNative) - Facebook Audience Network Performance Tool.
* [rndrawer-implemented-rnrouter ★50](https://github.com/efkan/rndrawer-implemented-rnrouter) - A react-native-drawer implemented example and scaffolding for react-native-router-flux
* [Magento 2 Mobile App ★47](https://github.com/troublediehard/magento-react-native) - Magento 2.x mobile app built with React Native
* [iOS app that transcript your voice with IBM Watson Cloud ★41](https://github.com/yrezgui/meowth-ios)
* [Splitcloud ★35](https://github.com/egm0121/splitcloud-app) - Share listening to two songs at the same time from Soundcloud (by splitting right/left channels).
* [ZudVPN ★32](https://github.com/zudvpn/ZudVPN) - Deploy private VPN on major Cloud Providers with [ZudVPN](https://www.zudvpn.com)
* [Todo List ★31](https://github.com/rishabhbhatia/react-native-todo) - Todo-List app using SwipeView with ES6 standards for iOS and Android.
* [Paramap ★30](https://github.com/twist900/paramap) - Accessability map. React-native with Redux and Firebase. iOS and Android.
* [Confreaks ★29](https://github.com/cabaret/confreaks-react-native)
* [Vocab React Native ★27](https://github.com/thaiinhk/VocabReactNative) - Thai Vocabulary Learning App
* [Premier League ★25](https://github.com/ennioma/react-native-premier-league)
* [Roxie ★23](https://github.com/venepe/react-native-roxie) - Sound processing and bluetooth hardware control.
* [Roverz ★21](https://github.com/mongrov/roverz) - A native mobile chat client library for Rocket.Chat on both iOS and Android.
* [Text Blast ★18](https://github.com/SeshApp/text-blast-react-native) - iOS client for MMS text blasting app with analogous [ionic version](https://github.com/SeshApp/text-blast-ionic) for comparison
* [NewYorkTimesTopStories ★14](https://github.com/vidyuthd/NYTimesTopStories-React-Native) - Read Topstories of NewYorkTimes using its api written for android in react-native.
* [Quick-Sample ★14](https://github.com/innFactory/react-native-quick-sample) - A small and simple example app with navigation, data persistence, redux, listview and animation.
* [iGap Plus ★13](https://github.com/RooyeKhat-Media/iGap-Plus) - iGap+ is a cross-platform messaging application (Currently Android , iOS and Windows UWP) and has been created using all latest modern technologies. iGap+ is designed to easily support additional platforms like web, macOS and linux.
* [Posters_Galore_Android ★11](https://github.com/marmelab/Posters_Galore_Android) - An experimental Android application using Redux and a REST API
* [react-native-medium-clap-animation ★11](https://github.com/saketkumar95/react-native-medium-clap-animation) - Medium Clap Animation in React Native
* [HupuApp ★9](https://github.com/MelonRice/ReactNative-HupuJRS) - A Third-party Hupu App (<http://bbs.hupu.com/>) client implemented using React Native (Android and iOS).
* [react-native-uber-clone ★9](https://github.com/saketkumar95/react-native-uber-clone) - Uber UI Clone with animations in react native
* [Commit Strip (Unofficial) ★8](https://github.com/rizalibnu/commit-strip-react-native) - A CommitStrip.com reader built in React Native.
* [react-native-otello ★6](https://github.com/hiaw/react_native_otello) - a reversi game written in React Native
* [GitHub Jobs Search App (Unofficial) ★6](https://github.com/rizalibnu/github-jobs-react-native) - A GitHub Jobs Search App built in React Native.
* [Minimal Quotes ★6](https://github.com/insiderdev/minimal-quotes) - Mobile app that throws you random quotes in a super clean minimal version.
* [Hello Bemans ★5](https://github.com/rapportyou/HelloBemans) - Health Trainer Connection App (Android Version)
* [RNV2ex ★5](https://github.com/dyygtfx/RNV2ex) - react-native for v2ex
* [Renote ★4](https://github.com/mavajee/react-native-note-example) - A simple react-native example app for make notes.
* [Manyverse](https://github.com/staltz/manyverse) – Social network off the grid (a Scuttlebutt Android client)
* [Bristol Pound](http://blog.scottlogic.com/2017/11/22/developing-bristol-pound-an-open-source-react-native-app.html) - An app for the Bristol Pound, a UK-based local currency.
* [React Native Showcase](https://facebook.github.io/react-native/showcase.html)
* [Instagram clone](https://github.com/reindexio/reindex-examples/tree/master/react-native-gallery) - an Instagram clone
* [Joplin](https://github.com/laurent22/joplin/tree/master/ReactNativeClient) - A note taking app for desktop, CLI, and mobile (linked here is the mobile app).
* [Cat-or-dog](https://github.com/punksta/Cat-or-dog) - Simple game with drag'n'drops and animations.
* [Forex Rates](https://github.com/MicroPyramid/forex-rates-mobile-app) - Foreign exchange rates. currency rate converter. Historical exchange rates. Android and iOS.
* [Smog Alert App](https://github.com/Bartozzz/smog-alert-app) – provides real-time air pollution data all around the world and shows nearby polluters.
* [Audio Book App](https://github.com/minhtc/sachnoiapp) – Completed Audiobook app with some cool animations.
* [FastBuy](https://github.com/Bruno-Furtado/fastbuy-app) - App to manage the products from a dummy Store (built with React Native and Redux).
* [Hydropuzzle](https://github.com/hydropuzzle/hydropuzzle) - Stylish puzzle adventure game.
* [Github-Gist](https://github.com/Arjun-sna/react-native-githubgist-client) - React native mobile application for github gist
* [Lyrics King](https://github.com/SKempin/Lyrics-King-React-Native) - Minimalist and stylish lyrics search app.
* [TensorFlow.js Starter](https://github.com/t73liu/tfjs-starter) - TensorFlow.js starter app using MobileNet to predict image class. [Blog post](https://t73liu.github.io/posts/experimenting-with-tfjs/) for additional context.
* [Art Museum](https://github.com/pedrobern/react-native-art-museums-app) - Browse through the endless Harvard's Art Museum collection.
* [NMF.earth ★14](https://github.com/NotMyFaultEarth/nmf-app) - Calculate, understand and reduce your carbon footprint. Available for Android and iOS, using Expo, Redux Toolkit and Typescript.
* [Nyxo ★12](https://github.com/hello-nyxo/nyxo-app) - Sleep tracker and sleep coaching app. Available for Android and iOS.
* [Post Card App ★1](https://github.com/adarsh0d/postcardApp) - Create old style post card and share on whatsapp as image. Built with Expo and available for android.


## Frameworks

* [NativeBase ★10520](https://github.com/GeekyAnts/NativeBase) - builds a layer on top of React Native that provides you with basic set of components for mobile application development
* [Teaset ★1575](https://github.com/rilyu/teaset) - A UI library for react native, provides 20+ pure JS(ES6) components, focusing on content display and action control.
* [Awesome React Native Meteor ★152](https://github.com/meteor-factory/awesome-react-native-meteor) - An awesome list of resources for using Meteor and React Native together
* [first-born ★106](https://github.com/99xt/first-born) - A UI framework with pre-built components that render separately according to the underlying mobile platform.
* [OsmiCSX ★48](https://github.com/OsmiCSX/osmicsx) - An utility React Native style framework for rapidly building custom user interfaces.
* [React Native Diagnose ★13](https://github.com/netbeast/react-native-diagnose) - A framework to test a React Native app during runtime and production

## Tutorials

Walkthroughs and tutorials that help you learn React Native.

* [Fully-immersive, hands-on, and fun learning experience for React Native ★825](https://github.com/jondot/ReactNativeKatas)
* [React Native with Django backend ★12](https://github.com/shunpochang/connect_love_mobile_demo)
* [Setting up background tasks that run periodically when app is closed in React Native](https://hackernoon.com/easy-os-background-tasks-in-react-native-bc4476c48b8a)
* [Animate React Native UI Elements](https://egghead.io/courses/animate-react-native-ui-elements)
* [Build a streaming audio app with React Native](http://slides.com/jhabdas/streaming-audio-react-native/)
* [Building a Calculator for Android and iOS with React Native](https://kylewbanks.com/blog/react-native-tutorial-part-1-hello-react)
* [Building Custom React Native Components From Scratch](http://moduscreate.com/blog/react_native_custom_components_ios/)
* [Deploying React Native using Fastlane](https://shift.infinite.red/simple-react-native-ios-releases-4c28bb53a97b#.bjifers3r)
* [Enabling Live Reload](https://www.reddit.com/r/reactnative/comments/30hbg3/enabling_live_reload/)
* [Facebook's F8 App Walkthrough Tutorial: React Native, Redux, Relay, Flow, Jest](http://makeitopen.com/)
* [Facebook Login With React Native](http://brentvatne.ca/facebook-login-with-react-native)
* [Integrating Parse and React Native for iOS](http://www.raywenderlich.com/106369/integrating-parse-react-native-ios)
* [Introducing React Native (on Ray Wenderlich's)](http://www.raywenderlich.com/99473/introducing-react-native-building-apps-javascript)
* [Leverage Existing iOS Views In Your React Native App](http://moduscreate.com/blog/leverage-existing-ios-views-react-native-app/)
* [Official React Native tutorial](http://facebook.github.io/react-native/docs/tutorial.html#content)
* [React Native Periscope Hearts Animation](http://browniefed.com/blog/2015/09/07/react-native-periscope-hearts-animation/)
* [React Native Youtube Animated Video Slide](http://browniefed.com/blog/2015/08/31/react-native-youtube-animated-video-slide/)
* [React Native and Socket.io](https://bullpen.bullish.io/how-to-actually-use-socket-io-in-react-native-39082d8d6172)
* [React-Native Animated with React-Art - Firework Tap To Shoot](http://browniefed.com/blog/2015/08/29/react-native-animated-with-react-art-firework-show/)
* [React-native Animated API Basic Example](http://browniefed.com/blog/2015/07/26/react-native-animated-api-basic-example/)
* [React-native Animated API with PanResponder](http://browniefed.com/blog/2015/08/15/react-native-animated-api-with-panresponder/)
* [React-native Animated ScrollView Row Swipe Actions](http://browniefed.com/blog/2015/08/01/react-native-animated-listview-row-swipe/)
* [React-native press and hold button actions](http://browniefed.com/blog/2015/08/22/react-native-press-and-hold-button-actions/)
* [React Native Express](http://www.reactnativeexpress.com/)
* [Simple React Native forms with redux-form, immutable.js and styled-components](http://esbenp.github.io/2017/01/06/react-native-redux-form-immutable-styled-components/)
* [A Mini-Course on React Native Flexbox](https://medium.com/@yoniweisbrod/a-mini-course-on-react-native-flexbox-2832a1ccc6)
* [The beauty of react-native -Build a stunning wallpaper app](https://www.smashingmagazine.com/2016/04/the-beauty-of-react-native-building-your-first-ios-app-with-javascript-part-1/)
* [Adding and removing custom fonts in React Native IOS Android](https://medium.com/@danielskripnik/how-to-add-and-remove-custom-fonts-in-react-native-b2830084b0e4#.s73pqh4ez)
* [Adding Custom Fonts to A React Native Application](https://medium.com/@dabit3/adding-custom-fonts-to-react-native-b266b41bff7f)
* [Building a Minimalist Weather App with React Native and Expo](https://blog.expo.io/building-a-minimalist-weather-app-with-react-native-and-expo-fe7066e02c09)
* [Getting Started with Lottie, React Native and Expo](https://hackernoon.com/react-native-getting-started-with-lottie-and-expo-8b2105fbb496)
* [How to integrate Redux into your application with React Native and Expo](https://medium.freecodecamp.org/how-to-integrate-redux-into-your-application-with-react-native-and-expo-ec37c9ca6033)
* [React Native for Designers](https://designcode.io/react-native)
* [Start React Native - Animation tutorial series](https://start-react-native.dev/)

## Books

Books - free and commercial (but only good ones).

* [Programming React Native](https://leanpub.com/programming-react-native) - (Free) An in-depth React Native book that you should read after you've done a couple tutorials of the many out there.
* [React Native Animation Book](http://browniefed.com/react-native-animation-book/) - (Free) React Native Animation.

Books - for sale.

* [React Native In Action](https://www.manning.com/books/react-native-in-action) - Learn how to build applications using React Native from the ground up.
* [React Native - Building Mobile Apps with JavaScript](https://www.packtpub.com/application-development/react-native-building-mobile-apps-javascript) - Your go-to guide to creating truly native iOS and Android mobile applications using React and JavaScript.
* [Fullstack React Native](https://fullstackreact.com/react-native/) - The up-to-date, in-depth, complete guide to React Native.

## Videos

Assortment of conference and training videos.

### Talks
* Chain React 2019: [React Native Only Playlist](https://www.youtube.com/playlist?list=PLq2wBqKQbpCqVKqZwysoo2MEDwVX7auhX)
* [awesome-react-native-talks ★312](https://github.com/mightyCrow/awesome-react-native-talks) - A curated list of talks about React Native or topics related to React Native.
* [Actually Building Things In React Native , Jani Eväkallio, Futurice](https://www.youtube.com/watch?v=ZqKYk0aTaYk)
* [Using Redux, Jonas Ohlsson, State](https://www.youtube.com/watch?v=Ola8U-SpL6U)
* [Native Testing](https://www.youtube.com/watch?v=6aVDe2Y-co4)
* [Reactotron](https://www.youtube.com/watch?v=tPBRfxswDjA)
* [React Native In The Wild - Bonnie Eisenman](https://www.youtube.com/watch?v=KWEhFWm0SL8)
* Chain React 2019: [Playlist](https://www.youtube.com/watch?v=zEjqDWqeDdg&list=PLFHvL21g9bk2bTWTCP1BueiiIz8q258z9)
* Chain React 2018: [Playlist](https://www.youtube.com/watch?v=UiPo9A9k7xc&t=0s&list=PLFHvL21g9bk1skdjnKVGXREDmP_HVDj-u)
* Chain React 2017: [Playlist](https://www.youtube.com/watch?v=cz5BzwgATpc&list=PLFHvL21g9bk3RxJ1Ut5nR_uTZFVOxu522)
* React Conf 2015: [Introducing React Native](https://youtu.be/KVZ-P-ZI6W4)
* React Conf 2015: [A Deep Dive into React Native](https://youtu.be/7rDsRXj9-cU)
* F8 2015: [React Native and Relay](https://www.youtube.com/watch?v=X6YbAKiLCLU)

### Training & tutorials

* [Awesome React Native Education ★455](https://github.com/hsavit1/Awesome-React-Native-Education)
* [React Native training ★238](https://www.gitbook.com/book/unbug/react-native-training/details)
* [Let's build a React Native app in 20 minutes](https://www.youtube.com/watch?v=9ArhJiMGVDc) and [Gist](https://gist.github.com/peterjmag/2ef39ba5d25f3f1e0008)
* [Mario Díez Channel](https://www.youtube.com/channel/UCisGMoxaVxJMcbio2FBHORg/search?query=React+Native) - Youtube channel in spanish about with a series of videos talking about react native
* [React Native Basics: Build a Currency Converter](http://learn.handlebarlabs.com/p/react-native-basics-build-a-currency-converter?ref=awesome-react-native) - (Free) A multi-hour in-depth video course showing you how to build apps with React Native.
* [React Native in Arabic: Build a newspaper app](https://www.youtube.com/playlist?list=PLk-CkzAysw4BLLNtATmnZOA8E8I6TP8MS) - (Free) A simple to follow video series in Arabic showing you how to build a newspaper app with React Native.
* [Building Youtube UI in 30 Minutes](https://www.youtube.com/watch?v=LdKtugH-sb8) - A quick tutorial showing how to build Youtube Mobile app's UI using React Native. This tutorial helps in getting started with coding designs from scratch.
* [Adding Authentication to a React Native Project](https://www.youtube.com/watch?v=dhOk7aNIzKw) - This tutorial shows how to easily add authentication to a React Native application using [AWS Mobile Hub](https://aws.amazon.com/mobile/)
* [Generate React Native Forms](http://react.rocks/example/tcomb-form-native) with `tcomb-form-native`
* [Build a chat app with React Native](https://pusher.com/tutorials/chat-react-native)
* Egghead.io: [React Native Fundamentals](https://egghead.io/series/react-native-fundamentals)
* Pluralsight.com: [Build iOS Apps with React Native](http://www.pluralsight.com/courses/build-ios-apps-react-native)
* Udemy.com: [Build apps with React Native](https://www.udemy.com/the-complete-react-native-and-redux-course/)
* Udemy.com: [Create Your First React Native App](https://www.udemy.com/create-your-first-react-native-app/?couponCode=AWESOME-REACT-NATIVE) - Introduction to building a React Native app and learning the foundational pieces.
* Handlebarlabs.com: [Learn React Native + Meteor](http://reactnativemeteor.com) - Comprehensive course & community on building an application with React Native and Meteor.
* Udemy.com: [Automate Your React Native Releases with Fastlane & Bitrise](https://www.udemy.com/automate-your-react-native-releases-with-fastlane-and-bitrise/?couponCode=AWESOME-REACT-NATIVE) - Learn step-by-step how to release your React Native applications into Stores automatically by using Fastlane & Bitrise.

## Blogs

* [React Native Training](https://medium.com/react-native-training)
* [Use React Native Blog](http://www.reactnative.com/)
* [Facebook Code Blog](https://code.facebook.com/)
* [The Bakery](http://blog.thebakery.io/) - JavaScript, React, React Native posts.
* [Christopher Chedeau aka Vjeux](http://blog.vjeux.com/)
* [Brent Vatne](http://brentvatne.ca/)
* [Kyle Corbitt](https://corbt.com/posts/) - Cofounder at Emberall.
* [Made with React](http://madewithreact.com/) - Showcase of apps using React or React Native.
* [Spencer Carli](https://medium.com/@spencer_carli)
* [Official React Native Blog](http://facebook.github.io/react-native/blog/)
* [reactnative.gallery](https://reactnative.gallery/) - Show and tell for React Native developers
* [Red Shift - Infinite Red](https://shift.infinite.red/) - Lots of React Native content
* [Ideamotive's Blog](https://www.ideamotive.co/blog/tag/react-native) - Blog about React Native

## Newsletters

* [React Native Now](https://reactnativenow.com)
* [React Native Newsletter](http://reactnative.cc)

## Releases

* [Stable: 0.57.0](https://github.com/react-native-community/react-native-releases/blob/master/CHANGELOG.md#057)
* [Next: latest](https://github.com/facebook/react-native/releases/latest)
* [All Versions](https://facebook.github.io/react-native/versions)
* [All Changelogs](https://github.com/react-native-community/react-native-releases/blob/master/CHANGELOG.md)
* [Upgrading Versions](https://facebook.github.io/react-native/docs/upgrading.html)
* [Release Process](http://facebook.github.io/react/blog/2015/05/22/react-native-release-process.html)
