The following is a list of free and/or open source books on machine learning, statistics, data mining, etc.

## Machine Learning / Data Mining

* [Distributed Machine Learning Patterns](https://github.com/terrytangyuan/distributed-ml-patterns)  - Book (free to read online) + Code
* [The Hundred-Page Machine Learning Book](http://themlbook.com/wiki/doku.php)
* [Real World Machine Learning](https://www.manning.com/books/real-world-machine-learning) [Free Chapters]
* [An Introduction To Statistical Learning With Applications In R](https://drive.usercontent.google.com/download?id=106d-rN7cXpyAkgrUqjcPONNCyO-rX7MQ&export=download) - Book + R Code
* [An Introduction To Statistical Learning With Applications In Python](https://drive.usercontent.google.com/download?id=1ajFkHO6zjrdGNqhqW1jKBZdiNGh_8YQ1&export=download) - Book + Python Code
* [Elements of Statistical Learning](https://web.stanford.edu/~hastie/ElemStatLearn/) - Book
* [Computer Age Statistical Inference (CASI)](https://web.stanford.edu/~hastie/CASI_files/PDF/casi.pdf) ([Permalink as of October 2017](https://perma.cc/J8JG-ZVFW)) - Book
* [Probabilistic Programming & Bayesian Methods for Hackers](http://camdavidsonpilon.github.io/Probabilistic-Programming-and-Bayesian-Methods-for-Hackers/) - Book + IPython Notebooks
* [Think Bayes](https://greenteapress.com/wp/think-bayes/) - Book + Python Code
* [Information Theory, Inference, and Learning Algorithms](http://www.inference.phy.cam.ac.uk/mackay/itila/book.html)
* [Gaussian Processes for Machine Learning](http://www.gaussianprocess.org/gpml/chapters/)
* [Data Intensive Text Processing w/ MapReduce](https://lintool.github.io/MapReduceAlgorithms/)
* [Reinforcement Learning: - An Introduction](http://incompleteideas.net/book/the-book-2nd.html) ([Permalink to Nov 2017 Draft](https://perma.cc/83ER-64M3))
* [Mining Massive Datasets](http://infolab.stanford.edu/~ullman/mmds/book.pdf)
* [A First Encounter with Machine Learning](https://www.ics.uci.edu/~welling/teaching/273ASpring10/IntroMLBook.pdf)
* [Pattern Recognition and Machine Learning](http://users.isr.ist.utl.pt/~wurmd/Livros/school/Bishop%20-%20Pattern%20Recognition%20And%20Machine%20Learning%20-%20Springer%20%202006.pdf)
* [Machine Learning & Bayesian Reasoning](http://web4.cs.ucl.ac.uk/staff/D.Barber/textbook/090310.pdf)
* [Introduction to Machine Learning](https://alex.smola.org/drafts/thebook.pdf) - Alex Smola and S.V.N. Vishwanathan
* [A Probabilistic Theory of Pattern Recognition](https://www.szit.bme.hu/~gyorfi/pbook.pdf)
* [Introduction to Information Retrieval](https://nlp.stanford.edu/IR-book/pdf/irbookprint.pdf)
* [Forecasting: principles and practice](https://otexts.com/fpp2/)
* [Practical Artificial Intelligence Programming in Java](https://www.saylor.org/site/wp-content/uploads/2011/11/CS405-1.1-WATSON.pdf)
* [Introduction to Machine Learning](https://arxiv.org/pdf/0904.3664v1.pdf) - Amnon Shashua
* [Reinforcement Learning](https://www.intechopen.com/books/reinforcement_learning)
* [Machine Learning](https://www.intechopen.com/books/machine_learning)
* [A Quest for AI](https://ai.stanford.edu/~nilsson/QAI/qai.pdf)
* [Introduction to Applied Bayesian Statistics and Estimation for Social Scientists](https://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.177.857&rep=rep1&type=pdf) - Scott M. Lynch
* [Bayesian Modeling, Inference and Prediction](https://users.soe.ucsc.edu/~draper/draper-BMIP-dec2005.pdf)
* [A Course in Machine Learning](http://ciml.info/)
* [Machine Learning, Neural and Statistical Classification](https://www1.maths.leeds.ac.uk/~charles/statlog/)
* [Bayesian Reasoning and Machine Learning](http://web4.cs.ucl.ac.uk/staff/D.Barber/pmwiki/pmwiki.php?n=Brml.HomePage) Book+MatlabToolBox
* [R Programming for Data Science](https://leanpub.com/rprogramming)
* [Data Mining - Practical Machine Learning Tools and Techniques](https://cdn.preterhuman.net/texts/science_and_technology/artificial_intelligence/Data%20Mining%20Practical%20Machine%20Learning%20Tools%20and%20Techniques%202d%20ed%20-%20Morgan%20Kaufmann.pdf) Book
* [Machine Learning with TensorFlow](https://www.manning.com/books/machine-learning-with-tensorflow) Early book access
* [Machine Learning Systems](https://www.manning.com/books/machine-learning-systems) Early book access
* [Hands‑On Machine Learning with Scikit‑Learn and TensorFlow](http://index-of.es/Varios-2/Hands%20on%20Machine%20Learning%20with%20Scikit%20Learn%20and%20Tensorflow.pdf) - Aurélien Géron
* [R for Data Science: Import, Tidy, Transform, Visualize, and Model Data](https://r4ds.had.co.nz/) - Wickham and Grolemund. Great introduction on how to use R language. 
* [Advanced R](http://adv-r.had.co.nz/) - Hadley Wickham. More advanced usage of R for programming.
* [Graph-Powered Machine Learning](https://www.manning.com/books/graph-powered-machine-learning) - Alessandro Negro. Combining graph theory and models to improve machine learning projects.
* [Machine Learning for Dummies](https://mscdss.ds.unipi.gr/wp-content/uploads/2018/02/Untitled-attachment-00056-2-1.pdf)
* [Machine Learning for Mortals (Mere and Otherwise)](https://www.manning.com/books/machine-learning-for-mortals-mere-and-otherwise) - Early access book that provides basics of machine learning and using R programming language.
* [Grokking Machine Learning](https://www.manning.com/books/grokking-machine-learning) - Early access book that introduces the most valuable machine learning techniques.
- [Foundations of Machine Learning](https://cs.nyu.edu/~mohri/mlbook/) - Mehryar Mohri, Afshin Rostamizadeh, and Ameet Talwalkar
- [Understanding Machine Learning](http://www.cs.huji.ac.il/~shais/UnderstandingMachineLearning/) - Shai Shalev-Shwartz and Shai Ben-David
- [Fighting Churn With Data](https://www.manning.com/books/fighting-churn-with-data)  [Free Chapter] Carl Gold - Hands on course in applied data science in Python and SQL, taught through the use case of customer churn.
- [Machine Learning Bookcamp](https://www.manning.com/books/machine-learning-bookcamp) - Alexey Grigorev - a project-based approach on learning machine learning (early access).
- [AI Summer](https://theaisummer.com/) A blog to help you learn Deep Learning an Artificial Intelligence
- [Mathematics for Machine Learning](https://mml-book.github.io/)
- [Approaching Almost any Machine learning problem Abhishek Thakur](https://github.com/abhishekkrthakur/approachingalmost)
- [MLOps Engineering at Scale](https://www.manning.com/books/mlops-engineering-at-scale) - Carl Osipov - Guide to bringing your experimental machine learning code to production using serverless capabilities from major cloud providers.
- [AI-Powered Search](https://www.manning.com/books/ai-powered-search) - Trey Grainger, Doug Turnbull, Max Irwin - Early access book that teaches you how to build search engines that automatically understand the intention of a query in order to deliver significantly better results.
- [Ensemble Methods for Machine Learning](https://www.manning.com/books/ensemble-methods-for-machine-learning) - Gautam Kunapuli - Early access book that teaches you to implement the most important ensemble machine learning methods from scratch.
- [Machine Learning Engineering in Action](https://www.manning.com/books/machine-learning-engineering-in-action) - Ben Wilson - Field-tested tips, tricks, and design patterns for building Machine Learning projects that are deployable, maintainable, and secure from concept to production.
- [Privacy-Preserving Machine Learning](https://www.manning.com/books/privacy-preserving-machine-learning) - J. Morris Chang, Di Zhuang, G. Dumindu Samaraweera - Keep sensitive user data safe and secure, without sacrificing the accuracy of your machine learning models.
- [Automated Machine Learning in Action](https://www.manning.com/books/automated-machine-learning-in-action) - Qingquan Song, Haifeng Jin, and Xia Hu - Optimize every stage of your machine learning pipelines with powerful automation components and cutting-edge tools like AutoKeras and Keras Tuner.
- [Distributed Machine Learning Patterns](https://www.manning.com/books/distributed-machine-learning-patterns) - Yuan Tang - Practical patterns for scaling machine learning from your laptop to a distributed cluster.
- [Human-in-the-Loop Machine Learning: Active learning and annotation for human-centered AI](https://www.manning.com/books/human-in-the-loop-machine-learning) - Robert (Munro) Monarch - a practical guide to optimizing the entire machine learning process, including techniques for annotation, active learning, transfer learning, and using machine learning to optimize every step of the process.
- [Feature Engineering Bookcamp](https://www.manning.com/books/feature-engineering-bookcamp) - Maurucio Aniche - This book’s practical case-studies reveal feature engineering techniques that upgrade your data wrangling—and your ML results.
- [Metalearning: Applications to Automated Machine Learning and Data Mining](https://link.springer.com/content/pdf/10.1007/978-3-030-67024-5.pdf) - Pavel Brazdil, Jan N. van Rijn, Carlos Soares, Joaquin Vanschoren
- [Managing Machine Learning Projects: From design to deployment](https://www.manning.com/books/managing-machine-learning-projects) - Simon Thompson
- [Causal AI](https://www.manning.com/books/causal-machine-learning) - Robert Ness - Practical introduction to building AI models that can reason about causality.
- [Bayesian Optimization in Action](https://www.manning.com/books/bayesian-optimization-in-action) - Quan Nguyen - Book about building Bayesian optimization systems from the ground up.
- [Machine Learning Algorithms in Depth](https://www.manning.com/books/machine-learning-algorithms-in-depth) - Vadim Smolyakov - Book about practical implementations of dozens of ML algorithms.
- [Optimization Algorithms](https://www.manning.com/books/optimization-algorithms) - Alaa Khamis - Book about how to solve design, planning, and control problems using modern machine learning and AI techniques.
- [Practical Gradient Boosting](https://www.amazon.com/dp/B0BL1HRD6Z) by Guillaume Saupin
- [Machine Learning System Design](https://www.manning.com/books/machine-learning-system-design) - Valerii Babushkin and Arseny Kravchenko - A book about planning and designing successful ML applications.
- [Fight Fraud with Machine Learning](https://www.manning.com/books/fight-fraud-with-machine-learning) - by Ashish Ranjan Jha - A book about developing scalable and tunable models that can spot and stop fraudulent activity.
- [Machine Learning for Drug Discovery](https://www.manning.com/books/machine-learning-for-drug-discovery) - by Noah Flynn - A book that introduces the machine learning and deep learning techniques that drive modern medical research.
- [Probabilistic Machine Learning](https://probml.github.io/pml-book/book1.html) - 2022 edition By Kevin P. Murphy - A must have for PhD students and ML researchers. An exceptional book that covers the basic foundational ML concepts like optimization decision theory information theory and ML maths(linear algebra & probability theory) before delving into traditional but important models Linear Models , then modern supervised and unsupervised Deep learning models.
- [Probabilistic Machine Learning: Advanced Topics](https://probml.github.io/pml-book/book2.html) - 2023 edition By Kevin P. Murphy Sequel to the first book for those seeking to learn about more niche but important topics. Also includes technical coverage on latest models like diffusion and generative modeling.
- [Python Feature Engineering Cookbook](https://www.amazon.com/Python-Feature-Engineering-Cookbook-complete/dp/B0DBQDG7SG) - A hands-on guide to streamline data preprocessing and feature engineering in your machine learning projects.
- [AI Governance](https://www.manning.com/books/ai-governance) - A structured playbook for safely harnessing the potential of Generative AI.
  
## Deep Learning

* [Deep Learning - An MIT Press book](https://www.deeplearningbook.org/)
* [Deep Learning with Python](https://www.manning.com/books/deep-learning-with-python)
* [Deep Learning with Python, Second Edition](https://www.manning.com/books/deep-learning-with-python-second-edition) Early access book
* [Deep Learning with Python, Third Edition](https://www.manning.com/books/deep-learning-with-python-third-edition) Early access book
* [Deep Learning with JavaScript](https://www.manning.com/books/deep-learning-with-javascript) Early access book
* [Grokking Deep Learning](https://www.manning.com/books/grokking-deep-learning) Early access book
* [Deep Learning for Search](https://www.manning.com/books/deep-learning-for-search) Early access book
* [Deep Learning and the Game of Go](https://www.manning.com/books/deep-learning-and-the-game-of-go) Early access book
* [Machine Learning for Business](https://www.manning.com/books/machine-learning-for-business) Early access book
* [Probabilistic Deep Learning with Python](https://www.manning.com/books/probabilistic-deep-learning-with-python) Early access book
* [Deep Learning with Structured Data](https://www.manning.com/books/deep-learning-with-structured-data) Early access book
* [Deep Learning](https://www.deeplearningbook.org/)[Ian Goodfellow, Yoshua Bengio and Aaron Courville]
* [Deep Learning with Python, Second Edition](https://www.manning.com/books/deep-learning-with-python-second-edition) 
* [Inside Deep Learning](https://www.manning.com/books/inside-deep-learning) Early access book
* [Math and Architectures of Deep Learning](https://www.manning.com/books/math-and-architectures-of-deep-learning) Early access book
* [Deep Learning for Natural Language Processing](https://www.manning.com/books/deep-learning-for-natural-language-processing) Early access book
* [Deep Learning with R, Third Edition](https://www.manning.com/books/deep-learning-with-r-third-edition)
* [AI Model Evaluation](https://www.manning.com/books/ai-model-evaluation) 

## Natural Language Processing

* [Coursera Course Book on NLP](http://www.cs.columbia.edu/~mcollins/notes-spring2013.html)
* [NLTK](https://www.nltk.org/book/)
* [Foundations of Statistical Natural Language Processing](https://nlp.stanford.edu/fsnlp/promo/)
* [Natural Language Processing in Action](https://www.manning.com/books/natural-language-processing-in-action) Early access book
* [Natural Language Processing in Action, Second Edition](https://www.manning.com/books/natural-language-processing-in-action-second-edition) Early access book
* [Real-World Natural Language Processing](https://www.manning.com/books/real-world-natural-language-processing) Early access book
* [Essential Natural Language Processing](https://www.manning.com/books/essential-natural-language-processing) Early access book
* [Deep Learning for Natural Language Processing](https://www.manning.com/books/deep-learning-for-natural-language-processing) Early access book
* [Natural Language Processing in Action, Second Edition](https://www.manning.com/books/natural-language-processing-in-action-second-edition) Early access book
* [Getting Started with Natural Language Processing in Action](https://www.manning.com/books/getting-started-with-natural-language-processing) Early access book
* [Transfer Learnin for Natural Language Processing](https://www.manning.com/books/transfer-learning-for-natural-language-processing) by Paul Azunre


## Information Retrieval

* [An Introduction to Information Retrieval](https://nlp.stanford.edu/IR-book/pdf/irbookonlinereading.pdf)

## Neural Networks

* [A Brief Introduction to Neural Networks](http://www.dkriesel.com/_media/science/neuronalenetze-en-zeta2-2col-dkrieselcom.pdf)
* [Neural Networks and Deep Learning](http://neuralnetworksanddeeplearning.com/)
* [Graph Neural Networks in Action](https://www.manning.com/books/graph-neural-networks-in-action)

## Probability & Statistics

* [Think Stats](https://www.greenteapress.com/thinkstats/) - Book + Python Code
* [From Algorithms to Z-Scores](http://heather.cs.ucdavis.edu/probstatbook) - Book
* [The Art of R Programming](http://heather.cs.ucdavis.edu/~matloff/132/NSPpart.pdf) - Book (Not Finished)
* [Introduction to statistical thought](https://people.math.umass.edu/~lavine/Book/book.pdf)
* [Basic Probability Theory](https://www.math.uiuc.edu/~r-ash/BPT/BPT.pdf)
* [Introduction to probability](https://math.dartmouth.edu/~prob/prob/prob.pdf) - By Dartmouth College
* [Probability & Statistics Cookbook](http://statistics.zone/)
* [Introduction to Probability](http://athenasc.com/probbook.html) -  Book and course by MIT
* [The Elements of Statistical Learning: Data Mining, Inference, and Prediction.](https://web.stanford.edu/~hastie/ElemStatLearn/) - Book
* [An Introduction to Statistical Learning with Applications in R](https://www-bcf.usc.edu/~gareth/ISL/) - Book
* [Introduction to Probability and Statistics Using R](http://ipsur.r-forge.r-project.org/book/download/IPSUR.pdf) - Book
* [Advanced R Programming](http://adv-r.had.co.nz) - Book
* [Practical Regression and Anova using R](https://cran.r-project.org/doc/contrib/Faraway-PRA.pdf) - Book
* [R practicals](http://www.columbia.edu/~cjd11/charles_dimaggio/DIRE/resources/R/practicalsBookNoAns.pdf) - Book
* [The R Inferno](https://www.burns-stat.com/pages/Tutor/R_inferno.pdf) - Book
* [Probability Theory: The Logic of Science](https://bayes.wustl.edu/etj/prob/book.pdf) - By Jaynes

## Linear Algebra

* [The Matrix Cookbook](https://www.math.uwaterloo.ca/~hwolkowi/matrixcookbook.pdf)
* [Linear Algebra by Shilov](https://cosmathclub.files.wordpress.com/2014/10/georgi-shilov-linear-algebra4.pdf)
* [Linear Algebra Done Wrong](https://www.math.brown.edu/~treil/papers/LADW/LADW.html)
* [Linear Algebra, Theory, and Applications](https://math.byu.edu/~klkuttle/Linearalgebra.pdf)
* [Convex Optimization](https://web.stanford.edu/~boyd/cvxbook/bv_cvxbook.pdf)
* [Applied Numerical Computing](https://www.seas.ucla.edu/~vandenbe/ee133a.html)

## Calculus

* [Calculus Made Easy](https://github.com/lahorekid/Calculus/blob/master/Calculus%20Made%20Easy.pdf)
* [calculus by ron larson](https://www.pdfdrive.com/calculus-e183995561.html)
* [Active Calculus by Matt Boelkins](https://scholarworks.gvsu.edu/books/20/)
