[**NeuroLink API Reference v8.32.0**](../README.md)

---

[NeuroLink API Reference](../README.md) / GenerateResult

# Type Alias: GenerateResult

> **GenerateResult** = `object`

Defined in: [types/generateTypes.ts:285](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L285)

Generate function result type - Primary output format
Future-ready for multi-modal outputs while maintaining text focus

## Properties

### content

> **content**: `string`

Defined in: [types/generateTypes.ts:286](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L286)

---

### outputs?

> `optional` **outputs**: `object`

Defined in: [types/generateTypes.ts:287](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L287)

#### text

> **text**: `string`

---

### audio?

> `optional` **audio**: `TTSResult`

Defined in: [types/generateTypes.ts:317](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L317)

Text-to-Speech audio result

Contains the generated audio buffer and metadata when TTS is enabled.
Generated by TTSProcessor.synthesize() using the specified provider.

#### Example

```typescript
const result = await neurolink.generate({
  input: { text: "Hello world" },
  provider: "google-ai",
  tts: { enabled: true, voice: "en-US-Neural2-C" },
});

if (result.audio) {
  console.log(`Audio size: ${result.audio.size} bytes`);
  console.log(`Format: ${result.audio.format}`);
  if (result.audio.duration) {
    console.log(`Duration: ${result.audio.duration}s`);
  }
  if (result.audio.voice) {
    console.log(`Voice: ${result.audio.voice}`);
  }
  // Save or play the audio buffer
  fs.writeFileSync("output.mp3", result.audio.buffer);
}
```

---

### video?

> `optional` **video**: `VideoGenerationResult`

Defined in: [types/generateTypes.ts:341](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L341)

Video generation result

Contains the generated video buffer and metadata when video mode is enabled.
Present when `output.mode` is set to "video" in GenerateOptions.

#### Example

```typescript
const result = await neurolink.generate({
  input: { text: "Product showcase", images: [imageBuffer] },
  provider: "vertex",
  model: "veo-3.1",
  output: { mode: "video", video: { resolution: "1080p" } },
});

if (result.video) {
  fs.writeFileSync("output.mp4", result.video.data);
  console.log(`Duration: ${result.video.metadata?.duration}s`);
  console.log(
    `Dimensions: ${result.video.metadata?.dimensions?.width}x${result.video.metadata?.dimensions?.height}`,
  );
}
```

---

### imageOutput?

> `optional` **imageOutput**: \{ `base64`: `string`; \} \| `null`

Defined in: [types/generateTypes.ts:342](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L342)

---

### provider?

> `optional` **provider**: `string`

Defined in: [types/generateTypes.ts:345](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L345)

---

### model?

> `optional` **model**: `string`

Defined in: [types/generateTypes.ts:346](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L346)

---

### usage?

> `optional` **usage**: `TokenUsage`

Defined in: [types/generateTypes.ts:349](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L349)

---

### responseTime?

> `optional` **responseTime**: `number`

Defined in: [types/generateTypes.ts:350](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L350)

---

### toolCalls?

> `optional` **toolCalls**: `object`[]

Defined in: [types/generateTypes.ts:353](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L353)

#### toolCallId

> **toolCallId**: `string`

#### toolName

> **toolName**: `string`

#### args

> **args**: `StandardRecord`

---

### toolResults?

> `optional` **toolResults**: `unknown`[]

Defined in: [types/generateTypes.ts:358](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L358)

---

### toolsUsed?

> `optional` **toolsUsed**: `string`[]

Defined in: [types/generateTypes.ts:359](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L359)

---

### toolExecutions?

> `optional` **toolExecutions**: `object`[]

Defined in: [types/generateTypes.ts:360](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L360)

#### name

> **name**: `string`

#### input

> **input**: `StandardRecord`

#### output

> **output**: `unknown`

---

### enhancedWithTools?

> `optional` **enhancedWithTools**: `boolean`

Defined in: [types/generateTypes.ts:365](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L365)

---

### availableTools?

> `optional` **availableTools**: `object`[]

Defined in: [types/generateTypes.ts:366](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L366)

#### name

> **name**: `string`

#### description

> **description**: `string`

#### parameters

> **parameters**: `StandardRecord`

---

### analytics?

> `optional` **analytics**: [`AnalyticsData`](AnalyticsData.md)

Defined in: [types/generateTypes.ts:373](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L373)

---

### evaluation?

> `optional` **evaluation**: [`EvaluationData`](EvaluationData.md)

Defined in: [types/generateTypes.ts:374](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L374)

---

### factoryMetadata?

> `optional` **factoryMetadata**: `object`

Defined in: [types/generateTypes.ts:377](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L377)

#### enhancementApplied

> **enhancementApplied**: `boolean`

#### enhancementType?

> `optional` **enhancementType**: `string`

#### domainType?

> `optional` **domainType**: `string`

#### processingTime?

> `optional` **processingTime**: `number`

#### configurationUsed?

> `optional` **configurationUsed**: `StandardRecord`

#### migrationPerformed?

> `optional` **migrationPerformed**: `boolean`

#### legacyFieldsPreserved?

> `optional` **legacyFieldsPreserved**: `boolean`

---

### streamingMetadata?

> `optional` **streamingMetadata**: `object`

Defined in: [types/generateTypes.ts:388](https://github.com/juspay/neurolink/blob/1be79595b7d7307795c98da4267c1728cb50033d/src/lib/types/generateTypes.ts#L388)

#### streamingUsed

> **streamingUsed**: `boolean`

#### fallbackToGenerate?

> `optional` **fallbackToGenerate**: `boolean`

#### chunkCount?

> `optional` **chunkCount**: `number`

#### streamingDuration?

> `optional` **streamingDuration**: `number`

#### streamId?

> `optional` **streamId**: `string`

#### bufferOptimization?

> `optional` **bufferOptimization**: `boolean`
