# Getting Started

Welcome to NeuroLink! This section will help you get up and running quickly with the Enterprise AI Development Platform.

## 🚀 What You'll Learn

<div class="grid cards" markdown>

- :material-clock-fast: **[Quick Start](quick-start.md)**

  ***

  Get NeuroLink working in under 2 minutes with basic examples for both CLI and SDK usage.

- :material-download: **[Installation](installation.md)**

  ***

  Detailed installation instructions for different environments and package managers.

- :material-key: **[Provider Setup](provider-setup.md)**

  ***

  Configure API keys and credentials for all 9 supported AI providers with step-by-step guides.

- :material-cog: **[Environment Variables](environment-variables.md)**

  ***

  Complete reference for all environment variables and configuration options.

</div>

## 🎯 Choose Your Path

=== "I'm New to AI Development"

    Start with our [Quick Start guide](quick-start.md) to understand the basics and see NeuroLink in action.

=== "I Want to Use the CLI"

    Jump to [Provider Setup](provider-setup.md) to configure your API keys, then check the [CLI Guide](../cli/index.md).

=== "I'm Building an Application"

    Follow the [Installation guide](installation.md) for SDK setup, then explore [Framework Integration](../sdk/framework-integration.md).

=== "I'm Migrating from Another Platform"

    Check our [Provider Comparison](../reference/provider-comparison.md) to understand the differences and benefits.

## 🔧 Prerequisites

- **Node.js 18+** (for SDK usage)
- **npm/pnpm/yarn** (package manager)
- **API keys** for at least one AI provider

!!! tip "Free Options Available"

    You can start with free providers like Google AI Studio, Hugging Face, or local Ollama to test NeuroLink without costs.

## 🚦 Next Steps

1. **[Quick Start](quick-start.md)** - Get running in 2 minutes
2. **[Provider Setup](provider-setup.md)** - Configure your AI providers
3. **[CLI Guide](../cli/index.md)** or **[SDK Reference](../sdk/index.md)** - Deep dive into usage
4. **[Examples](../examples/index.md)** - See real-world applications
