# Video Tutorials

Learn NeuroLink through comprehensive video tutorials covering everything from quick starts to advanced enterprise features.

!!! info "Coming Soon"
We're actively creating video content for the NeuroLink community. Check back soon for new tutorials, or [contribute your own](#contributing-videos)!

## Getting Started Series

Perfect for developers new to NeuroLink. Start here to build a solid foundation.

### Quick Start (5 minutes)

**Coming Soon**

<!-- [Video embed placeholder] -->

Learn the basics of NeuroLink in just 5 minutes:

- Install NeuroLink via npm/pnpm
- Configure your first AI provider
- Make your first API call
- Handle responses and errors

**Topics Covered:**

- Installation and setup
- Provider configuration
- Basic text generation
- Error handling basics

---

### Provider Setup Deep Dive (10 minutes)

**Coming Soon**

<!-- [Video embed placeholder] -->

Complete guide to setting up all 13 AI providers:

- OpenAI, Anthropic, Google AI Studio
- AWS Bedrock, Azure OpenAI, Google Vertex
- Mistral, LiteLLM, Hugging Face
- Ollama, SageMaker, OpenAI Compatible, OpenRouter

**Topics Covered:**

- API key management
- Environment variable configuration
- Provider-specific settings
- Testing provider connections

**Related Resources:**

- [Provider Setup Guide](../getting-started/provider-setup.md)
- [Environment Variables Reference](../getting-started/environment-variables.md)

---

### Interactive CLI Deep Dive (15 minutes)

**Coming Soon**

<!-- [Video embed placeholder] -->

Master the NeuroLink CLI for rapid prototyping and testing:

- Loop mode for interactive sessions
- Conversation management
- Multimodal file uploads
- Session persistence

**Topics Covered:**

- CLI installation
- Interactive loop sessions
- Command-line options
- File attachments (images, PDFs, CSVs)
- Session management

**Related Resources:**

- [CLI Guide](../cli/index.md)
- [CLI Commands Reference](../cli/commands.md)
- [CLI Loop Sessions](../features/cli-loop-sessions.md)

---

## Feature Tutorials

Intermediate tutorials focusing on specific NeuroLink features.

### Human-in-the-Loop (HITL) Security Setup (12 minutes)

**Coming Soon**

<!-- [Video embed placeholder] -->

Implement enterprise-grade security with HITL workflow controls:

- Setting up approval workflows
- Configuring approval rules
- Handling approval requests
- Integration with enterprise systems

**Topics Covered:**

- HITL architecture
- Approval workflow configuration
- Custom approval handlers
- Security best practices

**Related Resources:**

- [HITL Feature Guide](../features/hitl.md)
- [Enterprise HITL Documentation](../features/enterprise-hitl.md)

---

### Redis Conversation Memory (15 minutes)

**Coming Soon**

<!-- [Video embed placeholder] -->

Configure Redis for production-grade conversation persistence:

- Redis setup and configuration
- Memory export and import
- Conversation summarization
- Token management strategies

**Topics Covered:**

- Redis installation
- NeuroLink Redis configuration
- Memory persistence patterns
- Conversation export/import
- Summarization strategies

**Related Resources:**

- [Redis Quick Start](../getting-started/redis-quickstart.md)
- [Redis Configuration Guide](../guides/redis-configuration.md)
- [Redis Migration Patterns](../guides/redis-migration.md)

---

### MCP Tools Integration (20 minutes)

**Coming Soon**

<!-- [Video embed placeholder] -->

Integrate external tools using the Model Context Protocol:

- Built-in tool overview (58+ tools)
- Custom tool development
- External MCP server integration
- Tool execution and error handling

**Topics Covered:**

- MCP architecture
- Built-in tool catalog
- Custom tool creation
- MCP server configuration
- Tool discovery and registration

**Related Resources:**

- [MCP Integration Guide](../advanced/mcp-integration.md)
- [MCP Server Catalog](../guides/mcp/server-catalog.md)
- [Custom Tools Guide](../sdk/custom-tools.md)

---

### Multimodal Chat Experiences (18 minutes)

**Coming Soon**

<!-- [Video embed placeholder] -->

Build rich multimodal applications with text, images, PDFs, and more:

- Image processing and vision APIs
- PDF document understanding
- CSV data analysis
- Audio/video integration (TTS)

**Topics Covered:**

- Image upload and processing
- PDF extraction and analysis
- CSV parsing and interpretation
- Text-to-speech integration
- Provider-specific multimodal capabilities

**Related Resources:**

- [Multimodal Guide](../features/multimodal.md)
- [TTS Integration](../features/tts.md)
- [Multimodal Chat Experiences](../features/multimodal-chat.md)

---

## Advanced Topics

Expert-level tutorials for production deployments and advanced patterns.

### Middleware Development (25 minutes)

**Coming Soon**

<!-- [Video embed placeholder] -->

Build custom middleware for request/response transformation:

- Middleware architecture overview
- Built-in middleware (Analytics, Auto-evaluation, Guardrails)
- Creating custom middleware
- Middleware chaining and composition

**Topics Covered:**

- Middleware system architecture
- Request/response lifecycle
- Built-in middleware features
- Custom middleware development
- Testing middleware

**Related Resources:**

- [Middleware Architecture](../advanced/middleware-architecture.md)
- [Built-in Middleware](../advanced/builtin-middleware.md)
- [Custom Middleware Guide](../custom-middleware-guide.md)

---

### Multi-Provider Architecture (30 minutes)

**Coming Soon**

<!-- [Video embed placeholder] -->

Design enterprise-grade multi-provider systems:

- Provider failover strategies
- Load balancing across providers
- Cost optimization techniques
- Health monitoring and observability

**Topics Covered:**

- Multi-provider patterns
- Failover configuration
- Load balancing strategies
- Cost tracking and optimization
- Provider health monitoring
- Analytics and observability

**Related Resources:**

- [Multi-Provider Failover](../guides/enterprise/multi-provider-failover.md)
- [Load Balancing](../guides/enterprise/load-balancing.md)
- [Cost Optimization](../guides/enterprise/cost-optimization.md)
- [Monitoring & Observability](../guides/enterprise/monitoring.md)

---

### Framework Integration Series

Building NeuroLink applications with popular frameworks.

#### Next.js Integration (20 minutes)

**Coming Soon**

<!-- [Video embed placeholder] -->

Build AI-powered Next.js applications:

- Server-side generation with NeuroLink
- API routes and streaming
- Edge runtime support
- Client-side integration patterns

**Related Resources:**

- [Next.js Integration Guide](../guides/frameworks/nextjs.md)

---

#### Express.js Integration (15 minutes)

**Coming Soon**

<!-- [Video embed placeholder] -->

Create REST APIs with NeuroLink and Express:

- Route handlers with AI generation
- Streaming responses
- Error middleware integration
- Authentication patterns

**Related Resources:**

- [Express.js Integration Guide](../guides/frameworks/express.md)

---

#### SvelteKit Integration (18 minutes)

**Coming Soon**

<!-- [Video embed placeholder] -->

Integrate NeuroLink into SvelteKit applications:

- Server routes and load functions
- Form actions with AI
- Real-time streaming with stores
- Progressive enhancement

**Related Resources:**

- [SvelteKit Integration Guide](../guides/frameworks/sveltekit.md)

---

## Migration Guides (Video Series)

Step-by-step video guides for migrating from other AI SDKs.

### Migrating from LangChain (20 minutes)

**Coming Soon**

<!-- [Video embed placeholder] -->

Complete migration guide from LangChain to NeuroLink:

- Feature comparison
- Code migration patterns
- Tool/chain equivalents
- Common gotchas

**Related Resources:**

- [LangChain Migration Guide](../guides/migration/from-langchain.md)

---

### Migrating from Vercel AI SDK (15 minutes)

**Coming Soon**

<!-- [Video embed placeholder] -->

Migrate your Vercel AI SDK projects to NeuroLink:

- API differences
- Provider mapping
- Streaming migration
- UI component adaptation

**Related Resources:**

- [Vercel AI SDK Migration Guide](../guides/migration/from-vercel-ai-sdk.md)

---

## Live Workshop Recordings

Recordings from community workshops and webinars.

!!! note "Upcoming Workshops"
We host regular community workshops. Join our [GitHub Discussions](https://github.com/juspay/neurolink/discussions) for announcements.

---

## Community Tutorials

Third-party video tutorials from the NeuroLink community:

- Check back soon for community contributions!
- Want to add your tutorial? See [Contributing Videos](#contributing-videos) below.

---

## Contributing Videos

We welcome video tutorial contributions from the community!

### What We're Looking For

**Beginner Tutorials:**

- Getting started guides
- Provider setup walkthroughs
- Basic feature demonstrations

**Intermediate Tutorials:**

- Framework integration examples
- Real-world use cases
- Feature deep dives

**Advanced Tutorials:**

- Enterprise deployment patterns
- Custom middleware development
- Performance optimization
- Security implementations

### Contribution Guidelines

1. **Quality Standards:**
   - Clear audio (no background noise)
   - HD video resolution (1080p preferred)
   - Well-structured content with clear objectives
   - Include code examples and working demos

2. **Technical Requirements:**
   - Use latest NeuroLink version
   - Test all code examples before recording
   - Include links to GitHub repositories with code
   - Provide timestamps for key sections

3. **Submission Process:**
   - Upload to YouTube or similar platform
   - Create a Pull Request to add your video to this page
   - Include video title, description, duration, and embed code
   - Ensure you have rights to all content used

4. **Content Guidelines:**
   - Follow our [Code of Conduct](../code-of-conduct.md)
   - Respect NeuroLink's branding guidelines
   - Provide accurate, up-to-date information
   - Credit sources and dependencies appropriately

### How to Submit

1. Fork the [NeuroLink repository](https://github.com/juspay/neurolink)
2. Add your video to `docs/tutorials/videos.md`
3. Create a Pull Request with:
   - Video title and description
   - YouTube/Vimeo embed code
   - Topics covered
   - Related documentation links
   - Your attribution (name, social links)

**Template:**

```markdown
### [Your Video Title] ([Duration])

By [Your Name](your-link)

<!-- Embed code -->

[Brief description of what the video covers]

**Topics Covered:**

- Topic 1
- Topic 2
- Topic 3

**Related Resources:**

- [Link 1]
- [Link 2]
```

See our full [Contributing Guide](../contributing.md) for more details.

---

## Video Playlist

Watch all NeuroLink tutorials in sequence:

<!-- [Full playlist embed placeholder] -->

**Coming Soon:** Subscribe to our [YouTube Channel](#) for notifications when new tutorials are released.

---

## Need Help?

- **Documentation:** [Complete Documentation](../index.md)
- **Getting Started:** [Quick Start Guide](../getting-started/quick-start.md)
- **Examples:** [Code Examples](../examples/index.md)
- **Interactive:** [Try the Playground](../playground/index.md)
- **Community:** [GitHub Discussions](https://github.com/juspay/neurolink/discussions)
- **Support:** [GitHub Issues](https://github.com/juspay/neurolink/issues)

---

**Last Updated:** January 1, 2026
