#!/usr/bin/env node

/**
 * Format Changelog Script
 * 
 * This script formats the CHANGELOG.md file after it's generated by semantic-release.
 * It's designed to be run as part of the release process to ensure consistent formatting.
 */

const { execSync } = require('child_process');
const fs = require('fs');
const path = require('path');

function formatChangelog() {
  console.log('📄 Formatting CHANGELOG.md...');
  
  const changelogPath = path.join(process.cwd(), 'CHANGELOG.md');
  
  // Check if CHANGELOG.md exists
  if (!fs.existsSync(changelogPath)) {
    console.log('⚠️  CHANGELOG.md not found, skipping formatting');
    return;
  }
  
  try {
    // Run prettier on CHANGELOG.md
    execSync('pnpm run format CHANGELOG.md', { 
      stdio: 'inherit',
      cwd: process.cwd()
    });
    
    console.log('✅ CHANGELOG.md formatted successfully');
  } catch (error) {
    console.error('❌ Error formatting CHANGELOG.md:', error.message);
    process.exit(1);
  }
}

// Run if called directly
if (require.main === module) {
  formatChangelog();
}

module.exports = { formatChangelog };