# Awesome Food [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

![Awesome-food](awesome_food.png)

> A curated list of food-related projects on GitHub

## Contents

- [Food-related projects](#food-related-projects)
- [Cookbooks](#cookbooks)
- [API for Food services](#api-for-food-services)
  - [Only available for French market](#only-available-for-french-market)
- [Sport nutrition](#sport-nutrition)
- [Things to read](#things-to-read)
  - [Books](#books)
  - [Forums and chat groups](#forums-and-chat-groups)
- [Courses and MOOCs](#courses-and-moocs)
- [Videos](#videos)
  - [Italian cuisine](#italian-cuisine)
  - [Asian cuisine](#asian-cuisine)

## Food-related projects

- [is-vegan](https://github.com/hmontazeri/is-vegan) - Is-Vegan helps you to find out which food ingredients are vegan / non-vegan.
- [FoodTrucks](https://github.com/prakhar1989/FoodTrucks) - San Francisco's finger-licking street food now at your fingertips.
- [Growstuff](https://github.com/Growstuff/growstuff) - Open data project for small-scale food growers.
- [myfood-app](https://github.com/MickaelGandecki/myfood-app) - Smart Greenhouse Management.
- [dominosjp](https://github.com/inket/dominosjp) - Domino's Pizza Japan CLI.
- [pizzadash](https://github.com/bhberson/pizzadash) - This is a Node.js application that "hacks" your Amazon Dash Button to order you a Domino's pizza.
- [fetch-my-whopper](https://github.com/jzarca01/fetch-my-whopper) - Node app to claim your free whopper at Burger King.
- [fetch-my-cookie](https://github.com/jzarca01/fetch-my-cookie) - Node app to claim your free cookie at Subway.
- [whoffer](https://github.com/jzarca01/whoffer) - React Native OCR app to claim free cookie at Subway.
- [Food-Recipe-CNN](https://github.com/Murgio/Food-Recipe-CNN) - DeepChef : Classification of Cooking Dishes with Machine Learning.
- [TooManyChefs](https://github.com/navignaw/TooManyChefs) - A text-based cooperative cooking game.
- [Auto-Soylent](https://github.com/nick/auto-soylent) - Automatic Soylent recipe generator.
- [Genetic-Soylent](https://github.com/nick/genetic-soylent) - This project generates soylent recipes based on genetic algorithms.
- [hasgluten](https://github.com/hasgluten/hasgluten) - Quick and Accurate Gluten-Free Foods List.
- [diy-proofing-box](https://github.com/hendricius/diy-proofing-box) - Build your own DIY proofing box for sourdough, yoghurt and pizza. Featuring a raspberry pi and night vision.
- [Mealie](https://github.com/hay-kot/mealie) - Mealie is a self hosted recipe manager and meal planner.
- [RasPiBrew](https://github.com/steve71/RasPiBrew) - Raspberry Pi Temperature Controller for homebrewing and sous vide cooking .

## Cookbooks

- [the-bread-code](https://github.com/hendricius/the-bread-code) - Learn how to master the art of baking the programmer way.
- [1337-Noms-The-Hacker-Cookbook](https://github.com/DEAD10C5/1337-Noms-The-Hacker-Cookbook) - The goal of this repo is to collect recipes for an eclectic mix of dishes from around the hacker community.
- [Vegan-chocolate-seduction-cookbook](https://github.com/the-domains/vegan-chocolate-seduction-cookbook) - Several great vegan chocolate recipes.
- [food-recipes](https://github.com/obfuscurity/food-recipes) - Honest-to-goodness "real food" recipes.
- [recipes](https://github.com/bzimmerman/recipes) - This repository contains tasty open-source recipes.
- [tacofancy](https://github.com/sinker/tacofancy) - Community-driven taco repo. stars stars stars.
- [cookbook](https://github.com/jlinder/cookbook) - Delicious food. Mostly wheat or gluten free.
- [pizza-dough](https://github.com/hendricius/pizza-dough) - This recipe is dedicated to helping you make the best possible pizza dough for Neapolitan pizza.
- [mozzarella](https://github.com/hendricius/mozzarella) - Learn how to make homemade mozzarella.
- [lactofermentation](https://github.com/tirimia/lactofermentation) - Experiments with wild lactobacillus.
- [bread](https://github.com/dgryski/bread) - Notes on bread baking.
- [El Fuego Viviente Chili Open Sauce](https://github.com/aweijnitz/recipe-el_fuego_viviente) - Fermented Chili "Open Sauce".
- [Chowdown](https://github.com/clarklab/chowdown) - A simple, plaintext markdown recipe database for hackers.
- [Cooking-Recipes](https://github.com/Donearm/Cooking-Recipes) - Mostly italian recipes.
- [bagels](https://github.com/andrewkern/bagels) - open source bagel recipe; let's raise the quality of bagels worldwide !

## Addresses

- [awesome-kacchi](https://github.com/s4kibs4mi/awesome-kacchi) - A curated list of awesome Kacchi Biryani available throughout the world.
- [awesome-berlin](https://github.com/AwesomeCities/awesome-berlin) - A curated list of Berlin's awesomeness.
- [Berlín para mexicanos](https://github.com/carlosyslas/berlin-para-mexicanos) - Berlin guide for mexicans. 

## API for Food services

- [node-deliveroo](https://github.com/jzarca01/node-deliveroo) - Unofficial Node API for Deliveroo.
- [tacofancy-api](https://github.com/evz/tacofancy-api) - An API for the repo Tacofancy.
- [Spoonacular](https://spoonacular.com/food-api) -
  Spoonacular offers its food parsing, matching, and searching technology for businesses and developers to create outstanding applications.
- [Edamam](https://developer.edamam.com/) - API developer portal for Nutrition Analysis, Food Database Lookup, Recipe Search API and others.
- [RecipePuppy](http://www.recipepuppy.com/about/api/) - This api lets you search through recipe puppy database of over a million recipes by keyword and/or by search query.
- [node-ubereats](https://github.com/jzarca01/node-ubereats) - A work in progress API for Uber Eats.
- [node-simplefeast](https://github.com/jzarca01/node-simplefeast) - An API Wrapper for the app Simple Feast.

### Only available for French market

- [node-foodcheri](https://github.com/jzarca01/node-foodcheri) - Foodcheri API Wrapper for Node.js.
- [node-frichti](https://github.com/jzarca01/node-frichti) - Un wrapper d'API pour Frichti.
- [node-nestor](https://github.com/jzarca01/node-nestor) - Nestor API wrapper for Node.js.
- [node-mcdofrance](https://github.com/jzarca01/node-mcdofrance) - API for McDonald's France.
- [FoodtttruckAPI](https://github.com/jzarca01/FoodtttruckAPI.git) - An unofficial tttruck.com API to find foodtrucks.
- [node-dominos-france](https://github.com/jzarca01/node-dominos-france.git) - Une API pour l'app Promos de Domino's Pizza.
- [node-kebab](https://github.com/jzarca01/node-kebab) - Un wrapper d'API pour kebab-frites.info .

## Sport nutrition

- [fitness](https://github.com/jamesflorentino/fitness) - Some of @jamesflorentino mumbo jumbo about training and nutrition. Take them with a grain of salt.
- [affordable-whey](https://github.com/prkeshri/affordable-whey) - Can be used to calculate out of a few available Whey proteins. which one is most affordable in terms of Cost per Serving. Also gives. total servings.

## Things to read

### Books

- [The 4-hour Chef](https://www.goodreads.com/book/show/13129810-the-4-hour-chef) - The Simple Path to Cooking Like a Pro, Learning Anything, and Living the Good Life by Timothy Feriss
- [How to bake Pi](https://www.goodreads.com/book/show/23360039-how-to-bake-pi) - An Edible Exploration of the Mathematics of Mathematics by Eugenia Cheng

### Forums and chat groups

- [/r/cooking](https://www.reddit.com/r/Cooking/) - /r/Cooking is a place for the cooks of reddit and those who want to learn how to cook.
- [/r/GifRecipes](https://www.reddit.com/r/GifRecipes/) - Recipes in an easy to follow gif format.
- [/r/AskCulinary](https://www.reddit.com/r/AskCulinary/) - /r/AskCulinary provides expert guidance for your specific cooking problems to help people of all skill levels become better cooks, to increase understanding of cooking, and to share valuable culinary knowledge.
- [/r/recipes](https://www.reddit.com/r/recipes/) - Improve and share your cooking repertoire with recipes from reddit's community.
- [/r/IndianFood](https://www.reddit.com/r/IndianFood/) - Indian Food is your step by step guide to simple and delicious home cooking. From regional Indian cuisine to popular dishes from around the globe, our community's focus is to make cooking easy.

## Courses and MOOCs

- [Child Nutrition and Cooking](https://www.coursera.org/learn/childnutrition) - This course examines contemporary child nutrition and the impact of the individual decisions made by each family. The health risks associated with obesity in childhood are also discussed.
- [Science & Cooking: From Haute Cuisine to Soft Matter Science (chemistry)](https://www.edx.org/course/science-cooking-from-haute-cuisine-to-soft-matter-science-chemistry) - Top chefs and Harvard researchers explore how everyday cooking and haute cuisine can illuminate basic principles in chemistry, physics, and engineering.
- [Science & Cooking: From Haute Cuisine to Soft Matter Science (physics)](https://www.edx.org/course/science-cooking-from-haute-cuisine-to-soft-matter-science-physics-2) - Part 2 of the class above, learn about elasticity, viscosity, mayonnaise, baking, and more!

## Videos

### Italian Cuisine

- [Jamie Oliver](https://www.youtube.com/user/JamieOliver) - A notorious british chef, this guy has books and restaurants everywhere

### Asian cuisine

- [Peaceful Cuisine](https://www.youtube.com/user/ryoya1983) - Asian cooking, relaxing and beautiful
- [Asian at Home](https://www.youtube.com/user/SeonkyoungLongest) - She talks too much but the food looks great


## Contribute

Contributions welcome! Read the [contribution guidelines](contributing.md) first.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](http://creativecommons.org/publicdomain/zero/1.0)

To the extent possible under law. Jérémie Zarca has waived all copyright and
related or neighboring rights to this work.
