# Contributing

We love pull requests from everyone. By contributing to this repository, you
agree to abide by the [Code of Conduct](CODE_OF_CONDUCT.md).

## Get Started  

* First [fork][fork] the repository and then clone it using:

    git clone git@github.com:your-username/algorithms.git  

* After that create a branch for your changes. For example:  
  * add_XXX if you will add new algorithms or data structures.  
  * fix_XXX if you will fix a bug on a certain algorithm or data structure.  
  * test_XXX if you wrote a test/s.  
  * doc_XXX if you added to or edited documentation.

You may contribute by:
- implementing new algorithms in the repo. Be sure to keep it under
right section (e.g. [array](array), [dp](dp), etc). Make a new section for it if
it doesn't fall under any section. Make sure that your implementation works.  
- optimizing or improving the existing algorithms.
- adding a different solution for the problem.
- finding and fixing bugs.
- adding examples to explain the algorithms better.
- adding test cases.
- improving documentation.

## Pull Requests
Push to your fork and [submit a pull request][pr].

We will review and may suggest some changes or improvements or alternatives.
Some things that will increase the chance that your pull request is accepted:

* All algorithms should be written in **Python 3**.
(There are a few algorithms still in _Python 2_ syntax. You can start by converting
[those][issue120] to _Python 3_.)
* Write clean and understandable code.
* Properly comment the code and briefly explain what the algorithm is doing in the [docstrings][docstr].
* You may also explain the output using a minimal example.
* Try to also include a couple of test cases for the algorithm.
* Write a [good commit message][commit].


## Issues
Submit a [new issue][newissue] if there is an algorithm to add, or if a bug was found in an existing algorithm. Before submitting a new issue please review the [existing issues][issues] to avoid creating duplicates. Also, consider resolving current issues or contributing to the discussion on an issue.

## Collaborators
You can ask for any help or clarifications from the collaborators.  
[Keon Kim](https://github.com/keon)

[Rahul Goswami](https://github.com/goswami-rahul)

[Ankit Agarwal](https://github.com/ankit167)

[Hai Hoang Dang](https://github.com/danghai)

[Saad](https://github.com/SaadBenn)

[fork]: https://help.github.com/articles/fork-a-repo/
[docstr]: https://www.python.org/dev/peps/pep-0257/#multi-line-docstrings
[commit]: http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html
[pr]: https://github.com/keon/algorithms/compare/
[newissue]: https://github.com/keon/algorithms/issues/new
[issue120]: https://github.com/keon/algorithms/issues/120
[issues]: https://github.com/keon/algorithms/issues/
