## 📝 Description

**⚠️ Issue Link Required**: This PR must be linked to an approved and assigned issue. See [Contributing Guide](https://github.com/kornia/kornia/blob/main/CONTRIBUTING.md#pull-request) for details.

**Fixes/Relates to:** # (issue number)

**Important**:
- Ensure you are assigned to the linked issue before submitting this PR
- This PR should strictly implement what the linked issue describes
- Do not include changes beyond the scope of the linked issue

---

## 🛠️ Changes Made
- [ ] Item 1
- [ ] Item 2

---

## 🧪 How Was This Tested?
- [ ] **Unit Tests:** (List new/updated tests)
- [ ] **Manual Verification:** (Describe the steps you took)
- [ ] **Performance/Edge Cases:** (How does this handle nulls, large data, etc.?)

---

## 🕵️ AI Usage Disclosure
*Check one of the following:*
- [ ] 🟢 **No AI used.**
- [ ] 🟡 **AI-assisted:** I used AI for boilerplate/refactoring but have manually reviewed and tested every line.
- [ ] 🔴 **AI-generated:** (Note: These PRs may be subject to stricter scrutiny or immediate closure if the logic is not explained).

---

## 🚦 Checklist
- [ ] I am assigned to the linked issue (required before PR submission)
- [ ] The linked issue has been approved by a maintainer
- [ ] I have performed a **self-review** of my code (no "ghost" variables or hallucinations).
- [ ] My code follows the existing style guidelines of this project.
- [ ] I have commented my code, particularly in hard-to-understand areas.
- [ ] I have added tests that prove my fix is effective or that my feature works.
- [ ] (Optional) I have attached screenshots/recordings for UI changes.

---

## 💭 Additional Context
Add any other context or screenshots about the pull request here.
