# LICENSE HEADER MANAGED BY add-license-header
#
# Copyright 2018 Kornia Team
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

from typing import Dict, List, NamedTuple, Optional, Union

import torch

__all__ = ["ParamItem", "PatchParamItem"]


class ParamItem(NamedTuple):
    """Store the parameters for a single augmentation operation.

    Attributes:
        name: The name of the augmentation operation.
        data: The dictionary of parameters or a list of nested parameters.
    """

    name: str
    data: Optional[Union[Dict[str, torch.Tensor], List["ParamItem"]]]


class PatchParamItem(NamedTuple):
    """Store parameters for patch-based augmentation operations.

    Attributes:
        indices: The list of patch indices where the augmentation is applied.
        param: The specific :class:`ParamItem` containing the operation parameters.
    """

    indices: List[int]
    param: ParamItem
