# LICENSE HEADER MANAGED BY add-license-header
#
# Copyright 2018 Kornia Team
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

"""Kornia Augmentation Utils — Helper functions and utilities for augmentations.

This subpackage provides internal helpers and utility functions for augmentation modules.
"""

from kornia.augmentation.utils.helpers import (
    _adapted_beta,
    _adapted_rsampling,
    _adapted_sampling,
    _adapted_uniform,
    _infer_batch_shape,
    _infer_batch_shape3d,
    _shape_validation,
    _transform_input,
    _transform_input3d,
    _transform_input3d_by_shape,
    _transform_input_by_shape,
    _transform_output_shape,
    _validate_input,
    _validate_input3d,
    _validate_input_dtype,
    _validate_input_shape,
    _validate_shape,
    deepcopy_dict,
    override_parameters,
)
from kornia.augmentation.utils.param_validation import (
    _common_param_check,
    _joint_range_check,
    _range_bound,
    _singular_range_check,
    _tuple_range_reader,
)

__all__ = [
    "_adapted_beta",
    "_adapted_rsampling",
    "_adapted_sampling",
    "_adapted_uniform",
    "_common_param_check",
    "_infer_batch_shape",
    "_infer_batch_shape3d",
    "_joint_range_check",
    "_range_bound",
    "_shape_validation",
    "_singular_range_check",
    "_transform_input",
    "_transform_input3d",
    "_transform_input3d_by_shape",
    "_transform_input_by_shape",
    "_transform_output_shape",
    "_tuple_range_reader",
    "_validate_input",
    "_validate_input3d",
    "_validate_input_dtype",
    "_validate_input_shape",
    "_validate_shape",
    "deepcopy_dict",
    "override_parameters",
]
