# LICENSE HEADER MANAGED BY add-license-header
#
# Copyright 2018 Kornia Team
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

"""SAM-3 (Segment Anything Model v3) integration for Kornia.

This module provides the Segment Anything Model v3 (SAM-3) implementation for image segmentation tasks.
SAM-3 is a foundation model for image segmentation that can segment any object in an image with zero-shot
capability.
"""

from __future__ import annotations

from .architecture import ImageEncoderHiera

__all__ = ["ImageEncoderHiera"]
