# Generated by Django 4.2 on 2023-04-19 02:43

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Agent",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                ("purpose", models.TextField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("model", models.CharField(max_length=255)),
                ("system_prompt", models.TextField()),
                ("commands", models.JSONField(blank=True, null=True)),
                ("config", models.JSONField()),
            ],
        ),
        migrations.CreateModel(
            name="Resource",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("vector_memory", "Vector Memory"),
                            ("database", "Database"),
                            ("file_system", "File System"),
                            ("cache", "Cache"),
                            ("api", "API"),
                            ("knowledge_base", "Knowledge Base"),
                            ("image_database", "Image Database"),
                            ("audio_database", "Audio Database"),
                            ("video_database", "Video Database"),
                            ("cloud_storage", "Cloud Storage"),
                            ("content_delivery_network", "Content Delivery Network"),
                            ("message_queue", "Message Queue"),
                            ("stream_processing", "Stream Processing"),
                        ],
                        max_length=32,
                    ),
                ),
                ("config", models.JSONField()),
                (
                    "agent",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="resources",
                        to="agents.agent",
                    ),
                ),
            ],
        ),
    ]
