from typing import List, Iterator, Optional

from langchain_community.document_loaders.base import BaseLoader
from langchain.schema import Document


class StringLoader(BaseLoader):
    """A loader that constructs a document from a text string.

    This is used for testing and for creating documents from
    text generated by chains.

    Combine with IngestionTool and parameterize the text input to create a tool
    that an agent can use to store arbitrary data
    """

    text: str
    metadata: Optional[dict] = None

    def __init__(self, text: str, metadata: Optional[dict] = None):
        self.text = text
        self.metadata = metadata

    def load(self) -> List[Document]:
        metadata = self.metadata or {}
        documents = [Document(page_content=self.text, metadata=metadata)]
        return documents

    def lazy_load(self) -> Iterator[Document]:
        metadata = self.metadata or {}
        documents = [Document(page_content=self.text, metadata=metadata)]
        return documents
