# Generated by Django 4.2 on 2023-05-01 03:08

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="ChainNode",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("class_path", models.CharField(max_length=255)),
                ("config", models.JSONField(null=True)),
                ("name", models.CharField(max_length=255, null=True)),
                ("description", models.TextField(null=True)),
                (
                    "node_type",
                    models.CharField(
                        choices=[("node", "node"), ("list", "list"), ("map", "map")],
                        default="node",
                        max_length=10,
                    ),
                ),
                (
                    "parent",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="children",
                        to="chains.chainnode",
                    ),
                ),
                (
                    "root",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="descendants",
                        to="chains.chainnode",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ChainEdge",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("key", models.CharField(max_length=255, null=True)),
                ("input_map", models.JSONField(null=True)),
                (
                    "root",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="edges",
                        to="chains.chainnode",
                    ),
                ),
                (
                    "source",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="outgoing_edges",
                        to="chains.chainnode",
                    ),
                ),
                (
                    "target",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="incoming_edges",
                        to="chains.chainnode",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Chain",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("name", models.CharField(max_length=128)),
                ("description", models.TextField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "root",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="chains",
                        to="chains.chainnode",
                    ),
                ),
            ],
        ),
    ]
