# Generated by Django 4.2.2 on 2023-09-03 22:43

from django.db import migrations, models


def noop(apps, schema_editor):
    pass


def create_agents(apps, schema_editor):
    """Create an agent for each chain if one does not exist"""
    Agent = apps.get_model("agents", "Agent")
    Chain = apps.get_model("chains", "Chain")
    for chain in Chain.objects.all():
        if not Agent.objects.filter(chain=chain).exists():
            # strip spaces, dashes, and special characters
            alias = "".join([c.lower() for c in chain.name if c.isalnum()])
            Agent.objects.create(
                chain=chain, name=chain.name, purpose=chain.description, alias=alias
            )


class Migration(migrations.Migration):
    dependencies = [
        ("chains", "0008_nodetype_config_schema"),
    ]

    operations = [
        migrations.AddField(
            model_name="chain",
            name="is_agent",
            field=models.BooleanField(default=True),
        ),
        migrations.RunPython(create_agents, noop),
    ]
