# Generated by Django 4.2.6 on 2023-11-05 22:10

from django.db import migrations, models


def key_to_target_key(apps, schema_editor):
    ChainEdge = apps.get_model("chains", "ChainEdge")
    for edge in ChainEdge.objects.all():
        edge.target_key = edge.key
        edge.save()


def target_key_to_key(apps, schema_editor):
    ChainEdge = apps.get_model("chains", "ChainEdge")
    for edge in ChainEdge.objects.all():
        edge.key = edge.target_key
        edge.save()


class Migration(migrations.Migration):
    dependencies = [
        ("chains", "0012_chain_group_chain_user_nodetype_group_nodetype_user"),
    ]

    operations = [
        migrations.AddField(
            model_name="chainedge",
            name="source_key",
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.AddField(
            model_name="chainedge",
            name="target_key",
            field=models.CharField(max_length=255, null=True),
        ),
        migrations.RunPython(key_to_target_key, target_key_to_key),
        migrations.RemoveField(model_name="chainedge", name="key"),
    ]
