# Generated by Django 4.2.1 on 2023-05-22 03:22

from django.db import migrations


def forward(apps, schema_editor):
    TaskLogMessage = apps.get_model("task_log", "TaskLogMessage")
    for msg in TaskLogMessage.objects.all():
        msg.role = msg.role.upper()
        msg.save()


def backwards(apps, schema_editor):
    TaskLogMessage = apps.get_model("task_log", "TaskLogMessage")
    for msg in TaskLogMessage.objects.all():
        msg.role = msg.role.lower()
        msg.save()


class Migration(migrations.Migration):
    """Converts all TaskLogMessage roles to uppercase for conversion to FastAPI enum"""

    dependencies = [
        ("task_log", "0008_alter_task_parent"),
    ]

    operations = [
        migrations.RunPython(
            forward,
            backwards,
        ),
    ]
