import sys
import traceback
import uuid
from importlib.machinery import SourceFileLoader

if __name__ == "__main__":
    files = sys.argv[1:]
    has_failure = False
    for file in files:
        try:
            module_name = f"test_module_{uuid.uuid4().hex[:20]}"
            SourceFileLoader(module_name, file).load_module()
        except Exception:  # noqa: BLE001
            has_failure = True
            print(file)  # noqa: T201
            traceback.print_exc()
            print()  # noqa: T201

    sys.exit(1 if has_failure else 0)
