// ============================================================================
// USER-DEFINED TEST INPUT - ADD YOUR TEST DATA HERE
//
// 1. For testing string parsing:
//    Modify USER_DEFINED_TEST_INPUT below (used in "user-defined input" test)
//
// 2. For testing object parsing with performance measurement:
//    Replace USER_DEFINED_TEST_OBJECT below (used in "custom object" test)
//    This test will show you the performance comparison and verify both
//    implementations produce identical results
//
// ============================================================================

const USER_DEFINED_TEST_INPUT =
  '{"message": "hello", "nested": "{\\"inner\\": \\"world\\"}"}';

const USER_DEFINED_TEST_OBJECT: any = {
  // Example: Replace with your own test data from production traces
  data: '{"key": "value"}',
  nested: '{"level1": "{\\"level2\\": \\"value\\"}"}',
  largeOutput1: `[{\"timestamp\":\"2025-11-04T17:37:55.789705Z\",\"message_uuid\":\"591ccc1a-84fc-4b0d-9581-39c34d97727f\",\"role\":\"assistant\",\"stop_reason\":\"tool_use\",\"content\":[{\"type\":\"text\",\"text\":\"I'll retrieve the details of this symphony to analyze it for you.\"},{\"type\":\"tool_use\",\"id\":\"toolu_01BgX5ynSCRKmHsoF7Hdfcgs\",\"name\":\"get-symphony-details\",\"input\":{\"symphony_sid\":\"o29Qg1pv9naYVT5CIaRF\"}}]},{\"timestamp\":\"2025-11-04T17:37:55.856370Z\",\"message_uuid\":\"6deb37c5-e9de-48bb-9b85-f84a4f97d1ca\",\"role\":\"user\",\"stop_reason\":\"tool_result\",\"content\":[{\"type\":\"tool_result\",\"tool_use_id\":\"toolu_01BgX5ynSCRKmHsoF7Hdfcgs\",\"content\":\"Found symphony details:{\\\"description\\\":\\\"OOS Jan 8 2024\\\",\\\"community_review_status\\\":\\\"ACTIVE\\\",\\\"owner_name\\\":null,\\\"stats_sharpe_ratio\\\":3.3386612624831535,\\\"tags\\\":[],\\\"stats_mean\\\":0.006868660401759723,\\\"last_semantic_update_at\\\":\\\"2024-01-08T13:16:37.700142-05:00[America/New_York]\\\",\\\"stats_max_drawdown\\\":0.1587351673971642,\\\"color\\\":\\\"#E3BC99\\\",\\\"rebalance_frequency\\\":\\\"daily\\\",\\\"risk_rationale\\\":null,\\\"version_id\\\":889867,\\\"name\\\":\\\"Growth Blend v2.2 RL\\\",\\\"risk_rating\\\":null,\\\"asset_class\\\":\\\"EQUITIES\\\",\\\"owner_link_url\\\":null,\\\"last_backtest_value\\\":206950.01,\\\"is_deleted\\\":false,\\\"last_backtest_last_market_day\\\":\\\"2025-11-03\\\",\\\"stats_trailing_three_month_return\\\":0.6154624297084581,\\\"is_discover_symphony\\\":false,\\\"youtube_url\\\":null,\\\"sparkgraph_gcs_url\\\":\\\"https://storage.googleapis.com/composer-prod-cache/sparkgraphs/o29Qg1pv9naYVT5CIaRF.png?X-Goog-Algorithm=GOOG4-RSA-SHA256&X-Goog-Credential=backtest-server%40leverheads-278521.iam.gserviceaccount.com%2F20251104%2Fauto%2Fstorage%2Fgoog4_request&X-Goog-Date=20251104T052053Z&X-Goog-Expires=604800&X-Goog-SignedHeaders=host&X-Goog-Signature=3bf44607faec16996e49813f1b3a8c69239d043142d04b336640b1cf306db850f6b4c5c1bf436272944ee15ff8b3e59b73aad52cb8e4350faf04e708b6947e7efe53864e52180af6405b8707933d07e80141f35fde0db19f3e3680131742ea291646de2654e639e4da9a2451e81817c1dfb5ff3fcf996459369de64bd79e7a238ad2a265edc322f99099cddefad28c34da60a732c397ca2feca19abb20f5748bc8808568f94052cb1ca781d942291ea895937aa0fe7418f7d2a2fe619b37b87f630ff087f456a7362b12c1ecd035dd3a208387632466f3c8ac2cfda05c2f75f1ed9abbb954d46d17c3b8f2a4aac1cbeeb2d12509f520f07549ea81d8f242bfd6\\\",\\\"stats_cumulative_return\\\":1.0695001000000002,\\\"symphony_sid\\\":\\\"o29Qg1pv9naYVT5CIaRF\\\",\\\"symphony_id\\\":1376690,\\\"rebalance_corridor_width\\\":null,\\\"updated_at\\\":\\\"2025-11-04T00:20:53.503730-05:00[America/New_York]\\\",\\\"stats_median\\\":0.00202188742828624,\\\"categories\\\":null,\\\"is_searchable_updated_at\\\":\\\"2025-07-16T16:13:33.900622-04:00[America/New_York]\\\",\\\"stats_standard_deviation\\\":0.5184420596044772,\\\"stats_size\\\":115,\\\"stats_annualized_rate_of_return\\\":3.8550137484883393,\\\"last_backtest_first_market_day\\\":\\\"2025-05-20\\\",\\\"stats_min\\\":-0.11020513767548801,\\\"last_backtest_holdings\\\":{\\\"UCO\\\":0.0,\\\"SH\\\":0.0,\\\"EUO\\\":0.0,\\\"TECS\\\":0.0,\\\"SHY\\\":0.0,\\\"DRIP\\\":0.0,\\\"TQQQ\\\":0.0,\\\"FNGU\\\":0.0,\\\"JDST\\\":0.0,\\\"TNA\\\":0.0,\\\"LABD\\\":0.0,\\\"CURE\\\":0.0,\\\"PSQ\\\":6993.91720175735,\\\"AGG\\\":0.0,\\\"USDU\\\":0.0,\\\"DRV\\\":0.0,\\\"TMF\\\":0.0,\\\"DIA\\\":0.0,\\\"NRGD\\\":0.0,\\\"EDC\\\":0.0,\\\"FNGD\\\":0.0,\\\"EFA\\\":0.0,\\\"TLT\\\":0.0,\\\"SQQQ\\\":0.0,\\\"ERX\\\":0.0,\\\"GUSH\\\":0.0,\\\"HIBL\\\":0.0,\\\"URTY\\\":0.0,\\\"DBC\\\":0.0,\\\"SOXS\\\":0.0,\\\"HIBS\\\":0.0,\\\"QQQ\\\":0.0,\\\"PUI\\\":0.0,\\\"SOXX\\\":0.0,\\\"SPXL\\\":0.0,\\\"EEM\\\":0.0,\\\"SOXL\\\":0.0,\\\"XLP\\\":0.0,\\\"BSV\\\":0.0,\\\"QLD\\\":0.0,\\\"YCS\\\":0.0,\\\"UVXY\\\":0.0,\\\"EPI\\\":0.0,\\\"NRGU\\\":0.0,\\\"LABU\\\":0.0,\\\"GLD\\\":0.0,\\\"USD\\\":0.0,\\\"NAIL\\\":0.0,\\\"TMV\\\":0.0,\\\"UUP\\\":0.0,\\\"$USD\\\":0.01,\\\"UGL\\\":0.0,\\\"SPY\\\":0.0,\\\"UPRO\\\":0.0,\\\"EURL\\\":0.0,\\\"SMH\\\":0.0,\\\"SPXU\\\":0.0,\\\"TZA\\\":0.0,\\\"TECL\\\":0.0,\\\"FAS\\\":0.0,\\\"MVV\\\":0.0,\\\"SPXS\\\":0.0,\\\"YINN\\\":0.0,\\\"TYO\\\":0.0,\\\"EWZ\\\":0.0,\\\"VIXY\\\":0.0,\\\"DFEN\\\":0.0,\\\"MIDU\\\":0.0,\\\"BIL\\\":0.0},\\\"is_searchable\\\":true,\\\"stats_calmar_ratio\\\":24.2858202860799,\\\"user_id\\\":84,\\\"stats_max\\\":0.10912995641158485,\\\"is_shared\\\":true,\\\"stats_trailing_one_year_return\\\":null,\\\"user_sid\\\":\\\"6wRCLDYOREdOwzpGoISeJVV17FF2\\\",\\\"copied_from_symphony_sid\\\":\\\"ITRu3JQZjEaAYWUSiLiQ\\\",\\\"version_sid\\\":\\\"9DXskKvZBRhOBi7lWObw\\\",\\\"owner_link_text\\\":null,\\\"hashtag\\\":\\\"#GBvR\\\",\\\"created_at\\\":\\\"2023-12-10T19:36:00.762436-05:00[America/New_York]\\\",\\\"asset_classes\\\":[\\\"EQUITIES\\\"],\\\"twitter_handle\\\":null,\\\"copied_from_symphony_id\\\":1376205,\\\"ai_description\\\":{\\\"summary\\\":\\\"Daily, rules-based swing strategy. In uptrends it rides leveraged tech/semis; when momentum weakens or bonds/vol warn, it cuts risk or flips to inverse or volatility. Very aggressive; uses 3x ETFs and UVXY, so drawdowns can be large.\\\",\\\"categories\\\":\\\"Leveraged ETFs, trend-following, momentum, mean reversion, risk-on/off, tech-focused, volatility hedge, tactical allocation\\\",\\\"how_it_works\\\":\\\"Each day the rules check if stocks are trending up or losing steam and what bonds/commodities are signaling. If uptrend: buy the strongest tech/semis funds (e.g., TQQQ=3x Nasdaq, SOXL=3x semis, TECL=3x tech). If things look overheated, hedge with UVXY (volatility). If momentum fades or drops: cut leverage or switch to SQQQ/SOXS/TECS (3x short tech), cash-like T‑bills (BIL/SHY), or long/short Treasuries (TMF/TMV). Special rules handle sideways markets and sharp selloffs.\\\"},\\\"stats_trailing_one_month_return\\\":0.624463150081549}\",\"user-content\":null,\"user-content-type\":null}]},{\"timestamp\":\"2025-11-04T17:38:03.996646Z\",\"message_uuid\":\"3823bcfc-b774-4bdb-a613-393739d97c82\",\"role\":\"assistant\",\"stop_reason\":\"tool_use\",\"content\":[{\"type\":\"text\",\"text\":\"Now let me present this symphony with a detailed backtest to show you its structure and performance:\"},{\"type\":\"tool_use\",\"id\":\"toolu_01FkiaQynpiVZ2KiedENG8TU\",\"name\":\"present-symphony-to-user\",\"input\":{\"symphony\":{\"symphony_sid\":\"o29Qg1pv9naYVT5CIaRF\"},\"capital\":10000,\"start_date\":\"2025-05-20\",\"end_date\":\"2025-11-03\",\"broker\":\"ALPACA_WHITE_LABEL\",\"sparkgraph_color\":\"#1EC072\",\"benchmark_tickers\":[\"EQUITIES::SPY//USD\",\"EQUITIES::QQQ//USD\",\"EQUITIES::TQQQ//USD\"]}}]},{\"timestamp\":\"2025-11-04T17:38:05.133015Z\",\"message_uuid\":\"9f1dc68b-b8c5-45bc-bd7c-a2ec871a34ac\",\"role\":\"user\",\"stop_reason\":\"tool_result\",\"content\":[{\"type\":\"tool_result\",\"tool_use_id\":\"toolu_01FkiaQynpiVZ2KiedENG8TU\",\"content\":\"{\\\"backtest_parameters\\\":{\\\"benchmark_tickers\\\":[\\\"EQUITIES::SPY//USD\\\",\\\"EQUITIES::QQQ//USD\\\",\\\"EQUITIES::TQQQ//USD\\\"],\\\"apply_subscription\\\":\\\"none\\\",\\\"capital\\\":10000,\\\"sparkgraph_color\\\":\\\"#E3BC99\\\",\\\"end_date\\\":\\\"2025-11-03\\\",\\\"broker\\\":\\\"ALPACA_WHITE_LABEL\\\",\\\"start_date\\\":\\\"2025-05-20\\\",\\\"slippage_percent\\\":1.0E-4,\\\"backtest_version\\\":\\\"v1\\\",\\\"apply_reg_fee\\\":true,\\\"apply_taf_fee\\\":true},\\\"backtest_response\\\":{\\\"data_warnings\\\":{},\\\"stats\\\":{\\\"skewness\\\":0.192523816784483,\\\"min\\\":-0.11020645335940404,\\\"top_five_percent_day_contribution\\\":0.7006265169182517,\\\"annualized_rate_of_return\\\":3.855624833310025,\\\"mean\\\":0.006868987690372397,\\\"herfindahl_index\\\":0.616950786882194,\\\"benchmarks\\\":{\\\"SPY\\\":{\\\"skewness\\\":-0.5945802516144346,\\\"min\\\":-0.027027832409559527,\\\"top_five_percent_day_contribution\\\":0.6010744780343567,\\\"annualized_rate_of_return\\\":0.3785767699495075,\\\"mean\\\":0.0013084125629610228,\\\"herfindahl_index\\\":1.0,\\\"top_ten_percent_day_contribution\\\":0.9998639422406214,\\\"top_one_day_contribution\\\":0.13922416095929252,\\\"calmar_ratio\\\":12.684111977138521,\\\"sortino_ratio\\\":4.750465091290724,\\\"win_rate\\\":0.5739130434782609,\\\"sharpe_ratio\\\":3.0854055217000056,\\\"tail_ratio\\\":1.2390895922887528,\\\"trailing_two_week_return\\\":0.017935349322210747,\\\"size\\\":115,\\\"cumulative_return\\\":0.15926441149526685,\\\"trailing_one_month_return\\\":0.02111444837943255,\\\"max_drawdown\\\":0.02984653325608,\\\"median\\\":0.0018766677418409206,\\\"max\\\":0.020788468218131406,\\\"standard_deviation\\\":0.10686438575001567,\\\"percent\\\":{\\\"alpha\\\":1.431393262541945,\\\"beta\\\":0.9086244887987593,\\\"r_square\\\":0.035090027172886847,\\\"pearson_r\\\":0.187323322554579},\\\"kurtosis\\\":2.703461473181055,\\\"log\\\":{\\\"alpha\\\":1.301059946295116,\\\"beta\\\":0.9041968430305519,\\\"r_square\\\":0.03532956289763303,\\\"pearson_r\\\":0.18796159952935343},\\\"trailing_one_week_return\\\":-0.0027727511528806703,\\\"trailing_three_month_return\\\":0.08566616885386558},\\\"QQQ\\\":{\\\"skewness\\\":-0.6580964281336055,\\\"min\\\":-0.03471426232192576,\\\"top_five_percent_day_contribution\\\":0.5620049230155036,\\\"annualized_rate_of_return\\\":0.5339930573938847,\\\"mean\\\":0.0017494416821785615,\\\"herfindahl_index\\\":1.0,\\\"top_ten_percent_day_contribution\\\":0.9345469341942809,\\\"top_one_day_contribution\\\":0.11813317675617799,\\\"calmar_ratio\\\":14.881709891199442,\\\"sortino_ratio\\\":5.058992356726268,\\\"win_rate\\\":0.6173913043478261,\\\"sharpe_ratio\\\":3.2943371382455613,\\\"tail_ratio\\\":1.200026955246937,\\\"trailing_two_week_return\\\":0.033587336887202834,\\\"size\\\":115,\\\"cumulative_return\\\":0.21769284118055018,\\\"trailing_one_month_return\\\":0.04793010262446762,\\\"max_drawdown\\\":0.035882506869030606,\\\"median\\\":0.002409852042172478,\\\"max\\\":0.02354006337709369,\\\"standard_deviation\\\":0.13382337186769608,\\\"percent\\\":{\\\"alpha\\\":1.352473956662842,\\\"beta\\\":0.8585753730381417,\\\"r_square\\\":0.049132587131625376,\\\"pearson_r\\\":0.22165871769823395},\\\"kurtosis\\\":2.56182541434515,\\\"log\\\":{\\\"alpha\\\":1.2260519170801754,\\\"beta\\\":0.8522488803818635,\\\"r_square\\\":0.049256733217186266,\\\"pearson_r\\\":0.22193857983051588},\\\"trailing_one_week_return\\\":0.006352592781289301,\\\"trailing_three_month_return\\\":0.12182308675280407},\\\"TQQQ\\\":{\\\"skewness\\\":-0.6757516489067605,\\\"min\\\":-0.10493314891655148,\\\"top_five_percent_day_contribution\\\":0.6244427670981875,\\\"annualized_rate_of_return\\\":2.0683441998396415,\\\"mean\\\":0.0048159733009711745,\\\"herfindahl_index\\\":1.0,\\\"top_ten_percent_day_contribution\\\":1.0385719327404401,\\\"top_one_day_contribution\\\":0.13041862361099574,\\\"calmar_ratio\\\":19.068697415625746,\\\"sortino_ratio\\\":4.588752155416851,\\\"win_rate\\\":0.6173913043478261,\\\"sharpe_ratio\\\":3.0290367577447093,\\\"tail_ratio\\\":1.1743387389428854,\\\"trailing_two_week_return\\\":0.09667253684308075,\\\"size\\\":115,\\\"cumulative_return\\\":0.6754460492778248,\\\"trailing_one_month_return\\\":0.13008595988538674,\\\"max_drawdown\\\":0.10846803820720063,\\\"median\\\":0.006609686609686527,\\\"max\\\":0.0696231269865295,\\\"standard_deviation\\\":0.4006637650539273,\\\"percent\\\":{\\\"alpha\\\":1.3807829520263675,\\\"beta\\\":0.2885585477428,\\\"r_square\\\":0.04974814192505628,\\\"pearson_r\\\":0.22304291498511286},\\\"kurtosis\\\":2.626247263866528,\\\"log\\\":{\\\"alpha\\\":1.2773518751936996,\\\"beta\\\":0.2798919958114465,\\\"r_square\\\":0.04799410835993486,\\\"pearson_r\\\":0.21907557682209777},\\\"trailing_one_week_return\\\":0.016232929657304718,\\\"trailing_three_month_return\\\":0.3542405860135056}},\\\"top_ten_percent_day_contribution\\\":1.1224325989782782,\\\"top_one_day_contribution\\\":0.1423967709015197,\\\"calmar_ratio\\\":24.2886900608678,\\\"sortino_ratio\\\":5.853297106134513,\\\"win_rate\\\":0.591304347826087,\\\"sharpe_ratio\\\":3.339394286727032,\\\"tail_ratio\\\":1.7392397008080502,\\\"trailing_two_week_return\\\":0.07759819138533763,\\\"size\\\":115,\\\"cumulative_return\\\":1.06962,\\\"annualized_turnover\\\":124.94288047325732,\\\"trailing_one_month_return\\\":0.6243575938140642,\\\"max_drawdown\\\":0.15874157163880698,\\\"median\\\":0.002019649191430606,\\\"max\\\":0.10912834213931322,\\\"standard_deviation\\\":0.5183529554607931,\\\"kurtosis\\\":2.372566670435905,\\\"trailing_one_week_return\\\":0.009359997034765533,\\\"trailing_three_month_return\\\":0.6154014268096599},\\\"costs\\\":{\\\"reg_fee\\\":21.09,\\\"taf_fee\\\":6.88,\\\"slippage\\\":149.57,\\\"spread_markup\\\":0.0,\\\"subscription\\\":0.0}},\\\"symphony\\\":{\\\"symphony_sid\\\":\\\"o29Qg1pv9naYVT5CIaRF\\\",\\\"symphony_score\\\":{\\\"description\\\":\\\"OOS Jan 8 2024\\\",\\\"children\\\":[{\\\"id\\\":\\\"5bdb855c-0cc5-4b78-8a37-675454e810c6\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"653e0d71-d2f1-4209-8b30-00fa51b471cb\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":\\\"70\\\",\\\"den\\\":100},\\\"id\\\":\\\"80800a19-d0ab-4499-a892-bc507ad15ee2\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Blend Growth Amoeba\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"7d84659e-822b-4c04-9bda-7338543cc254\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"f0903332-6277-4731-aa59-f5fca8908332\\\",\\\"children\\\":[{\\\"id\\\":\\\"49429233-ff9d-481e-a79b-d609e16b59fb\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"TQQQ FTLT w/Sideways Market Mods\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"b3a84771-6a3b-41da-94e4-2cb240c47a33\\\",\\\"children\\\":[{\\\"id\\\":\\\"e90ccd7a-62ec-481f-b6c2-9c07e222b379\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"d525ca7c-b549-4973-8002-3a35e1eeee2f\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"bb916311-514d-4e57-a953-8e6915d50ddc\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"e215eeac-5b57-46b2-b79c-50e687d9592d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4c9dd2a9-c753-4320-bdbd-191ccf28e4be\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":10.52,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1174265281}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"36b71d4d-24b4-46f8-931f-1132a23bf3d1\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"79\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":true},{\\\"id\\\":\\\"ce10f64c-33df-498f-91e8-268cafeda681\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"3f8ab8bc-7cf6-434f-bb9b-70ac9e46501c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"087d2cc6-678f-4f3a-8664-9b8b88c42497\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"89b8e553-a249-4849-8c85-da5c5bd68763\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":9.91,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.5052543003E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SPXL\\\",\\\"id\\\":\\\"1529ad51-ff77-41dd-8a24-f87d71003aa2\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"80\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"59705877-8750-41e0-83a2-f8fc96042686\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"7a427c19-0477-4fb9-a013-d0068964f59a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"7cc79d14-b662-41ab-affa-ca7df05c3034\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"6f0c0149-64d1-45ae-8be9-14cf0aee03e1\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"d4e29a3f-f579-43f9-9115-de6275f31438\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"f206146b-ae29-42cd-8d4d-18c9b5cfd9d2\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"step\\\":\\\"filter\\\",\\\"id\\\":\\\"83289541-0c10-4047-9cd9-63ed8410ec2e\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30},\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"6aaa44a7-1482-4df8-87d3-315c26bbe680\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"1d6b523a-298f-4614-afc4-4d89ded09612\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"53990b1b-e3d6-4ce1-928f-1f9b057a25cb\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"dcb1663c-ea28-4972-935e-418e86376b02\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"e17c69c2-cf82-462a-9193-c07c90ed335f\\\",\\\"step\\\":\\\"asset\\\"}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"1c2f88fe-20a0-4abf-a19b-2ad016a426b3\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"31\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"62c36e22-597f-4260-9ba4-d911a54e7873\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"11e3ffd1-ce98-4696-8b3f-71c3b269373b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"608855c2-a5a8-4297-b6b7-713ef0854854\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":12.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.0439159665E8},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ed674df9-8d4f-4bf2-9cb4-7e14c74bb464\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":61.32,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.65597774064E9},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"10bb042a-402a-4ca4-b521-30d3689b85c4\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"10\\\",\\\"id\\\":\\\"80f44002-8a8b-4306-a649-61dd64aa00e8\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}]}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"a684b607-f531-4bef-b9e3-a2f938cdd0a5\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"20\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"e9ba7dfa-a4b4-4bd9-aeeb-b79b3177a000\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"3ef93ff3-645f-490f-8861-15d59f6435ad\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"7ff2e255-f955-48f1-8568-c3049663a7e9\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"e93b3bd1-5730-46c6-ba20-4debcd86f680\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"6db9284d-496a-4231-acbf-29e21ebe26cc\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"4d4a31f2-e23a-4da8-8dfb-7957b5f71d73\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"a44877d5-07cf-4da9-a86e-52f01dc3559d\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"45410089-b2c3-418c-bbc7-e25fd71d976a\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}]}]}]}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"current-price\\\",\\\"rhs-window-days\\\":\\\"200\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"7ce23b5f-6fdb-4c5a-84e5-6d67383c4720\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"41d778f3-3328-4c3c-8c6c-6bb2fe35cd29\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"04e6d977-dbff-42f4-b9b7-a21dae3c277c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"b12ef05a-e52d-4d77-88a0-c55f386aa2ed\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fda7204b-1f15-4cb2-b0c1-6db104a93474\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.31,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.7078565207E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"3def3047-da6a-4e4d-92b5-edd6a55f641d\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"31\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":true},{\\\"id\\\":\\\"ba128f87-a5df-4c7b-875c-98b04d3fde58\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"dfea6d46-d616-4c12-822c-4cdfa525b26b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"bc6471a7-a621-4585-bdba-bf1e983b6944\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"4b61f4a7-6a60-4c23-8442-a3f4032b5797\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"76b70595-f8be-4ef0-a62b-1f17d92c1a66\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"1394c092-6894-44db-abd4-768a9ecf1468\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"5a43179a-e70d-4a4b-8918-740ae979765d\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"223c5957-0edf-4a9c-8325-16121fd8fae0\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"d631e45f-964f-4f69-b0cf-29659915bb23\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"ec66bfbf-2d64-403a-b3de-20a3d83681c0\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SMH\\\",\\\"id\\\":\\\"c72eeee4-c922-4dd8-94a3-5fc40eded614\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"2a40d039-32c4-48d3-ab68-6123829298b4\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"0b770bc4-2a09-47d0-9a1f-786a319082aa\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"5f3c15ba-e36e-4346-a83a-2ae8011ac45d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"d9ff8da8-f539-4fc8-8c58-653095918568\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"27430101-9a97-42f2-9954-fc066c8d4fd2\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"73f0160b-1ea2-4f5b-8ab8-87c687c47341\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"25aca5d1-6fa7-4186-8514-c5fc32c9c9b4\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"2aabd269-4b8b-43cf-b5e8-30434320e457\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"327b3ffb-9f1b-484e-9285-2ae6f75a821b\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"49a5e0c9-174c-448e-a7e7-7d7db53087bf\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"DIA\\\",\\\"id\\\":\\\"6508bf06-372d-4998-96f2-7c97001c9969\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"27\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"67d757a9-54e3-4cfd-8d22-c1d08f1be5e2\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"00d58eea-f136-4ebb-9ba1-d8af1044e566\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"0f78d6d0-a4c8-41ac-9284-0b65e47d02d5\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"4f2227d0-2e25-4ce7-a0fa-6fd3999ab65c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"0772a48d-b6b0-4535-a80c-0af42b352e0b\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"818f8fc0-8e3e-4c47-8302-9c4527d3cc41\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"a8dd0b3b-127d-4192-ab11-22181bd82023\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"1a68d138-2be1-4144-9873-b2a5fc13d18b\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"96f2eaf4-5845-47e5-ab80-fbbf0b3e7f25\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"7745ebbc-9ddc-4858-8463-8aa7bb269cb2\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"14\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"62cfe46d-c63d-4df1-af98-0626fe748c36\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"28\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"dba25787-3725-4533-9a30-1e4554f1301f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"04988eeb-473f-4050-af7a-45358dbd5ef5\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"5a9a6791-e224-481d-a70b-5aade7452a8b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"c78bd0ed-3150-41b9-bc9e-8732bff27b52\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"a346b830-c08b-447f-8d88-d2b9e20db09c\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Nasdaq In Crash Territory, Time to Deleverage\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"4cf36990-ff12-445b-95fd-f25247d53ffc\\\",\\\"children\\\":[{\\\"id\\\":\\\"0d19d47c-32c1-4eef-84b0-00f83980e95d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"7ef57af3-9152-41c0-8faa-48068c0474b9\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"b4df2030-3c60-45b0-90af-430f957b69e5\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"aa81e1ad-9999-4c1b-b914-b19d4d158f90\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Sideways Market Deleverage\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"3a3cb284-5f3b-4c6f-a252-d5b7c00a49ae\\\",\\\"children\\\":[{\\\"id\\\":\\\"6df7d22e-5cfc-40d6-85aa-456997a09747\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"5cd804b8-60df-4a95-a3ee-e418b4a07740\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"SPDR S&P 500 ETF Trust\\\",\\\"ticker\\\":\\\"SPY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4365438f-2b49-43d1-a3c0-37850b9d336c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":379.95,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.53587893181E10}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"current-price\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"f4c9d5b1-68f9-412e-b62e-eb1a071c2dad\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"6947b120-eca5-498f-a072-3b7b8bd780dc\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"d1d4c0e4-5933-464e-983b-b6f4e040cc84\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"baf8dc2b-892e-464c-ae91-104b63fca2bb\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"Invesco QQQ Trust\\\",\\\"ticker\\\":\\\"QQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b35cac78-2516-4a9c-983b-2a627a6955a9\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":269.54,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6819746131800001E10}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"10\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"4ebcedd9-d5f3-4020-9794-a1f08ce18326\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SQQQ\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"0accbfa7-24c0-483b-8a38-372008c2da16\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares Short QQQ\\\",\\\"ticker\\\":\\\"PSQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cb8fd7fe-131a-48fe-ad05-dae5d896dac1\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":14.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.5279310004E8}]}]}]}]}]},{\\\"id\\\":\\\"7b590c87-6ab4-49d9-b959-1baff3bb3841\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"Invesco QQQ Trust\\\",\\\"ticker\\\":\\\"QQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2c1e94fc-b10b-48ee-ad24-ea76eec3bd86\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":269.54,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6819746131800001E10}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"10\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"4bea4737-320e-4bbc-9277-62b9b86f804f\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SQQQ\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"3f453478-d7b2-4e52-adb4-7eead18df82f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares Short QQQ\\\",\\\"ticker\\\":\\\"PSQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"478a6864-51d2-412b-b529-b8e7058fd2ab\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":14.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.5279310004E8}]}]}]}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"60\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"dc6726a8-7648-4a48-9ae1-aa7e4b5987a2\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"-12\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"bd0cd85e-dd25-43f4-ab10-35e70680f59d\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"a8c53623-ec7a-4839-9bbc-b87bd453f718\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"1abc5329-82c0-4163-b352-c3e9c79c8f97\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"689055e9-204f-4884-93eb-f8096127aa19\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"3bc7d2c8-0b88-4ec8-8c7d-9245ff9a98ad\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"58fe8cd3-9dc3-494d-955a-679db169d682\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"be52dfd0-3124-4d1e-b84d-87ed17c3ce6a\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"a062b16e-c044-4029-b663-605c9d89f860\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"17164845-5c84-4a9f-a394-4a63850253c0\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"fb9b710e-20ea-46c6-b115-a786c70f76c7\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"10\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"8424a8eb-f0ed-4d9a-8d2b-53032d1795aa\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SQQQ\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"f91ea40b-f9bf-4b54-a541-d970d0892186\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f987f290-bfcf-4665-bf45-668ccd4072cb\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":56.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.9813385272E9},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"90eaa029-af01-43df-bca5-cb8cdd720437\\\",\\\"step\\\":\\\"asset\\\"}]}]}]}]}]}]}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"current-price\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"af2c54b3-2007-499f-96a5-6d24dd051c96\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"QQQ\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"4a43f9e2-9052-4718-bace-27df3eb70ca4\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"bd9f69e2-ae33-4347-805e-c8f2e8144852\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"4241a755-530f-418d-b0f2-9043fd00c19b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Short QQQ\\\",\\\"ticker\\\":\\\"PSQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2a720436-f252-4b44-9b4c-3fc110519730\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":14.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.5279310004E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SQQQ\\\",\\\"id\\\":\\\"04b85967-fff9-4801-ae35-0b62e91bde55\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"31\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"18c5db53-1972-403a-b5ae-639a8c0cfa62\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"2f13aee1-00de-47a6-80d4-4a4c1c36daae\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"7e7cc607-9835-42db-b7a3-062d1f1400eb\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Short QQQ\\\",\\\"ticker\\\":\\\"PSQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7cabaa8a-38f7-4408-ba06-864d431faf38\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":14.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.5279310004E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"1a1dc2b8-b39b-4c25-80c4-408a8874586b\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"5.5\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"2c9c3e31-9de4-482a-b3fd-519242af2479\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"41af321f-1717-4dfb-9795-604d478db513\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Invesco QQQ Trust\\\",\\\"ticker\\\":\\\"QQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4a3b7174-89e1-4153-8bf8-fef821a9fa6b\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":269.54,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6819746131800001E10},{\\\"name\\\":\\\"VanEck Semiconductor ETF\\\",\\\"ticker\\\":\\\"SMH\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"19d735d4-0e19-4f97-83b0-77475e1ac6a9\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":199.39,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.2097667232099998E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"10\\\",\\\"id\\\":\\\"b4050f7b-3778-4c13-aa89-12b8b63fc1ab\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}]}]}]}]}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"200\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"e5ec4a2d-880d-4236-b1c8-f4ba2c9c815e\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"-20\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"d761b659-8d46-433c-a488-26b3fa3509fc\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"3f4afa35-6393-4252-9e88-5aa84cf7de5d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"01884e39-4990-4846-b39b-5051cf0e97af\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"c2ad211c-a108-49f4-b844-e11e3d345826\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"2e01ea3d-4dea-4c3d-9529-fe4c7ec78d2f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"57656a90-3557-45b4-ae80-ad4341a31919\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"2468835b-91ef-4a7c-b13f-068352a1e87e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"37cc1165-d0fc-408d-a936-cb909bc44c1d\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"56183581-d06f-440b-b5b4-c123f93499e9\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"4915712a-c3ec-4525-98d2-764fb128c552\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"8e84b8c5-177f-4821-9d8c-a11d04c22130\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"9b7d0d31-fd48-4a0d-8916-571209863be6\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"22e5cf90-1f45-46d0-a8cc-c2968a9e7545\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"10\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"8f2d3974-99fe-4769-b2f6-dc1329c5afea\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SQQQ\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"85366ee5-fd7f-43be-98e5-f27d21e9cadb\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"dbefb44a-3c8e-4142-82c1-dffd11035101\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":56.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.9813385272E9},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"bb6fc82d-4f4a-41e0-8a1b-e9ae533d332e\\\",\\\"step\\\":\\\"asset\\\"}]}]}]}]}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"current-price\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"40d89bdb-8bcb-4cb1-9284-aea2dbc68be7\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"QQQ\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"fe887afc-716f-4fd3-a39a-73a38c47081d\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"2b0072cd-ce74-4736-aaec-4aef97fbe386\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"ba88b393-c0be-4f22-875d-f6cf74840269\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"048c242e-028f-499d-abc3-e54ce6758022\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":61.32,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.65597774064E9},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"76618841-efc7-422d-8c89-b2a767444a29\\\",\\\"step\\\":\\\"asset\\\"}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SQQQ\\\",\\\"id\\\":\\\"da91234b-2de7-4007-8c64-2f414145ecf4\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"31\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"c7ab6d0b-386e-490a-a0d4-5ef4e5d36b33\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"56a10c7a-9a10-48a6-b1f9-6547781cdfe5\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"faa4b1be-15f8-439a-beae-b20e2c782ef4\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ba701785-7e83-4d16-84ae-ef1e36ab4ba7\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":57.66,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.5946141260199995E9}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"541d6e84-bb67-4c26-9343-23b81aea33de\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"5.5\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"c6348292-365d-4065-ae6f-50a6225bccd6\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"88799e13-a73a-4b0b-bd9c-bd72dd4e9e15\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"6bf9132e-7e30-4e0a-9ee7-6e23757560f2\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"6c12d959-b2ee-44ac-ad84-8bffb3b31c24\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"99906b8a-d401-486b-ac92-dd3357c3743f\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"a0892b83-3eed-46a4-b950-b66f90cc7753\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"79d7864a-1279-4255-a767-cda5e0ec8e2e\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"6beff866-b52f-4b22-9c30-c5c4e2033ec5\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}]}]}]}]}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]},{\\\"id\\\":\\\"182660cc-a381-494c-a42a-fb0d87178927\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"01bdfa89-1041-4731-b178-33d99aa30805\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"a31bb678-3c64-4fd8-bb9d-f9aef8821d12\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"12ffcef4-67fb-4d4f-8e4f-12eadfcb64a9\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Sideways Market Deleverage\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"832ab41e-9630-403d-812c-fe706b85bc7f\\\",\\\"children\\\":[{\\\"id\\\":\\\"92404fd4-c9ff-4b0d-be3a-9334e4a0856a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"a7d04733-138f-4cdb-ba2a-c88be93d94fe\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"SPDR S&P 500 ETF Trust\\\",\\\"ticker\\\":\\\"SPY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1cc17e2a-b4bb-42a3-b6e7-b5f088516b9f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":379.95,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.53587893181E10}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"current-price\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"2d1eaa6c-1209-48a8-8b14-499dea604aac\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"2333d482-050f-429b-85ff-6b65038972c2\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"02314fb8-b1f3-46e5-94be-b641ab938913\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"5b5e6f13-2c8e-402d-8b2c-2382d69c61f3\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"Invesco QQQ Trust\\\",\\\"ticker\\\":\\\"QQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cdf3a12e-bf8b-4913-860c-f4a2519cbd58\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":269.54,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6819746131800001E10}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"10\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"cd646c6f-3567-45e8-98b7-42fc76451985\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SQQQ\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"e97450a2-a5c9-426c-80bd-f95e56e34b9f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares Short QQQ\\\",\\\"ticker\\\":\\\"PSQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d8bf387c-ebe8-44bc-a5c2-0c5661f220b7\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":14.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.5279310004E8}]}]}]}]}]},{\\\"id\\\":\\\"8036062f-7452-4ea3-8c3f-0b2375527991\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"Invesco QQQ Trust\\\",\\\"ticker\\\":\\\"QQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"592c1bb8-3fe7-4bf6-b702-2aa93dee5465\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":269.54,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6819746131800001E10}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"10\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"0fd1e8ab-de14-4025-8f88-66a0e02296d3\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SQQQ\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"2aa9e6bb-dee1-4bb3-bbef-55f29c18915a\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares Short QQQ\\\",\\\"ticker\\\":\\\"PSQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9517a453-b192-4339-b4c5-cb13a94632e9\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":14.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.5279310004E8}]}]}]}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"60\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"c2319342-d048-4031-8acc-ce017686906b\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"-12\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"716b84bd-59d0-4021-9f7e-623331ec1ae7\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"53ce6df0-f9ad-41c8-bcb6-a098b272a43d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"02eb1016-df1d-4b41-bba1-1abd87e5c9cd\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"0deefc96-34d7-4e63-a491-f80bab39ae72\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"491e5371-2ea7-437d-9d28-e5b4b74814de\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"5627d6e7-ec99-4643-98e4-15b42f42d3d4\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"01a552fc-7964-4b6e-8b43-0fc1332c9ee5\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"4a6ca898-5d7b-4235-816f-3293834e41ea\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"8b4b0512-fb4b-4057-9e9f-9c753bd8b973\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"c23a51a5-fe32-4f11-8400-6e8ef0154b6d\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"10\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"e57f8136-c13e-49ba-bc2d-790dbb784885\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SQQQ\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"d849dcf2-5676-4d98-bd5c-6913001c43c8\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b6ccf5fe-8b59-4f18-b20d-b975c688dd8c\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":56.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.9813385272E9},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"85d8bee1-be52-4168-8b3a-a8e54fe15843\\\",\\\"step\\\":\\\"asset\\\"}]}]}]}]}]}]}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"current-price\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"38875d04-6e15-4840-a943-5dbcb642ffeb\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"QQQ\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"ca73cbca-d70f-4540-a8f5-ec64518bfaa0\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"c7711295-579b-4409-8c98-9ea6fbd1b4bb\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"783c5ed4-1728-4367-b460-ac767480a379\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ca9cb2bd-f16f-4603-881e-60373bc7e218\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":61.32,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.65597774064E9},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"32ec392a-852a-473e-a645-0a16c15b2593\\\",\\\"step\\\":\\\"asset\\\"}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SQQQ\\\",\\\"id\\\":\\\"8afbd2fa-b0fd-46a9-9d7f-8145e661c94f\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"31\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"25835d4d-d91c-415b-8f31-c9c62faebba0\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"d9b51ee7-181f-446b-8d73-1cc955267ac8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"b5d44ce1-2598-4ab3-9aec-d4c4ecf9437d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"7333dbbc-d4c1-4488-86ec-a2864a4505c0\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"63be167d-7f7a-462e-8498-fd3ddcfff92b\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"ba19d895-ae9b-4c56-829c-e0851dd02b9e\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"46bea86c-2253-4f49-aa21-1ed8d490f144\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"0a232f18-de8c-4044-837f-20a363c37c66\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"40dfcd1e-ebfc-4d52-9277-59631a0e0170\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"fd856bf9-90ef-4b18-897e-93cf2e78442d\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"70\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"b4f154ea-82a7-4a88-98a0-d22c725f0a81\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"-15\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"e4d025a6-e0fb-4e9e-bb11-54d76d8f9884\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"9b0e65c9-130e-4668-bd48-bf6f27664883\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"SPDR S&P 500 ETF Trust\\\",\\\"ticker\\\":\\\"SPY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"be0ea01b-2028-43fe-b28a-5ff1ff435324\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":382,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":31811364004},{\\\"name\\\":\\\"Invesco QQQ Trust\\\",\\\"ticker\\\":\\\"QQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"93ea5f2f-a581-4e4a-b26a-7b4d7d992272\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":269.54,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6819746131800001E10},{\\\"name\\\":\\\"SPDR Dow Jones Industrial Average ETF Trust\\\",\\\"ticker\\\":\\\"DIA\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f200dfba-64af-4bd8-b755-11d2a3010285\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":331.71,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.0892153954899998E9},{\\\"name\\\":\\\"Consumer Staples Select Sector SPDR Fund\\\",\\\"ticker\\\":\\\"XLP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"14619c74-5770-4359-8f93-839372e1e631\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":72.7,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.601671808000001E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"2\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"15\\\",\\\"id\\\":\\\"f7d97f62-c119-4718-96e9-bbcd9ca57275\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}]}]}]}]}]}]}],\\\"collapsed?\\\":false}]}]}]}]}]}]}]}]}]}]}]}]}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":true},{\\\"id\\\":\\\"b16f9a65-5561-412b-a6e6-bbe8e026e52a\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Proposal for V3.0.4.1b | ?? Beta Baller + TCCC ? | Deez, BrianE, HinnomTX, DereckN, Garen, DJKeyhole ????, comrade, WaywardSon, zyzz | 2012 Backtestable | Belcampo69 updated some of the modules > AR & < DD\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"144a3842-e049-425a-82b2-e4eb8d01d141\\\",\\\"children\\\":[{\\\"id\\\":\\\"08aeb916-a2f4-4cb3-a5b9-ce534cec22fb\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\".V3.0.4 5/7 2012 | ?? Beta Baller + TCCC ?\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"b394c2c9-95f7-4dc5-9b19-0d20687b3b7a\\\",\\\"children\\\":[{\\\"id\\\":\\\"80812bf8-bfe2-412b-bd4b-1175e6459cae\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"f23a435f-bdaf-4e1c-ba2b-ebb861898667\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"9f445d8a-a01d-4cfe-83c3-8d5a2aafb80e\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"0c75868c-d68a-4835-8177-862d14958529\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Overbought S&P. Sell the rip. Buy volatility.\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"fcab1b0a-6dfc-408d-b78b-6a62f8bbb2c6\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6f585b79-41a2-4895-8bc9-5a7851b2a037\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":11.45,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.5342449984999996E8},{\\\"name\\\":\\\"ProShares VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"VIXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4fea295b-bbf3-4769-be72-f6d0fd110422\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":15.84,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.4911915392E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"13\\\",\\\"weight\\\":{\\\"num\\\":\\\"80\\\",\\\"den\\\":100},\\\"id\\\":\\\"55da47ea-b607-4360-8a97-9b02f4dc8051\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\"}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"c716f02e-e6ad-495b-a54e-0d8561762b94\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"75\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"4978876f-f2f0-40d8-85aa-c99179475dd1\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"f0da3079-2f47-4e8b-9ba1-1c876c4ab3af\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"4c549d51-725a-4b44-88d5-bd157d804cd6\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"973690ba-95ba-40c2-8c98-d3a1444c89be\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.99,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.5392827503700001E9}],\\\"rhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"5\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"c34ce9c5-1be8-42d0-9d6f-7756df2d4630\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"75\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"b22a9fae-5e3b-495b-b8be-98ce4919d357\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a4716621-d655-4915-b3fa-ab72b6a9a92e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":56.82,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.18838302704E9}]}]}]}]}]}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"61e7b734-56a8-4806-a56c-348ec05eedd4\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"f496ed37-aa1a-4e50-962b-458f7aeecbd0\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"c01a6aa6-8b84-46c6-a42b-342158cdf59b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"a9d95e68-3f81-4dda-8985-a5887059cee0\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"d2009119-7013-43eb-9c42-69f43b309266\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Extremely oversold S&P (low RSI). Double check with bond mkt before going long\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"ad27e039-98c2-4fb1-81b2-0e69d91b6821\\\",\\\"children\\\":[{\\\"id\\\":\\\"7442bc3a-ed32-4a37-8c85-c5b52b639a73\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"49dd094e-6018-49dc-a08e-d78acd0d6992\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8856b257-8507-4f14-8452-66811133e208\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":75.59,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.57344069699E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4ba32768-51b8-47b5-88e9-321d9d77888f\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":63.2,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.8760366064E9}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"7\\\",\\\"id\\\":\\\"edbb105d-4a31-44d6-9c34-8d682984f695\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BSV\\\",\\\"id\\\":\\\"5c6c5588-6671-4f75-82e2-0e69ccd0fc3d\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"SPHB\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"ea145caa-7122-4086-82b4-9afd22409b4d\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"d4f3e2fd-a51d-4a2c-bde5-6a890df6cd22\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"278d4e94-a11a-4738-b086-d3eff1eee53c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.28,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.3390279048799999E9},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"dc51f959-11e9-4c78-bfa1-0145ff6419e7\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":21.12,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.177117312E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"7\\\",\\\"id\\\":\\\"cddb1b54-0f07-488f-bc19-027b3fe88bc8\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}]}]}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"0fbb33b5-dee3-4053-b69e-c3a7be9451c2\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"27\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"17f3ed8f-3ac8-4d98-95e0-186abcd926aa\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"c3fd260b-c657-4c0f-9209-7cf7aad2aba2\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"V0.2.1 | TCCC Stop the Bleed ? | DJKeyhole ???? | 1/2 of Momentum Mean Reversion\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"17949a06-255d-4b96-80b7-1cd2324a941d\\\",\\\"children\\\":[{\\\"id\\\":\\\"bfe88428-ba5d-4932-ba9c-5dbe05adc9fd\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"670ae05b-77c0-4435-946b-dda39ea4dc06\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"V1.2 | Five and Below | DJKeyhole | No Low Volume LETFs\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"3c168dfe-b0ea-404f-8489-36b29c857dd2\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d495b0b4-913a-481e-b427-f2c0535d7e3c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"585c6eb6-727f-4745-bd6d-ebcb407c9ede\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0431959a-de60-4d67-bad4-19528ba2f387\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":83.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.8172328099999994E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"19e6803b-afe0-422f-a11e-9abd6b0534a7\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ecdc08c0-a8f5-40ef-8098-e2132be61467\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"ProShares Ultra QQQ\\\",\\\"ticker\\\":\\\"QLD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"62c1b7a2-a2ab-4318-b50e-d57f77501780\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6824665126E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"01c904ed-4bd3-471b-9f71-ec00eaf1c95c\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"0ecfa371-27b7-4cb8-97ab-5730e7053427\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"d5547b12-c7b1-4be6-885f-8c81ce1e9f69\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"4a0caff0-60a8-4c7d-a761-83853a937132\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"bc313fed-63e8-4db6-8edb-190fedb589c7\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"309772a3-6f48-4403-a4c6-026befce2069\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"093f6999-3838-4773-aac8-4cdc07a59e81\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"dfdaa48a-bfeb-49b3-a6f1-73d9afda67d2\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Bear Stock Market - High Inflation - [STRIPPED] V2.0.2b | A Better LETF Basket | DJKeyhole ???? | BIL and TMV\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"9b9e128d-08a9-4841-8908-22c8e6785f4d\\\",\\\"children\\\":[{\\\"id\\\":\\\"ec3fceb6-2d99-490f-a057-441edb09529a\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"d0324d01-7c0d-44f2-82de-b7465350df75\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"A.B: Medium term TLT may be overbought*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"87e2552c-d83f-4add-b8e4-227aff8a8c3e\\\",\\\"children\\\":[{\\\"id\\\":\\\"00449891-1903-4cb9-aedf-6fb5e32a5b6e\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"d1455451-d941-46d8-b3d1-1b96112affb6\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"A.B.B.A: Risk Off, Rising Rates (TMV)*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"f6254ac6-ef0c-4b56-897e-de2e7fcbd729\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"9b3f711a-482f-4367-a477-1e35912a327c\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"7c45c93b-9df2-45d9-834e-5730136918b6\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"214c52ec-a6f0-4176-b7a3-6160a39a122a\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"26108ccd-2330-4349-83af-02901d35aa25\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fda7cf83-b949-47c9-8ae6-4acb59eb2a6f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"afbc41d4-fd24-49f4-93c0-d32e5f79cbbe\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"71597b93-26fb-48a5-b0a5-719d467f59b3\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fcb2eb32-6e40-4e85-a68a-32e599e11b33\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"b81ca0c0-d252-4efb-b736-9914e2a45434\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"37018f22-7b30-4cae-802a-ae7cd57c68d1\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"7fe6d90e-4842-41db-b3d3-80815a575bdd\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"867511a2-eb6e-4854-8ac3-3575d07aa232\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"c553cc14-f080-4d0f-a003-d88d73f494d1\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"d186c569-a750-4247-96a0-53d44d409931\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4cd32b6e-819b-4b91-968f-9cafd1cbb140\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9},{\\\"name\\\":\\\"ProShares UltraShort Euro\\\",\\\"ticker\\\":\\\"EUO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7e68336f-362f-49e7-8cd5-2a8bb0242b69\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":34.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5517930.159999999},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e94c6c2d-4d11-4861-a759-2e7f1a97fb20\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"30e21cbe-fa1c-4722-8fa5-ea2d971dbea2\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"SPXU\\\",\\\"id\\\":\\\"e59d5e8b-d012-4559-a9f9-9a7eac89b5c4\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"f61069d4-73bd-4b90-b434-372b62f4081a\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"c839e0d8-2dd7-40c1-9987-23a09112dee7\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e551d518-3fa3-4709-ae26-3e82ac6f5ab6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"34332c53-d66e-44e8-b8df-5358266b3a31\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2a3556df-e522-4914-a0d9-d876de19052c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"Direxion Daily Healthcare Bull 3x Shares\\\",\\\"ticker\\\":\\\"CURE\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5a31ea40-5a5a-4941-9148-491d0aaae9b2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":89.46,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5880205.8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"fcc61fd6-8822-4ec6-bf85-ba1cc17127fd\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"002ca8a8-882f-42d8-a3d5-01ad1cdeb8de\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"35343aac-bb77-4d1e-99ce-62ecb542298b\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"062fc5b2-23e0-4d58-bd63-7cafb1d58522\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"287b3b18-f10d-4a9c-96b8-15710363d080\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7ecb88b1-d22b-4b5c-a868-0e74a8f6be96\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"5f58bb30-99b4-402c-a614-ec760ec5373a\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"628c1218-f388-4a6d-a2e7-c12a4a9c708e\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"2214b820-31c8-4cae-bac1-6e57bddf403e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2a28c9b5-3470-42ea-881f-95e039b7c3c4\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6f5041a8-bf9f-4919-afc5-a3554436eaf4\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"bdd033f1-447e-48f8-bb81-89c9b00dfe43\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4c199c44-175f-4960-9637-a7bd83828f07\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0a2e5fc4-0345-4ba5-8eae-89c66f6af787\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":148.89,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.982935702999999E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"99445f5f-faa7-42ed-b6d9-aa3be7f3e49f\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":true}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"0cfb3128-2aee-41ec-b253-ba9d58a4d77e\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"0\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"01e845dd-c7a0-40c9-9596-3489948ba223\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"67143cfa-2826-467b-8420-fe26fff29ab5\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"A.B.B.B: Risk Off, Falling Rates (TMF)*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"ad85c799-b60e-4400-ac78-e1da30fc587d\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"8fac02d0-b102-4a51-96c5-d66a34207f82\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"a741a32e-0ae4-47ac-9bd1-91545d1672df\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"6646cdf3-8370-437a-b027-41a9b04b0025\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"fa0297e7-f3e0-473a-9158-0a90d8e633d3\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d01e87e3-6fea-4baa-b293-492cf494ddf7\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"10a377e8-fd28-4e31-b404-02e7f8a42c67\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d86f857c-8aac-4c52-b195-45badd7d8568\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"934699fa-9ff7-4f45-a482-9aa5f97dedde\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"7bf1a876-b82b-40f7-9ece-77e669990bb2\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"6b874f17-8030-4e17-bba5-bcace3bfaec6\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"60e56b4d-b83f-411a-847b-0d0843036807\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"36da3e46-71cc-4a20-ab55-9fcb39a3c050\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"cc917215-83db-4a6f-aae3-3f4f629a3a59\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"15c72e8c-dbc8-4b6a-be5e-962882819a85\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.327053606E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8b16d63a-0442-4162-98ab-4f75bba3de56\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9ea894e0-6585-46e6-89ea-c8286c7af436\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"ec48dca5-cef1-4e28-b230-0dfc53090a6c\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"2\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"bc8650a9-0252-4f1c-996f-1b390ff2b31c\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"-2\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"98a44559-e830-43e0-acc4-a22692bb15c6\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"ceed5106-5a88-4ab7-8fb8-f9588f0e0e4b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"7ee62eba-1c8e-43b8-927b-01d7a2d40bfc\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"c95a1173-dae8-443d-983f-75840f93915b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Energy Bull 2x Shares\\\",\\\"ticker\\\":\\\"ERX\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a0f4c022-d7a8-45bb-89d4-fabe8fa02201\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":51.3,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.7945037539999998E8},{\\\"name\\\":\\\"ProShares UltraShort Euro\\\",\\\"ticker\\\":\\\"EUO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b2915f77-b40c-4c0f-b4a9-043c75eeb3b9\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":34.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5517930.159999999},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f4b76656-0860-44b2-b080-de0e7b624349\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"ecdb2ba4-a40a-46f1-aa19-3886e3ada175\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"SPXU\\\",\\\"id\\\":\\\"ba961f77-337f-4d14-b695-072f61100209\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"862947cd-8f5b-4c6f-be8b-fedd61573fc0\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"cac45c4a-a702-42d7-8340-161ca08df6c9\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a9ece448-85b5-4b9c-a996-481a2ae01b4e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"605c1c1b-ca6d-48dc-8f71-03b0dc6ead5e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":31.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.6195129461E8},{\\\"name\\\":\\\"ProShares Ultra MidCap400\\\",\\\"ticker\\\":\\\"MVV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b6d06c8b-b37b-4353-90b5-0d009242e38e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":130018.59999999999},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7dda0973-da7e-4511-999d-484c032538a2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"72933f55-73b6-452a-95e7-3449ac7f78ae\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"81e3345b-e4ac-4e39-a579-a421e3198ff6\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"88f6f67a-f7d8-4d0e-9a53-91a07742f151\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"7cc4faf0-1933-4f00-80c2-e5e3b9c7756b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"cfef1d6d-0bb5-4a8d-af31-5c36d65d3066\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"a591bf6e-74fd-4462-8d59-10cd2f128d47\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"88d2b0a9-3381-4d1d-886e-e2182b3cc3aa\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"746e7ea5-4353-47be-b660-3b577d1c4afd\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"39e2f079-a749-4969-8905-582d2b8b21f2\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"b59204c2-a9b6-48a0-91b4-7c06e3f468d4\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"ae7739ad-109c-4434-8bed-3ee46dd84e35\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"da7d4714-15a7-4866-9d4a-fcb36c772f57\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"cd50cf6d-59c3-4cbe-bfc7-bae0d6e06699\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"dceee3b5-ce4b-41e1-8c87-38c956572a38\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"bad7eb21-3587-4c5e-9d93-166ee3aa285a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"92d18b47-1eef-4df0-b396-2ecaaa9fbd6b\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":10.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6812945732E8}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"c45857b0-d443-4092-8c2f-01acd04b28ce\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"5.5\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"d36163c9-7f5a-43b6-9c1e-68da72b78d4a\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"1bd5c5e1-b469-429f-9592-6f07fc05a2cb\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"b60415fe-2b11-4551-8c3b-d934f1c66e18\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"3a102fb0-81e6-433a-ab3a-97a72f0f1156\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"072a83e0-1453-4f34-848f-54cdd1453091\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"b280ccf6-ec2b-41b2-a564-d84ae5374673\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"8fa12dde-d5dc-4620-98b4-286ee79442a5\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"137ee542-a3b0-4aaa-985c-f85b5ff80d0c\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"22b101e5-00ba-4ea9-b443-e4d945a9acc7\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f77a554a-3b03-409c-ae23-6f7f6c5a1d8e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Invesco DB US Dollar Index Bullish Fund\\\",\\\"ticker\\\":\\\"UUP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0dc34d0d-3b0d-4832-8793-1ee947f1ffb2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.15,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.429251705E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cce649a2-eea4-4731-99ec-f8e7699a9db8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"763b0a40-896e-42f9-9470-1c3db5506639\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":29.97,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.165467361E7}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"b91cb656-df7f-4b34-bcfc-07f462556a50\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed-specified-weight?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"cb9cc123-128e-4cf6-9d99-999bd10f25ac\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"-10\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"2df78482-ea8b-421c-9e48-c4ec63963302\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"2ec96315-7733-47be-b345-777245506e20\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"1a7f9ce7-555c-45e3-b8eb-9147fa7617e5\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"d58aca71-bed9-4760-96f3-2f9b468209ba\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1462453e-5fbc-4ca1-b94f-ef02a5cf74b3\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"80681ee8-2766-4ac0-962f-26cce2fdfad0\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7fba1fd3-88ea-4b37-9aa9-ea393c1d4ba8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":83.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.8172328099999994E8},{\\\"name\\\":\\\"ProShares Ultra QQQ\\\",\\\"ticker\\\":\\\"QLD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"695b0e2a-35ee-4418-885a-d569a46fb79f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6824665126E8},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7ec4de1f-ea85-4e1f-bad1-447f3c5cdcc5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"460ea09b-5d50-4367-bfe3-8d468b2742a0\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"8faf958a-c91e-4201-9a27-22dc34a87e8e\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"8b748bb8-58d2-456f-9768-7cf060bf518d\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"74c4ebda-85ad-4550-ab26-f4ecce7fed19\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d58b4024-7acd-4b95-8a10-a024a74d38cd\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Invesco DB US Dollar Index Bullish Fund\\\",\\\"ticker\\\":\\\"UUP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"dbeb0f4d-4c52-4e83-a4c3-df0c49aa482b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.15,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.429251705E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c2026cb8-2075-42c9-b231-e338d6dfb731\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"8608ea0d-e877-4d86-90e8-f36b1a525937\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"2c8d3d7d-30d9-4219-a847-620653437ba1\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"8f9fc5da-55a2-49a8-9a38-e3057fffaeb3\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"5dc2a2ff-184b-4d50-b232-b853c99f7b9a\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Defense | Modified\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"ee0b87be-7629-40c3-98eb-60ada3a62746\\\",\\\"children\\\":[{\\\"id\\\":\\\"3b6f31a8-b4d7-4d2a-ab62-e298c61ea935\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"4a38b3a0-4c14-4311-9094-cbd02fded4cf\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares 1-3 Year Treasury Bond ETF\\\",\\\"ticker\\\":\\\"SHY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1dbdcfca-8ad8-44a6-b8e6-d195f3b0b8ec\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":82.38,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.516601524599999E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"87029d6a-3ac3-4c28-b64b-584ebdccd3e5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.97,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.040002155799999E8},{\\\"name\\\":\\\"SPDR Gold Shares\\\",\\\"ticker\\\":\\\"GLD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4fa53f1b-94f9-4618-a4cb-34efd17ede44\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":162.77,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.6775562373E8},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"48bec408-601b-4dbd-ada6-30cfb1fd2337\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a2a7d307-2a31-4de3-ab8c-b38cf6b09bce\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":55.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.1806370296E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3dfc19ba-5424-4d90-ab9b-89d5e939b76e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":70.73,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.714480458100001E8},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9bb9e6b8-8856-410a-83f6-d8a95b5cd1d8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.2,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.985865139999999E7},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3d8692c8-8ca6-45d0-91e7-c621de954377\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"263ecafa-8a28-46ed-a06a-4814e6fc663b\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"701fcf5c-4ee4-4f97-b923-ae561f9fcf5f\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"e0773deb-ca26-4abd-aa70-52e29fc46869\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"9457a1b9-7cea-4982-8a69-27641a39ef5b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"e4fa9880-22aa-40c3-a015-d8b1319c0e0a\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"699e221e-67a8-4060-9ff7-338c380d001b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e88a30f8-45ed-4324-9cb3-39000973a05f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4700713e-047a-4c2c-b175-f86841400a24\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a9c4b52c-9625-4575-82b5-977956689418\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"a9df268b-37ba-4577-8aec-25c32a35794b\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"1bb09531-526a-41ab-a215-812beef5f234\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"5642b31f-92f3-44e9-aee5-11b351e31499\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"a895862a-eaf3-4a9a-ad73-7a2019e51ad1\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"bca7f342-48be-4133-a66b-a36addefee05\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"317deb85-7e1e-4d9f-8c0b-c6ccf5033893\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a409ec3d-d232-4157-a6b2-90110e9db130\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":44.99,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.058357684200001E8},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3d082f72-41bf-4cca-a2e2-648bf5245184\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.2,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.985865139999999E7},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5ffd30de-b046-4352-af47-54cc879670f6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"cc01ff6d-ba7c-4031-98e5-ae081c7cc1b8\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":true}]}],\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100}}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"current-price\\\",\\\"rhs-window-days\\\":\\\"200\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"e0bd28d6-d5be-4819-a76a-ec2d777bdf1b\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"TLT\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":true},{\\\"id\\\":\\\"64b2d723-381a-4454-b399-ee61d32d67d9\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"517029d0-728f-4a11-954a-d9b51937a3fc\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"B: If long term TLT is trending down, safety: Long Term, 2 Least Volatile*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"e58c6519-e6a7-4d74-b5f1-938567978edd\\\",\\\"children\\\":[{\\\"id\\\":\\\"7ebee162-4d2d-4ded-812f-5318dda97a80\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"d53fda3e-65eb-44d6-98f2-15f1477c47da\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"B.A.A: Risk Off, Rising Rates (TMV)* - LETF Basket^\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"1e5c17cc-8051-49a1-9bcc-d3e473ef4d8a\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"ed2a5f6a-a73d-47a6-916b-2220d734a100\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"edb33d28-e37a-46b6-abf3-17bb8e02c9e9\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"eca93ffe-54c8-4b86-8804-3497bf63b3f6\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"f8ee85b6-f5d8-4962-bcb6-0557746ed9b8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"12cff5cf-6099-419b-b2bc-589ec3cf1465\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a80ac908-fbe4-45e1-9870-b59fce42b09a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d65b6c00-2664-4b98-8831-86608aab3728\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"3316fcfd-39d5-4768-b577-3cf8fc538f10\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"191b8cab-a662-4ee6-964c-5223a481ed9b\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":true},{\\\"id\\\":\\\"15829ab5-1b38-4da6-ae17-09cfdadd0f3d\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"160fd07f-cd8a-4601-bf4c-e4d41ceeec1a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"6c503b99-0a7d-479b-810b-0c467d382508\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"63a59f46-de1c-45ed-8ebf-505453b3f57c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ad3cb66b-96b1-4f08-903c-913491a7508c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.91,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.3752632333E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cc3ecf38-19e2-4bbc-bb1e-7c01860844d6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.327053606E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"07cb1f32-0270-45c6-84bd-2fb6425e49ec\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2367de03-3d5d-4e84-a49f-5791b07e6b31\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9},{\\\"name\\\":\\\"Direxion Daily Energy Bull 2x Shares\\\",\\\"ticker\\\":\\\"ERX\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"139e2e5b-761d-40a5-b9a5-44295b15a34a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":51.3,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.7945037539999998E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"ceafd433-8f1f-46bf-bcc9-609e5c15ba51\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"a54760e7-9da5-4fbe-876d-1b5608b1b2a2\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"-2\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"f6a19fa2-f716-45c4-9910-020c58b03f0c\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"eefac6f9-e94f-4d7e-9206-04211dd10735\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"7f33d165-6e50-457e-b788-c728ad0fcbda\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"f0c95b4c-0d56-4f77-a759-23760a53938f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"76c9ee80-d751-4f72-80df-2b3ce481b08b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fd1b51bb-e6f8-4a6b-a930-40d0998a8b26\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b9c29ea5-6bd8-47d2-83e1-a712ccf6ef9b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.13,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6708776.130000001}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"7d3b35dd-016f-484b-a05f-4a116f0156fb\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"4\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"SPXU\\\",\\\"id\\\":\\\"6891c667-2a51-493e-b65c-af1cb0b5d3a8\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":true},{\\\"id\\\":\\\"d80cac03-d575-40e0-a7be-9ce95ec4f143\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"0664bd5d-7933-410d-a7cd-0b90f4b9a450\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"f4e75739-ae49-4264-b0d8-481b36c526ff\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"1560c1da-5a2d-4e6f-8a83-d12d30a19716\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"000036d6-c37f-4b9a-8af4-58c283d5bccb\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"13b69528-0153-4c3b-a04b-5cd494ce6698\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"5b4858fb-2ba4-4996-a633-2d06f789d90c\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"b2c96bc9-2f3d-415c-9333-2072a28111d9\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"fa25e149-8b63-4e10-8bbc-862a3c3e0695\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"32b2dac5-9fdd-40ef-b34e-8fc3f5136338\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-window-days\\\":\\\"3\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"95c84ccf-7f75-4a43-82df-8820f954441f\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"TMV\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"7c4feb3e-d10c-40cb-a179-ecc412b18594\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"33ad7e82-2b6e-48b8-91db-072f00012841\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6b2af631-ed1a-495f-a514-f22cecb5af94\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5876fbd3-667b-4fe5-997e-09c94f5fb59a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"95f424d1-52ee-4f34-8d07-740cbad89397\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":157.82,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.906629694E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"faa6c117-9021-4fb9-84de-f385058f1b24\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"68ad03e9-4e25-4360-a84a-3c11c336afd0\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"48f2a167-9b5c-4e83-b172-8c04b0a9640e\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"5ce49589-808c-4eb8-b127-7351a3b890b9\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"715a5c06-0462-4ab7-8aa3-a2222448a4f2\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"85dbdeb5-251e-4ce0-aa7b-5bc02a7df923\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"531910e5-e6e5-41a9-be2a-5ad4cf6ee1cb\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e0f1cf22-ad62-4aae-983f-76b2a1b29c9a\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"5c498f8a-f3ed-4030-93bd-fd11ffc3b88e\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"4447c541-3b51-4181-a5c0-30cf4b0580c8\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"30a7784c-4a83-4c6c-8cc2-5770061b9aec\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"0e875953-7797-4fe2-8f4e-a18d44a1f90b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"b5020133-e455-4800-8104-64c78c84dda5\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"08867a8b-97df-48e2-a1cd-a24377eab0ad\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"d9c5d9cd-8c1f-4a1c-9341-90f6c5e9f638\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"50073bef-0314-4085-a236-2252c863d852\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":10.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6812945732E8}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"ef8a59da-e292-4d39-bc62-472d6ad57e1d\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"5.5\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"08f40116-5e29-41ff-89df-d149918a41c6\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"95506245-bc45-4d7b-bc7a-bef4a18d3af9\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"dc143ec7-9630-48ed-b06f-638522e25baf\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"886490a7-62eb-4c34-aa78-20e6209351a7\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"b200387d-77f3-44a9-a85b-e0180c599ce5\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"68f5e819-a002-45db-98b8-934ac1ffd12c\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"-10\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"b9db6014-10e4-4d7e-b540-c813f13f1f55\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"6c45384f-545c-419a-b83c-280f9164dd41\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"36d65e8d-5dcb-43f8-a6ce-7f77109b2426\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"b2b383f4-9a71-4ccc-9726-6d6167958d4c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"177d5e76-d395-463f-a321-4b0b9ded66a6\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a662d0a8-6d7f-4c8e-b4f9-4d727b925312\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1136ae5e-532e-4996-95bd-a77509af27d0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"74bcad30-dd11-4f36-b86d-4d801658a8c6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":148.89,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.982935702999999E7},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d72bc1ca-243e-4432-9508-84ee6afba570\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":19.95,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6883044604999998E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"716e68d9-d745-4734-b0cb-e6783b43ab74\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"ece6d1ab-3abd-4e5c-a5e2-b3cf56baedd3\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"162824c7-9abe-4f5c-84ff-23c5928f04e0\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"2e2a094c-c859-42e8-9548-6a311e1caf4c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"bbce957b-7132-42d4-87fa-8b3fc60ce5f6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2de2129a-f31b-4b3d-b47a-d5124e864394\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"22\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"b31c8654-6c21-4aaa-a717-da7ac982ef1a\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}]}],\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"b85f861c-b45f-4e26-9b16-cfb667d126b8\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"89bdac98-d95e-4d7c-8cf1-d6aa5e168d56\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"d9b4cfc4-456e-4345-8c7b-6e89a125fe93\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Defense | Modified\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"31e33de3-dfd5-4f70-a056-38b5bc34e2aa\\\",\\\"children\\\":[{\\\"id\\\":\\\"c03403fd-b0d9-45ac-81fd-0c45c9b75619\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"0b001177-fe11-43e8-8ec7-9791f0694c11\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"a57bb900-07e9-49b1-b91b-8d629272c3c4\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"30b417e1-a941-46aa-a29f-c96d0cecadb4\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"b7f0f2bc-a40e-4010-8f66-c2bd84aa7eca\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cc225fc7-a802-4227-b5d1-375956bfb8c8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"5\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"TMV\\\",\\\"id\\\":\\\"70563a9c-a854-403a-bfa3-21804f929653\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"09975e6c-1d61-407f-bf48-0d321463c874\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Invesco DB Commodity Index Tracking Fund\\\",\\\"ticker\\\":\\\"DBC\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"674d4dc1-301d-432a-a7d4-086ad0f3196e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.33,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.922121070999999E7}]}]}]}],\\\"rhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"100\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"0ea57d9e-f579-4a0e-9c23-046e6e572f59\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"3\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"d8384e5e-4de3-469d-9c40-d1c42d135eaf\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"54f32ab9-12f4-46e6-924a-12fe042c8f64\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"4506c0d6-4731-4fcb-b301-2b2c9a77182f\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"6490d012-7a90-4868-8339-77f3f186999b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9350e4bf-ddd7-48f8-9f94-20ea4f3d3d84\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ee0c439b-0de5-4435-85d0-b23b2c9abebd\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":80.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.38192436325E9},{\\\"name\\\":\\\"ProShares UltraPro Short S&P500\\\",\\\"ticker\\\":\\\"SPXU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"31c7a1b0-fa0a-45ec-a8a9-0937ba4154cd\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":21.92,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.14726053376E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"5154c8ed-84a4-4e48-a725-b4d070e019a1\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"7b3b1733-accf-4cbd-81d5-310f8f7b3747\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"e5f83b78-8f0c-4ea1-8de4-7c68f6964baa\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"973599f9-c770-45be-89e8-3224fae3af10\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI EAFE ETF\\\",\\\"exch\\\":\\\"PCX\\\",\\\"typeDisp\\\":\\\"ETF\\\",\\\"type\\\":\\\"E\\\",\\\"exchDisp\\\":\\\"NYSEArca\\\",\\\"ticker\\\":\\\"EFA\\\",\\\"id\\\":\\\"c2addb8d-67d5-411c-92d5-973b2770a5bd\\\",\\\"step\\\":\\\"asset\\\"},{\\\"name\\\":\\\"iShares MSCI Emerging Markets ETF\\\",\\\"exch\\\":\\\"NYQ\\\",\\\"ticker\\\":\\\"EEM\\\",\\\"type\\\":\\\"E\\\",\\\"typeDisp\\\":\\\"ETF\\\",\\\"id\\\":\\\"2fcac9fa-49a0-4156-b933-0b5519ee7a95\\\",\\\"exchDisp\\\":\\\"NYSE\\\",\\\"step\\\":\\\"asset\\\"},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2495ca04-edea-4890-b9e6-c1478653483a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3a1cbc03-cc22-4a5a-a0d3-fc6e8d998e5b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":44.99,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.058357684200001E8},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"97ea2f07-df11-4f9d-a914-6b64ebb61c9f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.2,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.985865139999999E7},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d71cccfb-969f-4263-aaaa-163aab0c6d92\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"9a6c7068-61cc-4fa9-8b40-7abe8a354297\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"ffaf1c90-c453-4ddc-b41b-a78e887ea87d\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"3a5d2edd-b844-4e67-b97c-5bc1d588ca57\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"26df2d91-3bf8-4a1f-ab1e-fba086c5966b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"e7cb5893-48ab-45d3-af61-2a5a50572253\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"b8794acc-2aa1-4edf-972b-78b13b58ba22\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b7dddd72-f428-4ad4-a2ac-7cfaecacfc39\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.529816533E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d8a02f8c-d53d-433d-bb30-0d52b9e1e978\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f02138d3-c519-40cb-a6bd-92e96a1ab403\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"234096fa-dac5-4f79-a3e0-3685bb68359c\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"45da7521-1145-4a46-af68-7a55d8892d4f\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"d5170975-78f8-44e4-86fa-9e34dc147cd8\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"59ed38b5-194f-418e-9ab8-6ed6a149ea4e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d38e2905-d27e-4c15-8b54-e50b46c7477d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"dd65d17b-2eaa-413f-956c-e1eb573b8070\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":36.8,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.218889968E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"31956ad6-ac4f-44f2-bb27-c0d27e88d384\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":44.99,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.058357684200001E8},{\\\"name\\\":\\\"ProShares UltraShort Euro\\\",\\\"ticker\\\":\\\"EUO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c417546f-247f-4b28-98cb-f51c4933410f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":34.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5517930.159999999},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"50254654-7ba4-44d4-8076-ea6d41c3535d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f821fa75-aa32-4a44-9c09-614284b520b8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"ebd42294-c27d-4d35-98fd-8d675c475ef6\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":true}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"7e8c541c-83c3-4475-91b6-a091b0e856fd\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"0\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"12b53c6f-f44d-44a5-a06d-4d3b52ddbef3\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"8351b671-4c0a-49bc-9c4c-e07b30f794a4\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"B.A.B: Risk Off, Falling Rates (TMF)* - LETF Basket\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"8cf13ba7-07b6-4602-8804-f09004847e94\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"9731941d-3fea-4a27-8889-e98ec6d419e1\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"ff6e44ac-9b23-4fa6-8a0c-6c6be3ff75dc\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"b49e105e-8670-4e6e-8c7e-0a562271220d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"b12bd489-fc12-46e6-93f7-2ab34d60e1c3\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5e942029-54f1-4b57-a1ef-39014b65673c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.91,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.3752632333E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b614832c-1b18-4862-b06c-41f1eb360304\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.327053606E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7858e82c-6764-46e9-ae0e-924f3eb0c8ae\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a8f31f39-3c31-4e3a-a972-bf6237af9490\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"c3b095a2-9207-4cda-afab-979f831de25a\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"2\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"8080ddd7-3a58-4b32-913c-b7dab443cc98\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"-2\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"03da4387-4d55-4be6-b0c6-aa1b7ae213ba\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"d6af04b5-762f-4deb-857e-df8549279a2c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"3024b9ab-c9ed-4993-8db3-71469a36a1f8\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"88adab66-feef-433b-b5f2-f852eb06fdfb\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"SPDR Bloomberg 1-3 Month T-Bill ETF\\\",\\\"ticker\\\":\\\"BIL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"145cb4b4-bf93-46a4-a88e-661b29529b10\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":91.44,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.3686188791999996E8},{\\\"name\\\":\\\"iShares Core U.S. Aggregate Bond ETF\\\",\\\"ticker\\\":\\\"AGG\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"63c79404-884e-4e4f-9fc7-e994e95f014a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":96.34,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.3850104298400002E9},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"07bf8fe5-e95b-4dbe-9a63-583887f45933\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":7.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.270521856E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"0b2f3b1c-59ec-47b6-9065-0c50f9170265\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"SPXU\\\",\\\"id\\\":\\\"e2a962d8-c734-4947-a954-c94bd78a2e8e\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"7357d627-14d1-4b8b-b646-a4245a13677d\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"7f3298e8-cc06-45af-8346-ed3c4913e27b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ad10c143-5ed3-4235-b64a-3b66dff02db3\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2cabf987-b15d-41bd-b734-6452d4bfb988\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"70c9509b-b038-4e99-8447-1e08b6e19f99\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0f4db0f5-ad8a-456d-bd9d-7af237bc62a0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":31.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.6195129461E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"72be36df-23c5-43c0-a5e3-afe4d74e8393\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"7e333605-78dd-498b-a46f-a91cb53836d3\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"7b64f259-5b81-4d89-880e-93bf64d27919\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"2b5d3223-5326-45a3-bb6a-a5d0fdbeba69\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"36f2a855-6668-4f81-afab-8c438d893da3\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"a89b7d0a-8727-4aad-b43b-791d0d8571f2\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"90334277-015b-4308-9b17-b1cdbfd6a818\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"edd33274-0fa7-4f40-8100-e99f96706446\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"2117d202-087e-42b7-8294-fa2e02de72b8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"98db85c2-8b56-4117-97d7-e882a32dfba7\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c2cf213d-e779-48c1-a68c-bf92e0649bca\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"612d180c-3a82-4b17-b0c0-39fa6ad8283d\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"3f24d291-5f0b-4db4-abd8-480ad4b2c099\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"09601599-6550-4caa-8d5c-a71675c4f4b8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"c6acf289-b02e-48ea-b973-d129fb439bc2\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"742ef1a3-a068-43b2-bf4c-8a7b7f9c82dc\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"cc2864ad-1b16-4561-b945-8603f02065d2\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"681f6fc3-2a71-4415-b379-3dfbec822a44\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c4df285f-99d5-4239-a012-813922048e86\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":10.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6812945732E8}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"c271da25-fd0d-4d4d-acc8-7d807a111147\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"5.5\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"f2202092-2a71-40ba-a2b4-2a51593afad6\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"70e4f13c-ee94-4690-9619-c90be77cd249\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0fc3e469-f85f-4a61-b1cc-769ce6f45e5b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1287c7ee-77d1-40ce-836a-f9900178f8d3\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b85cdf0a-7f41-4792-8392-d97d548f86a6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":83.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.8172328099999994E8},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"95aaab5b-e6da-4811-9877-2edeeb801a1f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.529816533E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cc94a4f0-eb05-4743-9e20-34039f9ed189\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"da85470d-27ce-4fd4-a91a-74536ee8742e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"ProShares Ultra QQQ\\\",\\\"ticker\\\":\\\"QLD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"50ac7df5-98c2-4083-88b4-cebaaaa5c7ec\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6824665126E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e054dd9b-6fe6-40c6-96c3-875228a8a2d8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":31.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.6195129461E8},{\\\"name\\\":\\\"ProShares Ultra MidCap400\\\",\\\"ticker\\\":\\\"MVV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4f20194b-0772-4369-9018-d75095a53535\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":130018.59999999999},{\\\"name\\\":\\\"Invesco DWA Utilities Momentum ETF\\\",\\\"ticker\\\":\\\"PUI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0c5d8a95-a3f4-4ab5-b4aa-aac1ef6ea77d\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":30.77,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":118956.81999999999},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1cdca9cb-1a01-40e9-9fbe-dc75c197070c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b9d85973-60f9-4351-8d41-dfce03465d56\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"7\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"77dfb2db-34f6-4af7-9da7-aeb022d13b6d\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"b99904bf-89e0-4be6-9710-e5de00fc7a86\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"-10\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"15040d9b-657b-424c-9e6c-a701d3888635\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"e8084a83-04f2-420e-944b-a7450f735751\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"2fa3ce33-cd9f-42b9-9284-7376bb2fb455\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"516ba346-fdd0-47a3-bc7d-eebb85ad14b1\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5b471ddb-f2cb-4982-9dff-3872a4b3b15e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"62aa236c-8137-4d6e-9dd1-deb3b40eebe6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":83.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.8172328099999994E8},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"084625c3-47c6-49f0-b7c5-51f1c72af38b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.529816533E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"97d61dab-33d2-4374-9bb8-602e9a2bde08\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0fed9614-7922-42b9-ab9e-f28e0c907af4\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"ProShares Ultra MidCap400\\\",\\\"ticker\\\":\\\"MVV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f02f4ff0-2177-47e9-97df-fc2d8476c729\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":130018.59999999999}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"7\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"83123cdc-7f87-4c66-a677-4a6267808d7c\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"ea328cf7-cdbd-4076-9b9a-b9ed3e92f3cb\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"7a05033f-eec4-44a5-9ac3-fded717399fd\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"a9b97a88-a3cd-4eac-a211-11963f207c90\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7e75259b-cebc-45e3-87ec-38c9670c408c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8fa216c1-7b2c-4a79-9f50-4a2ea1d0479d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":7.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.270521856E7}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"8ad728fb-9c30-436f-ba75-de066a0b8631\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"700b3013-0a6a-441c-890e-b911bdb2ef62\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"0cc8e487-611c-4491-bac1-1cbff2b976e9\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"7aa474b5-e89b-4811-aebf-60602c266ffa\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"86c84974-9502-4adb-a979-941b193643db\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4ee1f5bb-60e5-4208-9856-30c7f1a69764\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":61.32,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.65597774064E9},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f65e5196-3fbc-4fe7-a4fa-82ea6c5eadeb\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":55.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.1806370296E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cb0ca80a-d003-40d6-b27b-4b2953937088\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":70.73,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.714480458100001E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"9c727ff2-dc2e-4082-82cd-5cef76409d84\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"2fabfb5d-7851-4580-9590-30f25b6b0423\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"a2ef1c17-9cd0-4f03-9f00-bd1dde569750\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"29912c69-5886-40d8-ad94-411b156952b0\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Defense | Modified\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"14498224-1ac9-4b15-b3e7-536d365b8ce0\\\",\\\"children\\\":[{\\\"id\\\":\\\"513be4c4-acd2-44fa-bfc3-cd77bf2c7e9f\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"0d394f60-2c80-4550-a6ab-97de11991a1c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"defbfd81-684a-45ee-af98-cb45ae1aaedd\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d2b78c6e-6028-4e83-a62d-d819e51d14e0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.5,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.28180325E7},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1401b0da-257a-4f50-9441-1866a8078b2e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":55.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.1806370296E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b5be0e21-2cac-4041-8c99-47f7babc7a72\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":70.73,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.714480458100001E8},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c3685a64-4a72-41a6-8e26-f9095d2b2287\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":64.38,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.087537804458E10}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"add0ef4c-63bb-41a2-a70a-7fe90bbc90ab\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"601c7e42-1ad4-49ee-aa5d-b82404319076\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"54d79a52-5cba-4e40-9ccb-56c87fbc0c61\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"22404a86-7f2f-4fb1-9930-8b7d8ec8dbf6\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ae26c354-47e3-463c-9ffc-bb6d5c4e1caa\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0b8896da-0f68-48d6-8fef-86d445c8b6ed\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"41f07f9d-a4c6-4f84-916e-7457e0132aeb\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"380ed81d-6306-4fbf-b21e-f41878383f57\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"2880772c-ad0b-4185-8c15-6e8dedd4320a\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":true}],\\\"collapsed?\\\":true}],\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100}}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"UVXY\\\",\\\"id\\\":\\\"572a148b-3a19-48d9-adf9-f85f70fe9ae4\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"84\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"e6a08c70-10da-472b-9914-d970b20113b7\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2195137c-bee5-4889-ac45-3ade2654b107\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":12.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.6779972826E8}],\\\"collapsed?\\\":false}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"UVXY\\\",\\\"id\\\":\\\"6d5e111f-0319-4fc4-9028-bf0b09164a4e\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"74\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"45713fa4-05ee-4765-9ea0-ce86db9d1bd8\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"e97063ad-22b9-4a34-8d0b-7fe11606ac5b\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Bear Stock Market - High Inflation - [STRIPPED] V2.0.2b | A Better LETF Basket | DJKeyhole ???? | BIL and TMV\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"82e5dd84-32ee-4b09-b916-8b3fa75f0036\\\",\\\"children\\\":[{\\\"id\\\":\\\"361fd946-f9dd-483e-bebf-3c3bc6a72cff\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"a784b12b-eb6d-4dec-8c63-8ccaced2e27d\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"A.B: Medium term TLT may be overbought*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"4e931831-a55e-4d99-b9bc-53e212501859\\\",\\\"children\\\":[{\\\"id\\\":\\\"49404bfc-1578-42db-b8cf-6c568492fd2f\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"5ba6c84d-12c0-4f3c-8773-a78fc3536060\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"A.B.B.A: Risk Off, Rising Rates (TMV)*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"c50ed473-13c4-4048-952b-d704d34032b2\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"d1544077-cf50-49a6-bb87-ebe0e6d4a413\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"09c17a9c-68ac-4af0-8994-b8989b9b8b56\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"5f58a2ee-3aa8-4237-b061-445bcdcb8ac8\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"dc778ce0-7db0-4d78-ad3e-9102d644d3a7\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"8022b9f4-123b-4d90-bb93-5bda7e9c2a12\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"24e150e0-f9a2-48f3-be57-ef5ad3bc7b8d\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"0111b19a-7510-47c7-8a65-65623727f7a5\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"687251a2-39d7-4123-915a-c9807dbd712a\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"fbd73469-8d94-437a-997b-c3ba3f4b41c3\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"39f99e05-538d-4fc8-a4e1-25d997d0bbb3\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"3d6c1a87-ba3c-4cd3-bb1f-8d6abaec38f1\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"64b8dac4-c798-4879-bd74-f935b1a6a4b0\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"c5ea3ed5-e3e5-4978-b6bd-df66f57315d2\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"64332d03-8edc-4194-9c83-bc697641b25b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"ee8de6e2-ed30-4884-9fef-d007631a9807\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"bf9288e6-363d-42ac-9b71-b35e9c819b1f\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9},{\\\"name\\\":\\\"ProShares UltraShort Euro\\\",\\\"ticker\\\":\\\"EUO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8d167401-4cab-4c73-949e-cca13ab74976\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":34.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5517930.159999999},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6e9c27bf-d6d9-4726-bfc5-1dd684328f09\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"b4d560e2-633a-4a94-afaf-848da5e8dc90\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"SPXU\\\",\\\"id\\\":\\\"d94bf85d-3138-47ce-826b-435b063501d6\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"68249f10-45eb-43d1-a9db-3473292a14eb\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"984dae34-80fb-4178-802d-3c10fa02930d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"804656c5-df31-4f16-bac8-f127a1ae6e4b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c988587a-03a1-4cd2-9d74-b6166cf43a12\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"81544edd-ba2b-4922-ba81-e5b8c36f9e37\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"Direxion Daily Healthcare Bull 3x Shares\\\",\\\"ticker\\\":\\\"CURE\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a0b3695b-be02-4a57-814a-81f4129c985e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":89.46,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5880205.8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"6c759577-a40b-479b-aff6-864603000070\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"ceca6d1f-7456-4feb-931f-044dae33eb38\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"e9b0d1dd-35c0-4992-9ec3-22b49d79a009\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"5e0a7882-bf14-45b9-a601-cc31cfb1849b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"fc0edbb5-b788-493e-94ba-64607d7a6e0a\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"79e282eb-a08d-4571-bd73-ccd212114513\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"9bca334c-7f17-47b8-9910-4dd0e9eaf986\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"5faef255-929b-4921-8480-f6adceefa6e5\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"db053ed5-9dad-4358-b0d3-aa59e13fe7f8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"81963190-9782-4fce-b595-4fd0b2971ede\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"335d84a0-0f52-444a-a115-3871c0cb0f8c\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7239f9a1-2d11-48db-8835-ff04595e04bb\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5e8b4a50-ba1e-464f-9c53-348e1bc29044\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"55650b88-d0e4-43ab-a69a-13e4b35cde55\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":148.89,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.982935702999999E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"7542d95a-e586-4014-9f59-41fc7b8e26de\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"cc866a13-d825-40a1-a656-343d516f2de7\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"0\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"9d5662f4-4a35-4c38-bc14-c7444f7cb3d2\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"b6b46fa3-b560-4ff3-ae06-97f8a138d317\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"A.B.B.B: Risk Off, Falling Rates (TMF)*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"a36319ce-fabd-4426-bb54-35f6f82b84f3\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"6af5fc5e-37ec-4bc3-9d7e-64aaa3c801f2\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"681b1b5d-55a0-4423-bfd8-25bdcf37fad1\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"93ba2885-cdb3-4368-bf47-85ac29dbad43\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"e6105e6f-88c8-4e54-bf1c-aec711520653\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"59ac63a1-ea8b-407c-8314-0307ce24daf5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a4adf6d0-e55b-4be0-b9a1-5c4e703b6606\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b9f26f0d-9f67-400c-a34e-5f399ca839ca\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"624a92db-f941-4196-a7ca-a74d2c6fb792\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"a36315fe-c0df-4b3b-9dcd-f55dac0cac26\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"4fa18b61-d9a7-4321-892d-3d49997498ae\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"1e250ec5-4d06-47da-9fc4-73d32fbabae5\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"d20357c0-6c3e-419a-bc17-ba2f1c09825c\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"33725e6e-7cdd-49a0-88e1-2fea475356ee\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d406c3c0-326c-4d3a-9616-40400f66993a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.327053606E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f99a8a31-1bcb-4c45-b067-26ce10d03366\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cfc0b113-c850-4d3e-9b2f-6836615c33f8\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"0f683e1f-a56e-4585-b8f1-6274485d8189\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"2\\\",\\\"lhs-val\\\":\\\"UUP\\\",\\\"id\\\":\\\"bb9ebedb-e067-410b-be82-602815c3afc7\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"1\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"c4f72f0d-c87b-4ed8-9bbe-2c5af59af80d\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"47f949a9-a100-4d80-88cd-e347716bbafd\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"86c6ffd9-5d4c-4f06-9fc4-2420cf257a55\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"88bd4c80-2dfe-49b3-8fc4-06e2df362d0a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Energy Bull 2x Shares\\\",\\\"ticker\\\":\\\"ERX\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5680b7e8-ae22-4972-a560-d737c0cc3452\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":51.3,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.7945037539999998E8},{\\\"name\\\":\\\"ProShares UltraShort Euro\\\",\\\"ticker\\\":\\\"EUO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"599f4707-f6f7-485e-acc4-2fa544e1a0fc\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":34.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5517930.159999999},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e8cbcd69-8590-4354-b926-23d9d3e05d7d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"d5b6fa09-9f6f-4a58-a7b9-80083cb8aa4f\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"moving-average-price\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"231d6834-df79-4817-b3c7-90e288a1708f\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"-1\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"be359805-78b3-43d5-aeea-04fb51c7614c\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"d1658a28-2339-4d2e-80ec-d2c2b531a47f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"bba95683-2e9b-4d79-9a5e-de5b9fe954a1\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ea86e5a7-d57c-43c8-8d18-b6b5dcea2c44\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":31.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.6195129461E8},{\\\"name\\\":\\\"ProShares Ultra MidCap400\\\",\\\"ticker\\\":\\\"MVV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"56343cb2-641d-463f-8462-9230cfc06f87\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":130018.59999999999},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"96369ec5-2091-49f3-b724-0002a5e3cef7\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"f5c96b63-5980-46c6-bdf6-0fb757bc3c60\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"e9b46b3c-b256-4810-a0de-72c3fd4a9bee\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"63f47b48-5d9b-4629-8c89-cf0b5d0241fb\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"1c2dade6-d850-4499-9761-3854b4fdd232\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"dc06a9d5-93cb-4b11-995b-2b397f51d960\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"7d190161-19af-41d9-9646-f805d03135d3\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"4946ccca-6507-427d-b6ad-2204c0da90b4\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"11cd6748-7478-445e-81f9-74b14e0d4ce5\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"0bab603a-1a7b-40df-9c68-f3d20b88d257\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"43a837bc-be4b-4142-9bcf-f8a45870689c\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"d9733743-59ee-4b8b-9855-5e08806a6a5e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"e542dc17-54a0-4b75-ab7a-24fbfd59ae0d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"6ab3a842-8cb2-4c8a-b216-711738d8316b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"5ea4200e-ea13-4bf9-9bd0-96f88c0abe7d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"37eef155-1e7e-4e5c-ae03-85dd075a61ab\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4d4e3a50-7767-4167-81dc-f7c767ca10b6\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":10.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6812945732E8}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"f804a34a-7389-4d26-8dac-638c5a8ba39b\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"5.5\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"6d2251f4-d286-4b19-94a6-d927432f7007\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"830b6bac-68c9-4c0c-a972-1bdfb82944ba\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"27b7c063-0d26-4570-bca6-67d41b1de69a\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"816b3b5c-cd10-4ad8-85ab-b5f2a23c51ea\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"524650b1-04f0-4955-bb02-234dd4952f6c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"3f8a60f9-a709-4843-b496-3d97cca7c791\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"d01524f5-b00b-4f42-a95a-845e73ed8bdd\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"d2f36911-a2a6-4826-a5c7-f8c706e1e00f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"db45a48e-0758-4082-ba45-f0fac3ee5eb1\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"83827f84-2263-48fd-baa5-24317877f2f4\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Invesco DB US Dollar Index Bullish Fund\\\",\\\"ticker\\\":\\\"UUP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"73bd0ffe-196d-48ee-bc5b-047809a3aea9\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.15,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.429251705E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a99c5668-d6cc-4ef0-bd6f-15090ef01782\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5741cdc2-74c7-4950-a5b1-61b93d800e1d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":29.97,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.165467361E7}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"dd5e80d0-d17b-40c1-aab5-cadaf371600c\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed-specified-weight?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"9020d278-4b8e-45d1-a9c2-acd7f53dc5ff\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"-10\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"17277225-a40d-471f-815e-8fe673594399\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"20ff1195-3ae2-4bee-8c6d-77129606bdb6\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"1bfc8a4e-1409-4980-97a9-fa2f7f9eb0b1\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"59d13821-028f-4611-b406-14bb7157197d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"56b5150f-eca7-4764-a5c8-e81417f053ff\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ba5a1154-1c36-4a99-82b0-cc0b2279d015\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"aa40c33a-5e48-4153-92bf-da8c6b019a71\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":83.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.8172328099999994E8},{\\\"name\\\":\\\"ProShares Ultra QQQ\\\",\\\"ticker\\\":\\\"QLD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fd326a05-2b7e-4837-9ed6-30f954c346dd\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6824665126E8},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6d836be9-efef-42dc-9cb6-ab7d4ee96909\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"b9bb6cfb-6fe5-471d-83f3-21969d21ef8b\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"17692601-b59c-44aa-92ee-d75f7ca2970b\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"dd942761-8f15-452e-8fa0-877bc54a9169\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"7c76a13f-483d-4e89-8115-d4b534c3852a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a84ab4ee-63b3-41ee-9222-c4c41a99227e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Invesco DB US Dollar Index Bullish Fund\\\",\\\"ticker\\\":\\\"UUP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1461c9af-92d1-411f-acff-2884ac2270bc\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.15,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.429251705E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1d168bc2-fa26-478d-a6c2-a749e882c1d3\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"0ee6dadb-13db-4f60-aa7d-bb889d1ddef7\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"b406a471-89bb-49ca-a75e-1a7ccd550cb8\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"aedebbe4-c541-407f-9d99-d3be2e42b975\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"d694cf95-ab10-4c2b-8883-7ad991e991c2\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Defense | Modified\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"238eda71-0b7b-4d20-8a88-891ada825606\\\",\\\"children\\\":[{\\\"id\\\":\\\"b8c9cc0d-a0b0-44c2-989a-231b4306a4a5\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"675f86e3-d95e-42d0-9879-69bdbb5115df\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares 1-3 Year Treasury Bond ETF\\\",\\\"ticker\\\":\\\"SHY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0f6fddba-ff65-42d8-936c-77e1b1a3dd86\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":82.38,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.516601524599999E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"16f9eb7e-1835-476d-a09d-b5e1eacdb5c7\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.97,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.040002155799999E8},{\\\"name\\\":\\\"SPDR Gold Shares\\\",\\\"ticker\\\":\\\"GLD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b39e79b4-0a8c-4ee5-8ef0-7dea7d4177cb\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":162.77,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.6775562373E8},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6945fa17-291f-452c-ba56-2260545174ce\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7299ffb2-5db7-4347-ac9c-d2b4b88e3f1d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":55.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.1806370296E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c610fe93-035a-4148-95ab-90b582b27698\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":70.73,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.714480458100001E8},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ef5be8cf-0843-4e0f-a58a-95cefa4b179a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.2,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.985865139999999E7},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b01ac5bd-c6e8-46a8-bcd1-d803a742214e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"5e9be1b0-aa02-419b-81c4-a8e242c57455\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"5e82eefe-ef6d-4307-a303-1eba9ac7c9ec\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"f73df03d-0d1f-4b2e-8c00-ba7867673bba\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"3492d5d8-f9c6-466a-9740-d9b98140df96\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"ccbb4d6b-7d59-44ab-857a-ba4d04e38809\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"89304916-0dc4-4a45-97ad-1279990069b8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6aacabb3-319f-472b-9fcf-cb046119b8b2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"80c8625f-0a77-442d-bda0-7786cbc15d03\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"afd0b13e-3f27-4522-a170-5628213fccb9\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"bbd51346-72cb-4c63-9663-f61c7f6ee21f\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"bd480257-5181-4859-ab75-8b8e50198c09\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"138f71c7-ab79-4bf9-995d-2c869f73e565\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"7e978b6a-077d-4534-b61d-c230b65465d1\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"43ea5b91-1f74-45b8-8e5a-a9f8b9247946\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ada52721-6a09-4d52-9ed1-33df171ec9b8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"80fa2445-7f64-4dba-a6e5-997ec51f3d58\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":44.99,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.058357684200001E8},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f4cb68b3-4f7b-4515-8d62-961a71f88827\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.2,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.985865139999999E7},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"61c3e77b-92b1-4c22-8b24-380b919175f3\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"9cd35e41-f766-4fd5-b14d-e773f72db1b9\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100}}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"current-price\\\",\\\"rhs-window-days\\\":\\\"200\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"17b07699-a87b-4959-b6f5-364bf48d83b9\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"TLT\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"15ca13e7-6c34-4684-a373-63be9a0991aa\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"f699479e-ea64-49f2-afc4-6dcbeae7d363\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"B: If long term TLT is trending down, safety: Long Term, 2 Least Volatile*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"74838a35-93d5-4baf-be6e-9cad6d3719de\\\",\\\"children\\\":[{\\\"id\\\":\\\"4e6acf76-013d-428c-b5c3-1a1553d8cb22\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"797d930a-6c01-4f9e-ae8b-44dd2308003e\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"B.A.A: Risk Off, Rising Rates (TMV)* - LETF Basket^\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"7966be89-3398-4432-b495-f5e308c1e8aa\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"8f956314-0a76-4dce-8131-f0581989f6be\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"92e6d6da-3ede-41d0-a71e-548d9a73b00f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"912b4d80-b101-4803-a9b3-f19c226f4551\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"8c31a440-d20e-4dcd-9cd8-94d750544b19\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2e318d0f-2544-4b4c-b0fa-48fe401ada90\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"75aed837-dc5a-4982-932d-a4b7ba713e98\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0788f8a2-b2ca-4fe6-ad79-c0d17d43ec41\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"c2bc36f7-0482-44da-b6b1-134afedc3b2e\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"d35a683e-e95e-4ae2-8344-8330c8712f44\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"b04f6d91-0da7-4e63-9099-c7c903878059\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"7091ca3a-a424-43e9-ae55-f5f97062b7d5\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"b18e7bc0-1f0d-4155-b6fb-482b8aa9dcfd\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"1addcd04-51f5-45de-aaa4-30eb0dee3b5c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a3ba5cf0-0774-4075-ab38-1e8664d9a955\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.91,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.3752632333E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"591cf1a3-5ae9-4307-b74d-6b6c8d7b60eb\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.327053606E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"faf65116-a1fc-4711-bc9d-a2bc6ca268af\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8458698e-2fd8-4a0b-8099-0829423e17e2\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9},{\\\"name\\\":\\\"Direxion Daily Energy Bull 2x Shares\\\",\\\"ticker\\\":\\\"ERX\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c6a0f250-f6fa-4dfc-8de5-7e335fd08543\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":51.3,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.7945037539999998E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"7a7b5894-d946-4066-8f9c-b9073343a5f6\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"2\\\",\\\"lhs-val\\\":\\\"UUP\\\",\\\"id\\\":\\\"77cc3f42-48ab-4e0f-bbdf-5e2bbfc0015c\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"1\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"5ceb2e54-6786-4e40-9229-bed511eba7d7\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"ef88a4fd-0d4d-4fd1-b5f8-475aec63fea7\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"02e977ec-7e9f-4087-8057-92b549af597a\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"1b1496a4-543e-4f1d-b8b1-9b36489925c9\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"dbf13d4a-88e2-4198-abf2-3b45d853c549\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c9f6b4b3-b351-4f3c-82d1-da8cbf9f9430\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"30f5d89d-20e2-490f-82bf-4fce80fda3fb\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.13,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6708776.130000001}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"ea5d94c5-503f-4440-8dc2-62b17a31faed\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"4\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"SPXU\\\",\\\"id\\\":\\\"e8403030-8d40-49f3-9412-064d79cc238f\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":true},{\\\"id\\\":\\\"24bec395-527b-4296-a60c-d6e62b939ca2\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"7c24af08-6a7d-446c-82c5-eb8095983033\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"c2613548-b660-49f9-91c5-913fad5f00eb\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"2c91c6d6-bd70-4409-a02d-bf05016fdaf8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"10601aff-86db-4315-abb5-baa3b6d81b95\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"20c907f7-513b-4db0-9e61-54985700e1b0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"Direxion Daily Small Cap Bull 3x Shares\\\",\\\"ticker\\\":\\\"TNA\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"85758515-1dcc-4715-bdff-c0d49fa71500\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.84,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.7466253824E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"258c6efe-7f8f-4c9c-8924-2e44caf9bcd7\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-window-days\\\":\\\"3\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"9deea0e3-0546-49c1-95b2-396c74eff97f\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"TMV\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"b57a9560-b5d2-4885-bcc9-84d949bcd9f3\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"948766a5-f75a-4922-a9cf-c6cd5f2f03ad\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9c8d5885-e954-440e-857c-9b99144c11ce\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"384ddc9f-9140-48df-806e-bd7047a03caa\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.92,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.04673400904E9},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d2ddff76-4a3b-4040-8397-e834716a9a3a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":157.82,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.906629694E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"92ca814d-e90e-4f07-b4ae-649be714c5a8\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":20.95,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3542169102E9}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"3\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"12fc2792-1296-48f3-9191-f68bc7f0ffe2\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"f809accb-cfe5-424e-891a-8d1136b8f90a\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"73e655ca-60d8-4594-b6ca-dc3d31094c44\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"4749694a-6e2a-47ba-99ca-5a8c5bb03696\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"03ae2624-6c87-4ad6-abdd-c618959ad033\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"19400835-41f4-442c-b1ee-e3f42a3c384e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"c5c2e743-d747-4005-8687-36adadea001b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cf414a89-a2ca-47ef-8b32-acf2326cb06a\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"ea91f174-3c9e-44a1-9761-d6d8d8a1973f\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"0aa25282-d4b1-4905-a470-03631f65b998\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"232af548-2a28-4c9e-8f67-1dae370220ed\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"1383c1b1-0d61-4fab-ac82-c309d94a26fa\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"2da79cdb-e153-47cb-9159-2b7d300e27dd\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"c13fdc2b-d9d9-4a63-9c6c-7f58a991574c\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"226cab3b-fa19-49c9-bc6a-4835d988838c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"af757ba8-14fb-4062-8d95-dfe351ad7bb0\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":10.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6812945732E8}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"76a5014b-02c7-452a-b3b9-aa80db40d239\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"5.5\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"7acd0c35-3dc5-4891-82c4-b88976ffa403\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"88d51fb6-e309-432a-9ce3-81ce26074921\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"75e8a383-6961-4717-8fee-dc64914c99eb\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e434807e-8827-465e-ab16-71d46267248c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"74466e73-980c-40c4-b5eb-cb58af7c73b6\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"66dbaaef-2966-4937-a1fb-76c04287f105\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"-10\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"0fa5cce9-9cab-4e58-b872-da0d65809e57\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"873013c6-71fd-4bb8-bba9-574a9aef3bb3\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"6320a60d-6f65-4418-a239-b5a841bff29b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"f4066460-a82b-47cb-a570-61fa999ecdf6\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1a53b9e0-14aa-43eb-8dcc-b80403acafa3\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9c3fe861-1274-4f63-8be4-6213de39c128\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cbbeaeb4-4cdc-4676-9812-6a76333c1976\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f2322aec-476c-432b-872a-1f432bd667ca\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":148.89,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.982935702999999E7},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5c5de1f7-2c94-40c5-9113-94cf3624f22e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":19.95,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6883044604999998E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"077584f3-3277-4830-bee3-2d423e51b3b4\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"b51ff738-df39-4344-81f2-82adac74dc71\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"f8e318e7-b9ab-4c03-a753-34624c94a024\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"446077ca-7e92-4ef5-8561-b297c02da976\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8ce97ddd-dc48-42db-a851-fdcd4011e953\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e5c27f38-8a10-45a9-8798-94fa59cf12ab\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"22\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"a31891c6-9893-4523-afba-43cd1ec9a09b\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}]}],\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"9f460f13-980c-4c66-978d-3d5adeb0c243\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"45bc403f-1ac7-4a55-bb7d-651f07ec8b4b\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"d5021343-7bc8-45ce-a2c4-bdd8d118723e\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Defense | Modified\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"214a4d3c-abb8-4f73-8d00-ca229fc5cc99\\\",\\\"children\\\":[{\\\"id\\\":\\\"924680f4-ab4c-4e64-bf14-5834bfec3a5d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"b52296da-f8ff-4ae5-bbab-c6bb919d9689\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"95fb6181-a034-4e59-858c-7b12f517be05\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"9734aa68-a643-4fcc-9b72-e72de403bcef\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"6b8914b5-b184-4f1d-80de-2e489958ab07\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0d2e090e-5536-4be5-b807-330495c5d25b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"5\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"TMV\\\",\\\"id\\\":\\\"f92593dd-8bc1-4f3d-b3c1-28d87afd33c6\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"65f2e138-cc23-43de-b9db-eef7ab36ce7f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Invesco DB Commodity Index Tracking Fund\\\",\\\"ticker\\\":\\\"DBC\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1b2ee486-da2b-49d6-bf4f-5fb68ccbc635\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.33,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.922121070999999E7}]}]}]}],\\\"rhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"100\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"8dd6c744-a83e-49a6-a4cf-76700ad238b8\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"3\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"7d1a201d-7652-41d8-9fc5-7a3f5e1bd390\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"ae692df5-f75c-4356-ad8b-610558ddf361\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"b1df1048-7c94-4fa7-8166-65b00b9b6470\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"86b29f4d-27bc-4595-8ec4-5183c5dc9982\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ebc930b2-4cd0-4ec2-970e-b52c2c04e651\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"78b50151-c15a-4d10-8802-71a15ed49c1e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":80.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.38192436325E9},{\\\"name\\\":\\\"ProShares UltraPro Short S&P500\\\",\\\"ticker\\\":\\\"SPXU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"db189b2a-9bf0-405c-959d-5b705fb4c2af\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":21.92,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.14726053376E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"44548e02-9f44-41ed-87b1-80a2787be695\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"c27ce911-8ce7-45d1-81ea-88944522a7eb\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"a5fb2cd0-8ae6-46cf-af14-b6891ae88fe5\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"ea193636-8d93-4182-a538-5a0b927c7f8d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI EAFE ETF\\\",\\\"exch\\\":\\\"PCX\\\",\\\"typeDisp\\\":\\\"ETF\\\",\\\"type\\\":\\\"E\\\",\\\"exchDisp\\\":\\\"NYSEArca\\\",\\\"ticker\\\":\\\"EFA\\\",\\\"id\\\":\\\"d09a2705-3b0f-4381-ad53-e8a91b13ba9f\\\",\\\"step\\\":\\\"asset\\\"},{\\\"name\\\":\\\"iShares MSCI Emerging Markets ETF\\\",\\\"exch\\\":\\\"NYQ\\\",\\\"ticker\\\":\\\"EEM\\\",\\\"type\\\":\\\"E\\\",\\\"typeDisp\\\":\\\"ETF\\\",\\\"id\\\":\\\"ae733082-1c1b-49e6-8ca9-3dc497a5cf00\\\",\\\"exchDisp\\\":\\\"NYSE\\\",\\\"step\\\":\\\"asset\\\"},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c8613b01-de51-49e5-9fb8-7d07449a68ab\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d82167e5-565d-46fd-9f88-5450a37fb342\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":44.99,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.058357684200001E8},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"85aef5d2-fc45-4600-8707-8ccdd13b83c8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.2,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.985865139999999E7},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c772abeb-21d9-4e4d-969e-e157db93a5c7\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"fc768f7b-080a-4274-996e-62fd88f803f1\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"c6117bb4-9df3-4f2c-9588-8f0e8996ef67\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"adfe4df4-fb1d-4f71-aaa4-006756581b5a\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"8c2bdb41-407a-4af6-bede-91bdd35cfaf4\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"bb22fa71-ee83-4182-8ef2-aa43ee013577\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"4e1a2e4b-3bd2-4ddc-8812-e70fab97895c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b4f95c2d-bd82-4009-b5b4-55bff70768c9\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.529816533E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9fce38d8-0aa7-47ec-964f-2c48425e7f34\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9830c08a-caf8-4fd2-a3fe-9837668bfa67\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"eb966cba-3a19-4eff-976f-298e864c2a7e\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"2f358c42-883f-417e-8e3c-2bc8d798bf5c\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"d9f336cc-4c08-4db8-a310-4281de0276e2\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"69e7bf9c-7473-4a91-be01-fe1bc0fb2525\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3e6a751f-dcd4-4bb4-9ed1-6749b1317cb5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a3dc8940-1508-4d39-96e3-e0a5ddceb6df\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":36.8,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.218889968E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c93a0d07-d87f-4652-9673-6dbd7eac7143\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":44.99,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.058357684200001E8},{\\\"name\\\":\\\"ProShares UltraShort Euro\\\",\\\"ticker\\\":\\\"EUO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a85886ea-0c8f-4555-8787-0ddc373f33f9\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":34.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5517930.159999999},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8806412e-e21c-4205-b0d4-5d98e169738e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0902a03b-c5a9-4362-86c9-96d4cafa71d4\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"094fe4cd-b9e8-4748-8cc0-7f9b18b57b36\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"d1a9ba2a-1db5-45a4-9964-4fdee218f21f\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"0\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"88222b4c-f746-41db-b86e-cab219e40ff7\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"5a52eeeb-27e9-4446-8bd6-c6b488fb1d15\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"B.A.B: Risk Off, Falling Rates (TMF)* - LETF Basket\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"2d78c0f1-992a-4be7-8f2d-2b37f078bf19\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"c78ca00d-42e1-459b-b4f3-ff62dcdb5478\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"334ca988-27c9-43a9-b15b-f5e1cb1dd3d8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"81e529c5-e804-4233-ab54-a002ce7490e4\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"3dc373c9-49d2-45e4-9141-f58963d4d465\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6551e816-0d6d-4332-9a0c-a71478cea2ed\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.91,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.3752632333E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"692dbaab-4d51-4bb7-b0f6-c7b57336727a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.327053606E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"92b501e2-f6d8-4eea-a7db-62084e6ba82a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c661e405-1863-4fd4-81ed-c52b9c501769\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"cb0a6a5c-7eb9-44be-8d43-114774f14d56\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"bfe6d310-7294-4042-a101-2ff01815ca2b\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"-2\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"b7a10f7a-406e-4af9-9bad-75dbd68873c4\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"c70874d7-47cf-4c4a-915c-c46b0ebce434\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"d5b45291-58da-4f2b-9e1c-485838cd0d60\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"e26e2098-a833-493d-9fc8-b5c74ddaa176\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"SPDR Bloomberg 1-3 Month T-Bill ETF\\\",\\\"ticker\\\":\\\"BIL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2e8551b7-8722-4d34-a918-ee5e83b45f8d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":91.44,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.3686188791999996E8},{\\\"name\\\":\\\"iShares Core U.S. Aggregate Bond ETF\\\",\\\"ticker\\\":\\\"AGG\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fedf86ef-7ef3-4909-934b-7b710d52618e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":96.34,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.3850104298400002E9},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fd780d93-7890-495c-804d-435550656e99\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":7.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.270521856E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"d9d4247c-aa1f-414a-8561-eaed464a6473\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"SPXU\\\",\\\"id\\\":\\\"3c5ced78-893c-4642-a118-d769bdd63a27\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"c4136f4c-9d6a-4d99-b7cb-9be4eb2452e9\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"6e8cac91-a865-4ead-a32b-1642692da142\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1f2d133e-d71c-442e-8425-f711bd777b17\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"645d8257-9a38-444d-ab34-006fe78bf1c7\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d175d615-ac91-4f54-a5bd-98d6874c5530\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b0711eca-6f96-4e9d-9a0b-84b0d1109497\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":31.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.6195129461E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"180952c7-88af-4583-8d32-219f706315b0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"3d03cca3-ae70-4ec1-b09c-e0253e34e3ce\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"90de4bd3-7809-4567-a36b-3b026ee45629\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"8135c1dc-488e-41ef-8095-40bbebf37c50\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"1dc2c7d4-5bde-4e00-a0d5-76c4e5308bc5\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"9bec6738-b078-455b-90ba-41af916d1bea\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"3f974e2f-0165-4409-b974-73d0c8878768\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"65a30e49-27fe-48b1-aaa9-ef7c5191965b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"c4fde9a2-36dd-4ae7-874c-4a8f067e8b5e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"4be9d8cd-8f6c-42e3-ba19-da6f6e20f5fe\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"15f059f0-b636-40ad-87d8-c2d22d5eb3e4\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"82d4e73e-d5aa-4400-9813-bfdc0e452123\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"b1e56166-5141-49f0-af22-6d5ca419fc2d\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"d197c28c-78de-43c3-a52d-e3f132bd3cfc\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"30c676da-8430-44f1-896d-eebccea3fd0d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"6ace9f03-e5db-4c11-9a1e-b9ab7b20709f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"83581990-f171-4726-b26d-222991029e5e\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"60ca8855-7b01-405e-97d4-c81f662d0af6\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7f931be8-58ed-46bf-a65c-44e51c24fb2e\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":10.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6812945732E8}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"077301db-b6a2-4724-a5ad-3234c38f0909\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"5.5\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"e2da9c63-51bd-4f7a-9c22-91a2143e752f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"702d8630-0f61-4a7b-bc73-b020ee915c3e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"96411b05-6fe1-4533-8d8f-a3a7d188ee07\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cba285ad-5915-46eb-843c-0dd3ce1f206b\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6327773b-6b84-466a-98df-e77bd0c5b412\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":83.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.8172328099999994E8},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"05fae476-26d3-4787-b03b-20ff7e625361\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.529816533E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5a0b1565-c014-4241-88ab-a934bc303eb2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6ba88555-1875-40bd-9d16-1ea3a5a608e7\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"ProShares Ultra QQQ\\\",\\\"ticker\\\":\\\"QLD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"218de042-27a4-4c34-b92c-ccf319de5d47\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6824665126E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3bbb11f6-b048-477b-8db3-fd56e47be3d9\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":31.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.6195129461E8},{\\\"name\\\":\\\"ProShares Ultra MidCap400\\\",\\\"ticker\\\":\\\"MVV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8937ba22-3f35-4acf-8d90-a112ce3492b0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":130018.59999999999},{\\\"name\\\":\\\"Invesco DWA Utilities Momentum ETF\\\",\\\"ticker\\\":\\\"PUI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"39cfc6ff-607d-4a74-a6e2-753381f0c71b\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":30.77,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":118956.81999999999},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"47a6f40e-7984-4de4-9d27-6cbce85f711f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9e1d2781-3b0d-4d25-a548-f33c58271e7f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"7\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"28f8a9df-ce7e-4ad3-9442-f8602d03bf6d\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"73d81c99-931c-4e17-b697-bbb5ff3993b0\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"-10\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"665a94c0-ed5d-481d-aea2-8b9f86465f16\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"82f9b070-7f76-4102-a575-a1b158734ec3\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"aeaca2cf-9c2d-4853-8fbc-fa53ea35f08b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"f3ffadbb-9413-4de3-907a-237c7eb77070\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b051575b-cb8b-4919-ae9a-7f983b33f587\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e92a90af-6208-47f1-b6ec-cd2250392a95\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":83.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.8172328099999994E8},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6749e405-a31c-42b5-bdb6-ec37decd90e9\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.529816533E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b56614bf-2f6c-4046-9bd7-7162d979debe\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3cb0fd5b-a2ec-4b70-bd3e-07bea38e2243\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"ProShares Ultra MidCap400\\\",\\\"ticker\\\":\\\"MVV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"348b2ae2-f9a4-4266-8d1e-16ea212652eb\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":130018.59999999999}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"7\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"1ba0d459-0423-4f84-8a6a-fb2d21b2728c\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"2498bcf2-5dc3-44b7-ac53-46e8ddd3e4f2\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"cb7691f2-3713-4f72-865b-47c72645293b\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"1811a082-ab90-43cc-9186-4a626ad741de\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"04e9852c-7955-4ec2-85c3-22fb7c49c6dc\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"76c0225a-060d-41d9-9571-54a7f551be4c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":7.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.270521856E7}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"09e04572-0dcc-4143-9790-19ef6f540d90\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"bdd7fbdd-c22b-4f37-bfaf-0360292e5a36\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"b4004ca5-e696-4f98-9f8c-08d6e3a55a2f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"b0b8b987-812e-49d0-b486-5ec68e7c7c5a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"88cf880a-d177-4a88-805c-99cb0021c08b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"383e97f0-2e1d-4c68-934d-08435ae6ff95\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":61.32,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.65597774064E9},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ed779805-eaef-4340-9530-e96a4fd08e41\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":55.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.1806370296E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b874a34a-fefe-435b-a5a9-eac375182742\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":70.73,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.714480458100001E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"c5f5a2c4-6890-426d-8fab-4f301b1ba11b\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"fcf05c47-b7e5-41c7-b38b-c91b04774dff\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"63a40ea5-ff20-48c9-82ac-9097cff05b12\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"615a05d0-9441-42fe-8f66-5279bfd0e97c\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Defense | Modified\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"ffa3b721-8d6e-418a-a41f-d337a59a382b\\\",\\\"children\\\":[{\\\"id\\\":\\\"697a0ba9-0a03-4f79-b031-71ba8223f342\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"7885147e-4c36-419b-bcaa-22ed8d83d167\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"19456ad7-82c0-4859-a154-1b3af42235fa\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6f045e02-7ced-43ea-9ff3-c689a5c889c2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.5,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.28180325E7},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1110a185-1352-4c9b-8427-072ffb15900c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":55.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.1806370296E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"997cf8be-95d9-4c96-a1d1-00d36da4d71d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":70.73,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.714480458100001E8},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c99b67f5-9bfe-4e58-b33b-3ff03746a781\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":64.38,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.087537804458E10}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"15b566a3-131b-4e12-9c42-879b5746bc37\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"f2646b51-1878-47f8-ab7b-7d13831ce6f4\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"36d8cf2a-0084-44b5-a185-6c1410d04803\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"2883a9fc-1f04-492b-a6fa-80c0bc4c75cd\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"90273871-a24a-4abf-b15b-2e41fd741552\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"a6322d73-8a14-4869-b41d-2b8ffa922a50\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"9a9b9588-abf5-4860-9a6e-e0f76abdb705\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"c110121d-8ba8-45a8-9d6e-03e2b89d95c0\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"9692b1f7-842e-402e-bedb-9caaab4f32ce\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"f3acb8e0-584d-492f-8acb-fee93d8b4bf5\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100}}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":true,\\\"weight\\\":{\\\"num\\\":\\\"50\\\",\\\"den\\\":100}},{\\\"id\\\":\\\"3af74d2c-5e58-445f-8275-75fce959f483\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\".V3.0.4 7/40 2012 | ?? Beta Baller + TCCC ?\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"b6ac5943-d00e-45d9-bf6e-a504d0ca3c2c\\\",\\\"children\\\":[{\\\"id\\\":\\\"f91094ac-8db5-40a8-94ee-18c96c4e4b01\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"da8c7600-d8e4-483e-8c35-1d69cf692208\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"fc9a43a1-7fa3-4419-98f8-e001985b8263\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"cfd3f5ce-90ef-4142-af02-019e509320b0\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Overbought S&P. Sell the rip. Buy volatility.\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"03dc33cf-883f-4597-9514-49dd30b54c95\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a0304feb-b119-4b81-afd1-e7128df30205\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":11.45,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.5342449984999996E8},{\\\"name\\\":\\\"ProShares VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"VIXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7bccb252-b182-4683-a1ad-1a3a93b23668\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":15.84,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.4911915392E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"12\\\",\\\"weight\\\":{\\\"num\\\":\\\"80\\\",\\\"den\\\":100},\\\"id\\\":\\\"180dd4a0-067f-4023-9cd9-2bf5d1c24b7e\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\"}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"51c538d4-6f0c-44d9-bc30-d6c38f92ac40\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"75\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"9deda23f-02fa-42c6-a341-0437cf71ce40\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"cec0ce3b-c333-470c-83eb-d12564150962\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"4b405a25-dafd-47e4-9299-cdced5b21790\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"60554365-a869-4fa8-b651-6fa38527fcbb\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c65583e4-9294-4b5b-95cf-c2ab423e97cd\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":13.87,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.19211018399E9},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"68892ea1-9acb-4974-b76e-36f020f795ed\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":22.96,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.24194747976E9},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"edb01110-01b4-4c05-ab75-aa3c23c7ba87\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":29.43,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.7871923727E8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"23961e6f-e389-4ba4-aeb1-f8c5ef4676a4\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"12\\\",\\\"id\\\":\\\"e84b0ea3-fd60-439a-bd38-8af6e1324e0f\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}],\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"current-price\\\",\\\"rhs-window-days\\\":\\\"2\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"c17f3892-0471-4691-afec-d986f7837ee9\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SOXL\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"9e6e12ef-729b-4a67-9a82-28ecc206abe5\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"e0981ede-2ce3-40af-b424-0872c67ac68e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9d138bd9-32dc-4438-babe-430ab0c1bdec\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1453642752},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"434f5115-6cbe-4b86-937b-ca7a689af78c\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":43.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.059458332200001E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"12\\\",\\\"id\\\":\\\"508911f2-7944-4980-8d5c-b7ca3a5ac9f4\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}]}]}]}]}]}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"40\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"9cf1fc15-bf4e-4bdb-b15a-a087d3daf11e\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"85da289f-fd2c-4e5f-be57-bf2704acc307\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"30f8c78e-e7b4-47e6-a25c-e874850f5267\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"fac38dbb-c7ff-425f-b661-258e9aa6df1d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"3c9ce2bf-7579-4e94-8390-db302f4df023\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Extremely oversold S&P (low RSI). Double check with bond mkt before going long\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"080ec2b1-cb00-4910-afe2-89d7bdd6af8c\\\",\\\"children\\\":[{\\\"id\\\":\\\"ed400367-2856-4fad-afec-3dfbfcb0d6aa\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"aeaf67eb-4ef9-4926-aa0e-41ddf1ba97e3\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cb3ba385-ac94-470f-92a9-ea8b6ce84ab2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":75.59,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.57344069699E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cc950f91-4751-4a7f-aae3-edef136eb2fa\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":63.2,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.8760366064E9}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"7\\\",\\\"id\\\":\\\"34f44f01-3ae9-4cc8-82b1-05e09c9c46d2\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"8\\\",\\\"lhs-window-days\\\":\\\"8\\\",\\\"lhs-val\\\":\\\"BSV\\\",\\\"id\\\":\\\"7413552a-069b-4a18-83dc-fb0dff5c2c28\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"SPHB\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"fa62d400-e358-4e1d-b8e0-2e1ab437b180\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"a8795e8a-4a26-4729-98e0-7c2965da5715\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"85584514-019a-4505-92ca-ba156fc5b0b2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":13.03,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.27717077433E9},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f9b61b80-89da-4148-ad68-2526496a0eb6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":75.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.03091986416E9},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e68315ba-7e8f-46b6-bcaa-f313e65f901a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":29.43,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.7871923727E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"22f1a951-d807-401d-a64a-0f85aa20c7cf\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":9.61,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.1763240372E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2f288868-d2bf-4deb-8aae-550bbe4417bd\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":39.76,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.198274304E8},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b37055ab-d178-4f36-83dc-7e9c84c06d9d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.31,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3435416.19},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"75a61a9c-7a9d-44d8-a0aa-a0f8d5f45f69\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.25254404161E9},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"dd718026-082e-4c55-8d3c-cf66328c4d5c\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"18\\\",\\\"id\\\":\\\"bc313f35-1d3d-4d8b-9c78-6904ccbf6de4\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}]}]}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"e9b03e56-ab9c-47b3-bd7c-4eff8cce6c93\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"27\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"a86e4631-953b-4ccf-8be4-a6cb8af1289f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"4fc8fe88-6ee3-4ba4-b1bf-5196d41d4623\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"V0.2.1 | TCCC Stop the Bleed ? | DJKeyhole ???? | 1/2 of Momentum Mean Reversion\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"e825f0a6-0ef7-4890-9607-fb4b736f4e40\\\",\\\"children\\\":[{\\\"id\\\":\\\"87cfd022-e05f-4a83-8119-7a4e7582b6a6\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"b7cff22e-98f0-46dd-afe4-3a9e4017e8ff\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"V1.2 | Five and Below | DJKeyhole | No Low Volume LETFs | Belcampo69 changed for > AR removed 1\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"ef2c639f-44f3-41d4-bcf0-86c19452b5f5\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8a4f90bc-2afb-4069-815a-741842ffd6c0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":13.03,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.27717077433E9},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"03523996-ea97-4311-9dd2-2263542b3e8f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":29.43,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.7871923727E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0df7e235-352d-437a-a393-7da1da17614e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":9.61,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.1763240372E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"41bfa461-89c4-494b-9bdc-29fa502c4943\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":39.76,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.198274304E8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"2805fbbf-3ab8-4cd1-adf4-dad952d575dc\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"17\\\",\\\"id\\\":\\\"012ad3e2-e58d-4391-90c3-b7d2d3924029\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"b36fe356-68d1-4377-b579-4196348539e2\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"fb14be2a-fa4a-4413-91fa-987231e227a5\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"31d74705-1184-4456-95e3-f6e5f5c56f88\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"bcec8a09-2bcc-4241-92b2-534006797d69\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"8e649688-a978-46ae-94e3-f36b1b62aa41\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"dd2146d0-0e51-4c1b-9bec-19a6c82a3ed2\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"d331c075-cd74-4549-892f-613b450ce60c\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Bear Stock Market - High Inflation - [STRIPPED] V2.0.2b | A Better LETF Basket | DJKeyhole ???? | BIL and TMV\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"ee9820ca-acd6-4fe2-845d-d0e738160c20\\\",\\\"children\\\":[{\\\"id\\\":\\\"35c71160-d51a-4e51-a8b6-b72eeba980ba\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"db9fed03-35af-473d-bf24-b4f7e46fa017\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"A.B: Medium term TLT may be overbought*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"094019f9-ba40-4734-8084-7e0a20d00612\\\",\\\"children\\\":[{\\\"id\\\":\\\"713e1c21-05c6-4b65-ac10-2d1753321210\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"37e8ade1-db20-4f04-a70f-272b28c18492\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"A.B.B.A: Risk Off, Rising Rates (TMV)*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"16ffd681-42d6-47ed-8c4b-8e8f5751b839\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"6c61ef24-ab10-4724-8e40-0c04d969461b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"2cde05b4-c2da-4bb5-9c66-813d2575ed17\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"c437db45-54ae-49cf-9d2a-4e63f1268738\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"59b6b8be-e0d9-4804-ab67-cf3e2ac4c34a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"29526a7a-8500-45a1-9f23-8f16ad4aa507\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"576436ee-bbed-4233-9ca1-d1815cc5f563\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e10cbab9-e59d-4f21-90a8-627b69202789\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8cd2daaf-5b73-46f3-b9bc-0a4e8eb74763\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"4833fea9-1b78-4c69-a8f8-1872739c9539\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"6f202e78-50cf-40ec-8ed7-e9cfd931da4f\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"5c801d33-e4eb-4436-b62d-a885cf54b95a\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"51a76b84-7ed8-4d55-bbb4-f0b25b578e77\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"13ded061-1d8d-469f-948d-202108bcb843\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"a44b7d1f-f12b-43da-ac2a-e0ab10853ec8\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"62704481-6f63-4975-af9d-1359117b5dac\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"27d0a525-edd0-4f6c-82d7-03fc0a7395ab\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9},{\\\"name\\\":\\\"ProShares UltraShort Euro\\\",\\\"ticker\\\":\\\"EUO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c854c6b3-41ad-46d0-80a3-d2a30a42e8cf\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":34.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5517930.159999999},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c6196500-302d-40d0-ac7a-6ad28173f34f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"23718b3a-2ae9-4b4c-a8da-899d1da3ec43\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"SPXU\\\",\\\"id\\\":\\\"0c6cc8fe-39a7-480b-a2fe-1b325a50c222\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"d7f46e46-3a12-42ae-9a23-0c4569724b3c\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"b4a1cf14-8c97-4d0f-b3c1-b8e36815fb32\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"683044ff-c5e4-4d3b-8991-16bb1f9ca397\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c654315a-382d-45bc-94fb-db9db5234dee\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"88c23b30-5e4f-4832-94f4-cd6592f12425\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"Direxion Daily Healthcare Bull 3x Shares\\\",\\\"ticker\\\":\\\"CURE\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c09c3917-55c8-4698-b7ea-c18d3ba6dd47\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":89.46,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5880205.8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"49dcd606-7f0b-4bda-86c7-a48231ca668a\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"52ca70a4-8387-47ca-9c28-1a68a7e0ebdb\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"dd1f9cb5-a1d1-4c48-a51b-1169d7eb66e4\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"9081b5c2-5fac-405b-8640-05350d028864\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"17d2dc35-bcbc-40c7-b5cc-793d4410b03e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"7b0b3dc1-316f-48ea-b629-865d12ba9bff\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"bd529451-7cd8-4198-8568-7b0b0416741e\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"6fdc40e7-aa48-4059-811b-98671257c4a2\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"8adacdfd-ac98-4740-986e-7c0a885968a0\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"26b2249c-814a-421d-8dd4-4e3e576dd004\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a419b714-6df6-47fb-a9c2-9326e70358f7\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f581b4fa-f74d-45ec-8e0c-aef27d3a2aa4\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"43c3527a-64ac-4703-8d1c-3128b58be392\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ec7e371f-b4a7-4638-bfef-d8101c0b5eea\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ddde15ae-8967-4731-ac1f-f4df5df36028\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":148.89,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.982935702999999E7},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"a393a043-c4c4-4b2a-baf4-ffca4849796b\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"fec1f227-4fb5-4cc5-b5e4-7eb936d4ee05\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"6224e1d9-e350-423b-9556-470f11b12a05\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"0\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"2723cdfb-8bbd-4a0f-9f01-808403ef9e60\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"4935e873-9b2e-4e20-8b9c-7096d260cf69\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"A.B.B.B: Risk Off, Falling Rates (TMF)*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"3e39bcba-d1ac-4219-9803-ddf6f1c70c7d\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"c67d9d3b-a501-499b-bca2-3960d11365af\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"85d7f34e-4936-4b8d-b58b-7e9596885d46\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"e96a19d0-ea4d-4b9d-9bab-02b47b3b4979\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"9c818799-669c-4209-a6ab-ca87001a12dc\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"86d3eedf-ecb3-40b2-9b56-f732f577d415\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"97226e5c-ee64-4318-8208-5b55f7aa7167\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1106922b-087e-442c-8265-97d6aa11873c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"d59355f5-d6ad-4e96-b5a7-f0a5a15acd48\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"893b095b-ded1-401f-ac61-81799c371ad7\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"baef6723-dc85-4fb3-8298-076ed6698b4f\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"17bd387e-49a6-45b5-8cf0-210f44fd24d8\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"16b6817d-b496-4a4a-9657-d0b177ef2639\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"d0d31baf-b5be-493a-837d-24ccff3c91b2\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"2584b414-9989-453a-87bb-a1278f9a69e0\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"92cbc78d-1715-4d58-95b0-4f3967132cfa\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.327053606E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b04b0ce1-4380-4ef0-826a-d4aa974a8139\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b3fd2a11-6072-4269-a5dd-976b476a7d64\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"796fad91-d139-4fc2-b70d-7c84655f75d1\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"2\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"c53cb0ba-a171-42aa-bdbb-544cf2dd3785\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"-2\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"66735064-4839-40ad-a4fd-a84ffdb9d990\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"1b05926c-2cc5-4eaa-b566-1ab039e94fa6\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"7eff34c7-e3e6-4721-8d3c-62acf555b11d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"a682ee85-e35d-4109-a009-3199463d6392\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Energy Bull 2x Shares\\\",\\\"ticker\\\":\\\"ERX\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"64f08563-22bb-4974-9b7f-a43c7c41a272\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":51.3,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.7945037539999998E8},{\\\"name\\\":\\\"ProShares UltraShort Euro\\\",\\\"ticker\\\":\\\"EUO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b6da052b-8851-4d00-a466-49962be743fe\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":34.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5517930.159999999},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d8a99244-ceb2-4614-b0ce-6c7d7a842e59\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"e4dbeb5d-8831-444a-a207-25a648351e6b\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"SPXU\\\",\\\"id\\\":\\\"c6fa6c2a-94b0-4df0-82bc-80e77d203f2e\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"8d443c84-1e67-46a5-9672-64fc57585883\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"3429cad4-d5fd-4d22-bf7e-9845f5331e3f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0b0b061b-5744-4fd0-8211-2ca218d78f74\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"da6a5ed0-1c90-4ebc-90ee-b35d6cca2edd\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":31.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.6195129461E8},{\\\"name\\\":\\\"ProShares Ultra MidCap400\\\",\\\"ticker\\\":\\\"MVV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9c2df734-5be4-40e1-9ca0-45e4ae4766bf\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":130018.59999999999},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"17de28c9-dc57-4a53-b331-b80c54e8ff62\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"c31b3f9c-1f6c-466b-ba74-0af5cf01bcd2\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"fc05bcd0-b1db-4f0c-838a-ab8bdbed82a7\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"63aecef5-c89d-4f1b-9d37-c006ef91001c\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"8402532d-f2c8-4b72-bcc0-81de90e2c84f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"0f59ddcf-ac1f-4685-bd30-94538dfd21f9\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"f3d8e1aa-7c7d-4dff-b857-084b4467b45c\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"e52491f2-2a74-4c7f-8276-df30a1ac8ba3\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"1104139c-5233-45c5-a392-90da1842d60b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"57828464-e3b3-4eeb-bb7b-de158a508167\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"62f3c097-fb7d-4cb8-9ac1-9a3a51b64fc9\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"220c09c7-d3a5-4f9a-9c2d-1bb1253c43ca\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"e24c7ba7-210c-43d0-bafd-b8ec1a996c5a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"1bf88669-7a68-44ab-ac76-a0ef0006f274\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"7c0b85c6-9d26-4031-a161-c582782c22bd\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"747f8ab1-8e83-489b-b4cf-efea900e2513\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"2a1efc6f-aadc-47b8-8834-1344ac9aac2c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f6fa15ff-710e-4d95-9ca9-7ea9fc8906d3\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":10.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6812945732E8}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"9c8659c4-1556-4025-87cd-0c0b29ff3efb\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"5.5\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"ba8e6670-f46b-41b9-86f5-070e30c9f824\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"34293c7d-8c2b-4d4f-a025-d85d032da575\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"d3c177f5-eca8-418a-8f7b-cef2848cf6c4\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"16d20487-0e1a-4112-90fa-4411b9d17899\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6ba8d2f9-3747-4639-803d-677e76ca3425\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"36a81c9e-91e5-46b6-bfa9-eee8e21b64e9\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"79a1e305-288b-464c-bfc2-74c51334d0b9\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"7d5ee081-f3be-4820-b876-934b253e6942\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"1cf9edb6-4c28-4a76-b99c-10aad6bd64ba\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"c289fe12-bb4f-4d69-90b4-2ece3db20156\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8b4f9d3a-1cdc-4087-9f76-aa8006630328\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Invesco DB US Dollar Index Bullish Fund\\\",\\\"ticker\\\":\\\"UUP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fe3c5502-5c72-4838-a6dd-afd13b4f52e6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.15,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.429251705E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6c139e03-a7bb-4dd0-aeb0-fdc81c05a201\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a30af108-2a16-4745-abf9-0dbd8c3e579f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":29.97,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.165467361E7}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"44e6ddbf-8892-43fa-9cc9-0e8e5d3c802a\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed-specified-weight?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"cc135e4d-e4ff-4795-b029-82efee2efbef\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"-10\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"71eb76d6-2cd1-46b3-8eeb-a7ec0eb3e3e3\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"1c69e668-071c-4fde-95c7-38cd65935e00\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"de064b30-5f83-4a67-be88-c949b0e9c4a5\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"6ffb6e3b-74bb-4feb-8a38-fb0eb3fd737d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d2af3a5e-ed9f-4e50-8646-57b5ae76b096\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9f707b46-2ff7-47d9-8ab9-cd56f6e0c06a\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7c340388-e0d6-4937-8e56-b9bbb8fe161a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":83.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.8172328099999994E8},{\\\"name\\\":\\\"ProShares Ultra QQQ\\\",\\\"ticker\\\":\\\"QLD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8615e92a-8977-4d64-b537-8c88e3d16995\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6824665126E8},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"967c8d4b-80d0-4e22-a875-79eff9b2b201\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"18683784-b3c9-49d1-b6d6-759300844601\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"b13cc76a-9d1a-44e2-8e85-432f40101cb0\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"636287da-7568-460e-bd36-24b9588652f1\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"73ec4eb6-28c4-4896-b076-7b42d8f38dd3\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"f7555c6f-bee1-45fc-aa35-8c19b3eb9798\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5f93361a-61f2-4929-9a3f-de7f283fc9d1\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Invesco DB US Dollar Index Bullish Fund\\\",\\\"ticker\\\":\\\"UUP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ad1ad4bc-e087-4857-a2f9-17585fc5529b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.15,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.429251705E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"13a6e564-7777-4443-bc98-aa74e963cd08\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"8a37a45d-0c42-471a-a718-84fbaad0ccf2\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"dbd7f2de-a1fb-448b-a754-ba35698c7992\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"1ccacec1-1e03-4574-995e-1288e06ad0cb\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"cdffd5f6-82a8-4b13-b7aa-37e784de3652\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Defense | Modified\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"f58fed26-8a23-4cde-a559-1ec761e7f00a\\\",\\\"children\\\":[{\\\"id\\\":\\\"ce882c79-875b-4abc-b91c-a61fd3d84a44\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"1d479b85-7458-4aa0-b0e4-9350af68437d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares 1-3 Year Treasury Bond ETF\\\",\\\"ticker\\\":\\\"SHY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4c7a63e8-d61f-49e2-8c10-678206006f23\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":82.38,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.516601524599999E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2eb85dd0-b75c-4160-b77e-03718d51ad00\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.97,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.040002155799999E8},{\\\"name\\\":\\\"SPDR Gold Shares\\\",\\\"ticker\\\":\\\"GLD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"31da4374-932f-4b03-8d06-cf8a76fd9365\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":162.77,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.6775562373E8},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ee755b1a-4202-4494-a286-9dd7736e811b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cd7636b7-e356-4438-ab33-c84db293b810\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":55.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.1806370296E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"494dca13-5f92-44da-aabb-72902f609b96\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":70.73,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.714480458100001E8},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"86bcc0a8-0e04-4a83-affb-439a7faae2c2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.2,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.985865139999999E7},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"271df808-0e96-46aa-aa0e-fda3643a0416\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"c68427cd-cb4a-4a68-9444-78d262c2d5b1\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"0de299a1-a3e6-4ce3-bce1-234db97cf76f\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"66ed1671-de3f-4175-8fc9-2aa7040744e1\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"3d11d7f8-f309-46b3-88eb-ab308eb7318f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"e757c20f-5140-4d8d-8cbf-867744388593\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"a65ddd1d-96bb-4494-94ee-76678815e240\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b867053b-ace4-4fc8-9715-0499fdb17050\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"86a8aea5-7585-4912-82b9-392f909af391\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cd03db29-9ac5-43f0-b6e8-0c936e50d330\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"49452eb0-c1c6-4d2e-a0b8-e49bb1f51d60\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"4d5c6a55-5e63-48c1-a34e-9e4598c2aceb\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"6f2ed71a-53d5-4bf2-bb70-df9ee40544bb\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"35213ecc-23e9-496c-8b50-17a45ab0edec\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a3a1b504-2e89-4c41-8731-13d7d5834b23\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"22f217f5-1f43-460a-b0e1-33ca62b4442c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ccbc76ef-b3ed-430c-9afa-12e67142825c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":44.99,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.058357684200001E8},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1cf9b373-ac48-44a3-aeee-764d119b2420\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.2,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.985865139999999E7},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0e74aaae-4335-401d-b3ba-5ad5e7b49d25\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"d42f3ba4-cd02-4873-9082-70460054cafd\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100}}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"current-price\\\",\\\"rhs-window-days\\\":\\\"200\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"fa7adcdc-4e3c-4869-92ff-11ef2e8c85ab\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"TLT\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"e115b052-11b9-447f-8ca8-0348f20fcb2f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"79dd8508-7a05-4447-b04e-b60b5b08fb48\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"B: If long term TLT is trending down, safety: Long Term, 2 Least Volatile*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"793199e3-b6d2-4499-8647-1e646ef95fde\\\",\\\"children\\\":[{\\\"id\\\":\\\"2897690b-d0f7-447c-a831-d17cffea11ed\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"818ff79d-ccb5-4065-a8d5-61b0fea799af\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"B.A.A: Risk Off, Rising Rates (TMV)* - LETF Basket^\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"baae2c35-12b0-42ed-a779-53cb31ef130c\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"d47cb93e-fb87-4014-9f80-dc0c5968e35f\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"c159c7e7-cb8d-46fe-a954-a1c1647a2e10\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"cc0ebe25-6444-4e41-9e9b-9ad85b11f72c\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"2531c3be-b5b1-48e2-b987-b6190ce95743\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"23b0305d-cb99-4ff7-9761-23087acce5a3\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"985423f0-3750-4153-9e01-8ea8d8825e1c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8c69f7d0-58e7-4c17-b95f-f03f7f4f9074\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"8bbc6135-8a95-4c75-9fc3-6bbac0c699d7\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"f3dd00df-f73d-4d77-a3a7-0d3d8546bde6\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":true},{\\\"id\\\":\\\"909f05b7-6886-4e2b-ba64-0c0204b74af0\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"10a68b28-347a-42e4-944c-63ec1168d072\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"3362f3e4-9903-4865-99f3-09895be15aa3\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"890d48b7-386d-4824-bc38-5ae27bd1f480\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"18ef4370-4c04-4bbe-82f2-01b874a097ca\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.91,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.3752632333E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7d8b0127-43a0-481e-802f-2ff6453f43ad\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.327053606E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"463e1af5-c275-4628-8dea-ad619d8974c1\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2f50c368-96e5-460b-9c26-5ab52b179def\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9},{\\\"name\\\":\\\"Direxion Daily Energy Bull 2x Shares\\\",\\\"ticker\\\":\\\"ERX\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3bc4b175-9334-4c73-ba14-180331f3e90c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":51.3,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.7945037539999998E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"7eadbeba-dc59-496c-ab91-3148f44b0cd5\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"2\\\",\\\"lhs-val\\\":\\\"UUP\\\",\\\"id\\\":\\\"7002f493-d0e7-44e9-9e5c-4a2f34384bdb\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"1\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"3d0912d0-2694-4d9e-92fd-8ea7c319e6fa\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"6604baf8-e255-4ef4-99b1-590a0450e3fc\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"c0eabb49-5c1c-450c-95ec-696de89c3a3d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"ae62ce20-4bcd-48f6-be89-d4e3fdae40b6\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"04e4fb2d-8478-4540-9953-0aed521cc6ca\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f3a3c157-d1fc-4a09-97a7-37e0afcf9a92\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"23eed353-b1ac-459f-836d-b1272fde14ee\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.13,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6708776.130000001}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"cfd15396-3027-4698-8615-9a4f3882cfa6\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"4\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"SPXU\\\",\\\"id\\\":\\\"4093a339-b6a8-46ec-9de7-13c5aebe15c3\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":true},{\\\"id\\\":\\\"6d0d0c37-6438-4954-b18d-87a79ef66e4a\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"19ef9bba-0617-46eb-946e-65f97bdd8778\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"46d0183e-b846-44ac-a02c-a9584934274f\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"f9304d35-157e-4c8b-bbb6-aca1c9480423\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"38025bda-4eb9-4080-8110-d2267f80f22b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"23fb70d8-524e-4107-ba2b-a8e154c24837\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"Direxion Daily Small Cap Bull 3x Shares\\\",\\\"ticker\\\":\\\"TNA\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e4f7d1a3-bdc1-4062-8aa9-93db263094ac\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.84,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.7466253824E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"490ec666-eb84-4c06-8119-988ee2f5f7cc\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":33.96,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.8879939692E8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"0a561065-cb44-4e13-9448-c4024add3c4a\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"6e92de79-0e4a-402e-b843-25db2ff38a82\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-window-days\\\":\\\"3\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"40d6077e-3a78-4fcc-b9d6-97107dee88fd\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"TMV\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"f9668e62-4489-4d8c-a968-8b754c670e53\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"9726afa2-1dcb-41c4-9eb0-95da490dc13d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6639a51b-63f5-477a-87fd-159a7cc61040\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f7ac3581-465a-4596-808b-2f90ae9ebb68\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3c6152dd-5f3c-4d9f-9fb0-39c21c74c006\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":157.82,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.906629694E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"8f61380f-6922-4ed3-82f6-add5d43d30b0\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"64ded43e-60e3-4b55-8a59-a94f3af037ea\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"b56eb1da-9a84-43c8-8c6a-14cb814dfc46\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"11663430-b538-45e5-8097-9607066eb842\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"1dd838fa-0bec-435b-b52c-69ed84c53ecb\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"0ab8dbbd-366d-4649-899c-d01355e7fe53\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"da02d726-571b-4abb-ae8a-bf4505ddb5fd\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1cd07762-805b-46ac-bd07-e6a442ac0ec8\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"a199dd46-4d17-4d82-87d1-aa0a38d85cce\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"eb8e4af3-3f6f-4a74-af0a-3cac1145a37f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"ba37c872-c2f0-454b-bd10-45b8fdf4971a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"d7f76b96-a163-4bcc-b0f5-f87855328ea7\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"702d09d8-d443-44f1-99f3-9cddaaf6767b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"012c52a2-3eea-4da4-ac97-65bf6aeaf17d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"2174a158-9e94-433d-8628-1c7cc8e7ee50\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"129dd099-656d-42c9-8caf-20019f26aa82\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":10.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6812945732E8}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"1392c57f-8593-4989-9888-0524f3381346\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"5.5\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"77338ae0-a362-464d-a119-2abe9e11e85e\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"3e045f34-c8c1-4bd8-847b-64000ef40119\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ca5ea158-2835-470c-a1f6-3a6de9c6dc93\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"e128bbf7-15c4-4c2f-8fec-47e43c5f07cd\\\",\\\"step\\\":\\\"asset\\\"},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"beb47367-72f7-4b13-9bef-052e6baf40ff\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"3786c655-854e-4841-a8c6-c4276b043705\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"da8fd05f-b47d-4186-9ba7-ddb5ecd0d879\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"-10\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"a439ed05-3bb4-486b-be1b-dd463ad38966\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"9f32ed67-f5ce-40a3-a4d9-88e015ae6f9d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"47414a6b-1f6e-4b6a-a8c1-b1f298ea2e8b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"829c0b73-f966-4a8b-b1cc-c89dc840e555\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4164e03d-b3d0-4f94-8b0e-db0467c91357\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"bed21cc8-8411-400b-81ac-7a582b20e8e7\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6bf9473d-aec5-4d6a-80e2-903fbf36e559\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1c789c57-9b82-42be-bc8f-5b528fe22f5e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":148.89,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.982935702999999E7},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4f5ddc75-681c-4cb9-80f2-ab85d44db850\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":19.95,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6883044604999998E8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"10f40157-2d55-4773-8858-3b951ff05207\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"5341fd58-f01f-4e4c-836b-48e4434de76d\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"f2d84271-1a1b-4edc-ac19-b09a718e5fa0\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"c5747c35-476f-4ef3-a4a9-432d555b94c6\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"27401bea-6bcc-41e7-a96f-a42bfd4793bf\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"98054d58-4c5a-4b53-9599-77243fec3a26\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6d766b2f-4025-4391-809d-cb83a494c74e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"de526f56-a5df-486a-8917-c5c8a313ba93\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"22\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"5e93366e-3075-4285-9822-ec1ae5ab3c70\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}]}],\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"81f11047-a7d4-4e94-9cdd-cda0d20b4133\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"869d657a-eb77-4d38-b365-f1aef5bb5dbc\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"0b3ee4d6-b6cc-49d2-be91-5e5ec5693610\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Defense | Modified\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"6516fb6d-307e-4897-b4b0-eb38ac4018a3\\\",\\\"children\\\":[{\\\"id\\\":\\\"769991ed-4878-40ed-bc72-ff438fbbed05\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"a606b164-1675-4c42-a628-e436de33b3dd\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"a2b270f1-a369-4a2c-a9b2-2211faa9d3af\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"56ffe7fe-9191-4014-b0a1-dc4276080739\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"502c1d0e-830e-4474-9380-0231570f3229\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1fe3e200-f19d-4606-854f-4bd14bc8614f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"5\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"TMV\\\",\\\"id\\\":\\\"20ca5de3-3b48-45d2-bd3c-2b463d7df090\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"31e296a7-8a2a-43c8-a63d-d70b8b8e0d57\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Invesco DB Commodity Index Tracking Fund\\\",\\\"ticker\\\":\\\"DBC\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5c13de7c-04cf-4dc5-80e0-e9a219cc75b5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.33,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.922121070999999E7}]}]}]}],\\\"rhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"100\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"0348a2aa-a0f7-44b5-aefb-0ca7919149f3\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"3\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"456f3221-2914-4886-9004-47ee0d9b2a85\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"6fa17751-a731-4ab4-9e67-fec531b97c2f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"a4611078-053a-4509-bab9-347593a72f4b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"e557e19f-dd0b-4793-adac-3949333bb79b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a472dcaf-8a2b-4f4a-9734-bb3e5a69a1fa\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"57f83c76-8a49-4f7b-9b8b-e9ac477d5a4c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":80.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.38192436325E9},{\\\"name\\\":\\\"ProShares UltraPro Short S&P500\\\",\\\"ticker\\\":\\\"SPXU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"20cb57c2-3b85-470b-8b03-5ce4670cc0f2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":21.92,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.14726053376E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"b4064b92-140c-4b96-9b0f-e54609016875\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"70f85045-68cb-4616-aee9-d1f6d5b9261b\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"9a696506-ad07-46e6-8a90-cab61d33fecd\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"1a3ecabe-e3ee-4aca-a935-08489d7c0549\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI EAFE ETF\\\",\\\"exch\\\":\\\"PCX\\\",\\\"typeDisp\\\":\\\"ETF\\\",\\\"type\\\":\\\"E\\\",\\\"exchDisp\\\":\\\"NYSEArca\\\",\\\"ticker\\\":\\\"EFA\\\",\\\"id\\\":\\\"6f93a1d2-6fe0-405e-aa04-4aeeb0ffc829\\\",\\\"step\\\":\\\"asset\\\"},{\\\"name\\\":\\\"iShares MSCI Emerging Markets ETF\\\",\\\"exch\\\":\\\"NYQ\\\",\\\"ticker\\\":\\\"EEM\\\",\\\"type\\\":\\\"E\\\",\\\"typeDisp\\\":\\\"ETF\\\",\\\"id\\\":\\\"24c5730a-08ed-4d63-aba6-3fc0480826b3\\\",\\\"exchDisp\\\":\\\"NYSE\\\",\\\"step\\\":\\\"asset\\\"},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c97bacec-6d5c-48e6-a11d-280e25212a70\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2a33b80f-7473-4a65-a760-5eb853240849\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":44.99,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.058357684200001E8},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1e365513-8de5-4654-b324-73ed3d2744fb\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.2,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.985865139999999E7},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2a21a20b-3197-4d0b-af8f-0f2a3c06b550\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"e1879d9c-4eea-4d4e-99b8-1a7f9f1eeff6\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"eaa172dc-4c04-42ca-9443-f5a892d4beb6\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"7bf00b60-81ad-4dcf-a458-534bb59997e7\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"a25e05cd-ca66-429d-992b-35f1dfc7fbcf\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"e1bb2d74-d0ed-4b26-a595-e7048f79b994\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"966ad8b3-8a79-42ba-a4d5-5454c68c3051\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0a980bf3-d750-44d3-87c0-e5cd06cd4ec6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.529816533E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e83f01a3-dba2-45a1-85de-8a101e247779\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7b110323-44cd-4f44-bc7b-8ed8a7a8cf0b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"f2c84aae-c71f-4384-91a5-23a28b14e1d0\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"c5ed0da1-341c-485f-b497-e1a087c036c8\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"f7719246-a56b-48b5-a52f-358fffb2acf1\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"7042fa15-2806-40cf-80ab-71bac569cd18\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"93162671-b8ef-48ed-b7c6-0de4eb44aa92\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1ab2918b-6910-42f7-807e-fc50b201f1c0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9a3fcb46-86e0-4e76-94fa-e28b9ee96d6f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":36.8,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.218889968E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8e8817f4-c292-4b4d-86fa-b68ab4bc4d14\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":44.99,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.058357684200001E8},{\\\"name\\\":\\\"ProShares UltraShort Euro\\\",\\\"ticker\\\":\\\"EUO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"778de5e0-086b-4a4d-840a-47a04fb762ae\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":34.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5517930.159999999},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"aa8d3e85-eacb-4d17-9b70-54bb5a91c8ac\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5a01acfd-fd78-4298-8343-67ec41818596\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"a33fb821-69c9-4f5f-b95a-0133dc5f92fb\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"c10b7083-70d0-4718-95b8-edf3b78556d4\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"0\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"d1c60477-444c-401c-a16f-b8bb593236e9\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"a62c8a7a-dfea-4c53-82d9-8a3641f23914\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"B.A.B: Risk Off, Falling Rates (TMF)* - LETF Basket\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"f8c4469e-6b20-4c27-bedb-6628a8158521\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"a82cb91e-fb62-444d-ab3f-b6dcff7f2ce3\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"c2b5b6a7-fff5-4120-a9e1-a943b10faed8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"6ebf3311-69a2-47a9-99a8-c84bdb4ef6a0\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"275c150d-45f6-4744-af71-f82361bac9d6\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"14d91b02-90f6-426f-a737-0c8a87def4c4\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.91,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.3752632333E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a6156470-6700-40ef-ad5d-f34a4b8f9059\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.327053606E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"13fdded4-2c72-4496-9def-23cb97407798\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"161e9592-ce2f-43e0-8591-5519b35c048f\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"34e2cd64-48e4-445b-88a1-c97259fabac8\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"2\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"d39821d9-29a6-41e2-9df5-3d0af46c6c1c\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"-2\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"9bd11159-b512-4204-b60d-8ce79eae8185\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"a4f57839-196d-4b35-905e-5849302a58a2\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"104ef534-6d50-4d93-b00f-0261bbdfd3a7\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"20b36fdc-d223-436c-9f21-a3b5752e1e27\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"SPDR Bloomberg 1-3 Month T-Bill ETF\\\",\\\"ticker\\\":\\\"BIL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"81f6aa35-07b4-40b8-9c9d-46d3cb246f8d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":91.44,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.3686188791999996E8},{\\\"name\\\":\\\"iShares Core U.S. Aggregate Bond ETF\\\",\\\"ticker\\\":\\\"AGG\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f14ef348-8a95-43e6-8917-67f69d3423b4\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":96.34,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.3850104298400002E9},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ab45380f-e532-4e87-a3e9-c43356bc36ed\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":7.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.270521856E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"17a634d9-5ad0-404c-be52-7fbd501b8bbc\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"SPXU\\\",\\\"id\\\":\\\"b5b0eb88-597b-434a-b362-26cb24554e0b\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"4ab7bc39-4879-4af7-b10e-482ba7af4987\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"2886686d-31b9-4942-8277-5fe7d769e015\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ebdfa882-9ac2-4120-b056-68433cbf2c23\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d7f83030-5a17-4812-961a-d9be1fd1548f\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d2fbebcf-aded-4656-95ad-c3dad2c5c838\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"23303e60-ffd9-458e-afcf-c649e5e7450d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":31.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.6195129461E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"39e50810-3fcb-48c4-86ed-27b6d00e7b41\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"fc907e4f-5b30-4713-a602-a2ceb9afac26\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"9401f174-3408-46dd-8b85-cefab5b3f633\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"1414b2f6-72d8-4bd6-9d81-dc27c93890f3\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"9eb9aa82-9253-4b92-9be0-321d4ec33622\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"f7e9b5b6-d33e-4c01-b139-2e81d5352dd0\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"31e9cd80-1d2d-4353-817d-61b35310ceee\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"67e6ce51-e7bc-4f77-a06b-3403359f9380\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"829c814e-3167-46f7-acbc-a2427fbdc8dc\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"fc9fb0ba-2eae-4e80-beb2-c06769097d7e\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"734d2952-194e-4560-a133-8deacdae1f4f\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"b464293d-31f9-474d-b635-a63d03bad9f4\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"88ed27ed-0192-42e9-ad78-803195fd2c24\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"9a1a7231-0775-458d-b1e2-02ead687b39b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"ea2ae52f-4abc-4973-9e44-2173dca644b4\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"928fb7ff-ca75-4076-b20f-ef31e061b7b0\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"fc07d33d-b844-4d65-a2af-aaf32de5a1c8\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"cc9a7ba5-6976-48f0-ba08-4edab52df17a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"16d0184a-7ee3-4e95-955b-162c201f2dc2\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":10.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6812945732E8}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"b1f24678-a3b8-47e2-a41f-bc2b7488102a\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"5.5\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"c59a31d5-7acd-4337-9683-cde5fff45e6a\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"6878a1e8-7bb0-4e60-b2f2-11a1daa88ea3\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5b88a9d6-2121-488c-af82-00448bb2c63b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a244a6df-4abb-497a-a9c5-23ed45bc5da2\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"716923e6-24b5-4777-83e2-82167cdf8fa5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":83.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.8172328099999994E8},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8b21030c-cafb-4c99-855b-5f9cf2a93ef8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.529816533E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"50a0f614-8096-4cba-a31a-de851306cc85\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"346e1c41-6ae4-4dde-bd10-92e6216fa513\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"ProShares Ultra QQQ\\\",\\\"ticker\\\":\\\"QLD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ed6b243f-e65a-4562-be12-1b1f95a3fea1\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6824665126E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0cad3518-9af7-46ca-bcd2-0483df6c63b3\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":31.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.6195129461E8},{\\\"name\\\":\\\"ProShares Ultra MidCap400\\\",\\\"ticker\\\":\\\"MVV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f7187142-73a0-4e78-b282-22538078a03d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":130018.59999999999},{\\\"name\\\":\\\"Invesco DWA Utilities Momentum ETF\\\",\\\"ticker\\\":\\\"PUI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b2c74081-1dad-4ee5-9596-996861816e17\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":30.77,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":118956.81999999999},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9bd6a234-e6cc-4a38-89aa-4262c221a0ab\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c29e2301-62c3-43f3-b608-d5babb2089cf\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"7\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"256a6a27-b547-43ed-a576-95c05a0ac25a\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"cf2be8ec-c293-4e1d-801a-97890369fc56\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"-10\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"9d0d24f2-6dd3-44bf-87ed-d9b3c2873d72\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"742e6272-00c9-47c3-814c-b35d86069ea4\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"48a1202b-eebd-4bd8-af6c-3a0799d032d5\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"e923147a-d155-4877-b726-03f606a99643\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"93a09997-05c1-4c17-acf4-b80d321c0282\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4cef16d7-6618-41cc-bd87-1e6d4fd8f337\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":83.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.8172328099999994E8},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"34206538-5d48-464f-a63d-764bae87ec54\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.529816533E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e6b0c39b-7c22-45c5-b21e-2411efdae242\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"04d7b070-1320-43c4-820c-56cf7842e4cc\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"ProShares Ultra MidCap400\\\",\\\"ticker\\\":\\\"MVV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"35bf0371-f146-41d6-bee2-40f21597a898\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":130018.59999999999}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"7\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"73baa088-d81b-4fb0-b185-51e48baaae46\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"5fb44429-fb4b-40e8-b602-5cbc2aa26412\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"d2ecb1c0-a1fa-4cb0-b724-85da55cb1fd4\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"78f54091-3e0f-4690-b750-e260feb4ee14\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"295bd319-afc5-49fd-ab6e-d6f8ef025bc9\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1f2a9914-5b82-429e-a545-08cc2a4b0298\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":7.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.270521856E7}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"3bc672e6-c6eb-43d4-abc8-0e4a9cdd111e\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"3e5cacba-0ec5-499d-a625-f77d2ea0566e\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"78043931-6806-43c6-8eb9-f4465510a891\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"11b60ada-4cad-40e4-8794-02ab5049a9f1\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"983fb03c-fad7-46be-90af-64d2b7449e02\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"82e004f7-e11b-49c2-966a-99ff0280a866\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":61.32,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.65597774064E9},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b5e01fcf-aa08-43c4-9fb1-258366773251\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":55.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.1806370296E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6993f48b-abdd-4238-a685-fee6810d3204\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":70.73,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.714480458100001E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"a0edc5b4-492b-4dea-b952-4fe939f761f3\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"fdcf98b3-5c3c-4c5c-8db3-63055934eda0\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"b8790342-4341-4d6b-a61e-adcf8f02d573\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"db9702fc-7c42-4250-98c0-2a2ad6fad0e3\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Defense | Modified\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"037b62ec-13b6-478c-aa86-8c76ad541111\\\",\\\"children\\\":[{\\\"id\\\":\\\"880de3f8-5566-4d64-b84b-7963b4b5f4a3\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"faae74d5-36ef-4b1f-b67a-6f725301b9c8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7ae37af2-9abb-4403-b8f4-482d57175420\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f0314104-c5a3-402f-88b3-46c97b2ac42f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.5,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.28180325E7},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"64af8463-9a63-4cd8-992a-646e74543088\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":55.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.1806370296E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d18227e4-8a36-4104-9cee-8d8a49e52d1b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":70.73,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.714480458100001E8},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c1a0240d-7ef5-43c2-afc2-c0c422bca314\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":64.38,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.087537804458E10}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"92a67f9b-5518-453a-9ccb-9032fb2076fa\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"96720f3f-7123-4f74-b514-ff1dcaf5df85\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"65257d76-c8e4-4ee7-a120-8fd7b1e1f9bf\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"56c6d57c-0bd8-49f7-9d3c-43ef4383b78a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"961274ae-5e36-402d-8bef-a31a3f64c8ca\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6b33cfba-3d83-4864-8878-b598e3ea818d\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"434b0faf-9e28-4313-a1cf-a991d78da3a5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e59b1b25-4c68-409b-a840-996070d0e177\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"15bfbea1-c7e8-4f27-b00b-9c2201f76361\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100}}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"UVXY\\\",\\\"id\\\":\\\"5fc0815d-cc58-4389-83a0-497570ebbc53\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"84\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"0b7d3e35-3941-49a6-ad90-c7e7c1070c14\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d254667a-fc71-4351-989b-1f586bcea351\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":12.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.6779972826E8}],\\\"collapsed?\\\":false}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"UVXY\\\",\\\"id\\\":\\\"aab03e5f-1fcb-4b9e-a837-16f760cb3eb1\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"74\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"a174cf68-45cb-4e5b-9194-879af955aa2d\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"61994a5e-d242-4bd9-8e40-936a4c9dfa0e\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Bear Stock Market - High Inflation - [STRIPPED] V2.0.2b | A Better LETF Basket | DJKeyhole ???? | BIL and TMV\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"dfec3641-05b2-4888-9ac5-3483dac6cc42\\\",\\\"children\\\":[{\\\"id\\\":\\\"c06c2a6e-72b7-4731-82ff-ceceff8f0168\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"201f6985-f0cc-41cb-8b15-373f1bc4f009\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"A.B: Medium term TLT may be overbought*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"48a8ed9e-b033-4b1c-a348-ab590a5521b0\\\",\\\"children\\\":[{\\\"id\\\":\\\"e347ccf5-04ab-40b5-a3cf-bc5146bdbedf\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"53197b4c-d6a5-491d-9b6c-62d80f37bbea\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"A.B.B.A: Risk Off, Rising Rates (TMV)*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"786b7dd6-d5d7-4731-88c4-100fea46b3b4\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"81e9c0c7-54bd-4137-8989-643e36ae87b8\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"550d1dee-d2d2-4bcf-8003-74a1cf5fe132\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"8d8618b2-74a3-41a1-97b2-30093e783f0e\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"0643ede3-6139-42ba-a3f3-8b4cdddb4f65\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"43413aff-11ae-4d14-9614-4a4c96e70935\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"acddeafe-c8e0-4190-b719-197a0bda6c08\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b8b30ce6-cca6-420d-991a-034e558ded5c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"678e7f14-12e2-4569-a2ce-cb637e3f3186\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"15cdde8a-e8d7-4120-9707-fdc9bda044cc\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"f4181c98-c9f4-4125-8a71-c5b593ff3c56\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"1aeb4e11-40a3-4643-a082-9dbed6cc00c3\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"4c27ed33-ce2e-4cb5-b93e-39058cce098e\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"d41a1bfd-f995-4dc3-a6ab-f5d5e7e48440\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"f82bf3cd-e679-4099-8633-39d1b28ac839\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"92009a26-60a9-4961-b532-8832d59b11d5\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"42d2a745-21d1-439c-9f34-bfd01e75a1a3\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9},{\\\"name\\\":\\\"ProShares UltraShort Euro\\\",\\\"ticker\\\":\\\"EUO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"77fc3729-2193-402f-8ce0-f848b6e50e17\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":34.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5517930.159999999},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"751771e2-306f-409a-834c-cd3ec892e20d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"dd39122a-bac4-49cc-9023-7a776693b10e\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"SPXU\\\",\\\"id\\\":\\\"6c640fb5-5e54-4d60-9d94-b45b8a1a4db0\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"1879f150-e717-4807-9b25-21bd2c2f2e17\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"5207a1f0-33aa-4f5e-be4c-cb7ab9ff6f3f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"10c777ca-f336-4643-9882-426cb72ff7b6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5720eed9-cb1f-4f50-af20-31cdeb22e2d4\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e6a41f8b-e456-4adc-a406-5c7d7cdedffc\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"Direxion Daily Healthcare Bull 3x Shares\\\",\\\"ticker\\\":\\\"CURE\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ef021295-27ab-4f0d-ac94-6692d8524a44\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":89.46,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5880205.8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"fde1f6de-b05c-46f6-8a34-fac3c503943a\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"23bbaeb4-dc53-4e9e-9e12-387cd1f5d015\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"30ed7dda-f4f5-40a8-b100-c3c0e22e7147\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"833d3f5c-5309-4659-833a-6b1268e53155\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"18b47164-2698-42db-bc20-c2b131b48826\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"a4e3cda7-983d-4a66-af22-f73de2cf2673\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2ebe0eb2-d2c0-4bc4-a5df-763cd83555fc\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"829846ee-79c8-4f2d-8629-6beec47fbcfa\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"54972575-fe84-4dab-b945-c09575aeaa7a\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"59b15346-4863-4499-b00a-b8c0faea484c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c810817d-c210-4b43-a4c7-1535288a671c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8d3be478-b14c-469e-8192-14d73dbc3d06\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"808b9da6-aeb4-4724-aed9-73fdbd6da0d4\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d5e9d6eb-695e-4ea6-b589-d968428f6221\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b6137dd8-c906-49d5-be02-1d0abe2c4b5d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":148.89,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.982935702999999E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"2d6f0e52-3289-436d-b5f5-c3302db64f9f\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"2c5650e6-6576-43b8-8b13-f082f9e94e61\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"0\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"bc2ca21f-9e39-46d6-9d25-07ae99c26669\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"2edc9ffa-e642-4de5-abe8-5d3fddf199c9\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"A.B.B.B: Risk Off, Falling Rates (TMF)*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"1ec3d6a4-b8ce-47ee-933e-ba6e6cda5b01\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"806db0d9-5526-45d7-ac59-24475cbb089d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"913a33c3-9c5a-4e54-a2c6-2b5becec45f9\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"d327135d-416d-4bbb-ae18-f9bbb2d6f53d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"d0036c92-53ec-44bb-99bf-4b04cd50fe95\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8f9112b1-708c-44d8-8678-2b10029ce733\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"88bbf525-9012-46f9-839a-0866c66f4d9a\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3067000d-b550-444a-85d3-e36b82d5a4c4\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"8a50ca52-84fb-4bdf-9602-6ee9a1731333\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"5a94d447-945b-457e-9d0e-fbb5dd20cb44\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"abad25aa-7930-43a4-97dc-b9c7bfcf0160\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"aacfc6dc-ff75-43af-9895-2785f39add70\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"82aa3831-adbd-43d6-84b9-217c6778189e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"fc85731a-c37d-45af-ac47-14960e5a9815\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"2a23d6cf-23bc-4763-b5d4-a63a7d886f65\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a75ea596-3653-4d88-99b4-35c7278369a1\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.327053606E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"032b5772-ac47-45e7-bb1a-9e81f5a7b1fd\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c370cc7c-2ece-4830-8ca7-de411e565ff0\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"9a05ea9e-b9e6-4cfe-aec2-7a76d5a3b25a\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"2\\\",\\\"lhs-val\\\":\\\"UUP\\\",\\\"id\\\":\\\"28b9c985-4caa-4ffe-8ddf-5e675bfe91b8\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"1\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"8f69ca70-baca-474c-82d7-15107c7faffd\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"1a7a6561-375d-44ba-b0d1-cb82b944045e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"96724bbb-b2a4-4e40-95d9-b8b836892ffb\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"486db3f8-4156-4267-919a-a7f81ddbfb66\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Energy Bull 2x Shares\\\",\\\"ticker\\\":\\\"ERX\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2eab5e71-ea2e-4a33-8328-3536ccc2f13c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":51.3,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.7945037539999998E8},{\\\"name\\\":\\\"ProShares UltraShort Euro\\\",\\\"ticker\\\":\\\"EUO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a5f06d63-0f14-4f33-86d1-d0ad3934180e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":34.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5517930.159999999},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7ad59398-db39-4b80-9e29-38012521e2e2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"5dec1475-5156-4f74-a169-03e8b2159106\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"4\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"SPXU\\\",\\\"id\\\":\\\"1929d248-962d-458a-a8d5-833d1b1e22bd\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"a50e0f12-b3b8-44d9-9f0c-1561bcd64310\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"e6bc4eca-eb9c-40d9-8500-04cb98cb4a7d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2f15e765-9b27-4a58-8941-f6165a927cf3\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"dbacfa82-0741-4072-874f-c4b4f5b23efa\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":31.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.6195129461E8},{\\\"name\\\":\\\"ProShares Ultra MidCap400\\\",\\\"ticker\\\":\\\"MVV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"05de6393-5c5c-4548-b4fe-b4df6d62cf52\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":130018.59999999999},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ff9c4b1b-be8c-4c3f-9b07-8369189f8551\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"bd0fb2da-d85e-4583-a6d7-26111622c8c9\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"9f7b21f4-1b00-4052-977a-30d4c247ce68\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"ab6db5c2-e3ca-48c5-97d7-f7d6cf939ab4\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"4ddaef58-e0f9-41ea-af61-e9d8e6f6db54\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"7c5cf630-9b75-4359-abd4-2690aff0c948\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"178fe662-a6c0-415f-8e42-28deefcce9d3\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"bb8b91ad-7d5a-47b3-810f-5a41f9dca9aa\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d19555d8-7607-4848-ac04-2a5bb02cc4b4\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"677010ee-811c-47bb-93ce-503773426f05\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"5ee80514-4b32-4df2-ae1b-22547285fb31\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"b2fdd93a-8957-4aa6-8003-2a6c6cf7b9d6\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"1302ca43-6582-4edb-9a1d-c0ddc39ff91f\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"a7a5ea56-3c6c-4f6d-80cd-a23bc6221337\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"47b63527-9bbc-448d-99e9-b3d0d5efaea9\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"cbd14b3b-3c32-45e2-aa84-3b287c2577c7\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"466dd777-297f-42fa-a0e7-9f7936cce184\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":10.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6812945732E8}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"36452ad8-800d-49e5-9c68-6dddc5df7d5e\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"5.5\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"e25cfb39-4faf-436f-8d89-6c62c69bbc28\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"349a648a-5f19-459b-84c2-51cab5b41946\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"7f8fe14a-31ba-4803-bd1b-a1c64dbc5a93\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"ff4f6cae-f4f7-4882-a944-b5df78357ad6\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4b00a0a5-5861-4531-bcde-2784e6054168\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"35932591-3d9e-4183-84bf-7ad452b248b6\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"f025d858-ce34-484b-8d65-e198d881f80f\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"ef052e70-41a8-41f8-b206-152896f8ec4a\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"855d9785-5f07-4fa4-87f6-d6f41d07dc98\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"023304b3-2350-4a1c-93f3-266550b37850\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ce406558-213f-4e73-b4eb-1237f6f6f898\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Invesco DB US Dollar Index Bullish Fund\\\",\\\"ticker\\\":\\\"UUP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0e0c465e-bdc1-45dd-9285-13a3920f8ffa\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.15,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.429251705E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7d0cd75b-8c23-40ac-a7fa-d741b6ae284c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5f857bb7-1070-464a-b465-9b597b8dbc08\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":29.97,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.165467361E7}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"50e717dd-b669-47c4-a9ae-73ff9d758682\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed-specified-weight?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"f3a318a3-164b-42f1-b150-5525d6cc7d96\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"-10\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"9aafd9db-8c9a-4c7c-ac15-60acde4c8f2d\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"c7c3e13b-8daf-46a0-8cb8-6b9980a36c61\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"48ffd059-68d0-4f10-8866-3564809e835d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"74c22208-b3fb-4d38-95fc-50929070c06e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"222b43f6-b07b-43a7-a943-b955039fd485\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c83c896e-7942-420b-ba1f-0ec199056ab3\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"08306b17-1176-46c4-9319-700de531156e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":83.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.8172328099999994E8},{\\\"name\\\":\\\"ProShares Ultra QQQ\\\",\\\"ticker\\\":\\\"QLD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9e852801-bc28-4b62-8002-dd835b8cae88\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6824665126E8},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"59979547-9d01-4163-834d-c32db86396f8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"78924c51-67c9-41fc-956e-99b16e014d99\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"c896b5f1-3681-4095-bddb-141d749de9aa\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"440667e6-17ef-4465-a308-0324892561a1\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"27b8962f-403a-48db-8084-b1e26caa39d2\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"4441a7cf-44bd-454f-8218-bf5c21617935\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6a9ca6c9-0231-44da-a396-8fada754faaf\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Invesco DB US Dollar Index Bullish Fund\\\",\\\"ticker\\\":\\\"UUP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4a605250-2b1f-42fc-ab07-59d34adde648\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.15,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.429251705E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f60f132e-dee7-48ad-bd17-34195ed723fd\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"54c56d4c-690f-4470-90c7-0d8fa46afba4\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"8defc76b-3044-4e10-8783-15a2e801c371\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"8a2360b2-4d88-4829-9956-a156bfcfc1e6\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"2871225f-51b2-48b7-bb36-504d73a442b9\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Defense | Modified\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"a27f4507-3591-4066-a432-de069a1eb67e\\\",\\\"children\\\":[{\\\"id\\\":\\\"e2148c58-959d-4205-a8f1-f8be3e653cc5\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"16cf29d1-aa66-4a09-9c20-67d2c2bde79d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares 1-3 Year Treasury Bond ETF\\\",\\\"ticker\\\":\\\"SHY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9b51c7ec-13be-4ea7-8e56-ecde8476fe1d\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":82.38,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.516601524599999E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"dd1bfdf6-567e-464e-91f2-ed2519d7df9c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.97,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.040002155799999E8},{\\\"name\\\":\\\"SPDR Gold Shares\\\",\\\"ticker\\\":\\\"GLD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"42a6c755-61aa-45a4-a26a-89f96c9aa319\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":162.77,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.6775562373E8},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"58dc6d02-8510-49be-8b8d-a107dffc3602\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"52333fc6-b8cf-4465-9201-df72473f8266\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":55.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.1806370296E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"92999a99-aee6-436a-93dc-7c58ddb23257\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":70.73,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.714480458100001E8},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ae6b368d-cdf5-4c44-a1b4-bbf911797b21\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.2,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.985865139999999E7},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9010da58-3729-4e4c-933e-bf5bb78e9842\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"e46a8866-4539-4134-8644-cec391bcb27d\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"bed3f522-b56f-40cd-b4e8-373a408c120a\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"e2570a4e-65b5-43f6-a155-9bcfd977c84d\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"4e15d2c4-2fd0-4caa-b03e-6d0e576dc659\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"c7afd683-41f6-44a9-a67b-ccc0ea074058\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"315ce919-75ff-4f15-8479-6fa88a6147ff\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f0b82b36-c318-4054-8938-9195edf5f326\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"35d2f4ad-4c97-452e-93aa-4745ae6691d2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"57eac4fd-074e-43cf-94cc-1a96ceeba54a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"2392f79f-2038-49eb-ba4a-eda38800ebc1\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"7dd059e2-fa55-4bf8-93b9-82a333e80dcc\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"6834872e-20cd-435b-a838-4640acddbeaf\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"c8a4c7f6-aa16-4ae7-ba6c-fed1f25cd7fa\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"c9e2e171-38d5-49f1-95f2-592ef1c89104\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"234f8ac0-f0b0-4c3f-bde6-fbe7b83a4cd4\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a1c7eee3-4ab7-4709-8193-c0a8bcefb77e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c8c03413-991b-46e0-963a-851694a1bfa2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":44.99,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.058357684200001E8},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a74c64d6-8566-4abc-ab67-ffb3faddfc94\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.2,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.985865139999999E7},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"67a9a7a3-5a41-40e8-b677-ce7bee8a3047\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"97deac13-2a91-4fb7-8471-f9b43d7cb425\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100}}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"current-price\\\",\\\"rhs-window-days\\\":\\\"200\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"4fa0ba4e-5aee-41c8-b7d4-3e17de072dcb\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"TLT\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"3aebdd24-8d8a-48d2-9945-b169bb0eeab0\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"b8728779-7e56-443e-b9f5-8d449e1ea98e\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"B: If long term TLT is trending down, safety: Long Term, 2 Least Volatile*\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"01dadedf-2065-4629-a597-3d4a52f690da\\\",\\\"children\\\":[{\\\"id\\\":\\\"f6948000-11d4-456b-bc98-66468399ee12\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"cc9e6386-b31f-4531-855e-3c2ecd1ab27a\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"B.A.A: Risk Off, Rising Rates (TMV)* - LETF Basket^\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"cd3e67eb-063a-4585-947d-2539595aaede\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"2b890fc8-61e7-46ac-bf42-3d1469956c2d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"0c35c75b-b8f9-40cd-be5c-1b96014b2987\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"c08b5825-e71b-470c-8adc-b8752d2c3207\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"e59b7f1b-e74f-484a-b5ce-08bc2e1ad83a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8738fb06-afa4-45c5-b010-3702bcfb490c\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ab8c658a-a2d9-4c33-8709-6dfdbc2bc0a8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"963377f7-f8bc-4303-a6ac-6e2e5f7a1882\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"60cda6ff-d020-45d0-bb3c-9be32813ebdd\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"c21c7439-9537-4d48-99ec-cabad5f29221\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"f1e14a5e-1ebc-40ef-be9e-e38399e3c44f\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"61dd1133-8545-4269-9889-655761da27a8\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"520478e7-661a-4a0f-a9b9-8a5d7e90e9b9\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"4f4608ab-c741-4bd6-99c5-d81c20311d71\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"fbaa12b9-63a4-43ee-a71a-846cbe61d979\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a1a3eddc-5506-4cb0-b8fa-4adec19054e2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.91,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.3752632333E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"88bb2c82-8351-4e6a-9d5a-34d88f4a73ca\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.327053606E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"24a2322d-dce7-4ebc-a051-2dcb37fa4fc0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c4522791-7e99-4614-a757-a699b4c6ffdd\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9},{\\\"name\\\":\\\"Direxion Daily Energy Bull 2x Shares\\\",\\\"ticker\\\":\\\"ERX\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b9b49366-879f-42f1-8208-89b6c30f35e2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":51.3,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.7945037539999998E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"7c4697ec-fb45-4531-b906-05ddb3b98d6d\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"2\\\",\\\"lhs-val\\\":\\\"UUP\\\",\\\"id\\\":\\\"3e5cc30b-b270-46e6-87a8-37005a1ad90d\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"1\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"5c30ca31-f1e5-4b34-b823-d3150bff9c8b\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"e8ee6a21-7693-4c6c-a018-3727787fe12e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"94247e50-6201-42ba-aa25-b8cd67293f96\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"d3a2f570-b1e7-483a-ae8d-5bae4efe4801\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f9167167-205e-4bf8-9c3c-fccb22f4c99e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5d4a53e8-6b2b-48f6-b488-68ffb04ece17\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0d8b9122-887e-40fb-8311-ddc983775086\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.13,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6708776.130000001}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"a29f3768-f47f-49cc-b9fa-bb3da785204a\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"4\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"SPXU\\\",\\\"id\\\":\\\"82ec0f3b-84f7-4f21-a7b8-dc86b105c2c2\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":true},{\\\"id\\\":\\\"b8861401-96f9-41eb-ab55-8f34720c0e17\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"2f3a8c23-762a-4b75-bfae-7f8558c800c7\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"97f6812a-f186-4a37-8d12-a8c636a07ef7\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"31901b1f-ad66-4e96-b89c-a048b85b25f7\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f9e99200-36c6-4f58-9972-22e7d14cd4ac\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0c10c461-bfec-4131-8a10-08fe73aae68e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"Direxion Daily Small Cap Bull 3x Shares\\\",\\\"ticker\\\":\\\"TNA\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4c6b36ac-48af-4a4b-8517-a799ea7e0f50\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.84,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.7466253824E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"210be9e5-12dc-4fb0-b96e-57ef5a3f7217\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-window-days\\\":\\\"3\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"7755b5b0-a6d5-401a-9e77-d740163b15f5\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"TMV\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"3d3850f0-3287-4846-8a59-29bea8285416\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"0dc3612c-829b-411d-a054-4942782ea18f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9d3f4559-2601-4f8f-a2f2-6353912fbdad\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"48602641-36fa-4d96-aeca-2893d0d35cd6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.92,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.04673400904E9},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9dd38455-b618-475b-a23b-6c4cad1028eb\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":157.82,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.906629694E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d8d89a07-471f-48b7-b884-45dee501c77b\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":20.95,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3542169102E9}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"3\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"8ee0d663-8d0f-45b0-97e0-e1466fbe5384\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"fd63df25-2aa9-4b5a-a143-93b88b517a22\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"abb99253-a3ca-4da2-8855-b1c8baedfe7b\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"86872211-2820-4535-a06c-f229217cfc2c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"f834c0da-6845-4d5f-ae84-0e632ba1f89e\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"250cc63d-2175-41c5-ae1e-30e9b0e967c5\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"d2f7302b-5371-4b6d-a0a0-818864603eb6\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b97d4e46-6dfa-499d-a6f8-3b534141feda\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"7527f6cd-7bf0-41ae-8b9a-2f59446ed519\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"eb476187-c6d2-4fe3-b2da-8e6c24d3f3d1\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"180028cf-cebc-4681-b666-6d3fb4e12a0b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"b6ceddb6-7e88-4436-9295-f6927ae75ec7\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"f66c47de-f12d-4295-b490-f291423eccd7\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"031fb4d0-37fa-4687-bb30-5989ab8c9f5d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"ca84d2af-d8d7-411e-bd25-53d3cca1fc67\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"76843113-8bd8-48c5-916d-72e155861556\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":10.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6812945732E8}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"a0b5339d-5298-459d-b82a-91da43524387\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"5.5\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"3992c123-2bb0-44ee-9691-107382e682be\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"eb1fb260-0416-45e2-aca0-c775aa9a73be\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"475b3933-edf3-4679-ad6d-26754f4dd995\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b535c7de-8318-4147-b03b-07160341aa88\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"2a0b49df-cd75-4ed5-aaed-83b5b44746de\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"aba8e689-bcb1-41b3-a6a2-f46c7eadaaef\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"-10\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"3fce8356-f371-4321-8b2c-06cc13f8cb05\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"ec04cfd3-7ede-4a2b-949c-869e69925a3d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"dea44614-55a0-45f2-b4fd-172231f3c74d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"cc5abca8-2ec9-4977-a715-2c4f9e0dd6af\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"690cc27a-9ce2-4235-b8ba-898595d52672\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d7d0644a-55c1-4ed5-898f-9e8861311c90\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d205a16d-500f-4f83-a568-d109da3733a1\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"45db7f9c-6c3a-4fdd-9135-078fdf2aa580\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":148.89,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.982935702999999E7},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fc796800-d656-4f0d-a5df-09e1a95434b0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":19.95,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6883044604999998E8},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"4b72c6d1-768d-4ba3-8cc1-d907c84642fd\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"d136e7ee-1a7b-44e3-91ab-8841858057ef\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"d5e05462-0ea0-4b2c-84d3-3424e8a53470\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"f086340d-5bd7-472e-8648-cdf274deb076\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"29c237d0-e1b3-464a-8e20-e5d922b190bf\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"993c84af-f195-45c4-bb8e-b1edf1e2e959\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"effdb03c-4e15-486d-83cb-8be2b5d32ee5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"22\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"4ecafde9-8621-4332-a3f9-42a2b4bf8a09\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}]}],\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"4dc81576-0251-41d6-9fcc-a9ac2ee7744b\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"3a11792b-5f5d-4c2f-86a8-964728316b6c\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"460715db-cadd-4c9d-b562-59868e348ce7\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Defense | Modified\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"3dd8fa8f-e849-42fb-a770-d68ed1ea7123\\\",\\\"children\\\":[{\\\"id\\\":\\\"9e970624-7f02-450c-9db5-f6721c1983ff\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"3f620007-52c9-4513-be2a-ff5e8d8403f7\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"4e78d062-72c0-42d9-8c27-0b87ccd31b1a\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"a07e3226-bdd2-42c3-835d-2a4ecb1e6b76\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"1444568b-6bd1-49a5-a801-df847784c53a\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1e3a17c9-e6c0-45bf-ba3e-3922a7876cea\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"5\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"TMV\\\",\\\"id\\\":\\\"b0411613-97a7-42eb-828d-890548dc10c8\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"bbd00759-a6d5-474c-a287-e444aeb9a751\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Invesco DB Commodity Index Tracking Fund\\\",\\\"ticker\\\":\\\"DBC\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9016b099-c706-4305-8fe3-636a94e26988\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.33,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.922121070999999E7}]}]}]}],\\\"rhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"100\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"27ec5882-a272-4e51-a8ee-f8f725b61871\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"3\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"f5d14765-da30-49d6-ad18-290c6cd8cee4\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"541406ba-07b8-4370-b49c-a53482deb686\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"2587d85d-9398-45cd-b55d-9ac6c8ef5684\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"7e080f65-ed30-4543-aea7-8d10db08e942\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f7317709-3485-4bbd-b01d-d42e81e52299\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7c8771a2-5d2d-480e-8fbd-83eb3113d80e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":80.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.38192436325E9},{\\\"name\\\":\\\"ProShares UltraPro Short S&P500\\\",\\\"ticker\\\":\\\"SPXU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e4fdb173-0a19-4f9c-add5-6054bd6e3f9b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":21.92,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.14726053376E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"62b2b05f-9bc7-443e-b379-2f4422345001\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"ae84aa70-3c67-43d7-bfc9-0d1008af6d33\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"ff54d069-4b6a-40e7-8565-29d732a79551\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"1273a185-c57e-4d64-86ab-3c149e5218c9\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI EAFE ETF\\\",\\\"exch\\\":\\\"PCX\\\",\\\"typeDisp\\\":\\\"ETF\\\",\\\"type\\\":\\\"E\\\",\\\"exchDisp\\\":\\\"NYSEArca\\\",\\\"ticker\\\":\\\"EFA\\\",\\\"id\\\":\\\"9d1c6b5d-e810-4339-9e26-be284b1a27da\\\",\\\"step\\\":\\\"asset\\\"},{\\\"name\\\":\\\"iShares MSCI Emerging Markets ETF\\\",\\\"exch\\\":\\\"NYQ\\\",\\\"ticker\\\":\\\"EEM\\\",\\\"type\\\":\\\"E\\\",\\\"typeDisp\\\":\\\"ETF\\\",\\\"id\\\":\\\"5b32132f-8094-4426-b11f-2688402ba479\\\",\\\"exchDisp\\\":\\\"NYSE\\\",\\\"step\\\":\\\"asset\\\"},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"77e8721c-5eff-41c9-9bd2-aa060249cf2f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1ccd6943-f340-4987-9672-06935417fd0c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":44.99,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.058357684200001E8},{\\\"name\\\":\\\"ProShares Ultra Bloomberg Crude Oil\\\",\\\"ticker\\\":\\\"UCO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9c7b5ae5-93de-42dc-aa9b-d6908f731184\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.2,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.985865139999999E7},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d4b1cbee-63f3-46e5-8253-560d00761f7d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"99c8b132-70b6-44d7-8a29-5c2747e1b2a8\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"aba2a715-7f6f-41ed-9193-16994ffa1b5f\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"3f18aee3-c3bc-4c71-a1a7-c3177b50fe12\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"d8cb5cef-7454-47c9-b3c3-f4fe2c4533d3\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"32be21fd-a7e4-4488-8f83-2cee8ef7e484\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"5331cfc1-05ec-4538-af8f-7311ba8d7da2\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"632b9ce9-a809-452f-adb5-37d457ce3b56\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.529816533E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a6e8ccf8-22a0-42ce-bdc1-7f379c655e66\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5a63e004-9556-4590-a10a-ee16df88e89f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"34b069df-c337-4a2e-9109-66575d913bfd\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"6919fbc1-d89e-490c-9a51-fcb953fdcb0d\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"2eaf96c7-80f4-40a4-9514-6bbbc68e18d1\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"34c4fb9d-8d66-4e8e-9830-7f89b489d38c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ed5de22b-cff9-4b62-9cf8-890bf7953594\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":28.27,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3641556481E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b83cdb82-a722-47ea-add6-df979e3d4e6d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":36.8,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.218889968E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"587407b0-034f-4d34-98c2-13ed8e003e0a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":44.99,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.058357684200001E8},{\\\"name\\\":\\\"ProShares UltraShort Euro\\\",\\\"ticker\\\":\\\"EUO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8b712a25-fcc9-44f2-a7fd-a797b02c4f9c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":34.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5517930.159999999},{\\\"name\\\":\\\"ProShares UltraShort Yen\\\",\\\"ticker\\\":\\\"YCS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7dd0deaf-a7c1-4c10-af0f-70beb31e4d68\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.06,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3221445.9},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1c6a601b-093e-42c4-a514-1adb372b6322\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":141.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3188126099999994E7}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"a83382fd-bfd6-4025-baf6-8908f1e99d09\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"919dd725-d748-4a52-aba3-7ea141fd1bc7\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"0\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"74c00185-e39d-42ee-9e45-d2494223dfb2\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"2885becd-88c3-4e9b-905c-9ddef6302c62\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"B.A.B: Risk Off, Falling Rates (TMF)* - LETF Basket\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"83ab1e99-c843-45a6-b4a1-ad327cff9881\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"3cb622da-e577-4fd9-ba40-a773da725c01\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"c1fda29d-b3ba-46fd-8a83-3dd155b69a0d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"f7eb7fa2-bc0c-4ee7-b763-aba9f2670cf2\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"ae81244f-798e-48e3-ae4f-a8440ae7d5ed\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f997d4eb-9f49-405f-9b17-e73cee9569ef\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.91,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.3752632333E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"822894ac-04ff-423a-bd6b-09aea4ea7efe\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.327053606E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"57e737d3-98af-4bfe-afff-2e681606ceae\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"49b25b0b-d021-4e41-9e27-1ffb475c300d\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":44.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.90147741888E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"7036aaa4-bd58-412a-a9dd-ef83de29deaa\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"f676baa0-c97e-433d-bcb9-5cb68c1849fa\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"-2\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"588f7f96-29a8-4ecd-b3fd-6ac6cdc74d03\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"7ebf9051-00b9-4dfa-baa3-1872e9931319\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"8bceff9d-16a0-469a-b20f-9456d731c532\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"b56ab27f-d0aa-4842-bf4e-944abbb5a414\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"SPDR Bloomberg 1-3 Month T-Bill ETF\\\",\\\"ticker\\\":\\\"BIL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d178355e-d02b-4f5f-ba30-379b9497429f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":91.44,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.3686188791999996E8},{\\\"name\\\":\\\"iShares Core U.S. Aggregate Bond ETF\\\",\\\"ticker\\\":\\\"AGG\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2f432dd0-16b5-45c4-93a5-ac4823c194a5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":96.34,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.3850104298400002E9},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"15f07a19-33a6-45ee-9dc2-78dcf0acc640\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":7.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.270521856E7}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"5c57db4a-f8ac-4838-a784-50253e4e5eba\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"SPXU\\\",\\\"id\\\":\\\"9bfc9fa6-84a5-437f-bb26-fe252072b297\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"95057790-3742-48a3-a513-de95578cbff2\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"32ab70f5-2195-4b6d-9a8a-1e2965463bb9\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4f8adc87-8131-4d00-b35e-7832b4253c40\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e33fa944-b6d1-4d4a-a6cb-be5975a6bd7e\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ce3c03c9-1771-44e7-8b72-e6e414e24c6b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ec81d8f7-2d5e-49c7-a2ab-a365644e0113\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":31.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.6195129461E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"712156af-a882-4ba0-bafb-0a1177eedae3\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"7442f2ea-ca60-4a73-9989-e466e34f0554\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"5decef00-18a9-45ff-be4d-4e681f21c6d8\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"00b08f29-2b09-4b2f-84e4-ee80740546da\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"0b6948b1-2dce-417a-bd20-951f3a831c28\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"ca5f2449-4125-41a1-ab1d-3fb6a31725e2\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"6d625566-6528-4c5f-8153-222d697979f2\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"1a340346-18ec-477b-a140-dfdd85f6494e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"0975c38c-6b1f-4e2a-844e-e16c7dad339a\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"ef4e4de6-0419-4ce3-b8f3-1cbf12174439\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"a56dbb87-e85a-4df4-b63c-749737eb2fa3\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2c551e7b-82e7-441c-9fcf-13fb881e9974\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":16.19,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3964454544E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"11\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"5382282c-1b2b-4e91-a33f-760390ee11fe\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"77\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"9dd44587-0b89-46e4-9f9e-9acb1d8ef796\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"6b929784-99eb-4fa7-ba09-927cef70148b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"68226766-26dd-4cef-ab89-fbde21d5407b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"2ce0bdb6-b063-4cca-b1ab-27f112b6dac0\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"d75570c8-0d54-4c38-b25c-5f83bdc4b73c\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"39ddae9e-19bc-4ec5-b329-2edd9aab243b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2b108eb9-568b-47f3-8bcf-8a062aff0fc6\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":10.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6812945732E8}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"320e870c-f17e-419f-9efb-6d50751aeb02\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"5.5\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"1c943306-cfbd-43ef-a41f-54afc4a8be06\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"90cf63ea-a118-4de3-808c-8e89b2759a68\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"abd7bc16-dd99-4948-a582-0bc04bc22b95\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2cd1ae8c-a4e3-431f-a4a9-094b7d57f2f9\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a2a50cb6-6198-48d9-8c78-97b037d76b0b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":83.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.8172328099999994E8},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c397fc45-af33-42be-b13d-fe4996ccfffc\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.529816533E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e2ea69f4-e581-4ce4-ad85-2f196bb72082\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"02fb489e-fd69-4994-bb28-8041f769e0c0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"ProShares Ultra QQQ\\\",\\\"ticker\\\":\\\"QLD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b2838e3e-4785-41f2-871a-22bc661a69ee\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6824665126E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d5338763-96a2-417b-90aa-37fd63dc6568\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":31.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.6195129461E8},{\\\"name\\\":\\\"ProShares Ultra MidCap400\\\",\\\"ticker\\\":\\\"MVV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7b7006c4-c1c5-47f9-8832-b1a1a8f216d3\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":130018.59999999999},{\\\"name\\\":\\\"Invesco DWA Utilities Momentum ETF\\\",\\\"ticker\\\":\\\"PUI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1a006580-dff6-4206-9843-980586bb28af\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":30.77,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":118956.81999999999},{\\\"name\\\":\\\"ProShares Ultra Semiconductors\\\",\\\"ticker\\\":\\\"USD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2be4f26c-bb90-4e97-844b-5060ae0d1910\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.68,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2838452.28},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"53bf72ef-2538-4a0b-bc60-72e195670bb6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"34608d3f-3443-4ffd-94d6-c25ba18a2155\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"7\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"0608691f-2ad5-4d82-b97c-ef954ce25431\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"5720ebf1-d568-4c23-b694-5cdb900ee9bd\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"-10\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"ae8e5e94-3122-45a3-94b3-e6a7bd354329\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"b8c7d45c-9fe2-42c0-84a1-9c60b6917b63\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"b122ddbb-92bb-4628-84dd-328adfb998e0\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"7eb46606-33bd-4c47-b2ef-ffe1e2c76718\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4f8ead70-6c69-4cc4-9414-3c381e06e269\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"21ac9ad1-6581-42b5-b1db-613621136d67\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":83.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.8172328099999994E8},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1ad98325-d78e-4a24-8a54-ae3d06ea53ed\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.529816533E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6972f424-488c-470a-8b2b-deb984e73653\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8a98b956-02f3-4035-9d25-09db87e5c7e2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":37.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.461024183199999E8},{\\\"name\\\":\\\"ProShares Ultra MidCap400\\\",\\\"ticker\\\":\\\"MVV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"27e55355-a160-4a33-acc1-f3d119a056a2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.05,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":130018.59999999999},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"dca77ea3-34c7-4e9b-ac7e-53854d44001e\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"7\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"df077192-6e99-4e68-a68d-7c03825eb784\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"7\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"096af08b-b37e-48cd-8574-1af43abf5418\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"9f498535-7d76-41fc-8f98-f39635b74e1f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"0ac08542-6a98-4cf2-ad62-b4397f3cbbcf\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"87e6de23-db47-427b-817a-73a228c0bc89\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.05451796723E9},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d6aa7d52-fd06-49b7-9121-9b57e7d8d399\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":7.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.270521856E7}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"b3f127a5-e1b1-4f08-aeb0-a0f9782a3827\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"4cb48c5c-c295-4a9b-b0f4-27ae965a334a\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"d92d58e2-3651-43c8-906c-14dea5abcf87\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"a8a1b748-e5fb-4bf8-b276-4272342b69cd\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"bf792a94-2e45-4786-b1c5-df12aa3d7ebf\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c1923b20-dc3c-4e46-a7de-89450b45ec53\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":61.32,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.65597774064E9},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3878f606-7bb1-4dfb-8c25-988bafc7b64e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":55.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.1806370296E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ba7b76f5-fa6f-4c5d-8437-a3a2e61ebe43\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":70.73,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.714480458100001E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"e9a40bdc-ec15-45f3-bcd1-ac5631e9e3cc\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"rhs-window-days\\\":\\\"360\\\",\\\"lhs-window-days\\\":\\\"210\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"5c7df76b-973f-4ecc-b651-78f7ecf4febc\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"DBC\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"92605ee2-3c59-43e9-a603-2b6147bbde85\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"0c1ba08a-c43b-4deb-a13c-b0202e62f366\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Defense | Modified\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"82bbc38d-7bdd-40bb-a561-0932e71982e6\\\",\\\"children\\\":[{\\\"id\\\":\\\"7942686e-e57d-406b-8f2f-bb0993eb6bd0\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"4a1b4e04-b35e-4873-b814-d14a6de3f511\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f690b0c8-9cb0-4fd6-a649-1cfd27a23932\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":20.01,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.0217437168E8},{\\\"name\\\":\\\"WisdomTree India Earnings Fund\\\",\\\"ticker\\\":\\\"EPI\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"23d46576-6db1-4d2e-b86a-333dd11384fa\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.5,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.28180325E7},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fe8f67fb-9973-4c36-99a2-d4d09fe7e62f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":55.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.1806370296E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4913773d-663e-45dd-918d-1c8a82b643d3\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":70.73,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.714480458100001E8},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6727e9ec-17ba-4e2d-9315-66c14e734499\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":64.38,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.087537804458E10}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"8011f31c-b338-4fce-b19f-f51c82cb3116\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"DBC\\\",\\\"id\\\":\\\"24722e05-21e1-4071-8ce0-6059ea9d5986\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"5e188626-8967-4409-bb4d-b14e0c949094\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"34262406-4a42-4069-a9f5-1774f175c40a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ea9f5a8a-2ace-4473-af3b-8ba6f85265f5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":45.48,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.993788247999999E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cd2e9c64-91c9-4d93-ad6d-2b7a748e6786\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":23.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.51222093884E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fadcf0fc-1b42-47d7-a98c-db708b96ebd1\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.0774877814E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f417b1d4-22d1-4b7d-bad4-56a7023e0cdf\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":50206167},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"86c1fa02-bb8f-43b1-9037-79390d1fce2c\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100},\\\"id\\\":\\\"49992e09-1296-4034-b3c4-789f3f76454b\\\",\\\"sort-by?\\\":true,\\\"collapsed-specified-weight?\\\":false,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100}}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":true},{\\\"id\\\":\\\"19e6888d-aa2c-4c34-881a-452bb5252a22\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Copy of  7e TQQQ FTLT V4.2.5a + Sideways Market Deleverage | No K-1\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"8e82a2e0-fafc-45f2-a677-de674a9421fe\\\",\\\"children\\\":[{\\\"id\\\":\\\"907c82f4-f21e-4f8a-8e7d-da693e44c9c4\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"TQQQ For The Long Term V4.2 (1957.0% RR/27.6% Max DD)\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"6aa2b555-be34-4e60-9ec7-c51e601baac8\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"bdd00651-5dff-4fa0-8de9-9c9e195cc53d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"96204cbd-ed3d-46d7-9882-fbfb9295e474\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"271649ca-86a4-4e43-aee6-b5bd058b9fa5\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"73bf0df1-80dc-4e0b-9af2-caa6797612f3\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":9.91,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.5052543003E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"14\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"ff5ced98-11bf-408d-8abb-9eed1ca87cb4\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"75\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"0269637e-93d3-411c-8a52-0b3c0e929a10\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"b57fd0af-23de-444c-84c0-3eb909e590ca\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"8f738ae0-33ca-4ce4-853f-ff8604ad6705\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3540fe90-4e0d-4a70-a6cf-7420e9fba77e\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":9.91,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.5052543003E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SPXL\\\",\\\"id\\\":\\\"75096727-5aca-4fa8-9edb-35ebd9c82412\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"80\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"9096baed-d30f-4852-87e4-69fc2acd9ee6\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"c15a931d-a032-478f-bef8-3cc4ec69d669\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"A Better \\\\\\\"Buy the Dips Nasdaq\\\\\\\" by Garen Phillips\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"623d7308-5229-4524-a134-15da7e648e9b\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"715d519a-50a9-4c87-b60e-36c06b0b4cf3\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"466689e7-2d17-415d-a84a-af7e4efcaf85\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"776c895e-d078-4291-8308-4f6bbb3a1baf\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f7103008-03fd-4223-ae52-7d303f80b537\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":47.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.33136042865E9},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"083019be-2e23-4998-b98c-db9e2fe02561\\\",\\\"step\\\":\\\"asset\\\"}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"a7e68e5f-295e-423c-9aeb-2600f50420b6\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"5\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"b96f6c07-61a4-4f3e-ac83-9cfbe8200597\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"8859f743-beb1-4c44-84ec-63a39dec4df2\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"8f997a64-5acc-4586-bc44-ea0ad3e6226b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"48c96bb8-e1d2-42c2-ac05-5d75cdde18c3\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":47.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.33136042865E9},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"9190d96e-b30f-4765-b821-d8611379d6c7\\\",\\\"step\\\":\\\"asset\\\"}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"eac1f0d8-76ca-412f-9c72-4f5c942c9fc2\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"20\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"9b03c19b-cfe5-42f3-bfb1-fac716e5362b\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"2bc55035-22dc-40c5-a1a9-91dd6f7e4d59\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"94b289d3-cd27-4fe8-81c6-6fd868b3a576\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"e31b7dda-d591-4515-a67d-920260f28113\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"55bcac4d-a557-429e-9f50-69716966ba39\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"fb07fbec-733c-46bc-b6a1-db3aeaea20bb\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"75bf9877-98d9-49b4-ba36-039e293aa416\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"a39ca836-437a-4d80-9790-dcd76988034e\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}]}]}]}]}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"bc684a3d-31ac-4566-b432-ed96df6035cd\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"-6\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"c7ede35e-601d-4e5b-b779-4b44fd376194\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"170c8883-4ae3-4f26-8bc0-038366295184\\\",\\\"step\\\":\\\"wt-cash-specified\\\",\\\"children\\\":[{\\\"id\\\":\\\"bd09b167-6ec0-4ab3-a083-6ae59a3dd5b4\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"31819075-1135-4267-9e45-c28cf676ec7c\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":54.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.91490645344E9},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"0dadde60-48dc-4a58-a88c-8ca77f1f354c\\\",\\\"step\\\":\\\"asset\\\"}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"caa069a5-53c7-44cf-ab90-d4bc5028031a\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"80\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"cbafb13a-7443-4649-8c14-21f6270cd5a6\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"6eb1dd49-54f0-4f64-8ac7-0df7b37ef13f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"9c9869eb-0de7-4464-9f5e-a1b009b6d4b0\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2145ddfe-f2ba-4c23-ad61-a8b132160f61\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.51440258684E9}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"71f8536d-652f-48c5-8bf1-e8132953351a\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"31\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"55354790-8b81-41b6-b75f-7482b50ad32f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"5b68b48a-b13f-4692-85b0-597ab1eff473\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"\\\\\\\"A Better QQQ\\\\\\\"\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"509b8ea3-1603-4f42-b8e5-5f38b12c3685\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"20ca0777-94e9-4d0b-a272-5d0731e6872d\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":22.07,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.674766804940001E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3e7ea78f-4b28-47ef-97b8-0cda67d07069\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":12.77,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.3692630201399999E9},{\\\"name\\\":\\\"SPDR Bloomberg 1-3 Month T-Bill ETF\\\",\\\"ticker\\\":\\\"BIL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0a28c0d0-c69b-4aca-8b8d-13b3686b25cb\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":91.52,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.549733107199999E8},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"86a56fea-aa5a-40dc-8986-789161e2e81b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":36.82,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.276874966E8},{\\\"name\\\":\\\"Invesco QQQ Trust\\\",\\\"ticker\\\":\\\"QQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"def5233b-00e7-4510-90ce-7b77ff8baa20\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":285.44,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.547058425344E10},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0869e00c-8663-426b-ad15-702c4ee09c76\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":27.36,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.3561306848E8},{\\\"name\\\":\\\"SPDR S&P 500 ETF Trust\\\",\\\"ticker\\\":\\\"SPY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3367b556-bf9b-4152-8e6e-f9e1c117bad5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":395.12,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.8038800989760002E10},{\\\"name\\\":\\\"Direxion Daily Small Cap Bull 3x Shares\\\",\\\"ticker\\\":\\\"TNA\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"57cdad43-9b40-4f44-81ea-d2ce9a99baa8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":40.29,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.3864535003E8},{\\\"name\\\":\\\"MicroSectors U.S. Big Oil Index 3X Leveraged ETN\\\",\\\"ticker\\\":\\\"NRGU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"269257e5-9522-4207-921d-d6e1595966b5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":675.291,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.26178798641E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"c423c143-7bfb-4b82-b886-66c397519f0f\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":20}}]}],\\\"collapsed?\\\":false}]}],\\\"weight\\\":{\\\"num\\\":\\\"69\\\",\\\"den\\\":100}}]}]}],\\\"weight\\\":{\\\"num\\\":\\\"100\\\",\\\"den\\\":100}}]}]}]}]}],\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"current-price\\\",\\\"rhs-window-days\\\":\\\"200\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"9a930d47-86c4-47dd-8cbf-a096542eba8f\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"7e6fd37b-700f-482c-90e8-437aa2526529\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"171c1b1f-47fd-4523-8635-2cf0c1aacb30\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"cd62db14-a4e2-451a-8466-7a0daeb1439b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"19ba4650-6da4-4460-954e-0718b4acc028\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Sideways Market Deleverage\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"40c49468-82cd-4388-acce-b566e437cd56\\\",\\\"children\\\":[{\\\"id\\\":\\\"1ad862ba-41a0-4a57-b245-247fefd8a94e\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"e6b5cd5d-8287-4f12-a4c9-7f9c80773b16\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"eed7e254-a792-48a4-8b84-cb13ae664d30\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"b0faea98-f203-4c77-ba35-2d6649e9f081\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b3ad7338-fade-4a6e-8253-f62a350d1741\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":22.07,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.674766804940001E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"de71ac53-ee70-4eba-a3fb-e343e99444c4\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":12.77,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.3692630201399999E9},{\\\"name\\\":\\\"SPDR Bloomberg 1-3 Month T-Bill ETF\\\",\\\"ticker\\\":\\\"BIL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1a5ee0de-eea2-4b57-889d-53a2b259db4c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":91.52,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.549733107199999E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d3ae3a10-e1af-48f1-b2d4-991f02caddcb\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.81,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.07568931002E9},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d6c445bc-37eb-4578-9193-5d7937d541b2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":36.82,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.276874966E8},{\\\"name\\\":\\\"Invesco QQQ Trust\\\",\\\"ticker\\\":\\\"QQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9e2d9593-16a7-4816-9275-cf54302bd933\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":285.44,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.547058425344E10},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c8fc5998-a99a-4a55-baa2-3e63f5d79392\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":27.36,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.3561306848E8},{\\\"name\\\":\\\"SPDR S&P 500 ETF Trust\\\",\\\"ticker\\\":\\\"SPY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9943f609-2a2b-4216-8e55-5a370a98bc11\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":395.12,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.8038800989760002E10},{\\\"name\\\":\\\"Direxion Daily Small Cap Bull 3x Shares\\\",\\\"ticker\\\":\\\"TNA\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"941806e0-7873-4927-8822-cd1ec28e8021\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":40.29,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.3864535003E8},{\\\"name\\\":\\\"MicroSectors U.S. Big Oil Index 3X Leveraged ETN\\\",\\\"ticker\\\":\\\"NRGU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"49a6c171-e76f-4c54-b54d-11ad60f75ee7\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":675.291,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.26178798641E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"7d87d473-a903-45b1-879d-bc2a3c91b3d6\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"1\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"ae97dc83-522c-4531-9ee6-37605d803f69\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"0\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"becc367b-710d-4226-a727-a064154da8b3\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"62d3fb4e-2049-4407-9f08-6c358fc3f7fc\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"faddab47-7be0-4305-b33a-273c308f5f4c\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":43.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.059458332200001E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"de4af068-8f77-4126-823b-41ed26e64d0a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1453642752},{\\\"name\\\":\\\"SPDR Bloomberg 1-3 Month T-Bill ETF\\\",\\\"ticker\\\":\\\"BIL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b0a0bbff-64af-483b-ab75-c0c79c1ede1b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":91.52,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.549733107199999E8},{\\\"name\\\":\\\"ProShares Short S&P500\\\",\\\"ticker\\\":\\\"SH\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ee4e71a9-961c-4022-8151-41727c802ff8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":15.41,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.4046728664E8},{\\\"name\\\":\\\"ProShares Short QQQ\\\",\\\"ticker\\\":\\\"PSQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"487d9d6c-6aeb-47c2-a294-7aecf4557495\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":13.61,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.1857280859999996E8},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"aedad64f-9856-4f5b-96eb-a014758505f5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":34.44,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.1179041467999999E8},{\\\"name\\\":\\\"Direxion Daily Small Cap Bear 3x Shares\\\",\\\"ticker\\\":\\\"TZA\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f3760000-2ec2-443f-a667-2b87805537f2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":29.09,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3918962035E8},{\\\"name\\\":\\\"MicroSectors U.S. Big Oil Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"NRGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"dcf8d311-0b2a-46c1-b100-3527d83fb8c3\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.628107346E7},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"92252260-dab3-41ff-94fc-07089ccfe0e6\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"0c6c0e86-2673-4315-8a0a-fb443e45bd28\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}]}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"2\\\",\\\"lhs-val\\\":\\\"UUP\\\",\\\"id\\\":\\\"c5690bf9-5d3c-4721-8516-fd74947bd084\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"1\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"a875ea9b-2215-4cc8-a2f9-d7a777bc5d3e\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"f95324ed-00a5-4ca6-946c-d4681c77c48d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"b172054c-309d-4d93-8341-ca8b3791792e\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"97006438-7485-4970-b55c-9985a45dfa34\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fa5236c9-7aa9-47ce-a52b-23bf019a362e\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":22.07,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.674766804940001E9},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1f86e0e6-e389-480b-a461-c0e33baf165b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":12.77,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.3692630201399999E9},{\\\"name\\\":\\\"SPDR Bloomberg 1-3 Month T-Bill ETF\\\",\\\"ticker\\\":\\\"BIL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2dab30d7-74e7-4738-aed1-885643aa3426\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":91.52,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.549733107199999E8},{\\\"name\\\":\\\"iShares MSCI Brazil ETF\\\",\\\"ticker\\\":\\\"EWZ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5f4dd8b4-7733-4cff-8c48-10ba5ede008a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.81,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.07568931002E9},{\\\"name\\\":\\\"ProShares UltraPro S&P500\\\",\\\"ticker\\\":\\\"UPRO\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"537d4f0a-37e4-4b69-bfcb-7c578e423be0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":36.82,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.276874966E8},{\\\"name\\\":\\\"Invesco QQQ Trust\\\",\\\"ticker\\\":\\\"QQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a4c8903b-91a6-4e19-971f-eb4027a337fd\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":285.44,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.547058425344E10},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"20109185-7b28-49a0-a159-6ed5c9a1ed07\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":27.36,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.3561306848E8},{\\\"name\\\":\\\"SPDR S&P 500 ETF Trust\\\",\\\"ticker\\\":\\\"SPY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7b01acdb-00e0-4526-ae34-290cf284112c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":395.12,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.8038800989760002E10},{\\\"name\\\":\\\"Direxion Daily Small Cap Bull 3x Shares\\\",\\\"ticker\\\":\\\"TNA\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"957582b5-7d99-4a37-9a86-d32d3f30a645\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":40.29,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.3864535003E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"6c0bc2e5-43f1-4415-b806-17d4bbbe690e\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"current-price\\\",\\\"rhs-window-days\\\":\\\"3\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"a49c729b-7144-4f80-af80-88365dee43e1\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"SPY\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"dbd0c8d5-7fb1-418e-b66e-cc324580e2fd\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Vanguard Short-Term Bond ETF\\\",\\\"ticker\\\":\\\"BSV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7ff508ad-068a-4a5e-8514-650eba7e82ed\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":74.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.1731665137E8},{\\\"name\\\":\\\"iShares 20+ Year Treasury Bond ETF\\\",\\\"ticker\\\":\\\"TLT\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8beacee6-6eab-4dc3-bb03-2c3fd5fbe047\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":94.3,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.8584839201E9}]}]}]}]}]}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"60\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"c092608d-4b17-4418-800d-a26fd9a9d655\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"-20\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"405625d5-5d65-42f4-8ee6-394efa4197b4\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"35cae5f1-88c0-45ce-bc8e-2059f2f68d70\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"fa775865-20aa-4c4c-9018-f8f10b017206\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"b1775d82-c034-4aeb-9e61-4404f83e3f03\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"0468aa78-870a-402e-ba2b-dce40f2a9f9f\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"57990325-36a4-4df9-8ffc-2b0a8a14e01f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4860112f-2a19-4613-aa7f-2d4357b5dddf\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.591009519999999E7},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9706a146-cfe9-4c8f-8089-a7e1c375a261\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":9.55,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.079433300000001E8},{\\\"name\\\":\\\"iShares 1-3 Year Treasury Bond ETF\\\",\\\"ticker\\\":\\\"SHY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"add0718c-8c63-49ea-965e-de803cd51b2a\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":81.04,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.9762984784000003E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"10\\\",\\\"id\\\":\\\"0061f1be-06df-4edc-9298-06c29a311db3\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"},{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d4e292a1-dc15-417c-a6e6-b547e8ccd32d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":9.55,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.079433300000001E8},{\\\"name\\\":\\\"iShares 1-3 Year Treasury Bond ETF\\\",\\\"ticker\\\":\\\"SHY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"46bdd149-8b08-40f4-8bf6-4ff8c1c61f2d\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":81.04,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.9762984784000003E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"8f0b706e-f94e-40d2-8dc8-ca1fe1dcb6df\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"5\\\",\\\"lhs-window-days\\\":\\\"2\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"3dd93807-fa1d-4858-9a93-02a8828ef4ab\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"TQQQ\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"3736d7d5-5f5b-42bb-b1f7-ffb15774abdf\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"86187188-f939-4560-b06e-9d5bc83a5da6\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"894e5b7b-078e-4a11-b984-7c4e80d8935f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"42bb0c36-6d70-498b-8af7-fc2511b59a45\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"14efc931-0854-47f4-883d-76e27fdc1ae5\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7763d569-10fd-458c-b024-4c0f34a52a0f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":57.12,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.01696442288E9},{\\\"name\\\":\\\"iShares 1-3 Year Treasury Bond ETF\\\",\\\"ticker\\\":\\\"SHY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a28027aa-9f8b-49ac-942c-33ad2b77c19e\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":81.04,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.9762984784000003E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"10\\\",\\\"id\\\":\\\"56112aa5-9eb4-444b-92f9-1dfe9da56e30\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"f6507a22-8a88-44ce-bcca-b1d96966c9d4\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"c34ecee6-795c-4953-b386-ceca070d28d2\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"326f8e5f-4ce3-45e2-81f1-2d6407318aeb\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"ea133755-9602-451e-8a6f-27362e6293dd\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"42f909a0-b15a-42cd-ba21-cd93371ad813\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"748ab752-3439-4211-a926-0be88287d394\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"f03d7176-3d4a-489d-a2fb-cd027e58e58c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Vanguard Short-Term Bond ETF\\\",\\\"ticker\\\":\\\"BSV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"21783c7f-6745-4690-bbdc-64a723416479\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":76.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.9194586264999998E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0f42e75f-607f-4cc1-9447-9f97f9d193b7\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":71.16,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.2186793286399999E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"10\\\",\\\"id\\\":\\\"665dc5a8-6135-465e-8581-bcab58c90fe4\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"UVXY\\\",\\\"id\\\":\\\"fc5e7786-b189-496b-984c-7dae7bd17f99\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"84\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"e086ef39-ae5c-4bf9-bfb5-ba5a3bb55d69\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"41ddb49f-b520-4837-9330-10fa327de758\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":10.28,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.4027583588E8}],\\\"collapsed?\\\":false}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"UVXY\\\",\\\"id\\\":\\\"2f14ffa2-5d9a-492b-936e-f340eb45e170\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"74\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"5d098a62-8e13-475a-938e-76cc62d4b813\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"b139855d-01bd-4791-975c-f50e33dca3ce\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"8d64baca-50b3-4600-9f44-7cd2c393ac45\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"ee3e5918-3271-4385-ad4a-b22044221c46\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"3f2b87ec-88cf-40bc-bf3a-517d5dc68453\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e70cee87-24c5-4e53-821b-177d342932d0\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":54.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.91490645344E9},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"0fe685f7-3624-4861-9490-c64dea4d9cf9\\\",\\\"step\\\":\\\"asset\\\"}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SQQQ\\\",\\\"id\\\":\\\"3b560bb7-4bda-427b-a6c8-1f44a77c4191\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"31\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"42b51e92-60c9-4c71-a6d2-da5e5ea0fe2d\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"c445556f-336f-4a6f-b40f-678ef4eb0432\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"58b55b8d-3b1c-4d18-a5f7-3a96e341443f\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"2ce95129-3eaf-40f3-9c9a-8f7b02aed1da\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"6c8f9303-9f10-4f89-a08a-e5e081cdc871\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"aa27430d-9405-48b3-b05c-1ad995432748\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"55276bfa-3439-47d9-bd50-c8f51b78d646\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"356e4d4d-6f88-45a9-a706-9e9e1a875a79\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"current-price\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"976a8ba5-195b-4763-90eb-0f5feb8e031a\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"TQQQ\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"6a417bd9-2f9a-461a-bc7f-b6ea59426491\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"38be0867-9744-4cf8-ac00-150aed462cb2\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Vanguard Short-Term Bond ETF\\\",\\\"ticker\\\":\\\"BSV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5677f1e3-0f3a-4bd8-808a-54d73f787e20\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":76.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.9194586264999998E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6ccd4e09-ae15-4e16-985d-fb2ae1ee14a0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":71.16,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.2186793286399999E9}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"10\\\",\\\"id\\\":\\\"70695596-5bbc-4dd2-af07-41f731bdba98\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"9\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"80ca24d0-2e0c-4dab-a192-6a673054d02b\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"32\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"a64b1799-6d76-4feb-993f-efdedb602d1e\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"f04f99b6-f842-43f4-a5b6-093353f94517\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"29ca9511-d5a4-4699-9446-1539c007aa24\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"0cfecfd9-e200-4b8b-96a0-a34c70835754\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e5fba854-4091-4c6b-8e51-2c868f178e08\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":57.12,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.01696442288E9},{\\\"name\\\":\\\"iShares 1-3 Year Treasury Bond ETF\\\",\\\"ticker\\\":\\\"SHY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d481e9fe-003a-4ed5-b6aa-f143113b6368\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":81.04,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.9762984784000003E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"10\\\",\\\"id\\\":\\\"d75f246a-31d8-4147-b71b-3ddd8b72788e\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"16587598-b142-452a-a121-dfce32823d4f\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"30\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"b30a2d23-2c43-421b-94bb-524456fee1a1\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"3b409d24-bc49-45d9-879d-b03c861e8f78\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"dfd3ede9-c68f-48d0-b7da-a7902b649e74\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"dd70a5a3-a169-4205-96dc-21c91f4c384f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"9c4a2fa8-0266-4c77-b47f-c8832e182d92\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"a57a3905-236c-4775-a94c-a983d348c8c4\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Vanguard Short-Term Bond ETF\\\",\\\"ticker\\\":\\\"BSV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f7190213-dd40-4f78-abec-6f4907a4ae7e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":76.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.9194586264999998E8},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3bbdb3e3-4344-4d14-9776-113290e91aa0\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":54.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.91490645344E9},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"f9db7cda-329f-466a-8284-714f4adf64f7\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"10\\\",\\\"id\\\":\\\"855843de-7d6e-47b3-85dd-10d23f2f6ab6\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"UVXY\\\",\\\"id\\\":\\\"afbb8da9-b176-4ecf-93eb-455a904847b7\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"84\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"76fa1978-aaa2-4716-a18d-224e6b4d0360\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra VIX Short-Term Futures ETF\\\",\\\"ticker\\\":\\\"UVXY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"111c616c-f8b5-4df4-ab02-dcda4a54a7de\\\",\\\"exchange\\\":\\\"BATS\\\",\\\"price\\\":10.28,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.4027583588E8}],\\\"collapsed?\\\":false}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"UVXY\\\",\\\"id\\\":\\\"9b3b9265-c99f-40d1-bb44-2f200682a94c\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"74\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"fd6f1cca-86cd-4295-97ec-b653343e18b2\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"506aac9b-e9c3-4039-bfdb-1982d2f47d00\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"6abac110-243d-49c5-b560-fb34755b66f1\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"09a2aab8-adc3-40d6-b164-af068db7cf4f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"3bbf7ace-c17a-4d78-9702-b0882f83d248\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0e4e2024-02dd-44b5-abe2-757d51d39274\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":71.16,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.2186793286399999E9},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"6e4db0ba-78c0-4673-aaac-cd100d449c55\\\",\\\"step\\\":\\\"asset\\\"}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SQQQ\\\",\\\"id\\\":\\\"c78efdbf-661e-40d6-b0ba-a861bfbe4de6\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"31\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"15aa3578-ee07-4a76-8c6f-9d0fae6b668d\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"670edba8-17fc-44ff-8af9-561a0f8fc820\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.51440258684E9}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"current-price\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"7521d3bf-5699-4c2c-8eb9-a13e84e051d1\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"TQQQ\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"a52fe632-7699-49ec-b568-9a7341d0fbe4\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"a06f6d4a-fc5c-42fd-ba93-31e3e03e4795\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Vanguard Short-Term Bond ETF\\\",\\\"ticker\\\":\\\"BSV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"42a18f03-e8cc-4739-97c7-77c1383c5929\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":76.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.9194586264999998E8},{\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"ticker\\\":\\\"SQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6386a265-9f9d-4f05-97ff-de73affc1438\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":54.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.91490645344E9},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"76d51fa5-4399-41c1-92c4-8c86b8961ef7\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"10\\\",\\\"id\\\":\\\"2cdd2a51-a476-48c2-bc33-f13678d7a204\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":true},{\\\"id\\\":\\\"2505ff3e-93cb-4942-bd32-cf3d36f4387e\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\" ? SOXX RSI Machine | Deez | 3YR-BT: AR 391.9% DD: 52.0% | 15NOV2022\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"7ad073df-3fff-477c-bd0f-166045c475dd\\\",\\\"children\\\":[{\\\"id\\\":\\\"156bd841-b81a-480a-9037-f7659219969f\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"? SOXX RSI Machine | Deez | 15NOV2022\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"f83bf3e5-e13e-4a1c-9eaf-ff1ea6d9a034\\\",\\\"children\\\":[{\\\"id\\\":\\\"e8744769-c96a-4327-9380-41eda1f1673f\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"d5060c0b-c76b-4c65-bd79-bf1de42d4e34\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ba5ae320-8818-4080-a315-16b31c5424fd\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":36.17,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.27397847405E9}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SOXX\\\",\\\"id\\\":\\\"bb6604d6-6140-4fbd-aed4-22b7b5ab2e4d\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"63\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"f4616e19-c2e7-4d8c-91b0-588232f76775\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"4c624fcf-aa41-4118-88f6-ca39f6d0e990\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"f993b03f-cdc9-4f0e-a00c-0d174212a23c\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"869e8c64-e5e2-4124-9e27-300b2d782308\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"6444dfff-85c0-4ced-bd37-d3cbdc254fdb\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"9795d73c-9289-41b2-a0f2-c098a72b72d8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"a23a919e-2a28-458f-aaea-f934ff1dbe30\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"a007dd40-9811-41cb-b94b-0d1a44bc513e\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"481a9f9a-0c5c-4ba6-b330-62436ab8b1f0\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"57\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"86abfdd8-390c-4809-824d-b5a36a06f3e9\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c6eddc34-a827-4fa0-8b97-a0ffa47a7657\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.07,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.9668164873E8},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"77ff776a-e742-4c14-a513-4d291e9d2979\\\",\\\"step\\\":\\\"asset\\\"}]}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"2\\\",\\\"lhs-val\\\":\\\"SOXX\\\",\\\"id\\\":\\\"184d7b8c-322a-403a-a6f2-bd61b866305e\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"41\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"a1990f90-d3c2-4239-b7a9-a5caf90809e6\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"e083f742-0162-43d5-a479-ac52bf21ebee\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"V2a | ? Gain Train DGAF | Deez | (A: 0.30, B: 0.01, R^2: 0, R: 0.02) BT - 1JAN2015\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"7818256a-ef56-4ba5-bd7c-1a194422bc97\\\",\\\"children\\\":[{\\\"id\\\":\\\"1ce48919-92af-445c-8391-3a447b2ebe38\\\",\\\"step\\\":\\\"wt-cash-specified\\\",\\\"children\\\":[{\\\"id\\\":\\\"d89859f4-2a31-47f8-a01f-a91447dab4ad\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"46f144ae-cc44-48e9-9bc6-b4e7ccda8934\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Invesco DB US Dollar Index Bullish Fund\\\",\\\"ticker\\\":\\\"UUP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8594d4c6-064a-4863-b883-7da396494c43\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.3,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.433175153E8},{\\\"name\\\":\\\"WisdomTree Bloomberg US Dollar Bullish Fund\\\",\\\"ticker\\\":\\\"USDU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6aeff3a3-2971-42c0-a5cf-c297711f8e8f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":29.87,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3584459.74}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"relative-strength-index\\\",\\\"sort-by-window-days\\\":\\\"14\\\",\\\"id\\\":\\\"36ab0738-2010-4aeb-9f2c-b18aa864da6f\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}],\\\"rhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"exponential-moving-average-price\\\",\\\"rhs-window-days\\\":\\\"100\\\",\\\"lhs-window-days\\\":\\\"42\\\",\\\"lhs-val\\\":\\\"UUP\\\",\\\"id\\\":\\\"fb669598-e757-4aaf-b8de-5a5058f4aeb8\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"UUP\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"527e3276-ae4d-47e8-bc41-f21de71218fc\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"60f17304-3e0a-4c53-ac3c-9b0556896cc3\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"SPDR Bloomberg 1-3 Month T-Bill ETF\\\",\\\"ticker\\\":\\\"BIL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6c37619c-a23f-43d5-8055-60661482f012\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":91.47,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.6022023713E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9f42253a-a798-46b4-9a2d-1bc3264f8f7a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":9.21,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.22594427888E9},{\\\"name\\\":\\\"Invesco DB Commodity Index Tracking Fund\\\",\\\"ticker\\\":\\\"DBC\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f06fa06a-c7ea-4468-afdc-7fe97ca42c7d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.99,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.1908959699999996E7}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"2\\\",\\\"sort-by-fn\\\":\\\"standard-deviation-price\\\",\\\"sort-by-window-days\\\":\\\"14\\\",\\\"id\\\":\\\"3b9fcef6-516f-44e7-a3ff-d6c152194501\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}]}]}],\\\"weight\\\":{\\\"num\\\":\\\"45\\\",\\\"den\\\":100},\\\"collapsed-specified-weight?\\\":false},{\\\"id\\\":\\\"898b7900-4e07-40ab-b9a6-866e273b0061\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"c94899eb-7e4b-4496-843a-1f72d5cedc0e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"715e1def-1f13-4a0a-afa5-5f5ce85998cf\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"7e17e972-ff74-4daa-b068-3961a9f1beed\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Overbought S&P. Sell the rip. Buy volatility.\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"5b4abca5-d272-4bee-a175-f7b04513a5a0\\\",\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra Gold\\\",\\\"ticker\\\":\\\"UGL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fe568e1c-83be-4ddd-bfce-59eceb6d7910\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":52.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5255643.75}],\\\"window-days\\\":\\\"7\\\"}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"2a4d4b83-50ff-494f-86c9-6b62ead21179\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"76\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"4e3e57a1-6d15-46a1-a58c-3e8dc9e7d4bf\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"bcaa1140-b527-4de3-9d11-54a85da57d8b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"dd481e3e-3ff7-4619-957f-36344b984192\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":8.99,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.5392827503700001E9},{\\\"name\\\":\\\"VanEck Semiconductor ETF\\\",\\\"ticker\\\":\\\"SMH\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cb4eefdb-052c-4f85-9b95-ae19096700ea\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":191.4,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":809087037}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"max-drawdown\\\",\\\"sort-by-window-days\\\":\\\"6\\\",\\\"id\\\":\\\"afb7a71e-991b-4b56-889e-db55955cf568\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\"}],\\\"window-days\\\":\\\"7\\\"}]}]}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"10\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"BIL\\\",\\\"id\\\":\\\"03eb3ed6-4755-4bfb-82a0-037c60b7899e\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"IEF\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"6f4bf581-7ad0-46ce-8f8c-cee3f57a9ec3\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"9b9029c3-b2da-4123-91f1-2eac68098d7b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"1d9557ad-b5cc-449f-96c5-4880a1b09b27\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"cae7e425-42c4-4cbd-9fdd-fe55f8866c40\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Extremely oversold S&P (low RSI). Double check with bond mkt before going long\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"df0884f3-62b5-4e33-abdf-33cea20ed71d\\\",\\\"children\\\":[{\\\"id\\\":\\\"7d0af2bc-2cfd-4a59-b118-048f23cacbc8\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cf409037-cfa7-4003-ac08-bfde1eacfd92\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":53.72,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.713534416E8},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"fed8989a-eca2-4416-b33f-343b516fcc5a\\\",\\\"step\\\":\\\"asset\\\"}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"10\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SHY\\\",\\\"id\\\":\\\"baefbb9d-2094-4288-9d06-9eb01156f74b\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"VTI\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"1f61aa19-f6c0-4710-8daf-f46fe75e9636\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"efcabfc3-b4a4-40c2-afcf-cf7007afed33\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"40584f54-c8f4-48c3-b45b-743940864907\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"83c64e09-ca7a-48e0-b413-d5194280d62d\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"99212d86-a638-4370-bfec-7d690b91b667\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"04875c50-73af-463a-880c-0957763ef8f2\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"46ef487d-2f17-48df-a44e-eeb6d0d0b589\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"3\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"d861ed9e-89aa-4406-9f04-4ca4d4d82f7c\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}]}]}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"7\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"fe6413dd-98f6-4536-8783-62ac339aba8a\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"27\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"751a291a-0291-47a4-8502-81a9120a0a14\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares Ultra Gold\\\",\\\"ticker\\\":\\\"UGL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"132504ad-a25d-4792-b011-d600d2c3f084\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":52.23,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5255643.75},{\\\"name\\\":\\\"ProShares Short S&P500\\\",\\\"ticker\\\":\\\"SH\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fc9026d0-a595-4e41-9833-eff4839be9f9\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":15.59,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.5631463859E8},{\\\"name\\\":\\\"ProShares Short QQQ\\\",\\\"ticker\\\":\\\"PSQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2c1a5561-89f8-40ae-994b-f064d98fc36b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":13.83,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.4216982776E8}]}]}]}]}],\\\"weight\\\":{\\\"num\\\":45,\\\"den\\\":100},\\\"collapsed-specified-weight?\\\":false},{\\\"weight\\\":{\\\"num\\\":10,\\\"den\\\":100},\\\"id\\\":\\\"66e6ff75-74e3-4f50-8e31-12b9df337790\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"? Operation: Meat Shield | [Low Touch] | 3Y BT ~ AR: 31.7%, DD: 21.7%\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-specified\\\",\\\"id\\\":\\\"0d060f79-3235-4c2f-9aec-9f7ad9beaa1a\\\",\\\"children\\\":[{\\\"id\\\":\\\"239208de-091a-4529-8500-c074e9cc6441\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"6b7f3c16-8c3e-4cd8-8c97-505cef957b31\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"b1ca8c9f-dd8e-40af-b743-812a73f3cef1\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"SPDR Bloomberg 1-3 Month T-Bill ETF\\\",\\\"ticker\\\":\\\"BIL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d19ea386-10fe-4176-bd8a-2dacd9f262d6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":91.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3700748828E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"max-drawdown\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"4f70976e-c359-43b0-aa35-a597bc71cc5c\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"12\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"837d36ce-2ee3-443b-a055-f033e7dbb5e5\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"060e2923-3d8f-492d-8387-4eb32d94fae5\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"6a9cdef7-2502-45f4-b5c0-e451e29f65d9\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"2fccfb9d-ac24-4ed9-8fad-e39cec9b2365\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"b85ec4a0-eb27-497b-a67d-e7c9e82e565d\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"23adc9b1-f5da-4a7d-944a-1e119944a74f\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"b1f60bbe-b564-419c-901d-83899c26f5ac\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"90f38d05-78f3-4b4f-b379-f14d7f4bfefc\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}]}]}]}],\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"15\\\",\\\"lhs-window-days\\\":\\\"14\\\",\\\"lhs-val\\\":\\\"COST\\\",\\\"id\\\":\\\"9959b07b-61bf-4f99-8c65-697069006c6a\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"69\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"2462e929-f2d3-41f5-ad42-1be1de952cdf\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"SPDR Bloomberg 1-3 Month T-Bill ETF\\\",\\\"ticker\\\":\\\"BIL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ee0effce-efbd-4c8d-8424-5b28c236a565\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":91.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3700748828E8}]}],\\\"weight\\\":{\\\"num\\\":\\\"20\\\",\\\"den\\\":100}},{\\\"id\\\":\\\"14ad4179-fb22-4f78-8de0-83b282df7941\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"33c4398c-ec33-4577-a427-c6456ffbae99\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"3ff719a5-77a8-45a6-a05e-c8abd436c9a3\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"name\\\":\\\"SPDR Bloomberg 1-3 Month T-Bill ETF\\\",\\\"ticker\\\":\\\"BIL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4fd24e04-b588-453c-aa54-d1799efa2a8c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":91.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3700748828E8}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"max-drawdown\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"df866012-781c-44c9-8f34-05eae41972b8\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"12\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"6cdfca4b-e6bb-49a4-859d-9cff6eee9418\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"4fda952e-82f4-44de-a603-c8823711bc9b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"1471fed3-983e-4d28-9d5f-b337f5f2b787\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"51972f1a-36ae-411a-aa47-b25f416f1834\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"cac54314-0ee7-4e3a-b371-80cffa94e65f\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"16ff3484-fc0c-448c-b2b5-f51a1b936ce8\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TECL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"id\\\":\\\"24c6a7ec-e482-4405-820f-0fa9fc2cf330\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"id\\\":\\\"2afd9af4-e58f-410b-aa66-0222606c25ec\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":30}}]}]}]}]}],\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"15\\\",\\\"lhs-window-days\\\":\\\"14\\\",\\\"lhs-val\\\":\\\"UNH\\\",\\\"id\\\":\\\"06ffa532-b79e-4770-a310-8351dc9e7cb4\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"79\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"b9d32704-6c67-44e2-a0be-cb4bb2cf1d2b\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"SPDR Bloomberg 1-3 Month T-Bill ETF\\\",\\\"ticker\\\":\\\"BIL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f48499f0-e791-486b-aa87-cc0984899d64\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":91.58,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.3700748828E8}]}],\\\"weight\\\":{\\\"num\\\":\\\"80\\\",\\\"den\\\":100}}]}],\\\"weight-method\\\":\\\"percentage\\\",\\\"collapsed?\\\":false}],\\\"window-days\\\":\\\"35\\\",\\\"weight\\\":{\\\"num\\\":\\\"27.5\\\",\\\"den\\\":100}}],\\\"collapsed?\\\":false}],\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"collapsed?\\\":false}]}]}]}]}],\\\"weight\\\":{\\\"num\\\":\\\"50\\\",\\\"den\\\":100}}]}]}]}],\\\"collapsed?\\\":true}]}]}],\\\"collapsed?\\\":true}],\\\"lhs-fn-params\\\":{\\\"window\\\":20},\\\"rhs-fn\\\":\\\"moving-average-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"moving-average-return\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"b1e664a5-29c7-491b-abb8-eeeaaba8257b\\\",\\\"rhs-fn-params\\\":{\\\"window\\\":20},\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"TMF\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"7cda0846-792b-41fd-bc36-d671af80c3a2\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"1b75ae34-fd3a-4f5d-9c9c-f264e5a64523\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"WAM + Colonel Sanders ETF Only\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"4f1e5a68-71b5-4926-9533-de8b947fb3c3\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"d4cf8b08-7ece-43fb-9311-574b7f93305a\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"16528f6c-c4b6-44d9-9583-8e1ac7639c30\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Colonel Sanders 21 Spices ?\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-specified\\\",\\\"id\\\":\\\"f710694c-c694-49e7-89f5-a3c77d800fe3\\\",\\\"children\\\":[{\\\"id\\\":\\\"622c7a96-8141-4e2f-9c4f-2135e63336d4\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"V1.4 [RSI 4d TLH UPRO] | ? Colonel Sanders 21 Spices | slowloss1 performance replica | HTX\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"bfcc442b-804a-49d0-af10-c9db59cde12d\\\",\\\"children\\\":[{\\\"id\\\":\\\"a9b23480-b598-4d03-a66f-c84cf7ea50b0\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"c1771ba2-f2d7-42c6-b81a-0f779c4a8005\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"b124c73b-f0a5-470b-be31-c70913909f2b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"7d94c7b2-fccc-41b9-bc99-bcebcec26cd4\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"step\\\":\\\"filter\\\",\\\"id\\\":\\\"30aef737-9ba2-4903-9c83-54447e3babc5\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":20},\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"children\\\":[{\\\"ticker\\\":\\\"SQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"id\\\":\\\"53600c98-9a09-4120-bc31-eed73c1b3c6f\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"3bbec195-1e5d-40d5-84e4-8edd852157c9\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"HIBS\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 High Beta Bear 3X Shares\\\",\\\"id\\\":\\\"05d8aeac-f1bd-4928-be42-e0c10992f2ec\\\",\\\"step\\\":\\\"asset\\\"}]}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"15\\\",\\\"lhs-window-days\\\":\\\"15\\\",\\\"lhs-val\\\":\\\"BND\\\",\\\"id\\\":\\\"cacba44c-2c49-4988-adae-4dc00886142b\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"TQQQ\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"4800337d-59d4-4774-b2ed-58447e2d1b78\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"e17e8078-4242-4050-9862-72b840f90d98\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"step\\\":\\\"filter\\\",\\\"id\\\":\\\"e938bdae-aea8-4e50-a4da-6c751cef128c\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":20},\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"0a3c4c2c-7a61-4c32-b81e-3882a76664f4\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"af9d2158-209b-4256-870d-ea7ce8bf91da\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"38919e8c-82f8-4ff2-b449-e967bb48e45c\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"c337c009-bd0c-4c94-9851-efaff1360a46\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"HIBL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 High Beta Bull 3X Shares\\\",\\\"id\\\":\\\"8cd78061-0ec1-4eb9-a332-cc278caf2151\\\",\\\"step\\\":\\\"asset\\\"}]}]}]}]}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"4\\\",\\\"lhs-window-days\\\":\\\"4\\\",\\\"lhs-val\\\":\\\"TLH\\\",\\\"id\\\":\\\"73ba3f61-16d6-44d5-96b2-a981728e1d37\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"UPRO\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"c961668c-1bf9-4895-b953-67be643fb202\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"9fc1dcbe-48f9-4caf-b7b9-777a19c461fc\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"0d8d4d73-1835-424d-9f97-20427f8b4eaf\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"c66db73d-c3e0-4c57-b380-7dc1bc926b4c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"ticker\\\":\\\"SQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"id\\\":\\\"2cf1f0b3-b5ff-4b09-93eb-244eb81f21fb\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"b94fb2ac-d468-4568-a081-8a0058856dbf\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"HIBS\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 High Beta Bear 3X Shares\\\",\\\"id\\\":\\\"bbda4ccc-81f7-41b1-9675-cfb8e8d75ade\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"id\\\":\\\"2ec10073-ac14-4de5-8e07-face1daf6623\\\",\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":20}}]}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"9\\\",\\\"lhs-window-days\\\":\\\"3\\\",\\\"lhs-val\\\":\\\"SPHB\\\",\\\"id\\\":\\\"9960f217-df41-480c-945c-10372d5e7379\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPHB\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"f2744ac3-ff76-458d-a5ee-32acc43bdbd9\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"c3122d95-6634-41c0-a42d-2acbff58c919\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"step\\\":\\\"filter\\\",\\\"id\\\":\\\"6415ad40-6b22-4615-8515-f7a2ffc189c4\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":20},\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"6ea8c7ba-e9cb-4568-949e-ac344005174a\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"03f91c8f-bc30-452a-80dc-c4d763aa6995\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"069b4870-a7d1-4708-a4d6-1a67ac70b180\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"HIBL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 High Beta Bull 3X Shares\\\",\\\"id\\\":\\\"18c7c79b-33c9-4123-97b6-d29365484447\\\",\\\"step\\\":\\\"asset\\\"}]}]}]}]}]}]}]}]}],\\\"weight\\\":{\\\"num\\\":\\\"15\\\",\\\"den\\\":100},\\\"collapsed?\\\":true},{\\\"id\\\":\\\"3f6d7cbd-740c-4a1c-9ae3-7317612c0abd\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"V1.4 [CR 6d TLT 5d QQQ] | ? Colonel Sanders 21 Spices | slowloss1 performance replica | HTX\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"c9a62457-ec53-4f0b-94df-6f7ef60aa8d5\\\",\\\"children\\\":[{\\\"id\\\":\\\"ba4dbaa8-4f91-42f5-b72c-bfc87aa0000b\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"a6191874-ea56-461a-92bb-62811840c2b6\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"85fe8f41-3a51-44ec-8cbe-b016205ccbae\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"c5190766-58b5-4e61-bc25-98c707bf6007\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"step\\\":\\\"filter\\\",\\\"id\\\":\\\"ac74a7a3-1fca-41fc-9c6a-3b05e597338b\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":20},\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"children\\\":[{\\\"ticker\\\":\\\"SQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"id\\\":\\\"a707a083-3fa4-4106-a29e-f27c21419e37\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"69810205-a6e8-40aa-a983-4ab74fdb65b5\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"HIBS\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 High Beta Bear 3X Shares\\\",\\\"id\\\":\\\"7ab391f5-63ba-4bcc-98f1-f8174532ae99\\\",\\\"step\\\":\\\"asset\\\"}]}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"15\\\",\\\"lhs-window-days\\\":\\\"15\\\",\\\"lhs-val\\\":\\\"BND\\\",\\\"id\\\":\\\"1bf6f14e-1e0e-4d88-a68f-9f84f3b92cd9\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"TQQQ\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"d0a53435-5142-4821-8041-a06ef262bb84\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"c03f0ead-9ac9-4a51-9d6a-904b0f011a16\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"step\\\":\\\"filter\\\",\\\"id\\\":\\\"39104eae-62f5-49a0-a21f-91548a559fae\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":20},\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"cae92e93-33a8-420e-b224-fc78db287615\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"27a7f27a-e987-4148-a28c-8e59aeee8fc4\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"4f8a212c-c0ec-4d19-a7fc-2e35e749703a\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"cdedfe7c-3647-4aca-973f-0c5b6b12bd80\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"HIBL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 High Beta Bull 3X Shares\\\",\\\"id\\\":\\\"c26e70b4-7220-45fe-9950-5bff7ebaf6bb\\\",\\\"step\\\":\\\"asset\\\"}]}]}]}]}]}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"5\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"TLT\\\",\\\"id\\\":\\\"73bf6cf4-c3d9-4ef8-9df2-a26dce8460a5\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"QQQ\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"8a21a95c-20c4-4cb1-8daf-07d9a4f8a910\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"c8067556-0107-49a7-8154-3299d60667a8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"52aac053-037d-4804-985c-fe6c995d0379\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"389b7c6a-fd8e-41c0-932d-ca23af3ea8ec\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"step\\\":\\\"filter\\\",\\\"id\\\":\\\"ab56b595-e3a6-4ae5-ab05-5f339dda2643\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":20},\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"children\\\":[{\\\"ticker\\\":\\\"SQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"id\\\":\\\"3ad98cdf-3ce8-499f-b7a5-7afd7d65daa0\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"ed11a149-81eb-4073-a146-a44e6989258b\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"HIBS\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 High Beta Bear 3X Shares\\\",\\\"id\\\":\\\"d52bbf25-9a38-4d3f-a9ec-e3cba2b7d9b4\\\",\\\"step\\\":\\\"asset\\\"}]}]}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"9\\\",\\\"lhs-window-days\\\":\\\"3\\\",\\\"lhs-val\\\":\\\"SPHB\\\",\\\"id\\\":\\\"0deb6f4b-b8d4-4849-a7fb-4114376f1ebc\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPHB\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"96c8c09f-6e67-41d7-8beb-d5c5ead46c92\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"3f84f558-4ef7-4525-af5d-673f21bb3772\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"step\\\":\\\"filter\\\",\\\"id\\\":\\\"37108003-7048-4ac5-a183-2744ba46f76b\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":20},\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"children\\\":[{\\\"ticker\\\":\\\"HIBL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 High Beta Bull 3X Shares\\\",\\\"id\\\":\\\"6d8babca-d982-477e-9934-a883aaa1c5e2\\\",\\\"step\\\":\\\"asset\\\"}]}]}]}]}]}]}]}]}],\\\"weight\\\":{\\\"num\\\":\\\"20\\\",\\\"den\\\":100},\\\"collapsed?\\\":true},{\\\"id\\\":\\\"07563027-8d01-4c53-ba68-9528142e62a0\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"V1.4 [CR 6d TLH FNGS] | ? Colonel Sanders 21 Spices | slowloss1 performance replica | HTX\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"d9e8d3f6-5051-4ea1-8528-5dab6d743f6f\\\",\\\"children\\\":[{\\\"id\\\":\\\"4c9109cf-97b8-4026-b088-ea7d602239f5\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"a38f1865-2b1a-43bc-8c47-dc01a93cdeb5\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"ef291ccc-2da9-4e14-9cc5-a18be2af2272\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"ab4125e6-cfde-4242-a4b0-d085f31636fc\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"step\\\":\\\"filter\\\",\\\"id\\\":\\\"bf26ad97-54c6-4a76-886d-9c9b93dd2f74\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":20},\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"children\\\":[{\\\"ticker\\\":\\\"SQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"id\\\":\\\"e8925f04-f9ee-4f51-9000-a472ee085c02\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"04ea2ae9-99c3-4359-b9d0-6f64aa9d5959\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"HIBS\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 High Beta Bear 3X Shares\\\",\\\"id\\\":\\\"937c55b4-aa0c-4d8c-8f06-6658c18f3d7a\\\",\\\"step\\\":\\\"asset\\\"}]}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"15\\\",\\\"lhs-window-days\\\":\\\"15\\\",\\\"lhs-val\\\":\\\"BND\\\",\\\"id\\\":\\\"ebaf7a80-1af2-42be-80d4-ef8c72412b68\\\",\\\"comparator\\\":\\\"lt\\\",\\\"rhs-val\\\":\\\"TQQQ\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"97b2f467-ad47-4077-a725-d32007decde4\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"afe3ed3a-2df5-4924-bdcb-571f2c925cf3\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"step\\\":\\\"filter\\\",\\\"id\\\":\\\"34754633-ef20-49eb-ba95-f5d206f1c1cd\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":20},\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"children\\\":[{\\\"ticker\\\":\\\"TQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"id\\\":\\\"d40c559c-4a4d-4b98-964a-545087e0cc56\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SPXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"id\\\":\\\"d7b7a05a-f776-43e1-9bd7-9ff14fe2fae6\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"93cf1054-c556-4948-8038-8fec725abfff\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"71278aba-da72-427b-806b-f9075ea5d726\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"HIBL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 High Beta Bull 3X Shares\\\",\\\"id\\\":\\\"8b1d8cb0-2b5d-442b-bc42-deb819f0796e\\\",\\\"step\\\":\\\"asset\\\"}]}]}]}]}]}],\\\"rhs-fn\\\":\\\"cumulative-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"6\\\",\\\"lhs-window-days\\\":\\\"6\\\",\\\"lhs-val\\\":\\\"TLH\\\",\\\"id\\\":\\\"afbcb809-06c7-42d6-986a-11df09a07d53\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"FNGS\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"92b3553c-f763-4bc5-a03e-2b479e5e3553\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"f726a14d-7e92-4e18-873a-5cfa4aeab612\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"f0d3b89a-f206-4f20-b01d-d4d51fc9768d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"4a783c4b-444b-4175-a49c-ee752f1b2551\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"step\\\":\\\"filter\\\",\\\"id\\\":\\\"4ba61fb5-3434-48f8-a481-443bc873155d\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":20},\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"children\\\":[{\\\"ticker\\\":\\\"SQQQ\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"name\\\":\\\"ProShares UltraPro Short QQQ\\\",\\\"id\\\":\\\"d33f8904-af90-4a8b-8823-8478e462c8fc\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"FNGD\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"id\\\":\\\"4bb21654-ed84-4ede-aef0-d42778897128\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"HIBS\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily S&P 500 High Beta Bear 3X Shares\\\",\\\"id\\\":\\\"ad2cb705-2264-4bc9-831c-8be7d0aa5de5\\\",\\\"step\\\":\\\"asset\\\"}]}]}],\\\"rhs-fn\\\":\\\"standard-deviation-return\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"rhs-window-days\\\":\\\"9\\\",\\\"lhs-window-days\\\":\\\"3\\\",\\\"lhs-val\\\":\\\"SPHB\\\",\\\"id\\\":\\\"f44f8446-907c-481e-87a8-8e9a1a24076e\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"SPHB\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"af3d698a-d755-419e-9af0-94cf1565c3ea\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily S&P 500 High Beta Bull 3X Shares\\\",\\\"ticker\\\":\\\"HIBL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7a0178f4-851c-4d3c-90a9-f997cfedbb62\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":29.36,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6549570.08}]}]}]}]}]}]}],\\\"weight\\\":{\\\"num\\\":25,\\\"den\\\":100},\\\"collapsed?\\\":true},{\\\"id\\\":\\\"82c6dfcf-7383-4701-adbf-a16673c805b1\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Growth Blend Retired\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"613da028-b119-46d6-b1d3-cfc459b0149d\\\",\\\"children\\\":[{\\\"id\\\":\\\"e547ba2e-6f2c-42ea-b7f0-95adf8a6ffb7\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"b10fa049-19f6-4bd9-b6ce-a1f449f2fb52\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"35e8eba3-c798-445e-90a4-c36acb6835b8\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"6185fd71-eaa6-4ccb-abb1-900564c26b7e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"1e8ee5b7-2715-4187-b17b-197d631b6a64\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"027a0877-783a-441b-b4ac-25db75f4b955\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"27caf94e-28e1-4e24-b3f7-919ad09c38d9\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":24.83,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.0765387964599996E9},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"dfbe98bb-748b-4699-a3c1-071cbfe49105\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":65.77,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":9.3459913201E8},{\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"44996488-10dc-4876-a384-47e6f34529a2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":84.55,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6062834365E8},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"970df469-f9a2-4115-aab9-1d494decd0b0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":81518067}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"15\\\",\\\"id\\\":\\\"36a80588-2fd3-4c79-8465-cec940a13ec5\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"lhs-window-days\\\":\\\"100\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"c8c2bcee-7882-49e1-8ee4-36b275cbacf1\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"2\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"99da976c-1425-4c79-af91-3d0b8188937e\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"fd21157a-2c64-46a0-9c33-2fe870e56470\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"51c268b6-ad7f-4564-96cf-d1ad93533ef1\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"c9fa1e2d-42cc-41c0-800d-94b217fe778b\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"db05e683-e168-414c-a646-765796884594\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"73c6d384-4792-461a-94f2-d69d509166d5\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"1f2affa3-195b-4de4-a8bb-226b9c5e7f06\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"084dd198-c330-41b3-9dc3-76e80b1bcde7\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"31ed22cf-47bc-48b4-b275-e0f44615f912\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.61,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.0387303514499999E9},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bull 2X Shares\\\",\\\"ticker\\\":\\\"GUSH\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"250873f3-1ab8-4851-96d8-f92307498bad\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":109.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.048193838E7},{\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"06c5866a-9356-4d2c-b4bd-cca4bc1518ec\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":84.55,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6062834365E8},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7884e1e3-f026-4f39-8a48-92a248f78580\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":81518067}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"14\\\",\\\"id\\\":\\\"7fb39313-fc72-41c7-8644-036e438f3307\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"b23853b4-320d-424c-a44b-2c8062d49b34\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"-4\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"961f7d4b-f022-4221-99c1-aaf95ab0ee9c\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"151fcdaa-00fa-4ca3-aaeb-2d6eab9d919a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7d4710de-07b7-4545-9cfb-a27b502c4e61\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":18.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.387308232900001E8},{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f55e8edc-82b7-43ff-8ac2-ba2c80aa7bd9\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"93a42f05-8ef5-4161-abb0-b391881733f2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.8321689440000005E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d9079c46-be38-4467-87f8-d6033d574f53\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8},{\\\"name\\\":\\\"Direxion Daily Financial Bull 3x Shares\\\",\\\"ticker\\\":\\\"FAS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"411c0488-b5c0-47bc-ba39-01e9d23439b5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":57.18,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.4661110738E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"standard-deviation-return\\\",\\\"sort-by-window-days\\\":\\\"8\\\",\\\"id\\\":\\\"09453690-8392-48df-a87f-4273df02d3f9\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"lhs-window-days\\\":\\\"30\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"beff7c5a-d07e-43ec-a2db-eda8269700c0\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"7\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"68e0a4ec-a631-4066-9c59-c3a10607e0ab\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"5e7164f5-c6ef-4379-92bc-b59d26f74343\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"8faec579-f78e-46d0-aacd-2edc31b264b7\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"e8f45e98-3951-407c-8bfd-ea2e6f6f9b2d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"2622c8db-9e16-42e9-96a1-4bc0c660bf0a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":18.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.387308232900001E8},{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"33ec408e-5301-4fab-809d-39ff7e2ddbff\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3a59d419-06cb-412f-ab7b-aa3aead652af\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.8321689440000005E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d23e68e6-0778-4479-bf23-90fdf22fbe04\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8},{\\\"name\\\":\\\"Direxion Daily Financial Bull 3x Shares\\\",\\\"ticker\\\":\\\"FAS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"dcfcfff1-fe97-4f1c-8d58-95cd7ffe5eb4\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":57.18,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.4661110738E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"standard-deviation-return\\\",\\\"sort-by-window-days\\\":\\\"8\\\",\\\"id\\\":\\\"62764aaf-f271-4b83-a0d2-dc8f2b83404e\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"77f8428b-1eca-45e1-b4f2-f45c7a145b2e\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"1\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"48da6019-984a-4460-8ade-5ec59ee7369d\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"22ff62f0-9c0c-4972-a570-65489ac6ba6d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"05a82f48-c16c-417a-99bc-a515387a4fcd\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.61,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.0387303514499999E9},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bull 2X Shares\\\",\\\"ticker\\\":\\\"GUSH\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5233d195-e207-4376-97bb-34f49d6845d2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":109.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.048193838E7},{\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b8a57a47-92d0-4b85-bd44-41eff50b4d12\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":84.55,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6062834365E8},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"45147cfc-c107-40e2-af55-400fcd77adf5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":81518067}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"14\\\",\\\"id\\\":\\\"3f4bd7b0-11a1-4e18-97b5-8edaead9d0c2\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}]}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"30\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"91fae075-344b-46a5-9717-e41f2cbdbcb5\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"50\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"c6f62b14-e373-435e-af65-84cdd084c448\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"4899122c-5a0b-4398-9350-bf8c15139fd0\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"47c36a98-2eb0-4248-88e5-856413b42f6c\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"fa226877-caa2-464f-83f2-fccc48031ad9\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4699b6a3-fb89-4822-b537-0a7cbefe5ef9\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.61,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.0387303514499999E9},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8e92be51-c656-4aec-835e-3ad479a06ffa\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":24.83,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.0765387964599996E9},{\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e8d84e8e-14f2-4c67-b559-57c48321b614\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":84.55,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6062834365E8},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a7840b11-2357-4e95-b6a9-cc23657b7892\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":81518067}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"standard-deviation-return\\\",\\\"sort-by-window-days\\\":\\\"9\\\",\\\"id\\\":\\\"c9bcdf05-ca10-467c-9c57-43825b7edd57\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"8\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"0f2a3d73-7629-4448-948f-c7926a01121e\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"-20\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"ec287142-9871-4537-9ae7-92b282a6d202\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"595fb621-518c-414b-a006-2e1ce322b5ae\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"81a9b77c-0b56-460c-8052-dcff8706ef08\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"2d490ac9-765d-42bb-99ff-b22aad3bd8b6\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"bca7509a-2451-46d9-8619-772e3c7fb632\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":18.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.387308232900001E8},{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9528774a-ba1d-4eaa-b0fc-6f4a29ab25ab\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b21d12c4-e8db-478c-ad18-8a9f734169b0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.8321689440000005E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3f068bd4-fb6d-4828-ae5d-403930aca0a5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"10\\\",\\\"id\\\":\\\"46ec1a43-6334-463a-911f-b7a09c3089eb\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"max-drawdown\\\",\\\"lhs-window-days\\\":\\\"200\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"9ee24ffd-a118-42df-86fe-095da393b66a\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"68\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"60641b3f-6912-4c81-b901-6a78063ecf1b\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"6d57aa97-97ab-4e2b-9eac-5206e0d4a175\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"29ef880d-b0aa-4b1c-ac52-bc2385a2c62c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.61,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.0387303514499999E9},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bull 2X Shares\\\",\\\"ticker\\\":\\\"GUSH\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3fe6e874-ba14-48e8-9eb1-9296bfb35005\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":109.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.048193838E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d93e9c74-d587-4f78-a135-de78d8258303\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":24.83,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.0765387964599996E9},{\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"46355827-ce8d-4e96-97ab-b9ec36dfeb63\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":84.55,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6062834365E8},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5488ef75-03a1-4077-9d67-21e822a99ee6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":81518067}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"standard-deviation-return\\\",\\\"sort-by-window-days\\\":\\\"5\\\",\\\"id\\\":\\\"bb4a4245-5b90-40ba-b405-881200d3bb2c\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"60\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"f1c8fab5-8a6a-4036-9ba2-31c76eef9edc\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"55\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"914ba97e-b694-4ed2-96ed-93b357976e62\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"0877b98b-7c25-4e85-95f9-d6693e278a6e\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"d5d0cffc-f8f2-4b84-a4f8-b5ea6efba3b0\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"106d78ab-a648-449f-9fa8-a4c6b36da8af\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"7636bf44-31ef-4b87-9d61-f3bbd49fa228\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"b649e16b-f603-4a92-8372-d0727eca56dd\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"ee152ed7-4f51-4c15-a01a-866072e1cbca\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"74f478dd-b7bf-4926-8192-832570d96ed8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"2dad1166-a700-44c2-9e2e-1c0ee1ba4ff8\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"447a034b-bfdb-409f-a22a-0f49e42fe7b8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c9dd1e76-9431-4c71-81ed-78d657eed17b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":15.66,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.03201183674E9},{\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ea0c3a93-da21-48f3-be35-c1d9b26edb89\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":96.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.3288044675E8},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c4d95743-bb55-4496-8583-919e70351522\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.925578874E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"aded987f-f2a7-417b-aa5b-d47ea55ff3ae\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":27.43,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.31794108386E9},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7cd013a0-49e9-4ae5-9fa9-c3b7798ab791\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":72.86,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6979424254E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"62\\\",\\\"id\\\":\\\"aba5c3e8-7fb7-4b22-9fea-7eebc4e3bf2f\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"lhs-window-days\\\":\\\"30\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"076ba03a-85ef-4f92-b011-01625b356e72\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"8\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"f51a3a7f-caa5-48b5-af43-92cce1a5202c\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"eb468cf9-e2c7-4483-bdfe-e57b9efa1306\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cdab8a96-9f08-4f1f-9cee-4b13e687a855\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"0dd21b47-e5d2-4360-aaaf-b6c4ba15399a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"60\\\",\\\"id\\\":\\\"18cc76fa-3c07-4b60-8b7d-8740446ebaa0\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"lhs-window-days\\\":\\\"15\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"e1432573-6199-4d37-9ab9-cbdcb27374a8\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"8\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"cd63c73f-ab25-4d18-9bb3-8cf0477379f0\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"a7ad6df8-2379-4b4f-815c-c61857d30da8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"06d62ddf-67c9-4fba-a53c-e379749bcce4\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a2389726-db22-4d5a-a5bd-592452b07f4b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6ce52225-847a-4965-b9cd-d535e65e0a6b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":18.94,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.081884946400001E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"60\\\",\\\"id\\\":\\\"e038244b-716b-403a-9439-b027e367a61d\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"447c2d0a-a664-4a57-b8bd-437721fecb8b\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"-1\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"33967e03-1640-4778-93e7-d4eaca9377e1\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"caf9bde9-34e0-453e-bab1-b7de483d5a21\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"df5d9e69-113c-4fa4-9a69-d2d76fd58fd0\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"7f143968-0d6a-4297-b499-0d597fc85b59\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"e2acb113-d30d-40a2-8a2a-083ac651f6b1\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"8eae1caf-f9a9-4018-a831-eaddcfd9e031\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"2d6bb881-469a-4367-812b-e20df8ac1ae5\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"bef5c5e6-fed3-4e9a-a829-9605419f577a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b70bd66f-7419-4384-8592-8a3fcc4bbe75\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":15.66,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.03201183674E9},{\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c7911d3c-9367-4cc5-9eb4-26ac0d8aba00\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":96.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.3288044675E8},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"766f8d13-06ed-4ea7-8c1b-427211ef5aef\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.925578874E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b31a35ca-a0ad-4cfc-8734-4482c6625ad2\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":27.43,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.31794108386E9},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"08ddf73c-1801-4294-803c-b5a68e6d4557\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":72.86,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6979424254E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"62\\\",\\\"id\\\":\\\"a81ff07d-f345-4155-9d46-1f9965b1dc40\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"lhs-window-days\\\":\\\"30\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"07e9e407-a10f-4787-94f9-aa05ea716b3a\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"8\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"fa562f0a-6445-4161-85b8-804852e5186f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"d3c6b50b-9f88-4607-804b-9fe93792d8e7\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4fc8c3cb-8c72-41f1-819f-d38926ef576e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c5397405-d51c-48eb-9cd8-4ac542539557\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"60\\\",\\\"id\\\":\\\"e8a38e9f-5b64-46e5-845f-56ab1f9a2dad\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"lhs-window-days\\\":\\\"15\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"bec6939e-6b46-4d25-bb87-317530690621\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"8\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"4a1da83b-e666-43ee-ad8d-f34c76bbff3b\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"29ce3c8b-a900-433f-9794-8737b430423c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4c9bc997-2d33-44a7-86ce-a14aa6e4e012\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":18.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.387308232900001E8},{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a2b1c040-2727-4791-88b5-c4e66fbbd121\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6091fc65-f308-419f-9b71-34157df98fe8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.8321689440000005E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3e35cc4d-486b-48ba-a7a3-41a57ebc3c6c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8},{\\\"name\\\":\\\"Direxion Daily Financial Bull 3x Shares\\\",\\\"ticker\\\":\\\"FAS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"26cb9211-a552-4415-93eb-74c71f80fa79\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":57.18,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.4661110738E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"standard-deviation-return\\\",\\\"sort-by-window-days\\\":\\\"8\\\",\\\"id\\\":\\\"c1697168-408f-42b6-b72f-05aeabf6c498\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"5\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"b80abab8-fbb9-467a-a62c-8e47093f4699\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"-1\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"6dbabd16-5051-4d01-81a0-029e72d98d0f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"0df3f852-b5c7-4434-b2ff-2ff10c254904\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c6327c10-7560-412b-8bfa-c94cfb53ed3d\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":18.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.387308232900001E8},{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c803452e-d55c-4f70-8f99-7b4b66b8b396\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4f9c7332-5b82-4461-91ae-c993982cf5f4\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.8321689440000005E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"1c1124d7-7921-456b-91d6-d04ec8b13c38\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8},{\\\"name\\\":\\\"Direxion Daily Financial Bull 3x Shares\\\",\\\"ticker\\\":\\\"FAS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"96eba11f-f3a6-4dc2-94f5-4e3008306ebe\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":57.18,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.4661110738E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"standard-deviation-return\\\",\\\"sort-by-window-days\\\":\\\"8\\\",\\\"id\\\":\\\"eabab01f-c45e-4758-bd19-256f52df08cc\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}]}]}]}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"30\\\",\\\"lhs-window-days\\\":\\\"30\\\",\\\"lhs-val\\\":\\\"TQQQ\\\",\\\"id\\\":\\\"9a5b22a0-beb9-4b60-bca0-cb52576660b3\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"50\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"a82d3e1d-d0f3-4d9d-903e-19c534b85dd8\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"f1549313-01a1-462f-92b5-8f3631e1c16d\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"8bcf3e22-0608-4819-acde-2987e1207cce\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"e4a7d1f2-ad39-42d8-934a-8cf4896277f7\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4a5472cc-a380-4834-b1fd-23792162bde5\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":18.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.387308232900001E8},{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4c64eada-172e-4148-a7b0-47ea42d103ae\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"cf63707b-a65a-4085-9cd5-88400f741c59\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.8321689440000005E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"71bae710-2438-443c-8ad3-aaaabfd661d8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8},{\\\"name\\\":\\\"Direxion Daily Financial Bull 3x Shares\\\",\\\"ticker\\\":\\\"FAS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"40b638dd-6359-49e5-b214-9fefdd50491b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":57.18,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.4661110738E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"standard-deviation-return\\\",\\\"sort-by-window-days\\\":\\\"8\\\",\\\"id\\\":\\\"88f3c426-d555-4086-b61b-39a899b9535c\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"ca30864d-5b7e-47f7-9e71-89ecc94ab0d3\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"2\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"de440e4e-2ecb-44fe-b75f-ed06f68018c9\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"fe73da3f-c6c6-43c5-8e94-d84b1551352f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"c1984fa9-b24b-4da3-a2f7-d5524a8f97d1\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"30b2f20c-bc58-4ac4-a7f4-806c6c5db86c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"1c1155dd-b342-4c41-aeec-a249622c5636\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"bc2f5815-8978-48aa-a8ef-fd71cdc2fc8c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4ce4d616-d215-4352-a512-38295a70ebe2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":15.66,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.03201183674E9},{\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"97bc7979-825a-45ee-a33c-55f9307729ea\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":96.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.3288044675E8},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"30aff0e9-de78-4ec4-a98e-c6ed97f59e0b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.925578874E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"02fa0051-d428-4949-95c4-0640709797cc\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":27.43,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.31794108386E9},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"be60e717-6e6f-4158-94e4-25cc1afd7a9a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":72.86,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6979424254E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"62\\\",\\\"id\\\":\\\"4aabb3a2-1247-44f2-94b7-d526b2cfe072\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"lhs-window-days\\\":\\\"30\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"0a4b8546-a82c-45b9-82ae-a2f7a65e9201\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"8\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"d7c6ca94-144c-4688-8fee-3f467cbb4930\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"c206d270-5e27-4062-98a5-a2be23ba0477\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"5fd887de-bdaa-402a-b275-176fc7f7d659\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":18.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.387308232900001E8},{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a1799cc6-240b-4fed-9fb1-47a0d7f40dd4\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"72eea1ae-17f9-48cc-83af-32b8a78cfa45\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.8321689440000005E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e576e7be-b42f-48a9-84b1-46be0b373862\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8},{\\\"name\\\":\\\"Direxion Daily Financial Bull 3x Shares\\\",\\\"ticker\\\":\\\"FAS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e18bba41-787e-4ef9-b070-a825da9378b7\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":57.18,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.4661110738E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"standard-deviation-return\\\",\\\"sort-by-window-days\\\":\\\"30\\\",\\\"id\\\":\\\"1f3eae4b-4821-4da5-ad22-da3d2ec9cfd9\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"lhs-window-days\\\":\\\"15\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"58eb2f8d-ac0c-4c20-91e3-c97de39ae144\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"8\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"fd1836cf-3c54-479a-b909-7ea5f265d23e\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"0f20d8a2-31f6-4782-aaf9-5877c794bbcf\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a98966cd-098c-4ac2-822a-6e09be51b1b0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":18.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.387308232900001E8},{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7806108d-a4da-47d3-9ab5-a2aeb3f34fff\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"25ed6222-73dc-4c4c-adef-b1216244f692\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.8321689440000005E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"37bd3b09-51d8-4c00-ab29-95a25a753947\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8},{\\\"name\\\":\\\"Direxion Daily Financial Bull 3x Shares\\\",\\\"ticker\\\":\\\"FAS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"a1e8b650-566b-4f57-81a3-dd683ca86cc8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":57.18,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.4661110738E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"standard-deviation-return\\\",\\\"sort-by-window-days\\\":\\\"30\\\",\\\"id\\\":\\\"20295401-5a82-47e8-968f-905d91744d7e\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}]}]}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"max-drawdown\\\",\\\"lhs-window-days\\\":\\\"59\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"f8be8b5f-6e94-489c-8392-c044c36232be\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"50\\\",\\\"step\\\":\\\"if-child\\\",\\\"collapsed?\\\":false},{\\\"id\\\":\\\"bb6cfcb3-8c1e-493f-9f2d-8aa91be0944f\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"4c048e0a-259f-4433-83a3-e7a8f562b9d4\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"b988818b-b0f0-4894-acc3-19d57f4f8779\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"0f42a5c2-f42c-4641-9e27-f1a2dfa80b39\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"ff61bd17-ad5c-493c-b922-557f53141af4\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"442fea14-3180-43b1-97ee-2eb34b2bfc06\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"a184a007-d857-4332-8cce-32bd34478ab0\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"e0d3cdec-b729-4a7d-8864-17814e8bef93\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8e8fe9af-a531-4412-8925-3fd559ae797e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.61,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.0387303514499999E9},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bull 2X Shares\\\",\\\"ticker\\\":\\\"GUSH\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d99e4eff-896f-48c0-811b-40fe55fdda03\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":109.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.048193838E7},{\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"077611c8-6e75-4867-be11-1de21df531ef\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":84.55,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6062834365E8},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"8ea8db97-a3e4-4b4c-8477-d573eac15a4b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":81518067}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"14\\\",\\\"id\\\":\\\"a2b2a23f-4af9-4bd1-b9c9-25fb38cfaeb0\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"QQQ\\\",\\\"id\\\":\\\"30cb6077-ef88-44db-97ff-65faf6e80b11\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"2\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"a791f399-5a76-4ef2-bef5-71be7eb34d0e\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"1c4068da-b180-42e4-b289-e83ed458a97c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"564cb12a-2589-4e5d-a769-647d3c454045\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":18.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.387308232900001E8},{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6e8a1a24-10c4-447d-89d7-57e8e465504e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"462d8008-8a3a-49b0-87c9-179b7ca54040\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.8321689440000005E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e0f0da74-9653-429c-84ec-6ac0203f69ad\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8},{\\\"name\\\":\\\"Direxion Daily Financial Bull 3x Shares\\\",\\\"ticker\\\":\\\"FAS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"28ccebdb-7b6d-4c80-aeec-8e1e931bef91\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":57.18,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.4661110738E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"standard-deviation-return\\\",\\\"sort-by-window-days\\\":\\\"8\\\",\\\"id\\\":\\\"2b71442c-4f5a-4446-a673-0ed6309152b9\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}],\\\"collapsed?\\\":false}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"lhs-window-days\\\":\\\"105\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"1db3da1f-936b-4db6-a690-8a8c9fe86da3\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"4.9226\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"71ccb2dd-ce1a-484d-babd-c8b8a520c588\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"511096fc-af71-4ecc-adb9-3a7a1633f5f4\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"3a8ac6e0-bd83-4d85-8744-a25337e61cd4\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"a2a89e70-ee0e-490a-b898-6e101631023f\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"0947e9c4-9c61-44e4-9467-9852b70c03ba\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"c7bcfb86-ce12-4ab1-ad1d-3043f3c1c6a2\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3d7bb424-4028-41a5-96ef-c6ffe553df7f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":18.53,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.387308232900001E8},{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6ac19e4d-c628-4704-9641-57ea74d680be\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily Technology Bear 3X Shares\\\",\\\"ticker\\\":\\\"TECS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3d0e5d74-132a-4f8e-a1b7-46eaa5c0efdf\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.37,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.8321689440000005E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d51542da-ffd9-45d2-a68b-0e5c01788a26\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"standard-deviation-return\\\",\\\"sort-by-window-days\\\":\\\"15\\\",\\\"id\\\":\\\"d61693b6-d557-4a43-ab3f-3787d5bc107d\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"lhs-window-days\\\":\\\"30\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"f40608b2-04a4-461a-8454-64d7150ebfb2\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"5.4135\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"c558b17d-0fae-4022-a290-6260b9b35478\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"518e665d-b2cc-4629-93f8-d2b344ce6de9\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b1e6920d-f3e8-42e2-8504-d22e9d5e2107\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.61,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.0387303514499999E9},{\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"15e22c6e-58dc-4010-a007-bf89ef8a8892\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":84.55,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6062834365E8},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6f043f72-8c13-43aa-986e-9b90f3568a8e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":81518067}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"14\\\",\\\"id\\\":\\\"21670fc7-e86d-4289-94af-f0df882867dd\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"30\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"d11ca90c-11da-432d-8c29-ec585328353d\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"57.49\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"f28dfd88-5cb4-4730-9dee-650200ffbc00\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"bda778a6-ece8-4104-b8a2-3be5023d4411\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"66d16f5e-eedd-4b8a-932e-f7cb8b88ae85\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"e75d04f7-9900-47aa-ae78-2f6e61a93e3a\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7adf56a0-6683-4f03-bac5-619d63ec4767\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.61,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.0387303514499999E9},{\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b0961c75-c80a-4e33-8edf-ea407329b17a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":84.55,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6062834365E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"14\\\",\\\"id\\\":\\\"ef9bd32d-e523-4b5c-a6c8-580eb0ed7b9f\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"cumulative-return\\\",\\\"lhs-window-days\\\":\\\"32\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"357d9d2f-42c2-46bd-a70a-46ee7a31cf2f\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"-10\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"eb5f39ae-1bc2-4b47-8e93-7cedd3bf9ab1\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"8f7cb423-912d-41cf-a5c9-4f3a866c69d0\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"c7701c7c-5c26-4ea4-ab6e-726a1121e0a6\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"bed91751-6c74-42b2-835c-f5409858d6c6\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"32cd8b13-6a14-4087-8d26-3fdab24bdda8\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"531db838-ef8a-4790-88cc-0b6918e065c4\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"11\\\",\\\"id\\\":\\\"94ba6d2a-22a4-4912-89da-3ec6e1b86588\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"max-drawdown\\\",\\\"lhs-window-days\\\":\\\"250\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"76ea771e-a8b9-4551-993e-fa2b4ce3d710\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"72\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"02ce3d1d-aa51-4dc4-b647-96bb22376ebf\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"9a6f4a8f-a90f-4467-986e-5c86b405faf2\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"945f232f-f00d-447d-b36e-f9359bbbafb9\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"2e4e287b-13bd-4e80-930f-5a791b64c273\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"42e41538-912e-41ba-8045-ea683088279d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"c75560d9-111d-41df-9bd6-9a42352894d7\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d4b5368a-c737-4e4e-b653-05d229437f51\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":15.66,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.03201183674E9},{\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"d4a109c1-824d-4e23-b400-72597ea17fc3\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":96.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.3288044675E8},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"86852637-a360-42e9-96d7-afde86490603\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":35.67,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.925578874E7},{\\\"name\\\":\\\"ProShares UltraPro QQQ\\\",\\\"ticker\\\":\\\"TQQQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"05849015-8f9c-4fa0-8992-ce7d504beca9\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":27.43,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":3.31794108386E9},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bull 3x Shares\\\",\\\"ticker\\\":\\\"SPXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"147a4125-d1d3-489a-9a82-ec7d89852b47\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":72.86,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.6979424254E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"60\\\",\\\"id\\\":\\\"4aebcd21-b437-4de5-8380-23531577b9d2\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"lhs-window-days\\\":\\\"30\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"d0b98463-953d-43ad-a899-6d8f36976dea\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"8\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"f709e186-571e-4fd7-ba98-df1b48e78f49\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"33130f2d-15ce-4271-ab37-ddab36a7fb59\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"4e3f09a7-c299-4fa5-80e0-edf9bca2428a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"66725f6b-ec5f-4a05-8130-ff9f9d937ba2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"60\\\",\\\"id\\\":\\\"8f1a352c-f969-413c-8a07-e3664acf1d4d\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"standard-deviation-return\\\",\\\"lhs-window-days\\\":\\\"15\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"3a04ef1b-75ae-46b4-8e4c-51e481f751ef\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"8\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"3eb0223b-0737-4ffa-a72f-17e357b2eb3a\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"500191d4-4ac8-4d9e-964e-39767acffd92\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"b824bfbf-0555-4962-b67c-3875c098d604\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fb0b962c-0c1a-4ac7-a4cb-dbfa666bdd30\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"806a495a-fd4d-456f-8ef0-cf16e5c376de\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":18.94,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":7.081884946400001E8}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"60\\\",\\\"id\\\":\\\"1f99020d-b7b8-4ba2-95b3-726dd486aac7\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}]}]}]}]}]}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"lhs-window-days\\\":\\\"32\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"b4fcb6ec-1efe-46dd-9c5a-72116aca1d03\\\",\\\"comparator\\\":\\\"lte\\\",\\\"rhs-val\\\":\\\"62.1995\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"8f72b465-1f70-4cdc-ad6b-7e227e4de2b8\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"713a7efa-9c72-4112-a20e-deb6541ad249\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"id\\\":\\\"f642b333-3e75-4b34-9d76-8a491dd154b7\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"3541bcea-1cc3-497a-88ce-3b1c932e00bc\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e3219343-bf6b-4355-ad24-582a2b00cb79\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":23.26,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.098375682E7},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bear 2X Shares\\\",\\\"ticker\\\":\\\"DRIP\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e4899807-80f8-43de-81b9-eca6393cdcc0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":17.08,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.019199468E8},{\\\"name\\\":\\\"Direxion Daily S&P 500 Bear 3x Shares\\\",\\\"ticker\\\":\\\"SPXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"3219d784-449f-4238-a3dd-74d769246f11\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":15.85,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.8862984725E8},{\\\"name\\\":\\\"Direxion Daily Semiconductor Bear 3x Shares\\\",\\\"ticker\\\":\\\"SOXS\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"ed7696fe-cd27-4235-afd8-09287947bcd0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":12.3,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":5.1523130520000005E8}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"20\\\",\\\"id\\\":\\\"f7a17b70-323b-42ea-8781-4361b9aee673\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":true,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"30\\\",\\\"lhs-window-days\\\":\\\"32\\\",\\\"lhs-val\\\":\\\"SOXL\\\",\\\"id\\\":\\\"69bd9195-c989-40cd-bce5-d6727bfb0555\\\",\\\"comparator\\\":\\\"gte\\\",\\\"rhs-val\\\":\\\"50\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"24118ed3-e494-47bf-aa87-6d3a28f24264\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"4f2be7ab-ed60-4c59-a0ca-bd7307166d07\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"ticker\\\":\\\"SOXL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"546232a0-5809-4f4a-81f1-57ae130d131b\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":16.61,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.0387303514499999E9},{\\\"name\\\":\\\"Direxion Daily S&P Oil & Gas Exp. & Prod. Bull 2X Shares\\\",\\\"ticker\\\":\\\"GUSH\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"85be558d-9ce6-48f1-81fa-fc22e45d242e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":109.49,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.048193838E7},{\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"ticker\\\":\\\"FNGU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"e6703334-d5fc-4458-af77-0fa7fff313f0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":84.55,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.6062834365E8},{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"7db97136-24ee-4545-80c8-b127183e422f\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":32.25,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":81518067}],\\\"select-fn\\\":\\\"top\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"cumulative-return\\\",\\\"sort-by-window-days\\\":\\\"14\\\",\\\"id\\\":\\\"458fd7f7-70a2-4e5d-bbbc-3108bf21b45a\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}]}]}]}]}],\\\"collapsed?\\\":false}]}]}],\\\"collapsed?\\\":false}],\\\"weight\\\":{\\\"num\\\":\\\"60\\\",\\\"den\\\":100},\\\"collapsed-specified-weight?\\\":false}],\\\"collapsed?\\\":true}],\\\"weight\\\":{\\\"num\\\":\\\"40\\\",\\\"den\\\":100},\\\"collapsed?\\\":true}]}],\\\"collapsed?\\\":false}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"20\\\",\\\"lhs-window-days\\\":\\\"20\\\",\\\"lhs-val\\\":\\\"SPY\\\",\\\"id\\\":\\\"adb62188-86bf-4e7d-a3f9-8112f4e85815\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"TFLO\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"ea819013-78fc-4ec6-809f-b756d88002a1\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"b69bea5a-2dbc-4878-ad9a-9ab18d23fb33\\\",\\\"step\\\":\\\"group\\\",\\\"name\\\":\\\"Wooden ARKK Machine 2.2b no IEF no TYO [RSI 10d SCHZ URTY]\\\",\\\"children\\\":[{\\\"step\\\":\\\"wt-cash-equal\\\",\\\"id\\\":\\\"49e4d627-f1c8-4247-9e28-ed5e71f0d2ff\\\",\\\"children\\\":[{\\\"id\\\":\\\"fb4be133-ecfd-4cbf-acfc-0406ecf4755d\\\",\\\"step\\\":\\\"if\\\",\\\"children\\\":[{\\\"children\\\":[{\\\"id\\\":\\\"dfef251a-1802-4a25-be92-dbed4887f04c\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"Direxion Daily Technology Bull 3x Shares\\\",\\\"ticker\\\":\\\"TECL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"c2dfa096-3d15-40ac-bfc9-eab310676d13\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":29.03,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.0271821341000001E8},{\\\"name\\\":\\\"ProShares UltraPro Russell2000\\\",\\\"ticker\\\":\\\"URTY\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"70ab7fc2-1b80-4474-9662-6c033e529a5a\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":42.22,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6.5018166699999996E7},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bull 3X Shares\\\",\\\"ticker\\\":\\\"TMF\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"433d47f8-82df-4f18-8b61-7bb2a4298806\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":7.97,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.7254215541E8},{\\\"name\\\":\\\"Direxion Daily FTSE China Bull 3X Shares\\\",\\\"ticker\\\":\\\"YINN\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f0ee4eef-ddbb-4493-8b88-f7a4e779eae6\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":43.72,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":8.339856692E7},{\\\"name\\\":\\\"Direxion Daily MSCI Emerging Markets Bull 3x Shares\\\",\\\"ticker\\\":\\\"EDC\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9b9f029c-1f77-4a36-a3fc-1c9a4ea1177c\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":30.71,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1462502.33},{\\\"name\\\":\\\"iShares Semiconductor ETF\\\",\\\"ticker\\\":\\\"SOXX\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"f53a7743-5375-429a-a339-0d68a179142b\\\",\\\"exchange\\\":\\\"XNAS\\\",\\\"price\\\":421.79,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.529558988E8},{\\\"name\\\":\\\"Direxion Daily S&P Biotech Bull 3X Shares\\\",\\\"ticker\\\":\\\"LABU\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"abb6ecd2-c17d-4af2-9459-ed0969f39fd7\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":7.12,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.1811656488E8},{\\\"name\\\":\\\"Direxion Daily S&P 500 High Beta Bull 3X Shares\\\",\\\"ticker\\\":\\\"HIBL\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"12314000-1916-42c8-ac2b-b417bdffd26e\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":25.69,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":6388049.71},{\\\"ticker\\\":\\\"FNGU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"MicroSectors FANG+ Index 3X Leveraged ETN\\\",\\\"id\\\":\\\"64482709-291a-42ed-8e92-3e8c7938df6c\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"SOXL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Semiconductor Bull 3x Shares\\\",\\\"id\\\":\\\"9fed7b00-c44e-4cd5-a27b-af28110a3228\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"TNA\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Small Cap Bull 3x Shares\\\",\\\"id\\\":\\\"eef3012f-9deb-45f1-abe7-4bd9cc8740a1\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"MIDU\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Mid Cap Bull 3x Shares\\\",\\\"id\\\":\\\"f6fe66a7-10de-41a7-bdbc-25cd5cd0cb19\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"EURL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily FTSE Europe Bull 3X Shares\\\",\\\"id\\\":\\\"a819d88b-4831-4ad1-a6c2-b74a2c0d37d6\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"NAIL\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Homebuilders & Supplies Bull 3X Shares\\\",\\\"id\\\":\\\"025b756a-4d26-483e-a500-9226e02d7e8e\\\",\\\"step\\\":\\\"asset\\\"},{\\\"ticker\\\":\\\"DFEN\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily Aerospace & Defense Bull 3X Shares\\\",\\\"id\\\":\\\"c674a247-c80b-46cc-a866-84a3b2b365bd\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"sort-by-window-days\\\":\\\"4\\\",\\\"weight\\\":{\\\"num\\\":100,\\\"den\\\":100},\\\"id\\\":\\\"d01f30d7-1eac-4c82-bac1-26598eadf93c\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"collapsed?\\\":false}],\\\"window-days\\\":\\\"15\\\"}],\\\"rhs-fn\\\":\\\"relative-strength-index\\\",\\\"is-else-condition?\\\":false,\\\"rhs-fixed-value?\\\":false,\\\"lhs-fn\\\":\\\"relative-strength-index\\\",\\\"rhs-window-days\\\":\\\"10\\\",\\\"lhs-window-days\\\":\\\"10\\\",\\\"lhs-val\\\":\\\"SCHZ\\\",\\\"id\\\":\\\"f2185998-12c7-40dd-ba9a-c6e39e87a11a\\\",\\\"comparator\\\":\\\"gt\\\",\\\"rhs-val\\\":\\\"URTY\\\",\\\"step\\\":\\\"if-child\\\"},{\\\"id\\\":\\\"0b38c5a3-54e1-41e7-be90-0fd5fcdf6bc3\\\",\\\"step\\\":\\\"if-child\\\",\\\"is-else-condition?\\\":true,\\\"children\\\":[{\\\"id\\\":\\\"7f1d8051-3e15-4bb0-9ed9-aafd9fe618c8\\\",\\\"step\\\":\\\"wt-cash-equal\\\",\\\"children\\\":[{\\\"select?\\\":true,\\\"children\\\":[{\\\"name\\\":\\\"ProShares Short QQQ\\\",\\\"ticker\\\":\\\"PSQ\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"91ad3292-ae40-424b-ad67-f72d48be8ec1\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":13.47,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":1.7947912920000002E8},{\\\"name\\\":\\\"Direxion Daily 20+ Year Treasury Bear 3x Shares\\\",\\\"ticker\\\":\\\"TMV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6dca1992-b4b6-42fd-9fec-105e7ae9baab\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":123.43,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.4744999540000003E7},{\\\"name\\\":\\\"Direxion Daily Real Estate Bear 3X Shares\\\",\\\"ticker\\\":\\\"DRV\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"6fbec9c8-a748-4094-8b59-8f4d8a732283\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":47.98,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.853831208E7},{\\\"name\\\":\\\"Direxion Daily Junior Gold Miners Index Bear 2X Shares\\\",\\\"ticker\\\":\\\"JDST\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"93ab935f-d389-4fc6-925b-80604b1ae589\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":5.63,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":2.546430421E7},{\\\"name\\\":\\\"Direxion Daily S&P Biotech Bear 3X Shares\\\",\\\"ticker\\\":\\\"LABD\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"9a69b3d8-66b7-49e0-ba33-31731e0a08d0\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":13,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":75627942},{\\\"name\\\":\\\"ProShares Short S&P500\\\",\\\"ticker\\\":\\\"SH\\\",\\\"has_marketcap\\\":false,\\\"id\\\":\\\"fedece1e-58a0-4a76-9300-6ad5956a1dd2\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"price\\\":14.52,\\\"step\\\":\\\"asset\\\",\\\"dollar_volume\\\":4.137740442E8},{\\\"ticker\\\":\\\"TYO\\\",\\\"exchange\\\":\\\"ARCX\\\",\\\"name\\\":\\\"Direxion Daily 7-10 Year Treasury Bear 3x Shares\\\",\\\"id\\\":\\\"1a8f905c-3cfd-4ce9-ac77-99fe3023a1ed\\\",\\\"step\\\":\\\"asset\\\"}],\\\"select-fn\\\":\\\"bottom\\\",\\\"select-n\\\":\\\"1\\\",\\\"sort-by-fn\\\":\\\"moving-average-return\\\",\\\"id\\\":\\\"9facdfdb-9824-40d4-b606-d129b797ac04\\\",\\\"sort-by?\\\":true,\\\"step\\\":\\\"filter\\\",\\\"sort-by-fn-params\\\":{\\\"window\\\":4}}],\\\"window-days\\\":\\\"15\\\"}]}],\\\"weight\\\":{\\\"num\\\":\\\"90\\\",\\\"den\\\":100}}]}],\\\"collapsed?\\\":true}]}]}]}],\\\"collapsed?\\\":true,\\\"weight\\\":{\\\"num\\\":\\\"80\\\",\\\"den\\\":100}}]}]}],\\\"collapsed?\\\":false}],\\\"color\\\":\\\"#829DFF\\\",\\\"name\\\":\\\"Growth Blend v2.2 RL\\\",\\\"rebalance\\\":\\\"daily\\\",\\\"sparkgraph_url\\\":\\\"https://storage.googleapis.com/composer-prod-cache/sparkgraphs/GRiEaKmkWhvq75MqGQZj.png?X-Goog-Algorithm=GOOG4-RSA-SHA256&X-Goog-Credential=backtest-server%40leverheads-278521.iam.gserviceaccount.com%2F20230609%2Fauto%2Fstorage%2Fgoog4_request&X-Goog-Date=20230609T042504Z&X-Goog-Expires=604800&X-Goog-SignedHeaders=host&X-Goog-Signature=781d12358dd98168a0867e09573a11f226e7e35b9234265a89d4aff43759c1064c6378cb12049f3c228fe04cb2f8afd201982713c6e1b7ed6946a547e0ee2f575722c1bbc32ccbfb3250ae09f594e25dff608774c52bdad7e03c559002c0da4ef5617e859d3262d1a5c3733858cbe372d14c12eddbcc6e11f4a2c44e3846bbaba23acb1a49d1d0ea49a3b181847cb5f845c16d210fa7ceb41eab0e6092d77b720e740559651702d57fa9cd29d8e3bc813658922674b598f13b38c9a2c191d059f37aa638c88cd499eca12b3e945ef97804bc110ae6e103d20e6e69b622ffb170a9984179850b675a95f79a047f5c770d4416de3a7a2958745e19c8a6b62db323\\\",\\\"id\\\":\\\"o29Qg1pv9naYVT5CIaRF\\\",\\\"step\\\":\\\"root\\\",\\\"collapsed?\\\":false}},\\\"symphony_metadata\\\":{\\\"asset_classes\\\":[\\\"EQUITIES\\\"],\\\"color\\\":\\\"#E3BC99\\\",\\\"sparkgraph_url\\\":\\\"https://storage.googleapis.com/composer-prod-cache/sparkgraphs/o29Qg1pv9naYVT5CIaRF.png?X-Goog-Algorithm=GOOG4-RSA-SHA256&X-Goog-Credential=backtest-server%40leverheads-278521.iam.gserviceaccount.com%2F20251104%2Fauto%2Fstorage%2Fgoog4_request&X-Goog-Date=20251104T052053Z&X-Goog-Expires=604800&X-Goog-SignedHeaders=host&X-Goog-Signature=3bf44607faec16996e49813f1b3a8c69239d043142d04b336640b1cf306db850f6b4c5c1bf436272944ee15ff8b3e59b73aad52cb8e4350faf04e708b6947e7efe53864e52180af6405b8707933d07e80141f35fde0db19f3e3680131742ea291646de2654e639e4da9a2451e81817c1dfb5ff3fcf996459369de64bd79e7a238ad2a265edc322f99099cddefad28c34da60a732c397ca2feca19abb20f5748bc8808568f94052cb1ca781d942291ea895937aa0fe7418f7d2a2fe619b37b87f630ff087f456a7362b12c1ecd035dd3a208387632466f3c8ac2cfda05c2f75f1ed9abbb954d46d17c3b8f2a4aac1cbeeb2d12509f520f07549ea81d8f242bfd6\\\"}}\",\"user-content\":{\"card_type\":\"symphony_presentation\",\"content\":{\"backtest_parameters\":{\"benchmark_tickers\":[\"EQUITIES::SPY//USD\",\"EQUITIES::QQQ//USD\",\"EQUITIES::TQQQ//USD\"],\"apply_subscription\":\"none\",\"capital\":10000,\"sparkgraph_color\":\"#E3BC99\",\"end_date\":\"2025-11-03\",\"broker\":\"ALPACA_WHITE_LABEL\",\"start_date\":\"2025-05-20\",\"slippage_percent\":1.0E-4,\"backtest_version\":\"v1\",\"apply_reg_fee\":true,\"apply_taf_fee\":true},\"backtest_response\":{\"data_warnings\":{},\"stats\":{\"skewness\":0.192523816784483,\"min\":-0.11020645335940404,\"top_five_percent_day_contribution\":0.7006265169182517,\"annualized_rate_of_return\":3.855624833310025,\"mean\":0.006868987690372397,\"herfindahl_index\":0.616950786882194,\"benchmarks\":{\"SPY\":{\"skewness\":-0.5945802516144346,\"min\":-0.027027832409559527,\"top_five_percent_day_contribution\":0.6010744780343567,\"annualized_rate_of_return\":0.3785767699495075,\"mean\":0.0013084125629610228,\"herfindahl_index\":1.0,\"top_ten_percent_day_contribution\":0.9998639422406214,\"top_one_day_contribution\":0.13922416095929252,\"calmar_ratio\":12.684111977138521,\"sortino_ratio\":4.750465091290724,\"win_rate\":0.5739130434782609,\"sharpe_ratio\":3.0854055217000056,\"tail_ratio\":1.2390895922887528,\"trailing_two_week_return\":0.017935349322210747,\"size\":115,\"cumulative_return\":0.15926441149526685,\"trailing_one_month_return\":0.02111444837943255,\"max_drawdown\":0.02984653325608,\"median\":0.0018766677418409206,\"max\":0.020788468218131406,\"standard_deviation\":0.10686438575001567,\"percent\":{\"alpha\":1.431393262541945,\"beta\":0.9086244887987593,\"r_square\":0.035090027172886847,\"pearson_r\":0.187323322554579},\"kurtosis\":2.703461473181055,\"log\":{\"alpha\":1.301059946295116,\"beta\":0.9041968430305519,\"r_square\":0.03532956289763303,\"pearson_r\":0.18796159952935343},\"trailing_one_week_return\":-0.0027727511528806703,\"trailing_three_month_return\":0.08566616885386558},\"QQQ\":{\"skewness\":-0.6580964281336055,\"min\":-0.03471426232192576,\"top_five_percent_day_contribution\":0.5620049230155036,\"annualized_rate_of_return\":0.5339930573938847,\"mean\":0.0017494416821785615,\"herfindahl_index\":1.0,\"top_ten_percent_day_contribution\":0.9345469341942809,\"top_one_day_contribution\":0.11813317675617799,\"calmar_ratio\":14.881709891199442,\"sortino_ratio\":5.058992356726268,\"win_rate\":0.6173913043478261,\"sharpe_ratio\":3.2943371382455613,\"tail_ratio\":1.200026955246937,\"trailing_two_week_return\":0.033587336887202834,\"size\":115,\"cumulative_return\":0.21769284118055018,\"trailing_one_month_return\":0.04793010262446762,\"max_drawdown\":0.035882506869030606,\"median\":0.002409852042172478,\"max\":0.02354006337709369,\"standard_deviation\":0.13382337186769608,\"percent\":{\"alpha\":1.352473956662842,\"beta\":0.8585753730381417,\"r_square\":0.049132587131625376,\"pearson_r\":0.22165871769823395},\"kurtosis\":2.56182541434515,\"log\":{\"alpha\":1.2260519170801754,\"beta\":0.8522488803818635,\"r_square\":0.049256733217186266,\"pearson_r\":0.22193857983051588},\"trailing_one_week_return\":0.006352592781289301,\"trailing_three_month_return\":0.12182308675280407},\"TQQQ\":{\"skewness\":-0.6757516489067605,\"min\":-0.10493314891655148,\"top_five_percent_day_contribution\":0.6244427670981875,\"annualized_rate_of_return\":2.0683441998396415,\"mean\":0.0048159733009711745,\"herfindahl_index\":1.0,\"top_ten_percent_day_contribution\":1.0385719327404401,\"top_one_day_contribution\":0.13041862361099574,\"calmar_ratio\":19.068697415625746,\"sortino_ratio\":4.588752155416851,\"win_rate\":0.6173913043478261,\"sharpe_ratio\":3.0290367577447093,\"tail_ratio\":1.1743387389428854,\"trailing_two_week_return\":0.09667253684308075,\"size\":115,\"cumulative_return\":0.6754460492778248,\"trailing_one_month_return\":0.13008595988538674,\"max_drawdown\":0.10846803820720063,\"median\":0.006609686609686527,\"max\":0.0696231269865295,\"standard_deviation\":0.4006637650539273,\"percent\":{\"alpha\":1.3807829520263675,\"beta\":0.2885585477428,\"r_square\":0.04974814192505628,\"pearson_r\":0.22304291498511286},\"kurtosis\":2.626247263866528,\"log\":{\"alpha\":1.2773518751936996,\"beta\":0.2798919958114465,\"r_square\":0.04799410835993486,\"pearson_r\":0.21907557682209777},\"trailing_one_week_return\":0.016232929657304718,\"trailing_three_month_return\":0.3542405860135056}},\"top_ten_percent_day_contribution\":1.1224325989782782,\"top_one_day_contribution\":0.1423967709015197,\"calmar_ratio\":24.2886900608678,\"sortino_ratio\":5.853297106134513,\"win_rate\":0.591304347826087,\"sharpe_ratio\":3.339394286727032,\"tail_ratio\":1.7392397008080502,\"trailing_two_week_return\":0.07759819138533763,\"size\":115,\"cumulative_return\":1.06962,\"annualized_turnover\":124.94288047325732,\"trailing_one_month_return\":0.6243575938140642,\"max_drawdown\":0.15874157163880698,\"median\":0.002019649191430606,\"max\":0.10912834213931322,\"standard_deviation\":0.5183529554607931,\"kurtosis\":2.372566670435905,\"trailing_one_week_return\":0.009359997034765533,\"trailing_three_month_return\":0.6154014268096599},\"costs\":{\"reg_fee\":21.09,\"taf_fee\":6.88,\"slippage\":149.57,\"spread_markup\":0.0,\"subscription\":0.0}},\"symphony\":{\"symphony_sid\":\"o29Qg1pv9naYVT5CIaRF\",\"symphony_score\":{\"description\":\"OOS Jan 8 2024\",\"children\":[{\"id\":\"5bdb855c-0cc5-4b78-8a37-675454e810c6\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"653e0d71-d2f1-4209-8b30-00fa51b471cb\",\"step\":\"if\",\"children\":[{\"children\":[{\"weight\":{\"num\":\"70\",\"den\":100},\"id\":\"80800a19-d0ab-4499-a892-bc507ad15ee2\",\"step\":\"group\",\"name\":\"Blend Growth Amoeba\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"7d84659e-822b-4c04-9bda-7338543cc254\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"f0903332-6277-4731-aa59-f5fca8908332\",\"children\":[{\"id\":\"49429233-ff9d-481e-a79b-d609e16b59fb\",\"step\":\"group\",\"name\":\"TQQQ FTLT w/Sideways Market Mods\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"b3a84771-6a3b-41da-94e4-2cb240c47a33\",\"children\":[{\"id\":\"e90ccd7a-62ec-481f-b6c2-9c07e222b379\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"d525ca7c-b549-4973-8002-3a35e1eeee2f\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"bb916311-514d-4e57-a953-8e6915d50ddc\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"e215eeac-5b57-46b2-b79c-50e687d9592d\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"4c9dd2a9-c753-4320-bdbd-191ccf28e4be\",\"exchange\":\"BATS\",\"price\":10.52,\"step\":\"asset\",\"dollar_volume\":1174265281}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TQQQ\",\"id\":\"36b71d4d-24b4-46f8-931f-1132a23bf3d1\",\"comparator\":\"gt\",\"rhs-val\":\"79\",\"step\":\"if-child\",\"collapsed?\":true},{\"id\":\"ce10f64c-33df-498f-91e8-268cafeda681\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"3f8ab8bc-7cf6-434f-bb9b-70ac9e46501c\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"087d2cc6-678f-4f3a-8664-9b8b88c42497\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"89b8e553-a249-4849-8c85-da5c5bd68763\",\"exchange\":\"BATS\",\"price\":9.91,\"step\":\"asset\",\"dollar_volume\":6.5052543003E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"SPXL\",\"id\":\"1529ad51-ff77-41dd-8a24-f87d71003aa2\",\"comparator\":\"gt\",\"rhs-val\":\"80\",\"step\":\"if-child\"},{\"id\":\"59705877-8750-41e0-83a2-f8fc96042686\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"7a427c19-0477-4fb9-a013-d0068964f59a\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"7cc79d14-b662-41ab-affa-ca7df05c3034\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"6f0c0149-64d1-45ae-8be9-14cf0aee03e1\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"d4e29a3f-f579-43f9-9115-de6275f31438\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"f206146b-ae29-42cd-8d4d-18c9b5cfd9d2\",\"step\":\"wt-cash-equal\",\"children\":[{\"step\":\"filter\",\"id\":\"83289541-0c10-4047-9cd9-63ed8410ec2e\",\"sort-by-fn-params\":{\"window\":30},\"sort-by-fn\":\"cumulative-return\",\"select-fn\":\"top\",\"select-n\":\"3\",\"children\":[{\"ticker\":\"TQQQ\",\"exchange\":\"XNAS\",\"name\":\"ProShares UltraPro QQQ\",\"id\":\"6aaa44a7-1482-4df8-87d3-315c26bbe680\",\"step\":\"asset\"},{\"ticker\":\"SPXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"id\":\"1d6b523a-298f-4614-afc4-4d89ded09612\",\"step\":\"asset\"},{\"ticker\":\"SOXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"id\":\"53990b1b-e3d6-4ce1-928f-1f9b057a25cb\",\"step\":\"asset\"},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"dcb1663c-ea28-4972-935e-418e86376b02\",\"step\":\"asset\"},{\"ticker\":\"TECL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"id\":\"e17c69c2-cf82-462a-9193-c07c90ed335f\",\"step\":\"asset\"}]}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TQQQ\",\"id\":\"1c2f88fe-20a0-4abf-a19b-2ad016a426b3\",\"comparator\":\"lt\",\"rhs-val\":\"31\",\"step\":\"if-child\"},{\"id\":\"62c36e22-597f-4260-9ba4-d911a54e7873\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"11e3ffd1-ce98-4696-8b3f-71c3b269373b\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"608855c2-a5a8-4297-b6b7-713ef0854854\",\"exchange\":\"BATS\",\"price\":12.85,\"step\":\"asset\",\"dollar_volume\":9.0439159665E8},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"ed674df9-8d4f-4bf2-9cb4-7e14c74bb464\",\"exchange\":\"XNAS\",\"price\":61.32,\"step\":\"asset\",\"dollar_volume\":9.65597774064E9},{\"ticker\":\"FNGD\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\",\"id\":\"10bb042a-402a-4ca4-b521-30d3689b85c4\",\"step\":\"asset\"}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"10\",\"id\":\"80f44002-8a8b-4306-a649-61dd64aa00e8\",\"sort-by?\":true,\"step\":\"filter\"}]}]}]}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"5\",\"lhs-val\":\"TQQQ\",\"id\":\"a684b607-f531-4bef-b9e3-a2f938cdd0a5\",\"comparator\":\"gt\",\"rhs-val\":\"20\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"e9ba7dfa-a4b4-4bd9-aeeb-b79b3177a000\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"3ef93ff3-645f-490f-8861-15d59f6435ad\",\"step\":\"wt-cash-equal\",\"children\":[{\"children\":[{\"ticker\":\"TQQQ\",\"exchange\":\"XNAS\",\"name\":\"ProShares UltraPro QQQ\",\"id\":\"7ff2e255-f955-48f1-8568-c3049663a7e9\",\"step\":\"asset\"},{\"ticker\":\"SPXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"id\":\"e93b3bd1-5730-46c6-ba20-4debcd86f680\",\"step\":\"asset\"},{\"ticker\":\"SOXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"id\":\"6db9284d-496a-4231-acbf-29e21ebe26cc\",\"step\":\"asset\"},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"4d4a31f2-e23a-4da8-8dfb-7957b5f71d73\",\"step\":\"asset\"},{\"ticker\":\"TECL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"id\":\"a44877d5-07cf-4da9-a86e-52f01dc3559d\",\"step\":\"asset\"}],\"select-fn\":\"top\",\"select-n\":\"3\",\"sort-by-fn\":\"cumulative-return\",\"id\":\"45410089-b2c3-418c-bbc7-e25fd71d976a\",\"step\":\"filter\",\"sort-by-fn-params\":{\"window\":30}}]}]}]}]}]}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"lhs-fn\":\"current-price\",\"rhs-window-days\":\"200\",\"lhs-val\":\"SPY\",\"id\":\"7ce23b5f-6fdb-4c5a-84e5-6d67383c4720\",\"comparator\":\"gt\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"41d778f3-3328-4c3c-8c6c-6bb2fe35cd29\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"04e6d977-dbff-42f4-b9b7-a21dae3c277c\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"b12ef05a-e52d-4d77-88a0-c55f386aa2ed\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"fda7204b-1f15-4cb2-b0c1-6db104a93474\",\"exchange\":\"ARCX\",\"price\":28.31,\"step\":\"asset\",\"dollar_volume\":1.7078565207E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TQQQ\",\"id\":\"3def3047-da6a-4e4d-92b5-edd6a55f641d\",\"comparator\":\"lt\",\"rhs-val\":\"31\",\"step\":\"if-child\",\"collapsed?\":true},{\"id\":\"ba128f87-a5df-4c7b-875c-98b04d3fde58\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"dfea6d46-d616-4c12-822c-4cdfa525b26b\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"bc6471a7-a621-4585-bdba-bf1e983b6944\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"4b61f4a7-6a60-4c23-8442-a3f4032b5797\",\"step\":\"wt-cash-equal\",\"children\":[{\"children\":[{\"ticker\":\"TQQQ\",\"exchange\":\"XNAS\",\"name\":\"ProShares UltraPro QQQ\",\"id\":\"76b70595-f8be-4ef0-a62b-1f17d92c1a66\",\"step\":\"asset\"},{\"ticker\":\"SPXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"id\":\"1394c092-6894-44db-abd4-768a9ecf1468\",\"step\":\"asset\"},{\"ticker\":\"SOXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"id\":\"5a43179a-e70d-4a4b-8918-740ae979765d\",\"step\":\"asset\"},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"223c5957-0edf-4a9c-8325-16121fd8fae0\",\"step\":\"asset\"},{\"ticker\":\"TECL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"id\":\"d631e45f-964f-4f69-b0cf-29659915bb23\",\"step\":\"asset\"}],\"select-fn\":\"top\",\"select-n\":\"3\",\"sort-by-fn\":\"cumulative-return\",\"id\":\"ec66bfbf-2d64-403a-b3de-20a3d83681c0\",\"step\":\"filter\",\"sort-by-fn-params\":{\"window\":30}}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"SMH\",\"id\":\"c72eeee4-c922-4dd8-94a3-5fc40eded614\",\"comparator\":\"lt\",\"rhs-val\":\"30\",\"step\":\"if-child\"},{\"id\":\"2a40d039-32c4-48d3-ab68-6123829298b4\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"0b770bc4-2a09-47d0-9a1f-786a319082aa\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"5f3c15ba-e36e-4346-a83a-2ae8011ac45d\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"d9ff8da8-f539-4fc8-8c58-653095918568\",\"step\":\"wt-cash-equal\",\"children\":[{\"children\":[{\"ticker\":\"TQQQ\",\"exchange\":\"XNAS\",\"name\":\"ProShares UltraPro QQQ\",\"id\":\"27430101-9a97-42f2-9954-fc066c8d4fd2\",\"step\":\"asset\"},{\"ticker\":\"SPXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"id\":\"73f0160b-1ea2-4f5b-8ab8-87c687c47341\",\"step\":\"asset\"},{\"ticker\":\"SOXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"id\":\"25aca5d1-6fa7-4186-8514-c5fc32c9c9b4\",\"step\":\"asset\"},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"2aabd269-4b8b-43cf-b5e8-30434320e457\",\"step\":\"asset\"},{\"ticker\":\"TECL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"id\":\"327b3ffb-9f1b-484e-9285-2ae6f75a821b\",\"step\":\"asset\"}],\"select-fn\":\"top\",\"select-n\":\"3\",\"sort-by-fn\":\"cumulative-return\",\"id\":\"49a5e0c9-174c-448e-a7e7-7d7db53087bf\",\"step\":\"filter\",\"sort-by-fn-params\":{\"window\":30}}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"DIA\",\"id\":\"6508bf06-372d-4998-96f2-7c97001c9969\",\"comparator\":\"lt\",\"rhs-val\":\"27\",\"step\":\"if-child\"},{\"id\":\"67d757a9-54e3-4cfd-8d22-c1d08f1be5e2\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"00d58eea-f136-4ebb-9ba1-d8af1044e566\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"0f78d6d0-a4c8-41ac-9284-0b65e47d02d5\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"4f2227d0-2e25-4ce7-a0fa-6fd3999ab65c\",\"step\":\"wt-cash-equal\",\"children\":[{\"children\":[{\"ticker\":\"TQQQ\",\"exchange\":\"XNAS\",\"name\":\"ProShares UltraPro QQQ\",\"id\":\"0772a48d-b6b0-4535-a80c-0af42b352e0b\",\"step\":\"asset\"},{\"ticker\":\"SPXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"id\":\"818f8fc0-8e3e-4c47-8302-9c4527d3cc41\",\"step\":\"asset\"},{\"ticker\":\"SOXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"id\":\"a8dd0b3b-127d-4192-ab11-22181bd82023\",\"step\":\"asset\"},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"1a68d138-2be1-4144-9873-b2a5fc13d18b\",\"step\":\"asset\"},{\"ticker\":\"TECL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"id\":\"96f2eaf4-5845-47e5-ab80-fbbf0b3e7f25\",\"step\":\"asset\"}],\"select-fn\":\"top\",\"select-n\":\"3\",\"sort-by-fn\":\"cumulative-return\",\"id\":\"7745ebbc-9ddc-4858-8463-8aa7bb269cb2\",\"step\":\"filter\",\"sort-by-fn-params\":{\"window\":30}}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"14\",\"lhs-val\":\"SPY\",\"id\":\"62cfe46d-c63d-4df1-af98-0626fe748c36\",\"comparator\":\"lt\",\"rhs-val\":\"28\",\"step\":\"if-child\"},{\"id\":\"dba25787-3725-4533-9a30-1e4554f1301f\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"04988eeb-473f-4050-af7a-45358dbd5ef5\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"5a9a6791-e224-481d-a70b-5aade7452a8b\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"c78bd0ed-3150-41b9-bc9e-8732bff27b52\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"a346b830-c08b-447f-8d88-d2b9e20db09c\",\"step\":\"group\",\"name\":\"Nasdaq In Crash Territory, Time to Deleverage\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"4cf36990-ff12-445b-95fd-f25247d53ffc\",\"children\":[{\"id\":\"0d19d47c-32c1-4eef-84b0-00f83980e95d\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"7ef57af3-9152-41c0-8faa-48068c0474b9\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"b4df2030-3c60-45b0-90af-430f957b69e5\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"aa81e1ad-9999-4c1b-b914-b19d4d158f90\",\"step\":\"group\",\"name\":\"Sideways Market Deleverage\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"3a3cb284-5f3b-4c6f-a252-d5b7c00a49ae\",\"children\":[{\"id\":\"6df7d22e-5cfc-40d6-85aa-456997a09747\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"5cd804b8-60df-4a95-a3ee-e418b4a07740\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"SPDR S&P 500 ETF Trust\",\"ticker\":\"SPY\",\"has_marketcap\":false,\"id\":\"4365438f-2b49-43d1-a3c0-37850b9d336c\",\"exchange\":\"ARCX\",\"price\":379.95,\"step\":\"asset\",\"dollar_volume\":2.53587893181E10}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"lhs-fn\":\"current-price\",\"rhs-window-days\":\"20\",\"lhs-val\":\"SPY\",\"id\":\"f4c9d5b1-68f9-412e-b62e-eb1a071c2dad\",\"comparator\":\"gt\",\"rhs-val\":\"SPY\",\"step\":\"if-child\"},{\"id\":\"6947b120-eca5-498f-a072-3b7b8bd780dc\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"d1d4c0e4-5933-464e-983b-b6f4e040cc84\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"baf8dc2b-892e-464c-ae91-104b63fca2bb\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"Invesco QQQ Trust\",\"ticker\":\"QQQ\",\"has_marketcap\":false,\"id\":\"b35cac78-2516-4a9c-983b-2a627a6955a9\",\"exchange\":\"XNAS\",\"price\":269.54,\"step\":\"asset\",\"dollar_volume\":1.6819746131800001E10}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"10\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TLT\",\"id\":\"4ebcedd9-d5f3-4020-9794-a1f08ce18326\",\"comparator\":\"gt\",\"rhs-val\":\"SQQQ\",\"step\":\"if-child\"},{\"id\":\"0accbfa7-24c0-483b-8a38-372008c2da16\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"name\":\"ProShares Short QQQ\",\"ticker\":\"PSQ\",\"has_marketcap\":false,\"id\":\"cb8fd7fe-131a-48fe-ad05-dae5d896dac1\",\"exchange\":\"ARCX\",\"price\":14.69,\"step\":\"asset\",\"dollar_volume\":2.5279310004E8}]}]}]}]}]},{\"id\":\"7b590c87-6ab4-49d9-b959-1baff3bb3841\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"Invesco QQQ Trust\",\"ticker\":\"QQQ\",\"has_marketcap\":false,\"id\":\"2c1e94fc-b10b-48ee-ad24-ea76eec3bd86\",\"exchange\":\"XNAS\",\"price\":269.54,\"step\":\"asset\",\"dollar_volume\":1.6819746131800001E10}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"10\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TLT\",\"id\":\"4bea4737-320e-4bbc-9277-62b9b86f804f\",\"comparator\":\"gt\",\"rhs-val\":\"SQQQ\",\"step\":\"if-child\"},{\"id\":\"3f453478-d7b2-4e52-adb4-7eead18df82f\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"name\":\"ProShares Short QQQ\",\"ticker\":\"PSQ\",\"has_marketcap\":false,\"id\":\"478a6864-51d2-412b-b529-b8e7058fd2ab\",\"exchange\":\"ARCX\",\"price\":14.69,\"step\":\"asset\",\"dollar_volume\":2.5279310004E8}]}]}]}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"60\",\"lhs-val\":\"QQQ\",\"id\":\"dc6726a8-7648-4a48-9ae1-aa7e4b5987a2\",\"comparator\":\"lte\",\"rhs-val\":\"-12\",\"step\":\"if-child\"},{\"id\":\"bd0cd85e-dd25-43f4-ab10-35e70680f59d\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"a8c53623-ec7a-4839-9bbc-b87bd453f718\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"1abc5329-82c0-4163-b352-c3e9c79c8f97\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"689055e9-204f-4884-93eb-f8096127aa19\",\"step\":\"wt-cash-equal\",\"children\":[{\"children\":[{\"ticker\":\"TQQQ\",\"exchange\":\"XNAS\",\"name\":\"ProShares UltraPro QQQ\",\"id\":\"3bc7d2c8-0b88-4ec8-8c7d-9245ff9a98ad\",\"step\":\"asset\"},{\"ticker\":\"SPXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"id\":\"58fe8cd3-9dc3-494d-955a-679db169d682\",\"step\":\"asset\"},{\"ticker\":\"SOXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"id\":\"be52dfd0-3124-4d1e-b84d-87ed17c3ce6a\",\"step\":\"asset\"},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"a062b16e-c044-4029-b663-605c9d89f860\",\"step\":\"asset\"},{\"ticker\":\"TECL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"id\":\"17164845-5c84-4a9f-a394-4a63850253c0\",\"step\":\"asset\"}],\"select-fn\":\"top\",\"select-n\":\"3\",\"sort-by-fn\":\"cumulative-return\",\"id\":\"fb9b710e-20ea-46c6-b115-a786c70f76c7\",\"step\":\"filter\",\"sort-by-fn-params\":{\"window\":30}}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"10\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TLT\",\"id\":\"8424a8eb-f0ed-4d9a-8d2b-53032d1795aa\",\"comparator\":\"gt\",\"rhs-val\":\"SQQQ\",\"step\":\"if-child\"},{\"id\":\"f91ea40b-f9bf-4b54-a541-d970d0892186\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"f987f290-bfcf-4665-bf45-668ccd4072cb\",\"exchange\":\"XNAS\",\"price\":56.4,\"step\":\"asset\",\"dollar_volume\":6.9813385272E9},{\"ticker\":\"FNGD\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\",\"id\":\"90eaa029-af01-43df-bca5-cb8cdd720437\",\"step\":\"asset\"}]}]}]}]}]}]}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"lhs-fn\":\"current-price\",\"rhs-window-days\":\"20\",\"lhs-val\":\"QQQ\",\"id\":\"af2c54b3-2007-499f-96a5-6d24dd051c96\",\"comparator\":\"lt\",\"rhs-val\":\"QQQ\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"4a43f9e2-9052-4718-bace-27df3eb70ca4\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"bd9f69e2-ae33-4347-805e-c8f2e8144852\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"4241a755-530f-418d-b0f2-9043fd00c19b\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Short QQQ\",\"ticker\":\"PSQ\",\"has_marketcap\":false,\"id\":\"2a720436-f252-4b44-9b4c-3fc110519730\",\"exchange\":\"ARCX\",\"price\":14.69,\"step\":\"asset\",\"dollar_volume\":2.5279310004E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"SQQQ\",\"id\":\"04b85967-fff9-4801-ae35-0b62e91bde55\",\"comparator\":\"lt\",\"rhs-val\":\"31\",\"step\":\"if-child\"},{\"id\":\"18c5db53-1972-403a-b5ae-639a8c0cfa62\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"2f13aee1-00de-47a6-80d4-4a4c1c36daae\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"7e7cc607-9835-42db-b7a3-062d1f1400eb\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Short QQQ\",\"ticker\":\"PSQ\",\"has_marketcap\":false,\"id\":\"7cabaa8a-38f7-4408-ba06-864d431faf38\",\"exchange\":\"ARCX\",\"price\":14.69,\"step\":\"asset\",\"dollar_volume\":2.5279310004E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"10\",\"lhs-val\":\"QQQ\",\"id\":\"1a1dc2b8-b39b-4c25-80c4-408a8874586b\",\"comparator\":\"gt\",\"rhs-val\":\"5.5\",\"step\":\"if-child\"},{\"id\":\"2c9c3e31-9de4-482a-b3fd-519242af2479\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"41af321f-1717-4dfb-9795-604d478db513\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Invesco QQQ Trust\",\"ticker\":\"QQQ\",\"has_marketcap\":false,\"id\":\"4a3b7174-89e1-4153-8bf8-fef821a9fa6b\",\"exchange\":\"XNAS\",\"price\":269.54,\"step\":\"asset\",\"dollar_volume\":1.6819746131800001E10},{\"name\":\"VanEck Semiconductor ETF\",\"ticker\":\"SMH\",\"has_marketcap\":false,\"id\":\"19d735d4-0e19-4f97-83b0-77475e1ac6a9\",\"exchange\":\"XNAS\",\"price\":199.39,\"step\":\"asset\",\"dollar_volume\":1.2097667232099998E9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"10\",\"id\":\"b4050f7b-3778-4c13-aa89-12b8b63fc1ab\",\"sort-by?\":true,\"step\":\"filter\"}]}]}]}]}]}]}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"200\",\"lhs-val\":\"QQQ\",\"id\":\"e5ec4a2d-880d-4236-b1c8-f4ba2c9c815e\",\"comparator\":\"lt\",\"rhs-val\":\"-20\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"d761b659-8d46-433c-a488-26b3fa3509fc\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"3f4afa35-6393-4252-9e88-5aa84cf7de5d\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"01884e39-4990-4846-b39b-5051cf0e97af\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"c2ad211c-a108-49f4-b844-e11e3d345826\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"2e01ea3d-4dea-4c3d-9529-fe4c7ec78d2f\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"57656a90-3557-45b4-ae80-ad4341a31919\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"2468835b-91ef-4a7c-b13f-068352a1e87e\",\"step\":\"wt-cash-equal\",\"children\":[{\"children\":[{\"ticker\":\"TQQQ\",\"exchange\":\"XNAS\",\"name\":\"ProShares UltraPro QQQ\",\"id\":\"37cc1165-d0fc-408d-a936-cb909bc44c1d\",\"step\":\"asset\"},{\"ticker\":\"SPXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"id\":\"56183581-d06f-440b-b5b4-c123f93499e9\",\"step\":\"asset\"},{\"ticker\":\"SOXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"id\":\"4915712a-c3ec-4525-98d2-764fb128c552\",\"step\":\"asset\"},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"8e84b8c5-177f-4821-9d8c-a11d04c22130\",\"step\":\"asset\"},{\"ticker\":\"TECL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"id\":\"9b7d0d31-fd48-4a0d-8916-571209863be6\",\"step\":\"asset\"}],\"select-fn\":\"top\",\"select-n\":\"3\",\"sort-by-fn\":\"cumulative-return\",\"id\":\"22e5cf90-1f45-46d0-a8cc-c2968a9e7545\",\"step\":\"filter\",\"sort-by-fn-params\":{\"window\":30}}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"10\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TLT\",\"id\":\"8f2d3974-99fe-4769-b2f6-dc1329c5afea\",\"comparator\":\"gt\",\"rhs-val\":\"SQQQ\",\"step\":\"if-child\"},{\"id\":\"85366ee5-fd7f-43be-98e5-f27d21e9cadb\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"dbefb44a-3c8e-4142-82c1-dffd11035101\",\"exchange\":\"XNAS\",\"price\":56.4,\"step\":\"asset\",\"dollar_volume\":6.9813385272E9},{\"ticker\":\"FNGD\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\",\"id\":\"bb6fc82d-4f4a-41e0-8a1b-e9ae533d332e\",\"step\":\"asset\"}]}]}]}]}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"lhs-fn\":\"current-price\",\"rhs-window-days\":\"20\",\"lhs-val\":\"QQQ\",\"id\":\"40d89bdb-8bcb-4cb1-9284-aea2dbc68be7\",\"comparator\":\"lt\",\"rhs-val\":\"QQQ\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"fe887afc-716f-4fd3-a39a-73a38c47081d\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"2b0072cd-ce74-4736-aaec-4aef97fbe386\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"ba88b393-c0be-4f22-875d-f6cf74840269\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"048c242e-028f-499d-abc3-e54ce6758022\",\"exchange\":\"XNAS\",\"price\":61.32,\"step\":\"asset\",\"dollar_volume\":9.65597774064E9},{\"ticker\":\"FNGD\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\",\"id\":\"76618841-efc7-422d-8c89-b2a767444a29\",\"step\":\"asset\"}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"SQQQ\",\"id\":\"da91234b-2de7-4007-8c64-2f414145ecf4\",\"comparator\":\"lt\",\"rhs-val\":\"31\",\"step\":\"if-child\"},{\"id\":\"c7ab6d0b-386e-490a-a0d4-5ef4e5d36b33\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"56a10c7a-9a10-48a6-b1f9-6547781cdfe5\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"faa4b1be-15f8-439a-beae-b20e2c782ef4\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"ba701785-7e83-4d16-84ae-ef1e36ab4ba7\",\"exchange\":\"XNAS\",\"price\":57.66,\"step\":\"asset\",\"dollar_volume\":5.5946141260199995E9}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"10\",\"lhs-val\":\"QQQ\",\"id\":\"541d6e84-bb67-4c26-9343-23b81aea33de\",\"comparator\":\"gt\",\"rhs-val\":\"5.5\",\"step\":\"if-child\"},{\"id\":\"c6348292-365d-4065-ae6f-50a6225bccd6\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"88799e13-a73a-4b0b-bd9c-bd72dd4e9e15\",\"step\":\"wt-cash-equal\",\"children\":[{\"children\":[{\"ticker\":\"TQQQ\",\"exchange\":\"XNAS\",\"name\":\"ProShares UltraPro QQQ\",\"id\":\"6bf9132e-7e30-4e0a-9ee7-6e23757560f2\",\"step\":\"asset\"},{\"ticker\":\"SPXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"id\":\"6c12d959-b2ee-44ac-ad84-8bffb3b31c24\",\"step\":\"asset\"},{\"ticker\":\"SOXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"id\":\"99906b8a-d401-486b-ac92-dd3357c3743f\",\"step\":\"asset\"},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"a0892b83-3eed-46a4-b950-b66f90cc7753\",\"step\":\"asset\"},{\"ticker\":\"TECL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"id\":\"79d7864a-1279-4255-a767-cda5e0ec8e2e\",\"step\":\"asset\"}],\"select-fn\":\"top\",\"select-n\":\"3\",\"sort-by-fn\":\"cumulative-return\",\"id\":\"6beff866-b52f-4b22-9c30-c5c4e2033ec5\",\"step\":\"filter\",\"sort-by-fn-params\":{\"window\":30}}]}]}]}]}]}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]},{\"id\":\"182660cc-a381-494c-a42a-fb0d87178927\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"01bdfa89-1041-4731-b178-33d99aa30805\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"a31bb678-3c64-4fd8-bb9d-f9aef8821d12\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"12ffcef4-67fb-4d4f-8e4f-12eadfcb64a9\",\"step\":\"group\",\"name\":\"Sideways Market Deleverage\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"832ab41e-9630-403d-812c-fe706b85bc7f\",\"children\":[{\"id\":\"92404fd4-c9ff-4b0d-be3a-9334e4a0856a\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"a7d04733-138f-4cdb-ba2a-c88be93d94fe\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"SPDR S&P 500 ETF Trust\",\"ticker\":\"SPY\",\"has_marketcap\":false,\"id\":\"1cc17e2a-b4bb-42a3-b6e7-b5f088516b9f\",\"exchange\":\"ARCX\",\"price\":379.95,\"step\":\"asset\",\"dollar_volume\":2.53587893181E10}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"lhs-fn\":\"current-price\",\"rhs-window-days\":\"20\",\"lhs-val\":\"SPY\",\"id\":\"2d1eaa6c-1209-48a8-8b14-499dea604aac\",\"comparator\":\"gt\",\"rhs-val\":\"SPY\",\"step\":\"if-child\"},{\"id\":\"2333d482-050f-429b-85ff-6b65038972c2\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"02314fb8-b1f3-46e5-94be-b641ab938913\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"5b5e6f13-2c8e-402d-8b2c-2382d69c61f3\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"Invesco QQQ Trust\",\"ticker\":\"QQQ\",\"has_marketcap\":false,\"id\":\"cdf3a12e-bf8b-4913-860c-f4a2519cbd58\",\"exchange\":\"XNAS\",\"price\":269.54,\"step\":\"asset\",\"dollar_volume\":1.6819746131800001E10}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"10\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TLT\",\"id\":\"cd646c6f-3567-45e8-98b7-42fc76451985\",\"comparator\":\"gt\",\"rhs-val\":\"SQQQ\",\"step\":\"if-child\"},{\"id\":\"e97450a2-a5c9-426c-80bd-f95e56e34b9f\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"name\":\"ProShares Short QQQ\",\"ticker\":\"PSQ\",\"has_marketcap\":false,\"id\":\"d8bf387c-ebe8-44bc-a5c2-0c5661f220b7\",\"exchange\":\"ARCX\",\"price\":14.69,\"step\":\"asset\",\"dollar_volume\":2.5279310004E8}]}]}]}]}]},{\"id\":\"8036062f-7452-4ea3-8c3f-0b2375527991\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"Invesco QQQ Trust\",\"ticker\":\"QQQ\",\"has_marketcap\":false,\"id\":\"592c1bb8-3fe7-4bf6-b702-2aa93dee5465\",\"exchange\":\"XNAS\",\"price\":269.54,\"step\":\"asset\",\"dollar_volume\":1.6819746131800001E10}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"10\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TLT\",\"id\":\"0fd1e8ab-de14-4025-8f88-66a0e02296d3\",\"comparator\":\"gt\",\"rhs-val\":\"SQQQ\",\"step\":\"if-child\"},{\"id\":\"2aa9e6bb-dee1-4bb3-bbef-55f29c18915a\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"name\":\"ProShares Short QQQ\",\"ticker\":\"PSQ\",\"has_marketcap\":false,\"id\":\"9517a453-b192-4339-b4c5-cb13a94632e9\",\"exchange\":\"ARCX\",\"price\":14.69,\"step\":\"asset\",\"dollar_volume\":2.5279310004E8}]}]}]}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"60\",\"lhs-val\":\"QQQ\",\"id\":\"c2319342-d048-4031-8acc-ce017686906b\",\"comparator\":\"lte\",\"rhs-val\":\"-12\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"716b84bd-59d0-4021-9f7e-623331ec1ae7\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"53ce6df0-f9ad-41c8-bcb6-a098b272a43d\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"02eb1016-df1d-4b41-bba1-1abd87e5c9cd\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"0deefc96-34d7-4e63-a491-f80bab39ae72\",\"step\":\"wt-cash-equal\",\"children\":[{\"children\":[{\"ticker\":\"TQQQ\",\"exchange\":\"XNAS\",\"name\":\"ProShares UltraPro QQQ\",\"id\":\"491e5371-2ea7-437d-9d28-e5b4b74814de\",\"step\":\"asset\"},{\"ticker\":\"SPXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"id\":\"5627d6e7-ec99-4643-98e4-15b42f42d3d4\",\"step\":\"asset\"},{\"ticker\":\"SOXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"id\":\"01a552fc-7964-4b6e-8b43-0fc1332c9ee5\",\"step\":\"asset\"},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"4a6ca898-5d7b-4235-816f-3293834e41ea\",\"step\":\"asset\"},{\"ticker\":\"TECL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"id\":\"8b4b0512-fb4b-4057-9e9f-9c753bd8b973\",\"step\":\"asset\"}],\"select-fn\":\"top\",\"select-n\":\"3\",\"sort-by-fn\":\"cumulative-return\",\"id\":\"c23a51a5-fe32-4f11-8400-6e8ef0154b6d\",\"step\":\"filter\",\"sort-by-fn-params\":{\"window\":30}}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"10\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TLT\",\"id\":\"e57f8136-c13e-49ba-bc2d-790dbb784885\",\"comparator\":\"gt\",\"rhs-val\":\"SQQQ\",\"step\":\"if-child\"},{\"id\":\"d849dcf2-5676-4d98-bd5c-6913001c43c8\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"b6ccf5fe-8b59-4f18-b20d-b975c688dd8c\",\"exchange\":\"XNAS\",\"price\":56.4,\"step\":\"asset\",\"dollar_volume\":6.9813385272E9},{\"ticker\":\"FNGD\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\",\"id\":\"85d8bee1-be52-4168-8b3a-a8e54fe15843\",\"step\":\"asset\"}]}]}]}]}]}]}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"lhs-fn\":\"current-price\",\"rhs-window-days\":\"20\",\"lhs-val\":\"QQQ\",\"id\":\"38875d04-6e15-4840-a943-5dbcb642ffeb\",\"comparator\":\"lt\",\"rhs-val\":\"QQQ\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"ca73cbca-d70f-4540-a8f5-ec64518bfaa0\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"c7711295-579b-4409-8c98-9ea6fbd1b4bb\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"783c5ed4-1728-4367-b460-ac767480a379\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"ca9cb2bd-f16f-4603-881e-60373bc7e218\",\"exchange\":\"XNAS\",\"price\":61.32,\"step\":\"asset\",\"dollar_volume\":9.65597774064E9},{\"ticker\":\"FNGD\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index -3X Inverse Leveraged ETN\",\"id\":\"32ec392a-852a-473e-a645-0a16c15b2593\",\"step\":\"asset\"}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"SQQQ\",\"id\":\"8afbd2fa-b0fd-46a9-9d7f-8145e661c94f\",\"comparator\":\"lt\",\"rhs-val\":\"31\",\"step\":\"if-child\"},{\"id\":\"25835d4d-d91c-415b-8f31-c9c62faebba0\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"d9b51ee7-181f-446b-8d73-1cc955267ac8\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"b5d44ce1-2598-4ab3-9aec-d4c4ecf9437d\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"7333dbbc-d4c1-4488-86ec-a2864a4505c0\",\"step\":\"wt-cash-equal\",\"children\":[{\"children\":[{\"ticker\":\"TQQQ\",\"exchange\":\"XNAS\",\"name\":\"ProShares UltraPro QQQ\",\"id\":\"63be167d-7f7a-462e-8498-fd3ddcfff92b\",\"step\":\"asset\"},{\"ticker\":\"SPXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"id\":\"ba19d895-ae9b-4c56-829c-e0851dd02b9e\",\"step\":\"asset\"},{\"ticker\":\"SOXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"id\":\"46bea86c-2253-4f49-aa21-1ed8d490f144\",\"step\":\"asset\"},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"0a232f18-de8c-4044-837f-20a363c37c66\",\"step\":\"asset\"},{\"ticker\":\"TECL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"id\":\"40dfcd1e-ebfc-4d52-9277-59631a0e0170\",\"step\":\"asset\"}],\"select-fn\":\"top\",\"select-n\":\"3\",\"sort-by-fn\":\"cumulative-return\",\"id\":\"fd856bf9-90ef-4b18-897e-93cf2e78442d\",\"step\":\"filter\",\"sort-by-fn-params\":{\"window\":30}}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"70\",\"lhs-val\":\"QQQ\",\"id\":\"b4f154ea-82a7-4a88-98a0-d22c725f0a81\",\"comparator\":\"lt\",\"rhs-val\":\"-15\",\"step\":\"if-child\"},{\"id\":\"e4d025a6-e0fb-4e9e-bb11-54d76d8f9884\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"9b0e65c9-130e-4668-bd48-bf6f27664883\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"SPDR S&P 500 ETF Trust\",\"ticker\":\"SPY\",\"has_marketcap\":false,\"id\":\"be0ea01b-2028-43fe-b28a-5ff1ff435324\",\"exchange\":\"ARCX\",\"price\":382,\"step\":\"asset\",\"dollar_volume\":31811364004},{\"name\":\"Invesco QQQ Trust\",\"ticker\":\"QQQ\",\"has_marketcap\":false,\"id\":\"93ea5f2f-a581-4e4a-b26a-7b4d7d992272\",\"exchange\":\"XNAS\",\"price\":269.54,\"step\":\"asset\",\"dollar_volume\":1.6819746131800001E10},{\"name\":\"SPDR Dow Jones Industrial Average ETF Trust\",\"ticker\":\"DIA\",\"has_marketcap\":false,\"id\":\"f200dfba-64af-4bd8-b755-11d2a3010285\",\"exchange\":\"ARCX\",\"price\":331.71,\"step\":\"asset\",\"dollar_volume\":2.0892153954899998E9},{\"name\":\"Consumer Staples Select Sector SPDR Fund\",\"ticker\":\"XLP\",\"has_marketcap\":false,\"id\":\"14619c74-5770-4359-8f93-839372e1e631\",\"exchange\":\"ARCX\",\"price\":72.7,\"step\":\"asset\",\"dollar_volume\":6.601671808000001E8}],\"select-fn\":\"top\",\"select-n\":\"2\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"15\",\"id\":\"f7d97f62-c119-4718-96e9-bbcd9ca57275\",\"sort-by?\":true,\"step\":\"filter\"}]}]}]}]}]}]}]}],\"collapsed?\":false}]}]}]}]}]}]}]}]}]}]}]}]}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}]}],\"collapsed?\":true},{\"id\":\"b16f9a65-5561-412b-a6e6-bbe8e026e52a\",\"step\":\"group\",\"name\":\"Proposal for V3.0.4.1b | ?? Beta Baller + TCCC ? | Deez, BrianE, HinnomTX, DereckN, Garen, DJKeyhole ????, comrade, WaywardSon, zyzz | 2012 Backtestable | Belcampo69 updated some of the modules > AR & < DD\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"144a3842-e049-425a-82b2-e4eb8d01d141\",\"children\":[{\"id\":\"08aeb916-a2f4-4cb3-a5b9-ce534cec22fb\",\"step\":\"group\",\"name\":\".V3.0.4 5/7 2012 | ?? Beta Baller + TCCC ?\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"b394c2c9-95f7-4dc5-9b19-0d20687b3b7a\",\"children\":[{\"id\":\"80812bf8-bfe2-412b-bd4b-1175e6459cae\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"f23a435f-bdaf-4e1c-ba2b-ebb861898667\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"9f445d8a-a01d-4cfe-83c3-8d5a2aafb80e\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"0c75868c-d68a-4835-8177-862d14958529\",\"step\":\"group\",\"name\":\"Overbought S&P. Sell the rip. Buy volatility.\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"fcab1b0a-6dfc-408d-b78b-6a62f8bbb2c6\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"6f585b79-41a2-4895-8bc9-5a7851b2a037\",\"exchange\":\"BATS\",\"price\":11.45,\"step\":\"asset\",\"dollar_volume\":4.5342449984999996E8},{\"name\":\"ProShares VIX Short-Term Futures ETF\",\"ticker\":\"VIXY\",\"has_marketcap\":false,\"id\":\"4fea295b-bbf3-4769-be72-f6d0fd110422\",\"exchange\":\"BATS\",\"price\":15.84,\"step\":\"asset\",\"dollar_volume\":1.4911915392E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"13\",\"weight\":{\"num\":\"80\",\"den\":100},\"id\":\"55da47ea-b607-4360-8a97-9b02f4dc8051\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\"}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"6\",\"lhs-val\":\"SPY\",\"id\":\"c716f02e-e6ad-495b-a54e-0d8561762b94\",\"comparator\":\"gt\",\"rhs-val\":\"75\",\"step\":\"if-child\"},{\"id\":\"4978876f-f2f0-40d8-85aa-c99179475dd1\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"f0da3079-2f47-4e8b-9ba1-1c876c4ab3af\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"4c549d51-725a-4b44-88d5-bd157d804cd6\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"973690ba-95ba-40c2-8c98-d3a1444c89be\",\"exchange\":\"ARCX\",\"price\":8.99,\"step\":\"asset\",\"dollar_volume\":1.5392827503700001E9}],\"rhs-fn\":\"exponential-moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"5\",\"lhs-window-days\":\"5\",\"lhs-val\":\"SOXL\",\"id\":\"c34ce9c5-1be8-42d0-9d6f-7756df2d4630\",\"comparator\":\"lte\",\"rhs-val\":\"75\",\"step\":\"if-child\"},{\"id\":\"b22a9fae-5e3b-495b-b8be-98ce4919d357\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"a4716621-d655-4915-b3fa-ab72b6a9a92e\",\"exchange\":\"ARCX\",\"price\":56.82,\"step\":\"asset\",\"dollar_volume\":1.18838302704E9}]}]}]}]}]}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"5\",\"lhs-val\":\"BIL\",\"id\":\"61e7b734-56a8-4806-a56c-348ec05eedd4\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"f496ed37-aa1a-4e50-962b-458f7aeecbd0\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"c01a6aa6-8b84-46c6-a42b-342158cdf59b\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"a9d95e68-3f81-4dda-8985-a5887059cee0\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"d2009119-7013-43eb-9c42-69f43b309266\",\"step\":\"group\",\"name\":\"Extremely oversold S&P (low RSI). Double check with bond mkt before going long\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"ad27e039-98c2-4fb1-81b2-0e69d91b6821\",\"children\":[{\"id\":\"7442bc3a-ed32-4a37-8c85-c5b52b639a73\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"49dd094e-6018-49dc-a08e-d78acd0d6992\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"8856b257-8507-4f14-8452-66811133e208\",\"exchange\":\"ARCX\",\"price\":75.59,\"step\":\"asset\",\"dollar_volume\":1.57344069699E9},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"4ba32768-51b8-47b5-88e9-321d9d77888f\",\"exchange\":\"XNAS\",\"price\":63.2,\"step\":\"asset\",\"dollar_volume\":9.8760366064E9}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"7\",\"id\":\"edbb105d-4a31-44d6-9c34-8d682984f695\",\"sort-by?\":true,\"step\":\"filter\"}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BSV\",\"id\":\"5c6c5588-6671-4f75-82e2-0e69ccd0fc3d\",\"comparator\":\"lt\",\"rhs-val\":\"SPHB\",\"step\":\"if-child\"},{\"id\":\"ea145caa-7122-4086-82b4-9afd22409b4d\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"d4f3e2fd-a51d-4a2c-bde5-6a890df6cd22\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"278d4e94-a11a-4738-b086-d3eff1eee53c\",\"exchange\":\"ARCX\",\"price\":8.28,\"step\":\"asset\",\"dollar_volume\":1.3390279048799999E9},{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"dc51f959-11e9-4c78-bfa1-0145ff6419e7\",\"exchange\":\"ARCX\",\"price\":21.12,\"step\":\"asset\",\"dollar_volume\":9.177117312E7}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"7\",\"id\":\"cddb1b54-0f07-488f-bc19-027b3fe88bc8\",\"sort-by?\":true,\"step\":\"filter\"}]}]}]}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"6\",\"lhs-val\":\"SPY\",\"id\":\"0fbb33b5-dee3-4053-b69e-c3a7be9451c2\",\"comparator\":\"lt\",\"rhs-val\":\"27\",\"step\":\"if-child\"},{\"id\":\"17f3ed8f-3ac8-4d98-95e0-186abcd926aa\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"c3fd260b-c657-4c0f-9209-7cf7aad2aba2\",\"step\":\"group\",\"name\":\"V0.2.1 | TCCC Stop the Bleed ? | DJKeyhole ???? | 1/2 of Momentum Mean Reversion\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"17949a06-255d-4b96-80b7-1cd2324a941d\",\"children\":[{\"id\":\"bfe88428-ba5d-4932-ba9c-5dbe05adc9fd\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"670ae05b-77c0-4435-946b-dda39ea4dc06\",\"step\":\"group\",\"name\":\"V1.2 | Five and Below | DJKeyhole | No Low Volume LETFs\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"3c168dfe-b0ea-404f-8489-36b29c857dd2\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"d495b0b4-913a-481e-b427-f2c0535d7e3c\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"585c6eb6-727f-4745-bd6d-ebcb407c9ede\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"ticker\":\"SPXL\",\"has_marketcap\":false,\"id\":\"0431959a-de60-4d67-bad4-19528ba2f387\",\"exchange\":\"ARCX\",\"price\":83.85,\"step\":\"asset\",\"dollar_volume\":4.8172328099999994E8},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"19e6803b-afe0-422f-a11e-9abd6b0534a7\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"ecdc08c0-a8f5-40ef-8098-e2132be61467\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"name\":\"ProShares Ultra QQQ\",\"ticker\":\"QLD\",\"has_marketcap\":false,\"id\":\"62c1b7a2-a2ab-4318-b50e-d57f77501780\",\"exchange\":\"ARCX\",\"price\":35.26,\"step\":\"asset\",\"dollar_volume\":1.6824665126E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"01c904ed-4bd3-471b-9f71-ec00eaf1c95c\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"SPY\",\"id\":\"0ecfa371-27b7-4cb8-97ab-5730e7053427\",\"comparator\":\"lt\",\"rhs-val\":\"30\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"d5547b12-c7b1-4be6-885f-8c81ce1e9f69\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"4a0caff0-60a8-4c7d-a761-83853a937132\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"bc313fed-63e8-4db6-8edb-190fedb589c7\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"309772a3-6f48-4403-a4c6-026befce2069\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"093f6999-3838-4773-aac8-4cdc07a59e81\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"dfdaa48a-bfeb-49b3-a6f1-73d9afda67d2\",\"step\":\"group\",\"name\":\"Bear Stock Market - High Inflation - [STRIPPED] V2.0.2b | A Better LETF Basket | DJKeyhole ???? | BIL and TMV\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"9b9e128d-08a9-4841-8908-22c8e6785f4d\",\"children\":[{\"id\":\"ec3fceb6-2d99-490f-a057-441edb09529a\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"d0324d01-7c0d-44f2-82de-b7465350df75\",\"step\":\"group\",\"name\":\"A.B: Medium term TLT may be overbought*\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"87e2552c-d83f-4add-b8e4-227aff8a8c3e\",\"children\":[{\"id\":\"00449891-1903-4cb9-aedf-6fb5e32a5b6e\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"d1455451-d941-46d8-b3d1-1b96112affb6\",\"step\":\"group\",\"name\":\"A.B.B.A: Risk Off, Rising Rates (TMV)*\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"f6254ac6-ef0c-4b56-897e-de2e7fcbd729\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"9b3f711a-482f-4367-a477-1e35912a327c\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"7c45c93b-9df2-45d9-834e-5730136918b6\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"214c52ec-a6f0-4176-b7a3-6160a39a122a\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"26108ccd-2330-4349-83af-02901d35aa25\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"fda7cf83-b949-47c9-8ae6-4acb59eb2a6f\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"afbc41d4-fd24-49f4-93c0-d32e5f79cbbe\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"71597b93-26fb-48a5-b0a5-719d467f59b3\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"fcb2eb32-6e40-4e85-a68a-32e599e11b33\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"b81ca0c0-d252-4efb-b736-9914e2a45434\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TQQQ\",\"id\":\"37018f22-7b30-4cae-802a-ae7cd57c68d1\",\"comparator\":\"lt\",\"rhs-val\":\"30\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"7fe6d90e-4842-41db-b3d3-80815a575bdd\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"867511a2-eb6e-4854-8ac3-3575d07aa232\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"c553cc14-f080-4d0f-a003-d88d73f494d1\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"d186c569-a750-4247-96a0-53d44d409931\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"4cd32b6e-819b-4b91-968f-9cafd1cbb140\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9},{\"name\":\"ProShares UltraShort Euro\",\"ticker\":\"EUO\",\"has_marketcap\":false,\"id\":\"7e68336f-362f-49e7-8cd5-2a8bb0242b69\",\"exchange\":\"ARCX\",\"price\":34.69,\"step\":\"asset\",\"dollar_volume\":5517930.159999999},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"e94c6c2d-4d11-4861-a759-2e7f1a97fb20\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"30e21cbe-fa1c-4722-8fa5-ea2d971dbea2\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"3\",\"lhs-window-days\":\"6\",\"lhs-val\":\"SPXU\",\"id\":\"e59d5e8b-d012-4559-a9f9-9a7eac89b5c4\",\"comparator\":\"gte\",\"rhs-val\":\"UPRO\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"f61069d4-73bd-4b90-b434-372b62f4081a\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"c839e0d8-2dd7-40c1-9987-23a09112dee7\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"e551d518-3fa3-4709-ae26-3e82ac6f5ab6\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"34332c53-d66e-44e8-b8df-5358266b3a31\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"2a3556df-e522-4914-a0d9-d876de19052c\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"Direxion Daily Healthcare Bull 3x Shares\",\"ticker\":\"CURE\",\"has_marketcap\":false,\"id\":\"5a31ea40-5a5a-4941-9148-491d0aaae9b2\",\"exchange\":\"ARCX\",\"price\":89.46,\"step\":\"asset\",\"dollar_volume\":5880205.8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"fcc61fd6-8822-4ec6-bf85-ba1cc17127fd\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"002ca8a8-882f-42d8-a3d5-01ad1cdeb8de\",\"comparator\":\"lte\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"35343aac-bb77-4d1e-99ce-62ecb542298b\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"062fc5b2-23e0-4d58-bd63-7cafb1d58522\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"287b3b18-f10d-4a9c-96b8-15710363d080\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"7ecb88b1-d22b-4b5c-a868-0e74a8f6be96\",\"exchange\":\"BATS\",\"price\":16.19,\"step\":\"asset\",\"dollar_volume\":9.3964454544E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"11\",\"lhs-val\":\"TQQQ\",\"id\":\"5f58bb30-99b4-402c-a614-ec760ec5373a\",\"comparator\":\"gt\",\"rhs-val\":\"77\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"628c1218-f388-4a6d-a2e7-c12a4a9c708e\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"2214b820-31c8-4cae-bac1-6e57bddf403e\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"2a28c9b5-3470-42ea-881f-95e039b7c3c4\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"6f5041a8-bf9f-4919-afc5-a3554436eaf4\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"bdd033f1-447e-48f8-bb81-89c9b00dfe43\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"4c199c44-175f-4960-9637-a7bd83828f07\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"0a2e5fc4-0345-4ba5-8eae-89c66f6af787\",\"exchange\":\"ARCX\",\"price\":148.89,\"step\":\"asset\",\"dollar_volume\":8.982935702999999E7}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"99445f5f-faa7-42ed-b6d9-aa3be7f3e49f\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":true}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"TLT\",\"id\":\"0cfb3128-2aee-41ec-b253-ba9d58a4d77e\",\"comparator\":\"lt\",\"rhs-val\":\"0\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"01e845dd-c7a0-40c9-9596-3489948ba223\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"67143cfa-2826-467b-8420-fe26fff29ab5\",\"step\":\"group\",\"name\":\"A.B.B.B: Risk Off, Falling Rates (TMF)*\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"ad85c799-b60e-4400-ac78-e1da30fc587d\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"8fac02d0-b102-4a51-96c5-d66a34207f82\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"a741a32e-0ae4-47ac-9bd1-91545d1672df\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"6646cdf3-8370-437a-b027-41a9b04b0025\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"fa0297e7-f3e0-473a-9158-0a90d8e633d3\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"d01e87e3-6fea-4baa-b293-492cf494ddf7\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"10a377e8-fd28-4e31-b404-02e7f8a42c67\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"d86f857c-8aac-4c52-b195-45badd7d8568\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"934699fa-9ff7-4f45-a482-9aa5f97dedde\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TQQQ\",\"id\":\"7bf1a876-b82b-40f7-9ece-77e669990bb2\",\"comparator\":\"lt\",\"rhs-val\":\"30\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"6b874f17-8030-4e17-bba5-bcace3bfaec6\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"60e56b4d-b83f-411a-847b-0d0843036807\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"36da3e46-71cc-4a20-ab55-9fcb39a3c050\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"cc917215-83db-4a6f-aae3-3f4f629a3a59\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"15c72e8c-dbc8-4b6a-be5e-962882819a85\",\"exchange\":\"ARCX\",\"price\":35.4,\"step\":\"asset\",\"dollar_volume\":1.327053606E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"8b16d63a-0442-4162-98ab-4f75bba3de56\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"9ea894e0-6585-46e6-89ea-c8286c7af436\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"ec48dca5-cef1-4e28-b230-0dfc53090a6c\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"2\",\"lhs-val\":\"SPY\",\"id\":\"bc8650a9-0252-4f1c-996f-1b390ff2b31c\",\"comparator\":\"lte\",\"rhs-val\":\"-2\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"98a44559-e830-43e0-acc4-a22692bb15c6\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"ceed5106-5a88-4ab7-8fb8-f9588f0e0e4b\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"7ee62eba-1c8e-43b8-927b-01d7a2d40bfc\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"c95a1173-dae8-443d-983f-75840f93915b\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Energy Bull 2x Shares\",\"ticker\":\"ERX\",\"has_marketcap\":false,\"id\":\"a0f4c022-d7a8-45bb-89d4-fabe8fa02201\",\"exchange\":\"ARCX\",\"price\":51.3,\"step\":\"asset\",\"dollar_volume\":1.7945037539999998E8},{\"name\":\"ProShares UltraShort Euro\",\"ticker\":\"EUO\",\"has_marketcap\":false,\"id\":\"b2915f77-b40c-4c0f-b4a9-043c75eeb3b9\",\"exchange\":\"ARCX\",\"price\":34.69,\"step\":\"asset\",\"dollar_volume\":5517930.159999999},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"f4b76656-0860-44b2-b080-de0e7b624349\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"ecdb2ba4-a40a-46f1-aa19-3886e3ada175\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"3\",\"lhs-window-days\":\"6\",\"lhs-val\":\"SPXU\",\"id\":\"ba961f77-337f-4d14-b695-072f61100209\",\"comparator\":\"gte\",\"rhs-val\":\"UPRO\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"862947cd-8f5b-4c6f-be8b-fedd61573fc0\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"cac45c4a-a702-42d7-8340-161ca08df6c9\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"a9ece448-85b5-4b9c-a996-481a2ae01b4e\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"605c1c1b-ca6d-48dc-8f71-03b0dc6ead5e\",\"exchange\":\"ARCX\",\"price\":31.37,\"step\":\"asset\",\"dollar_volume\":5.6195129461E8},{\"name\":\"ProShares Ultra MidCap400\",\"ticker\":\"MVV\",\"has_marketcap\":false,\"id\":\"b6d06c8b-b37b-4353-90b5-0d009242e38e\",\"exchange\":\"ARCX\",\"price\":42.05,\"step\":\"asset\",\"dollar_volume\":130018.59999999999},{\"name\":\"ProShares Ultra Semiconductors\",\"ticker\":\"USD\",\"has_marketcap\":false,\"id\":\"7dda0973-da7e-4511-999d-484c032538a2\",\"exchange\":\"ARCX\",\"price\":16.68,\"step\":\"asset\",\"dollar_volume\":2838452.28}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"72933f55-73b6-452a-95e7-3449ac7f78ae\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"81e3345b-e4ac-4e39-a579-a421e3198ff6\",\"comparator\":\"lte\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"88f6f67a-f7d8-4d0e-9a53-91a07742f151\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"7cc4faf0-1933-4f00-80c2-e5e3b9c7756b\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"cfef1d6d-0bb5-4a8d-af31-5c36d65d3066\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"a591bf6e-74fd-4462-8d59-10cd2f128d47\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"88d2b0a9-3381-4d1d-886e-e2182b3cc3aa\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"746e7ea5-4353-47be-b660-3b577d1c4afd\",\"exchange\":\"BATS\",\"price\":16.19,\"step\":\"asset\",\"dollar_volume\":9.3964454544E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"11\",\"lhs-val\":\"TQQQ\",\"id\":\"39e2f079-a749-4969-8905-582d2b8b21f2\",\"comparator\":\"gt\",\"rhs-val\":\"77\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"b59204c2-a9b6-48a0-91b4-7c06e3f468d4\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"ae7739ad-109c-4434-8bed-3ee46dd84e35\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"da7d4714-15a7-4866-9d4a-fcb36c772f57\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"cd50cf6d-59c3-4cbe-bfc7-bae0d6e06699\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"dceee3b5-ce4b-41e1-8c87-38c956572a38\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"bad7eb21-3587-4c5e-9d93-166ee3aa285a\",\"step\":\"wt-cash-equal\",\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"92d18b47-1eef-4df0-b396-2ecaaa9fbd6b\",\"exchange\":\"BATS\",\"price\":10.41,\"step\":\"asset\",\"dollar_volume\":7.6812945732E8}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"1\",\"lhs-val\":\"TQQQ\",\"id\":\"c45857b0-d443-4092-8c2f-01acd04b28ce\",\"comparator\":\"gt\",\"rhs-val\":\"5.5\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"d36163c9-7f5a-43b6-9c1e-68da72b78d4a\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"1bd5c5e1-b469-429f-9592-6f07fc05a2cb\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"b60415fe-2b11-4551-8c3b-d934f1c66e18\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"3a102fb0-81e6-433a-ab3a-97a72f0f1156\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"072a83e0-1453-4f34-848f-54cdd1453091\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"b280ccf6-ec2b-41b2-a564-d84ae5374673\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"8fa12dde-d5dc-4620-98b4-286ee79442a5\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"137ee542-a3b0-4aaa-985c-f85b5ff80d0c\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"22b101e5-00ba-4ea9-b443-e4d945a9acc7\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"f77a554a-3b03-409c-ae23-6f7f6c5a1d8e\",\"exchange\":\"ARCX\",\"price\":28.27,\"step\":\"asset\",\"dollar_volume\":9.3641556481E8},{\"name\":\"Invesco DB US Dollar Index Bullish Fund\",\"ticker\":\"UUP\",\"has_marketcap\":false,\"id\":\"0dc34d0d-3b0d-4832-8793-1ee947f1ffb2\",\"exchange\":\"ARCX\",\"price\":30.15,\"step\":\"asset\",\"dollar_volume\":1.429251705E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"cce649a2-eea4-4731-99ec-f8e7699a9db8\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167},{\"name\":\"ProShares Ultra Bloomberg Crude Oil\",\"ticker\":\"UCO\",\"has_marketcap\":false,\"id\":\"763b0a40-896e-42f9-9470-1c3db5506639\",\"exchange\":\"ARCX\",\"price\":29.97,\"step\":\"asset\",\"dollar_volume\":6.165467361E7}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"b91cb656-df7f-4b34-bcfc-07f462556a50\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed-specified-weight?\":false}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"6\",\"lhs-val\":\"TQQQ\",\"id\":\"cb9cc123-128e-4cf6-9d99-999bd10f25ac\",\"comparator\":\"lt\",\"rhs-val\":\"-10\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"2df78482-ea8b-421c-9e48-c4ec63963302\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"2ec96315-7733-47be-b345-777245506e20\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"1a7f9ce7-555c-45e3-b8eb-9147fa7617e5\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"d58aca71-bed9-4760-96f3-2f9b468209ba\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"1462453e-5fbc-4ca1-b94f-ef02a5cf74b3\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"80681ee8-2766-4ac0-962f-26cce2fdfad0\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"ticker\":\"SPXL\",\"has_marketcap\":false,\"id\":\"7fba1fd3-88ea-4b37-9aa9-ea393c1d4ba8\",\"exchange\":\"ARCX\",\"price\":83.85,\"step\":\"asset\",\"dollar_volume\":4.8172328099999994E8},{\"name\":\"ProShares Ultra QQQ\",\"ticker\":\"QLD\",\"has_marketcap\":false,\"id\":\"695b0e2a-35ee-4418-885a-d569a46fb79f\",\"exchange\":\"ARCX\",\"price\":35.26,\"step\":\"asset\",\"dollar_volume\":1.6824665126E8},{\"name\":\"ProShares Ultra Semiconductors\",\"ticker\":\"USD\",\"has_marketcap\":false,\"id\":\"7ec4de1f-ea85-4e1f-bad1-447f3c5cdcc5\",\"exchange\":\"ARCX\",\"price\":16.68,\"step\":\"asset\",\"dollar_volume\":2838452.28}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"460ea09b-5d50-4367-bfe3-8d468b2742a0\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"8faf958a-c91e-4201-9a27-22dc34a87e8e\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"8b748bb8-58d2-456f-9768-7cf060bf518d\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"74c4ebda-85ad-4550-ab26-f4ecce7fed19\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"d58b4024-7acd-4b95-8a10-a024a74d38cd\",\"exchange\":\"ARCX\",\"price\":28.27,\"step\":\"asset\",\"dollar_volume\":9.3641556481E8},{\"name\":\"Invesco DB US Dollar Index Bullish Fund\",\"ticker\":\"UUP\",\"has_marketcap\":false,\"id\":\"dbeb0f4d-4c52-4e83-a4c3-df0c49aa482b\",\"exchange\":\"ARCX\",\"price\":30.15,\"step\":\"asset\",\"dollar_volume\":1.429251705E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"c2026cb8-2075-42c9-b231-e338d6dfb731\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"8608ea0d-e877-4d86-90e8-f36b1a525937\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-return\",\"is-else-condition?\":false,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"2c8d3d7d-30d9-4219-a847-620653437ba1\",\"comparator\":\"gt\",\"rhs-val\":\"DBC\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"8f9fc5da-55a2-49a8-9a38-e3057fffaeb3\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"5dc2a2ff-184b-4d50-b232-b853c99f7b9a\",\"step\":\"group\",\"name\":\"Defense | Modified\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"ee0b87be-7629-40c3-98eb-60ada3a62746\",\"children\":[{\"id\":\"3b6f31a8-b4d7-4d2a-ab62-e298c61ea935\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"4a38b3a0-4c14-4311-9094-cbd02fded4cf\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares 1-3 Year Treasury Bond ETF\",\"ticker\":\"SHY\",\"has_marketcap\":false,\"id\":\"1dbdcfca-8ad8-44a6-b8e6-d195f3b0b8ec\",\"exchange\":\"XNAS\",\"price\":82.38,\"step\":\"asset\",\"dollar_volume\":6.516601524599999E8},{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"87029d6a-3ac3-4c28-b64b-584ebdccd3e5\",\"exchange\":\"ARCX\",\"price\":30.97,\"step\":\"asset\",\"dollar_volume\":8.040002155799999E8},{\"name\":\"SPDR Gold Shares\",\"ticker\":\"GLD\",\"has_marketcap\":false,\"id\":\"4fa53f1b-94f9-4618-a4cb-34efd17ede44\",\"exchange\":\"ARCX\",\"price\":162.77,\"step\":\"asset\",\"dollar_volume\":6.6775562373E8},{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"48bec408-601b-4dbd-ada6-30cfb1fd2337\",\"exchange\":\"ARCX\",\"price\":20.01,\"step\":\"asset\",\"dollar_volume\":3.0217437168E8},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"a2a7d307-2a31-4de3-ab8c-b38cf6b09bce\",\"exchange\":\"ARCX\",\"price\":55.58,\"step\":\"asset\",\"dollar_volume\":1.1806370296E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"3dfc19ba-5424-4d90-ab9b-89d5e939b76e\",\"exchange\":\"ARCX\",\"price\":70.73,\"step\":\"asset\",\"dollar_volume\":9.714480458100001E8},{\"name\":\"ProShares Ultra Bloomberg Crude Oil\",\"ticker\":\"UCO\",\"has_marketcap\":false,\"id\":\"9bb9e6b8-8856-410a-83f6-d8a95b5cd1d8\",\"exchange\":\"ARCX\",\"price\":28.2,\"step\":\"asset\",\"dollar_volume\":8.985865139999999E7},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"3d8692c8-8ca6-45d0-91e7-c621de954377\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"263ecafa-8a28-46ed-a06a-4814e6fc663b\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"standard-deviation-return\",\"is-else-condition?\":false,\"lhs-fn\":\"standard-deviation-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"DBC\",\"id\":\"701fcf5c-4ee4-4f97-b923-ae561f9fcf5f\",\"comparator\":\"gt\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"e0773deb-ca26-4abd-aa70-52e29fc46869\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"9457a1b9-7cea-4982-8a69-27641a39ef5b\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"e4fa9880-22aa-40c3-a015-d8b1319c0e0a\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"699e221e-67a8-4060-9ff7-338c380d001b\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"e88a30f8-45ed-4324-9cb3-39000973a05f\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares Ultra Semiconductors\",\"ticker\":\"USD\",\"has_marketcap\":false,\"id\":\"4700713e-047a-4c2c-b175-f86841400a24\",\"exchange\":\"ARCX\",\"price\":16.68,\"step\":\"asset\",\"dollar_volume\":2838452.28},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"a9c4b52c-9625-4575-82b5-977956689418\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"a9df268b-37ba-4577-8aec-25c32a35794b\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"1bb09531-526a-41ab-a215-812beef5f234\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"5642b31f-92f3-44e9-aee5-11b351e31499\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"a895862a-eaf3-4a9a-ad73-7a2019e51ad1\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"bca7f342-48be-4133-a66b-a36addefee05\",\"exchange\":\"ARCX\",\"price\":28.27,\"step\":\"asset\",\"dollar_volume\":9.3641556481E8},{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"317deb85-7e1e-4d9f-8c0b-c6ccf5033893\",\"exchange\":\"ARCX\",\"price\":20.01,\"step\":\"asset\",\"dollar_volume\":3.0217437168E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"a409ec3d-d232-4157-a6b2-90110e9db130\",\"exchange\":\"ARCX\",\"price\":44.99,\"step\":\"asset\",\"dollar_volume\":9.058357684200001E8},{\"name\":\"ProShares Ultra Bloomberg Crude Oil\",\"ticker\":\"UCO\",\"has_marketcap\":false,\"id\":\"3d082f72-41bf-4cca-a2e2-648bf5245184\",\"exchange\":\"ARCX\",\"price\":28.2,\"step\":\"asset\",\"dollar_volume\":8.985865139999999E7},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"5ffd30de-b046-4352-af47-54cc879670f6\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"cc01ff6d-ba7c-4031-98e5-ae081c7cc1b8\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}]}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":true}]}],\"weight\":{\"num\":100,\"den\":100}}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"lhs-fn\":\"current-price\",\"rhs-window-days\":\"200\",\"lhs-val\":\"TLT\",\"id\":\"e0bd28d6-d5be-4819-a76a-ec2d777bdf1b\",\"comparator\":\"gt\",\"rhs-val\":\"TLT\",\"step\":\"if-child\",\"collapsed?\":true},{\"id\":\"64b2d723-381a-4454-b399-ee61d32d67d9\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"517029d0-728f-4a11-954a-d9b51937a3fc\",\"step\":\"group\",\"name\":\"B: If long term TLT is trending down, safety: Long Term, 2 Least Volatile*\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"e58c6519-e6a7-4d74-b5f1-938567978edd\",\"children\":[{\"id\":\"7ebee162-4d2d-4ded-812f-5318dda97a80\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"d53fda3e-65eb-44d6-98f2-15f1477c47da\",\"step\":\"group\",\"name\":\"B.A.A: Risk Off, Rising Rates (TMV)* - LETF Basket^\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"1e5c17cc-8051-49a1-9bcc-d3e473ef4d8a\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"ed2a5f6a-a73d-47a6-916b-2220d734a100\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"edb33d28-e37a-46b6-abf3-17bb8e02c9e9\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"eca93ffe-54c8-4b86-8804-3497bf63b3f6\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"f8ee85b6-f5d8-4962-bcb6-0557746ed9b8\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"12cff5cf-6099-419b-b2bc-589ec3cf1465\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"a80ac908-fbe4-45e1-9870-b59fce42b09a\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"d65b6c00-2664-4b98-8831-86608aab3728\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"3316fcfd-39d5-4768-b577-3cf8fc538f10\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TQQQ\",\"id\":\"191b8cab-a662-4ee6-964c-5223a481ed9b\",\"comparator\":\"lt\",\"rhs-val\":\"30\",\"step\":\"if-child\",\"collapsed?\":true},{\"id\":\"15829ab5-1b38-4da6-ae17-09cfdadd0f3d\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"160fd07f-cd8a-4601-bf4c-e4d41ceeec1a\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"6c503b99-0a7d-479b-810b-0c467d382508\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"63a59f46-de1c-45ed-8ebf-505453b3f57c\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"ad3cb66b-96b1-4f08-903c-913491a7508c\",\"exchange\":\"ARCX\",\"price\":20.91,\"step\":\"asset\",\"dollar_volume\":5.3752632333E8},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"cc3ecf38-19e2-4bbc-bb1e-7c01860844d6\",\"exchange\":\"ARCX\",\"price\":35.4,\"step\":\"asset\",\"dollar_volume\":1.327053606E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"07cb1f32-0270-45c6-84bd-2fb6425e49ec\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"2367de03-3d5d-4e84-a49f-5791b07e6b31\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9},{\"name\":\"Direxion Daily Energy Bull 2x Shares\",\"ticker\":\"ERX\",\"has_marketcap\":false,\"id\":\"139e2e5b-761d-40a5-b9a5-44295b15a34a\",\"exchange\":\"ARCX\",\"price\":51.3,\"step\":\"asset\",\"dollar_volume\":1.7945037539999998E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"ceafd433-8f1f-46bf-bcc9-609e5c15ba51\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"1\",\"lhs-val\":\"SPY\",\"id\":\"a54760e7-9da5-4fbe-876d-1b5608b1b2a2\",\"comparator\":\"lte\",\"rhs-val\":\"-2\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"f6a19fa2-f716-45c4-9910-020c58b03f0c\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"eefac6f9-e94f-4d7e-9206-04211dd10735\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"7f33d165-6e50-457e-b788-c728ad0fcbda\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"f0c95b4c-0d56-4f77-a759-23760a53938f\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"76c9ee80-d751-4f72-80df-2b3ce481b08b\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"fd1b51bb-e6f8-4a6b-a930-40d0998a8b26\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9},{\"name\":\"WisdomTree India Earnings Fund\",\"ticker\":\"EPI\",\"has_marketcap\":false,\"id\":\"b9c29ea5-6bd8-47d2-83e1-a712ccf6ef9b\",\"exchange\":\"ARCX\",\"price\":32.13,\"step\":\"asset\",\"dollar_volume\":6708776.130000001}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"7d3b35dd-016f-484b-a05f-4a116f0156fb\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"4\",\"lhs-window-days\":\"5\",\"lhs-val\":\"SPXU\",\"id\":\"6891c667-2a51-493e-b65c-af1cb0b5d3a8\",\"comparator\":\"gte\",\"rhs-val\":\"UPRO\",\"step\":\"if-child\",\"collapsed?\":true},{\"id\":\"d80cac03-d575-40e0-a7be-9ce95ec4f143\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"0664bd5d-7933-410d-a7cd-0b90f4b9a450\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"f4e75739-ae49-4264-b0d8-481b36c526ff\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"1560c1da-5a2d-4e6f-8a83-d12d30a19716\",\"step\":\"wt-cash-equal\",\"children\":[{\"children\":[{\"ticker\":\"TQQQ\",\"exchange\":\"XNAS\",\"name\":\"ProShares UltraPro QQQ\",\"id\":\"000036d6-c37f-4b9a-8af4-58c283d5bccb\",\"step\":\"asset\"},{\"ticker\":\"SPXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"id\":\"13b69528-0153-4c3b-a04b-5cd494ce6698\",\"step\":\"asset\"},{\"ticker\":\"SOXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"id\":\"5b4858fb-2ba4-4996-a633-2d06f789d90c\",\"step\":\"asset\"},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"b2c96bc9-2f3d-415c-9333-2072a28111d9\",\"step\":\"asset\"},{\"ticker\":\"TECL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"id\":\"fa25e149-8b63-4e10-8bbc-862a3c3e0695\",\"step\":\"asset\"}],\"select-fn\":\"top\",\"select-n\":\"3\",\"sort-by-fn\":\"cumulative-return\",\"id\":\"32b2dac5-9fdd-40ef-b34e-8fc3f5136338\",\"step\":\"filter\",\"sort-by-fn-params\":{\"window\":30}}]}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"3\",\"lhs-window-days\":\"3\",\"lhs-val\":\"BIL\",\"id\":\"95c84ccf-7f75-4a43-82df-8820f954441f\",\"comparator\":\"gte\",\"rhs-val\":\"TMV\",\"step\":\"if-child\"},{\"id\":\"7c4feb3e-d10c-40cb-a179-ecc412b18594\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"33ad7e82-2b6e-48b8-91db-072f00012841\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"6b2af631-ed1a-495f-a514-f22cecb5af94\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"5876fbd3-667b-4fe5-997e-09c94f5fb59a\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"95f424d1-52ee-4f34-8d07-740cbad89397\",\"exchange\":\"ARCX\",\"price\":157.82,\"step\":\"asset\",\"dollar_volume\":9.906629694E7}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"faa6c117-9021-4fb9-84de-f385058f1b24\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}]}]}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"68ad03e9-4e25-4360-a84a-3c11c336afd0\",\"comparator\":\"lte\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"48f2a167-9b5c-4e83-b172-8c04b0a9640e\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"5ce49589-808c-4eb8-b127-7351a3b890b9\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"715a5c06-0462-4ab7-8aa3-a2222448a4f2\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"85dbdeb5-251e-4ce0-aa7b-5bc02a7df923\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"531910e5-e6e5-41a9-be2a-5ad4cf6ee1cb\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"e0f1cf22-ad62-4aae-983f-76b2a1b29c9a\",\"exchange\":\"BATS\",\"price\":16.19,\"step\":\"asset\",\"dollar_volume\":9.3964454544E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"11\",\"lhs-val\":\"TQQQ\",\"id\":\"5c498f8a-f3ed-4030-93bd-fd11ffc3b88e\",\"comparator\":\"gt\",\"rhs-val\":\"77\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"4447c541-3b51-4181-a5c0-30cf4b0580c8\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"30a7784c-4a83-4c6c-8cc2-5770061b9aec\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"0e875953-7797-4fe2-8f4e-a18d44a1f90b\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"b5020133-e455-4800-8104-64c78c84dda5\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"08867a8b-97df-48e2-a1cd-a24377eab0ad\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"d9c5d9cd-8c1f-4a1c-9341-90f6c5e9f638\",\"step\":\"wt-cash-equal\",\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"50073bef-0314-4085-a236-2252c863d852\",\"exchange\":\"BATS\",\"price\":10.41,\"step\":\"asset\",\"dollar_volume\":7.6812945732E8}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"1\",\"lhs-val\":\"TQQQ\",\"id\":\"ef8a59da-e292-4d39-bc62-472d6ad57e1d\",\"comparator\":\"gt\",\"rhs-val\":\"5.5\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"08f40116-5e29-41ff-89df-d149918a41c6\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"95506245-bc45-4d7b-bc7a-bef4a18d3af9\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"dc143ec7-9630-48ed-b06f-638522e25baf\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"886490a7-62eb-4c34-aa78-20e6209351a7\",\"exchange\":\"ARCX\",\"price\":141.26,\"step\":\"asset\",\"dollar_volume\":4.3188126099999994E7}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"b200387d-77f3-44a9-a85b-e0180c599ce5\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"6\",\"lhs-val\":\"TQQQ\",\"id\":\"68f5e819-a002-45db-98b8-934ac1ffd12c\",\"comparator\":\"lt\",\"rhs-val\":\"-10\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"b9db6014-10e4-4d7e-b540-c813f13f1f55\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"6c45384f-545c-419a-b83c-280f9164dd41\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"36d65e8d-5dcb-43f8-a6ce-7f77109b2426\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"b2b383f4-9a71-4ccc-9726-6d6167958d4c\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"177d5e76-d395-463f-a321-4b0b9ded66a6\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"a662d0a8-6d7f-4c8e-b4f9-4d727b925312\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"1136ae5e-532e-4996-95bd-a77509af27d0\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"74bcad30-dd11-4f36-b86d-4d801658a8c6\",\"exchange\":\"ARCX\",\"price\":148.89,\"step\":\"asset\",\"dollar_volume\":8.982935702999999E7},{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"d72bc1ca-243e-4432-9508-84ee6afba570\",\"exchange\":\"ARCX\",\"price\":19.95,\"step\":\"asset\",\"dollar_volume\":1.6883044604999998E8}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"716e68d9-d745-4734-b0cb-e6783b43ab74\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"ece6d1ab-3abd-4e5c-a5e2-b3cf56baedd3\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"162824c7-9abe-4f5c-84ff-23c5928f04e0\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"2e2a094c-c859-42e8-9548-6a311e1caf4c\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"bbce957b-7132-42d4-87fa-8b3fc60ce5f6\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"2de2129a-f31b-4b3d-b47a-d5124e864394\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"22\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"b31c8654-6c21-4aaa-a717-da7ac982ef1a\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}]}],\"rhs-fn\":\"moving-average-return\",\"is-else-condition?\":false,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"b85f861c-b45f-4e26-9b16-cfb667d126b8\",\"comparator\":\"gt\",\"rhs-val\":\"DBC\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"89bdac98-d95e-4d7c-8cf1-d6aa5e168d56\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"d9b4cfc4-456e-4345-8c7b-6e89a125fe93\",\"step\":\"group\",\"name\":\"Defense | Modified\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"31e33de3-dfd5-4f70-a056-38b5bc34e2aa\",\"children\":[{\"id\":\"c03403fd-b0d9-45ac-81fd-0c45c9b75619\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"0b001177-fe11-43e8-8ec7-9791f0694c11\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"a57bb900-07e9-49b1-b91b-8d629272c3c4\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"30b417e1-a941-46aa-a29f-c96d0cecadb4\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"b7f0f2bc-a40e-4010-8f66-c2bd84aa7eca\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"cc225fc7-a802-4227-b5d1-375956bfb8c8\",\"exchange\":\"ARCX\",\"price\":141.26,\"step\":\"asset\",\"dollar_volume\":4.3188126099999994E7}],\"rhs-fn\":\"standard-deviation-return\",\"is-else-condition?\":false,\"lhs-fn\":\"standard-deviation-return\",\"rhs-window-days\":\"5\",\"lhs-window-days\":\"5\",\"lhs-val\":\"TMV\",\"id\":\"70563a9c-a854-403a-bfa3-21804f929653\",\"comparator\":\"lte\",\"rhs-val\":\"DBC\",\"step\":\"if-child\"},{\"id\":\"09975e6c-1d61-407f-bf48-0d321463c874\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"name\":\"Invesco DB Commodity Index Tracking Fund\",\"ticker\":\"DBC\",\"has_marketcap\":false,\"id\":\"674d4dc1-301d-432a-a7d4-086ad0f3196e\",\"exchange\":\"ARCX\",\"price\":25.33,\"step\":\"asset\",\"dollar_volume\":5.922121070999999E7}]}]}]}],\"rhs-fn\":\"exponential-moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"standard-deviation-return\",\"rhs-window-days\":\"100\",\"lhs-window-days\":\"10\",\"lhs-val\":\"DBC\",\"id\":\"0ea57d9e-f579-4a0e-9c23-046e6e572f59\",\"comparator\":\"gte\",\"rhs-val\":\"3\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"d8384e5e-4de3-469d-9c40-d1c42d135eaf\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"54f32ab9-12f4-46e6-924a-12fe042c8f64\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"4506c0d6-4731-4fcb-b301-2b2c9a77182f\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"6490d012-7a90-4868-8339-77f3f186999b\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"9350e4bf-ddd7-48f8-9f94-20ea4f3d3d84\",\"exchange\":\"ARCX\",\"price\":141.26,\"step\":\"asset\",\"dollar_volume\":4.3188126099999994E7},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"ee0c439b-0de5-4435-85d0-b23b2c9abebd\",\"exchange\":\"ARCX\",\"price\":80.05,\"step\":\"asset\",\"dollar_volume\":1.38192436325E9},{\"name\":\"ProShares UltraPro Short S&P500\",\"ticker\":\"SPXU\",\"has_marketcap\":false,\"id\":\"31c7a1b0-fa0a-45ec-a8a9-0937ba4154cd\",\"exchange\":\"ARCX\",\"price\":21.92,\"step\":\"asset\",\"dollar_volume\":1.14726053376E9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"5154c8ed-84a4-4e48-a725-b4d070e019a1\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"7b3b1733-accf-4cbd-81d5-310f8f7b3747\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"e5f83b78-8f0c-4ea1-8de4-7c68f6964baa\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"973599f9-c770-45be-89e8-3224fae3af10\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares MSCI EAFE ETF\",\"exch\":\"PCX\",\"typeDisp\":\"ETF\",\"type\":\"E\",\"exchDisp\":\"NYSEArca\",\"ticker\":\"EFA\",\"id\":\"c2addb8d-67d5-411c-92d5-973b2770a5bd\",\"step\":\"asset\"},{\"name\":\"iShares MSCI Emerging Markets ETF\",\"exch\":\"NYQ\",\"ticker\":\"EEM\",\"type\":\"E\",\"typeDisp\":\"ETF\",\"id\":\"2fcac9fa-49a0-4156-b933-0b5519ee7a95\",\"exchDisp\":\"NYSE\",\"step\":\"asset\"},{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"2495ca04-edea-4890-b9e6-c1478653483a\",\"exchange\":\"ARCX\",\"price\":20.01,\"step\":\"asset\",\"dollar_volume\":3.0217437168E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"3a1cbc03-cc22-4a5a-a0d3-fc6e8d998e5b\",\"exchange\":\"ARCX\",\"price\":44.99,\"step\":\"asset\",\"dollar_volume\":9.058357684200001E8},{\"name\":\"ProShares Ultra Bloomberg Crude Oil\",\"ticker\":\"UCO\",\"has_marketcap\":false,\"id\":\"97ea2f07-df11-4f9d-a914-6b64ebb61c9f\",\"exchange\":\"ARCX\",\"price\":28.2,\"step\":\"asset\",\"dollar_volume\":8.985865139999999E7},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"d71cccfb-969f-4263-aaaa-163aab0c6d92\",\"exchange\":\"ARCX\",\"price\":141.26,\"step\":\"asset\",\"dollar_volume\":4.3188126099999994E7}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"9a6c7068-61cc-4fa9-8b40-7abe8a354297\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"standard-deviation-return\",\"is-else-condition?\":false,\"lhs-fn\":\"standard-deviation-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"DBC\",\"id\":\"ffaf1c90-c453-4ddc-b41b-a78e887ea87d\",\"comparator\":\"gt\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"3a5d2edd-b844-4e67-b97c-5bc1d588ca57\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"26df2d91-3bf8-4a1f-ab1e-fba086c5966b\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"e7cb5893-48ab-45d3-af61-2a5a50572253\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"b8794acc-2aa1-4edf-972b-78b13b58ba22\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"WisdomTree India Earnings Fund\",\"ticker\":\"EPI\",\"has_marketcap\":false,\"id\":\"b7dddd72-f428-4ad4-a2ac-7cfaecacfc39\",\"exchange\":\"ARCX\",\"price\":30.67,\"step\":\"asset\",\"dollar_volume\":1.529816533E7},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"d8a02f8c-d53d-433d-bb30-0d52b9e1e978\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"f02138d3-c519-40cb-a6bd-92e96a1ab403\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"234096fa-dac5-4f79-a3e0-3685bb68359c\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"45da7521-1145-4a46-af68-7a55d8892d4f\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"d5170975-78f8-44e4-86fa-9e34dc147cd8\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"59ed38b5-194f-418e-9ab8-6ed6a149ea4e\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"d38e2905-d27e-4c15-8b54-e50b46c7477d\",\"exchange\":\"ARCX\",\"price\":28.27,\"step\":\"asset\",\"dollar_volume\":9.3641556481E8},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"dd65d17b-2eaa-413f-956c-e1eb573b8070\",\"exchange\":\"ARCX\",\"price\":36.8,\"step\":\"asset\",\"dollar_volume\":1.218889968E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"31956ad6-ac4f-44f2-bb27-c0d27e88d384\",\"exchange\":\"ARCX\",\"price\":44.99,\"step\":\"asset\",\"dollar_volume\":9.058357684200001E8},{\"name\":\"ProShares UltraShort Euro\",\"ticker\":\"EUO\",\"has_marketcap\":false,\"id\":\"c417546f-247f-4b28-98cb-f51c4933410f\",\"exchange\":\"ARCX\",\"price\":34.69,\"step\":\"asset\",\"dollar_volume\":5517930.159999999},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"50254654-7ba4-44d4-8076-ea6d41c3535d\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"f821fa75-aa32-4a44-9c09-614284b520b8\",\"exchange\":\"ARCX\",\"price\":141.26,\"step\":\"asset\",\"dollar_volume\":4.3188126099999994E7}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"ebd42294-c27d-4d35-98fd-8d675c475ef6\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":true}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"TLT\",\"id\":\"7e8c541c-83c3-4475-91b6-a091b0e856fd\",\"comparator\":\"lt\",\"rhs-val\":\"0\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"12b53c6f-f44d-44a5-a06d-4d3b52ddbef3\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"8351b671-4c0a-49bc-9c4c-e07b30f794a4\",\"step\":\"group\",\"name\":\"B.A.B: Risk Off, Falling Rates (TMF)* - LETF Basket\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"8cf13ba7-07b6-4602-8804-f09004847e94\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"9731941d-3fea-4a27-8889-e98ec6d419e1\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"ff6e44ac-9b23-4fa6-8a0c-6c6be3ff75dc\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"b49e105e-8670-4e6e-8c7e-0a562271220d\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"b12bd489-fc12-46e6-93f7-2ab34d60e1c3\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"5e942029-54f1-4b57-a1ef-39014b65673c\",\"exchange\":\"ARCX\",\"price\":20.91,\"step\":\"asset\",\"dollar_volume\":5.3752632333E8},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"b614832c-1b18-4862-b06c-41f1eb360304\",\"exchange\":\"ARCX\",\"price\":35.4,\"step\":\"asset\",\"dollar_volume\":1.327053606E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"7858e82c-6764-46e9-ae0e-924f3eb0c8ae\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"a8f31f39-3c31-4e3a-a972-bf6237af9490\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"c3b095a2-9207-4cda-afab-979f831de25a\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"2\",\"lhs-val\":\"SPY\",\"id\":\"8080ddd7-3a58-4b32-913c-b7dab443cc98\",\"comparator\":\"lte\",\"rhs-val\":\"-2\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"03da4387-4d55-4be6-b0c6-aa1b7ae213ba\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"d6af04b5-762f-4deb-857e-df8549279a2c\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"3024b9ab-c9ed-4993-8db3-71469a36a1f8\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"88adab66-feef-433b-b5f2-f852eb06fdfb\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"SPDR Bloomberg 1-3 Month T-Bill ETF\",\"ticker\":\"BIL\",\"has_marketcap\":false,\"id\":\"145cb4b4-bf93-46a4-a88e-661b29529b10\",\"exchange\":\"ARCX\",\"price\":91.44,\"step\":\"asset\",\"dollar_volume\":5.3686188791999996E8},{\"name\":\"iShares Core U.S. Aggregate Bond ETF\",\"ticker\":\"AGG\",\"has_marketcap\":false,\"id\":\"63c79404-884e-4e4f-9fc7-e994e95f014a\",\"exchange\":\"ARCX\",\"price\":96.34,\"step\":\"asset\",\"dollar_volume\":1.3850104298400002E9},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"07bf8fe5-e95b-4dbe-9a63-583887f45933\",\"exchange\":\"ARCX\",\"price\":7.67,\"step\":\"asset\",\"dollar_volume\":7.270521856E7}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"0b2f3b1c-59ec-47b6-9065-0c50f9170265\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"3\",\"lhs-window-days\":\"6\",\"lhs-val\":\"SPXU\",\"id\":\"e2a962d8-c734-4947-a954-c94bd78a2e8e\",\"comparator\":\"gte\",\"rhs-val\":\"UPRO\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"7357d627-14d1-4b8b-b646-a4245a13677d\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"7f3298e8-cc06-45af-8346-ed3c4913e27b\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"ad10c143-5ed3-4235-b64a-3b66dff02db3\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"2cabf987-b15d-41bd-b734-6452d4bfb988\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"70c9509b-b038-4e99-8447-1e08b6e19f99\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"0f4db0f5-ad8a-456d-bd9d-7af237bc62a0\",\"exchange\":\"ARCX\",\"price\":31.37,\"step\":\"asset\",\"dollar_volume\":5.6195129461E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"72be36df-23c5-43c0-a5e3-afe4d74e8393\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"7e333605-78dd-498b-a46f-a91cb53836d3\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}]}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"7b64f259-5b81-4d89-880e-93bf64d27919\",\"comparator\":\"lte\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"2b5d3223-5326-45a3-bb6a-a5d0fdbeba69\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"36f2a855-6668-4f81-afab-8c438d893da3\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"a89b7d0a-8727-4aad-b43b-791d0d8571f2\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"90334277-015b-4308-9b17-b1cdbfd6a818\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"edd33274-0fa7-4f40-8100-e99f96706446\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"2117d202-087e-42b7-8294-fa2e02de72b8\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"98db85c2-8b56-4117-97d7-e882a32dfba7\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"c2cf213d-e779-48c1-a68c-bf92e0649bca\",\"exchange\":\"BATS\",\"price\":16.19,\"step\":\"asset\",\"dollar_volume\":9.3964454544E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"11\",\"lhs-val\":\"TQQQ\",\"id\":\"612d180c-3a82-4b17-b0c0-39fa6ad8283d\",\"comparator\":\"gt\",\"rhs-val\":\"77\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"3f24d291-5f0b-4db4-abd8-480ad4b2c099\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"09601599-6550-4caa-8d5c-a71675c4f4b8\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"c6acf289-b02e-48ea-b973-d129fb439bc2\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"742ef1a3-a068-43b2-bf4c-8a7b7f9c82dc\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"cc2864ad-1b16-4561-b945-8603f02065d2\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"681f6fc3-2a71-4415-b379-3dfbec822a44\",\"step\":\"wt-cash-equal\",\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"c4df285f-99d5-4239-a012-813922048e86\",\"exchange\":\"BATS\",\"price\":10.41,\"step\":\"asset\",\"dollar_volume\":7.6812945732E8}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"1\",\"lhs-val\":\"TQQQ\",\"id\":\"c271da25-fd0d-4d4d-acc8-7d807a111147\",\"comparator\":\"gt\",\"rhs-val\":\"5.5\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"f2202092-2a71-40ba-a2b4-2a51593afad6\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"70e4f13c-ee94-4690-9619-c90be77cd249\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"0fc3e469-f85f-4a61-b1cc-769ce6f45e5b\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"1287c7ee-77d1-40ce-836a-f9900178f8d3\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"ticker\":\"SPXL\",\"has_marketcap\":false,\"id\":\"b85cdf0a-7f41-4792-8392-d97d548f86a6\",\"exchange\":\"ARCX\",\"price\":83.85,\"step\":\"asset\",\"dollar_volume\":4.8172328099999994E8},{\"name\":\"WisdomTree India Earnings Fund\",\"ticker\":\"EPI\",\"has_marketcap\":false,\"id\":\"95aaab5b-e6da-4811-9877-2edeeb801a1f\",\"exchange\":\"ARCX\",\"price\":30.67,\"step\":\"asset\",\"dollar_volume\":1.529816533E7},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"cc94a4f0-eb05-4743-9e20-34039f9ed189\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"da85470d-27ce-4fd4-a91a-74536ee8742e\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"name\":\"ProShares Ultra QQQ\",\"ticker\":\"QLD\",\"has_marketcap\":false,\"id\":\"50ac7df5-98c2-4083-88b4-cebaaaa5c7ec\",\"exchange\":\"ARCX\",\"price\":35.26,\"step\":\"asset\",\"dollar_volume\":1.6824665126E8},{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"e054dd9b-6fe6-40c6-96c3-875228a8a2d8\",\"exchange\":\"ARCX\",\"price\":31.37,\"step\":\"asset\",\"dollar_volume\":5.6195129461E8},{\"name\":\"ProShares Ultra MidCap400\",\"ticker\":\"MVV\",\"has_marketcap\":false,\"id\":\"4f20194b-0772-4369-9018-d75095a53535\",\"exchange\":\"ARCX\",\"price\":42.05,\"step\":\"asset\",\"dollar_volume\":130018.59999999999},{\"name\":\"Invesco DWA Utilities Momentum ETF\",\"ticker\":\"PUI\",\"has_marketcap\":false,\"id\":\"0c5d8a95-a3f4-4ab5-b4aa-aac1ef6ea77d\",\"exchange\":\"XNAS\",\"price\":30.77,\"step\":\"asset\",\"dollar_volume\":118956.81999999999},{\"name\":\"ProShares Ultra Semiconductors\",\"ticker\":\"USD\",\"has_marketcap\":false,\"id\":\"1cdca9cb-1a01-40e9-9fbe-dc75c197070c\",\"exchange\":\"ARCX\",\"price\":16.68,\"step\":\"asset\",\"dollar_volume\":2838452.28},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"b9d85973-60f9-4351-8d41-dfce03465d56\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"7\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"77dfb2db-34f6-4af7-9da7-aeb022d13b6d\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"6\",\"lhs-val\":\"TQQQ\",\"id\":\"b99904bf-89e0-4be6-9710-e5de00fc7a86\",\"comparator\":\"lt\",\"rhs-val\":\"-10\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"15040d9b-657b-424c-9e6c-a701d3888635\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"e8084a83-04f2-420e-944b-a7450f735751\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"2fa3ce33-cd9f-42b9-9284-7376bb2fb455\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"516ba346-fdd0-47a3-bc7d-eebb85ad14b1\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"5b471ddb-f2cb-4982-9dff-3872a4b3b15e\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"ticker\":\"SPXL\",\"has_marketcap\":false,\"id\":\"62aa236c-8137-4d6e-9dd1-deb3b40eebe6\",\"exchange\":\"ARCX\",\"price\":83.85,\"step\":\"asset\",\"dollar_volume\":4.8172328099999994E8},{\"name\":\"WisdomTree India Earnings Fund\",\"ticker\":\"EPI\",\"has_marketcap\":false,\"id\":\"084625c3-47c6-49f0-b7c5-51f1c72af38b\",\"exchange\":\"ARCX\",\"price\":30.67,\"step\":\"asset\",\"dollar_volume\":1.529816533E7},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"97d61dab-33d2-4374-9bb8-602e9a2bde08\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"0fed9614-7922-42b9-ab9e-f28e0c907af4\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"name\":\"ProShares Ultra MidCap400\",\"ticker\":\"MVV\",\"has_marketcap\":false,\"id\":\"f02f4ff0-2177-47e9-97df-fc2d8476c729\",\"exchange\":\"ARCX\",\"price\":42.05,\"step\":\"asset\",\"dollar_volume\":130018.59999999999}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"7\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"83123cdc-7f87-4c66-a677-4a6267808d7c\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"ea328cf7-cdbd-4076-9b9a-b9ed3e92f3cb\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"7a05033f-eec4-44a5-9ac3-fded717399fd\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"a9b97a88-a3cd-4eac-a211-11963f207c90\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"7e75259b-cebc-45e3-87ec-38c9670c408c\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"8fa216c1-7b2c-4a79-9f50-4a2ea1d0479d\",\"exchange\":\"ARCX\",\"price\":7.67,\"step\":\"asset\",\"dollar_volume\":7.270521856E7}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"8ad728fb-9c30-436f-ba75-de066a0b8631\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"exponential-moving-average-price\",\"is-else-condition?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"700b3013-0a6a-441c-890e-b911bdb2ef62\",\"comparator\":\"gt\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"0cc8e487-611c-4491-bac1-1cbff2b976e9\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"7aa474b5-e89b-4811-aebf-60602c266ffa\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"86c84974-9502-4adb-a979-941b193643db\",\"exchange\":\"ARCX\",\"price\":20.01,\"step\":\"asset\",\"dollar_volume\":3.0217437168E8},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"4ee1f5bb-60e5-4208-9856-30c7f1a69764\",\"exchange\":\"XNAS\",\"price\":61.32,\"step\":\"asset\",\"dollar_volume\":9.65597774064E9},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"f65e5196-3fbc-4fe7-a4fa-82ea6c5eadeb\",\"exchange\":\"ARCX\",\"price\":55.58,\"step\":\"asset\",\"dollar_volume\":1.1806370296E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"cb0ca80a-d003-40d6-b27b-4b2953937088\",\"exchange\":\"ARCX\",\"price\":70.73,\"step\":\"asset\",\"dollar_volume\":9.714480458100001E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"9c727ff2-dc2e-4082-82cd-5cef76409d84\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-return\",\"is-else-condition?\":false,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"2fabfb5d-7851-4580-9590-30f25b6b0423\",\"comparator\":\"gt\",\"rhs-val\":\"DBC\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"a2ef1c17-9cd0-4f03-9f00-bd1dde569750\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"29912c69-5886-40d8-ad94-411b156952b0\",\"step\":\"group\",\"name\":\"Defense | Modified\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"14498224-1ac9-4b15-b3e7-536d365b8ce0\",\"children\":[{\"id\":\"513be4c4-acd2-44fa-bfc3-cd77bf2c7e9f\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"0d394f60-2c80-4550-a6ab-97de11991a1c\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"defbfd81-684a-45ee-af98-cb45ae1aaedd\",\"exchange\":\"ARCX\",\"price\":20.01,\"step\":\"asset\",\"dollar_volume\":3.0217437168E8},{\"name\":\"WisdomTree India Earnings Fund\",\"ticker\":\"EPI\",\"has_marketcap\":false,\"id\":\"d2b78c6e-6028-4e83-a62d-d819e51d14e0\",\"exchange\":\"ARCX\",\"price\":32.5,\"step\":\"asset\",\"dollar_volume\":1.28180325E7},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"1401b0da-257a-4f50-9441-1866a8078b2e\",\"exchange\":\"ARCX\",\"price\":55.58,\"step\":\"asset\",\"dollar_volume\":1.1806370296E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"b5be0e21-2cac-4041-8c99-47f7babc7a72\",\"exchange\":\"ARCX\",\"price\":70.73,\"step\":\"asset\",\"dollar_volume\":9.714480458100001E8},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"c3685a64-4a72-41a6-8e26-f9095d2b2287\",\"exchange\":\"XNAS\",\"price\":64.38,\"step\":\"asset\",\"dollar_volume\":1.087537804458E10}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"add0ef4c-63bb-41a2-a70a-7fe90bbc90ab\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"standard-deviation-return\",\"is-else-condition?\":false,\"lhs-fn\":\"standard-deviation-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"DBC\",\"id\":\"601c7e42-1ad4-49ee-aa5d-b82404319076\",\"comparator\":\"gt\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"54d79a52-5cba-4e40-9ccb-56c87fbc0c61\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"22404a86-7f2f-4fb1-9930-8b7d8ec8dbf6\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"ae26c354-47e3-463c-9ffc-bb6d5c4e1caa\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"0b8896da-0f68-48d6-8fef-86d445c8b6ed\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"41f07f9d-a4c6-4f84-916e-7457e0132aeb\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"380ed81d-6306-4fbf-b21e-f41878383f57\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"2880772c-ad0b-4185-8c15-6e8dedd4320a\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":true}],\"collapsed?\":true}],\"weight\":{\"num\":100,\"den\":100}}]}],\"collapsed?\":false}],\"collapsed?\":false}]}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"UVXY\",\"id\":\"572a148b-3a19-48d9-adf9-f85f70fe9ae4\",\"comparator\":\"gt\",\"rhs-val\":\"84\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"e6a08c70-10da-472b-9914-d970b20113b7\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"2195137c-bee5-4889-ac45-3ade2654b107\",\"exchange\":\"BATS\",\"price\":12.69,\"step\":\"asset\",\"dollar_volume\":9.6779972826E8}],\"collapsed?\":false}]}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"UVXY\",\"id\":\"6d5e111f-0319-4fc4-9028-bf0b09164a4e\",\"comparator\":\"gt\",\"rhs-val\":\"74\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"45713fa4-05ee-4765-9ea0-ce86db9d1bd8\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"e97063ad-22b9-4a34-8d0b-7fe11606ac5b\",\"step\":\"group\",\"name\":\"Bear Stock Market - High Inflation - [STRIPPED] V2.0.2b | A Better LETF Basket | DJKeyhole ???? | BIL and TMV\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"82e5dd84-32ee-4b09-b916-8b3fa75f0036\",\"children\":[{\"id\":\"361fd946-f9dd-483e-bebf-3c3bc6a72cff\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"a784b12b-eb6d-4dec-8c63-8ccaced2e27d\",\"step\":\"group\",\"name\":\"A.B: Medium term TLT may be overbought*\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"4e931831-a55e-4d99-b9bc-53e212501859\",\"children\":[{\"id\":\"49404bfc-1578-42db-b8cf-6c568492fd2f\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"5ba6c84d-12c0-4f3c-8773-a78fc3536060\",\"step\":\"group\",\"name\":\"A.B.B.A: Risk Off, Rising Rates (TMV)*\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"c50ed473-13c4-4048-952b-d704d34032b2\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"d1544077-cf50-49a6-bb87-ebe0e6d4a413\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"09c17a9c-68ac-4af0-8994-b8989b9b8b56\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"5f58a2ee-3aa8-4237-b061-445bcdcb8ac8\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"dc778ce0-7db0-4d78-ad3e-9102d644d3a7\",\"step\":\"wt-cash-equal\",\"children\":[{\"children\":[{\"ticker\":\"TQQQ\",\"exchange\":\"XNAS\",\"name\":\"ProShares UltraPro QQQ\",\"id\":\"8022b9f4-123b-4d90-bb93-5bda7e9c2a12\",\"step\":\"asset\"},{\"ticker\":\"SPXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"id\":\"24e150e0-f9a2-48f3-be57-ef5ad3bc7b8d\",\"step\":\"asset\"},{\"ticker\":\"SOXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"id\":\"0111b19a-7510-47c7-8a65-65623727f7a5\",\"step\":\"asset\"},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"687251a2-39d7-4123-915a-c9807dbd712a\",\"step\":\"asset\"},{\"ticker\":\"TECL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"id\":\"fbd73469-8d94-437a-997b-c3ba3f4b41c3\",\"step\":\"asset\"}],\"select-fn\":\"top\",\"select-n\":\"3\",\"sort-by-fn\":\"cumulative-return\",\"id\":\"39f99e05-538d-4fc8-a4e1-25d997d0bbb3\",\"step\":\"filter\",\"sort-by-fn-params\":{\"window\":30}}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TQQQ\",\"id\":\"3d6c1a87-ba3c-4cd3-bb1f-8d6abaec38f1\",\"comparator\":\"lt\",\"rhs-val\":\"30\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"64b8dac4-c798-4879-bd74-f935b1a6a4b0\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"c5ea3ed5-e3e5-4978-b6bd-df66f57315d2\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"64332d03-8edc-4194-9c83-bc697641b25b\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"ee8de6e2-ed30-4884-9fef-d007631a9807\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"bf9288e6-363d-42ac-9b71-b35e9c819b1f\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9},{\"name\":\"ProShares UltraShort Euro\",\"ticker\":\"EUO\",\"has_marketcap\":false,\"id\":\"8d167401-4cab-4c73-949e-cca13ab74976\",\"exchange\":\"ARCX\",\"price\":34.69,\"step\":\"asset\",\"dollar_volume\":5517930.159999999},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"6e9c27bf-d6d9-4726-bfc5-1dd684328f09\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"b4d560e2-633a-4a94-afaf-848da5e8dc90\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"3\",\"lhs-window-days\":\"6\",\"lhs-val\":\"SPXU\",\"id\":\"d94bf85d-3138-47ce-826b-435b063501d6\",\"comparator\":\"lte\",\"rhs-val\":\"UPRO\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"68249f10-45eb-43d1-a9db-3473292a14eb\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"984dae34-80fb-4178-802d-3c10fa02930d\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"804656c5-df31-4f16-bac8-f127a1ae6e4b\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"c988587a-03a1-4cd2-9d74-b6166cf43a12\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"81544edd-ba2b-4922-ba81-e5b8c36f9e37\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"Direxion Daily Healthcare Bull 3x Shares\",\"ticker\":\"CURE\",\"has_marketcap\":false,\"id\":\"a0b3695b-be02-4a57-814a-81f4129c985e\",\"exchange\":\"ARCX\",\"price\":89.46,\"step\":\"asset\",\"dollar_volume\":5880205.8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"6c759577-a40b-479b-aff6-864603000070\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"ceca6d1f-7456-4feb-931f-044dae33eb38\",\"comparator\":\"lte\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"e9b0d1dd-35c0-4992-9ec3-22b49d79a009\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"5e0a7882-bf14-45b9-a601-cc31cfb1849b\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"fc0edbb5-b788-493e-94ba-64607d7a6e0a\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"79e282eb-a08d-4571-bd73-ccd212114513\",\"exchange\":\"BATS\",\"price\":16.19,\"step\":\"asset\",\"dollar_volume\":9.3964454544E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"11\",\"lhs-val\":\"TQQQ\",\"id\":\"9bca334c-7f17-47b8-9910-4dd0e9eaf986\",\"comparator\":\"gt\",\"rhs-val\":\"77\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"5faef255-929b-4921-8480-f6adceefa6e5\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"db053ed5-9dad-4358-b0d3-aa59e13fe7f8\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"81963190-9782-4fce-b595-4fd0b2971ede\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"335d84a0-0f52-444a-a115-3871c0cb0f8c\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"7239f9a1-2d11-48db-8835-ff04595e04bb\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"5e8b4a50-ba1e-464f-9c53-348e1bc29044\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"55650b88-d0e4-43ab-a69a-13e4b35cde55\",\"exchange\":\"ARCX\",\"price\":148.89,\"step\":\"asset\",\"dollar_volume\":8.982935702999999E7}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"7542d95a-e586-4014-9f59-41fc7b8e26de\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"TLT\",\"id\":\"cc866a13-d825-40a1-a656-343d516f2de7\",\"comparator\":\"lt\",\"rhs-val\":\"0\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"9d5662f4-4a35-4c38-bc14-c7444f7cb3d2\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"b6b46fa3-b560-4ff3-ae06-97f8a138d317\",\"step\":\"group\",\"name\":\"A.B.B.B: Risk Off, Falling Rates (TMF)*\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"a36319ce-fabd-4426-bb54-35f6f82b84f3\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"6af5fc5e-37ec-4bc3-9d7e-64aaa3c801f2\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"681b1b5d-55a0-4423-bfd8-25bdcf37fad1\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"93ba2885-cdb3-4368-bf47-85ac29dbad43\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"e6105e6f-88c8-4e54-bf1c-aec711520653\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"59ac63a1-ea8b-407c-8314-0307ce24daf5\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"a4adf6d0-e55b-4be0-b9a1-5c4e703b6606\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"b9f26f0d-9f67-400c-a34e-5f399ca839ca\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"624a92db-f941-4196-a7ca-a74d2c6fb792\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TQQQ\",\"id\":\"a36315fe-c0df-4b3b-9dcd-f55dac0cac26\",\"comparator\":\"lt\",\"rhs-val\":\"30\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"4fa18b61-d9a7-4321-892d-3d49997498ae\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"1e250ec5-4d06-47da-9fc4-73d32fbabae5\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"d20357c0-6c3e-419a-bc17-ba2f1c09825c\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"33725e6e-7cdd-49a0-88e1-2fea475356ee\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"d406c3c0-326c-4d3a-9616-40400f66993a\",\"exchange\":\"ARCX\",\"price\":35.4,\"step\":\"asset\",\"dollar_volume\":1.327053606E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"f99a8a31-1bcb-4c45-b067-26ce10d03366\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"cfc0b113-c850-4d3e-9b2f-6836615c33f8\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"0f683e1f-a56e-4585-b8f1-6274485d8189\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"2\",\"lhs-val\":\"UUP\",\"id\":\"bb9ebedb-e067-410b-be82-602815c3afc7\",\"comparator\":\"gte\",\"rhs-val\":\"1\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"c4f72f0d-c87b-4ed8-9bbe-2c5af59af80d\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"47f949a9-a100-4d80-88cd-e347716bbafd\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"86c6ffd9-5d4c-4f06-9fc4-2420cf257a55\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"88bd4c80-2dfe-49b3-8fc4-06e2df362d0a\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Energy Bull 2x Shares\",\"ticker\":\"ERX\",\"has_marketcap\":false,\"id\":\"5680b7e8-ae22-4972-a560-d737c0cc3452\",\"exchange\":\"ARCX\",\"price\":51.3,\"step\":\"asset\",\"dollar_volume\":1.7945037539999998E8},{\"name\":\"ProShares UltraShort Euro\",\"ticker\":\"EUO\",\"has_marketcap\":false,\"id\":\"599f4707-f6f7-485e-acc4-2fa544e1a0fc\",\"exchange\":\"ARCX\",\"price\":34.69,\"step\":\"asset\",\"dollar_volume\":5517930.159999999},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"e8cbcd69-8590-4354-b926-23d9d3e05d7d\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"d5b6fa09-9f6f-4a58-a7b9-80083cb8aa4f\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"moving-average-price\",\"rhs-window-days\":\"3\",\"lhs-window-days\":\"1\",\"lhs-val\":\"SPY\",\"id\":\"231d6834-df79-4817-b3c7-90e288a1708f\",\"comparator\":\"gte\",\"rhs-val\":\"-1\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"be359805-78b3-43d5-aeea-04fb51c7614c\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"d1658a28-2339-4d2e-80ec-d2c2b531a47f\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"bba95683-2e9b-4d79-9a5e-de5b9fe954a1\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"ea86e5a7-d57c-43c8-8d18-b6b5dcea2c44\",\"exchange\":\"ARCX\",\"price\":31.37,\"step\":\"asset\",\"dollar_volume\":5.6195129461E8},{\"name\":\"ProShares Ultra MidCap400\",\"ticker\":\"MVV\",\"has_marketcap\":false,\"id\":\"56343cb2-641d-463f-8462-9230cfc06f87\",\"exchange\":\"ARCX\",\"price\":42.05,\"step\":\"asset\",\"dollar_volume\":130018.59999999999},{\"name\":\"ProShares Ultra Semiconductors\",\"ticker\":\"USD\",\"has_marketcap\":false,\"id\":\"96369ec5-2091-49f3-b724-0002a5e3cef7\",\"exchange\":\"ARCX\",\"price\":16.68,\"step\":\"asset\",\"dollar_volume\":2838452.28}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"f5c96b63-5980-46c6-bdf6-0fb757bc3c60\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"e9b46b3c-b256-4810-a0de-72c3fd4a9bee\",\"comparator\":\"lte\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"63f47b48-5d9b-4629-8c89-cf0b5d0241fb\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"1c2dade6-d850-4499-9761-3854b4fdd232\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"dc06a9d5-93cb-4b11-995b-2b397f51d960\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"7d190161-19af-41d9-9646-f805d03135d3\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"4946ccca-6507-427d-b6ad-2204c0da90b4\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"11cd6748-7478-445e-81f9-74b14e0d4ce5\",\"exchange\":\"BATS\",\"price\":16.19,\"step\":\"asset\",\"dollar_volume\":9.3964454544E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"11\",\"lhs-val\":\"TQQQ\",\"id\":\"0bab603a-1a7b-40df-9c68-f3d20b88d257\",\"comparator\":\"gt\",\"rhs-val\":\"77\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"43a837bc-be4b-4142-9bcf-f8a45870689c\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"d9733743-59ee-4b8b-9855-5e08806a6a5e\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"e542dc17-54a0-4b75-ab7a-24fbfd59ae0d\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"6ab3a842-8cb2-4c8a-b216-711738d8316b\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"5ea4200e-ea13-4bf9-9bd0-96f88c0abe7d\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"37eef155-1e7e-4e5c-ae03-85dd075a61ab\",\"step\":\"wt-cash-equal\",\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"4d4e3a50-7767-4167-81dc-f7c767ca10b6\",\"exchange\":\"BATS\",\"price\":10.41,\"step\":\"asset\",\"dollar_volume\":7.6812945732E8}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"1\",\"lhs-val\":\"TQQQ\",\"id\":\"f804a34a-7389-4d26-8dac-638c5a8ba39b\",\"comparator\":\"gt\",\"rhs-val\":\"5.5\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"6d2251f4-d286-4b19-94a6-d927432f7007\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"830b6bac-68c9-4c0c-a972-1bdfb82944ba\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"27b7c063-0d26-4570-bca6-67d41b1de69a\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"816b3b5c-cd10-4ad8-85ab-b5f2a23c51ea\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"524650b1-04f0-4955-bb02-234dd4952f6c\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"3f8a60f9-a709-4843-b496-3d97cca7c791\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"d01524f5-b00b-4f42-a95a-845e73ed8bdd\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"d2f36911-a2a6-4826-a5c7-f8c706e1e00f\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"db45a48e-0758-4082-ba45-f0fac3ee5eb1\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"83827f84-2263-48fd-baa5-24317877f2f4\",\"exchange\":\"ARCX\",\"price\":28.27,\"step\":\"asset\",\"dollar_volume\":9.3641556481E8},{\"name\":\"Invesco DB US Dollar Index Bullish Fund\",\"ticker\":\"UUP\",\"has_marketcap\":false,\"id\":\"73bd0ffe-196d-48ee-bc5b-047809a3aea9\",\"exchange\":\"ARCX\",\"price\":30.15,\"step\":\"asset\",\"dollar_volume\":1.429251705E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"a99c5668-d6cc-4ef0-bd6f-15090ef01782\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167},{\"name\":\"ProShares Ultra Bloomberg Crude Oil\",\"ticker\":\"UCO\",\"has_marketcap\":false,\"id\":\"5741cdc2-74c7-4950-a5b1-61b93d800e1d\",\"exchange\":\"ARCX\",\"price\":29.97,\"step\":\"asset\",\"dollar_volume\":6.165467361E7}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"dd5e80d0-d17b-40c1-aab5-cadaf371600c\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed-specified-weight?\":false}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"6\",\"lhs-val\":\"TQQQ\",\"id\":\"9020d278-4b8e-45d1-a9c2-acd7f53dc5ff\",\"comparator\":\"lt\",\"rhs-val\":\"-10\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"17277225-a40d-471f-815e-8fe673594399\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"20ff1195-3ae2-4bee-8c6d-77129606bdb6\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"1bfc8a4e-1409-4980-97a9-fa2f7f9eb0b1\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"59d13821-028f-4611-b406-14bb7157197d\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"56b5150f-eca7-4764-a5c8-e81417f053ff\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"ba5a1154-1c36-4a99-82b0-cc0b2279d015\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"ticker\":\"SPXL\",\"has_marketcap\":false,\"id\":\"aa40c33a-5e48-4153-92bf-da8c6b019a71\",\"exchange\":\"ARCX\",\"price\":83.85,\"step\":\"asset\",\"dollar_volume\":4.8172328099999994E8},{\"name\":\"ProShares Ultra QQQ\",\"ticker\":\"QLD\",\"has_marketcap\":false,\"id\":\"fd326a05-2b7e-4837-9ed6-30f954c346dd\",\"exchange\":\"ARCX\",\"price\":35.26,\"step\":\"asset\",\"dollar_volume\":1.6824665126E8},{\"name\":\"ProShares Ultra Semiconductors\",\"ticker\":\"USD\",\"has_marketcap\":false,\"id\":\"6d836be9-efef-42dc-9cb6-ab7d4ee96909\",\"exchange\":\"ARCX\",\"price\":16.68,\"step\":\"asset\",\"dollar_volume\":2838452.28}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"b9bb6cfb-6fe5-471d-83f3-21969d21ef8b\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"17692601-b59c-44aa-92ee-d75f7ca2970b\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"dd942761-8f15-452e-8fa0-877bc54a9169\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"7c76a13f-483d-4e89-8115-d4b534c3852a\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"a84ab4ee-63b3-41ee-9222-c4c41a99227e\",\"exchange\":\"ARCX\",\"price\":28.27,\"step\":\"asset\",\"dollar_volume\":9.3641556481E8},{\"name\":\"Invesco DB US Dollar Index Bullish Fund\",\"ticker\":\"UUP\",\"has_marketcap\":false,\"id\":\"1461c9af-92d1-411f-acff-2884ac2270bc\",\"exchange\":\"ARCX\",\"price\":30.15,\"step\":\"asset\",\"dollar_volume\":1.429251705E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"1d168bc2-fa26-478d-a6c2-a749e882c1d3\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"0ee6dadb-13db-4f60-aa7d-bb889d1ddef7\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-return\",\"is-else-condition?\":false,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"b406a471-89bb-49ca-a75e-1a7ccd550cb8\",\"comparator\":\"gt\",\"rhs-val\":\"DBC\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"aedebbe4-c541-407f-9d99-d3be2e42b975\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"d694cf95-ab10-4c2b-8883-7ad991e991c2\",\"step\":\"group\",\"name\":\"Defense | Modified\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"238eda71-0b7b-4d20-8a88-891ada825606\",\"children\":[{\"id\":\"b8c9cc0d-a0b0-44c2-989a-231b4306a4a5\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"675f86e3-d95e-42d0-9879-69bdbb5115df\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares 1-3 Year Treasury Bond ETF\",\"ticker\":\"SHY\",\"has_marketcap\":false,\"id\":\"0f6fddba-ff65-42d8-936c-77e1b1a3dd86\",\"exchange\":\"XNAS\",\"price\":82.38,\"step\":\"asset\",\"dollar_volume\":6.516601524599999E8},{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"16f9eb7e-1835-476d-a09d-b5e1eacdb5c7\",\"exchange\":\"ARCX\",\"price\":30.97,\"step\":\"asset\",\"dollar_volume\":8.040002155799999E8},{\"name\":\"SPDR Gold Shares\",\"ticker\":\"GLD\",\"has_marketcap\":false,\"id\":\"b39e79b4-0a8c-4ee5-8ef0-7dea7d4177cb\",\"exchange\":\"ARCX\",\"price\":162.77,\"step\":\"asset\",\"dollar_volume\":6.6775562373E8},{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"6945fa17-291f-452c-ba56-2260545174ce\",\"exchange\":\"ARCX\",\"price\":20.01,\"step\":\"asset\",\"dollar_volume\":3.0217437168E8},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"7299ffb2-5db7-4347-ac9c-d2b4b88e3f1d\",\"exchange\":\"ARCX\",\"price\":55.58,\"step\":\"asset\",\"dollar_volume\":1.1806370296E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"c610fe93-035a-4148-95ab-90b582b27698\",\"exchange\":\"ARCX\",\"price\":70.73,\"step\":\"asset\",\"dollar_volume\":9.714480458100001E8},{\"name\":\"ProShares Ultra Bloomberg Crude Oil\",\"ticker\":\"UCO\",\"has_marketcap\":false,\"id\":\"ef5be8cf-0843-4e0f-a58a-95cefa4b179a\",\"exchange\":\"ARCX\",\"price\":28.2,\"step\":\"asset\",\"dollar_volume\":8.985865139999999E7},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"b01ac5bd-c6e8-46a8-bcd1-d803a742214e\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"5e9be1b0-aa02-419b-81c4-a8e242c57455\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"standard-deviation-return\",\"is-else-condition?\":false,\"lhs-fn\":\"standard-deviation-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"DBC\",\"id\":\"5e82eefe-ef6d-4307-a303-1eba9ac7c9ec\",\"comparator\":\"gt\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"f73df03d-0d1f-4b2e-8c00-ba7867673bba\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"3492d5d8-f9c6-466a-9740-d9b98140df96\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"ccbb4d6b-7d59-44ab-857a-ba4d04e38809\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"89304916-0dc4-4a45-97ad-1279990069b8\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"6aacabb3-319f-472b-9fcf-cb046119b8b2\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares Ultra Semiconductors\",\"ticker\":\"USD\",\"has_marketcap\":false,\"id\":\"80c8625f-0a77-442d-bda0-7786cbc15d03\",\"exchange\":\"ARCX\",\"price\":16.68,\"step\":\"asset\",\"dollar_volume\":2838452.28},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"afd0b13e-3f27-4522-a170-5628213fccb9\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"bbd51346-72cb-4c63-9663-f61c7f6ee21f\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"bd480257-5181-4859-ab75-8b8e50198c09\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"138f71c7-ab79-4bf9-995d-2c869f73e565\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"7e978b6a-077d-4534-b61d-c230b65465d1\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"43ea5b91-1f74-45b8-8e5a-a9f8b9247946\",\"exchange\":\"ARCX\",\"price\":28.27,\"step\":\"asset\",\"dollar_volume\":9.3641556481E8},{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"ada52721-6a09-4d52-9ed1-33df171ec9b8\",\"exchange\":\"ARCX\",\"price\":20.01,\"step\":\"asset\",\"dollar_volume\":3.0217437168E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"80fa2445-7f64-4dba-a6e5-997ec51f3d58\",\"exchange\":\"ARCX\",\"price\":44.99,\"step\":\"asset\",\"dollar_volume\":9.058357684200001E8},{\"name\":\"ProShares Ultra Bloomberg Crude Oil\",\"ticker\":\"UCO\",\"has_marketcap\":false,\"id\":\"f4cb68b3-4f7b-4515-8d62-961a71f88827\",\"exchange\":\"ARCX\",\"price\":28.2,\"step\":\"asset\",\"dollar_volume\":8.985865139999999E7},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"61c3e77b-92b1-4c22-8b24-380b919175f3\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"9cd35e41-f766-4fd5-b14d-e773f72db1b9\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}]}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"weight\":{\"num\":100,\"den\":100}}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"lhs-fn\":\"current-price\",\"rhs-window-days\":\"200\",\"lhs-val\":\"TLT\",\"id\":\"17b07699-a87b-4959-b6f5-364bf48d83b9\",\"comparator\":\"gt\",\"rhs-val\":\"TLT\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"15ca13e7-6c34-4684-a373-63be9a0991aa\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"f699479e-ea64-49f2-afc4-6dcbeae7d363\",\"step\":\"group\",\"name\":\"B: If long term TLT is trending down, safety: Long Term, 2 Least Volatile*\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"74838a35-93d5-4baf-be6e-9cad6d3719de\",\"children\":[{\"id\":\"4e6acf76-013d-428c-b5c3-1a1553d8cb22\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"797d930a-6c01-4f9e-ae8b-44dd2308003e\",\"step\":\"group\",\"name\":\"B.A.A: Risk Off, Rising Rates (TMV)* - LETF Basket^\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"7966be89-3398-4432-b495-f5e308c1e8aa\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"8f956314-0a76-4dce-8131-f0581989f6be\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"92e6d6da-3ede-41d0-a71e-548d9a73b00f\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"912b4d80-b101-4803-a9b3-f19c226f4551\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"8c31a440-d20e-4dcd-9cd8-94d750544b19\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"2e318d0f-2544-4b4c-b0fa-48fe401ada90\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"75aed837-dc5a-4982-932d-a4b7ba713e98\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"0788f8a2-b2ca-4fe6-ad79-c0d17d43ec41\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"c2bc36f7-0482-44da-b6b1-134afedc3b2e\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TQQQ\",\"id\":\"d35a683e-e95e-4ae2-8344-8330c8712f44\",\"comparator\":\"lt\",\"rhs-val\":\"30\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"b04f6d91-0da7-4e63-9099-c7c903878059\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"7091ca3a-a424-43e9-ae55-f5f97062b7d5\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"b18e7bc0-1f0d-4155-b6fb-482b8aa9dcfd\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"1addcd04-51f5-45de-aaa4-30eb0dee3b5c\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"a3ba5cf0-0774-4075-ab38-1e8664d9a955\",\"exchange\":\"ARCX\",\"price\":20.91,\"step\":\"asset\",\"dollar_volume\":5.3752632333E8},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"591cf1a3-5ae9-4307-b74d-6b6c8d7b60eb\",\"exchange\":\"ARCX\",\"price\":35.4,\"step\":\"asset\",\"dollar_volume\":1.327053606E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"faf65116-a1fc-4711-bc9d-a2bc6ca268af\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"8458698e-2fd8-4a0b-8099-0829423e17e2\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9},{\"name\":\"Direxion Daily Energy Bull 2x Shares\",\"ticker\":\"ERX\",\"has_marketcap\":false,\"id\":\"c6a0f250-f6fa-4dfc-8de5-7e335fd08543\",\"exchange\":\"ARCX\",\"price\":51.3,\"step\":\"asset\",\"dollar_volume\":1.7945037539999998E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"7a7b5894-d946-4066-8f9c-b9073343a5f6\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"2\",\"lhs-val\":\"UUP\",\"id\":\"77cc3f42-48ab-4e0f-bbdf-5e2bbfc0015c\",\"comparator\":\"gte\",\"rhs-val\":\"1\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"5ceb2e54-6786-4e40-9229-bed511eba7d7\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"ef88a4fd-0d4d-4fd1-b5f8-475aec63fea7\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"02e977ec-7e9f-4087-8057-92b549af597a\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"1b1496a4-543e-4f1d-b8b1-9b36489925c9\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"dbf13d4a-88e2-4198-abf2-3b45d853c549\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"c9f6b4b3-b351-4f3c-82d1-da8cbf9f9430\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9},{\"name\":\"WisdomTree India Earnings Fund\",\"ticker\":\"EPI\",\"has_marketcap\":false,\"id\":\"30f5d89d-20e2-490f-82bf-4fce80fda3fb\",\"exchange\":\"ARCX\",\"price\":32.13,\"step\":\"asset\",\"dollar_volume\":6708776.130000001}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"ea5d94c5-503f-4440-8dc2-62b17a31faed\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"4\",\"lhs-window-days\":\"5\",\"lhs-val\":\"SPXU\",\"id\":\"e8403030-8d40-49f3-9412-064d79cc238f\",\"comparator\":\"gte\",\"rhs-val\":\"UPRO\",\"step\":\"if-child\",\"collapsed?\":true},{\"id\":\"24bec395-527b-4296-a60c-d6e62b939ca2\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"7c24af08-6a7d-446c-82c5-eb8095983033\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"c2613548-b660-49f9-91c5-913fad5f00eb\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"2c91c6d6-bd70-4409-a02d-bf05016fdaf8\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"10601aff-86db-4315-abb5-baa3b6d81b95\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"20c907f7-513b-4db0-9e61-54985700e1b0\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"Direxion Daily Small Cap Bull 3x Shares\",\"ticker\":\"TNA\",\"has_marketcap\":false,\"id\":\"85758515-1dcc-4715-bdff-c0d49fa71500\",\"exchange\":\"ARCX\",\"price\":35.84,\"step\":\"asset\",\"dollar_volume\":5.7466253824E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"258c6efe-7f8f-4c9c-8924-2e44caf9bcd7\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"3\",\"lhs-window-days\":\"3\",\"lhs-val\":\"BIL\",\"id\":\"9deea0e3-0546-49c1-95b2-396c74eff97f\",\"comparator\":\"gte\",\"rhs-val\":\"TMV\",\"step\":\"if-child\"},{\"id\":\"b57a9560-b5d2-4885-bcc9-84d949bcd9f3\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"948766a5-f75a-4922-a9cf-c6cd5f2f03ad\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"9c8d5885-e954-440e-857c-9b99144c11ce\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"384ddc9f-9140-48df-806e-bd7047a03caa\",\"exchange\":\"ARCX\",\"price\":8.92,\"step\":\"asset\",\"dollar_volume\":1.04673400904E9},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"d2ddff76-4a3b-4040-8397-e834716a9a3a\",\"exchange\":\"ARCX\",\"price\":157.82,\"step\":\"asset\",\"dollar_volume\":9.906629694E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"92ca814d-e90e-4f07-b4ae-649be714c5a8\",\"exchange\":\"XNAS\",\"price\":20.95,\"step\":\"asset\",\"dollar_volume\":4.3542169102E9}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"3\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"12fc2792-1296-48f3-9191-f68bc7f0ffe2\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}]}]}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"f809accb-cfe5-424e-891a-8d1136b8f90a\",\"comparator\":\"lte\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"73e655ca-60d8-4594-b6ca-dc3d31094c44\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"4749694a-6e2a-47ba-99ca-5a8c5bb03696\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"03ae2624-6c87-4ad6-abdd-c618959ad033\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"19400835-41f4-442c-b1ee-e3f42a3c384e\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"c5c2e743-d747-4005-8687-36adadea001b\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"cf414a89-a2ca-47ef-8b32-acf2326cb06a\",\"exchange\":\"BATS\",\"price\":16.19,\"step\":\"asset\",\"dollar_volume\":9.3964454544E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"11\",\"lhs-val\":\"TQQQ\",\"id\":\"ea91f174-3c9e-44a1-9761-d6d8d8a1973f\",\"comparator\":\"gt\",\"rhs-val\":\"77\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"0aa25282-d4b1-4905-a470-03631f65b998\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"232af548-2a28-4c9e-8f67-1dae370220ed\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"1383c1b1-0d61-4fab-ac82-c309d94a26fa\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"2da79cdb-e153-47cb-9159-2b7d300e27dd\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"c13fdc2b-d9d9-4a63-9c6c-7f58a991574c\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"226cab3b-fa19-49c9-bc6a-4835d988838c\",\"step\":\"wt-cash-equal\",\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"af757ba8-14fb-4062-8d95-dfe351ad7bb0\",\"exchange\":\"BATS\",\"price\":10.41,\"step\":\"asset\",\"dollar_volume\":7.6812945732E8}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"1\",\"lhs-val\":\"TQQQ\",\"id\":\"76a5014b-02c7-452a-b3b9-aa80db40d239\",\"comparator\":\"gt\",\"rhs-val\":\"5.5\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"7acd0c35-3dc5-4891-82c4-b88976ffa403\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"88d51fb6-e309-432a-9ce3-81ce26074921\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"75e8a383-6961-4717-8fee-dc64914c99eb\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"e434807e-8827-465e-ab16-71d46267248c\",\"exchange\":\"ARCX\",\"price\":141.26,\"step\":\"asset\",\"dollar_volume\":4.3188126099999994E7}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"74466e73-980c-40c4-b5eb-cb58af7c73b6\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"6\",\"lhs-val\":\"TQQQ\",\"id\":\"66dbaaef-2966-4937-a1fb-76c04287f105\",\"comparator\":\"lt\",\"rhs-val\":\"-10\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"0fa5cce9-9cab-4e58-b872-da0d65809e57\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"873013c6-71fd-4bb8-bba9-574a9aef3bb3\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"6320a60d-6f65-4418-a239-b5a841bff29b\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"f4066460-a82b-47cb-a570-61fa999ecdf6\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"1a53b9e0-14aa-43eb-8dcc-b80403acafa3\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"9c3fe861-1274-4f63-8be4-6213de39c128\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"cbbeaeb4-4cdc-4676-9812-6a76333c1976\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"f2322aec-476c-432b-872a-1f432bd667ca\",\"exchange\":\"ARCX\",\"price\":148.89,\"step\":\"asset\",\"dollar_volume\":8.982935702999999E7},{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"5c5de1f7-2c94-40c5-9113-94cf3624f22e\",\"exchange\":\"ARCX\",\"price\":19.95,\"step\":\"asset\",\"dollar_volume\":1.6883044604999998E8}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"077584f3-3277-4830-bee3-2d423e51b3b4\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"b51ff738-df39-4344-81f2-82adac74dc71\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"f8e318e7-b9ab-4c03-a753-34624c94a024\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"446077ca-7e92-4ef5-8561-b297c02da976\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"8ce97ddd-dc48-42db-a851-fdcd4011e953\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"e5c27f38-8a10-45a9-8798-94fa59cf12ab\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"22\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"a31891c6-9893-4523-afba-43cd1ec9a09b\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}]}],\"rhs-fn\":\"moving-average-return\",\"is-else-condition?\":false,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"9f460f13-980c-4c66-978d-3d5adeb0c243\",\"comparator\":\"gt\",\"rhs-val\":\"DBC\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"45bc403f-1ac7-4a55-bb7d-651f07ec8b4b\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"d5021343-7bc8-45ce-a2c4-bdd8d118723e\",\"step\":\"group\",\"name\":\"Defense | Modified\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"214a4d3c-abb8-4f73-8d00-ca229fc5cc99\",\"children\":[{\"id\":\"924680f4-ab4c-4e64-bf14-5834bfec3a5d\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"b52296da-f8ff-4ae5-bbab-c6bb919d9689\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"95fb6181-a034-4e59-858c-7b12f517be05\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"9734aa68-a643-4fcc-9b72-e72de403bcef\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"6b8914b5-b184-4f1d-80de-2e489958ab07\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"0d2e090e-5536-4be5-b807-330495c5d25b\",\"exchange\":\"ARCX\",\"price\":141.26,\"step\":\"asset\",\"dollar_volume\":4.3188126099999994E7}],\"rhs-fn\":\"standard-deviation-return\",\"is-else-condition?\":false,\"lhs-fn\":\"standard-deviation-return\",\"rhs-window-days\":\"5\",\"lhs-window-days\":\"5\",\"lhs-val\":\"TMV\",\"id\":\"f92593dd-8bc1-4f3d-b3c1-28d87afd33c6\",\"comparator\":\"lte\",\"rhs-val\":\"DBC\",\"step\":\"if-child\"},{\"id\":\"65f2e138-cc23-43de-b9db-eef7ab36ce7f\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"name\":\"Invesco DB Commodity Index Tracking Fund\",\"ticker\":\"DBC\",\"has_marketcap\":false,\"id\":\"1b2ee486-da2b-49d6-bf4f-5fb68ccbc635\",\"exchange\":\"ARCX\",\"price\":25.33,\"step\":\"asset\",\"dollar_volume\":5.922121070999999E7}]}]}]}],\"rhs-fn\":\"exponential-moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"standard-deviation-return\",\"rhs-window-days\":\"100\",\"lhs-window-days\":\"10\",\"lhs-val\":\"DBC\",\"id\":\"8dd6c744-a83e-49a6-a4cf-76700ad238b8\",\"comparator\":\"gte\",\"rhs-val\":\"3\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"7d1a201d-7652-41d8-9fc5-7a3f5e1bd390\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"ae692df5-f75c-4356-ad8b-610558ddf361\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"b1df1048-7c94-4fa7-8166-65b00b9b6470\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"86b29f4d-27bc-4595-8ec4-5183c5dc9982\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"ebc930b2-4cd0-4ec2-970e-b52c2c04e651\",\"exchange\":\"ARCX\",\"price\":141.26,\"step\":\"asset\",\"dollar_volume\":4.3188126099999994E7},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"78b50151-c15a-4d10-8802-71a15ed49c1e\",\"exchange\":\"ARCX\",\"price\":80.05,\"step\":\"asset\",\"dollar_volume\":1.38192436325E9},{\"name\":\"ProShares UltraPro Short S&P500\",\"ticker\":\"SPXU\",\"has_marketcap\":false,\"id\":\"db189b2a-9bf0-405c-959d-5b705fb4c2af\",\"exchange\":\"ARCX\",\"price\":21.92,\"step\":\"asset\",\"dollar_volume\":1.14726053376E9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"44548e02-9f44-41ed-87b1-80a2787be695\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"c27ce911-8ce7-45d1-81ea-88944522a7eb\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"a5fb2cd0-8ae6-46cf-af14-b6891ae88fe5\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"ea193636-8d93-4182-a538-5a0b927c7f8d\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares MSCI EAFE ETF\",\"exch\":\"PCX\",\"typeDisp\":\"ETF\",\"type\":\"E\",\"exchDisp\":\"NYSEArca\",\"ticker\":\"EFA\",\"id\":\"d09a2705-3b0f-4381-ad53-e8a91b13ba9f\",\"step\":\"asset\"},{\"name\":\"iShares MSCI Emerging Markets ETF\",\"exch\":\"NYQ\",\"ticker\":\"EEM\",\"type\":\"E\",\"typeDisp\":\"ETF\",\"id\":\"ae733082-1c1b-49e6-8ca9-3dc497a5cf00\",\"exchDisp\":\"NYSE\",\"step\":\"asset\"},{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"c8613b01-de51-49e5-9fb8-7d07449a68ab\",\"exchange\":\"ARCX\",\"price\":20.01,\"step\":\"asset\",\"dollar_volume\":3.0217437168E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"d82167e5-565d-46fd-9f88-5450a37fb342\",\"exchange\":\"ARCX\",\"price\":44.99,\"step\":\"asset\",\"dollar_volume\":9.058357684200001E8},{\"name\":\"ProShares Ultra Bloomberg Crude Oil\",\"ticker\":\"UCO\",\"has_marketcap\":false,\"id\":\"85aef5d2-fc45-4600-8707-8ccdd13b83c8\",\"exchange\":\"ARCX\",\"price\":28.2,\"step\":\"asset\",\"dollar_volume\":8.985865139999999E7},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"c772abeb-21d9-4e4d-969e-e157db93a5c7\",\"exchange\":\"ARCX\",\"price\":141.26,\"step\":\"asset\",\"dollar_volume\":4.3188126099999994E7}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"fc768f7b-080a-4274-996e-62fd88f803f1\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"standard-deviation-return\",\"is-else-condition?\":false,\"lhs-fn\":\"standard-deviation-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"DBC\",\"id\":\"c6117bb4-9df3-4f2c-9588-8f0e8996ef67\",\"comparator\":\"gt\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"adfe4df4-fb1d-4f71-aaa4-006756581b5a\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"8c2bdb41-407a-4af6-bede-91bdd35cfaf4\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"bb22fa71-ee83-4182-8ef2-aa43ee013577\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"4e1a2e4b-3bd2-4ddc-8812-e70fab97895c\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"WisdomTree India Earnings Fund\",\"ticker\":\"EPI\",\"has_marketcap\":false,\"id\":\"b4f95c2d-bd82-4009-b5b4-55bff70768c9\",\"exchange\":\"ARCX\",\"price\":30.67,\"step\":\"asset\",\"dollar_volume\":1.529816533E7},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"9fce38d8-0aa7-47ec-964f-2c48425e7f34\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"9830c08a-caf8-4fd2-a3fe-9837668bfa67\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"eb966cba-3a19-4eff-976f-298e864c2a7e\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"2f358c42-883f-417e-8e3c-2bc8d798bf5c\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"d9f336cc-4c08-4db8-a310-4281de0276e2\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"69e7bf9c-7473-4a91-be01-fe1bc0fb2525\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"3e6a751f-dcd4-4bb4-9ed1-6749b1317cb5\",\"exchange\":\"ARCX\",\"price\":28.27,\"step\":\"asset\",\"dollar_volume\":9.3641556481E8},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"a3dc8940-1508-4d39-96e3-e0a5ddceb6df\",\"exchange\":\"ARCX\",\"price\":36.8,\"step\":\"asset\",\"dollar_volume\":1.218889968E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"c93a0d07-d87f-4652-9673-6dbd7eac7143\",\"exchange\":\"ARCX\",\"price\":44.99,\"step\":\"asset\",\"dollar_volume\":9.058357684200001E8},{\"name\":\"ProShares UltraShort Euro\",\"ticker\":\"EUO\",\"has_marketcap\":false,\"id\":\"a85886ea-0c8f-4555-8787-0ddc373f33f9\",\"exchange\":\"ARCX\",\"price\":34.69,\"step\":\"asset\",\"dollar_volume\":5517930.159999999},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"8806412e-e21c-4205-b0d4-5d98e169738e\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"0902a03b-c5a9-4362-86c9-96d4cafa71d4\",\"exchange\":\"ARCX\",\"price\":141.26,\"step\":\"asset\",\"dollar_volume\":4.3188126099999994E7}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"094fe4cd-b9e8-4748-8cc0-7f9b18b57b36\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"TLT\",\"id\":\"d1a9ba2a-1db5-45a4-9964-4fdee218f21f\",\"comparator\":\"lt\",\"rhs-val\":\"0\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"88222b4c-f746-41db-b86e-cab219e40ff7\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"5a52eeeb-27e9-4446-8bd6-c6b488fb1d15\",\"step\":\"group\",\"name\":\"B.A.B: Risk Off, Falling Rates (TMF)* - LETF Basket\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"2d78c0f1-992a-4be7-8f2d-2b37f078bf19\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"c78ca00d-42e1-459b-b4f3-ff62dcdb5478\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"334ca988-27c9-43a9-b15b-f5e1cb1dd3d8\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"81e529c5-e804-4233-ab54-a002ce7490e4\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"3dc373c9-49d2-45e4-9141-f58963d4d465\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"6551e816-0d6d-4332-9a0c-a71478cea2ed\",\"exchange\":\"ARCX\",\"price\":20.91,\"step\":\"asset\",\"dollar_volume\":5.3752632333E8},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"692dbaab-4d51-4bb7-b0f6-c7b57336727a\",\"exchange\":\"ARCX\",\"price\":35.4,\"step\":\"asset\",\"dollar_volume\":1.327053606E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"92b501e2-f6d8-4eea-a7db-62084e6ba82a\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"c661e405-1863-4fd4-81ed-c52b9c501769\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"cb0a6a5c-7eb9-44be-8d43-114774f14d56\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"1\",\"lhs-val\":\"SPY\",\"id\":\"bfe6d310-7294-4042-a101-2ff01815ca2b\",\"comparator\":\"lte\",\"rhs-val\":\"-2\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"b7a10f7a-406e-4af9-9bad-75dbd68873c4\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"c70874d7-47cf-4c4a-915c-c46b0ebce434\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"d5b45291-58da-4f2b-9e1c-485838cd0d60\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"e26e2098-a833-493d-9fc8-b5c74ddaa176\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"SPDR Bloomberg 1-3 Month T-Bill ETF\",\"ticker\":\"BIL\",\"has_marketcap\":false,\"id\":\"2e8551b7-8722-4d34-a918-ee5e83b45f8d\",\"exchange\":\"ARCX\",\"price\":91.44,\"step\":\"asset\",\"dollar_volume\":5.3686188791999996E8},{\"name\":\"iShares Core U.S. Aggregate Bond ETF\",\"ticker\":\"AGG\",\"has_marketcap\":false,\"id\":\"fedf86ef-7ef3-4909-934b-7b710d52618e\",\"exchange\":\"ARCX\",\"price\":96.34,\"step\":\"asset\",\"dollar_volume\":1.3850104298400002E9},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"fd780d93-7890-495c-804d-435550656e99\",\"exchange\":\"ARCX\",\"price\":7.67,\"step\":\"asset\",\"dollar_volume\":7.270521856E7}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"d9d4247c-aa1f-414a-8561-eaed464a6473\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"3\",\"lhs-window-days\":\"6\",\"lhs-val\":\"SPXU\",\"id\":\"3c5ced78-893c-4642-a118-d769bdd63a27\",\"comparator\":\"gte\",\"rhs-val\":\"UPRO\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"c4136f4c-9d6a-4d99-b7cb-9be4eb2452e9\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"6e8cac91-a865-4ead-a32b-1642692da142\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"1f2d133e-d71c-442e-8425-f711bd777b17\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"645d8257-9a38-444d-ab34-006fe78bf1c7\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"d175d615-ac91-4f54-a5bd-98d6874c5530\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"b0711eca-6f96-4e9d-9a0b-84b0d1109497\",\"exchange\":\"ARCX\",\"price\":31.37,\"step\":\"asset\",\"dollar_volume\":5.6195129461E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"180952c7-88af-4583-8d32-219f706315b0\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"3d03cca3-ae70-4ec1-b09c-e0253e34e3ce\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}]}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"90de4bd3-7809-4567-a36b-3b026ee45629\",\"comparator\":\"lte\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"8135c1dc-488e-41ef-8095-40bbebf37c50\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"1dc2c7d4-5bde-4e00-a0d5-76c4e5308bc5\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"9bec6738-b078-455b-90ba-41af916d1bea\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"3f974e2f-0165-4409-b974-73d0c8878768\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"65a30e49-27fe-48b1-aaa9-ef7c5191965b\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"c4fde9a2-36dd-4ae7-874c-4a8f067e8b5e\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"4be9d8cd-8f6c-42e3-ba19-da6f6e20f5fe\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"15f059f0-b636-40ad-87d8-c2d22d5eb3e4\",\"exchange\":\"BATS\",\"price\":16.19,\"step\":\"asset\",\"dollar_volume\":9.3964454544E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"11\",\"lhs-val\":\"TQQQ\",\"id\":\"82d4e73e-d5aa-4400-9813-bfdc0e452123\",\"comparator\":\"gt\",\"rhs-val\":\"77\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"b1e56166-5141-49f0-af22-6d5ca419fc2d\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"d197c28c-78de-43c3-a52d-e3f132bd3cfc\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"30c676da-8430-44f1-896d-eebccea3fd0d\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"6ace9f03-e5db-4c11-9a1e-b9ab7b20709f\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"83581990-f171-4726-b26d-222991029e5e\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"60ca8855-7b01-405e-97d4-c81f662d0af6\",\"step\":\"wt-cash-equal\",\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"7f931be8-58ed-46bf-a65c-44e51c24fb2e\",\"exchange\":\"BATS\",\"price\":10.41,\"step\":\"asset\",\"dollar_volume\":7.6812945732E8}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"1\",\"lhs-val\":\"TQQQ\",\"id\":\"077301db-b6a2-4724-a5ad-3234c38f0909\",\"comparator\":\"gt\",\"rhs-val\":\"5.5\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"e2da9c63-51bd-4f7a-9c22-91a2143e752f\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"702d8630-0f61-4a7b-bc73-b020ee915c3e\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"96411b05-6fe1-4533-8d8f-a3a7d188ee07\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"cba285ad-5915-46eb-843c-0dd3ce1f206b\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"ticker\":\"SPXL\",\"has_marketcap\":false,\"id\":\"6327773b-6b84-466a-98df-e77bd0c5b412\",\"exchange\":\"ARCX\",\"price\":83.85,\"step\":\"asset\",\"dollar_volume\":4.8172328099999994E8},{\"name\":\"WisdomTree India Earnings Fund\",\"ticker\":\"EPI\",\"has_marketcap\":false,\"id\":\"05fae476-26d3-4787-b03b-20ff7e625361\",\"exchange\":\"ARCX\",\"price\":30.67,\"step\":\"asset\",\"dollar_volume\":1.529816533E7},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"5a0b1565-c014-4241-88ab-a934bc303eb2\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"6ba88555-1875-40bd-9d16-1ea3a5a608e7\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"name\":\"ProShares Ultra QQQ\",\"ticker\":\"QLD\",\"has_marketcap\":false,\"id\":\"218de042-27a4-4c34-b92c-ccf319de5d47\",\"exchange\":\"ARCX\",\"price\":35.26,\"step\":\"asset\",\"dollar_volume\":1.6824665126E8},{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"3bbb11f6-b048-477b-8db3-fd56e47be3d9\",\"exchange\":\"ARCX\",\"price\":31.37,\"step\":\"asset\",\"dollar_volume\":5.6195129461E8},{\"name\":\"ProShares Ultra MidCap400\",\"ticker\":\"MVV\",\"has_marketcap\":false,\"id\":\"8937ba22-3f35-4acf-8d90-a112ce3492b0\",\"exchange\":\"ARCX\",\"price\":42.05,\"step\":\"asset\",\"dollar_volume\":130018.59999999999},{\"name\":\"Invesco DWA Utilities Momentum ETF\",\"ticker\":\"PUI\",\"has_marketcap\":false,\"id\":\"39cfc6ff-607d-4a74-a6e2-753381f0c71b\",\"exchange\":\"XNAS\",\"price\":30.77,\"step\":\"asset\",\"dollar_volume\":118956.81999999999},{\"name\":\"ProShares Ultra Semiconductors\",\"ticker\":\"USD\",\"has_marketcap\":false,\"id\":\"47a6f40e-7984-4de4-9d27-6cbce85f711f\",\"exchange\":\"ARCX\",\"price\":16.68,\"step\":\"asset\",\"dollar_volume\":2838452.28},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"9e1d2781-3b0d-4d25-a548-f33c58271e7f\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"7\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"28f8a9df-ce7e-4ad3-9442-f8602d03bf6d\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"6\",\"lhs-val\":\"TQQQ\",\"id\":\"73d81c99-931c-4e17-b697-bbb5ff3993b0\",\"comparator\":\"lt\",\"rhs-val\":\"-10\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"665a94c0-ed5d-481d-aea2-8b9f86465f16\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"82f9b070-7f76-4102-a575-a1b158734ec3\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"aeaca2cf-9c2d-4853-8fbc-fa53ea35f08b\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"f3ffadbb-9413-4de3-907a-237c7eb77070\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"b051575b-cb8b-4919-ae9a-7f983b33f587\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"ticker\":\"SPXL\",\"has_marketcap\":false,\"id\":\"e92a90af-6208-47f1-b6ec-cd2250392a95\",\"exchange\":\"ARCX\",\"price\":83.85,\"step\":\"asset\",\"dollar_volume\":4.8172328099999994E8},{\"name\":\"WisdomTree India Earnings Fund\",\"ticker\":\"EPI\",\"has_marketcap\":false,\"id\":\"6749e405-a31c-42b5-bdb6-ec37decd90e9\",\"exchange\":\"ARCX\",\"price\":30.67,\"step\":\"asset\",\"dollar_volume\":1.529816533E7},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"b56614bf-2f6c-4046-9bd7-7162d979debe\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"3cb0fd5b-a2ec-4b70-bd3e-07bea38e2243\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"name\":\"ProShares Ultra MidCap400\",\"ticker\":\"MVV\",\"has_marketcap\":false,\"id\":\"348b2ae2-f9a4-4266-8d1e-16ea212652eb\",\"exchange\":\"ARCX\",\"price\":42.05,\"step\":\"asset\",\"dollar_volume\":130018.59999999999}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"7\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"1ba0d459-0423-4f84-8a6a-fb2d21b2728c\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"2498bcf2-5dc3-44b7-ac53-46e8ddd3e4f2\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"cb7691f2-3713-4f72-865b-47c72645293b\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"1811a082-ab90-43cc-9186-4a626ad741de\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"04e9852c-7955-4ec2-85c3-22fb7c49c6dc\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"76c0225a-060d-41d9-9571-54a7f551be4c\",\"exchange\":\"ARCX\",\"price\":7.67,\"step\":\"asset\",\"dollar_volume\":7.270521856E7}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"09e04572-0dcc-4143-9790-19ef6f540d90\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"exponential-moving-average-price\",\"is-else-condition?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"bdd7fbdd-c22b-4f37-bfaf-0360292e5a36\",\"comparator\":\"gt\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"b4004ca5-e696-4f98-9f8c-08d6e3a55a2f\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"b0b8b987-812e-49d0-b486-5ec68e7c7c5a\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"88cf880a-d177-4a88-805c-99cb0021c08b\",\"exchange\":\"ARCX\",\"price\":20.01,\"step\":\"asset\",\"dollar_volume\":3.0217437168E8},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"383e97f0-2e1d-4c68-934d-08435ae6ff95\",\"exchange\":\"XNAS\",\"price\":61.32,\"step\":\"asset\",\"dollar_volume\":9.65597774064E9},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"ed779805-eaef-4340-9530-e96a4fd08e41\",\"exchange\":\"ARCX\",\"price\":55.58,\"step\":\"asset\",\"dollar_volume\":1.1806370296E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"b874a34a-fefe-435b-a5a9-eac375182742\",\"exchange\":\"ARCX\",\"price\":70.73,\"step\":\"asset\",\"dollar_volume\":9.714480458100001E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"c5f5a2c4-6890-426d-8fab-4f301b1ba11b\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-return\",\"is-else-condition?\":false,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"fcf05c47-b7e5-41c7-b38b-c91b04774dff\",\"comparator\":\"gt\",\"rhs-val\":\"DBC\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"63a40ea5-ff20-48c9-82ac-9097cff05b12\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"615a05d0-9441-42fe-8f66-5279bfd0e97c\",\"step\":\"group\",\"name\":\"Defense | Modified\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"ffa3b721-8d6e-418a-a41f-d337a59a382b\",\"children\":[{\"id\":\"697a0ba9-0a03-4f79-b031-71ba8223f342\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"7885147e-4c36-419b-bcaa-22ed8d83d167\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"19456ad7-82c0-4859-a154-1b3af42235fa\",\"exchange\":\"ARCX\",\"price\":20.01,\"step\":\"asset\",\"dollar_volume\":3.0217437168E8},{\"name\":\"WisdomTree India Earnings Fund\",\"ticker\":\"EPI\",\"has_marketcap\":false,\"id\":\"6f045e02-7ced-43ea-9ff3-c689a5c889c2\",\"exchange\":\"ARCX\",\"price\":32.5,\"step\":\"asset\",\"dollar_volume\":1.28180325E7},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"1110a185-1352-4c9b-8427-072ffb15900c\",\"exchange\":\"ARCX\",\"price\":55.58,\"step\":\"asset\",\"dollar_volume\":1.1806370296E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"997cf8be-95d9-4c96-a1d1-00d36da4d71d\",\"exchange\":\"ARCX\",\"price\":70.73,\"step\":\"asset\",\"dollar_volume\":9.714480458100001E8},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"c99b67f5-9bfe-4e58-b33b-3ff03746a781\",\"exchange\":\"XNAS\",\"price\":64.38,\"step\":\"asset\",\"dollar_volume\":1.087537804458E10}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"15b566a3-131b-4e12-9c42-879b5746bc37\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"standard-deviation-return\",\"is-else-condition?\":false,\"lhs-fn\":\"standard-deviation-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"DBC\",\"id\":\"f2646b51-1878-47f8-ab7b-7d13831ce6f4\",\"comparator\":\"gt\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"36d8cf2a-0084-44b5-a185-6c1410d04803\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"2883a9fc-1f04-492b-a6fa-80c0bc4c75cd\",\"step\":\"wt-cash-equal\",\"children\":[{\"children\":[{\"ticker\":\"TQQQ\",\"exchange\":\"XNAS\",\"name\":\"ProShares UltraPro QQQ\",\"id\":\"90273871-a24a-4abf-b15b-2e41fd741552\",\"step\":\"asset\"},{\"ticker\":\"SPXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"id\":\"a6322d73-8a14-4869-b41d-2b8ffa922a50\",\"step\":\"asset\"},{\"ticker\":\"SOXL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"id\":\"9a9b9588-abf5-4860-9a6e-e0f76abdb705\",\"step\":\"asset\"},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"c110121d-8ba8-45a8-9d6e-03e2b89d95c0\",\"step\":\"asset\"},{\"ticker\":\"TECL\",\"exchange\":\"ARCX\",\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"id\":\"9692b1f7-842e-402e-bedb-9caaab4f32ce\",\"step\":\"asset\"}],\"select-fn\":\"top\",\"select-n\":\"3\",\"sort-by-fn\":\"cumulative-return\",\"id\":\"f3acb8e0-584d-492f-8acb-fee93d8b4bf5\",\"step\":\"filter\",\"sort-by-fn-params\":{\"window\":30}}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}],\"weight\":{\"num\":100,\"den\":100}}]}],\"collapsed?\":false}],\"collapsed?\":false}]}]}],\"collapsed?\":false}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}]}]}],\"collapsed?\":false}]}]}],\"collapsed?\":true,\"weight\":{\"num\":\"50\",\"den\":100}},{\"id\":\"3af74d2c-5e58-445f-8275-75fce959f483\",\"step\":\"group\",\"name\":\".V3.0.4 7/40 2012 | ?? Beta Baller + TCCC ?\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"b6ac5943-d00e-45d9-bf6e-a504d0ca3c2c\",\"children\":[{\"id\":\"f91094ac-8db5-40a8-94ee-18c96c4e4b01\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"da8c7600-d8e4-483e-8c35-1d69cf692208\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"fc9a43a1-7fa3-4419-98f8-e001985b8263\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"cfd3f5ce-90ef-4142-af02-019e509320b0\",\"step\":\"group\",\"name\":\"Overbought S&P. Sell the rip. Buy volatility.\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"03dc33cf-883f-4597-9514-49dd30b54c95\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"a0304feb-b119-4b81-afd1-e7128df30205\",\"exchange\":\"BATS\",\"price\":11.45,\"step\":\"asset\",\"dollar_volume\":4.5342449984999996E8},{\"name\":\"ProShares VIX Short-Term Futures ETF\",\"ticker\":\"VIXY\",\"has_marketcap\":false,\"id\":\"7bccb252-b182-4683-a1ad-1a3a93b23668\",\"exchange\":\"BATS\",\"price\":15.84,\"step\":\"asset\",\"dollar_volume\":1.4911915392E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"12\",\"weight\":{\"num\":\"80\",\"den\":100},\"id\":\"180dd4a0-067f-4023-9cd9-2bf5d1c24b7e\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\"}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"7\",\"lhs-val\":\"SPY\",\"id\":\"51c538d4-6f0c-44d9-bc30-d6c38f92ac40\",\"comparator\":\"gt\",\"rhs-val\":\"75\",\"step\":\"if-child\"},{\"id\":\"9deda23f-02fa-42c6-a341-0437cf71ce40\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"cec0ce3b-c333-470c-83eb-d12564150962\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"4b405a25-dafd-47e4-9299-cdced5b21790\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"60554365-a869-4fa8-b651-6fa38527fcbb\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"c65583e4-9294-4b5b-95cf-c2ab423e97cd\",\"exchange\":\"ARCX\",\"price\":13.87,\"step\":\"asset\",\"dollar_volume\":2.19211018399E9},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"68892ea1-9acb-4974-b76e-36f020f795ed\",\"exchange\":\"XNAS\",\"price\":22.96,\"step\":\"asset\",\"dollar_volume\":7.24194747976E9},{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"edb01110-01b4-4c05-ab75-aa3c23c7ba87\",\"exchange\":\"ARCX\",\"price\":29.43,\"step\":\"asset\",\"dollar_volume\":1.7871923727E8},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"23961e6f-e389-4ba4-aeb1-f8c5ef4676a4\",\"step\":\"asset\"}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"12\",\"id\":\"e84b0ea3-fd60-439a-bd38-8af6e1324e0f\",\"sort-by?\":true,\"step\":\"filter\"}]}],\"rhs-fn\":\"moving-average-return\",\"is-else-condition?\":false,\"rhs-fixed-value?\":false,\"lhs-fn\":\"current-price\",\"rhs-window-days\":\"2\",\"lhs-window-days\":\"5\",\"lhs-val\":\"SOXL\",\"id\":\"c17f3892-0471-4691-afec-d986f7837ee9\",\"comparator\":\"gt\",\"rhs-val\":\"SOXL\",\"step\":\"if-child\"},{\"id\":\"9e6e12ef-729b-4a67-9a82-28ecc206abe5\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"e0981ede-2ce3-40af-b424-0872c67ac68e\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"9d138bd9-32dc-4438-babe-430ab0c1bdec\",\"exchange\":\"ARCX\",\"price\":32,\"step\":\"asset\",\"dollar_volume\":1453642752},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"434f5115-6cbe-4b86-937b-ca7a689af78c\",\"exchange\":\"XNAS\",\"price\":43.67,\"step\":\"asset\",\"dollar_volume\":8.059458332200001E9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"12\",\"id\":\"508911f2-7944-4980-8d5c-b7ca3a5ac9f4\",\"sort-by?\":true,\"step\":\"filter\"}]}]}]}]}]}]}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"40\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"9cf1fc15-bf4e-4bdb-b15a-a087d3daf11e\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"85da289f-fd2c-4e5f-be57-bf2704acc307\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"30f8c78e-e7b4-47e6-a25c-e874850f5267\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"fac38dbb-c7ff-425f-b661-258e9aa6df1d\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"3c9ce2bf-7579-4e94-8390-db302f4df023\",\"step\":\"group\",\"name\":\"Extremely oversold S&P (low RSI). Double check with bond mkt before going long\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"080ec2b1-cb00-4910-afe2-89d7bdd6af8c\",\"children\":[{\"id\":\"ed400367-2856-4fad-afec-3dfbfcb0d6aa\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"aeaf67eb-4ef9-4926-aa0e-41ddf1ba97e3\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"cb3ba385-ac94-470f-92a9-ea8b6ce84ab2\",\"exchange\":\"ARCX\",\"price\":75.59,\"step\":\"asset\",\"dollar_volume\":1.57344069699E9},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"cc950f91-4751-4a7f-aae3-edef136eb2fa\",\"exchange\":\"XNAS\",\"price\":63.2,\"step\":\"asset\",\"dollar_volume\":9.8760366064E9}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"7\",\"id\":\"34f44f01-3ae9-4cc8-82b1-05e09c9c46d2\",\"sort-by?\":true,\"step\":\"filter\"}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"8\",\"lhs-window-days\":\"8\",\"lhs-val\":\"BSV\",\"id\":\"7413552a-069b-4a18-83dc-fb0dff5c2c28\",\"comparator\":\"lt\",\"rhs-val\":\"SPHB\",\"step\":\"if-child\"},{\"id\":\"fa62d400-e358-4e1d-b8e0-2e1ab437b180\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"a8795e8a-4a26-4729-98e0-7c2965da5715\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"85584514-019a-4505-92ca-ba156fc5b0b2\",\"exchange\":\"ARCX\",\"price\":13.03,\"step\":\"asset\",\"dollar_volume\":1.27717077433E9},{\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"ticker\":\"SPXL\",\"has_marketcap\":false,\"id\":\"f9b61b80-89da-4148-ad68-2526496a0eb6\",\"exchange\":\"ARCX\",\"price\":75.19,\"step\":\"asset\",\"dollar_volume\":1.03091986416E9},{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"e68315ba-7e8f-46b6-bcaa-f313e65f901a\",\"exchange\":\"ARCX\",\"price\":29.43,\"step\":\"asset\",\"dollar_volume\":1.7871923727E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"22f1a951-d807-401d-a64a-0f85aa20c7cf\",\"exchange\":\"ARCX\",\"price\":9.61,\"step\":\"asset\",\"dollar_volume\":2.1763240372E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"2f288868-d2bf-4deb-8aae-550bbe4417bd\",\"exchange\":\"ARCX\",\"price\":39.76,\"step\":\"asset\",\"dollar_volume\":4.198274304E8},{\"name\":\"ProShares Ultra Semiconductors\",\"ticker\":\"USD\",\"has_marketcap\":false,\"id\":\"b37055ab-d178-4f36-83dc-7e9c84c06d9d\",\"exchange\":\"ARCX\",\"price\":20.31,\"step\":\"asset\",\"dollar_volume\":3435416.19},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"75a61a9c-7a9d-44d8-a0aa-a0f8d5f45f69\",\"exchange\":\"XNAS\",\"price\":23.41,\"step\":\"asset\",\"dollar_volume\":4.25254404161E9},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"dd718026-082e-4c55-8d3c-cf66328c4d5c\",\"step\":\"asset\"}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"18\",\"id\":\"bc313f35-1d3d-4d8b-9c78-6904ccbf6de4\",\"sort-by?\":true,\"step\":\"filter\"}]}]}]}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"6\",\"lhs-val\":\"SPY\",\"id\":\"e9b03e56-ab9c-47b3-bd7c-4eff8cce6c93\",\"comparator\":\"lt\",\"rhs-val\":\"27\",\"step\":\"if-child\"},{\"id\":\"a86e4631-953b-4ccf-8be4-a6cb8af1289f\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"4fc8fe88-6ee3-4ba4-b1bf-5196d41d4623\",\"step\":\"group\",\"name\":\"V0.2.1 | TCCC Stop the Bleed ? | DJKeyhole ???? | 1/2 of Momentum Mean Reversion\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"e825f0a6-0ef7-4890-9607-fb4b736f4e40\",\"children\":[{\"id\":\"87cfd022-e05f-4a83-8119-7a4e7582b6a6\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"b7cff22e-98f0-46dd-afe4-3a9e4017e8ff\",\"step\":\"group\",\"name\":\"V1.2 | Five and Below | DJKeyhole | No Low Volume LETFs | Belcampo69 changed for > AR removed 1\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"ef2c639f-44f3-41d4-bcf0-86c19452b5f5\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"8a4f90bc-2afb-4069-815a-741842ffd6c0\",\"exchange\":\"ARCX\",\"price\":13.03,\"step\":\"asset\",\"dollar_volume\":1.27717077433E9},{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"03523996-ea97-4311-9dd2-2263542b3e8f\",\"exchange\":\"ARCX\",\"price\":29.43,\"step\":\"asset\",\"dollar_volume\":1.7871923727E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"0df7e235-352d-437a-a393-7da1da17614e\",\"exchange\":\"ARCX\",\"price\":9.61,\"step\":\"asset\",\"dollar_volume\":2.1763240372E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"41bfa461-89c4-494b-9bdc-29fa502c4943\",\"exchange\":\"ARCX\",\"price\":39.76,\"step\":\"asset\",\"dollar_volume\":4.198274304E8},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"2805fbbf-3ab8-4cd1-adf4-dad952d575dc\",\"step\":\"asset\"}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"17\",\"id\":\"012ad3e2-e58d-4391-90c3-b7d2d3924029\",\"sort-by?\":true,\"step\":\"filter\"}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"SPY\",\"id\":\"b36fe356-68d1-4377-b579-4196348539e2\",\"comparator\":\"lt\",\"rhs-val\":\"30\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"fb14be2a-fa4a-4413-91fa-987231e227a5\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"31d74705-1184-4456-95e3-f6e5f5c56f88\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"bcec8a09-2bcc-4241-92b2-534006797d69\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"8e649688-a978-46ae-94e3-f36b1b62aa41\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"dd2146d0-0e51-4c1b-9bec-19a6c82a3ed2\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"d331c075-cd74-4549-892f-613b450ce60c\",\"step\":\"group\",\"name\":\"Bear Stock Market - High Inflation - [STRIPPED] V2.0.2b | A Better LETF Basket | DJKeyhole ???? | BIL and TMV\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"ee9820ca-acd6-4fe2-845d-d0e738160c20\",\"children\":[{\"id\":\"35c71160-d51a-4e51-a8b6-b72eeba980ba\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"db9fed03-35af-473d-bf24-b4f7e46fa017\",\"step\":\"group\",\"name\":\"A.B: Medium term TLT may be overbought*\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"094019f9-ba40-4734-8084-7e0a20d00612\",\"children\":[{\"id\":\"713e1c21-05c6-4b65-ac10-2d1753321210\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"37e8ade1-db20-4f04-a70f-272b28c18492\",\"step\":\"group\",\"name\":\"A.B.B.A: Risk Off, Rising Rates (TMV)*\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"16ffd681-42d6-47ed-8c4b-8e8f5751b839\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"6c61ef24-ab10-4724-8e40-0c04d969461b\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"2cde05b4-c2da-4bb5-9c66-813d2575ed17\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"c437db45-54ae-49cf-9d2a-4e63f1268738\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"59b6b8be-e0d9-4804-ab67-cf3e2ac4c34a\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"29526a7a-8500-45a1-9f23-8f16ad4aa507\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"576436ee-bbed-4233-9ca1-d1815cc5f563\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"e10cbab9-e59d-4f21-90a8-627b69202789\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"8cd2daaf-5b73-46f3-b9bc-0a4e8eb74763\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"4833fea9-1b78-4c69-a8f8-1872739c9539\",\"step\":\"asset\"}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"6f202e78-50cf-40ec-8ed7-e9cfd931da4f\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TQQQ\",\"id\":\"5c801d33-e4eb-4436-b62d-a885cf54b95a\",\"comparator\":\"lt\",\"rhs-val\":\"30\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"51a76b84-7ed8-4d55-bbb4-f0b25b578e77\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"13ded061-1d8d-469f-948d-202108bcb843\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"a44b7d1f-f12b-43da-ac2a-e0ab10853ec8\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"62704481-6f63-4975-af9d-1359117b5dac\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"27d0a525-edd0-4f6c-82d7-03fc0a7395ab\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9},{\"name\":\"ProShares UltraShort Euro\",\"ticker\":\"EUO\",\"has_marketcap\":false,\"id\":\"c854c6b3-41ad-46d0-80a3-d2a30a42e8cf\",\"exchange\":\"ARCX\",\"price\":34.69,\"step\":\"asset\",\"dollar_volume\":5517930.159999999},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"c6196500-302d-40d0-ac7a-6ad28173f34f\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"23718b3a-2ae9-4b4c-a8da-899d1da3ec43\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"3\",\"lhs-window-days\":\"6\",\"lhs-val\":\"SPXU\",\"id\":\"0c6cc8fe-39a7-480b-a2fe-1b325a50c222\",\"comparator\":\"gte\",\"rhs-val\":\"UPRO\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"d7f46e46-3a12-42ae-9a23-0c4569724b3c\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"b4a1cf14-8c97-4d0f-b3c1-b8e36815fb32\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"683044ff-c5e4-4d3b-8991-16bb1f9ca397\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"c654315a-382d-45bc-94fb-db9db5234dee\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"88c23b30-5e4f-4832-94f4-cd6592f12425\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"Direxion Daily Healthcare Bull 3x Shares\",\"ticker\":\"CURE\",\"has_marketcap\":false,\"id\":\"c09c3917-55c8-4698-b7ea-c18d3ba6dd47\",\"exchange\":\"ARCX\",\"price\":89.46,\"step\":\"asset\",\"dollar_volume\":5880205.8},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"49dcd606-7f0b-4bda-86c7-a48231ca668a\",\"step\":\"asset\"}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"52ca70a4-8387-47ca-9c28-1a68a7e0ebdb\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"dd1f9cb5-a1d1-4c48-a51b-1169d7eb66e4\",\"comparator\":\"lte\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"9081b5c2-5fac-405b-8640-05350d028864\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"17d2dc35-bcbc-40c7-b5cc-793d4410b03e\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"7b0b3dc1-316f-48ea-b629-865d12ba9bff\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"bd529451-7cd8-4198-8568-7b0b0416741e\",\"exchange\":\"BATS\",\"price\":16.19,\"step\":\"asset\",\"dollar_volume\":9.3964454544E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"11\",\"lhs-val\":\"TQQQ\",\"id\":\"6fdc40e7-aa48-4059-811b-98671257c4a2\",\"comparator\":\"gt\",\"rhs-val\":\"77\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"8adacdfd-ac98-4740-986e-7c0a885968a0\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"26b2249c-814a-421d-8dd4-4e3e576dd004\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"a419b714-6df6-47fb-a9c2-9326e70358f7\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"f581b4fa-f74d-45ec-8e0c-aef27d3a2aa4\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"43c3527a-64ac-4703-8d1c-3128b58be392\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"ec7e371f-b4a7-4638-bfef-d8101c0b5eea\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"ddde15ae-8967-4731-ac1f-f4df5df36028\",\"exchange\":\"ARCX\",\"price\":148.89,\"step\":\"asset\",\"dollar_volume\":8.982935702999999E7},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"a393a043-c4c4-4b2a-baf4-ffca4849796b\",\"step\":\"asset\"}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"fec1f227-4fb5-4cc5-b5e4-7eb936d4ee05\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"TLT\",\"id\":\"6224e1d9-e350-423b-9556-470f11b12a05\",\"comparator\":\"lt\",\"rhs-val\":\"0\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"2723cdfb-8bbd-4a0f-9f01-808403ef9e60\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"4935e873-9b2e-4e20-8b9c-7096d260cf69\",\"step\":\"group\",\"name\":\"A.B.B.B: Risk Off, Falling Rates (TMF)*\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"3e39bcba-d1ac-4219-9803-ddf6f1c70c7d\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"c67d9d3b-a501-499b-bca2-3960d11365af\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"85d7f34e-4936-4b8d-b58b-7e9596885d46\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"e96a19d0-ea4d-4b9d-9bab-02b47b3b4979\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"9c818799-669c-4209-a6ab-ca87001a12dc\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"86d3eedf-ecb3-40b2-9b56-f732f577d415\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"97226e5c-ee64-4318-8208-5b55f7aa7167\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"1106922b-087e-442c-8265-97d6aa11873c\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"d59355f5-d6ad-4e96-b5a7-f0a5a15acd48\",\"step\":\"asset\"}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"893b095b-ded1-401f-ac61-81799c371ad7\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TQQQ\",\"id\":\"baef6723-dc85-4fb3-8298-076ed6698b4f\",\"comparator\":\"lt\",\"rhs-val\":\"30\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"17bd387e-49a6-45b5-8cf0-210f44fd24d8\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"16b6817d-b496-4a4a-9657-d0b177ef2639\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"d0d31baf-b5be-493a-837d-24ccff3c91b2\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"2584b414-9989-453a-87bb-a1278f9a69e0\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"92cbc78d-1715-4d58-95b0-4f3967132cfa\",\"exchange\":\"ARCX\",\"price\":35.4,\"step\":\"asset\",\"dollar_volume\":1.327053606E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"b04b0ce1-4380-4ef0-826a-d4aa974a8139\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"b3fd2a11-6072-4269-a5dd-976b476a7d64\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"796fad91-d139-4fc2-b70d-7c84655f75d1\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"2\",\"lhs-val\":\"SPY\",\"id\":\"c53cb0ba-a171-42aa-bdbb-544cf2dd3785\",\"comparator\":\"lte\",\"rhs-val\":\"-2\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"66735064-4839-40ad-a4fd-a84ffdb9d990\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"1b05926c-2cc5-4eaa-b566-1ab039e94fa6\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"7eff34c7-e3e6-4721-8d3c-62acf555b11d\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"a682ee85-e35d-4109-a009-3199463d6392\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Energy Bull 2x Shares\",\"ticker\":\"ERX\",\"has_marketcap\":false,\"id\":\"64f08563-22bb-4974-9b7f-a43c7c41a272\",\"exchange\":\"ARCX\",\"price\":51.3,\"step\":\"asset\",\"dollar_volume\":1.7945037539999998E8},{\"name\":\"ProShares UltraShort Euro\",\"ticker\":\"EUO\",\"has_marketcap\":false,\"id\":\"b6da052b-8851-4d00-a466-49962be743fe\",\"exchange\":\"ARCX\",\"price\":34.69,\"step\":\"asset\",\"dollar_volume\":5517930.159999999},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"d8a99244-ceb2-4614-b0ce-6c7d7a842e59\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"e4dbeb5d-8831-444a-a207-25a648351e6b\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"3\",\"lhs-window-days\":\"6\",\"lhs-val\":\"SPXU\",\"id\":\"c6fa6c2a-94b0-4df0-82bc-80e77d203f2e\",\"comparator\":\"gte\",\"rhs-val\":\"UPRO\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"8d443c84-1e67-46a5-9672-64fc57585883\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"3429cad4-d5fd-4d22-bf7e-9845f5331e3f\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"0b0b061b-5744-4fd0-8211-2ca218d78f74\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"da6a5ed0-1c90-4ebc-90ee-b35d6cca2edd\",\"exchange\":\"ARCX\",\"price\":31.37,\"step\":\"asset\",\"dollar_volume\":5.6195129461E8},{\"name\":\"ProShares Ultra MidCap400\",\"ticker\":\"MVV\",\"has_marketcap\":false,\"id\":\"9c2df734-5be4-40e1-9ca0-45e4ae4766bf\",\"exchange\":\"ARCX\",\"price\":42.05,\"step\":\"asset\",\"dollar_volume\":130018.59999999999},{\"name\":\"ProShares Ultra Semiconductors\",\"ticker\":\"USD\",\"has_marketcap\":false,\"id\":\"17de28c9-dc57-4a53-b331-b80c54e8ff62\",\"exchange\":\"ARCX\",\"price\":16.68,\"step\":\"asset\",\"dollar_volume\":2838452.28},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"c31b3f9c-1f6c-466b-ba74-0af5cf01bcd2\",\"step\":\"asset\"}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"fc05bcd0-b1db-4f0c-838a-ab8bdbed82a7\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"63aecef5-c89d-4f1b-9d37-c006ef91001c\",\"comparator\":\"lte\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"8402532d-f2c8-4b72-bcc0-81de90e2c84f\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"0f59ddcf-ac1f-4685-bd30-94538dfd21f9\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"f3d8e1aa-7c7d-4dff-b857-084b4467b45c\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"e52491f2-2a74-4c7f-8276-df30a1ac8ba3\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"1104139c-5233-45c5-a392-90da1842d60b\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"57828464-e3b3-4eeb-bb7b-de158a508167\",\"exchange\":\"BATS\",\"price\":16.19,\"step\":\"asset\",\"dollar_volume\":9.3964454544E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"11\",\"lhs-val\":\"TQQQ\",\"id\":\"62f3c097-fb7d-4cb8-9ac1-9a3a51b64fc9\",\"comparator\":\"gt\",\"rhs-val\":\"77\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"220c09c7-d3a5-4f9a-9c2d-1bb1253c43ca\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"e24c7ba7-210c-43d0-bafd-b8ec1a996c5a\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"1bf88669-7a68-44ab-ac76-a0ef0006f274\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"7c0b85c6-9d26-4031-a161-c582782c22bd\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"747f8ab1-8e83-489b-b4cf-efea900e2513\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"2a1efc6f-aadc-47b8-8834-1344ac9aac2c\",\"step\":\"wt-cash-equal\",\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"f6fa15ff-710e-4d95-9ca9-7ea9fc8906d3\",\"exchange\":\"BATS\",\"price\":10.41,\"step\":\"asset\",\"dollar_volume\":7.6812945732E8}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"1\",\"lhs-val\":\"TQQQ\",\"id\":\"9c8659c4-1556-4025-87cd-0c0b29ff3efb\",\"comparator\":\"gt\",\"rhs-val\":\"5.5\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"ba8e6670-f46b-41b9-86f5-070e30c9f824\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"34293c7d-8c2b-4d4f-a025-d85d032da575\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"d3c177f5-eca8-418a-8f7b-cef2848cf6c4\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"16d20487-0e1a-4112-90fa-4411b9d17899\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"6ba8d2f9-3747-4639-803d-677e76ca3425\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"36a81c9e-91e5-46b6-bfa9-eee8e21b64e9\",\"step\":\"asset\"}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"79a1e305-288b-464c-bfc2-74c51334d0b9\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"7d5ee081-f3be-4820-b876-934b253e6942\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"1cf9edb6-4c28-4a76-b99c-10aad6bd64ba\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"c289fe12-bb4f-4d69-90b4-2ece3db20156\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"8b4f9d3a-1cdc-4087-9f76-aa8006630328\",\"exchange\":\"ARCX\",\"price\":28.27,\"step\":\"asset\",\"dollar_volume\":9.3641556481E8},{\"name\":\"Invesco DB US Dollar Index Bullish Fund\",\"ticker\":\"UUP\",\"has_marketcap\":false,\"id\":\"fe3c5502-5c72-4838-a6dd-afd13b4f52e6\",\"exchange\":\"ARCX\",\"price\":30.15,\"step\":\"asset\",\"dollar_volume\":1.429251705E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"6c139e03-a7bb-4dd0-aeb0-fdc81c05a201\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167},{\"name\":\"ProShares Ultra Bloomberg Crude Oil\",\"ticker\":\"UCO\",\"has_marketcap\":false,\"id\":\"a30af108-2a16-4745-abf9-0dbd8c3e579f\",\"exchange\":\"ARCX\",\"price\":29.97,\"step\":\"asset\",\"dollar_volume\":6.165467361E7}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"44e6ddbf-8892-43fa-9cc9-0e8e5d3c802a\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed-specified-weight?\":false}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"6\",\"lhs-val\":\"TQQQ\",\"id\":\"cc135e4d-e4ff-4795-b029-82efee2efbef\",\"comparator\":\"lt\",\"rhs-val\":\"-10\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"71eb76d6-2cd1-46b3-8eeb-a7ec0eb3e3e3\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"1c69e668-071c-4fde-95c7-38cd65935e00\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"de064b30-5f83-4a67-be88-c949b0e9c4a5\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"6ffb6e3b-74bb-4feb-8a38-fb0eb3fd737d\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"d2af3a5e-ed9f-4e50-8646-57b5ae76b096\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"9f707b46-2ff7-47d9-8ab9-cd56f6e0c06a\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"ticker\":\"SPXL\",\"has_marketcap\":false,\"id\":\"7c340388-e0d6-4937-8e56-b9bbb8fe161a\",\"exchange\":\"ARCX\",\"price\":83.85,\"step\":\"asset\",\"dollar_volume\":4.8172328099999994E8},{\"name\":\"ProShares Ultra QQQ\",\"ticker\":\"QLD\",\"has_marketcap\":false,\"id\":\"8615e92a-8977-4d64-b537-8c88e3d16995\",\"exchange\":\"ARCX\",\"price\":35.26,\"step\":\"asset\",\"dollar_volume\":1.6824665126E8},{\"name\":\"ProShares Ultra Semiconductors\",\"ticker\":\"USD\",\"has_marketcap\":false,\"id\":\"967c8d4b-80d0-4e22-a875-79eff9b2b201\",\"exchange\":\"ARCX\",\"price\":16.68,\"step\":\"asset\",\"dollar_volume\":2838452.28},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"18683784-b3c9-49d1-b6d6-759300844601\",\"step\":\"asset\"}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"b13cc76a-9d1a-44e2-8e85-432f40101cb0\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"636287da-7568-460e-bd36-24b9588652f1\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"73ec4eb6-28c4-4896-b076-7b42d8f38dd3\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"f7555c6f-bee1-45fc-aa35-8c19b3eb9798\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"5f93361a-61f2-4929-9a3f-de7f283fc9d1\",\"exchange\":\"ARCX\",\"price\":28.27,\"step\":\"asset\",\"dollar_volume\":9.3641556481E8},{\"name\":\"Invesco DB US Dollar Index Bullish Fund\",\"ticker\":\"UUP\",\"has_marketcap\":false,\"id\":\"ad1ad4bc-e087-4857-a2f9-17585fc5529b\",\"exchange\":\"ARCX\",\"price\":30.15,\"step\":\"asset\",\"dollar_volume\":1.429251705E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"13a6e564-7777-4443-bc98-aa74e963cd08\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"8a37a45d-0c42-471a-a718-84fbaad0ccf2\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-return\",\"is-else-condition?\":false,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"dbd7f2de-a1fb-448b-a754-ba35698c7992\",\"comparator\":\"gt\",\"rhs-val\":\"DBC\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"1ccacec1-1e03-4574-995e-1288e06ad0cb\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"cdffd5f6-82a8-4b13-b7aa-37e784de3652\",\"step\":\"group\",\"name\":\"Defense | Modified\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"f58fed26-8a23-4cde-a559-1ec761e7f00a\",\"children\":[{\"id\":\"ce882c79-875b-4abc-b91c-a61fd3d84a44\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"1d479b85-7458-4aa0-b0e4-9350af68437d\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares 1-3 Year Treasury Bond ETF\",\"ticker\":\"SHY\",\"has_marketcap\":false,\"id\":\"4c7a63e8-d61f-49e2-8c10-678206006f23\",\"exchange\":\"XNAS\",\"price\":82.38,\"step\":\"asset\",\"dollar_volume\":6.516601524599999E8},{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"2eb85dd0-b75c-4160-b77e-03718d51ad00\",\"exchange\":\"ARCX\",\"price\":30.97,\"step\":\"asset\",\"dollar_volume\":8.040002155799999E8},{\"name\":\"SPDR Gold Shares\",\"ticker\":\"GLD\",\"has_marketcap\":false,\"id\":\"31da4374-932f-4b03-8d06-cf8a76fd9365\",\"exchange\":\"ARCX\",\"price\":162.77,\"step\":\"asset\",\"dollar_volume\":6.6775562373E8},{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"ee755b1a-4202-4494-a286-9dd7736e811b\",\"exchange\":\"ARCX\",\"price\":20.01,\"step\":\"asset\",\"dollar_volume\":3.0217437168E8},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"cd7636b7-e356-4438-ab33-c84db293b810\",\"exchange\":\"ARCX\",\"price\":55.58,\"step\":\"asset\",\"dollar_volume\":1.1806370296E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"494dca13-5f92-44da-aabb-72902f609b96\",\"exchange\":\"ARCX\",\"price\":70.73,\"step\":\"asset\",\"dollar_volume\":9.714480458100001E8},{\"name\":\"ProShares Ultra Bloomberg Crude Oil\",\"ticker\":\"UCO\",\"has_marketcap\":false,\"id\":\"86bcc0a8-0e04-4a83-affb-439a7faae2c2\",\"exchange\":\"ARCX\",\"price\":28.2,\"step\":\"asset\",\"dollar_volume\":8.985865139999999E7},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"271df808-0e96-46aa-aa0e-fda3643a0416\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"c68427cd-cb4a-4a68-9444-78d262c2d5b1\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"standard-deviation-return\",\"is-else-condition?\":false,\"lhs-fn\":\"standard-deviation-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"DBC\",\"id\":\"0de299a1-a3e6-4ce3-bce1-234db97cf76f\",\"comparator\":\"gt\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"66ed1671-de3f-4175-8fc9-2aa7040744e1\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"3d11d7f8-f309-46b3-88eb-ab308eb7318f\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"e757c20f-5140-4d8d-8cbf-867744388593\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"a65ddd1d-96bb-4494-94ee-76678815e240\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"b867053b-ace4-4fc8-9715-0499fdb17050\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares Ultra Semiconductors\",\"ticker\":\"USD\",\"has_marketcap\":false,\"id\":\"86a8aea5-7585-4912-82b9-392f909af391\",\"exchange\":\"ARCX\",\"price\":16.68,\"step\":\"asset\",\"dollar_volume\":2838452.28},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"cd03db29-9ac5-43f0-b6e8-0c936e50d330\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"49452eb0-c1c6-4d2e-a0b8-e49bb1f51d60\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"4d5c6a55-5e63-48c1-a34e-9e4598c2aceb\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"6f2ed71a-53d5-4bf2-bb70-df9ee40544bb\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"35213ecc-23e9-496c-8b50-17a45ab0edec\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"a3a1b504-2e89-4c41-8731-13d7d5834b23\",\"exchange\":\"ARCX\",\"price\":28.27,\"step\":\"asset\",\"dollar_volume\":9.3641556481E8},{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"22f217f5-1f43-460a-b0e1-33ca62b4442c\",\"exchange\":\"ARCX\",\"price\":20.01,\"step\":\"asset\",\"dollar_volume\":3.0217437168E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"ccbc76ef-b3ed-430c-9afa-12e67142825c\",\"exchange\":\"ARCX\",\"price\":44.99,\"step\":\"asset\",\"dollar_volume\":9.058357684200001E8},{\"name\":\"ProShares Ultra Bloomberg Crude Oil\",\"ticker\":\"UCO\",\"has_marketcap\":false,\"id\":\"1cf9b373-ac48-44a3-aeee-764d119b2420\",\"exchange\":\"ARCX\",\"price\":28.2,\"step\":\"asset\",\"dollar_volume\":8.985865139999999E7},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"0e74aaae-4335-401d-b3ba-5ad5e7b49d25\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"d42f3ba4-cd02-4873-9082-70460054cafd\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}]}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"weight\":{\"num\":100,\"den\":100}}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"lhs-fn\":\"current-price\",\"rhs-window-days\":\"200\",\"lhs-val\":\"TLT\",\"id\":\"fa7adcdc-4e3c-4869-92ff-11ef2e8c85ab\",\"comparator\":\"gt\",\"rhs-val\":\"TLT\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"e115b052-11b9-447f-8ca8-0348f20fcb2f\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"79dd8508-7a05-4447-b04e-b60b5b08fb48\",\"step\":\"group\",\"name\":\"B: If long term TLT is trending down, safety: Long Term, 2 Least Volatile*\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"793199e3-b6d2-4499-8647-1e646ef95fde\",\"children\":[{\"id\":\"2897690b-d0f7-447c-a831-d17cffea11ed\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"818ff79d-ccb5-4065-a8d5-61b0fea799af\",\"step\":\"group\",\"name\":\"B.A.A: Risk Off, Rising Rates (TMV)* - LETF Basket^\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"baae2c35-12b0-42ed-a779-53cb31ef130c\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"d47cb93e-fb87-4014-9f80-dc0c5968e35f\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"c159c7e7-cb8d-46fe-a954-a1c1647a2e10\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"cc0ebe25-6444-4e41-9e9b-9ad85b11f72c\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"2531c3be-b5b1-48e2-b987-b6190ce95743\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"23b0305d-cb99-4ff7-9761-23087acce5a3\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"985423f0-3750-4153-9e01-8ea8d8825e1c\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"8c69f7d0-58e7-4c17-b95f-f03f7f4f9074\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"8bbc6135-8a95-4c75-9fc3-6bbac0c699d7\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TQQQ\",\"id\":\"f3dd00df-f73d-4d77-a3a7-0d3d8546bde6\",\"comparator\":\"lt\",\"rhs-val\":\"30\",\"step\":\"if-child\",\"collapsed?\":true},{\"id\":\"909f05b7-6886-4e2b-ba64-0c0204b74af0\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"10a68b28-347a-42e4-944c-63ec1168d072\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"3362f3e4-9903-4865-99f3-09895be15aa3\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"890d48b7-386d-4824-bc38-5ae27bd1f480\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"18ef4370-4c04-4bbe-82f2-01b874a097ca\",\"exchange\":\"ARCX\",\"price\":20.91,\"step\":\"asset\",\"dollar_volume\":5.3752632333E8},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"7d8b0127-43a0-481e-802f-2ff6453f43ad\",\"exchange\":\"ARCX\",\"price\":35.4,\"step\":\"asset\",\"dollar_volume\":1.327053606E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"463e1af5-c275-4628-8dea-ad619d8974c1\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"2f50c368-96e5-460b-9c26-5ab52b179def\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9},{\"name\":\"Direxion Daily Energy Bull 2x Shares\",\"ticker\":\"ERX\",\"has_marketcap\":false,\"id\":\"3bc4b175-9334-4c73-ba14-180331f3e90c\",\"exchange\":\"ARCX\",\"price\":51.3,\"step\":\"asset\",\"dollar_volume\":1.7945037539999998E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"7eadbeba-dc59-496c-ab91-3148f44b0cd5\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"2\",\"lhs-val\":\"UUP\",\"id\":\"7002f493-d0e7-44e9-9e5c-4a2f34384bdb\",\"comparator\":\"gte\",\"rhs-val\":\"1\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"3d0912d0-2694-4d9e-92fd-8ea7c319e6fa\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"6604baf8-e255-4ef4-99b1-590a0450e3fc\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"c0eabb49-5c1c-450c-95ec-696de89c3a3d\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"ae62ce20-4bcd-48f6-be89-d4e3fdae40b6\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"04e4fb2d-8478-4540-9953-0aed521cc6ca\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"f3a3c157-d1fc-4a09-97a7-37e0afcf9a92\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9},{\"name\":\"WisdomTree India Earnings Fund\",\"ticker\":\"EPI\",\"has_marketcap\":false,\"id\":\"23eed353-b1ac-459f-836d-b1272fde14ee\",\"exchange\":\"ARCX\",\"price\":32.13,\"step\":\"asset\",\"dollar_volume\":6708776.130000001}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"cfd15396-3027-4698-8615-9a4f3882cfa6\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"4\",\"lhs-window-days\":\"5\",\"lhs-val\":\"SPXU\",\"id\":\"4093a339-b6a8-46ec-9de7-13c5aebe15c3\",\"comparator\":\"gte\",\"rhs-val\":\"UPRO\",\"step\":\"if-child\",\"collapsed?\":true},{\"id\":\"6d0d0c37-6438-4954-b18d-87a79ef66e4a\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"19ef9bba-0617-46eb-946e-65f97bdd8778\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"46d0183e-b846-44ac-a02c-a9584934274f\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"f9304d35-157e-4c8b-bbb6-aca1c9480423\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"38025bda-4eb9-4080-8110-d2267f80f22b\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"23fb70d8-524e-4107-ba2b-a8e154c24837\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"Direxion Daily Small Cap Bull 3x Shares\",\"ticker\":\"TNA\",\"has_marketcap\":false,\"id\":\"e4f7d1a3-bdc1-4062-8aa9-93db263094ac\",\"exchange\":\"ARCX\",\"price\":35.84,\"step\":\"asset\",\"dollar_volume\":5.7466253824E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"490ec666-eb84-4c06-8119-988ee2f5f7cc\",\"exchange\":\"ARCX\",\"price\":33.96,\"step\":\"asset\",\"dollar_volume\":5.8879939692E8},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"0a561065-cb44-4e13-9448-c4024add3c4a\",\"step\":\"asset\"}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"6e92de79-0e4a-402e-b843-25db2ff38a82\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"3\",\"lhs-window-days\":\"3\",\"lhs-val\":\"BIL\",\"id\":\"40d6077e-3a78-4fcc-b9d6-97107dee88fd\",\"comparator\":\"gte\",\"rhs-val\":\"TMV\",\"step\":\"if-child\"},{\"id\":\"f9668e62-4489-4d8c-a968-8b754c670e53\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"9726afa2-1dcb-41c4-9eb0-95da490dc13d\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"6639a51b-63f5-477a-87fd-159a7cc61040\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"f7ac3581-465a-4596-808b-2f90ae9ebb68\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"3c6152dd-5f3c-4d9f-9fb0-39c21c74c006\",\"exchange\":\"ARCX\",\"price\":157.82,\"step\":\"asset\",\"dollar_volume\":9.906629694E7}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"8f61380f-6922-4ed3-82f6-add5d43d30b0\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}]}]}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"64ded43e-60e3-4b55-8a59-a94f3af037ea\",\"comparator\":\"lte\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"b56eb1da-9a84-43c8-8c6a-14cb814dfc46\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"11663430-b538-45e5-8097-9607066eb842\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"1dd838fa-0bec-435b-b52c-69ed84c53ecb\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"0ab8dbbd-366d-4649-899c-d01355e7fe53\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"da02d726-571b-4abb-ae8a-bf4505ddb5fd\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"1cd07762-805b-46ac-bd07-e6a442ac0ec8\",\"exchange\":\"BATS\",\"price\":16.19,\"step\":\"asset\",\"dollar_volume\":9.3964454544E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"11\",\"lhs-val\":\"TQQQ\",\"id\":\"a199dd46-4d17-4d82-87d1-aa0a38d85cce\",\"comparator\":\"gt\",\"rhs-val\":\"77\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"eb8e4af3-3f6f-4a74-af0a-3cac1145a37f\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"ba37c872-c2f0-454b-bd10-45b8fdf4971a\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"d7f76b96-a163-4bcc-b0f5-f87855328ea7\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"702d09d8-d443-44f1-99f3-9cddaaf6767b\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"012c52a2-3eea-4da4-ac97-65bf6aeaf17d\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"2174a158-9e94-433d-8628-1c7cc8e7ee50\",\"step\":\"wt-cash-equal\",\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"129dd099-656d-42c9-8caf-20019f26aa82\",\"exchange\":\"BATS\",\"price\":10.41,\"step\":\"asset\",\"dollar_volume\":7.6812945732E8}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"1\",\"lhs-val\":\"TQQQ\",\"id\":\"1392c57f-8593-4989-9888-0524f3381346\",\"comparator\":\"gt\",\"rhs-val\":\"5.5\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"77338ae0-a362-464d-a119-2abe9e11e85e\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"3e045f34-c8c1-4bd8-847b-64000ef40119\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"ca5ea158-2835-470c-a1f6-3a6de9c6dc93\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"e128bbf7-15c4-4c2f-8fec-47e43c5f07cd\",\"step\":\"asset\"},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"beb47367-72f7-4b13-9bef-052e6baf40ff\",\"exchange\":\"ARCX\",\"price\":141.26,\"step\":\"asset\",\"dollar_volume\":4.3188126099999994E7}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"3786c655-854e-4841-a8c6-c4276b043705\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"6\",\"lhs-val\":\"TQQQ\",\"id\":\"da8fd05f-b47d-4186-9ba7-ddb5ecd0d879\",\"comparator\":\"lt\",\"rhs-val\":\"-10\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"a439ed05-3bb4-486b-be1b-dd463ad38966\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"9f32ed67-f5ce-40a3-a4d9-88e015ae6f9d\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"47414a6b-1f6e-4b6a-a8c1-b1f298ea2e8b\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"829c0b73-f966-4a8b-b1cc-c89dc840e555\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"4164e03d-b3d0-4f94-8b0e-db0467c91357\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"bed21cc8-8411-400b-81ac-7a582b20e8e7\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"6bf9473d-aec5-4d6a-80e2-903fbf36e559\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"1c789c57-9b82-42be-bc8f-5b528fe22f5e\",\"exchange\":\"ARCX\",\"price\":148.89,\"step\":\"asset\",\"dollar_volume\":8.982935702999999E7},{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"4f5ddc75-681c-4cb9-80f2-ab85d44db850\",\"exchange\":\"ARCX\",\"price\":19.95,\"step\":\"asset\",\"dollar_volume\":1.6883044604999998E8},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"10f40157-2d55-4773-8858-3b951ff05207\",\"step\":\"asset\"}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"5341fd58-f01f-4e4c-836b-48e4434de76d\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"f2d84271-1a1b-4edc-ac19-b09a718e5fa0\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"c5747c35-476f-4ef3-a4a9-432d555b94c6\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"27401bea-6bcc-41e7-a96f-a42bfd4793bf\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"98054d58-4c5a-4b53-9599-77243fec3a26\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"6d766b2f-4025-4391-809d-cb83a494c74e\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"de526f56-a5df-486a-8917-c5c8a313ba93\",\"step\":\"asset\"}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"22\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"5e93366e-3075-4285-9822-ec1ae5ab3c70\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}]}],\"rhs-fn\":\"moving-average-return\",\"is-else-condition?\":false,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"81f11047-a7d4-4e94-9cdd-cda0d20b4133\",\"comparator\":\"gt\",\"rhs-val\":\"DBC\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"869d657a-eb77-4d38-b365-f1aef5bb5dbc\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"0b3ee4d6-b6cc-49d2-be91-5e5ec5693610\",\"step\":\"group\",\"name\":\"Defense | Modified\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"6516fb6d-307e-4897-b4b0-eb38ac4018a3\",\"children\":[{\"id\":\"769991ed-4878-40ed-bc72-ff438fbbed05\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"a606b164-1675-4c42-a628-e436de33b3dd\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"a2b270f1-a369-4a2c-a9b2-2211faa9d3af\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"56ffe7fe-9191-4014-b0a1-dc4276080739\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"502c1d0e-830e-4474-9380-0231570f3229\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"1fe3e200-f19d-4606-854f-4bd14bc8614f\",\"exchange\":\"ARCX\",\"price\":141.26,\"step\":\"asset\",\"dollar_volume\":4.3188126099999994E7}],\"rhs-fn\":\"standard-deviation-return\",\"is-else-condition?\":false,\"lhs-fn\":\"standard-deviation-return\",\"rhs-window-days\":\"5\",\"lhs-window-days\":\"5\",\"lhs-val\":\"TMV\",\"id\":\"20ca5de3-3b48-45d2-bd3c-2b463d7df090\",\"comparator\":\"lte\",\"rhs-val\":\"DBC\",\"step\":\"if-child\"},{\"id\":\"31e296a7-8a2a-43c8-a63d-d70b8b8e0d57\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"name\":\"Invesco DB Commodity Index Tracking Fund\",\"ticker\":\"DBC\",\"has_marketcap\":false,\"id\":\"5c13de7c-04cf-4dc5-80e0-e9a219cc75b5\",\"exchange\":\"ARCX\",\"price\":25.33,\"step\":\"asset\",\"dollar_volume\":5.922121070999999E7}]}]}]}],\"rhs-fn\":\"exponential-moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"standard-deviation-return\",\"rhs-window-days\":\"100\",\"lhs-window-days\":\"10\",\"lhs-val\":\"DBC\",\"id\":\"0348a2aa-a0f7-44b5-aefb-0ca7919149f3\",\"comparator\":\"gte\",\"rhs-val\":\"3\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"456f3221-2914-4886-9004-47ee0d9b2a85\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"6fa17751-a731-4ab4-9e67-fec531b97c2f\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"a4611078-053a-4509-bab9-347593a72f4b\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"e557e19f-dd0b-4793-adac-3949333bb79b\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"a472dcaf-8a2b-4f4a-9734-bb3e5a69a1fa\",\"exchange\":\"ARCX\",\"price\":141.26,\"step\":\"asset\",\"dollar_volume\":4.3188126099999994E7},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"57f83c76-8a49-4f7b-9b8b-e9ac477d5a4c\",\"exchange\":\"ARCX\",\"price\":80.05,\"step\":\"asset\",\"dollar_volume\":1.38192436325E9},{\"name\":\"ProShares UltraPro Short S&P500\",\"ticker\":\"SPXU\",\"has_marketcap\":false,\"id\":\"20cb57c2-3b85-470b-8b03-5ce4670cc0f2\",\"exchange\":\"ARCX\",\"price\":21.92,\"step\":\"asset\",\"dollar_volume\":1.14726053376E9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"b4064b92-140c-4b96-9b0f-e54609016875\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"70f85045-68cb-4616-aee9-d1f6d5b9261b\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"9a696506-ad07-46e6-8a90-cab61d33fecd\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"1a3ecabe-e3ee-4aca-a935-08489d7c0549\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares MSCI EAFE ETF\",\"exch\":\"PCX\",\"typeDisp\":\"ETF\",\"type\":\"E\",\"exchDisp\":\"NYSEArca\",\"ticker\":\"EFA\",\"id\":\"6f93a1d2-6fe0-405e-aa04-4aeeb0ffc829\",\"step\":\"asset\"},{\"name\":\"iShares MSCI Emerging Markets ETF\",\"exch\":\"NYQ\",\"ticker\":\"EEM\",\"type\":\"E\",\"typeDisp\":\"ETF\",\"id\":\"24c5730a-08ed-4d63-aba6-3fc0480826b3\",\"exchDisp\":\"NYSE\",\"step\":\"asset\"},{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"c97bacec-6d5c-48e6-a11d-280e25212a70\",\"exchange\":\"ARCX\",\"price\":20.01,\"step\":\"asset\",\"dollar_volume\":3.0217437168E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"2a33b80f-7473-4a65-a760-5eb853240849\",\"exchange\":\"ARCX\",\"price\":44.99,\"step\":\"asset\",\"dollar_volume\":9.058357684200001E8},{\"name\":\"ProShares Ultra Bloomberg Crude Oil\",\"ticker\":\"UCO\",\"has_marketcap\":false,\"id\":\"1e365513-8de5-4654-b324-73ed3d2744fb\",\"exchange\":\"ARCX\",\"price\":28.2,\"step\":\"asset\",\"dollar_volume\":8.985865139999999E7},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"2a21a20b-3197-4d0b-af8f-0f2a3c06b550\",\"exchange\":\"ARCX\",\"price\":141.26,\"step\":\"asset\",\"dollar_volume\":4.3188126099999994E7}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"e1879d9c-4eea-4d4e-99b8-1a7f9f1eeff6\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"standard-deviation-return\",\"is-else-condition?\":false,\"lhs-fn\":\"standard-deviation-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"DBC\",\"id\":\"eaa172dc-4c04-42ca-9443-f5a892d4beb6\",\"comparator\":\"gt\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"7bf00b60-81ad-4dcf-a458-534bb59997e7\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"a25e05cd-ca66-429d-992b-35f1dfc7fbcf\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"e1bb2d74-d0ed-4b26-a595-e7048f79b994\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"966ad8b3-8a79-42ba-a4d5-5454c68c3051\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"WisdomTree India Earnings Fund\",\"ticker\":\"EPI\",\"has_marketcap\":false,\"id\":\"0a980bf3-d750-44d3-87c0-e5cd06cd4ec6\",\"exchange\":\"ARCX\",\"price\":30.67,\"step\":\"asset\",\"dollar_volume\":1.529816533E7},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"e83f01a3-dba2-45a1-85de-8a101e247779\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"7b110323-44cd-4f44-bc7b-8ed8a7a8cf0b\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"f2c84aae-c71f-4384-91a5-23a28b14e1d0\",\"step\":\"asset\"}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"c5ed0da1-341c-485f-b497-e1a087c036c8\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"f7719246-a56b-48b5-a52f-358fffb2acf1\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"7042fa15-2806-40cf-80ab-71bac569cd18\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"93162671-b8ef-48ed-b7c6-0de4eb44aa92\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"1ab2918b-6910-42f7-807e-fc50b201f1c0\",\"exchange\":\"ARCX\",\"price\":28.27,\"step\":\"asset\",\"dollar_volume\":9.3641556481E8},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"9a3fcb46-86e0-4e76-94fa-e28b9ee96d6f\",\"exchange\":\"ARCX\",\"price\":36.8,\"step\":\"asset\",\"dollar_volume\":1.218889968E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"8e8817f4-c292-4b4d-86fa-b68ab4bc4d14\",\"exchange\":\"ARCX\",\"price\":44.99,\"step\":\"asset\",\"dollar_volume\":9.058357684200001E8},{\"name\":\"ProShares UltraShort Euro\",\"ticker\":\"EUO\",\"has_marketcap\":false,\"id\":\"778de5e0-086b-4a4d-840a-47a04fb762ae\",\"exchange\":\"ARCX\",\"price\":34.69,\"step\":\"asset\",\"dollar_volume\":5517930.159999999},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"aa8d3e85-eacb-4d17-9b70-54bb5a91c8ac\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"5a01acfd-fd78-4298-8343-67ec41818596\",\"exchange\":\"ARCX\",\"price\":141.26,\"step\":\"asset\",\"dollar_volume\":4.3188126099999994E7}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"a33fb821-69c9-4f5f-b95a-0133dc5f92fb\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"TLT\",\"id\":\"c10b7083-70d0-4718-95b8-edf3b78556d4\",\"comparator\":\"lt\",\"rhs-val\":\"0\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"d1c60477-444c-401c-a16f-b8bb593236e9\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"a62c8a7a-dfea-4c53-82d9-8a3641f23914\",\"step\":\"group\",\"name\":\"B.A.B: Risk Off, Falling Rates (TMF)* - LETF Basket\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"f8c4469e-6b20-4c27-bedb-6628a8158521\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"a82cb91e-fb62-444d-ab3f-b6dcff7f2ce3\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"c2b5b6a7-fff5-4120-a9e1-a943b10faed8\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"6ebf3311-69a2-47a9-99a8-c84bdb4ef6a0\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"275c150d-45f6-4744-af71-f82361bac9d6\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"14d91b02-90f6-426f-a737-0c8a87def4c4\",\"exchange\":\"ARCX\",\"price\":20.91,\"step\":\"asset\",\"dollar_volume\":5.3752632333E8},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"a6156470-6700-40ef-ad5d-f34a4b8f9059\",\"exchange\":\"ARCX\",\"price\":35.4,\"step\":\"asset\",\"dollar_volume\":1.327053606E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"13fdded4-2c72-4496-9def-23cb97407798\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"161e9592-ce2f-43e0-8591-5519b35c048f\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"34e2cd64-48e4-445b-88a1-c97259fabac8\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"2\",\"lhs-val\":\"SPY\",\"id\":\"d39821d9-29a6-41e2-9df5-3d0af46c6c1c\",\"comparator\":\"lte\",\"rhs-val\":\"-2\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"9bd11159-b512-4204-b60d-8ce79eae8185\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"a4f57839-196d-4b35-905e-5849302a58a2\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"104ef534-6d50-4d93-b00f-0261bbdfd3a7\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"20b36fdc-d223-436c-9f21-a3b5752e1e27\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"SPDR Bloomberg 1-3 Month T-Bill ETF\",\"ticker\":\"BIL\",\"has_marketcap\":false,\"id\":\"81f6aa35-07b4-40b8-9c9d-46d3cb246f8d\",\"exchange\":\"ARCX\",\"price\":91.44,\"step\":\"asset\",\"dollar_volume\":5.3686188791999996E8},{\"name\":\"iShares Core U.S. Aggregate Bond ETF\",\"ticker\":\"AGG\",\"has_marketcap\":false,\"id\":\"f14ef348-8a95-43e6-8917-67f69d3423b4\",\"exchange\":\"ARCX\",\"price\":96.34,\"step\":\"asset\",\"dollar_volume\":1.3850104298400002E9},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"ab45380f-e532-4e87-a3e9-c43356bc36ed\",\"exchange\":\"ARCX\",\"price\":7.67,\"step\":\"asset\",\"dollar_volume\":7.270521856E7}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"17a634d9-5ad0-404c-be52-7fbd501b8bbc\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"3\",\"lhs-window-days\":\"6\",\"lhs-val\":\"SPXU\",\"id\":\"b5b0eb88-597b-434a-b362-26cb24554e0b\",\"comparator\":\"gte\",\"rhs-val\":\"UPRO\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"4ab7bc39-4879-4af7-b10e-482ba7af4987\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"2886686d-31b9-4942-8277-5fe7d769e015\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"ebdfa882-9ac2-4120-b056-68433cbf2c23\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"d7f83030-5a17-4812-961a-d9be1fd1548f\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"d2fbebcf-aded-4656-95ad-c3dad2c5c838\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"23303e60-ffd9-458e-afcf-c649e5e7450d\",\"exchange\":\"ARCX\",\"price\":31.37,\"step\":\"asset\",\"dollar_volume\":5.6195129461E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"39e50810-3fcb-48c4-86ed-27b6d00e7b41\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"fc907e4f-5b30-4713-a602-a2ceb9afac26\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}]}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"9401f174-3408-46dd-8b85-cefab5b3f633\",\"comparator\":\"lte\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"1414b2f6-72d8-4bd6-9d81-dc27c93890f3\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"9eb9aa82-9253-4b92-9be0-321d4ec33622\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"f7e9b5b6-d33e-4c01-b139-2e81d5352dd0\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"31e9cd80-1d2d-4353-817d-61b35310ceee\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"67e6ce51-e7bc-4f77-a06b-3403359f9380\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"829c814e-3167-46f7-acbc-a2427fbdc8dc\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"fc9fb0ba-2eae-4e80-beb2-c06769097d7e\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"734d2952-194e-4560-a133-8deacdae1f4f\",\"exchange\":\"BATS\",\"price\":16.19,\"step\":\"asset\",\"dollar_volume\":9.3964454544E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"11\",\"lhs-val\":\"TQQQ\",\"id\":\"b464293d-31f9-474d-b635-a63d03bad9f4\",\"comparator\":\"gt\",\"rhs-val\":\"77\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"88ed27ed-0192-42e9-ad78-803195fd2c24\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"9a1a7231-0775-458d-b1e2-02ead687b39b\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"ea2ae52f-4abc-4973-9e44-2173dca644b4\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"928fb7ff-ca75-4076-b20f-ef31e061b7b0\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"fc07d33d-b844-4d65-a2af-aaf32de5a1c8\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"cc9a7ba5-6976-48f0-ba08-4edab52df17a\",\"step\":\"wt-cash-equal\",\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"16d0184a-7ee3-4e95-955b-162c201f2dc2\",\"exchange\":\"BATS\",\"price\":10.41,\"step\":\"asset\",\"dollar_volume\":7.6812945732E8}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"1\",\"lhs-val\":\"TQQQ\",\"id\":\"b1f24678-a3b8-47e2-a41f-bc2b7488102a\",\"comparator\":\"gt\",\"rhs-val\":\"5.5\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"c59a31d5-7acd-4337-9683-cde5fff45e6a\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"6878a1e8-7bb0-4e60-b2f2-11a1daa88ea3\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"5b88a9d6-2121-488c-af82-00448bb2c63b\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"a244a6df-4abb-497a-a9c5-23ed45bc5da2\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"ticker\":\"SPXL\",\"has_marketcap\":false,\"id\":\"716923e6-24b5-4777-83e2-82167cdf8fa5\",\"exchange\":\"ARCX\",\"price\":83.85,\"step\":\"asset\",\"dollar_volume\":4.8172328099999994E8},{\"name\":\"WisdomTree India Earnings Fund\",\"ticker\":\"EPI\",\"has_marketcap\":false,\"id\":\"8b21030c-cafb-4c99-855b-5f9cf2a93ef8\",\"exchange\":\"ARCX\",\"price\":30.67,\"step\":\"asset\",\"dollar_volume\":1.529816533E7},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"50a0f614-8096-4cba-a31a-de851306cc85\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"346e1c41-6ae4-4dde-bd10-92e6216fa513\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"name\":\"ProShares Ultra QQQ\",\"ticker\":\"QLD\",\"has_marketcap\":false,\"id\":\"ed6b243f-e65a-4562-be12-1b1f95a3fea1\",\"exchange\":\"ARCX\",\"price\":35.26,\"step\":\"asset\",\"dollar_volume\":1.6824665126E8},{\"name\":\"iShares MSCI Brazil ETF\",\"ticker\":\"EWZ\",\"has_marketcap\":false,\"id\":\"0cad3518-9af7-46ca-bcd2-0483df6c63b3\",\"exchange\":\"ARCX\",\"price\":31.37,\"step\":\"asset\",\"dollar_volume\":5.6195129461E8},{\"name\":\"ProShares Ultra MidCap400\",\"ticker\":\"MVV\",\"has_marketcap\":false,\"id\":\"f7187142-73a0-4e78-b282-22538078a03d\",\"exchange\":\"ARCX\",\"price\":42.05,\"step\":\"asset\",\"dollar_volume\":130018.59999999999},{\"name\":\"Invesco DWA Utilities Momentum ETF\",\"ticker\":\"PUI\",\"has_marketcap\":false,\"id\":\"b2c74081-1dad-4ee5-9596-996861816e17\",\"exchange\":\"XNAS\",\"price\":30.77,\"step\":\"asset\",\"dollar_volume\":118956.81999999999},{\"name\":\"ProShares Ultra Semiconductors\",\"ticker\":\"USD\",\"has_marketcap\":false,\"id\":\"9bd6a234-e6cc-4a38-89aa-4262c221a0ab\",\"exchange\":\"ARCX\",\"price\":16.68,\"step\":\"asset\",\"dollar_volume\":2838452.28},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"c29e2301-62c3-43f3-b608-d5babb2089cf\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"7\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"256a6a27-b547-43ed-a576-95c05a0ac25a\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"6\",\"lhs-val\":\"TQQQ\",\"id\":\"cf2be8ec-c293-4e1d-801a-97890369fc56\",\"comparator\":\"lt\",\"rhs-val\":\"-10\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"9d0d24f2-6dd3-44bf-87ed-d9b3c2873d72\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"742e6272-00c9-47c3-814c-b35d86069ea4\",\"step\":\"wt-cash-equal\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"48a1202b-eebd-4bd8-af6c-3a0799d032d5\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"e923147a-d155-4877-b726-03f606a99643\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"93a09997-05c1-4c17-acf4-b80d321c0282\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"Direxion Daily S&P 500 Bull 3x Shares\",\"ticker\":\"SPXL\",\"has_marketcap\":false,\"id\":\"4cef16d7-6618-41cc-bd87-1e6d4fd8f337\",\"exchange\":\"ARCX\",\"price\":83.85,\"step\":\"asset\",\"dollar_volume\":4.8172328099999994E8},{\"name\":\"WisdomTree India Earnings Fund\",\"ticker\":\"EPI\",\"has_marketcap\":false,\"id\":\"34206538-5d48-464f-a63d-764bae87ec54\",\"exchange\":\"ARCX\",\"price\":30.67,\"step\":\"asset\",\"dollar_volume\":1.529816533E7},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"e6b0c39b-7c22-45c5-b21e-2411efdae242\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"04d7b070-1320-43c4-820c-56cf7842e4cc\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"name\":\"ProShares Ultra MidCap400\",\"ticker\":\"MVV\",\"has_marketcap\":false,\"id\":\"35bf0371-f146-41d6-bee2-40f21597a898\",\"exchange\":\"ARCX\",\"price\":42.05,\"step\":\"asset\",\"dollar_volume\":130018.59999999999}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"7\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"73baa088-d81b-4fb0-b185-51e48baaae46\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"relative-strength-index\",\"is-else-condition?\":false,\"lhs-fn\":\"relative-strength-index\",\"rhs-window-days\":\"7\",\"lhs-window-days\":\"7\",\"lhs-val\":\"BIL\",\"id\":\"5fb44429-fb4b-40e8-b602-5cbc2aa26412\",\"comparator\":\"lt\",\"rhs-val\":\"IEF\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"d2ecb1c0-a1fa-4cb0-b724-85da55cb1fd4\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"78f54091-3e0f-4690-b750-e260feb4ee14\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"295bd319-afc5-49fd-ab6e-d6f8ef025bc9\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"1f2a9914-5b82-429e-a545-08cc2a4b0298\",\"exchange\":\"ARCX\",\"price\":7.67,\"step\":\"asset\",\"dollar_volume\":7.270521856E7}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"3bc672e6-c6eb-43d4-abc8-0e4a9cdd111e\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"exponential-moving-average-price\",\"is-else-condition?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"3e5cacba-0ec5-499d-a625-f77d2ea0566e\",\"comparator\":\"gt\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"78043931-6806-43c6-8eb9-f4465510a891\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"11b60ada-4cad-40e4-8794-02ab5049a9f1\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"983fb03c-fad7-46be-90af-64d2b7449e02\",\"exchange\":\"ARCX\",\"price\":20.01,\"step\":\"asset\",\"dollar_volume\":3.0217437168E8},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"82e004f7-e11b-49c2-966a-99ff0280a866\",\"exchange\":\"XNAS\",\"price\":61.32,\"step\":\"asset\",\"dollar_volume\":9.65597774064E9},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"b5e01fcf-aa08-43c4-9fb1-258366773251\",\"exchange\":\"ARCX\",\"price\":55.58,\"step\":\"asset\",\"dollar_volume\":1.1806370296E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"6993f48b-abdd-4238-a685-fee6810d3204\",\"exchange\":\"ARCX\",\"price\":70.73,\"step\":\"asset\",\"dollar_volume\":9.714480458100001E8}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"a0edc5b4-492b-4dea-b952-4fe939f761f3\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-return\",\"is-else-condition?\":false,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"fdcf98b3-5c3c-4c5c-8db3-63055934eda0\",\"comparator\":\"gt\",\"rhs-val\":\"DBC\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"b8790342-4341-4d6b-a61e-adcf8f02d573\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"db9702fc-7c42-4250-98c0-2a2ad6fad0e3\",\"step\":\"group\",\"name\":\"Defense | Modified\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"037b62ec-13b6-478c-aa86-8c76ad541111\",\"children\":[{\"id\":\"880de3f8-5566-4d64-b84b-7963b4b5f4a3\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"faae74d5-36ef-4b1f-b67a-6f725301b9c8\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily S&P 500 Bear 3x Shares\",\"ticker\":\"SPXS\",\"has_marketcap\":false,\"id\":\"7ae37af2-9abb-4403-b8f4-482d57175420\",\"exchange\":\"ARCX\",\"price\":20.01,\"step\":\"asset\",\"dollar_volume\":3.0217437168E8},{\"name\":\"WisdomTree India Earnings Fund\",\"ticker\":\"EPI\",\"has_marketcap\":false,\"id\":\"f0314104-c5a3-402f-88b3-46c97b2ac42f\",\"exchange\":\"ARCX\",\"price\":32.5,\"step\":\"asset\",\"dollar_volume\":1.28180325E7},{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"64af8463-9a63-4cd8-992a-646e74543088\",\"exchange\":\"ARCX\",\"price\":55.58,\"step\":\"asset\",\"dollar_volume\":1.1806370296E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"d18227e4-8a36-4104-9cee-8d8a49e52d1b\",\"exchange\":\"ARCX\",\"price\":70.73,\"step\":\"asset\",\"dollar_volume\":9.714480458100001E8},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"c1a0240d-7ef5-43c2-afc2-c0c422bca314\",\"exchange\":\"XNAS\",\"price\":64.38,\"step\":\"asset\",\"dollar_volume\":1.087537804458E10}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"relative-strength-index\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"92a67f9b-5518-453a-9ccb-9032fb2076fa\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}]}],\"rhs-fn\":\"standard-deviation-return\",\"is-else-condition?\":false,\"lhs-fn\":\"standard-deviation-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"DBC\",\"id\":\"96720f3f-7123-4f74-b514-ff1dcaf5df85\",\"comparator\":\"gt\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"65257d76-c8e4-4ee7-a120-8fd7b1e1f9bf\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"56c6d57c-0bd8-49f7-9d3c-43ef4383b78a\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"961274ae-5e36-402d-8bef-a31a3f64c8ca\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"6b33cfba-3d83-4864-8878-b598e3ea818d\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"434b0faf-9e28-4313-a1cf-a991d78da3a5\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bull 3X Shares\",\"ticker\":\"TMF\",\"has_marketcap\":false,\"id\":\"e59b1b25-4c68-409b-a840-996070d0e177\",\"exchange\":\"ARCX\",\"price\":8.25,\"step\":\"asset\",\"dollar_volume\":50206167}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"15bfbea1-c7e8-4f27-b00b-9c2201f76361\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"collapsed?\":false}],\"weight\":{\"num\":100,\"den\":100}}]}],\"collapsed?\":false}],\"collapsed?\":false}]}]}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"UVXY\",\"id\":\"5fc0815d-cc58-4389-83a0-497570ebbc53\",\"comparator\":\"gt\",\"rhs-val\":\"84\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"0b7d3e35-3941-49a6-ad90-c7e7c1070c14\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"d254667a-fc71-4351-989b-1f586bcea351\",\"exchange\":\"BATS\",\"price\":12.69,\"step\":\"asset\",\"dollar_volume\":9.6779972826E8}],\"collapsed?\":false}]}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"UVXY\",\"id\":\"aab03e5f-1fcb-4b9e-a837-16f760cb3eb1\",\"comparator\":\"gt\",\"rhs-val\":\"74\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"a174cf68-45cb-4e5b-9194-879af955aa2d\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"61994a5e-d242-4bd9-8e40-936a4c9dfa0e\",\"step\":\"group\",\"name\":\"Bear Stock Market - High Inflation - [STRIPPED] V2.0.2b | A Better LETF Basket | DJKeyhole ???? | BIL and TMV\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"dfec3641-05b2-4888-9ac5-3483dac6cc42\",\"children\":[{\"id\":\"c06c2a6e-72b7-4731-82ff-ceceff8f0168\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"201f6985-f0cc-41cb-8b15-373f1bc4f009\",\"step\":\"group\",\"name\":\"A.B: Medium term TLT may be overbought*\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"48a8ed9e-b033-4b1c-a348-ab590a5521b0\",\"children\":[{\"id\":\"e347ccf5-04ab-40b5-a3cf-bc5146bdbedf\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"53197b4c-d6a5-491d-9b6c-62d80f37bbea\",\"step\":\"group\",\"name\":\"A.B.B.A: Risk Off, Rising Rates (TMV)*\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"786b7dd6-d5d7-4731-88c4-100fea46b3b4\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"81e9c0c7-54bd-4137-8989-643e36ae87b8\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"550d1dee-d2d2-4bcf-8003-74a1cf5fe132\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"8d8618b2-74a3-41a1-97b2-30093e783f0e\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"0643ede3-6139-42ba-a3f3-8b4cdddb4f65\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"43413aff-11ae-4d14-9614-4a4c96e70935\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"acddeafe-c8e0-4190-b719-197a0bda6c08\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"b8b30ce6-cca6-420d-991a-034e558ded5c\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"678e7f14-12e2-4569-a2ce-cb637e3f3186\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"15cdde8a-e8d7-4120-9707-fdc9bda044cc\",\"step\":\"asset\"}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"f4181c98-c9f4-4125-8a71-c5b593ff3c56\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TQQQ\",\"id\":\"1aeb4e11-40a3-4643-a082-9dbed6cc00c3\",\"comparator\":\"lt\",\"rhs-val\":\"30\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"4c27ed33-ce2e-4cb5-b93e-39058cce098e\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"d41a1bfd-f995-4dc3-a6ab-f5d5e7e48440\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"f82bf3cd-e679-4099-8633-39d1b28ac839\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"92009a26-60a9-4961-b532-8832d59b11d5\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"42d2a745-21d1-439c-9f34-bfd01e75a1a3\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9},{\"name\":\"ProShares UltraShort Euro\",\"ticker\":\"EUO\",\"has_marketcap\":false,\"id\":\"77fc3729-2193-402f-8ce0-f848b6e50e17\",\"exchange\":\"ARCX\",\"price\":34.69,\"step\":\"asset\",\"dollar_volume\":5517930.159999999},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"751771e2-306f-409a-834c-cd3ec892e20d\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"dd39122a-bac4-49cc-9023-7a776693b10e\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"3\",\"lhs-window-days\":\"6\",\"lhs-val\":\"SPXU\",\"id\":\"6c640fb5-5e54-4d60-9d94-b45b8a1a4db0\",\"comparator\":\"lte\",\"rhs-val\":\"UPRO\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"1879f150-e717-4807-9b25-21bd2c2f2e17\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"5207a1f0-33aa-4f5e-be4c-cb7ab9ff6f3f\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"10c777ca-f336-4643-9882-426cb72ff7b6\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"5720eed9-cb1f-4f50-af20-31cdeb22e2d4\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"e6a41f8b-e456-4adc-a406-5c7d7cdedffc\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"Direxion Daily Healthcare Bull 3x Shares\",\"ticker\":\"CURE\",\"has_marketcap\":false,\"id\":\"ef021295-27ab-4f0d-ac94-6692d8524a44\",\"exchange\":\"ARCX\",\"price\":89.46,\"step\":\"asset\",\"dollar_volume\":5880205.8},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"fde1f6de-b05c-46f6-8a34-fac3c503943a\",\"step\":\"asset\"}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"23bbaeb4-dc53-4e9e-9e12-387cd1f5d015\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"rhs-fn\":\"moving-average-price\",\"is-else-condition?\":false,\"rhs-fixed-value?\":false,\"lhs-fn\":\"exponential-moving-average-price\",\"rhs-window-days\":\"360\",\"lhs-window-days\":\"210\",\"lhs-val\":\"SPY\",\"id\":\"30ed7dda-f4f5-40a8-b100-c3c0e22e7147\",\"comparator\":\"lte\",\"rhs-val\":\"SPY\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"833d3f5c-5309-4659-833a-6b1268e53155\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"18b47164-2698-42db-bc20-c2b131b48826\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"a4e3cda7-983d-4a66-af22-f73de2cf2673\",\"step\":\"if\",\"children\":[{\"children\":[{\"name\":\"ProShares Ultra VIX Short-Term Futures ETF\",\"ticker\":\"UVXY\",\"has_marketcap\":false,\"id\":\"2ebe0eb2-d2c0-4bc4-a5df-763cd83555fc\",\"exchange\":\"BATS\",\"price\":16.19,\"step\":\"asset\",\"dollar_volume\":9.3964454544E8}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"11\",\"lhs-val\":\"TQQQ\",\"id\":\"829846ee-79c8-4f2d-8629-6beec47fbcfa\",\"comparator\":\"gt\",\"rhs-val\":\"77\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"54972575-fe84-4dab-b945-c09575aeaa7a\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"59b15346-4863-4499-b00a-b8c0faea484c\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"c810817d-c210-4b43-a4c7-1535288a671c\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"8d3be478-b14c-469e-8192-14d73dbc3d06\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"808b9da6-aeb4-4724-aed9-73fdbd6da0d4\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"name\":\"ProShares UltraPro S&P500\",\"ticker\":\"UPRO\",\"has_marketcap\":false,\"id\":\"d5e9d6eb-695e-4ea6-b589-d968428f6221\",\"exchange\":\"ARCX\",\"price\":37.98,\"step\":\"asset\",\"dollar_volume\":5.461024183199999E8},{\"name\":\"Direxion Daily 20+ Year Treasury Bear 3x Shares\",\"ticker\":\"TMV\",\"has_marketcap\":false,\"id\":\"b6137dd8-c906-49d5-be02-1d0abe2c4b5d\",\"exchange\":\"ARCX\",\"price\":148.89,\"step\":\"asset\",\"dollar_volume\":8.982935702999999E7}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"2d6f0e52-3289-436d-b5f5-c3302db64f9f\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"collapsed?\":false}]}]}],\"collapsed?\":false}]}],\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"moving-average-return\",\"rhs-window-days\":\"20\",\"lhs-window-days\":\"20\",\"lhs-val\":\"TLT\",\"id\":\"2c5650e6-6576-43b8-8b13-f082f9e94e61\",\"comparator\":\"lt\",\"rhs-val\":\"0\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"bc2ca21f-9e39-46d6-9d25-07ae99c26669\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"2edc9ffa-e642-4de5-abe8-5d3fddf199c9\",\"step\":\"group\",\"name\":\"A.B.B.B: Risk Off, Falling Rates (TMF)*\",\"children\":[{\"step\":\"wt-cash-equal\",\"id\":\"1ec3d6a4-b8ce-47ee-933e-ba6e6cda5b01\",\"children\":[{\"weight\":{\"num\":100,\"den\":100},\"id\":\"806db0d9-5526-45d7-ac59-24475cbb089d\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"913a33c3-9c5a-4e54-a2c6-2b5becec45f9\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"d327135d-416d-4bbb-ae18-f9bbb2d6f53d\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"d0036c92-53ec-44bb-99bf-4b04cd50fe95\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bull 3x Shares\",\"ticker\":\"TECL\",\"has_marketcap\":false,\"id\":\"8f9112b1-708c-44d8-8678-2b10029ce733\",\"exchange\":\"ARCX\",\"price\":45.48,\"step\":\"asset\",\"dollar_volume\":8.993788247999999E7},{\"name\":\"ProShares UltraPro QQQ\",\"ticker\":\"TQQQ\",\"has_marketcap\":false,\"id\":\"88bbf525-9012-46f9-839a-0866c66f4d9a\",\"exchange\":\"XNAS\",\"price\":23.23,\"step\":\"asset\",\"dollar_volume\":4.51222093884E9},{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\",\"has_marketcap\":false,\"id\":\"3067000d-b550-444a-85d3-e36b82d5a4c4\",\"exchange\":\"ARCX\",\"price\":17.41,\"step\":\"asset\",\"dollar_volume\":7.0774877814E8},{\"ticker\":\"FNGU\",\"exchange\":\"ARCX\",\"name\":\"MicroSectors FANG+ Index 3X Leveraged ETN\",\"id\":\"8a50ca52-84fb-4bdf-9602-6ee9a1731333\",\"step\":\"asset\"}],\"select-fn\":\"bottom\",\"select-n\":\"1\",\"sort-by-fn\":\"moving-average-return\",\"sort-by-window-days\":\"5\",\"weight\":{\"num\":\"100\",\"den\":100},\"id\":\"5a94d447-945b-457e-9d0e-fbb5dd20cb44\",\"sort-by?\":true,\"collapsed-specified-weight?\":false,\"step\":\"filter\",\"collapsed?\":false}]}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"relative-strength-index\",\"lhs-window-days\":\"10\",\"lhs-val\":\"TQQQ\",\"id\":\"abad25aa-7930-43a4-97dc-b9c7bfcf0160\",\"comparator\":\"lt\",\"rhs-val\":\"30\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"aacfc6dc-ff75-43af-9895-2785f39add70\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"82aa3831-adbd-43d6-84b9-217c6778189e\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"fc85731a-c37d-45af-ac47-14960e5a9815\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"2a23d6cf-23bc-4763-b5d4-a63a7d886f65\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Technology Bear 3X Shares\",\"ticker\":\"TECS\",\"has_marketcap\":false,\"id\":\"a75ea596-3653-4d88-99b4-35c7278369a1\",\"exchange\":\"ARCX\",\"price\":35.4,\"step\":\"asset\",\"dollar_volume\":1.327053606E8},{\"name\":\"Direxion Daily Semiconductor Bear 3x Shares\",\"ticker\":\"SOXS\",\"has_marketcap\":false,\"id\":\"032b5772-ac47-45e7-bb1a-9e81f5a7b1fd\",\"exchange\":\"ARCX\",\"price\":42.49,\"step\":\"asset\",\"dollar_volume\":1.05451796723E9},{\"name\":\"ProShares UltraPro Short QQQ\",\"ticker\":\"SQQQ\",\"has_marketcap\":false,\"id\":\"c370cc7c-2ece-4830-8ca7-de411e565ff0\",\"exchange\":\"XNAS\",\"price\":44.53,\"step\":\"asset\",\"dollar_volume\":6.90147741888E9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"9a05ea9e-b9e6-4cfe-aec2-7a76d5a3b25a\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"is-else-condition?\":false,\"rhs-fixed-value?\":true,\"lhs-fn\":\"cumulative-return\",\"lhs-window-days\":\"2\",\"lhs-val\":\"UUP\",\"id\":\"28b9c985-4caa-4ffe-8ddf-5e675bfe91b8\",\"comparator\":\"gte\",\"rhs-val\":\"1\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"8f69ca70-baca-474c-82d7-15107c7faffd\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"1a7a6561-375d-44ba-b0d1-cb82b944045e\",\"step\":\"wt-cash-equal\",\"children\":[{\"id\":\"96724bbb-b2a4-4e40-95d9-b8b836892ffb\",\"step\":\"if\",\"children\":[{\"children\":[{\"id\":\"486db3f8-4156-4267-919a-a7f81ddbfb66\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Energy Bull 2x Shares\",\"ticker\":\"ERX\",\"has_marketcap\":false,\"id\":\"2eab5e71-ea2e-4a33-8328-3536ccc2f13c\",\"exchange\":\"ARCX\",\"price\":51.3,\"step\":\"asset\",\"dollar_volume\":1.7945037539999998E8},{\"name\":\"ProShares UltraShort Euro\",\"ticker\":\"EUO\",\"has_marketcap\":false,\"id\":\"a5f06d63-0f14-4f33-86d1-d0ad3934180e\",\"exchange\":\"ARCX\",\"price\":34.69,\"step\":\"asset\",\"dollar_volume\":5517930.159999999},{\"name\":\"ProShares UltraShort Yen\",\"ticker\":\"YCS\",\"has_marketcap\":false,\"id\":\"7ad59398-db39-4b80-9e29-38012521e2e2\",\"exchange\":\"ARCX\",\"price\":65.06,\"step\":\"asset\",\"dollar_volume\":3221445.9}],\"select-fn\":\"top\",\"select-n\":\"1\",\"sort-by-fn\":\"cumulative-return\",\"sort-by-window-days\":\"5\",\"id\":\"5dec1475-5156-4f74-a169-03e8b2159106\",\"sort-by?\":true,\"step\":\"filter\",\"collapsed?\":false}],\"collapsed?\":false}],\"rhs-fn\":\"cumulative-return\",\"is-else-condition?\":false,\"rhs-fixed-value?\":false,\"lhs-fn\":\"cumulative-return\",\"rhs-window-days\":\"4\",\"lhs-window-days\":\"5\",\"lhs-val\":\"SPXU\",\"id\":\"1929d248-962d-458a-a8d5-833d1b1e22bd\",\"comparator\":\"gte\",\"rhs-val\":\"UPRO\",\"step\":\"if-child\",\"collapsed?\":false},{\"id\":\"a50e0f12-b3b8-44d9-9f0c-1561bcd64310\",\"step\":\"if-child\",\"is-else-condition?\":true,\"children\":[{\"id\":\"e6bc4eca-eb9c-40d9-8500-04cb98cb4a7d\",\"step\":\"wt-cash-equal\",\"children\":[{\"select?\":true,\"children\":[{\"name\":\"Direxion Daily Semiconductor Bull 3x Shares\",\"ticker\":\"SOXL\