"""support-multi-modal

Revision ID: d57accd375ae
Revises: 03f8dcbc611e
Create Date: 2025-11-12 15:37:12.363670

"""
from alembic import op
import models as models
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'd57accd375ae'
down_revision = '7bb281b7a422'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('segment_attachment_bindings',
    sa.Column('id', models.types.StringUUID(), nullable=False),
    sa.Column('tenant_id', models.types.StringUUID(), nullable=False),
    sa.Column('dataset_id', models.types.StringUUID(), nullable=False),
    sa.Column('document_id', models.types.StringUUID(), nullable=False),
    sa.Column('segment_id', models.types.StringUUID(), nullable=False),
    sa.Column('attachment_id', models.types.StringUUID(), nullable=False),
    sa.Column('created_at', sa.DateTime(), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
    sa.PrimaryKeyConstraint('id', name='segment_attachment_binding_pkey')
    )
    with op.batch_alter_table('segment_attachment_bindings', schema=None) as batch_op:
        batch_op.create_index(
            'segment_attachment_binding_tenant_dataset_document_segment_idx',
            ['tenant_id', 'dataset_id', 'document_id', 'segment_id'],
            unique=False
        )
        batch_op.create_index('segment_attachment_binding_attachment_idx', ['attachment_id'], unique=False)

    with op.batch_alter_table('datasets', schema=None) as batch_op:
        batch_op.add_column(sa.Column('is_multimodal', sa.Boolean(), server_default=sa.text('false'), nullable=False))

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please
    with op.batch_alter_table('datasets', schema=None) as batch_op:
        batch_op.drop_column('is_multimodal')


    with op.batch_alter_table('segment_attachment_bindings', schema=None) as batch_op:
        batch_op.drop_index('segment_attachment_binding_attachment_idx')
        batch_op.drop_index('segment_attachment_binding_tenant_dataset_document_segment_idx')

    op.drop_table('segment_attachment_bindings')
    # ### end Alembic commands ###
