Privacy Policy
==============

Your privacy is critically important to us. As an overview:

- When you use Letta applications/services/websites, we collect basic (anonymous) telemetry data such as clicks, crashes, etc.
  - This data helps us understand how our users are using the Letta application(s) and it informs our roadmap of future features and buxfixes.
  - If you would like to opt-out of basic telemetry, you can modify your configuration file to include `telemetry_disabled = True`.
- When you use Letta hosted services (such as the hosted endpoints or Discord Bot), we collect the data that was used to render these services.
  - For example, for the hosted endpoint, this includes the message request and message response.
  - We may use this data to improve our services, for example to train new models in the future.
  - We do NOT collect data on any of your messages or prompts unless you are using our hosted services (for example, if you are running your own model backends, this data will never be collected).

Below is our full Privacy Policy, which expands the overview in full detail.

### What This Policy Covers

This Privacy Policy applies to information that we collect about you when you use:

-   Our websites (including letta.ai, the Letta Discord server, and the repository github.com/cpacker/Letta);
-   Our applications (including the Python package, Discord Bot, and any other hosted services);
-   Our other Letta products, services, and features that are available on or through our websites;

Throughout this Privacy Policy we'll refer to our websites, mobile applications, and other products and services collectively as "Services."

Below we explain how we collect, use, and share information about you, along with the choices that you have with respect to that information.

### Information We Collect

We only collect information about you if we have a reason to do so — for example, to provide our Services, to communicate with you, or to make our Services better.

We collect this information from three sources: if and when you provide information to us, automatically through operating our Services, and from outside sources. Let's go over the information that we collect.

#### *Information You Provide to Us*

It's probably no surprise that we collect information that you provide to us directly. Here are some examples:

-   **Basic account information:** We ask for basic information from you in order to set up your account.
-   **Public profile information:** If you have an account with us, we collect the information that you provide for your public profile.
-   **Credentials: **Depending on the Services you use, you may provide us with credentials for your self-hosted website (like SSH, FTP, and SFTP username and password).
-   **Communications with us (hi there!):** You may also provide us with information when you post on GitHub, Discord, or message us through separate channels.

#### *Information We Collect Automatically*

We also collect some information automatically:

-   **Log information:** We collect information that web browsers, mobile devices, and servers typically make available, including the browser type, IP address, unique device identifiers, language preference, referring site, the date and time of access, operating system, and mobile network information. We collect log information when you use our Services.
-   **Usage information:** We collect information about your usage of our Services.  We use this information to, for example, provide our Services to you, get insights on how people use our Services so we can make our Services better, and understand and make predictions about user retention.
-   **Location information:** We may determine the location of your device from your IP address. We collect and use this information to, for example, calculate how many people visit our Services from certain geographic regions.
-   **Stored information:** We may access information stored on your devices if you upload this information to our Services.
-   **Information from cookies & other technologies:** A cookie is a string of information that a website stores on a visitor's computer, and that the visitor's browser provides to the website each time the visitor returns. Pixel tags (also called web beacons) are small blocks of code placed on websites and emails. We may use cookies and other technologies like pixel tags to help us identify and track visitors, usage, and access preferences for our Services.

#### *Information We Collect from Other Sources*

We may also get information about you from other sources. For example:

-   **Third Party Login:** If you create or log in to our Services through another service (like Google) we'll receive associated login information (e.g. a connection token, your username, your email address)

The information we receive depends on which services you use or authorize and what options are available.

Third-party services may also give us information, like mailing addresses for individuals who are not yet our users (but we hope will be!). We use this information for marketing purposes like postcards and other mailers advertising our Services.

### How and Why We Use Information

#### *Purposes for Using Information*

We use information about you for the purposes listed below:

-   **To provide our Services.** For example, to run a model on our hosted services to deliver a message to your client.
-   **To ensure quality, maintain safety, and improve our Services.** For example, by providing automatic upgrades and new versions of our Services. Or, for example, by monitoring and analyzing how users interact with our Services so we can create new features that we think our users will enjoy and that will help them create and manage websites more efficiently or make our Services easier to use.
-   **To protect our Services, our users, and the public.** For example, by detecting security incidents; detecting and protecting against malicious, deceptive, fraudulent, or illegal activity; fighting spam; complying with our legal obligations; and protecting the rights and property of Letta and others, which may result in us, for example, declining a transaction or terminating Services.
-   **To fix problems with our Services.** For example, by monitoring, debugging, repairing, and preventing issues.
-   **To customize the user experience.** For example, to personalize your experience by serving you relevant notifications for our Services.

#### *Legal Bases for Collecting and Using Information*

A note here for those in the European Union about our legal grounds for processing information about you under EU data protection laws, which is that our use of your information is based on the grounds that:

(1) The use is necessary in order to fulfill our commitments to you under the applicable terms of service or other agreements with you or is necessary to administer your account — for example, in order to enable access to our website on your device or charge you for a paid plan; or

(2) The use is necessary for compliance with a legal obligation; or

(3) The use is necessary in order to protect your vital interests or those of another person; or

(4) We have a legitimate interest in using your information — for example, to provide and update our Services; to improve our Services so that we can offer you an even better user experience; to safeguard our Services; to communicate with you; to measure, gauge, and improve the effectiveness of our advertising; and to understand our user retention and attrition; to monitor and prevent any problems with our Services; and to personalize your experience; or

(5) You have given us your consent

### Sharing Information

#### *How We Share Information*

We share information about you in limited circumstances, and with appropriate safeguards on your privacy.

-   **Subsidiaries, independent contractors, and research partners:** We may disclose information about you to our subsidiaries, independent contractors, and/or research partners who need the information to help us provide our Services or process the information on our behalf. We require our subsidiaries and independent contractors to follow this Privacy Policy for any personal information that we share with them. This includes the transfer of data collect on our Services to facilitate model training and refinement.
-   **Third-party vendors:** We may share information about you with third-party vendors who need the information in order to provide their services to us, or to provide their services to you or your site. This includes vendors that help us provide our Services to you (such as intrastructure or model serving companies); those that help us understand and enhance our Services (like analytics providers); those that make tools to help us run our operations (like programs that help us with task management, scheduling, word processing, email and other communications, and collaboration among our teams); other third-party tools that help us manage operations; and companies that make products available on our websites, who may need information about you in order to, for example, provide technical or other support services to you.
-   **Legal and regulatory requirements:** We may disclose information about you in response to a subpoena, court order, or other governmental request.
-   **To protect rights, property, and others:** We may disclose information about you when we believe in good faith that disclosure is reasonably necessary to protect the property or rights of Letta, third parties, or the public at large.
-   **Asset/IP transfers:** If any transfer of Letta assets were to happen, this Privacy Policy would continue to apply to your information and the party receiving your information may continue to use your information, but only consistent with this Privacy Policy.
-   **With your consent:** We may share and disclose information with your consent or at your direction.
-   **Aggregated or de-identified information:** We may share information that has been aggregated or de-identified, so that it can no longer reasonably be used to identify you. For instance, we may publish aggregate statistics about the use of our Services, or share a hashed version of your email address to facilitate customized ad campaigns on other platforms.
-   **Published support requests:** If you send us a request for assistance (for example, via a support email or one of our other feedback mechanisms), we reserve the right to publish that request in order to clarify or respond to your request, or to help us support other users.

#### *Information Shared Publicly*

Information that you choose to make public is — you guessed it — disclosed publicly.

That means information like your public profile, posts, other content that you make public on your website, and your "Likes" and comments on other websites are all available to others — and we hope they get a lot of views!

For example, the photo that you upload to your public profile, or a default image if you haven't uploaded one, is your **G**lobally **R**ecognized Avatar, or Gravatar — get it? :) Your Gravatar, along with other public profile information, displays alongside the comments and "Likes" that you make on other users' websites while logged in to your WordPress.com account. Your Gravatar and public profile information may also display with your comments, "Likes," and other interactions on websites that use our Gravatar service, if the email address associated with your account is the same email address you use on the other website.

Please keep all of this in mind when deciding what you would like to share publicly.

### How Long We Keep Information

We generally discard information about you when it's no longer needed for the purposes for which we collect and use it — described in the section above on How and Why We Use Information — and we're not legally required to keep it.

### Security

While no online service is 100% secure, we work very hard to protect information about you against unauthorized access, use, alteration, or destruction, and take reasonable measures to do so. We monitor our Services for potential vulnerabilities and attacks. To enhance the security of your account, we encourage you to enable our advanced security settings when available.

### Choices

You have several choices available when it comes to information about you:

-   **Opt out of telemetry:** You can opt our of basic telemetry by modifying your configuration file.
-   **Limit use of hosted services:** We only retain information on model inputs/outputs when you use our hosted services.

### Your Rights

If you are located in certain parts of the world, including some US states and countries that fall under the scope of the European General Data Protection Regulation (aka the "GDPR"), you may have certain rights regarding your personal information, like the right to request access to or deletion of your data.

#### *European General Data Protection Regulation (GDPR)*

If you are located in a country that falls under the scope of the GDPR, data protection laws give you certain rights with respect to your personal data, subject to any exemptions provided by the law, including the rights to:

-   Request access to your personal data;
-   Request correction or deletion of your personal data;
-   Object to our use and processing of your personal data;
-   Request that we limit our use and processing of your personal data; and
-   Request portability of your personal data.

You also have the right to make a complaint to a government supervisory authority.

#### *US Privacy Laws*

Laws in some US states, including California, Colorado, Connecticut, Utah, and Virginia, require us to provide residents with additional information about the categories of personal information we collect and share, where we get that personal information, and how and why we use it. You'll find that information in this section (if you are a California resident, please note that this is the Notice at Collection we are required to provide you under California law).

In the last 12 months, we collected the following categories of personal information, depending on the Services used:

-   Identifiers (like your name, contact information, and device and online identifiers);
-   Characteristics protected by law (for example, you might provide your gender as part of a research survey for us or you may choose to voluntarily disclose your race or veteran status);
-   Internet or other electronic network activity information (such as your usage of our Services);
-   Application and user data (such as model data and user inputs used to render our Services)
-   Geolocation data (such as your location based on your IP address);
-   Audio, electronic, visual or similar information (such as your profile picture, if you uploaded one);
-   Inferences we make (such as likelihood of retention or attrition).

We collect personal information for the purposes described in the "How and Why We Use Information section". And we share this information with the categories of third parties described in the "Sharing Information section". We retain this information for the length of time described in our "How Long We Keep Information section".

In some US states you have additional rights subject to any exemptions provided by your state's respective law, including the right to:

-   Request a copy of the specific pieces of information we collect about you and, if you're in California, to know the categories of personal information we collect, the categories of business or commercial purpose for collecting and using it, the categories of sources from which the information came, and the categories of third parties we share it with;
-   Request deletion of personal information we collect or maintain;
-   Request correction of personal information we collect or maintain;
-   Opt out of the sale or sharing of personal information;
-   Receive a copy of your information in a readily portable format; and
-   Not receive discriminatory treatment for exercising your rights.

***Right to Opt Out***

Our procedures to opt-out of data collection to our Services is the "Choices" section. We do not collect or process your sensitive (and potentially sensitive) personal information except where it is strictly necessary to provide you with our service or improve our services in the future, where the processing is not for the purpose of inferring characteristics about you, or for other purposes that do not require an option to limit under California law. We don't knowingly sell or share personal information of those under 16.

#### *Contacting Us About These Rights*

If you'd like to contact us about one of the other rights, scroll down to "How to Reach Us" to, well, find out how to reach us. When you contact us about one of your rights under this section, we'll need to verify that you are the right person before we disclose or delete anything. For example, if you are a user, we will need you to contact us from the email address associated with your account. You can also designate an authorized agent to make a request on your behalf by giving us written authorization. We may still require you to verify your identity with us.

#### ***Appeals Process for Rights Requests Denials***

In some circumstances we may deny your request to exercise one of these rights. For example, if we cannot verify that you are the account owner we may deny your request to access the personal information associated with your account. As another example, if we are legally required to maintain a copy of your personal information we may deny your request to delete your personal information.

In the event that we deny your request, we will communicate this fact to you in writing. You may appeal our decision by responding in writing to our denial email and stating that you would like to appeal. All appeals will be reviewed by an internal expert who was not involved in your original request. In the event that your appeal is also denied this information will be communicated to you in writing.  Please note that the appeal process does not apply to job applicants.

If your appeal is denied, in some US states (Colorado, Connecticut, and Virginia) you may refer the denied appeal to the state attorney general if you believe the denial is in conflict with your legal rights. The process for how to do this will be communicated to you in writing at the same time we send you our decision about your appeal.

### How to Reach Us

If you have a question about this Privacy Policy, please contact us through our via [email](mailto:contact@charlespacker.com).

### Other Things You Should Know (Keep Reading!)

#### *Ads and Analytics Services Provided by Others*

Ads appearing on any of our Services may be delivered by advertising networks. Othjjgger parties may also provide analytics services via our Services. These ad networks and analytics providers may set tracking technologies (like cookies) to collect information about your use of our Services and across other websites and online services. These technologies allow these third parties to recognize your device to compile information about you or others who use your device. This information allows us and other companies to, among other things, analyze and track usage, determine the popularity of certain content, and deliver ads that may be more targeted to your interests. Please note this Privacy Policy only covers the collection of information by Letta and does not cover the collection of information by any third-party advertisers or analytics providers.

#### *Third-Party Software and Services*

If you'd like to use third-party software or services (such as forks of our code), please keep in mind that interacting with them may mean providing information about yourself (or your site visitors) to those third parties. For example, some third-party services may request or require access to your (yours, your visitors', or customers') data via a pixel or cookie. Please note that if you use the third-party service or grant access, your data will be handled in accordance with the third party's privacy policy and practices. We don't own or control these third parties, and they have their own rules about information collection, use, and sharing, which you should review before using the software or services.

### Privacy Policy Changes

Although most changes are likely to be minor, we may change its Privacy Policy from time to time. We encourage visitors to frequently check this page for any changes to its Privacy Policy. If we make changes, we will notify you by revising the policy in the public repository (change log is publically viewable). Your further use of the Services after a change to our Privacy Policy will be subject to the updated policy.

### Creative Commons Sharealike License

This privacy policy is derived from the [Automattic Privacy Policy](https://github.com/Automattic/legalmattic) distributed under a Creative Commons Sharealike license. Thank you Automattic!
