"""add cascades to blocks_agents FKs; set initially immediate

Revision ID: 038e68cdf0df
Revises: b6061da886ee
Create Date: 2025-10-07 13:01:17.872405

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "038e68cdf0df"
down_revision: Union[str, None] = "b6061da886ee"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f("blocks_agents_agent_id_fkey"), "blocks_agents", type_="foreignkey")
    op.drop_constraint(op.f("fk_block_id_label"), "blocks_agents", type_="foreignkey")
    op.create_foreign_key(
        "fk_block_id_label",
        "blocks_agents",
        "block",
        ["block_id", "block_label"],
        ["id", "label"],
        onupdate="CASCADE",
        ondelete="CASCADE",
        initially="IMMEDIATE",
        deferrable=True,
    )
    op.create_foreign_key(None, "blocks_agents", "agents", ["agent_id"], ["id"], ondelete="CASCADE")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "blocks_agents", type_="foreignkey")
    op.drop_constraint("fk_block_id_label", "blocks_agents", type_="foreignkey")
    op.create_foreign_key(
        op.f("fk_block_id_label"),
        "blocks_agents",
        "block",
        ["block_id", "block_label"],
        ["id", "label"],
        initially="DEFERRED",
        deferrable=True,
    )
    op.create_foreign_key(op.f("blocks_agents_agent_id_fkey"), "blocks_agents", "agents", ["agent_id"], ["id"])
    # ### end Alembic commands ###
