"""add approvals field to messages

Revision ID: 066857381578
Revises: c734cfc0d595
Create Date: 2025-10-09 17:56:07.333221

"""

from typing import Sequence, Union

import sqlalchemy as sa

import letta.orm
from alembic import op
from letta.settings import settings

# revision identifiers, used by Alembic.
revision: str = "066857381578"
down_revision: Union[str, None] = "c734cfc0d595"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # Skip this migration for SQLite
    if not settings.letta_pg_uri_no_default:
        return

    ### commands auto generated by Alembic - please adjust! ###
    op.add_column("messages", sa.Column("approvals", letta.orm.custom_columns.ApprovalsColumn(), nullable=True))
    ### end Alembic commands ###


def downgrade() -> None:
    # Skip this migration for SQLite
    if not settings.letta_pg_uri_no_default:
        return

    ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("messages", "approvals")
    ### end Alembic commands ###
