"""add agent_id index to mapping tables

Revision ID: 18ff61fbc034
Revises: b888f21b151f
Create Date: 2025-09-10 19:16:39.118760

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "18ff61fbc034"
down_revision: Union[str, None] = "b888f21b151f"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index("ix_blocks_agents_block_id", "blocks_agents", ["block_id"], unique=False)
    op.create_index("ix_block_label", "block", ["label"], unique=False)
    op.create_index("ix_agents_organization_id", "agents", ["organization_id"], unique=False)
    op.create_index("ix_tools_agents_tool_id", "tools_agents", ["tool_id"], unique=False)
    op.create_index("ix_sources_agents_source_id", "sources_agents", ["source_id"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_sources_agents_source_id", table_name="sources_agents")
    op.drop_index("ix_tools_agents_tool_id", table_name="tools_agents")
    op.drop_index("ix_agents_organization_id", table_name="agents")
    op.drop_index("ix_block_label", table_name="block")
    op.drop_index("ix_blocks_agents_block_id", table_name="blocks_agents")
    # ### end Alembic commands ###
