"""add agents_runs table

Revision ID: 5973fd8b8c60
Revises: eff256d296cb
Create Date: 2025-09-18 10:52:46.270241

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "5973fd8b8c60"
down_revision: Union[str, None] = "eff256d296cb"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "agents_runs",
        sa.Column("agent_id", sa.String(), nullable=False),
        sa.Column("run_id", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["agent_id"],
            ["agents.id"],
        ),
        sa.ForeignKeyConstraint(
            ["run_id"],
            ["jobs.id"],
        ),
        sa.PrimaryKeyConstraint("agent_id", "run_id"),
        sa.UniqueConstraint("agent_id", "run_id", name="unique_agent_run"),
    )
    op.create_index("ix_agents_runs_agent_id_run_id", "agents_runs", ["agent_id", "run_id"], unique=False)
    op.create_index("ix_agents_runs_run_id_agent_id", "agents_runs", ["run_id", "agent_id"], unique=False)
    op.add_column("jobs", sa.Column("background", sa.Boolean(), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("jobs", "background")
    op.drop_index("ix_agents_runs_run_id_agent_id", table_name="agents_runs")
    op.drop_index("ix_agents_runs_agent_id_run_id", table_name="agents_runs")
    op.drop_table("agents_runs")
    # ### end Alembic commands ###
