"""add template fields to blocks agents groups

Revision ID: d5103ee17ed5
Revises: ffb17eb241fc
Create Date: 2025-08-26 15:45:32.949892

"""

from typing import Sequence, Union

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "d5103ee17ed5"
down_revision: Union[str, None] = "ffb17eb241fc"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("agents", sa.Column("entity_id", sa.String(), nullable=True))
    op.add_column("agents", sa.Column("deployment_id", sa.String(), nullable=True))
    op.add_column("block", sa.Column("entity_id", sa.String(), nullable=True))
    op.add_column("block", sa.Column("base_template_id", sa.String(), nullable=True))
    op.add_column("block", sa.Column("template_id", sa.String(), nullable=True))
    op.add_column("block", sa.Column("deployment_id", sa.String(), nullable=True))
    op.add_column("groups", sa.Column("base_template_id", sa.String(), nullable=True))
    op.add_column("groups", sa.Column("template_id", sa.String(), nullable=True))
    op.add_column("groups", sa.Column("deployment_id", sa.String(), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("groups", "deployment_id")
    op.drop_column("groups", "template_id")
    op.drop_column("groups", "base_template_id")
    op.drop_column("block", "deployment_id")
    op.drop_column("block", "template_id")
    op.drop_column("block", "base_template_id")
    op.drop_column("block", "entity_id")
    op.drop_column("agents", "deployment_id")
    op.drop_column("agents", "entity_id")
    # ### end Alembic commands ###
