"""Provides all data related to decorators."""

COMMON_LETTERS = {
    "\t": "\t",
    " ": " ",
    "А": "A",
    "Б": "B",
    "В": "V",
    "Д": "D",
    "Е": "E",
    "Ж": "Zh",
    "З": "Z",
    "К": "K",
    "Л": "L",
    "М": "M",
    "Н": "N",
    "О": "O",
    "П": "P",
    "Р": "R",
    "С": "S",
    "Т": "T",
    "У": "U",
    "Ф": "F",
    "Х": "Kh",
    "Ц": "Ts",
    "Ч": "Ch",
    "Ш": "Sh",
    "Щ": "Shch",
    "Ю": "Yu",
    "Я": "Ja",
    "а": "a",
    "б": "b",
    "в": "v",
    "д": "d",
    "е": "e",
    "ж": "zh",
    "з": "z",
    "к": "k",
    "л": "l",
    "м": "m",
    "н": "n",
    "о": "o",
    "п": "p",
    "р": "r",
    "с": "s",
    "т": "t",
    "у": "u",
    "ф": "f",
    "х": "kh",
    "ц": "ts",
    "ч": "ch",
    "ш": "sh",
    "щ": "shch",
    "ю": "yu",
    "я": "ja",
}

ROMANIZATION_DICT = {
    "kk": {
        "Ё": "Yo",
        "І": "I",
        "Г": "G",
        "И": "I",
        "Й": "Ye",
        "Ъ": "",
        "Ы": "Y",
        "Ь": "",
        "Э": "E",
        "г": "g",
        "и": "i",
        "й": "ye",
        "ъ": "",
        "ы": "y",
        "ь": "",
        "э": "e",
        "ё": "yo",
        "і": "i",
        "Ғ": "Ğ",
        "ғ": "ğ",
        "Қ": "Q",
        "қ": "q",
        "Ң": "Ñ",
        "ң": "ñ",
        "Ү": "Ü",
        "ү": "ü",
        "Ұ": "U",
        "ұ": "u",
        "Һ": "H",
        "һ": "h",
        "Ә": "Ä",
        "ә": "ä",
        "Ө": "Ö",
        "ө": "ö",
    },
    "ru": {
        "Ё": "Yo",
        "Г": "G",
        "И": "I",
        "Й": "Ye",
        "Ъ": "",
        "Ы": "Y",
        "Ь": "",
        "Э": "E",
        "г": "g",
        "и": "i",
        "й": "ye",
        "ъ": "",
        "ы": "y",
        "ь": "",
        "э": "e",
        "ё": "yo",
    },
    "uk": {
        "Є": "Ye",
        "І": "I",
        "Ї": "Yi",
        "Г": "H",
        "И": "Y",
        "Й": "Y",
        "Ь": "’",
        "г": "h",
        "и": "y",
        "й": "y",
        "ь": "’",
        "є": "ye",
        "і": "i",
        "ї": "yi",
        "Ґ": "G",
        "ґ": "g",
    },
}
