"""Provides all the generic data related to the business."""

CURRENCY_ISO_CODES = [
    "AED",
    "AFN",
    "ALL",
    "AMD",
    "ANG",
    "AOA",
    "ARS",
    "AUD",
    "AWG",
    "AZN",
    "BAM",
    "BBD",
    "BDT",
    "BGN",
    "BHD",
    "BIF",
    "BMD",
    "BND",
    "BOB",
    "BOV",
    "BRL",
    "BSD",
    "BTN",
    "BWP",
    "BYN",
    "BYR",
    "BZD",
    "CAD",
    "CDF",
    "CHE",
    "CHF",
    "CHW",
    "CLF",
    "CLP",
    "CNY",
    "COP",
    "COU",
    "CRC",
    "CUC",
    "CUP",
    "CVE",
    "CZK",
    "DJF",
    "DKK",
    "DOP",
    "DZD",
    "EGP",
    "ERN",
    "ETB",
    "EUR",
    "FJD",
    "FKP",
    "GBP",
    "GEL",
    "GHS",
    "GIP",
    "GMD",
    "GNF",
    "GTQ",
    "GYD",
    "HKD",
    "HNL",
    "HRK",
    "HTG",
    "HUF",
    "IDR",
    "ILS",
    "INR",
    "IQD",
    "IRR",
    "ISK",
    "JMD",
    "JOD",
    "JPY",
    "KES",
    "KGS",
    "KHR",
    "KMF",
    "KPW",
    "KRW",
    "KWD",
    "KYD",
    "KZT",
    "LAK",
    "LBP",
    "LKR",
    "LRD",
    "LSL",
    "LYD",
    "MAD",
    "MDL",
    "MGA",
    "MKD",
    "MMK",
    "MNT",
    "MOP",
    "MRO",
    "MUR",
    "MVR",
    "MWK",
    "MXN",
    "MXV",
    "MYR",
    "MZN",
    "NAD",
    "NGN",
    "NIO",
    "NOK",
    "NPR",
    "NZD",
    "OMR",
    "PAB",
    "PEN",
    "PGK",
    "PHP",
    "PKR",
    "PLN",
    "PYG",
    "QAR",
    "RON",
    "RSD",
    "RUB",
    "RWF",
    "SAR",
    "SBD",
    "SCR",
    "SDG",
    "SEK",
    "SGD",
    "SHP",
    "SLL",
    "SOS",
    "SRD",
    "SSP",
    "STD",
    "SVC",
    "SYP",
    "SZL",
    "THB",
    "TJS",
    "TMT",
    "TND",
    "TOP",
    "TRY",
    "TTD",
    "TWD",
    "TZS",
    "UAH",
    "UGX",
    "USD",
    "USN",
    "UYI",
    "UYU",
    "UZS",
    "VEF",
    "VND",
    "VUV",
    "WST",
    "XAF",
    "XAG",
    "XAU",
    "XBA",
    "XBB",
    "XBC",
    "XBD",
    "XCD",
    "XDR",
    "XOF",
    "XPD",
    "XPF",
    "XPT",
    "XSU",
    "XTS",
    "XUA",
    "XXX",
    "YER",
    "ZAR",
    "ZMW",
    "ZWL",
]

CRYPTOCURRENCY_ISO_CODES = [
    "BCH",
    "BNB",
    "BTC",
    "DASH",
    "DOT",
    "EOS",
    "ETH",
    "IOT",
    "LTC",
    "USDT",
    "VTC",
    "WBTC",
    "XBC",
    "XBT",
    "XLM",
    "XMR",
    "XRP",
    "XZC",
    "ZEC",
]


CURRENCY_SYMBOLS = {
    "ar-ae": "د.إ.",
    "ar-bh": "د.ب.",
    "ar-dz": "د.ج.",
    "ar-eg": "ج.م.",
    "ar-iq": "د.ع.",
    "ar-jo": "د.ا.",
    "ar-kw": "د.ك.",
    "ar-lb": "ل.ل.",
    "ar-ly": "د.ل.",
    "ar-ma": "د.م.",
    "ar-om": "ر.ع.",
    "ar-qa": "ر.ق.",
    "ar-ps": "ش.",
    "ar-sa": "ر.س.",
    "ar-sy": "ل.س.",
    "ar-tn": "د.ت.",
    "ar-ye": "ر.ي.",
    "az": "₼",
    "cs": "Kč",
    "da": "kr",
    "de": "€",
    "de-at": "€",
    "de-ch": "Fr.",
    "el": "€",
    "en": "$",
    "en-ca": "$",
    "en-gb": "£",
    "en-au": "$",
    "es": "€",
    "es-mx": "$",
    "et": "€",
    "fa": "﷼",
    "fi": "€",
    "fr": "€",
    "hr": "€",
    "hu": "Ft",
    "is": "kr",
    "it": "€",
    "ja": "¥",
    "kk": "₸",
    "ko": "₩",
    "nl": "€",
    "nl-be": "€",
    "no": "kr",
    "pl": "zł",
    "pt": "€",
    "pt-br": "R$",
    "ru": "₽",
    "sk": "€",
    "sv": "kr",
    "tr": "₺",
    "uk": "₴",
    "zh": "¥",
    "default": "$",
}

CRYPTOCURRENCY_SYMBOLS = [
    "₿",
    "Ł",
    "Ξ",
]


STOCK_EXCHANGES = ["NYSE", "NASDAQ", "AMEX", "JPX", "SSE", "HKEX", "Euronext"]

STOCK_TICKERS = [
    "A",
    "AA",
    "AABA",
    "AAC",
    "AAL",
    "AAMC",
    "AAME",
    "AAN",
    "AAOI",
    "AAON",
    "AAP",
    "AAPL",
    "AAT",
    "AAU",
    "AAWW",
    "AAXJ",
    "AAXN",
    "AB",
    "ABB",
    "ABBV",
    "ABC",
    "ABCB",
    "ABDC",
    "ABEO",
    "ABEOW",
    "ABEV",
    "ABG",
    "ABIL",
    "ABIO",
    "ABM",
    "ABMD",
    "ABR",
    "ABR^A",
    "ABR^B",
    "ABR^C",
    "ABT",
    "ABTX",
    "ABUS",
    "AC",
    "ACA",
    "ACAD",
    "ACAM",
    "ACAMU",
    "ACAMW",
    "ACB",
    "ACBI",
    "ACC",
    "ACCO",
    "ACCP",
    "ACER",
    "ACGL",
    "ACGLO",
    "ACGLP",
    "ACH",
    "ACHC",
    "ACHN",
    "ACHV",
    "ACIA",
    "ACIU",
    "ACIW",
    "ACLS",
    "ACM",
    "ACMR",
    "ACN",
    "ACNB",
    "ACOR",
    "ACP",
    "ACRE",
    "ACRS",
    "ACRX",
    "ACST",
    "ACT",
    "ACTG",
    "ACTT",
    "ACTTU",
    "ACTTW",
    "ACU",
    "ACV",
    "ACWI",
    "ACWX",
    "ACY",
    "ADAP",
    "ADBE",
    "ADC",
    "ADES",
    "ADI",
    "ADIL",
    "ADILW",
    "ADM",
    "ADMA",
    "ADMP",
    "ADMS",
    "ADNT",
    "ADP",
    "ADPT",
    "ADRA",
    "ADRD",
    "ADRE",
    "ADRO",
    "ADRU",
    "ADS",
    "ADSK",
    "ADSW",
    "ADT",
    "ADTN",
    "ADUS",
    "ADVM",
    "ADX",
    "ADXS",
    "AE",
    "AEB",
    "AEE",
    "AEF",
    "AEG",
    "AEGN",
    "AEH",
    "AEHR",
    "AEIS",
    "AEL",
    "AEM",
    "AEMD",
    "AEO",
    "AEP",
    "AEP^B",
    "AER",
    "AERI",
    "AES",
    "AESE",
    "AEY",
    "AEYE",
    "AEZS",
    "AFB",
    "AFC",
    "AFG",
    "AFGB",
    "AFGE",
    "AFGH",
    "AFH",
    "AFHBL",
    "AFI",
    "AFIN",
    "AFINP",
    "AFL",
    "AFMD",
    "AFT",
    "AFYA",
    "AG",
    "AGBA",
    "AGBAR",
    "AGBAU",
    "AGBAW",
    "AGCO",
    "AGD",
    "AGE",
    "AGEN",
    "AGFS",
    "AGFSW",
    "AGI",
    "AGIO",
    "AGLE",
    "AGM",
    "AGM.A",
    "AGMH",
    "AGM^A",
    "AGM^C",
    "AGM^D",
    "AGN",
    "AGNC",
    "AGNCB",
    "AGNCM",
    "AGNCN",
    "AGND",
    "AGO",
    "AGO^B",
    "AGO^E",
    "AGO^F",
    "AGR",
    "AGRO",
    "AGRX",
    "AGS",
    "AGTC",
    "AGX",
    "AGYS",
    "AGZD",
    "AHC",
    "AHH",
    "AHH^A",
    "AHL^C",
    "AHL^D",
    "AHL^E",
    "AHPI",
    "AHT",
    "AHT^D",
    "AHT^F",
    "AHT^G",
    "AHT^H",
    "AHT^I",
    "AI",
    "AIA",
    "AIC",
    "AIF",
    "AIG",
    "AIG.WS",
    "AIG^A",
    "AIHS",
    "AIM",
    "AIMC",
    "AIMT",
    "AIN",
    "AINC",
    "AINV",
    "AIQ",
    "AIR",
    "AIRG",
    "AIRI",
    "AIRR",
    "AIRT",
    "AIRTP",
    "AIRTW",
    "AIT",
    "AIV",
    "AIW",
    "AIZ",
    "AIZP",
    "AI^B",
    "AI^C",
    "AJG",
    "AJRD",
    "AJX",
    "AJXA",
    "AKAM",
    "AKBA",
    "AKCA",
    "AKER",
    "AKG",
    "AKO.A",
    "AKO.B",
    "AKR",
    "AKRO",
    "AKRX",
    "AKS",
    "AKTS",
    "AKTX",
    "AL",
    "ALAC",
    "ALACR",
    "ALACU",
    "ALACW",
    "ALB",
    "ALBO",
    "ALC",
    "ALCO",
    "ALDR",
    "ALDX",
    "ALE",
    "ALEC",
    "ALEX",
    "ALG",
    "ALGN",
    "ALGR",
    "ALGRR",
    "ALGRU",
    "ALGRW",
    "ALGT",
    "ALIM",
    "ALIT",
    "ALJJ",
    "ALK",
    "ALKS",
    "ALL",
    "ALLE",
    "ALLK",
    "ALLO",
    "ALLT",
    "ALLY",
    "ALLY^A",
    "ALL^A",
    "ALL^B",
    "ALL^D.CL",
    "ALL^E.CL",
    "ALL^F.CL",
    "ALL^G",
    "ALL^H",
    "ALNA",
    "ALNY",
    "ALO",
    "ALOT",
    "ALPN",
    "ALP^Q",
    "ALRM",
    "ALRN",
    "ALRS",
    "ALSK",
    "ALSN",
    "ALT",
    "ALTM",
    "ALTR",
    "ALTY",
    "ALV",
    "ALX",
    "ALXN",
    "ALYA",
    "AL^A",
    "AM",
    "AMAG",
    "AMAL",
    "AMAT",
    "AMBA",
    "AMBC",
    "AMBCW",
    "AMBO",
    "AMC",
    "AMCA",
    "AMCI",
    "AMCIU",
    "AMCIW",
    "AMCR",
    "AMCX",
    "AMD",
    "AME",
    "AMED",
    "AMEH",
    "AMG",
    "AMGN",
    "AMH",
    "AMH^D",
    "AMH^E",
    "AMH^F",
    "AMH^G",
    "AMH^H",
    "AMK",
    "AMKR",
    "AMN",
    "AMNB",
    "AMOT",
    "AMOV",
    "AMP",
    "AMPE",
    "AMPH",
    "AMPY",
    "AMR",
    "AMRB",
    "AMRC",
    "AMRH",
    "AMRHW",
    "AMRK",
    "AMRN",
    "AMRS",
    "AMRWW",
    "AMRX",
    "AMS",
    "AMSC",
    "AMSF",
    "AMSWA",
    "AMT",
    "AMTB",
    "AMTBB",
    "AMTD",
    "AMTX",
    "AMWD",
    "AMX",
    "AMZN",
    "AN",
    "ANAB",
    "ANAT",
    "ANCN",
    "ANDA",
    "ANDAR",
    "ANDAU",
    "ANDAW",
    "ANDE",
    "ANET",
    "ANF",
    "ANFI",
    "ANGI",
    "ANGO",
    "ANH",
    "ANH^A",
    "ANH^B",
    "ANH^C",
    "ANIK",
    "ANIP",
    "ANIX",
    "ANSS",
    "ANTE",
    "ANTM",
    "ANY",
    "AOBC",
    "AOD",
    "AON",
    "AOS",
    "AOSL",
    "AP",
    "APA",
    "APAM",
    "APD",
    "APDN",
    "APDNW",
    "APEI",
    "APEN",
    "APEX",
    "APH",
    "APHA",
    "APLE",
    "APLS",
    "APLT",
    "APM",
    "APO",
    "APOG",
    "APOP",
    "APOPW",
    "APO^A",
    "APO^B",
    "APPF",
    "APPN",
    "APPS",
    "APRN",
    "APT",
    "APTO",
    "APTS",
    "APTV",
    "APTX",
    "APVO",
    "APWC",
    "APY",
    "APYX",
    "AQ",
    "AQB",
    "AQMS",
    "AQN",
    "AQNA",
    "AQNB",
    "AQST",
    "AQUA",
    "AR",
    "ARA",
    "ARAV",
    "ARAY",
    "ARC",
    "ARCB",
    "ARCC",
    "ARCE",
    "ARCH",
    "ARCO",
    "ARCT",
    "ARD",
    "ARDC",
    "ARDS",
    "ARDX",
    "ARE",
    "AREC",
    "ARES",
    "ARES^A",
    "AREX",
    "ARE^D",
    "ARGD",
    "ARGO",
    "ARGX",
    "ARI",
    "ARKR",
    "ARL",
    "ARLO",
    "ARLP",
    "ARMK",
    "ARMP",
    "ARNA",
    "ARNC",
    "ARNC^",
    "AROC",
    "AROW",
    "ARPO",
    "ARQL",
    "ARR",
    "ARR^B",
    "ARTL",
    "ARTLW",
    "ARTNA",
    "ARTW",
    "ARTX",
    "ARVN",
    "ARW",
    "ARWR",
    "ARYA",
    "ARYAU",
    "ARYAW",
    "ASA",
    "ASB",
    "ASB^C",
    "ASB^D",
    "ASB^E",
    "ASC",
    "ASET",
    "ASFI",
    "ASG",
    "ASGN",
    "ASH",
    "ASIX",
    "ASLN",
    "ASM",
    "ASMB",
    "ASML",
    "ASNA",
    "ASND",
    "ASPN",
    "ASPS",
    "ASPU",
    "ASR",
    "ASRT",
    "ASRV",
    "ASRVP",
    "ASTC",
    "ASTE",
    "ASUR",
    "ASX",
    "ASYS",
    "AT",
    "ATAI",
    "ATAX",
    "ATEC",
    "ATEN",
    "ATEST",
    "ATEST.A",
    "ATEST.B",
    "ATEST.C",
    "ATEX",
    "ATGE",
    "ATH",
    "ATHE",
    "ATHM",
    "ATHX",
    "ATH^A",
    "ATI",
    "ATIF",
    "ATIS",
    "ATISW",
    "ATKR",
    "ATLC",
    "ATLO",
    "ATNI",
    "ATNM",
    "ATNX",
    "ATO",
    "ATOM",
    "ATOS",
    "ATR",
    "ATRA",
    "ATRC",
    "ATRI",
    "ATRO",
    "ATRS",
    "ATSG",
    "ATTO",
    "ATU",
    "ATUS",
    "ATV",
    "ATVI",
    "ATXI",
    "AU",
    "AUB",
    "AUBN",
    "AUDC",
    "AUG",
    "AUMN",
    "AUO",
    "AUPH",
    "AUTL",
    "AUTO",
    "AUY",
    "AVA",
    "AVAL",
    "AVAV",
    "AVB",
    "AVCO",
    "AVD",
    "AVDL",
    "AVDR",
    "AVEO",
    "AVGO",
    "AVGR",
    "AVH",
    "AVID",
    "AVK",
    "AVLR",
    "AVNS",
    "AVNW",
    "AVP",
    "AVRO",
    "AVT",
    "AVTR",
    "AVTR^A",
    "AVX",
    "AVXL",
    "AVY",
    "AVYA",
    "AWF",
    "AWI",
    "AWK",
    "AWP",
    "AWR",
    "AWRE",
    "AWSM",
    "AWX",
    "AX",
    "AXAS",
    "AXDX",
    "AXE",
    "AXGN",
    "AXGT",
    "AXL",
    "AXLA",
    "AXNX",
    "AXO",
    "AXP",
    "AXR",
    "AXS",
    "AXSM",
    "AXS^D",
    "AXS^E",
    "AXTA",
    "AXTI",
    "AXU",
    "AY",
    "AYI",
    "AYR",
    "AYTU",
    "AYX",
    "AZN",
    "AZO",
    "AZPN",
    "AZRE",
    "AZRX",
    "AZUL",
    "AZZ",
    "B",
    "BA",
    "BABA",
    "BAC",
    "BAC^A",
    "BAC^B",
    "BAC^C",
    "BAC^E",
    "BAC^K",
    "BAC^L",
    "BAC^M",
    "BAC^Y",
    "BAF",
    "BAH",
    "BAM",
    "BANC",
    "BANC^D",
    "BANC^E",
    "BAND",
    "BANF",
    "BANFP",
    "BANR",
    "BANX",
    "BAP",
    "BAS",
    "BASI",
    "BATRA",
    "BATRK",
    "BAX",
    "BB",
    "BBAR",
    "BBBY",
    "BBC",
    "BBCP",
    "BBD",
    "BBDC",
    "BBDO",
    "BBF",
    "BBGI",
    "BBH",
    "BBI",
    "BBIO",
    "BBK",
    "BBL",
    "BBN",
    "BBP",
    "BBRX",
    "BBSI",
    "BBT",
    "BBT^F",
    "BBT^G",
    "BBT^H",
    "BBU",
    "BBVA",
    "BBW",
    "BBX",
    "BBY",
    "BC",
    "BCBP",
    "BCC",
    "BCDA",
    "BCDAW",
    "BCE",
    "BCEI",
    "BCEL",
    "BCH",
    "BCLI",
    "BCML",
    "BCNA",
    "BCO",
    "BCOM",
    "BCOR",
    "BCOV",
    "BCOW",
    "BCPC",
    "BCRH",
    "BCRX",
    "BCS",
    "BCSF",
    "BCTF",
    "BCV",
    "BCV^A",
    "BCX",
    "BCYC",
    "BC^A",
    "BC^B",
    "BC^C",
    "BDC",
    "BDGE",
    "BDJ",
    "BDL",
    "BDN",
    "BDR",
    "BDSI",
    "BDX",
    "BDXA",
    "BE",
    "BEAT",
    "BECN",
    "BEDU",
    "BELFA",
    "BELFB",
    "BEN",
    "BEP",
    "BERY",
    "BEST",
    "BF.A",
    "BF.B",
    "BFAM",
    "BFC",
    "BFIN",
    "BFIT",
    "BFK",
    "BFO",
    "BFRA",
    "BFS",
    "BFST",
    "BFS^C",
    "BFS^D",
    "BFY",
    "BFZ",
    "BG",
    "BGB",
    "BGCP",
    "BGFV",
    "BGG",
    "BGH",
    "BGI",
    "BGIO",
    "BGNE",
    "BGR",
    "BGRN",
    "BGS",
    "BGSF",
    "BGT",
    "BGX",
    "BGY",
    "BH",
    "BH.A",
    "BHAT",
    "BHB",
    "BHC",
    "BHE",
    "BHF",
    "BHFAL",
    "BHFAP",
    "BHGE",
    "BHK",
    "BHLB",
    "BHP",
    "BHR",
    "BHR^B",
    "BHR^D",
    "BHTG",
    "BHV",
    "BHVN",
    "BIB",
    "BICK",
    "BID",
    "BIDU",
    "BIF",
    "BIG",
    "BIIB",
    "BILI",
    "BIMI",
    "BIO",
    "BIO.B",
    "BIOC",
    "BIOL",
    "BIOS",
    "BIOX",
    "BIOX.WS",
    "BIP",
    "BIS",
    "BIT",
    "BITA",
    "BIVI",
    "BJ",
    "BJRI",
    "BK",
    "BKCC",
    "BKCH",
    "BKD",
    "BKE",
    "BKEP",
    "BKEPP",
    "BKH",
    "BKI",
    "BKJ",
    "BKK",
    "BKN",
    "BKNG",
    "BKSC",
    "BKT",
    "BKTI",
    "BKU",
    "BKYI",
    "BK^C",
    "BL",
    "BLBD",
    "BLCM",
    "BLCN",
    "BLD",
    "BLDP",
    "BLDR",
    "BLE",
    "BLFS",
    "BLIN          ",
    "BLK",
    "BLKB",
    "BLL",
    "BLMN",
    "BLNK",
    "BLNKW",
    "BLPH",
    "BLRX",
    "BLU",
    "BLUE",
    "BLW",
    "BLX",
    "BMA",
    "BMCH",
    "BME",
    "BMI",
    "BMLP",
    "BML^G",
    "BML^H",
    "BML^J",
    "BML^L",
    "BMO",
    "BMRA",
    "BMRC",
    "BMRN",
    "BMTC",
    "BMY",
    "BND",
    "BNDW",
    "BNDX",
    "BNED",
    "BNFT",
    "BNGO",
    "BNGOW",
    "BNKL",
    "BNS",
    "BNSO",
    "BNTC",
    "BNTCW",
    "BNY",
    "BOCH",
    "BOE",
    "BOH",
    "BOKF",
    "BOKFL",
    "BOLD",
    "BOMN",
    "BOOM",
    "BOOT",
    "BORR",
    "BOSC",
    "BOTJ",
    "BOTZ",
    "BOX",
    "BOXL",
    "BP",
    "BPFH",
    "BPL",
    "BPMC",
    "BPMP",
    "BPMX",
    "BPOP",
    "BPOPM",
    "BPOPN",
    "BPR",
    "BPRAP",
    "BPRN",
    "BPT",
    "BPTH",
    "BPY",
    "BPYPO",
    "BPYPP",
    "BQH",
    "BR",
    "BRC",
    "BREW",
    "BRFS",
    "BRG",
    "BRG^A",
    "BRG^C",
    "BRG^D",
    "BRID",
    "BRK.A",
    "BRK.B",
    "BRKL",
    "BRKR",
    "BRKS",
    "BRN",
    "BRO",
    "BROG",
    "BROGR",
    "BROGU",
    "BROGW",
    "BRPA",
    "BRPAR",
    "BRPAU",
    "BRPAW",
    "BRPM",
    "BRPM.U",
    "BRPM.WS",
    "BRQS",
    "BRT",
    "BRX",
    "BRY",
    "BSA",
    "BSAC",
    "BSBR",
    "BSD",
    "BSE",
    "BSET",
    "BSGM",
    "BSIG",
    "BSL",
    "BSM",
    "BSMX",
    "BSQR",
    "BSRR",
    "BST",
    "BSTC",
    "BSTZ",
    "BSVN",
    "BSX",
    "BT",
    "BTA",
    "BTAI",
    "BTE",
    "BTEC",
    "BTG",
    "BTI",
    "BTN",
    "BTO",
    "BTT",
    "BTU",
    "BTZ",
    "BUD",
    "BUI",
    "BURG",
    "BURL",
    "BUSE",
    "BV",
    "BVN",
    "BVSN",
    "BVXV",
    "BVXVW",
    "BW",
    "BWA",
    "BWAY",
    "BWB",
    "BWEN",
    "BWFG",
    "BWG",
    "BWL.A",
    "BWMC",
    "BWMCU",
    "BWMCW",
    "BWXT",
    "BX",
    "BXC",
    "BXG",
    "BXMT",
    "BXMX",
    "BXP",
    "BXP^B",
    "BXS",
    "BY",
    "BYD",
    "BYFC",
    "BYM",
    "BYND",
    "BYSI",
    "BZH",
    "BZM",
    "BZUN",
    "C",
    "CAAP",
    "CAAS",
    "CABO",
    "CAC",
    "CACC",
    "CACG",
    "CACI",
    "CADE",
    "CAE",
    "CAF",
    "CAG",
    "CAH",
    "CAI",
    "CAI^A",
    "CAI^B",
    "CAJ",
    "CAKE",
    "CAL",
    "CALA",
    "CALM",
    "CALX",
    "CAMP",
    "CAMT",
    "CANF",
    "CANG",
    "CAPL",
    "CAPR",
    "CAR",
    "CARA",
    "CARB",
    "CARE",
    "CARG",
    "CARO",
    "CARS",
    "CART",
    "CARV",
    "CARZ",
    "CASA",
    "CASH",
    "CASI",
    "CASS",
    "CASY",
    "CAT",
    "CATB",
    "CATC",
    "CATH",
    "CATM",
    "CATO",
    "CATS",
    "CATY",
    "CB",
    "CBAN",
    "CBAT",
    "CBAY",
    "CBB",
    "CBB^B",
    "CBD",
    "CBFV",
    "CBH",
    "CBIO",
    "CBL",
    "CBLI",
    "CBLK",
    "CBL^D",
    "CBL^E",
    "CBM",
    "CBMB",
    "CBMG",
    "CBNK",
    "CBO",
    "CBOE",
    "CBPO",
    "CBPX",
    "CBRE",
    "CBRL",
    "CBS",
    "CBS.A",
    "CBSH",
    "CBSHP",
    "CBT",
    "CBTX",
    "CBU",
    "CBUS",
    "CBX",
    "CBZ",
    "CC",
    "CCB",
    "CCBG",
    "CCC",
    "CCC.WS",
    "CCCL",
    "CCD",
    "CCEP",
    "CCF",
    "CCH",
    "CCH.U",
    "CCH.WS",
    "CCI",
    "CCI^A",
    "CCJ",
    "CCK",
    "CCL",
    "CCLP",
    "CCM",
    "CCMP",
    "CCNE",
    "CCO",
    "CCOI",
    "CCR",
    "CCRC",
    "CCRN",
    "CCS",
    "CCU",
    "CCX",
    "CCX.U",
    "CCX.WS",
    "CCXI",
    "CCZ",
    "CDAY",
    "CDC",
    "CDE",
    "CDEV",
    "CDK",
    "CDL",
    "CDLX",
    "CDMO",
    "CDMOP",
    "CDNA",
    "CDNS",
    "CDOR",
    "CDR",
    "CDR^B",
    "CDR^C",
    "CDTX",
    "CDW",
    "CDXC",
    "CDXS",
    "CDZI",
    "CE",
    "CEA",
    "CECE",
    "CECO",
    "CEE",
    "CEI",
    "CEIX",
    "CEL",
    "CELC",
    "CELG",
    "CELGZ",
    "CELH",
    "CELP",
    "CEM",
    "CEMI",
    "CEN",
    "CENT",
    "CENTA",
    "CENX",
    "CEO",
    "CEPU",
    "CEQP",
    "CEQP^",
    "CERC",
    "CERN",
    "CERS",
    "CET",
    "CETV",
    "CETX",
    "CETXP",
    "CETXW",
    "CEV",
    "CEVA",
    "CEY",
    "CEZ",
    "CF",
    "CFA",
    "CFB",
    "CFBI",
    "CFBK",
    "CFFA",
    "CFFAU",
    "CFFAW",
    "CFFI",
    "CFFN",
    "CFG",
    "CFG^D",
    "CFMS",
    "CFO",
    "CFR",
    "CFRX",
    "CFR^A",
    "CFX",
    "CFXA",
    "CG",
    "CGA",
    "CGBD",
    "CGC",
    "CGEN",
    "CGIX",
    "CGNX",
    "CGO",
    "CHA",
    "CHAC",
    "CHAC.U",
    "CHAC.WS",
    "CHAP",
    "CHCI",
    "CHCO",
    "CHCT",
    "CHD",
    "CHDN",
    "CHE",
    "CHEF",
    "CHEK",
    "CHEKW",
    "CHEKZ",
    "CHFS",
    "CHGG",
    "CHH",
    "CHI",
    "CHIC",
    "CHK",
    "CHKP",
    "CHKR",
    "CHK^D",
    "CHL",
    "CHMA",
    "CHMG",
    "CHMI",
    "CHMI^A",
    "CHMI^B",
    "CHN",
    "CHNA",
    "CHNG",
    "CHNGU",
    "CHNR",
    "CHRA",
    "CHRS",
    "CHRW",
    "CHS",
    "CHSCL",
    "CHSCM",
    "CHSCN",
    "CHSCO",
    "CHSCP",
    "CHSP",
    "CHT",
    "CHTR",
    "CHU",
    "CHUY",
    "CHW",
    "CHWY",
    "CHY",
    "CI",
    "CIA",
    "CIB",
    "CIBR",
    "CID",
    "CIDM",
    "CIEN",
    "CIF",
    "CIFS",
    "CIG",
    "CIG.C",
    "CIGI",
    "CIH",
    "CII",
    "CIK",
    "CIL",
    "CIM",
    "CIM^A",
    "CIM^B",
    "CIM^C",
    "CIM^D",
    "CINF",
    "CINR",
    "CIO",
    "CIO^A",
    "CIR",
    "CISN",
    "CIT",
    "CIVB",
    "CIVBP",
    "CIX",
    "CIZ",
    "CIZN",
    "CJ",
    "CJJD",
    "CKH",
    "CKPT",
    "CKX",
    "CL",
    "CLAR",
    "CLB",
    "CLBK",
    "CLBS",
    "CLCT",
    "CLDB",
    "CLDR",
    "CLDT",
    "CLDX",
    "CLF",
    "CLFD",
    "CLGN",
    "CLGX",
    "CLH",
    "CLI",
    "CLIR",
    "CLLS",
    "CLM",
    "CLMT",
    "CLNC",
    "CLNE",
    "CLNY",
    "CLNY^B",
    "CLNY^E",
    "CLNY^G",
    "CLNY^H",
    "CLNY^I",
    "CLNY^J",
    "CLOU",
    "CLPR",
    "CLPS",
    "CLR",
    "CLRB",
    "CLRBZ",
    "CLRG",
    "CLRO",
    "CLS",
    "CLSD",
    "CLSN",
    "CLUB",
    "CLVS",
    "CLW",
    "CLWT",
    "CLX",
    "CLXT",
    "CM",
    "CMA",
    "CMBM",
    "CMC",
    "CMCL",
    "CMCM",
    "CMCO",
    "CMCSA",
    "CMCT",
    "CMCTP",
    "CMD",
    "CME",
    "CMFNL",
    "CMG",
    "CMI",
    "CMLS",
    "CMO",
    "CMO^E",
    "CMP",
    "CMPR",
    "CMRE",
    "CMRE^B",
    "CMRE^C",
    "CMRE^D",
    "CMRE^E",
    "CMRX",
    "CMS",
    "CMSA",
    "CMSC",
    "CMSD",
    "CMS^B",
    "CMT",
    "CMTL",
    "CMU",
    "CNA",
    "CNAT",
    "CNBKA",
    "CNC",
    "CNCE",
    "CNCR",
    "CNDT",
    "CNET",
    "CNF",
    "CNFR",
    "CNFRL",
    "CNHI",
    "CNI",
    "CNK",
    "CNMD",
    "CNNE",
    "CNO",
    "CNOB",
    "CNP",
    "CNP^B",
    "CNQ",
    "CNR",
    "CNS",
    "CNSL",
    "CNST",
    "CNTF",
    "CNTX",
    "CNTY",
    "CNX",
    "CNXM",
    "CNXN",
    "CO",
    "COCP",
    "CODA",
    "CODI",
    "CODI^A",
    "CODI^B",
    "CODX",
    "COE",
    "COF",
    "COF^C",
    "COF^D",
    "COF^F",
    "COF^G",
    "COF^H",
    "COF^P",
    "COG",
    "COHN",
    "COHR",
    "COHU",
    "COKE",
    "COLB",
    "COLD",
    "COLL",
    "COLM",
    "COMM",
    "COMT",
    "CONE",
    "CONN",
    "COO",
    "COOP",
    "COP",
    "COR",
    "CORE",
    "CORR",
    "CORR^A",
    "CORT",
    "CORV",
    "COST",
    "COT",
    "COTY",
    "COUP",
    "COWN",
    "COWNL",
    "COWNZ",
    "CP",
    "CPA",
    "CPAA",
    "CPAAU",
    "CPAAW",
    "CPAC",
    "CPAH",
    "CPB",
    "CPE",
    "CPF",
    "CPG",
    "CPHC",
    "CPHI",
    "CPIX",
    "CPK",
    "CPL",
    "CPLG",
    "CPLP",
    "CPRI",
    "CPRT",
    "CPRX",
    "CPS",
    "CPSH",
    "CPSI",
    "CPSS",
    "CPST",
    "CPT",
    "CPTA",
    "CPTAG",
    "CPTAL",
    "CPTI",
    "CQP",
    "CR",
    "CRAI",
    "CRAY",
    "CRBP",
    "CRC",
    "CRCM",
    "CRD.A",
    "CRD.B",
    "CREE",
    "CREG",
    "CRESY",
    "CREX",
    "CREXW",
    "CRF",
    "CRH",
    "CRHM",
    "CRI",
    "CRIS",
    "CRK",
    "CRL",
    "CRM",
    "CRMD",
    "CRMT",
    "CRNT",
    "CRNX",
    "CRON",
    "CROX",
    "CRR",
    "CRS",
    "CRSA",
    "CRSAU",
    "CRSAW",
    "CRSP",
    "CRT",
    "CRTO",
    "CRTX",
    "CRUS",
    "CRVL",
    "CRVS",
    "CRWD",
    "CRWS",
    "CRY",
    "CRZO",
    "CS",
    "CSA",
    "CSB",
    "CSBR",
    "CSCO",
    "CSF",
    "CSFL",
    "CSGP",
    "CSGS",
    "CSII",
    "CSIQ",
    "CSL",
    "CSLT",
    "CSML",
    "CSOD",
    "CSPI",
    "CSQ",
    "CSS",
    "CSSE",
    "CSSEP",
    "CSTE",
    "CSTL",
    "CSTM",
    "CSTR",
    "CSU",
    "CSV",
    "CSWC",
    "CSWCL",
    "CSWI",
    "CSX",
    "CTAA",
    "CTAC",
    "CTACU",
    "CTACW",
    "CTAS",
    "CTA^A",
    "CTA^B",
    "CTB",
    "CTBB",
    "CTBI",
    "CTDD",
    "CTEK",
    "CTEST",
    "CTEST.E",
    "CTEST.G",
    "CTEST.L",
    "CTEST.O",
    "CTEST.S",
    "CTEST.V",
    "CTG",
    "CTHR",
    "CTIB",
    "CTIC",
    "CTK",
    "CTL",
    "CTLT",
    "CTMX",
    "CTO",
    "CTR",
    "CTRA",
    "CTRC",
    "CTRE",
    "CTRM",
    "CTRN",
    "CTRP",
    "CTS",
    "CTSH",
    "CTSO",
    "CTST",
    "CTT           ",
    "CTV",
    "CTVA",
    "CTWS",
    "CTXR",
    "CTXRW",
    "CTXS",
    "CTY",
    "CTZ",
    "CUB",
    "CUBA",
    "CUBE",
    "CUBI",
    "CUBI^C",
    "CUBI^D",
    "CUBI^E",
    "CUBI^F",
    "CUE",
    "CUI",
    "CUK",
    "CULP",
    "CUO",
    "CUR",
    "CURO",
    "CUTR",
    "CUZ",
    "CVA",
    "CVBF",
    "CVCO",
    "CVCY",
    "CVE",
    "CVEO",
    "CVET",
    "CVGI",
    "CVGW",
    "CVI",
    "CVIA",
    "CVLT",
    "CVLY",
    "CVM",
    "CVNA",
    "CVR",
    "CVRS",
    "CVS",
    "CVTI",
    "CVU",
    "CVV",
    "CVX",
    "CW",
    "CWBC",
    "CWBR",
    "CWCO",
    "CWEN",
    "CWEN.A",
    "CWH",
    "CWK",
    "CWST",
    "CWT",
    "CX",
    "CXDC",
    "CXE",
    "CXH",
    "CXO",
    "CXP",
    "CXSE",
    "CXW",
    "CY",
    "CYAD",
    "CYAN",
    "CYBE",
    "CYBR",
    "CYCC",
    "CYCCP",
    "CYCN",
    "CYD",
    "CYH",
    "CYOU",
    "CYRN",
    "CYRX",
    "CYRXW",
    "CYTK",
    "CZNC",
    "CZR",
    "CZWI",
    "CZZ",
    "C^J",
    "C^K",
    "C^N",
    "C^S",
    "D",
    "DAC",
    "DAIO",
    "DAKT",
    "DAL",
    "DALI",
    "DAN",
    "DAR",
    "DARE",
    "DAVA",
    "DAVE",
    "DAX",
    "DB",
    "DBD",
    "DBI",
    "DBL",
    "DBVT",
    "DBX",
    "DCAR",
    "DCF",
    "DCI",
    "DCIX",
    "DCO",
    "DCOM",
    "DCP",
    "DCPH",
    "DCP^B",
    "DCP^C",
    "DCUE",
    "DD",
    "DDD",
    "DDF",
    "DDIV",
    "DDMX",
    "DDMXU",
    "DDMXW",
    "DDOC",
    "DDS",
    "DDT",
    "DE",
    "DEA",
    "DEAC",
    "DEACU",
    "DEACW",
    "DECK",
    "DEI",
    "DELL",
    "DENN",
    "DEO",
    "DERM",
    "DESP",
    "DEST",
    "DEX",
    "DF",
    "DFBH",
    "DFBHU",
    "DFBHW",
    "DFFN",
    "DFIN",
    "DFNL",
    "DFP",
    "DFRG",
    "DFS",
    "DFVL",
    "DFVS",
    "DG",
    "DGICA",
    "DGICB",
    "DGII",
    "DGLD",
    "DGLY",
    "DGRE",
    "DGRS",
    "DGRW",
    "DGSE",
    "DGX",
    "DHF",
    "DHI",
    "DHIL",
    "DHR",
    "DHR^A",
    "DHT",
    "DHX",
    "DHXM",
    "DHY",
    "DIAX",
    "DIN",
    "DINT",
    "DIOD",
    "DIS",
    "DISCA",
    "DISCB",
    "DISCK",
    "DISH",
    "DIT",
    "DJCO",
    "DK",
    "DKL",
    "DKS",
    "DKT",
    "DL",
    "DLA",
    "DLB",
    "DLBS",
    "DLHC",
    "DLNG",
    "DLNG^A",
    "DLNG^B",
    "DLPH",
    "DLPN",
    "DLPNW",
    "DLR",
    "DLR^C",
    "DLR^G",
    "DLR^I",
    "DLR^J",
    "DLR^K",
    "DLTH",
    "DLTR",
    "DLX",
    "DMAC",
    "DMB",
    "DMF",
    "DMLP",
    "DMO",
    "DMPI",
    "DMRC",
    "DMTK",
    "DMTKW",
    "DNBF",
    "DNI",
    "DNJR",
    "DNKN",
    "DNLI",
    "DNN",
    "DNOW",
    "DNP",
    "DNR",
    "DO",
    "DOC",
    "DOCU",
    "DOGZ",
    "DOMO",
    "DOOO",
    "DOOR",
    "DORM",
    "DOV",
    "DOVA",
    "DOW",
    "DOX",
    "DOYU",
    "DPG",
    "DPHC",
    "DPHCU",
    "DPHCW",
    "DPLO",
    "DPW",
    "DPZ",
    "DQ",
    "DRAD",
    "DRADP",
    "DRD",
    "DRE",
    "DRH",
    "DRI",
    "DRIO",
    "DRIOW",
    "DRIV",
    "DRMT",
    "DRNA",
    "DRQ",
    "DRRX",
    "DRUA",
    "DRYS",
    "DS",
    "DSE",
    "DSGX",
    "DSKE",
    "DSKEW",
    "DSL",
    "DSLV",
    "DSM",
    "DSPG",
    "DSS",
    "DSSI",
    "DSU",
    "DSWL",
    "DSX",
    "DSX^B",
    "DS^B",
    "DS^C",
    "DS^D",
    "DT",
    "DTE",
    "DTEA",
    "DTF",
    "DTIL",
    "DTJ",
    "DTLA^",
    "DTQ",
    "DTSS",
    "DTUL",
    "DTUS",
    "DTV",
    "DTW",
    "DTY",
    "DTYL",
    "DTYS",
    "DUC",
    "DUK",
    "DUKB",
    "DUKH",
    "DUK^A",
    "DUSA",
    "DVA",
    "DVAX",
    "DVD",
    "DVLU",
    "DVN",
    "DVOL",
    "DVY",
    "DWAQ",
    "DWAS",
    "DWAT",
    "DWCR",
    "DWFI",
    "DWIN",
    "DWLD",
    "DWMC",
    "DWPP",
    "DWSH",
    "DWSN",
    "DWTR",
    "DX",
    "DXB",
    "DXC",
    "DXCM",
    "DXF",
    "DXGE",
    "DXJS",
    "DXLG",
    "DXPE",
    "DXR",
    "DXYN",
    "DX^A",
    "DX^B",
    "DY",
    "DYAI",
    "DYNT",
    "DZSI",
    "E",
    "EA",
    "EAB",
    "EAD",
    "EAE",
    "EAF",
    "EAI",
    "EARN",
    "EARS",
    "EAST",
    "EAT",
    "EB",
    "EBAY",
    "EBAYL",
    "EBF",
    "EBIX",
    "EBIZ",
    "EBMT",
    "EBR",
    "EBR.B",
    "EBS",
    "EBSB",
    "EBTC",
    "EC",
    "ECA",
    "ECC           ",
    "ECCA",
    "ECCB",
    "ECCX",
    "ECCY",
    "ECF",
    "ECF^A",
    "ECHO",
    "ECL",
    "ECOL",
    "ECOM          ",
    "ECOR",
    "ECOW",
    "ECPG",
    "ECT",
    "ED",
    "EDAP",
    "EDD",
    "EDF",
    "EDI",
    "EDIT",
    "EDN",
    "EDNT",
    "EDRY",
    "EDSA",
    "EDTX",
    "EDTXU",
    "EDTXW",
    "EDU",
    "EDUC",
    "EE",
    "EEA",
    "EEFT",
    "EEI",
    "EEMA",
    "EEX",
    "EFAS",
    "EFBI",
    "EFC",
    "EFF",
    "EFL",
    "EFOI",
    "EFR",
    "EFSC",
    "EFT",
    "EFX",
    "EGAN",
    "EGBN",
    "EGF",
    "EGHT",
    "EGI",
    "EGIF",
    "EGLE",
    "EGO",
    "EGOV",
    "EGP",
    "EGRX",
    "EGY",
    "EHC",
    "EHI",
    "EHR",
    "EHT",
    "EHTH",
    "EIC",
    "EIDX",
    "EIG",
    "EIGI",
    "EIGR",
    "EIM",
    "EIX",
    "EKSO",
    "EL",
    "ELAN",
    "ELC",
    "ELF",
    "ELGX",
    "ELJ",
    "ELLO",
    "ELMD",
    "ELOX",
    "ELP",
    "ELS",
    "ELSE",
    "ELTK",
    "ELU",
    "ELVT",
    "ELY",
    "EMAN",
    "EMB",
    "EMCB",
    "EMCF",
    "EMCG",
    "EMCI",
    "EMD",
    "EME",
    "EMF",
    "EMIF",
    "EMKR",
    "EML",
    "EMMS",
    "EMN",
    "EMO",
    "EMP",
    "EMR",
    "EMX",
    "EMXC",
    "ENB",
    "ENBA",
    "ENBL",
    "ENDP",
    "ENFC",
    "ENG",
    "ENIA",
    "ENIC",
    "ENJ",
    "ENLC",
    "ENLV",
    "ENO",
    "ENOB",
    "ENPH",
    "ENR",
    "ENR^A",
    "ENS",
    "ENSG",
    "ENSV",
    "ENT",
    "ENTA",
    "ENTG",
    "ENTX",
    "ENTXW",
    "ENV",
    "ENVA",
    "ENX",
    "ENZ",
    "ENZL",
    "EOD",
    "EOG",
    "EOI",
    "EOLS",
    "EOS",
    "EOT",
    "EPAM",
    "EPAY",
    "EPC",
    "EPD",
    "EPIX",
    "EPM",
    "EPR",
    "EPRT",
    "EPR^C",
    "EPR^E",
    "EPR^G",
    "EPSN",
    "EPZM",
    "EP^C",
    "EQ",
    "EQBK",
    "EQC",
    "EQC^D",
    "EQH",
    "EQIX",
    "EQM",
    "EQNR",
    "EQR",
    "EQRR",
    "EQS",
    "EQT",
    "ERA",
    "ERC",
    "ERF",
    "ERH",
    "ERI",
    "ERIC",
    "ERIE",
    "ERII",
    "ERJ",
    "EROS",
    "ERYP",
    "ES",
    "ESBK",
    "ESCA",
    "ESE",
    "ESEA",
    "ESG",
    "ESGD",
    "ESGE",
    "ESGG",
    "ESGR",
    "ESGRO",
    "ESGRP",
    "ESGU",
    "ESI",
    "ESLT",
    "ESNT",
    "ESP",
    "ESPR",
    "ESQ",
    "ESRT",
    "ESS",
    "ESSA",
    "ESTA",
    "ESTC",
    "ESTE",
    "ESTR",
    "ESTRW",
    "ESXB",
    "ET",
    "ETB",
    "ETFC",
    "ETG",
    "ETH",
    "ETI^",
    "ETJ",
    "ETM",
    "ETN",
    "ETO",
    "ETON",
    "ETP^C",
    "ETP^D",
    "ETP^E",
    "ETR",
    "ETRN",
    "ETSY",
    "ETTX",
    "ETV",
    "ETW",
    "ETX           ",
    "ETY",
    "EUFN",
    "EURN",
    "EV",
    "EVA",
    "EVBG",
    "EVBN",
    "EVC",
    "EVER",
    "EVF",
    "EVFM",
    "EVG",
    "EVGBC",
    "EVGN",
    "EVH",
    "EVI",
    "EVK",
    "EVLMC",
    "EVLO",
    "EVM",
    "EVN",
    "EVOK",
    "EVOL",
    "EVOP",
    "EVR",
    "EVRG",
    "EVRI",
    "EVSI",
    "EVSIW",
    "EVSTC",
    "EVT",
    "EVTC",
    "EVV",
    "EVY",
    "EW",
    "EWBC",
    "EWJE",
    "EWJV",
    "EWZS",
    "EXAS",
    "EXC",
    "EXD",
    "EXEL",
    "EXFO",
    "EXG",
    "EXK",
    "EXLS",
    "EXP",
    "EXPC",
    "EXPCU",
    "EXPD",
    "EXPE",
    "EXPI",
    "EXPO",
    "EXPR",
    "EXR",
    "EXTN",
    "EXTR",
    "EYE",
    "EYEG",
    "EYEGW",
    "EYEN",
    "EYES",
    "EYESW",
    "EYPT",
    "EZPW",
    "EZT",
    "F",
    "FAAR",
    "FAB",
    "FAD",
    "FAF",
    "FALN",
    "FAM",
    "FAMI",
    "FANG",
    "FANH",
    "FARM",
    "FARO",
    "FAST",
    "FAT",
    "FATE",
    "FAX",
    "FB",
    "FBC",
    "FBHS",
    "FBIO",
    "FBIOP",
    "FBIZ",
    "FBK",
    "FBM",
    "FBMS",
    "FBNC",
    "FBP",
    "FBSS",
    "FBZ",
    "FC",
    "FCA",
    "FCAL",
    "FCAN",
    "FCAP",
    "FCAU",
    "FCBC",
    "FCBP",
    "FCCO",
    "FCCY",
    "FCEF",
    "FCEL",
    "FCF",
    "FCFS",
    "FCN",
    "FCNCA",
    "FCO",
    "FCPT",
    "FCSC",
    "FCT",
    "FCVT",
    "FCX",
    "FDBC",
    "FDEF",
    "FDEU",
    "FDIV",
    "FDNI",
    "FDP",
    "FDS",
    "FDT",
    "FDTS",
    "FDUS",
    "FDUSL",
    "FDUSZ",
    "FDX",
    "FE",
    "FEDU",
    "FEI           ",
    "FEIM",
    "FELE",
    "FELP",
    "FEM",
    "FEMB",
    "FEMS",
    "FEN",
    "FENC",
    "FENG",
    "FEO",
    "FEP",
    "FET",
    "FEUZ",
    "FEX",
    "FEYE",
    "FF",
    "FFA",
    "FFBC",
    "FFBW",
    "FFC",
    "FFG",
    "FFHL",
    "FFIC",
    "FFIN",
    "FFIV",
    "FFNW",
    "FFWM",
    "FG",
    "FG.WS",
    "FGB",
    "FGBI",
    "FGEN",
    "FGM",
    "FGP",
    "FHB",
    "FHK",
    "FHL",
    "FHN",
    "FHN^A",
    "FI",
    "FIBK",
    "FICO",
    "FID",
    "FIF",
    "FII",
    "FINS",
    "FINX",
    "FIS",
    "FISI",
    "FISV",
    "FIT",
    "FITB",
    "FITBI",
    "FITBP",
    "FIV",
    "FIVE",
    "FIVN",
    "FIX",
    "FIXD",
    "FIXX",
    "FIZZ",
    "FJP",
    "FKLY",
    "FKO",
    "FKU",
    "FL",
    "FLAG",
    "FLAT",
    "FLC",
    "FLDM",
    "FLEX",
    "FLGT",
    "FLIC",
    "FLIR",
    "FLL",
    "FLLCU",
    "FLMN",
    "FLMNW",
    "FLN",
    "FLNG",
    "FLNT",
    "FLO",
    "FLOW",
    "FLR",
    "FLS",
    "FLT",
    "FLUX",
    "FLWR",
    "FLWS",
    "FLXN",
    "FLXS",
    "FLY",
    "FMAO",
    "FMAX",
    "FMB",
    "FMBH",
    "FMBI",
    "FMC",
    "FMCI",
    "FMCIU",
    "FMCIW",
    "FMHI",
    "FMK",
    "FMN",
    "FMNB",
    "FMO",
    "FMS",
    "FMX",
    "FMY",
    "FN",
    "FNB",
    "FNB^E",
    "FNCB",
    "FND",
    "FNF",
    "FNHC",
    "FNJN",
    "FNK",
    "FNKO",
    "FNLC",
    "FNSR",
    "FNV",
    "FNWB",
    "FNX",
    "FNY",
    "FOCS",
    "FOE",
    "FOF",
    "FOLD",
    "FOMX",
    "FONR",
    "FOR",
    "FORD",
    "FORK",
    "FORM",
    "FORR",
    "FORTY",
    "FOSL",
    "FOX",
    "FOXA",
    "FOXF",
    "FPA",
    "FPAC",
    "FPAC.U",
    "FPAC.WS",
    "FPAY",
    "FPAYW",
    "FPF",
    "FPH",
    "FPI",
    "FPI^B",
    "FPL",
    "FPRX",
    "FPXE",
    "FPXI",
    "FR",
    "FRA",
    "FRAC",
    "FRAF",
    "FRAN",
    "FRBA",
    "FRBK",
    "FRC",
    "FRC^D",
    "FRC^F",
    "FRC^G",
    "FRC^H",
    "FRC^I",
    "FRD",
    "FRED",
    "FRGI",
    "FRME",
    "FRO",
    "FRPH",
    "FRPT",
    "FRSX",
    "FRT",
    "FRTA",
    "FRT^C",
    "FSB",
    "FSBC",
    "FSBW",
    "FSCT",
    "FSD",
    "FSEA",
    "FSFG",
    "FSI",
    "FSK",
    "FSLR",
    "FSLY",
    "FSM",
    "FSP",
    "FSS",
    "FSTR",
    "FSV",
    "FSZ",
    "FT",
    "FTA",
    "FTAC",
    "FTACU",
    "FTACW",
    "FTAG",
    "FTAI",
    "FTC",
    "FTCH",
    "FTCS",
    "FTDR",
    "FTEK",
    "FTEO",
    "FTF",
    "FTFT",
    "FTGC",
    "FTHI",
    "FTI",
    "FTK",
    "FTLB",
    "FTNT",
    "FTNW",
    "FTR",
    "FTRI",
    "FTS",
    "FTSI",
    "FTSL",
    "FTSM",
    "FTSV",
    "FTV",
    "FTV^A",
    "FTXD",
    "FTXG",
    "FTXH",
    "FTXL",
    "FTXN",
    "FTXO",
    "FTXR",
    "FUL",
    "FULC",
    "FULT",
    "FUN",
    "FUNC",
    "FUND",
    "FUSB",
    "FUV",
    "FV",
    "FVC",
    "FVCB",
    "FVE",
    "FVRR",
    "FWONA",
    "FWONK",
    "FWP",
    "FWRD",
    "FXNC",
    "FYC",
    "FYT",
    "FYX",
    "F^B",
    "G",
    "GAB",
    "GABC",
    "GAB^D",
    "GAB^G",
    "GAB^H",
    "GAB^J",
    "GAIA",
    "GAIN",
    "GAINL",
    "GAINM",
    "GALT",
    "GAM",
    "GAM^B",
    "GARS",
    "GASS",
    "GATX",
    "GBAB",
    "GBCI",
    "GBDC",
    "GBL",
    "GBLI",
    "GBLIL",
    "GBLIZ",
    "GBLK",
    "GBR",
    "GBT",
    "GBX",
    "GCAP",
    "GCBC",
    "GCI",
    "GCO",
    "GCP",
    "GCV",
    "GCVRZ",
    "GCV^B",
    "GD",
    "GDDY",
    "GDEN",
    "GDI",
    "GDL",
    "GDL^C",
    "GDO",
    "GDOT",
    "GDP",
    "GDS",
    "GDV",
    "GDV^A",
    "GDV^D",
    "GDV^G",
    "GDV^H",
    "GE",
    "GEC",
    "GECC",
    "GECCL",
    "GECCM",
    "GECCN",
    "GEF",
    "GEF.B",
    "GEL",
    "GEMP",
    "GEN           ",
    "GENC",
    "GENE",
    "GENY",
    "GEO",
    "GEOS",
    "GER",
    "GERN",
    "GES",
    "GEVO",
    "GF",
    "GFED",
    "GFF",
    "GFI",
    "GFN",
    "GFNCP",
    "GFNSL",
    "GFY",
    "GGAL",
    "GGB",
    "GGG",
    "GGM",
    "GGN",
    "GGN^B",
    "GGO",
    "GGO^A",
    "GGT",
    "GGT^B",
    "GGT^E",
    "GGZ",
    "GGZ^A",
    "GH",
    "GHC",
    "GHDX",
    "GHG",
    "GHL",
    "GHM",
    "GHSI",
    "GHY",
    "GIB",
    "GIFI",
    "GIG",
    "GIG.U",
    "GIG.WS",
    "GIGE",
    "GIGM",
    "GIG~",
    "GIII",
    "GIL",
    "GILD",
    "GILT",
    "GIM",
    "GIS",
    "GIX",
    "GIX.U",
    "GIX.WS",
    "GIX~",
    "GJH",
    "GJO",
    "GJP",
    "GJR",
    "GJS",
    "GJT",
    "GJV",
    "GKOS",
    "GL",
    "GLAC",
    "GLACR",
    "GLACU",
    "GLACW",
    "GLAD",
    "GLADD",
    "GLADN",
    "GLBS",
    "GLBZ",
    "GLDD",
    "GLDI",
    "GLG",
    "GLIBA",
    "GLIBP",
    "GLMD",
    "GLNG",
    "GLO",
    "GLOB",
    "GLOG",
    "GLOG^A",
    "GLOP",
    "GLOP^A",
    "GLOP^B",
    "GLOP^C",
    "GLOW",
    "GLP",
    "GLPG",
    "GLPI",
    "GLP^A",
    "GLQ",
    "GLRE",
    "GLT",
    "GLU",
    "GLUU",
    "GLU^A",
    "GLU^B",
    "GLV",
    "GLW",
    "GLYC",
    "GL^C",
    "GM",
    "GMAB",
    "GMDA",
    "GME",
    "GMED",
    "GMHI",
    "GMHIU",
    "GMHIW",
    "GMLP",
    "GMLPP",
    "GMO",
    "GMRE",
    "GMRE^A",
    "GMS",
    "GMTA",
    "GMZ",
    "GNC",
    "GNCA",
    "GNE",
    "GNE^A",
    "GNFT",
    "GNK",
    "GNL",
    "GNLN",
    "GNL^A",
    "GNMA",
    "GNMK",
    "GNMX",
    "GNOM",
    "GNPX",
    "GNRC",
    "GNST",
    "GNT",
    "GNTX",
    "GNTY",
    "GNT^A",
    "GNUS",
    "GNW",
    "GO",
    "GOF",
    "GOGL",
    "GOGO",
    "GOL",
    "GOLD",
    "GOLF",
    "GOOD",
    "GOODM",
    "GOODO",
    "GOODP",
    "GOOG",
    "GOOGL",
    "GOOS",
    "GORO",
    "GOSS",
    "GPAQ",
    "GPAQU",
    "GPAQW",
    "GPC",
    "GPI",
    "GPJA",
    "GPK",
    "GPL",
    "GPM",
    "GPMT",
    "GPN",
    "GPOR",
    "GPP",
    "GPRE",
    "GPRK",
    "GPRO",
    "GPS",
    "GPX",
    "GRA",
    "GRAF",
    "GRAF.U",
    "GRAF.WS",
    "GRAM",
    "GRBK",
    "GRC",
    "GRF",
    "GRFS",
    "GRID",
    "GRIF",
    "GRIN",
    "GRMN",
    "GRNQ",
    "GROW",
    "GRP.U",
    "GRPN",
    "GRSH",
    "GRSHU",
    "GRSHW",
    "GRTS",
    "GRUB",
    "GRVY",
    "GRX",
    "GRX^A",
    "GRX^B",
    "GS",
    "GSAH",
    "GSAH.U",
    "GSAH.WS",
    "GSAT",
    "GSB",
    "GSBC",
    "GSBD",
    "GSH",
    "GSHD",
    "GSIT",
    "GSK",
    "GSKY",
    "GSL",
    "GSL^B",
    "GSM",
    "GSS",
    "GSUM",
    "GSV",
    "GSX",
    "GS^A",
    "GS^C",
    "GS^D",
    "GS^J",
    "GS^K",
    "GS^N",
    "GT",
    "GTE",
    "GTES",
    "GTHX",
    "GTIM",
    "GTLS",
    "GTN",
    "GTN.A",
    "GTS",
    "GTT",
    "GTX",
    "GTY",
    "GTYH",
    "GULF",
    "GURE",
    "GUT",
    "GUT^A",
    "GUT^C",
    "GV",
    "GVA",
    "GVP",
    "GWB",
    "GWGH",
    "GWPH",
    "GWR",
    "GWRE",
    "GWRS",
    "GWW",
    "GXGX",
    "GXGXU",
    "GXGXW",
    "GYB",
    "GYC",
    "GYRO",
    "H",
    "HA",
    "HABT",
    "HAE",
    "HAFC",
    "HAIN",
    "HAIR",
    "HAL",
    "HALL",
    "HALO",
    "HARP",
    "HAS",
    "HASI",
    "HAYN",
    "HBAN",
    "HBANN",
    "HBANO",
    "HBB",
    "HBCP",
    "HBI",
    "HBIO",
    "HBM",
    "HBMD",
    "HBNC",
    "HBP",
    "HCA",
    "HCAC",
    "HCACU",
    "HCACW",
    "HCAP",
    "HCAPZ",
    "HCAT",
    "HCC",
    "HCCH",
    "HCCHR",
    "HCCHU",
    "HCCHW",
    "HCCI",
    "HCFT",
    "HCHC",
    "HCI",
    "HCKT",
    "HCM",
    "HCP",
    "HCR",
    "HCSG",
    "HCXY",
    "HCXZ",
    "HD",
    "HDB",
    "HDS",
    "HDSN",
    "HE",
    "HEAR",
    "HEBT",
    "HEES",
    "HEI",
    "HEI.A",
    "HELE",
    "HEP",
    "HEPA",
    "HEQ",
    "HERD",
    "HES",
    "HESM",
    "HEWG",
    "HEXO",
    "HFBL",
    "HFC",
    "HFFG",
    "HFRO",
    "HFRO^A",
    "HFWA",
    "HGH",
    "HGLB",
    "HGSH",
    "HGV",
    "HHC",
    "HHHH",
    "HHHHR",
    "HHHHU",
    "HHHHW",
    "HHR",
    "HHS",
    "HHT",
    "HI",
    "HIBB",
    "HIE",
    "HIFS",
    "HIG",
    "HIG^G",
    "HIHO",
    "HII",
    "HIIQ",
    "HIL",
    "HIMX",
    "HIO",
    "HIW",
    "HIX",
    "HJLI",
    "HJLIW",
    "HJV",
    "HKIB",
    "HL",
    "HLAL",
    "HLF",
    "HLG",
    "HLI",
    "HLIO",
    "HLIT",
    "HLM^",
    "HLNE",
    "HLT",
    "HLX",
    "HL^B",
    "HMC",
    "HMG",
    "HMHC",
    "HMI",
    "HMLP",
    "HMLP^A",
    "HMN",
    "HMNF",
    "HMST",
    "HMSY",
    "HMTV",
    "HMY",
    "HNDL",
    "HNGR",
    "HNI",
    "HNNA",
    "HNP",
    "HNRG",
    "HNW",
    "HOFT",
    "HOG",
    "HOLI",
    "HOLX",
    "HOMB",
    "HOME",
    "HON",
    "HONE",
    "HOOK",
    "HOPE",
    "HOS",
    "HOTH",
    "HOV",
    "HOVNP",
    "HP",
    "HPE",
    "HPF",
    "HPI",
    "HPJ",
    "HPP",
    "HPQ",
    "HPR",
    "HPS",
    "HPT",
    "HQH",
    "HQI",
    "HQL",
    "HQY",
    "HR",
    "HRB",
    "HRC",
    "HRI",
    "HRL",
    "HROW",
    "HRTG",
    "HRTX",
    "HRZN",
    "HSAC",
    "HSACU",
    "HSACW",
    "HSBC",
    "HSBC^A",
    "HSC",
    "HSDT",
    "HSGX",
    "HSIC",
    "HSII",
    "HSKA",
    "HSON",
    "HST",
    "HSTM",
    "HSY",
    "HT",
    "HTA",
    "HTBI",
    "HTBK",
    "HTBX",
    "HTD",
    "HTFA",
    "HTGC",
    "HTGM",
    "HTH",
    "HTHT",
    "HTLD",
    "HTLF",
    "HTY",
    "HTZ",
    "HT^C",
    "HT^D",
    "HT^E",
    "HUBB",
    "HUBG",
    "HUBS",
    "HUD",
    "HUM",
    "HUN",
    "HURC",
    "HURN",
    "HUSA",
    "HUYA",
    "HVBC",
    "HVT",
    "HVT.A",
    "HWBK",
    "HWC",
    "HWCC",
    "HWCPL",
    "HWKN",
    "HX",
    "HXL",
    "HY",
    "HYAC",
    "HYACU",
    "HYACW",
    "HYB",
    "HYI",
    "HYLS",
    "HYND",
    "HYRE",
    "HYT",
    "HYXE",
    "HYZD",
    "HZN",
    "HZNP",
    "HZO",
    "I",
    "IAA",
    "IAC",
    "IAE",
    "IAF",
    "IAG",
    "IART",
    "IBA",
    "IBB",
    "IBCP",
    "IBEX",
    "IBIO",
    "IBKC",
    "IBKCN",
    "IBKCO",
    "IBKCP",
    "IBM",
    "IBN",
    "IBO",
    "IBOC",
    "IBP",
    "IBTX",
    "IBUY",
    "ICAD",
    "ICBK",
    "ICCC",
    "ICCH",
    "ICD",
    "ICE",
    "ICFI",
    "ICHR",
    "ICL",
    "ICLK",
    "ICLN",
    "ICLR",
    "ICMB",
    "ICON",
    "ICPT",
    "ICUI",
    "IDA",
    "IDCC",
    "IDE",
    "IDEX",
    "IDLB",
    "IDN",
    "IDRA",
    "IDSA",
    "IDSY",
    "IDT",
    "IDXG",
    "IDXX",
    "IDYA",
    "IEA",
    "IEAWW",
    "IEC",
    "IEF",
    "IEI",
    "IEP",
    "IESC",
    "IEUS",
    "IEX",
    "IFEU",
    "IFF",
    "IFFT",
    "IFGL",
    "IFMK",
    "IFN",
    "IFRX",
    "IFS",
    "IFV",
    "IGA",
    "IGC",
    "IGD",
    "IGF",
    "IGI",
    "IGIB",
    "IGLD",
    "IGLE",
    "IGOV",
    "IGR",
    "IGSB",
    "IGT",
    "IHC",
    "IHD",
    "IHG",
    "IHIT",
    "IHRT",
    "IHT",
    "IHTA",
    "IID",
    "IIF",
    "III",
    "IIIN",
    "IIIV",
    "IIM",
    "IIN",
    "IIPR",
    "IIPR^A",
    "IIVI",
    "IJT",
    "IKNX",
    "ILMN",
    "ILPT",
    "IMAC",
    "IMACW",
    "IMAX",
    "IMBI",
    "IMGN",
    "IMH",
    "IMI",
    "IMKTA",
    "IMMP",
    "IMMR",
    "IMMU",
    "IMO",
    "IMOS",
    "IMRN",
    "IMRNW",
    "IMTE",
    "IMUX",
    "IMV",
    "IMXI",
    "INAP",
    "INB",
    "INBK",
    "INBKL",
    "INBKZ",
    "INCY",
    "INDB",
    "INDY",
    "INF",
    "INFI",
    "INFN",
    "INFO",
    "INFR",
    "INFU",
    "INFY",
    "ING",
    "INGN",
    "INGR",
    "INMB",
    "INMD",
    "INN",
    "INNT",
    "INN^D",
    "INN^E",
    "INO",
    "INOD",
    "INOV",
    "INPX",
    "INS",
    "INSE",
    "INSG",
    "INSI",
    "INSM",
    "INSP",
    "INST",
    "INSU",
    "INSUU",
    "INSUW",
    "INSW",
    "INSW^A",
    "INT",
    "INTC",
    "INTG",
    "INTL",
    "INTT",
    "INTU",
    "INUV",
    "INVA",
    "INVE",
    "INVH",
    "INWK",
    "INXN",
    "IO",
    "IONS",
    "IOR",
    "IOSP",
    "IOTS",
    "IOVA",
    "IP",
    "IPAR",
    "IPB",
    "IPDN",
    "IPG",
    "IPGP",
    "IPHI",
    "IPHS",
    "IPI",
    "IPKW",
    "IPLDP",
    "IPOA",
    "IPOA.U",
    "IPOA.WS",
    "IPWR",
    "IQ",
    "IQI",
    "IQV",
    "IR",
    "IRBT",
    "IRCP",
    "IRDM",
    "IRET",
    "IRET^C",
    "IRIX",
    "IRL",
    "IRM",
    "IRMD",
    "IROQ",
    "IRR",
    "IRS",
    "IRT",
    "IRTC",
    "IRWD",
    "ISBC",
    "ISCA",
    "ISD",
    "ISDR",
    "ISDS",
    "ISDX",
    "ISEE",
    "ISEM",
    "ISG",
    "ISHG",
    "ISIG",
    "ISNS",
    "ISR",
    "ISRG",
    "ISRL",
    "ISSC",
    "ISTB",
    "ISTR",
    "IT",
    "ITCB",
    "ITCI",
    "ITEQ",
    "ITGR",
    "ITI",
    "ITIC",
    "ITMR",
    "ITP",
    "ITRI",
    "ITRM",
    "ITRN",
    "ITT",
    "ITUB",
    "ITW",
    "IUS",
    "IUSB",
    "IUSG",
    "IUSS",
    "IUSV",
    "IVAC",
    "IVC",
    "IVH",
    "IVR",
    "IVR^A",
    "IVR^B",
    "IVR^C",
    "IVZ",
    "IX",
    "IXUS",
    "IZEA",
    "JACK",
    "JAG",
    "JAGX",
    "JAKK",
    "JAN",
    "JASN",
    "JAX",
    "JAZZ",
    "JBGS",
    "JBHT",
    "JBK",
    "JBL",
    "JBLU",
    "JBN",
    "JBR",
    "JBSS",
    "JBT",
    "JCAP",
    "JCAP^B",
    "JCE",
    "JCI",
    "JCO",
    "JCOM",
    "JCP",
    "JCS",
    "JCTCF",
    "JD",
    "JDD",
    "JE",
    "JEC",
    "JEF",
    "JELD",
    "JEMD",
    "JEQ",
    "JE^A",
    "JFIN",
    "JFK",
    "JFKKR",
    "JFKKU",
    "JFKKW",
    "JFR",
    "JFU",
    "JG",
    "JGH",
    "JHAA",
    "JHB",
    "JHD",
    "JHG",
    "JHI",
    "JHS",
    "JHX",
    "JHY",
    "JILL",
    "JJSF",
    "JKHY",
    "JKI",
    "JKS",
    "JLL",
    "JLS",
    "JMEI",
    "JMF",
    "JMIA",
    "JMLP",
    "JMM",
    "JMP",
    "JMPB",
    "JMPD",
    "JMT",
    "JMU",
    "JNCE",
    "JNJ",
    "JNPR",
    "JOB",
    "JOBS",
    "JOE",
    "JOF",
    "JOUT",
    "JP",
    "JPC",
    "JPI",
    "JPM",
    "JPM^A",
    "JPM^C",
    "JPM^D",
    "JPM^F",
    "JPM^G",
    "JPM^H",
    "JPS",
    "JPT",
    "JQC",
    "JRI",
    "JRJC",
    "JRO",
    "JRS",
    "JRSH",
    "JRVR",
    "JSD",
    "JSM",
    "JSMD",
    "JSML",
    "JT",
    "JTA",
    "JTD",
    "JVA",
    "JW.A",
    "JW.B",
    "JWN",
    "JYNT",
    "K",
    "KAI",
    "KALA",
    "KALU",
    "KALV",
    "KAMN",
    "KAR",
    "KB",
    "KBAL",
    "KBH",
    "KBLM",
    "KBLMR",
    "KBLMU",
    "KBLMW",
    "KBR",
    "KBSF",
    "KBWB",
    "KBWD",
    "KBWP",
    "KBWR",
    "KBWY",
    "KCAPL",
    "KDMN",
    "KDP",
    "KE",
    "KEG",
    "KELYA",
    "KELYB",
    "KEM",
    "KEN",
    "KEP",
    "KEQU",
    "KERN",
    "KERNW",
    "KEX",
    "KEY",
    "KEYS",
    "KEY^I",
    "KEY^J",
    "KEY^K",
    "KF",
    "KFFB",
    "KFRC",
    "KFS",
    "KFY",
    "KGC",
    "KGJI",
    "KHC",
    "KIDS",
    "KIM",
    "KIM^I.CL",
    "KIM^J",
    "KIM^K.CL",
    "KIM^L",
    "KIM^M",
    "KIN",
    "KINS",
    "KIO",
    "KIQ",
    "KIRK",
    "KKR",
    "KKR^A",
    "KKR^B",
    "KL",
    "KLAC",
    "KLDO",
    "KLIC",
    "KLXE",
    "KMB",
    "KMDA",
    "KMF",
    "KMI",
    "KMPH",
    "KMPR",
    "KMT",
    "KMX",
    "KN",
    "KNDI",
    "KNL",
    "KNOP",
    "KNSA",
    "KNSL",
    "KNX",
    "KO",
    "KOD",
    "KODK",
    "KOF",
    "KOOL",
    "KOP",
    "KOPN",
    "KOS",
    "KOSS",
    "KPTI",
    "KR",
    "KRA",
    "KRC",
    "KREF",
    "KRG",
    "KRMA",
    "KRNT",
    "KRNY",
    "KRO",
    "KRP",
    "KRTX",
    "KRUS",
    "KRYS",
    "KSM",
    "KSS",
    "KSU",
    "KSU^",
    "KT",
    "KTB",
    "KTCC",
    "KTF",
    "KTH",
    "KTN",
    "KTOS",
    "KTOV",
    "KTOVW",
    "KTP",
    "KURA",
    "KVHI",
    "KW",
    "KWEB",
    "KWR",
    "KXIN",
    "KYN",
    "KYN^F",
    "KZIA",
    "KZR",
    "L",
    "LAC",
    "LACQ",
    "LACQU",
    "LACQW",
    "LAD",
    "LADR",
    "LAIX",
    "LAKE",
    "LAMR",
    "LANC",
    "LAND",
    "LANDP",
    "LARK",
    "LASR",
    "LAUR",
    "LAWS",
    "LAZ",
    "LAZY",
    "LB",
    "LBAI",
    "LBC",
    "LBRDA",
    "LBRDK",
    "LBRT",
    "LBTYA",
    "LBTYB",
    "LBTYK",
    "LBY",
    "LBYAV",
    "LBYKV",
    "LC",
    "LCA",
    "LCAHU",
    "LCAHW",
    "LCI",
    "LCII",
    "LCNB",
    "LCTX",
    "LCUT",
    "LDL",
    "LDOS",
    "LDP",
    "LDRI",
    "LDSF",
    "LE",
    "LEA",
    "LEAF",
    "LECO",
    "LEDS",
    "LEE",
    "LEG",
    "LEGH",
    "LEGR",
    "LEJU",
    "LEN",
    "LEN.B",
    "LEO",
    "LEU",
    "LEVI",
    "LEVL",
    "LFAC",
    "LFACU",
    "LFACW",
    "LFC",
    "LFUS",
    "LFVN",
    "LGC",
    "LGC.U",
    "LGC.WS",
    "LGF.A",
    "LGF.B",
    "LGI",
    "LGIH",
    "LGL",
    "LGND",
    "LH",
    "LHC",
    "LHC.U",
    "LHC.WS",
    "LHCG",
    "LHX",
    "LIFE",
    "LII",
    "LILA",
    "LILAK",
    "LIN",
    "LINC",
    "LIND",
    "LINX",
    "LIQT",
    "LITB",
    "LITE",
    "LIVE",
    "LIVN",
    "LIVX",
    "LJPC",
    "LK",
    "LKCO",
    "LKFN",
    "LKOR",
    "LKQ",
    "LKSD",
    "LL",
    "LLEX",
    "LLIT",
    "LLNW",
    "LLY",
    "LM",
    "LMAT",
    "LMB",
    "LMBS",
    "LMFA",
    "LMFAW",
    "LMHA",
    "LMHB",
    "LMNR",
    "LMNX",
    "LMRK",
    "LMRKN",
    "LMRKO",
    "LMRKP",
    "LMST",
    "LMT",
    "LN",
    "LNC",
    "LND",
    "LNDC",
    "LNG",
    "LNGR",
    "LNN",
    "LNT",
    "LNTH",
    "LOAC",
    "LOACR",
    "LOACU",
    "LOACW",
    "LOAN",
    "LOB",
    "LOCO",
    "LODE",
    "LOGC",
    "LOGI",
    "LOGM",
    "LOMA",
    "LONE",
    "LOOP",
    "LOPE",
    "LOR",
    "LORL",
    "LOV",
    "LOVE",
    "LOW",
    "LPCN",
    "LPG",
    "LPI",
    "LPL",
    "LPLA",
    "LPSN",
    "LPT",
    "LPTH",
    "LPTX",
    "LPX",
    "LQDA",
    "LQDT",
    "LRAD",
    "LRCX",
    "LRGE",
    "LRN",
    "LSBK",
    "LSCC",
    "LSI",
    "LSTR",
    "LSXMA",
    "LSXMB",
    "LSXMK",
    "LTBR",
    "LTC",
    "LTHM",
    "LTM",
    "LTRPA",
    "LTRPB",
    "LTRX",
    "LTS",
    "LTSF",
    "LTSH",
    "LTSK",
    "LTSL",
    "LTS^A",
    "LTXB",
    "LUB",
    "LULU",
    "LUNA",
    "LUNG",
    "LUV",
    "LVGO",
    "LVHD",
    "LVS",
    "LW",
    "LWAY",
    "LX",
    "LXFR",
    "LXP",
    "LXP^C",
    "LXRX",
    "LXU",
    "LYB",
    "LYFT",
    "LYG",
    "LYL",
    "LYTS",
    "LYV",
    "LZB",
    "M",
    "MA",
    "MAA",
    "MAA^I",
    "MAC",
    "MACK",
    "MAG",
    "MAGS",
    "MAIN",
    "MAMS",
    "MAN",
    "MANH",
    "MANT",
    "MANU",
    "MAR",
    "MARA",
    "MARK",
    "MARPS",
    "MAS",
    "MASI",
    "MAT",
    "MATW",
    "MATX",
    "MAV",
    "MAXR",
    "MAYS",
    "MBB",
    "MBCN",
    "MBI",
    "MBII",
    "MBIN",
    "MBINO",
    "MBINP",
    "MBIO",
    "MBOT",
    "MBRX",
    "MBSD",
    "MBT",
    "MBUU",
    "MBWM",
    "MC",
    "MCA",
    "MCB",
    "MCBC",
    "MCC",
    "MCD",
    "MCEF",
    "MCEP",
    "MCF",
    "MCFT",
    "MCHI",
    "MCHP",
    "MCHX",
    "MCI",
    "MCK",
    "MCN",
    "MCO",
    "MCR",
    "MCRB",
    "MCRI",
    "MCRN",
    "MCS",
    "MCV",
    "MCX",
    "MCY",
    "MD",
    "MDB",
    "MDC",
    "MDCA",
    "MDCO",
    "MDGL",
    "MDGS",
    "MDGSW",
    "MDIV",
    "MDJH",
    "MDLA",
    "MDLQ",
    "MDLX",
    "MDLY",
    "MDLZ",
    "MDP",
    "MDR",
    "MDRR",
    "MDRX",
    "MDSO",
    "MDT",
    "MDU",
    "MDWD",
    "MEC",
    "MED",
    "MEDP",
    "MEET",
    "MEI",
    "MEIP",
    "MELI",
    "MEN",
    "MEOH",
    "MERC",
    "MER^K",
    "MESA",
    "MESO",
    "MET",
    "METC",
    "MET^A",
    "MET^E",
    "MFA",
    "MFAC",
    "MFAC.U",
    "MFAC.WS",
    "MFA^B",
    "MFC",
    "MFD",
    "MFG",
    "MFGP",
    "MFIN",
    "MFINL",
    "MFL",
    "MFM",
    "MFNC",
    "MFO",
    "MFSF",
    "MFT",
    "MFV",
    "MG",
    "MGA",
    "MGEE",
    "MGEN",
    "MGF",
    "MGI",
    "MGIC",
    "MGLN",
    "MGM",
    "MGNX",
    "MGP",
    "MGPI",
    "MGR",
    "MGRC",
    "MGTA",
    "MGTX",
    "MGU",
    "MGY",
    "MGYR",
    "MHD",
    "MHE",
    "MHF",
    "MHH",
    "MHI",
    "MHK",
    "MHLA",
    "MHLD",
    "MHN",
    "MHNC",
    "MHO",
    "MH^A",
    "MH^C",
    "MH^D",
    "MIC",
    "MICR",
    "MICT",
    "MIDD",
    "MIE",
    "MIK",
    "MILN",
    "MIME",
    "MIN",
    "MIND",
    "MINDP",
    "MINI",
    "MIRM",
    "MIST",
    "MITK",
    "MITO",
    "MITT",
    "MITT^A",
    "MITT^B",
    "MIXT",
    "MIY",
    "MJCO",
    "MKC",
    "MKC.V",
    "MKGI",
    "MKL",
    "MKSI",
    "MKTX",
    "MLAB",
    "MLCO",
    "MLHR",
    "MLI",
    "MLM",
    "MLND",
    "MLNT",
    "MLNX",
    "MLP",
    "MLR",
    "MLSS",
    "MLVF",
    "MMAC",
    "MMC",
    "MMD",
    "MMI",
    "MMLP",
    "MMM",
    "MMP",
    "MMS",
    "MMSI",
    "MMT",
    "MMU",
    "MMX",
    "MMYT",
    "MN",
    "MNCL",
    "MNCLU",
    "MNCLW",
    "MNDO",
    "MNE",
    "MNI",
    "MNK",
    "MNKD",
    "MNLO",
    "MNOV",
    "MNP",
    "MNR",
    "MNRL",
    "MNRO",
    "MNR^C",
    "MNSB",
    "MNST",
    "MNTA",
    "MNTX",
    "MO",
    "MOBL",
    "MOD",
    "MODN",
    "MOFG",
    "MOG.A",
    "MOG.B",
    "MOGO",
    "MOGU",
    "MOH",
    "MOMO",
    "MOR",
    "MORF",
    "MORN",
    "MOS",
    "MOSC",
    "MOSC.U",
    "MOSC.WS",
    "MOSY",
    "MOTA",
    "MOTS",
    "MOV",
    "MOXC",
    "MPA",
    "MPAA",
    "MPB",
    "MPC",
    "MPLX",
    "MPV",
    "MPVD",
    "MPW",
    "MPWR",
    "MPX",
    "MQT",
    "MQY",
    "MR",
    "MRAM",
    "MRBK",
    "MRC",
    "MRCC",
    "MRCCL",
    "MRCY",
    "MREO",
    "MRIC",
    "MRIN",
    "MRK",
    "MRKR",
    "MRLN",
    "MRNA",
    "MRNS",
    "MRO",
    "MRSN",
    "MRTN",
    "MRTX",
    "MRUS",
    "MRVL",
    "MS",
    "MSA",
    "MSB",
    "MSBF",
    "MSBI",
    "MSC",
    "MSCI",
    "MSD",
    "MSEX",
    "MSFT",
    "MSG",
    "MSGN",
    "MSI",
    "MSL",
    "MSM",
    "MSN",
    "MSON",
    "MSTR",
    "MSVB",
    "MS^A",
    "MS^E",
    "MS^F",
    "MS^G",
    "MS^I",
    "MS^K",
    "MT",
    "MTB",
    "MTBC",
    "MTBCP",
    "MTC",
    "MTCH",
    "MTD",
    "MTDR",
    "MTEM",
    "MTEX",
    "MTFB",
    "MTFBW",
    "MTG",
    "MTH",
    "MTL",
    "MTLS",
    "MTL^",
    "MTN",
    "MTNB",
    "MTOR",
    "MTP",
    "MTR",
    "MTRN",
    "MTRX",
    "MTSC",
    "MTSI",
    "MTSL",
    "MTT",
    "MTW",
    "MTX",
    "MTZ",
    "MU",
    "MUA",
    "MUC",
    "MUDS",
    "MUDSU",
    "MUDSW",
    "MUE",
    "MUFG",
    "MUH",
    "MUI",
    "MUJ",
    "MUR",
    "MUS",
    "MUSA",
    "MUX",
    "MVBF",
    "MVC",
    "MVCD",
    "MVF",
    "MVIS",
    "MVO",
    "MVT",
    "MWA",
    "MWK",
    "MX",
    "MXC",
    "MXE",
    "MXF",
    "MXIM",
    "MXL",
    "MYC",
    "MYD",
    "MYE",
    "MYF",
    "MYFW",
    "MYGN",
    "MYI",
    "MYJ",
    "MYL",
    "MYN",
    "MYO",
    "MYOK",
    "MYOS",
    "MYOV",
    "MYRG",
    "MYSZ",
    "MYT",
    "MZA",
    "NAC",
    "NAD",
    "NAII",
    "NAK",
    "NAKD",
    "NAN",
    "NANO",
    "NAOV",
    "NAT",
    "NATH",
    "NATI",
    "NATR",
    "NAV",
    "NAVB",
    "NAVI",
    "NAV^D",
    "NAZ",
    "NBB",
    "NBCP",
    "NBEV",
    "NBH",
    "NBHC",
    "NBIX",
    "NBL",
    "NBLX",
    "NBN",
    "NBO",
    "NBR",
    "NBRV",
    "NBR^A",
    "NBSE",
    "NBTB",
    "NBW",
    "NBY",
    "NC",
    "NCA",
    "NCB",
    "NCBS",
    "NCI",
    "NCLH",
    "NCMI",
    "NCNA",
    "NCR",
    "NCSM",
    "NCTY",
    "NCV",
    "NCV^A",
    "NCZ",
    "NCZ^A",
    "NDAQ",
    "NDLS",
    "NDP",
    "NDRA",
    "NDRAW",
    "NDSN",
    "NE",
    "NEA",
    "NEBU",
    "NEBUU",
    "NEBUW",
    "NEE",
    "NEE^I",
    "NEE^J",
    "NEE^K",
    "NEE^N",
    "NEE^O",
    "NEM",
    "NEN",
    "NEO",
    "NEOG",
    "NEON",
    "NEOS",
    "NEP",
    "NEPH",
    "NEPT",
    "NERV",
    "NES",
    "NESR",
    "NESRW",
    "NETE",
    "NEU",
    "NEV",
    "NEW",
    "NEWA",
    "NEWM",
    "NEWR",
    "NEWT",
    "NEWTI",
    "NEWTL",
    "NEXA",
    "NEXT",
    "NFBK",
    "NFC",
    "NFC.U",
    "NFC.WS",
    "NFE",
    "NFG",
    "NFIN",
    "NFINU",
    "NFINW",
    "NFJ",
    "NFLX",
    "NFTY",
    "NG",
    "NGD",
    "NGG",
    "NGHC",
    "NGHCN",
    "NGHCO",
    "NGHCP",
    "NGHCZ",
    "NGL",
    "NGLS^A",
    "NGL^B",
    "NGL^C",
    "NGM",
    "NGS",
    "NGVC",
    "NGVT",
    "NH",
    "NHA",
    "NHC",
    "NHF",
    "NHI",
    "NHLD",
    "NHLDW",
    "NHS",
    "NHTC",
    "NI",
    "NICE",
    "NICK",
    "NID",
    "NIE",
    "NIHD",
    "NIM",
    "NINE",
    "NIO",
    "NIQ",
    "NIU",
    "NI^B",
    "NJR",
    "NJV",
    "NK",
    "NKE",
    "NKG",
    "NKSH",
    "NKTR",
    "NKX",
    "NL",
    "NLNK",
    "NLS",
    "NLSN",
    "NLTX",
    "NLY",
    "NLY^D",
    "NLY^F",
    "NLY^G",
    "NLY^I",
    "NM",
    "NMCI",
    "NMFC",
    "NMFX",
    "NMI",
    "NMIH",
    "NMK^B",
    "NMK^C",
    "NML",
    "NMM",
    "NMR",
    "NMRD",
    "NMRK",
    "NMS",
    "NMT",
    "NMY",
    "NMZ",
    "NM^G",
    "NM^H",
    "NNA",
    "NNBR",
    "NNC",
    "NNDM",
    "NNI",
    "NNN",
    "NNN^E.CL",
    "NNN^F",
    "NNVC",
    "NNY",
    "NOA",
    "NOAH",
    "NOC",
    "NODK",
    "NOG",
    "NOK",
    "NOM",
    "NOMD",
    "NOV",
    "NOVA",
    "NOVN",
    "NOVT",
    "NOW",
    "NP",
    "NPAUU",
    "NPK",
    "NPN",
    "NPO",
    "NPTN",
    "NPV",
    "NQP",
    "NR",
    "NRC",
    "NRCG",
    "NRCG.WS",
    "NRE",
    "NRG",
    "NRGX",
    "NRIM",
    "NRK",
    "NRO",
    "NRP",
    "NRT",
    "NRUC",
    "NRZ",
    "NRZ^A",
    "NRZ^B",
    "NS",
    "NSA",
    "NSA^A",
    "NSC",
    "NSCO",
    "NSCO.WS",
    "NSEC",
    "NSIT",
    "NSL",
    "NSP",
    "NSPR",
    "NSPR.WS",
    "NSPR.WS.B",
    "NSS",
    "NSSC",
    "NSTG",
    "NSYS",
    "NS^A",
    "NS^B",
    "NS^C",
    "NTAP",
    "NTB",
    "NTC",
    "NTCT",
    "NTEC",
    "NTES",
    "NTEST",
    "NTEST.A",
    "NTEST.B",
    "NTEST.C",
    "NTG",
    "NTGN",
    "NTGR",
    "NTIC",
    "NTIP",
    "NTLA",
    "NTN",
    "NTNX",
    "NTP",
    "NTR",
    "NTRA",
    "NTRP",
    "NTRS",
    "NTRSP",
    "NTUS",
    "NTWK",
    "NTX",
    "NTZ",
    "NUAN",
    "NUE",
    "NUM",
    "NUO",
    "NURO",
    "NUROW",
    "NUS",
    "NUV",
    "NUVA",
    "NUW",
    "NVAX",
    "NVCN",
    "NVCR",
    "NVDA",
    "NVEC",
    "NVEE",
    "NVFY",
    "NVG",
    "NVGS",
    "NVIV",
    "NVLN",
    "NVMI",
    "NVO",
    "NVR",
    "NVRO",
    "NVS",
    "NVT",
    "NVTA",
    "NVTR",
    "NVUS",
    "NWBI",
    "NWE",
    "NWFL",
    "NWHM",
    "NWL",
    "NWLI",
    "NWN",
    "NWPX",
    "NWS",
    "NWSA",
    "NX",
    "NXC",
    "NXE",
    "NXGN",
    "NXJ",
    "NXMD",
    "NXN",
    "NXP",
    "NXPI",
    "NXQ",
    "NXR",
    "NXRT",
    "NXST",
    "NXTC",
    "NXTD",
    "NXTG",
    "NYCB",
    "NYCB^A",
    "NYCB^U",
    "NYMT",
    "NYMTN",
    "NYMTO",
    "NYMTP",
    "NYMX",
    "NYNY",
    "NYT",
    "NYV",
    "NZF",
    "O",
    "OAC",
    "OAC.U",
    "OAC.WS",
    "OAK",
    "OAK^A",
    "OAK^B",
    "OAS",
    "OBAS",
    "OBCI",
    "OBE",
    "OBLN",
    "OBNK",
    "OBSV",
    "OC",
    "OCC",
    "OCCI",
    "OCCIP",
    "OCFC",
    "OCN",
    "OCSI",
    "OCSL",
    "OCSLL",
    "OCUL",
    "OCX",
    "ODC",
    "ODFL",
    "ODP",
    "ODT",
    "OEC",
    "OESX",
    "OFC",
    "OFED",
    "OFG",
    "OFG^A",
    "OFG^B",
    "OFG^D",
    "OFIX",
    "OFLX",
    "OFS",
    "OFSSL",
    "OFSSZ",
    "OGE",
    "OGEN",
    "OGI",
    "OGS",
    "OHAI",
    "OHI",
    "OI",
    "OIA",
    "OIBR.C",
    "OII",
    "OIIM",
    "OIS",
    "OKE",
    "OKTA",
    "OLBK",
    "OLD",
    "OLED",
    "OLLI",
    "OLN",
    "OLP",
    "OMAB",
    "OMC",
    "OMCL",
    "OMER",
    "OMEX",
    "OMF",
    "OMI",
    "OMN",
    "OMP",
    "ON",
    "ONB",
    "ONCE",
    "ONCS",
    "ONCT",
    "ONCY",
    "ONDK",
    "ONE",
    "ONEQ",
    "ONTX",
    "ONTXW",
    "ONVO",
    "OOMA",
    "OPB",
    "OPBK",
    "OPES",
    "OPESU",
    "OPESW",
    "OPGN",
    "OPGNW",
    "OPHC",
    "OPI",
    "OPINI",
    "OPK",
    "OPNT",
    "OPOF",
    "OPP",
    "OPRA",
    "OPRX",
    "OPTN",
    "OPTT",
    "OPY",
    "OR",
    "ORA",
    "ORAN",
    "ORBC",
    "ORC",
    "ORCC",
    "ORCL",
    "ORG",
    "ORGO",
    "ORGS",
    "ORI",
    "ORIT",
    "ORLY",
    "ORMP",
    "ORN",
    "ORRF",
    "ORSNU",
    "ORTX",
    "OSB",
    "OSBC",
    "OSBCP",
    "OSG",
    "OSIS",
    "OSK",
    "OSLE",
    "OSMT",
    "OSN",
    "OSPN",
    "OSS",
    "OSTK",
    "OSUR",
    "OSW",
    "OTEL",
    "OTEX",
    "OTG",
    "OTIC",
    "OTIV",
    "OTLK",
    "OTLKW",
    "OTTR",
    "OTTW",
    "OUT",
    "OVBC",
    "OVID",
    "OVLY",
    "OXBR",
    "OXBRW",
    "OXFD",
    "OXLC",
    "OXLCM",
    "OXLCO",
    "OXM",
    "OXSQ",
    "OXSQL",
    "OXSQZ",
    "OXY",
    "OZK",
    "PAA",
    "PAAC",
    "PAACR",
    "PAACU",
    "PAACW",
    "PAAS",
    "PAC",
    "PACB",
    "PACD",
    "PACK",
    "PACK.WS",
    "PACQ",
    "PACQU",
    "PACQW",
    "PACW",
    "PAG",
    "PAGP",
    "PAGS",
    "PAHC",
    "PAI",
    "PAM",
    "PANL",
    "PANW",
    "PAR",
    "PARR",
    "PATI",
    "PATK",
    "PAVM",
    "PAVMW",
    "PAVMZ",
    "PAYC",
    "PAYS",
    "PAYX",
    "PB",
    "PBA",
    "PBB",
    "PBBI",
    "PBC",
    "PBCT",
    "PBCTP",
    "PBF",
    "PBFS",
    "PBFX",
    "PBH",
    "PBHC",
    "PBI",
    "PBIO",
    "PBIP",
    "PBI^B",
    "PBPB",
    "PBR",
    "PBR.A",
    "PBT",
    "PBTS",
    "PBY",
    "PBYI",
    "PCAR",
    "PCB",
    "PCF",
    "PCG",
    "PCG^A",
    "PCG^B",
    "PCG^C",
    "PCG^D",
    "PCG^E",
    "PCG^G",
    "PCG^H",
    "PCG^I",
    "PCH",
    "PCI",
    "PCIM",
    "PCK",
    "PCM",
    "PCN",
    "PCOM",
    "PCQ",
    "PCRX",
    "PCSB",
    "PCTI",
    "PCTY",
    "PCYG",
    "PCYO",
    "PD",
    "PDBC",
    "PDCE",
    "PDCO",
    "PDD",
    "PDEV",
    "PDEX",
    "PDFS",
    "PDI",
    "PDLB",
    "PDLI",
    "PDM",
    "PDP",
    "PDS",
    "PDSB",
    "PDT",
    "PE",
    "PEB",
    "PEBK",
    "PEBO",
    "PEB^C",
    "PEB^D",
    "PEB^E",
    "PEB^F",
    "PECK",
    "PED",
    "PEER",
    "PEG",
    "PEGA",
    "PEGI",
    "PEI",
    "PEIX",
    "PEI^B",
    "PEI^C",
    "PEI^D",
    "PEN",
    "PENN",
    "PEO",
    "PEP",
    "PER",
    "PERI",
    "PESI",
    "PETQ",
    "PETS",
    "PETZ",
    "PEY",
    "PEZ",
    "PFBC",
    "PFBI",
    "PFD",
    "PFE",
    "PFF",
    "PFG",
    "PFGC",
    "PFH",
    "PFI",
    "PFIE",
    "PFIN",
    "PFIS",
    "PFL",
    "PFLT",
    "PFM",
    "PFMT",
    "PFN",
    "PFNX",
    "PFO",
    "PFPT",
    "PFS",
    "PFSI",
    "PFSW",
    "PG",
    "PGC",
    "PGJ",
    "PGNX",
    "PGP",
    "PGR",
    "PGRE",
    "PGTI",
    "PGZ",
    "PH",
    "PHAS",
    "PHCF",
    "PHD",
    "PHG",
    "PHI",
    "PHIO",
    "PHIOW",
    "PHK",
    "PHM",
    "PHO",
    "PHR",
    "PHT",
    "PHUN",
    "PHUNW",
    "PHX",
    "PI",
    "PIC",
    "PIC.U",
    "PIC.WS",
    "PICO",
    "PID",
    "PIE",
    "PIH",
    "PIHPP",
    "PII",
    "PIM",
    "PINC",
    "PINS",
    "PIO",
    "PIR",
    "PIRS",
    "PIXY",
    "PIY",
    "PIZ",
    "PJC",
    "PJH",
    "PJT",
    "PK",
    "PKBK",
    "PKD",
    "PKE",
    "PKG",
    "PKI",
    "PKO",
    "PKOH",
    "PKW",
    "PKX",
    "PLAB",
    "PLAG",
    "PLAN",
    "PLAY",
    "PLBC",
    "PLC",
    "PLCE",
    "PLD",
    "PLG",
    "PLIN",
    "PLL",
    "PLM",
    "PLMR",
    "PLNT",
    "PLOW",
    "PLPC",
    "PLSE",
    "PLT",
    "PLUG",
    "PLUS",
    "PLW",
    "PLX",
    "PLXP",
    "PLXS",
    "PLYA",
    "PLYM",
    "PLYM^A",
    "PM",
    "PMBC",
    "PMD",
    "PME",
    "PMF",
    "PML",
    "PMM",
    "PMO",
    "PMOM",
    "PMT",
    "PMTS",
    "PMT^A",
    "PMT^B",
    "PMX",
    "PNBK",
    "PNC",
    "PNC^P",
    "PNC^Q",
    "PNF",
    "PNFP",
    "PNI",
    "PNM",
    "PNNT",
    "PNQI",
    "PNR",
    "PNRG",
    "PNRL",
    "PNTR",
    "PNW",
    "POAI",
    "PODD",
    "POL",
    "POLA",
    "POLY",
    "POOL",
    "POPE",
    "POR",
    "POST",
    "POWI",
    "POWL",
    "PPBI",
    "PPC",
    "PPDF",
    "PPG",
    "PPH",
    "PPHI",
    "PPIH",
    "PPL",
    "PPR",
    "PPSI",
    "PPT",
    "PPX",
    "PQG",
    "PRA",
    "PRAA",
    "PRAH",
    "PRCP",
    "PRE^F",
    "PRE^G",
    "PRE^H",
    "PRE^I",
    "PRFT",
    "PRFZ",
    "PRGO",
    "PRGS",
    "PRGX",
    "PRH",
    "PRI",
    "PRIF^A",
    "PRIF^B",
    "PRIF^C",
    "PRIF^D",
    "PRIM",
    "PRK",
    "PRLB",
    "PRMW",
    "PRN",
    "PRNB",
    "PRO",
    "PROS",
    "PROV",
    "PRPH",
    "PRPL",
    "PRPO",
    "PRQR",
    "PRS",
    "PRSC",
    "PRSP",
    "PRT",
    "PRTA",
    "PRTH",
    "PRTK",
    "PRTO",
    "PRTS",
    "PRTY",
    "PRU",
    "PRVB",
    "PRVL",
    "PS",
    "PSA",
    "PSA^A",
    "PSA^B",
    "PSA^C",
    "PSA^D",
    "PSA^E",
    "PSA^F",
    "PSA^G",
    "PSA^H",
    "PSA^V",
    "PSA^W",
    "PSA^X",
    "PSB",
    "PSB^U",
    "PSB^V",
    "PSB^W",
    "PSB^X",
    "PSB^Y",
    "PSC",
    "PSCC",
    "PSCD",
    "PSCE",
    "PSCF",
    "PSCH",
    "PSCI",
    "PSCM",
    "PSCT",
    "PSCU",
    "PSDO",
    "PSEC",
    "PSET",
    "PSF",
    "PSL",
    "PSM",
    "PSMT",
    "PSN",
    "PSNL",
    "PSO",
    "PSTG",
    "PSTI",
    "PSTL",
    "PSTV",
    "PSTVZ",
    "PSV",
    "PSX",
    "PSXP",
    "PT",
    "PTC",
    "PTCT",
    "PTE",
    "PTEN",
    "PTF",
    "PTGX",
    "PTH",
    "PTI",
    "PTLA",
    "PTMN",
    "PTN",
    "PTNR",
    "PTR",
    "PTSI",
    "PTVCA",
    "PTVCB",
    "PTY",
    "PUB",
    "PUI",
    "PUK",
    "PUK^",
    "PUK^A",
    "PULM",
    "PUMP",
    "PUYI",
    "PVAC",
    "PVAL",
    "PVBC",
    "PVG",
    "PVH",
    "PVL",
    "PVT",
    "PVT.U",
    "PVT.WS",
    "PVTL",
    "PW",
    "PWOD",
    "PWR",
    "PW^A",
    "PXD",
    "PXI",
    "PXLW",
    "PXS",
    "PY",
    "PYN",
    "PYPL",
    "PYS",
    "PYT",
    "PYX",
    "PYZ",
    "PZC",
    "PZG",
    "PZN",
    "PZZA",
    "QABA",
    "QADA",
    "QADB",
    "QAT",
    "QBAK",
    "QCLN",
    "QCOM",
    "QCRH",
    "QD",
    "QDEL",
    "QEP",
    "QES",
    "QFIN",
    "QGEN",
    "QHC",
    "QIWI",
    "QLC",
    "QLYS",
    "QNST",
    "QQEW",
    "QQQ",
    "QQQX",
    "QQXT",
    "QRHC",
    "QRTEA",
    "QRTEB",
    "QRVO",
    "QSR",
    "QTEC",
    "QTNT",
    "QTRH",
    "QTRX",
    "QTS",
    "QTS^A",
    "QTS^B",
    "QTT",
    "QTWO",
    "QUAD",
    "QUIK",
    "QUMU",
    "QUOT",
    "QURE",
    "QVCD",
    "QYLD",
    "R",
    "RA",
    "RACE",
    "RAD",
    "RADA",
    "RAIL",
    "RAMP",
    "RAND",
    "RAPT",
    "RARE",
    "RARX",
    "RAVE",
    "RAVN",
    "RBA",
    "RBB",
    "RBBN",
    "RBC",
    "RBCAA",
    "RBCN",
    "RBKB",
    "RBNC",
    "RBS",
    "RBZ",
    "RC",
    "RCA",
    "RCB",
    "RCG",
    "RCI",
    "RCII",
    "RCKT",
    "RCKY",
    "RCL",
    "RCM",
    "RCMT",
    "RCON",
    "RCP",
    "RCS",
    "RCUS",
    "RDCM",
    "RDFN",
    "RDHL",
    "RDI",
    "RDIB",
    "RDN",
    "RDNT",
    "RDS.A",
    "RDS.B",
    "RDUS",
    "RDVT",
    "RDVY",
    "RDWR",
    "RDY",
    "RE",
    "REAL",
    "RECN",
    "REDU",
    "REED",
    "REFR",
    "REG",
    "REGI",
    "REGN",
    "REI",
    "REKR",
    "RELL",
    "RELV",
    "RELX",
    "RENN",
    "REPH",
    "REPL",
    "RES",
    "RESI",
    "RESN",
    "RETA",
    "RETO",
    "REV",
    "REVG",
    "REX",
    "REXN",
    "REXR",
    "REXR^A",
    "REXR^B",
    "REZI",
    "RF",
    "RFAP",
    "RFDI",
    "RFEM",
    "RFEU",
    "RFI",
    "RFIL",
    "RFL",
    "RFP",
    "RF^A",
    "RF^B",
    "RF^C",
    "RGA",
    "RGCO",
    "RGEN",
    "RGLD",
    "RGLS",
    "RGNX",
    "RGR",
    "RGS",
    "RGT",
    "RH",
    "RHE",
    "RHE^A",
    "RHI",
    "RHP",
    "RIBT",
    "RICK",
    "RIF",
    "RIG",
    "RIGL",
    "RILY",
    "RILYG",
    "RILYH",
    "RILYI",
    "RILYL",
    "RILYO",
    "RILYZ",
    "RING",
    "RIO",
    "RIOT",
    "RIV",
    "RIVE",
    "RJF",
    "RKDA",
    "RL",
    "RLGT",
    "RLGY",
    "RLH",
    "RLI",
    "RLJ",
    "RLJ^A",
    "RM",
    "RMAX",
    "RMBI",
    "RMBL",
    "RMBS",
    "RMCF",
    "RMD",
    "RMED",
    "RMG",
    "RMG.U",
    "RMG.WS",
    "RMI",
    "RMM",
    "RMNI",
    "RMPL^",
    "RMR",
    "RMT",
    "RMTI",
    "RNDB",
    "RNDM",
    "RNDV",
    "RNEM",
    "RNET",
    "RNG",
    "RNGR",
    "RNLC",
    "RNMC",
    "RNP",
    "RNR",
    "RNR^C",
    "RNR^E",
    "RNR^F",
    "RNSC",
    "RNST",
    "RNWK",
    "ROAD",
    "ROAN",
    "ROBO",
    "ROBT",
    "ROCK",
    "ROG",
    "ROIC",
    "ROK",
    "ROKU",
    "ROL",
    "ROLL",
    "ROP",
    "ROSE",
    "ROSEU",
    "ROSEW",
    "ROST",
    "ROX",
    "ROYT",
    "RP",
    "RPAI",
    "RPAY",
    "RPD",
    "RPLA",
    "RPLA.U",
    "RPLA.WS",
    "RPM",
    "RPT",
    "RPT^D",
    "RQI",
    "RRBI",
    "RRC",
    "RRD",
    "RRGB",
    "RRR",
    "RRTS",
    "RS",
    "RSF",
    "RSG",
    "RST",
    "RTEC",
    "RTIX",
    "RTLR",
    "RTN",
    "RTRX",
    "RTTR",
    "RTW",
    "RUBI",
    "RUBY",
    "RUHN",
    "RUN",
    "RUSHA",
    "RUSHB",
    "RUTH",
    "RVEN",
    "RVI",
    "RVLT",
    "RVLV",
    "RVNC",
    "RVP",
    "RVSB",
    "RVT",
    "RWGE",
    "RWGE.U",
    "RWGE.WS",
    "RWLK",
    "RWT",
    "RXN",
    "RXN^A",
    "RY",
    "RYAAY",
    "RYAM",
    "RYB",
    "RYI",
    "RYN",
    "RYTM",
    "RY^T",
    "RZA",
    "RZB",
    "S",
    "SA",
    "SAB",
    "SABR",
    "SACH",
    "SAEX",
    "SAF",
    "SAFE",
    "SAFM",
    "SAFT",
    "SAGE",
    "SAH",
    "SAIA",
    "SAIC",
    "SAIL",
    "SAL",
    "SALM",
    "SALT",
    "SAM",
    "SAMA",
    "SAMAU",
    "SAMAW",
    "SAMG",
    "SAN",
    "SAND          ",
    "SANM",
    "SANW",
    "SAN^B",
    "SAP",
    "SAR",
    "SASR",
    "SATS",
    "SAUC",
    "SAVA",
    "SAVE",
    "SB",
    "SBAC",
    "SBBP",
    "SBBX",
    "SBCF",
    "SBE.U",
    "SBFG",
    "SBFGP",
    "SBGI",
    "SBGL",
    "SBH",
    "SBI",
    "SBLK",
    "SBLKZ",
    "SBNA",
    "SBNY",
    "SBOW",
    "SBPH",
    "SBR",
    "SBRA",
    "SBS",
    "SBSI",
    "SBT",
    "SBUX",
    "SB^C",
    "SB^D",
    "SC",
    "SCA",
    "SCCB",
    "SCCI",
    "SCCO",
    "SCD",
    "SCE^B",
    "SCE^C",
    "SCE^D",
    "SCE^E",
    "SCE^G",
    "SCE^H",
    "SCE^J",
    "SCE^K",
    "SCE^L",
    "SCHL",
    "SCHN",
    "SCHW",
    "SCHW^C",
    "SCHW^D",
    "SCI",
    "SCKT",
    "SCL",
    "SCM",
    "SCON",
    "SCOR",
    "SCPE",
    "SCPE.U",
    "SCPE.WS",
    "SCPH",
    "SCPL",
    "SCS",
    "SCSC",
    "SCVL",
    "SCWX",
    "SCX",
    "SCYX",
    "SCZ",
    "SD",
    "SDC",
    "SDG",
    "SDI",
    "SDPI",
    "SDR",
    "SDRL",
    "SDT",
    "SDVY",
    "SE",
    "SEAC",
    "SEAS",
    "SEB",
    "SECO",
    "SEDG",
    "SEE",
    "SEED",
    "SEEL",
    "SEIC",
    "SELB",
    "SELF",
    "SEM",
    "SEMG",
    "SENEA",
    "SENEB",
    "SENS",
    "SERV",
    "SES",
    "SESN",
    "SF",
    "SFB",
    "SFBC",
    "SFBS",
    "SFE",
    "SFET",
    "SFIX",
    "SFL",
    "SFLY",
    "SFM",
    "SFNC",
    "SFST",
    "SFUN",
    "SF^A",
    "SF^B",
    "SG",
    "SGA",
    "SGB",
    "SGBX",
    "SGC",
    "SGEN",
    "SGH",
    "SGLB",
    "SGLBW",
    "SGMA",
    "SGMO",
    "SGMS",
    "SGOC",
    "SGRP",
    "SGRY",
    "SGU",
    "SHAK",
    "SHBI",
    "SHEN",
    "SHG",
    "SHI",
    "SHIP",
    "SHIPW",
    "SHIPZ",
    "SHLL",
    "SHLL.U",
    "SHLL.WS",
    "SHLO",
    "SHLX",
    "SHO",
    "SHOO",
    "SHOP",
    "SHOS",
    "SHO^E",
    "SHO^F",
    "SHSP",
    "SHV",
    "SHW",
    "SHY",
    "SIBN",
    "SIC",
    "SID",
    "SIEB",
    "SIEN",
    "SIF",
    "SIFY",
    "SIG",
    "SIGA",
    "SIGI",
    "SILC",
    "SILK",
    "SILV",
    "SIM",
    "SIMO",
    "SINA",
    "SINO",
    "SINT",
    "SIRI",
    "SITC",
    "SITC^A",
    "SITC^J",
    "SITC^K",
    "SITE",
    "SITO",
    "SIVB",
    "SIX",
    "SJI",
    "SJIU",
    "SJM",
    "SJR",
    "SJT",
    "SJW",
    "SKIS",
    "SKM",
    "SKOR",
    "SKT",
    "SKX",
    "SKY",
    "SKYS",
    "SKYW",
    "SKYY",
    "SLAB",
    "SLB",
    "SLCA",
    "SLCT",
    "SLDB",
    "SLF",
    "SLG",
    "SLGG",
    "SLGL",
    "SLGN",
    "SLG^I",
    "SLIM",
    "SLM",
    "SLMBP",
    "SLNG",
    "SLNO",
    "SLNOW",
    "SLP",
    "SLQD",
    "SLRC",
    "SLRX",
    "SLS",
    "SLVO",
    "SM",
    "SMAR",
    "SMBC",
    "SMBK",
    "SMCP",
    "SMED",
    "SMFG",
    "SMG",
    "SMHI",
    "SMIT",
    "SMLP",
    "SMM",
    "SMMC",
    "SMMCU",
    "SMMCW",
    "SMMF",
    "SMMT",
    "SMP",
    "SMPL",
    "SMRT",
    "SMSI",
    "SMTA",
    "SMTC",
    "SMTS",
    "SMTX",
    "SNA",
    "SNAP",
    "SNBR",
    "SNCR",
    "SND",
    "SNDE",
    "SNDL",
    "SNDR",
    "SNDX",
    "SNE",
    "SNES",
    "SNFCA",
    "SNGX",
    "SNGXW",
    "SNH",
    "SNHNI",
    "SNHNL",
    "SNLN",
    "SNMP",
    "SNN",
    "SNNA",
    "SNOA",
    "SNOAW",
    "SNP",
    "SNPS",
    "SNR",
    "SNSR",
    "SNSS",
    "SNV",
    "SNV^D",
    "SNV^E",
    "SNX",
    "SNY",
    "SO",
    "SOCL",
    "SOGO",
    "SOHO",
    "SOHOB",
    "SOHON",
    "SOHOO",
    "SOHU",
    "SOI",
    "SOJA",
    "SOJB",
    "SOJC",
    "SOL",
    "SOLN",
    "SOLO",
    "SOLOW",
    "SOLY",
    "SON",
    "SONA",
    "SONG",
    "SONGW",
    "SONM",
    "SONO",
    "SOR",
    "SORL",
    "SOXX",
    "SP",
    "SPAQ",
    "SPAQ.U",
    "SPAQ.WS",
    "SPAR",
    "SPB           ",
    "SPCB",
    "SPE",
    "SPEX",
    "SPE^B",
    "SPFI",
    "SPG",
    "SPGI",
    "SPG^J",
    "SPH",
    "SPHS",
    "SPI",
    "SPKE",
    "SPKEP",
    "SPLK",
    "SPLP",
    "SPLP^A",
    "SPN",
    "SPNE",
    "SPNS",
    "SPOK",
    "SPOT",
    "SPPI",
    "SPR",
    "SPRO",
    "SPRT",
    "SPSC",
    "SPTN",
    "SPWH",
    "SPWR",
    "SPXC",
    "SPXX",
    "SQ",
    "SQBG",
    "SQLV",
    "SQM",
    "SQNS",
    "SQQQ",
    "SR",
    "SRAX",
    "SRC",
    "SRCE",
    "SRCI",
    "SRCL",
    "SRC^A",
    "SRDX",
    "SRE",
    "SREA",
    "SRET",
    "SREV",
    "SRE^A",
    "SRE^B",
    "SRF",
    "SRG",
    "SRG^A",
    "SRI",
    "SRL",
    "SRLP",
    "SRNE",
    "SRPT",
    "SRRA",
    "SRRK",
    "SRT",
    "SRTS",
    "SRTSW",
    "SRV",
    "SRVA",
    "SR^A",
    "SSB",
    "SSBI",
    "SSD",
    "SSFN",
    "SSI",
    "SSKN",
    "SSL",
    "SSNC",
    "SSNT",
    "SSP",
    "SSPKU",
    "SSRM",
    "SSSS",
    "SSTI",
    "SSTK",
    "SSW",
    "SSWA",
    "SSW^D",
    "SSW^E",
    "SSW^G",
    "SSW^H",
    "SSW^I",
    "SSY",
    "SSYS",
    "ST",
    "STAA",
    "STAF",
    "STAG",
    "STAG^C",
    "STAR          ",
    "STAR^D",
    "STAR^G",
    "STAR^I",
    "STAY",
    "STBA",
    "STC",
    "STCN",
    "STE",
    "STFC",
    "STG",
    "STI",
    "STIM",
    "STI^A",
    "STK",
    "STKL",
    "STKS",
    "STL",
    "STLD",
    "STL^A",
    "STM",
    "STML",
    "STMP",
    "STN",
    "STND",
    "STNE",
    "STNG",
    "STNL",
    "STNLU",
    "STNLW",
    "STOK",
    "STON",
    "STOR",
    "STPP",
    "STRA",
    "STRL",
    "STRM",
    "STRO",
    "STRS",
    "STRT",
    "STT",
    "STT^C",
    "STT^D",
    "STT^E",
    "STT^G",
    "STWD",
    "STX",
    "STXB",
    "STXS",
    "STZ",
    "STZ.B",
    "SU",
    "SUI",
    "SUM",
    "SUMR",
    "SUN",
    "SUNS",
    "SUNW",
    "SUP",
    "SUPN",
    "SUPV",
    "SURF",
    "SUSB",
    "SUSC",
    "SUSL",
    "SUZ",
    "SVA",
    "SVBI",
    "SVM",
    "SVMK",
    "SVRA",
    "SVT",
    "SVVC",
    "SWAV",
    "SWCH",
    "SWI",
    "SWIR",
    "SWJ",
    "SWK",
    "SWKS",
    "SWM",
    "SWN",
    "SWP",
    "SWTX",
    "SWX",
    "SWZ",
    "SXC",
    "SXI",
    "SXT",
    "SXTC",
    "SY",
    "SYBT",
    "SYBX",
    "SYF",
    "SYK",
    "SYKE",
    "SYMC",
    "SYN",
    "SYNA",
    "SYNC",
    "SYNH",
    "SYNL",
    "SYPR",
    "SYRS",
    "SYX",
    "SYY",
    "SZC",
    "T",
    "TA",
    "TAC",
    "TACO",
    "TACOW",
    "TACT",
    "TAIT",
    "TAK",
    "TAL",
    "TALO",
    "TALO.WS",
    "TANH",
    "TANNI",
    "TANNL",
    "TANNZ",
    "TAOP",
    "TAP",
    "TAP.A",
    "TAPR",
    "TARO",
    "TAST",
    "TAT",
    "TATT",
    "TAYD",
    "TBB",
    "TBBK",
    "TBC",
    "TBI",
    "TBIO",
    "TBK",
    "TBLT",
    "TBLTU",
    "TBLTW",
    "TBNK",
    "TBPH",
    "TC",
    "TCBI",
    "TCBIL",
    "TCBIP",
    "TCBK",
    "TCCO",
    "TCDA",
    "TCF",
    "TCFC",
    "TCFCP",
    "TCGP",
    "TCI",
    "TCMD",
    "TCO",
    "TCON",
    "TCO^J",
    "TCO^K",
    "TCP",
    "TCPC",
    "TCRD",
    "TCRR",
    "TCRW",
    "TCRZ",
    "TCS",
    "TCX",
    "TD",
    "TDA",
    "TDAC",
    "TDACU",
    "TDACW",
    "TDC",
    "TDE",
    "TDF",
    "TDG",
    "TDI",
    "TDIV",
    "TDJ",
    "TDOC",
    "TDS",
    "TDW",
    "TDW.WS",
    "TDW.WS.A",
    "TDW.WS.B",
    "TDY",
    "TEAF",
    "TEAM",
    "TECD",
    "TECH",
    "TECK",
    "TECTP",
    "TEDU",
    "TEF",
    "TEI",
    "TEL",
    "TELL",
    "TEN",
    "TENB",
    "TENX",
    "TEO",
    "TER",
    "TERP",
    "TESS",
    "TEUM",
    "TEVA",
    "TEX",
    "TFSL",
    "TFX",
    "TG",
    "TGA",
    "TGB",
    "TGC",
    "TGE",
    "TGEN",
    "TGH",
    "TGI",
    "TGLS",
    "TGNA",
    "TGP",
    "TGP^A",
    "TGP^B",
    "TGS",
    "TGT",
    "TGTX",
    "TH",
    "THBRU",
    "THC",
    "THCA",
    "THCAU",
    "THCAW",
    "THCB",
    "THCBU",
    "THCBW",
    "THFF",
    "THG",
    "THGA",
    "THM",
    "THO",
    "THOR",
    "THQ",
    "THR",
    "THRM",
    "THS",
    "THW",
    "THWWW",
    "TIBR",
    "TIBRU",
    "TIBRW",
    "TIF",
    "TIGO",
    "TIGR",
    "TILE",
    "TIPT",
    "TISI",
    "TITN",
    "TIVO",
    "TJX",
    "TK",
    "TKAT",
    "TKC",
    "TKKS",
    "TKKSR",
    "TKKSU",
    "TKKSW",
    "TKR",
    "TLC",
    "TLF",
    "TLGT",
    "TLI",
    "TLK",
    "TLND",
    "TLRA",
    "TLRD",
    "TLRY",
    "TLSA",
    "TLT",
    "TLYS",
    "TM",
    "TMCX",
    "TMCXU",
    "TMCXW",
    "TMDI",
    "TMDX",
    "TME",
    "TMHC",
    "TMO",
    "TMP",
    "TMQ",
    "TMSR",
    "TMST",
    "TMUS",
    "TNAV",
    "TNC",
    "TNDM",
    "TNET",
    "TNK",
    "TNP",
    "TNP^C",
    "TNP^D",
    "TNP^E",
    "TNP^F",
    "TNXP",
    "TOCA",
    "TOL",
    "TOO",
    "TOO^A",
    "TOO^B",
    "TOO^E",
    "TOPS",
    "TORC",
    "TOT",
    "TOTA",
    "TOTAR",
    "TOTAU",
    "TOTAW",
    "TOUR",
    "TOWN",
    "TOWR",
    "TPB",
    "TPC",
    "TPCO",
    "TPGH",
    "TPGH.U",
    "TPGH.WS",
    "TPH",
    "TPHS",
    "TPIC",
    "TPL",
    "TPR",
    "TPRE",
    "TPTX",
    "TPVG",
    "TPVY",
    "TPX",
    "TPZ",
    "TQQQ",
    "TR",
    "TRC",
    "TRCB",
    "TRCH",
    "TRCO",
    "TREC",
    "TREE",
    "TREX",
    "TRGP",
    "TRHC",
    "TRI",
    "TRIB",
    "TRIL",
    "TRIP",
    "TRK",
    "TRMB",
    "TRMD",
    "TRMK",
    "TRMT",
    "TRN",
    "TRNE",
    "TRNE.U",
    "TRNE.WS",
    "TRNO",
    "TRNS",
    "TRNX",
    "TROV",
    "TROW",
    "TROX",
    "TRP",
    "TRPX",
    "TRQ",
    "TRS",
    "TRST",
    "TRT",
    "TRTN",
    "TRTN^A",
    "TRTN^B",
    "TRTX",
    "TRU",
    "TRUE",
    "TRUP",
    "TRV",
    "TRVG",
    "TRVI",
    "TRVN",
    "TRWH",
    "TRX",
    "TRXC",
    "TS",
    "TSBK",
    "TSC",
    "TSCAP",
    "TSCBP",
    "TSCO",
    "TSE",
    "TSEM",
    "TSG",
    "TSI",
    "TSLA",
    "TSLF",
    "TSLX",
    "TSM",
    "TSN",
    "TSQ",
    "TSRI",
    "TSS",
    "TSU",
    "TTC",
    "TTD",
    "TTEC",
    "TTEK",
    "TTGT",
    "TTI",
    "TTM",
    "TTMI",
    "TTNP",
    "TTOO",
    "TTP",
    "TTPH",
    "TTS",
    "TTTN",
    "TTWO",
    "TU",
    "TUES",
    "TUFN",
    "TUP",
    "TUR",
    "TURN",
    "TUSA",
    "TUSK",
    "TV",
    "TVC",
    "TVE",
    "TVIX",
    "TVTY",
    "TW",
    "TWI",
    "TWIN",
    "TWLO",
    "TWMC",
    "TWN",
    "TWNK",
    "TWNKW",
    "TWO",
    "TWOU",
    "TWO^A",
    "TWO^B",
    "TWO^C",
    "TWO^D",
    "TWO^E",
    "TWST",
    "TWTR",
    "TX",
    "TXG",
    "TXMD",
    "TXN",
    "TXRH",
    "TXT",
    "TY",
    "TYG",
    "TYHT",
    "TYL",
    "TYME",
    "TYPE",
    "TY^",
    "TZAC",
    "TZACU",
    "TZACW",
    "TZOO",
    "UA",
    "UAA",
    "UAE",
    "UAL",
    "UAMY",
    "UAN",
    "UAVS",
    "UBA",
    "UBCP",
    "UBER",
    "UBFO",
    "UBIO",
    "UBNK",
    "UBOH",
    "UBP",
    "UBP^G",
    "UBP^H",
    "UBS",
    "UBSI",
    "UBX",
    "UCBI",
    "UCFC",
    "UCTT",
    "UDR",
    "UE",
    "UEC",
    "UEIC",
    "UEPS",
    "UFAB",
    "UFCS",
    "UFI",
    "UFPI",
    "UFPT",
    "UFS",
    "UG",
    "UGI",
    "UGLD",
    "UGP",
    "UHAL",
    "UHS",
    "UHT",
    "UI",
    "UIHC",
    "UIS",
    "UL",
    "ULBI",
    "ULH",
    "ULTA",
    "UMBF",
    "UMC",
    "UMH",
    "UMH^B",
    "UMH^C",
    "UMH^D",
    "UMPQ",
    "UMRX",
    "UN",
    "UNAM",
    "UNB",
    "UNF",
    "UNFI",
    "UNH",
    "UNIT",
    "UNM",
    "UNMA",
    "UNP",
    "UNT",
    "UNTY",
    "UNVR",
    "UONE",
    "UONEK",
    "UPLD",
    "UPS",
    "UPWK",
    "URBN",
    "URG",
    "URGN",
    "URI",
    "UROV",
    "USA",
    "USAC",
    "USAK",
    "USAP",
    "USAS",
    "USAT",
    "USATP",
    "USAU",
    "USB",
    "USB^A",
    "USB^H",
    "USB^M",
    "USB^O",
    "USB^P",
    "USCR",
    "USDP",
    "USEG",
    "USFD",
    "USIG",
    "USIO",
    "USLB",
    "USLM",
    "USLV",
    "USM",
    "USMC",
    "USNA",
    "USOI",
    "USPH",
    "USWS",
    "USWSW",
    "USX",
    "UTF",
    "UTG",
    "UTHR",
    "UTI",
    "UTL",
    "UTMD",
    "UTSI",
    "UTX",
    "UUU",
    "UUUU",
    "UUUU.WS",
    "UVE",
    "UVSP",
    "UVV",
    "UXIN",
    "UZA",
    "UZB",
    "UZC",
    "V",
    "VAC",
    "VAL",
    "VALE",
    "VALU",
    "VALX",
    "VAM",
    "VAPO",
    "VAR",
    "VBF",
    "VBFC",
    "VBIV",
    "VBLT",
    "VBND",
    "VBTX",
    "VC",
    "VCEL",
    "VCF",
    "VCIF",
    "VCIT",
    "VCLT",
    "VCNX",
    "VCRA",
    "VCSH",
    "VCTR",
    "VCV",
    "VCYT",
    "VEC",
    "VECO",
    "VEDL",
    "VEEV",
    "VEON",
    "VER",
    "VERB",
    "VERBW",
    "VERI",
    "VERU",
    "VERY",
    "VER^F",
    "VET",
    "VETS",
    "VFC",
    "VFF",
    "VFL",
    "VG",
    "VGI",
    "VGIT",
    "VGLT",
    "VGM",
    "VGR",
    "VGSH",
    "VGZ",
    "VHC",
    "VHI",
    "VIA",
    "VIAB",
    "VIAV",
    "VICI",
    "VICR",
    "VIDI",
    "VIGI",
    "VIIX",
    "VIOT",
    "VIPS",
    "VIRC",
    "VIRT",
    "VISL",
    "VIST",
    "VISTER",
    "VIV",
    "VIVE",
    "VIVO",
    "VJET",
    "VKI",
    "VKQ",
    "VKTX",
    "VKTXW",
    "VLGEA",
    "VLO",
    "VLRS",
    "VLRX",
    "VLT",
    "VLY",
    "VLYPO",
    "VLYPP",
    "VMBS",
    "VMC",
    "VMD",
    "VMET",
    "VMI",
    "VMM",
    "VMO",
    "VMW",
    "VNCE",
    "VNDA",
    "VNE",
    "VNET",
    "VNO",
    "VNOM",
    "VNO^K",
    "VNO^L",
    "VNO^M",
    "VNQI",
    "VNRX",
    "VNTR",
    "VOC",
    "VOD",
    "VOLT",
    "VONE",
    "VONG",
    "VONV",
    "VOXX",
    "VOYA",
    "VOYA^B",
    "VPG",
    "VPV",
    "VRA",
    "VRAY",
    "VRCA",
    "VREX",
    "VRIG",
    "VRML",
    "VRNA",
    "VRNS",
    "VRNT",
    "VRRM",
    "VRS",
    "VRSK",
    "VRSN",
    "VRTS",
    "VRTSP",
    "VRTU",
    "VRTV",
    "VRTX",
    "VSAT",
    "VSDA",
    "VSEC",
    "VSH",
    "VSI",
    "VSLR",
    "VSM",
    "VSMV",
    "VST",
    "VST.WS.A",
    "VSTM",
    "VSTO",
    "VTA",
    "VTC",
    "VTEC",
    "VTGN",
    "VTHR",
    "VTIP",
    "VTIQ",
    "VTIQU",
    "VTIQW",
    "VTN",
    "VTNR",
    "VTR",
    "VTSI",
    "VTUS",
    "VTVT",
    "VTWG",
    "VTWO",
    "VTWV",
    "VUSE",
    "VUZI",
    "VVI",
    "VVPR",
    "VVR",
    "VVUS",
    "VVV",
    "VWOB",
    "VXRT",
    "VXUS",
    "VYGR",
    "VYMI",
    "VZ",
    "W",
    "WAAS",
    "WAB",
    "WABC",
    "WAFD",
    "WAFU",
    "WAIR",
    "WAL",
    "WALA",
    "WASH",
    "WAT",
    "WATT",
    "WB",
    "WBA",
    "WBAI",
    "WBC",
    "WBK",
    "WBND",
    "WBS",
    "WBS^F",
    "WBT",
    "WCC",
    "WCG",
    "WCLD",
    "WCN",
    "WD",
    "WDAY",
    "WDC",
    "WDFC",
    "WDR",
    "WEA",
    "WEBK",
    "WEC",
    "WEI",
    "WELL",
    "WEN",
    "WERN",
    "WES",
    "WETF",
    "WEX",
    "WEYS",
    "WF",
    "WFC",
    "WFC^L",
    "WFC^N",
    "WFC^O",
    "WFC^P",
    "WFC^Q",
    "WFC^R",
    "WFC^T",
    "WFC^V",
    "WFC^W",
    "WFC^X",
    "WFC^Y",
    "WFE^A",
    "WGO",
    "WH",
    "WHD",
    "WHF",
    "WHFBZ",
    "WHG",
    "WHLM",
    "WHLR",
    "WHLRD",
    "WHLRP",
    "WHR",
    "WIA",
    "WIFI",
    "WILC",
    "WINA",
    "WINC",
    "WING",
    "WINS",
    "WIRE",
    "WISA",
    "WIT",
    "WIW",
    "WIX",
    "WK",
    "WKHS",
    "WLDN",
    "WLFC",
    "WLH",
    "WLK",
    "WLKP",
    "WLL",
    "WLTW",
    "WM",
    "WMB",
    "WMC",
    "WMGI",
    "WMK",
    "WMS",
    "WMT",
    "WNC",
    "WNEB",
    "WNFM",
    "WNS",
    "WOOD",
    "WOR",
    "WORK",
    "WORX",
    "WOW",
    "WPC",
    "WPG",
    "WPG^H",
    "WPG^I",
    "WPM",
    "WPP",
    "WPRT",
    "WPX",
    "WRB",
    "WRB^B",
    "WRB^C",
    "WRB^D",
    "WRB^E",
    "WRE",
    "WRI",
    "WRK",
    "WRLD",
    "WRLS",
    "WRLSR",
    "WRLSU",
    "WRLSW",
    "WRN",
    "WRTC",
    "WSBC",
    "WSBF",
    "WSC",
    "WSFS",
    "WSG",
    "WSM",
    "WSO",
    "WSO.B",
    "WSR",
    "WST",
    "WSTG",
    "WSTL",
    "WTBA",
    "WTER",
    "WTFC",
    "WTFCM",
    "WTI",
    "WTM",
    "WTR",
    "WTRE",
    "WTREP",
    "WTRH",
    "WTRU",
    "WTS",
    "WTT",
    "WTTR",
    "WU",
    "WUBA",
    "WVE",
    "WVFC",
    "WVVI",
    "WVVIP",
    "WW",
    "WWD",
    "WWE",
    "WWR",
    "WWW",
    "WY",
    "WYND",
    "WYNN",
    "WYY",
    "X",
    "XAIR",
    "XAN",
    "XAN^C",
    "XBIO",
    "XBIOW",
    "XBIT",
    "XCUR",
    "XEC",
    "XEL",
    "XELA",
    "XELB",
    "XENE",
    "XENT",
    "XERS",
    "XFLT",
    "XFOR",
    "XHR",
    "XIN",
    "XLNX",
    "XLRN",
    "XNCR",
    "XNET",
    "XOG",
    "XOM",
    "XOMA",
    "XON",
    "XONE",
    "XPEL",
    "XPER",
    "XPL",
    "XPO",
    "XRAY",
    "XRF",
    "XRX",
    "XSPA",
    "XT",
    "XTLB",
    "XTNT",
    "XXII",
    "XYF",
    "XYL",
    "Y",
    "YCBD",
    "YELP",
    "YETI",
    "YEXT",
    "YGYI",
    "YI",
    "YIN",
    "YJ",
    "YLCO",
    "YLDE",
    "YMAB",
    "YNDX",
    "YORW",
    "YPF",
    "YRCW",
    "YRD",
    "YTEN",
    "YTRA",
    "YUM",
    "YUMA",
    "YUMC",
    "YVR",
    "YY",
    "Z",
    "ZAGG",
    "ZAYO",
    "ZBH",
    "ZBIO",
    "ZBK",
    "ZBRA",
    "ZB^A",
    "ZB^G",
    "ZB^H",
    "ZDGE",
    "ZEAL",
    "ZEN",
    "ZEUS",
    "ZF",
    "ZFGN",
    "ZG",
    "ZGNX",
    "ZION",
    "ZIONW",
    "ZIOP",
    "ZIV",
    "ZIXI",
    "ZKIN",
    "ZLAB",
    "ZM",
    "ZN",
    "ZNGA",
    "ZNH",
    "ZNWAA",
    "ZOM",
    "ZS",
    "ZSAN",
    "ZTEST",
    "ZTO",
    "ZTR",
    "ZTS",
    "ZUMZ",
    "ZUO",
    "ZVO",
    "ZYME",
    "ZYNE",
    "ZYXI",
]

STOCK_NAMES = [
    "1-800 FLOWERS.COM",
    "10x Genomics",
    "111",
    "1347 Property Insurance Holdings",
    "180 Degree Capital Corp.",
    "1895 Bancorp of Wisconsin",
    "1st Constitution Bancorp (NJ)",
    "1st Source Corporation",
    "21Vianet Group",
    "22nd Century Group",
    "2U",
    "360 Finance",
    "3D Systems Corporation",
    "3M Company",
    "500.com Limited",
    "51job",
    "58.com Inc.",
    "8i Enterprises Acquisition Corp",
    "8x8 Inc",
    "9F Inc.",
    "A-Mark Precious Metals",
    "A.H. Belo Corporation",
    "A.O Smith Corporation",
    "A10 Networks",
    "AAC Holdings",
    "AAON",
    "AAR Corp.",
    "ABB Ltd",
    "ABIOMED",
    "ABM Industries Incorporated",
    "AC Immune SA",
    "ACADIA Pharmaceuticals Inc.",
    "ACI Worldwide",
    "ACM Research",
    "ACNB Corporation",
    "ADDvantage Technologies Group",
    "ADMA Biologics Inc",
    "ADT Inc.",
    "ADTRAN",
    "AECOM",
    "AEterna Zentaris Inc.",
    "AG Mortgage Investment Trust",
    "AGBA Acquisition Limited",
    "AGCO Corporation",
    "AGM Group Holdings Inc.",
    "AGNC Investment Corp.",
    "AK Steel Holding Corporation",
    "ALJ Regional Holdings",
    "AMAG Pharmaceuticals",
    "AMC Entertainment Holdings",
    "AMC Networks Inc.",
    "AMCI Acquisition Corp.",
    "AMCON Distributing Company",
    "AMERIPRISE FINANCIAL SERVICES",
    "AMERISAFE",
    "AMN Healthcare Services Inc",
    "AMREP Corporation",
    "AMTD International Inc.",
    "AMTEK",
    "ANGI Homeservices Inc.",
    "ANI Pharmaceuticals",
    "ANSYS",
    "ARC Document Solutions",
    "ARCA biopharma",
    "ARMOUR Residential REIT",
    "ARYA Sciences Acquisition Corp.",
    "ASA Gold and Precious Metals Limited",
    "ASE Technology Holding Co.",
    "ASGN Incorporated",
    "ASLAN Pharmaceuticals Limited",
    "ASML Holding N.V.",
    "AT&T Inc.",
    "ATA Inc.",
    "ATIF Holdings Limited",
    "ATN International",
    "AU Optronics Corp",
    "AVEO Pharmaceuticals",
    "AVROBIO",
    "AVX Corporation",
    "AXA Equitable Holdings",
    "AXT Inc",
    "AZZ Inc.",
    "Aaron&#39;s",
    "AbbVie Inc.",
    "Abbott Laboratories",
    "Abeona Therapeutics Inc.",
    "Abercrombie & Fitch Company",
    "Aberdeen Asia-Pacific Income Fund Inc",
    "Aberdeen Australia Equity Fund Inc",
    "Aberdeen Emerging Markets Equity Income Fund",
    "Aberdeen Global Dynamic Dividend Fund",
    "Aberdeen Global Income Fund",
    "Aberdeen Global Premier Properties Fund",
    "Aberdeen Income Credit Strategies Fund",
    "Aberdeen Japan Equity Fund",
    "Aberdeen Total Dynamic Dividend Fund",
    "Ability Inc.",
    "Abraxas Petroleum Corporation",
    "Acacia Communications",
    "Acacia Research Corporation",
    "Acadia Healthcare Company",
    "Acadia Realty Trust",
    "Acamar Partners Acquisition Corp.",
    "Acasti Pharma",
    "Accelerate Diagnostics",
    "Accelerated Pharma",
    "Acceleron Pharma Inc.",
    "Accenture plc",
    "Acco Brands Corporation",
    "Accuray Incorporated",
    "AcelRx Pharmaceuticals",
    "Acer Therapeutics Inc.",
    "Achieve Life Sciences",
    "Achillion Pharmaceuticals",
    "Aclaris Therapeutics",
    "Acme United Corporation.",
    "Acorda Therapeutics",
    "Acorn International",
    "Act II Global Acquisition Corp.",
    "Actinium Pharmaceuticals",
    "Activision Blizzard",
    "Actuant Corporation",
    "Acuity Brands",
    "Acushnet Holdings Corp.",
    "Adamas Pharmaceuticals",
    "Adamis Pharmaceuticals Corporation",
    "Adams Diversified Equity Fund",
    "Adams Natural Resources Fund",
    "Adams Resources & Energy",
    "Adaptimmune Therapeutics plc",
    "Adaptive Biotechnologies Corporation",
    "Addus HomeCare Corporation",
    "Adecoagro S.A.",
    "Adesto Technologies Corporation",
    "Adial Pharmaceuticals",
    "Adient plc",
    "Adobe Inc.",
    "Adtalem Global Education Inc.",
    "Aduro Biotech",
    "AdvanSix Inc.",
    "Advance Auto Parts Inc",
    "Advanced Disposal Services",
    "Advanced Drainage Systems",
    "Advanced Emissions Solutions",
    "Advanced Energy Industries",
    "Advanced Micro Devices",
    "Advaxis",
    "Advent Convertible and Income Fund",
    "Adverum Biotechnologies",
    "AdvisorShares Dorsey Wright Micro-Cap ETF",
    "AdvisorShares Dorsey Wright Short ETF",
    "AdvisorShares Sabretooth ETF",
    "AdvisorShares Vice ETF",
    "Aegion Corp",
    "Aeglea BioTherapeutics",
    "Aegon NV",
    "Aehr Test Systems",
    "Aemetis",
    "Aercap Holdings N.V.",
    "Aerie Pharmaceuticals",
    "AeroCentury Corp.",
    "AeroVironment",
    "Aerojet Rocketdyne Holdings",
    "Aerpio Pharmaceuticals",
    "Aethlon Medical",
    "Aevi Genomic Medicine",
    "Affiliated Managers Group",
    "Affimed N.V.",
    "Aflac Incorporated",
    "Afya Limited",
    "AgEagle Aerial Systems",
    "AgeX Therapeutics",
    "Agenus Inc.",
    "Agile Therapeutics",
    "Agilent Technologies",
    "Agilysys",
    "Agios Pharmaceuticals",
    "Agnico Eagle Mines Limited",
    "Agree Realty Corporation",
    "AgroFresh Solutions",
    "Aileron Therapeutics",
    "Aimmune Therapeutics",
    "Air Industries Group",
    "Air Lease Corporation",
    "Air Products and Chemicals",
    "Air T",
    "Air Transport Services Group",
    "AirNet Technology Inc.",
    "Aircastle Limited",
    "Airgain",
    "Akamai Technologies",
    "Akari Therapeutics Plc",
    "Akazoo S.A.",
    "Akcea Therapeutics",
    "Akebia Therapeutics",
    "Akerna Corp.",
    "Akero Therapeutics",
    "Akers Biosciences Inc.",
    "Akorn",
    "Akoustis Technologies",
    "Alabama Power Company",
    "Alamo Group",
    "Alamos Gold Inc.",
    "Alarm.com Holdings",
    "Alaska Air Group",
    "Alaska Communications Systems Group",
    "Albany International Corporation",
    "Albemarle Corporation",
    "Alberton Acquisition Corporation",
    "Albireo Pharma",
    "Alcentra Capital Corp.",
    "Alcoa Corporation",
    "Alcon Inc.",
    "Alder BioPharmaceuticals",
    "Aldeyra Therapeutics",
    "Alector",
    "Alerus Financial Corporation",
    "Alexander & Baldwin",
    "Alexander&#39;s",
    "Alexandria Real Estate Equities",
    "Alexco Resource Corp",
    "Alexion Pharmaceuticals",
    "Algonquin Power & Utilities Corp.",
    "Alibaba Group Holding Limited",
    "Alico",
    "Alight Inc.",
    "Align Technology",
    "Alimera Sciences",
    "Alio Gold Inc.",
    "Alithya Group inc.",
    "Alkermes plc",
    "Allakos Inc.",
    "Alleghany Corporation",
    "Allegheny Technologies Incorporated",
    "Allegiance Bancshares",
    "Allegiant Travel Company",
    "Allegion plc",
    "Allegro Merger Corp.",
    "Allena Pharmaceuticals",
    "Allergan plc.",
    "Allete",
    "Alliance Data Systems Corporation",
    "Alliance National Municipal Income Fund Inc",
    "Alliance Resource Partners",
    "Alliance World Dollar Government Fund II",
    "AllianceBernstein Holding L.P.",
    "Alliant Energy Corporation",
    "AllianzGI Convertible & Income 2024 Target Term Fund",
    "AllianzGI Convertible & Income Fund",
    "AllianzGI Convertible & Income Fund II",
    "AllianzGI Diversified Income & Convertible Fund",
    "AllianzGI Equity & Convertible Income Fund",
    "AllianzGI NFJ Dividend",
    "Allied Esports Entertainment",
    "Allied Healthcare Products",
    "Allied Motion Technologies",
    "Allison Transmission Holdings",
    "Allogene Therapeutics",
    "Allot Ltd.",
    "Allscripts Healthcare Solutions",
    "Allstate Corporation (The)",
    "Ally Financial Inc.",
    "Almaden Minerals",
    "Alnylam Pharmaceuticals",
    "Alpha Pro Tech",
    "Alpha and Omega Semiconductor Limited",
    "AlphaMark Actively Managed Small Cap ETF",
    "Alphabet Inc.",
    "Alphatec Holdings",
    "Alpine Immune Sciences",
    "Alta Mesa Resources",
    "Altaba Inc.",
    "Altair Engineering Inc.",
    "Alterity Therapeutics Limited",
    "Alteryx",
    "Altice USA",
    "Altimmune",
    "Altisource Asset Management Corp",
    "Altisource Portfolio Solutions S.A.",
    "Altra Industrial Motion Corp.",
    "Altria Group",
    "Altus Midstream Company",
    "Aluminum Corporation of China Limited",
    "Amalgamated Bank",
    "Amarin Corporation plc",
    "Amazon.com",
    "Ambac Financial Group",
    "Ambarella",
    "Ambev S.A.",
    "Ambow Education Holding Ltd.",
    "Amcor plc",
    "Amdocs Limited",
    "Amedisys Inc",
    "Amerant Bancorp Inc.",
    "Amerco",
    "Ameren Corporation",
    "Ameresco",
    "Ameri Holdings",
    "AmeriServ Financial Inc.",
    "America First Multifamily Investors",
    "America Movil",
    "America&#39;s Car-Mart",
    "American Airlines Group",
    "American Assets Trust",
    "American Axle & Manufacturing Holdings",
    "American Campus Communities Inc",
    "American Eagle Outfitters",
    "American Electric Power Company",
    "American Equity Investment Life Holding Company",
    "American Express Company",
    "American Finance Trust",
    "American Financial Group",
    "American Homes 4 Rent",
    "American International Group",
    "American National Bankshares",
    "American National Insurance Company",
    "American Outdoor Brands Corporation",
    "American Public Education",
    "American Realty Investors",
    "American Renal Associates Holdings",
    "American Resources Corporation",
    "American River Bankshares",
    "American Shared Hospital Services",
    "American Software",
    "American States Water Company",
    "American Superconductor Corporation",
    "American Tower Corporation (REIT)",
    "American Vanguard Corporation",
    "American Water Works",
    "American Woodmark Corporation",
    "Americas Gold and Silver Corporation",
    "Americold Realty Trust",
    "Ameris Bancorp",
    "AmerisourceBergen Corporation (Holding Co)",
    "Ames National Corporation",
    "Amgen Inc.",
    "Amicus Therapeutics",
    "Amira Nature Foods Ltd",
    "Amkor Technology",
    "Amneal Pharmaceuticals",
    "Ampco-Pittsburgh Corporation",
    "Amphastar Pharmaceuticals",
    "Amphenol Corporation",
    "Ampio Pharmaceuticals",
    "Amplify Online Retail ETF",
    "Amtech Systems",
    "Amyris",
    "Analog Devices",
    "Anaplan",
    "AnaptysBio",
    "Anavex Life Sciences Corp.",
    "Anchiano Therapeutics Ltd.",
    "Andina Acquisition Corp. III",
    "Angel Oak Financial Strategies Income Term Trust",
    "AngioDynamics",
    "AngloGold Ashanti Limited",
    "Anheuser-Busch Inbev SA",
    "Anika Therapeutics Inc.",
    "Anixa Biosciences",
    "Anixter International Inc.",
    "Annaly Capital Management Inc",
    "Antares Pharma",
    "Anterix Inc.",
    "Antero Midstream Corporation",
    "Antero Resources Corporation",
    "Anthem",
    "Anworth Mortgage Asset  Corporation",
    "Aon plc",
    "Apache Corporation",
    "Apartment Investment and Management Company",
    "Apellis Pharmaceuticals",
    "Apergy Corporation",
    "Apex Global Brands Inc.",
    "Aphria Inc.",
    "Apogee Enterprises",
    "Apollo Commercial Real Estate Finance",
    "Apollo Endosurgery",
    "Apollo Global Management",
    "Apollo Investment Corporation",
    "Apollo Medical Holdings",
    "Apollo Senior Floating Rate Fund Inc.",
    "Apollo Tactical Income Fund Inc.",
    "AppFolio",
    "Appian Corporation",
    "Apple Hospitality REIT",
    "Apple Inc.",
    "Applied DNA Sciences Inc",
    "Applied Genetic Technologies Corporation",
    "Applied Industrial Technologies",
    "Applied Materials",
    "Applied Optoelectronics",
    "Applied Therapeutics",
    "Approach Resources Inc.",
    "AptarGroup",
    "Aptevo Therapeutics Inc.",
    "Aptinyx Inc.",
    "Aptiv PLC",
    "Aptorum Group Limited",
    "Aptose Biosciences",
    "Apyx Medical Corporation",
    "Aqua America",
    "Aqua Metals",
    "AquaBounty Technologies",
    "AquaVenture Holdings Limited",
    "Aquantia Corp.",
    "Aquestive Therapeutics",
    "ArQule",
    "Aramark",
    "Aravive",
    "Arbor Realty Trust",
    "Arbutus Biopharma Corporation",
    "ArcBest Corporation",
    "Arcadia Biosciences",
    "ArcelorMittal",
    "Arch Capital Group Ltd.",
    "Arch Coal",
    "Archer-Daniels-Midland Company",
    "Archrock",
    "Arcimoto",
    "Arco Platform Limited",
    "Arconic Inc.",
    "Arcos Dorados Holdings Inc.",
    "Arcosa",
    "Arcturus Therapeutics Holdings Inc.",
    "Arcus Biosciences",
    "Ardagh Group S.A.",
    "Ardelyx",
    "Ardmore Shipping Corporation",
    "Arena Pharmaceuticals",
    "Ares Capital Corporation",
    "Ares Commercial Real Estate Corporation",
    "Ares Dynamic Credit Allocation Fund",
    "Ares Management Corporation",
    "Argan",
    "Argo Group International Holdings",
    "Aridis Pharmaceuticals Inc.",
    "Arista Networks",
    "Ark Restaurants Corp.",
    "Arlington Asset Investment Corp",
    "Arlo Technologies",
    "Armada Hoffler Properties",
    "Armata Pharmaceuticals",
    "Armstrong Flooring",
    "Armstrong World Industries Inc",
    "Arotech Corporation",
    "Arrow DWA Country Rotation ETF",
    "Arrow DWA Tactical ETF",
    "Arrow Electronics",
    "Arrow Financial Corporation",
    "Arrowhead Pharmaceuticals",
    "Art&#39;s-Way Manufacturing Co.",
    "Artelo Biosciences",
    "Artesian Resources Corporation",
    "Arthur J. Gallagher & Co.",
    "Artisan Partners Asset Management Inc.",
    "Arvinas",
    "Asanko Gold Inc.",
    "Asbury Automotive Group Inc",
    "Ascena Retail Group",
    "Ascendis Pharma A/S",
    "Ashford Hospitality Trust Inc",
    "Ashford Inc.",
    "Ashland Global Holdings Inc.",
    "Asia Pacific Wire & Cable Corporation Limited",
    "Aspen Aerogels",
    "Aspen Group Inc.",
    "Aspen Insurance Holdings Limited",
    "Aspen Technology",
    "Assembly Biosciences",
    "Assertio Therapeutics",
    "AssetMark Financial Holdings",
    "Associated Banc-Corp",
    "Associated Capital Group",
    "Assurant",
    "Assured Guaranty Ltd.",
    "Asta Funding",
    "Astec Industries",
    "Astrazeneca PLC",
    "AstroNova",
    "Astronics Corporation",
    "Astrotech Corporation",
    "Asure Software Inc",
    "At Home Group Inc.",
    "Atara Biotherapeutics",
    "Atento S.A.",
    "Athene Holding Ltd.",
    "Athenex",
    "Athersys",
    "Atkore International Group Inc.",
    "Atlantic American Corporation",
    "Atlantic Capital Bancshares",
    "Atlantic Power Corporation",
    "Atlantic Union Bankshares Corporation",
    "Atlantica Yield plc",
    "Atlanticus Holdings Corporation",
    "Atlas Air Worldwide Holdings",
    "Atlas Financial Holdings",
    "Atlassian Corporation Plc",
    "Atmos Energy Corporation",
    "Atomera Incorporated",
    "Atossa Genetics Inc.",
    "Atreca",
    "AtriCure",
    "Atrion Corporation",
    "Attis Industries Inc.",
    "Auburn National Bancorporation",
    "Audentes Therapeutics",
    "AudioCodes Ltd.",
    "AudioEye",
    "Aurinia Pharmaceuticals Inc",
    "Auris Medical Holding Ltd.",
    "Aurora Cannabis Inc.",
    "Aurora Mobile Limited",
    "Auryn Resources Inc.",
    "AutoNation",
    "AutoWeb",
    "AutoZone",
    "Autodesk",
    "Autohome Inc.",
    "Autoliv",
    "Autolus Therapeutics plc",
    "Automatic Data Processing",
    "Avadel Pharmaceuticals plc",
    "Avalara",
    "Avalon GloboCare Corp.",
    "Avalon Holdings Corporation",
    "AvalonBay Communities",
    "Avangrid",
    "Avanos Medical",
    "Avantor",
    "Avaya Holdings Corp.",
    "Avedro",
    "Avenue Therapeutics",
    "Avery Dennison Corporation",
    "Avianca Holdings S.A.",
    "Aviat Networks",
    "Avid Bioservices",
    "Avid Technology",
    "Avinger",
    "Avino Silver",
    "Avis Budget Group",
    "Avista Corporation",
    "Avnet",
    "Avon Products",
    "Aware",
    "Axalta Coating Systems Ltd.",
    "Axcelis Technologies",
    "Axcella Health Inc.",
    "Axis Capital Holdings Limited",
    "AxoGen",
    "Axon Enterprise",
    "Axonics Modulation Technologies",
    "Axos Financial",
    "Axovant Gene Therapies Ltd.",
    "Axsome Therapeutics",
    "Aytu BioScience",
    "Azul S.A.",
    "AzurRx BioPharma",
    "Azure Power Global Limited",
    "B Communications Ltd.",
    "B&G Foods",
    "B. Riley Financial",
    "B. Riley Principal Merger Corp.",
    "B.O.S. Better Online Solutions",
    "B2Gold Corp",
    "BATS BZX Exchange",
    "BB&T Corporation",
    "BBVA Banco Frances S.A.",
    "BBX Capital Corporation",
    "BCB Bancorp",
    "BCE",
    "BELLUS Health Inc.",
    "BEST Inc.",
    "BG Staffing Inc",
    "BGC Partners",
    "BHP Group Limited",
    "BHP Group Plc",
    "BIO-key International",
    "BJ&#39;s Restaurants",
    "BJ&#39;s Wholesale Club Holdings",
    "BK Technologies Corporation",
    "BLACKROCK INTERNATIONAL",
    "BMC Stock Holdings",
    "BNY Mellon Alcentra Global Credit Income 2024 Target Term Fund",
    "BNY Mellon High Yield Strategies Fund",
    "BNY Mellon Municipal Bond Infrastructure Fund",
    "BNY Mellon Municipal Income Inc.",
    "BNY Mellon Strategic Municipal Bond Fund",
    "BNY Mellon Strategic Municipals",
    "BOK Financial Corporation",
    "BP Midstream Partners LP",
    "BP Prudhoe Bay Royalty Trust",
    "BP p.l.c.",
    "BRF S.A.",
    "BRP Inc.",
    "BRT Apartments Corp.",
    "BSQUARE Corporation",
    "BT Group plc",
    "BWX Technologies",
    "Babcock",
    "Babson Global Short Duration High Yield Fund",
    "Badger Meter",
    "Baidu",
    "Bain Capital Specialty Finance",
    "Baker Hughes",
    "Balchem Corporation",
    "BalckRock Taxable Municipal Bond Trust",
    "Ball Corporation",
    "Ballantyne Strong",
    "Ballard Power Systems",
    "BanColombia S.A.",
    "Banc of California",
    "BancFirst Corporation",
    "Banco Bilbao Viscaya Argentaria S.A.",
    "Banco Bradesco Sa",
    "Banco De Chile",
    "Banco Latinoamericano de Comercio Exterior",
    "Banco Santander",
    "Banco Santander Brasil SA",
    "Banco Santander Chile",
    "Banco Santander Mexico",
    "Bancorp 34",
    "Bancorp of New Jersey",
    "BancorpSouth Bank",
    "Bancroft Fund Limited",
    "Bandwidth Inc.",
    "Bank First Corporation",
    "Bank OZK",
    "Bank Of Montreal",
    "Bank Of New York Mellon Corporation (The)",
    "Bank of America Corporation",
    "Bank of Commerce Holdings (CA)",
    "Bank of Hawaii Corporation",
    "Bank of Marin Bancorp",
    "Bank of N.T. Butterfield & Son Limited (The)",
    "Bank of Nova Scotia (The)",
    "Bank of South Carolina Corp.",
    "Bank of the James Financial Group",
    "Bank7 Corp.",
    "BankFinancial Corporation",
    "BankUnited",
    "Bankwell Financial Group",
    "Banner Corporation",
    "Baozun Inc.",
    "Bar Harbor Bankshares",
    "Barclays PLC",
    "Barings BDC",
    "Barings Corporate Investors",
    "Barings Participation Investors",
    "Barnes & Noble Education",
    "Barnes Group",
    "Barnwell Industries",
    "Barrett Business Services",
    "Barrick Gold Corporation",
    "Basic Energy Services",
    "Bassett Furniture Industries",
    "Bat Group",
    "Bausch Health Companies Inc.",
    "Baxter International Inc.",
    "BayCom Corp",
    "Baytex Energy Corp",
    "Beacon Roofing Supply",
    "Beasley Broadcast Group",
    "Beazer Homes USA",
    "Becton",
    "Bed Bath & Beyond Inc.",
    "BeiGene",
    "Bel Fuse Inc.",
    "Belden Inc",
    "Bellerophon Therapeutics",
    "Bellicum Pharmaceuticals",
    "Benchmark Electronics",
    "Benefitfocus",
    "Benitec Biopharma Limited",
    "Berkshire Hathaway Inc.",
    "Berkshire Hills Bancorp",
    "Berry Global Group",
    "Berry Petroleum Corporation",
    "Best Buy Co.",
    "Beyond Air",
    "Beyond Meat",
    "BeyondSpring",
    "Bicycle Therapeutics plc",
    "Big 5 Sporting Goods Corporation",
    "Big Lots",
    "Big Rock Partners Acquisition Corp.",
    "Biglari Holdings Inc.",
    "Bilibili Inc.",
    "Bio-Path Holdings",
    "Bio-Rad Laboratories",
    "Bio-Techne Corp",
    "BioCardia",
    "BioCryst Pharmaceuticals",
    "BioDelivery Sciences International",
    "BioHiTech Global",
    "BioLife Solutions",
    "BioLineRx Ltd.",
    "BioMarin Pharmaceutical Inc.",
    "BioPharmX Corporation",
    "BioSig Technologies",
    "BioSpecifics Technologies Corp",
    "BioTelemetry",
    "BioVie Inc.",
    "BioXcel Therapeutics",
    "Bioanalytical Systems",
    "Biocept",
    "Bioceres Crop Solutions Corp.",
    "Biofrontera AG",
    "Biogen Inc.",
    "Biohaven Pharmaceutical Holding Company Ltd.",
    "Biolase",
    "Biomerica",
    "Bionano Genomics",
    "BiondVax Pharmaceuticals Ltd.",
    "Bionik Laboratories Corp.",
    "Birks Group Inc.",
    "Bitauto Holdings Limited",
    "Black Hills Corporation",
    "Black Knight",
    "Black Stone Minerals",
    "BlackBerry Limited",
    "BlackLine",
    "BlackRock",
    "BlackRock 2022 Global Income Opportunity Trust",
    "BlackRock California Municipal Income Trust",
    "BlackRock Capital Investment Corporation",
    "BlackRock Credit Allocation Income Trust",
    "BlackRock Energy and Resources Trust",
    "BlackRock Income Investment Quality Trust",
    "BlackRock Income Trust Inc. (The)",
    "BlackRock Investment Quality Municipal Trust Inc. (The)",
    "BlackRock Long-Term Municipal Advantage Trust",
    "BlackRock Maryland Municipal Bond Trust",
    "BlackRock Massachusetts Tax-Exempt Trust",
    "BlackRock Multi-Sector Income Trust",
    "BlackRock Municipal Income Investment Trust",
    "BlackRock Municipal Income Trust",
    "BlackRock Municipal Income Trust II",
    "BlackRock Municipal Target Term Trust Inc. (The)",
    "BlackRock New York Investment Quality Municipal Trust Inc. (Th",
    "BlackRock New York Municipal Income Trust II",
    "BlackRock Resources",
    "BlackRock Science and Technology Trust",
    "BlackRock Science and Technology Trust II",
    "BlackRock Strategic Municipal Trust Inc. (The)",
    "BlackRock TCP Capital Corp.",
    "BlackRock Utility",
    "BlackRock Virginia Municipal Bond Trust",
    "Blackbaud",
    "Blackrock Capital and Income Strategies Fund Inc",
    "Blackrock Core Bond Trust",
    "Blackrock Corporate High Yield Fund",
    "Blackrock Debt Strategies Fund",
    "Blackrock Enhanced Equity Dividend Trust",
    "Blackrock Enhanced Government Fund",
    "Blackrock Floating Rate Income Strategies Fund Inc",
    "Blackrock Florida Municipal 2020 Term Trust",
    "Blackrock Global",
    "Blackrock Health Sciences Trust",
    "Blackrock Muni Intermediate Duration Fund Inc",
    "Blackrock Muni New York Intermediate Duration Fund Inc",
    "Blackrock MuniAssets Fund",
    "Blackrock MuniEnhanced Fund",
    "Blackrock MuniHoldings California Quality Fund",
    "Blackrock MuniHoldings Fund",
    "Blackrock MuniHoldings Fund II",
    "Blackrock MuniHoldings Investment Quality Fund",
    "Blackrock MuniHoldings New Jersey Insured Fund",
    "Blackrock MuniHoldings New York Quality Fund",
    "Blackrock MuniHoldings Quality Fund",
    "Blackrock MuniHoldings Quality Fund II",
    "Blackrock MuniVest Fund II",
    "Blackrock MuniYield California Fund",
    "Blackrock MuniYield California Insured Fund",
    "Blackrock MuniYield Fund",
    "Blackrock MuniYield Investment Fund",
    "Blackrock MuniYield Investment QualityFund",
    "Blackrock MuniYield Michigan Quality Fund",
    "Blackrock MuniYield New Jersey Fund",
    "Blackrock MuniYield New York Quality Fund",
    "Blackrock MuniYield Pennsylvania Quality Fund",
    "Blackrock MuniYield Quality Fund",
    "Blackrock MuniYield Quality Fund II",
    "Blackrock MuniYield Quality Fund III",
    "Blackrock Municipal 2020 Term Trust",
    "Blackrock Municipal Bond Trust",
    "Blackrock Municipal Income Quality Trust",
    "Blackrock New York Municipal Bond Trust",
    "Blackrock New York Municipal Income Quality Trust",
    "Blackstone / GSO Strategic Credit Fund",
    "Blackstone GSO Long Short Credit Income Fund",
    "Blackstone GSO Senior Floating Rate Term Fund",
    "Blink Charging Co.",
    "Blonder Tongue Laboratories",
    "Bloom Energy Corporation",
    "Bloomin&#39; Brands",
    "Blucora",
    "Blue Apron Holdings",
    "Blue Bird Corporation",
    "Blue Capital Reinsurance Holdings Ltd.",
    "Blue Hat Interactive Entertainment Technology",
    "BlueLinx Holdings Inc.",
    "BlueStar Israel Technology ETF",
    "Bluegreen Vacations Corporation",
    "Blueknight Energy Partners L.P.",
    "Blueprint Medicines Corporation",
    "Bluerock Residential Growth REIT",
    "Boeing Company (The)",
    "Boingo Wireless",
    "Boise Cascade",
    "Bonanza Creek Energy",
    "Bonso Electronics International",
    "Booking Holdings Inc.",
    "Boot Barn Holdings",
    "Booz Allen Hamilton Holding Corporation",
    "BorgWarner Inc.",
    "Borqs Technologies",
    "Borr Drilling Limited",
    "Boston Beer Company",
    "Boston Omaha Corporation",
    "Boston Private Financial Holdings",
    "Boston Properties",
    "Boston Scientific Corporation",
    "Bottomline Technologies",
    "Bowl America",
    "Box",
    "Boxlight Corporation",
    "Boxwood Merger Corp.",
    "Boyd Gaming Corporation",
    "Brady Corporation",
    "Braeburn Pharmaceuticals",
    "Braemar Hotels & Resorts Inc.",
    "Brainstorm Cell Therapeutics Inc.",
    "Brainsway Ltd.",
    "Brandywine Realty Trust",
    "BrandywineGLOBAL Global Income Opportunities Fund ",
    "Brasilagro Cia Brasileira De Propriedades Agricolas",
    "Brickell Biotech",
    "Bridge Bancorp",
    "BridgeBio Pharma",
    "Bridgeline Digital",
    "Bridgewater Bancshares",
    "Bridgford Foods Corporation",
    "Briggs & Stratton Corporation",
    "Brigham Minerals",
    "Bright Horizons Family Solutions Inc.",
    "Bright Scholar Education Holdings Limited",
    "BrightSphere Investment Group Inc.",
    "BrightView Holdings",
    "Brightcove Inc.",
    "Brighthouse Financial",
    "Brink&#39;s Company (The)",
    "Brinker International",
    "Bristol-Myers Squibb Company",
    "British American Tobacco p.l.c.",
    "Brixmor Property Group Inc.",
    "BroadVision",
    "Broadcom Inc.",
    "Broadridge Financial Solutions",
    "Broadway Financial Corporation",
    "Broadwind Energy",
    "Brookdale Senior Living Inc.",
    "Brookfield Asset Management Inc",
    "Brookfield Business Partners L.P.",
    "Brookfield DTLA Inc.",
    "Brookfield Global Listed Infrastructure Income Fund",
    "Brookfield Infrastructure Partners LP",
    "Brookfield Property Partners L.P.",
    "Brookfield Property REIT Inc.",
    "Brookfield Real Assets Income Fund Inc.",
    "Brookfield Renewable Partners L.P.",
    "Brookline Bancorp",
    "Brooks Automation",
    "Brown & Brown",
    "Brown Forman Corporation",
    "Bruker Corporation",
    "Brunswick Corporation",
    "Bryn Mawr Bank Corporation",
    "Buckeye Partners L.P.",
    "Buckle",
    "Buenaventura Mining Company Inc.",
    "Build-A-Bear Workshop",
    "Builders FirstSource",
    "Bunge Limited",
    "Burlington Stores",
    "Business First Bancshares",
    "Byline Bancorp",
    "C&F Financial Corporation",
    "C&J Energy Services",
    "C.H. Robinson Worldwide",
    "CABCO Series 2004-101 Trust",
    "CACI International",
    "CAE Inc",
    "CAI International",
    "CASI Pharmaceuticals",
    "CB Financial Services",
    "CBAK Energy Technology",
    "CBIZ",
    "CBL & Associates Properties",
    "CBM Bancorp",
    "CBO (Listing Market - NYSE - Networks A/E)",
    "CBRE Clarion Global Real Estate Income Fund",
    "CBRE Group",
    "CBS Corporation",
    "CBTX",
    "CBX (Listing Market NYSE Networks AE",
    "CDK Global",
    "CDW Corporation",
    "CECO Environmental Corp.",
    "CEVA",
    "CF Finance Acquisition Corp.",
    "CF Industries Holdings",
    "CGI Inc.",
    "CHF Solutions",
    "CHS Inc",
    "CIM Commercial Trust Corporation",
    "CIRCOR International",
    "CIT Group Inc (DEL)",
    "CKX Lands",
    "CLPS Incorporation",
    "CME Group Inc.",
    "CMS Energy Corporation",
    "CNA Financial Corporation",
    "CNB Financial Corporation",
    "CNFinance Holdings Limited",
    "CNH Industrial N.V.",
    "CNO Financial Group",
    "CNOOC Limited",
    "CNX Midstream Partners LP",
    "CNX Resources Corporation",
    "CONMED Corporation",
    "CONSOL Coal Resources LP",
    "CPB Inc.",
    "CPFL Energia S.A.",
    "CPI Aerostructures",
    "CPI Card Group Inc.",
    "CPS Technologies Corp.",
    "CRA International",
    "CRH Medical Corporation",
    "CRH PLC",
    "CRISPR Therapeutics AG",
    "CSG Systems International",
    "CSI Compressco LP",
    "CSP Inc.",
    "CSS Industries",
    "CSW Industrials",
    "CSX Corporation",
    "CTI BioPharma Corp.",
    "CTI Industries Corporation",
    "CTS Corporation",
    "CUI Global",
    "CURO Group Holdings Corp.",
    "CVB Financial Corporation",
    "CVD Equipment Corporation",
    "CVR Energy Inc.",
    "CVR Partners",
    "CVS Health Corporation",
    "CYREN Ltd.",
    "Cable One",
    "Cabot Corporation",
    "Cabot Microelectronics Corporation",
    "Cabot Oil & Gas Corporation",
    "Cactus",
    "Cadence Bancorporation",
    "Cadence Design Systems",
    "Cadiz",
    "Caesars Entertainment Corporation",
    "Caesarstone Ltd.",
    "Cal-Maine Foods",
    "CalAmp Corp.",
    "Caladrius Biosciences",
    "Calamos Convertible Opportunities and Income Fund",
    "Calamos Convertible and High Income Fund",
    "Calamos Dynamic Convertible & Income Fund",
    "Calamos Global Dynamic Income Fund",
    "Calamos Global Total Return Fund",
    "Calamos Strategic Total Return Fund",
    "Calavo Growers",
    "Caledonia Mining Corporation Plc",
    "Caleres",
    "California Resources Corporation",
    "California Water  Service Group Holding",
    "Calithera Biosciences",
    "Calix",
    "Callaway Golf Company",
    "Callon Petroleum Company",
    "Calumet Specialty Products Partners",
    "Calyxt",
    "Camber Energy",
    "Cambium Networks Corporation",
    "Cambrex Corporation",
    "Cambridge Bancorp",
    "Camden National Corporation",
    "Camden Property Trust",
    "Cameco Corporation",
    "Campbell Soup Company",
    "Camping World Holdings",
    "Camtek Ltd.",
    "Can-Fite Biopharma Ltd",
    "Canada Goose Holdings Inc.",
    "Canadian Imperial Bank of Commerce",
    "Canadian National Railway Company",
    "Canadian Natural Resources Limited",
    "Canadian Pacific Railway Limited",
    "Canadian Solar Inc.",
    "Cancer Genetics",
    "Cango Inc.",
    "CannTrust Holdings Inc.",
    "Cannae Holdings",
    "Canon",
    "Canopy Growth Corporation",
    "Cantel Medical Corp.",
    "Canterbury Park Holding Corporation",
    "CapStar Financial Holdings",
    "Capital Bancorp",
    "Capital City Bank Group",
    "Capital One Financial Corporation",
    "Capital Product Partners L.P.",
    "Capital Senior Living Corporation",
    "Capital Southwest Corporation",
    "Capital Trust",
    "Capitala Finance Corp.",
    "Capitol Federal Financial",
    "Capri Holdings Limited",
    "Capricor Therapeutics",
    "Capstead Mortgage Corporation",
    "Capstone Turbine Corporation",
    "CarGurus",
    "CarMax Inc",
    "Cara Therapeutics",
    "Carbo Ceramics",
    "Carbon Black",
    "Carbonite",
    "Cardinal Health",
    "Cardiovascular Systems",
    "Cardlytics",
    "Cardtronics plc",
    "Care.com",
    "CareDx",
    "CareTrust REIT",
    "Career Education Corporation",
    "Carlisle Companies Incorporated",
    "Carnival Corporation",
    "Carolina Financial Corporation",
    "Carolina Trust BancShares",
    "Carpenter Technology Corporation",
    "Carriage Services",
    "Carrizo Oil & Gas",
    "Carrols Restaurant Group",
    "Cars.com Inc.",
    "Carter Bank & Trust",
    "Carter&#39;s",
    "Carvana Co.",
    "Carver Bancorp",
    "Casa Systems",
    "Casella Waste Systems",
    "Caseys General Stores",
    "Cass Information Systems",
    "Cassava Sciences",
    "Castle Biosciences",
    "Castle Brands",
    "Castlight Health",
    "Castor Maritime Inc.",
    "Catabasis Pharmaceuticals",
    "Catalent",
    "Catalyst Biosciences",
    "Catalyst Pharmaceuticals",
    "Catasys",
    "CatchMark Timber Trust",
    "Caterpillar",
    "Cathay General Bancorp",
    "Cato Corporation (The)",
    "Cavco Industries",
    "Cboe Global Markets",
    "Cedar Fair",
    "Cedar Realty Trust",
    "Cel-Sci Corporation",
    "Celanese Corporation",
    "Celcuity Inc.",
    "Celestica",
    "Celgene Corporation",
    "Cellcom Israel",
    "Celldex Therapeutics",
    "Cellect Biotechnology Ltd.",
    "Cellectar Biosciences",
    "Cellectis S.A.",
    "Cellular Biomedicine Group",
    "Celsion Corporation",
    "Celsius Holdings",
    "Celyad SA",
    "Cementos Pacasmayo S.A.A.",
    "Cemex S.A.B. de C.V.",
    "Cemtrex Inc.",
    "Cenovus Energy Inc",
    "Centene Corporation",
    "Centennial Resource Development",
    "Center Coast Brookfield MLP & Energy Infrastructur",
    "CenterPoint Energy",
    "CenterState Bank Corporation",
    "Centrais Electricas Brasileiras S.A.- Eletrobras",
    "Central European Media Enterprises Ltd.",
    "Central Federal Corporation",
    "Central Garden & Pet Company",
    "Central Puerto S.A.",
    "Central Securities Corporation",
    "Central Valley Community Bancorp",
    "Centrexion Therapeutics Corporation",
    "Centric Brands Inc.",
    "Centrus Energy Corp.",
    "Century Aluminum Company",
    "Century Bancorp",
    "Century Casinos",
    "Century Communities",
    "CenturyLink",
    "Ceragon Networks Ltd.",
    "Cerecor Inc.",
    "Ceridian HCM Holding Inc.",
    "Cerner Corporation",
    "Cerus Corporation",
    "Cesca Therapeutics Inc.",
    "ChaSerg Technology Acquisition Corp.",
    "Champions Oncology",
    "Change Healthcare Inc.",
    "Changyou.com Limited",
    "ChannelAdvisor Corporation",
    "Chanticleer Holdings",
    "Chaparral Energy",
    "Charah Solutions",
    "Chardan Healthcare Acquisition Corp.",
    "Charles & Colvard Ltd.",
    "Charles River Laboratories International",
    "Chart Industries",
    "Charter Communications",
    "Chase Corporation",
    "Chatham Lodging Trust (REIT)",
    "Check Point Software Technologies Ltd.",
    "Check-Cap Ltd.",
    "Checkpoint Therapeutics",
    "Cheetah Mobile Inc.",
    "Chegg",
    "Chembio Diagnostics",
    "Chemed Corp.",
    "ChemoCentryx",
    "Chemours Company (The)",
    "Chemung Financial Corp",
    "Cheniere Energy",
    "Cheniere Energy Partners",
    "Cherry Hill Mortgage Investment Corporation",
    "Chesapeake Energy Corporation",
    "Chesapeake Granite Wash Trust",
    "Chesapeake Lodging Trust",
    "Chesapeake Utilities Corporation",
    "Chevron Corporation",
    "Chewy",
    "Chiasma",
    "Chicago Rivet & Machine Co.",
    "Chicken Soup for the Soul Entertainment",
    "Chico&#39;s FAS",
    "Children&#39;s Place",
    "Chimera Investment Corporation",
    "Chimerix",
    "China Automotive Systems",
    "China Biologic Products Holdings",
    "China Ceramics Co.",
    "China Customer Relations Centers",
    "China Distance Education Holdings Limited",
    "China Eastern Airlines Corporation Ltd.",
    "China Finance Online Co. Limited",
    "China Fund",
    "China Green Agriculture",
    "China HGS Real Estate",
    "China Index Holdings Limited",
    "China Internet Nationwide Financial Services Inc.",
    "China Jo-Jo Drugstores",
    "China Life Insurance Company Limited",
    "China Mobile (Hong Kong) Ltd.",
    "China Natural Resources",
    "China Online Education Group",
    "China Petroleum & Chemical Corporation",
    "China Pharma Holdings",
    "China Rapid Finance Limited",
    "China Recycling Energy Corporation",
    "China SXT Pharmaceuticals",
    "China Southern Airlines Company Limited",
    "China TechFaith Wireless Communication Technology Limited",
    "China Telecom Corp Ltd",
    "China Unicom (Hong Kong) Ltd",
    "China XD Plastics Company Limited",
    "China Xiangtai Food Co.",
    "China Yuchai International Limited",
    "ChinaNet Online Holdings",
    "ChipMOS TECHNOLOGIES INC.",
    "Chipotle Mexican Grill",
    "Choice Hotels International",
    "ChromaDex Corporation",
    "Chubb Limited",
    "Chunghwa Telecom Co.",
    "Church & Dwight Company",
    "Churchill Capital Corp II",
    "Churchill Downs",
    "Chuy&#39;s Holdings",
    "Cibus Corp.",
    "Cidara Therapeutics",
    "Ciena Corporation",
    "Cigna Corporation",
    "Cimarex Energy Co",
    "Cimpress N.V",
    "Cincinnati Bell Inc",
    "Cincinnati Financial Corporation",
    "Cinedigm Corp",
    "Cinemark Holdings Inc",
    "Ciner Resources LP",
    "Cintas Corporation",
    "Cirrus Logic",
    "Cisco Systems",
    "Cision Ltd.",
    "Citi Trends",
    "Citigroup Inc.",
    "Citius Pharmaceuticals",
    "Citizens",
    "Citizens & Northern Corp",
    "Citizens Community Bancorp",
    "Citizens Financial Group",
    "Citizens Holding Company",
    "Citrix Systems",
    "City Holding Company",
    "City Office REIT",
    "Civeo Corporation",
    "Civista Bancshares",
    "Clarivate Analytics Plc",
    "Clarus Corporation",
    "Clean Energy Fuels Corp.",
    "Clean Harbors",
    "Clear Channel Outdoor Holdings",
    "ClearBridge All Cap Growth ETF",
    "ClearBridge Dividend Strategy ESG ETF",
    "ClearBridge Energy Midstream Opportunity Fund Inc.",
    "ClearBridge Large Cap Growth ESG ETF",
    "ClearBridge MLP and Midstream Fund Inc.",
    "ClearBridge MLP and Midstream Total Return Fund In",
    "ClearOne",
    "ClearSign Combustion Corporation",
    "Clearfield",
    "Clearside Biomedical",
    "Clearwater Paper Corporation",
    "Clearway Energy",
    "Cleveland BioLabs",
    "Cleveland-Cliffs Inc.",
    "Clipper Realty Inc.",
    "Clorox Company (The)",
    "Cloudera",
    "Clough Global Dividend and Income Fund",
    "Clough Global Equity Fund",
    "Clough Global Opportunities Fund",
    "Clovis Oncology",
    "Co-Diagnostics",
    "CoStar Group",
    "Coastal Financial Corporation",
    "Coca Cola Femsa S.A.B. de C.V.",
    "Coca-Cola Company (The)",
    "Coca-Cola Consolidated",
    "Coca-Cola European Partners plc",
    "Cocrystal Pharma",
    "Coda Octopus Group",
    "Codexis",
    "Codorus Valley Bancorp",
    "Coeur Mining",
    "Coffee Holding Co.",
    "Cogent Communications Holdings",
    "Cognex Corporation",
    "Cognizant Technology Solutions Corporation",
    "CohBar",
    "Cohen & Company Inc.",
    "Cohen & Steers Closed-End Opportunity Fund",
    "Cohen & Steers Global Income Builder",
    "Cohen & Steers Inc",
    "Cohen & Steers Infrastructure Fund",
    "Cohen & Steers Limited Duration Preferred and Income Fund",
    "Cohen & Steers MLP Income and Energy Opportunity Fund",
    "Cohen & Steers Quality Income Realty Fund Inc",
    "Cohen & Steers REIT and Preferred and Income Fund",
    "Cohen & Steers Select Preferred and Income Fund",
    "Cohen & Steers Total Return Realty Fund",
    "Coherent",
    "Coherus BioSciences",
    "Cohu",
    "Colfax Corporation",
    "Colgate-Palmolive Company",
    "CollPlant Biotechnologies Ltd.",
    "Collectors Universe",
    "Collegium Pharmaceutical",
    "Collier Creek Holdings",
    "Colliers International Group Inc. ",
    "Colonial High Income Municipal Trust",
    "Colonial Intermediate High Income Fund",
    "Colonial Investment Grade Municipal Trust",
    "Colonial Municipal Income Trust",
    "Colony Bankcorp",
    "Colony Capital",
    "Colony Credit Real Estate",
    "Columbia Banking System",
    "Columbia Financial",
    "Columbia Property Trust",
    "Columbia Seligman Premium Technology Growth Fund",
    "Columbia Sportswear Company",
    "Columbus McKinnon Corporation",
    "Comcast Corporation",
    "Comerica Incorporated",
    "Comfort Systems USA",
    "CommScope Holding Company",
    "Commerce Bancshares",
    "Commercial Metals Company",
    "Commercial Vehicle Group",
    "Communications Systems",
    "Community Bank System",
    "Community Bankers Trust Corporation.",
    "Community First Bancshares",
    "Community Health Systems",
    "Community Healthcare Trust Incorporated",
    "Community Trust Bancorp",
    "Community West Bancshares",
    "Commvault Systems",
    "Comp En De Mn Cemig ADS",
    "CompX International Inc.",
    "Companhia Brasileira de Distribuicao",
    "Companhia Paranaense de Energia (COPEL)",
    "Companhia de saneamento Basico Do Estado De Sao Paulo - Sabesp",
    "Compania Cervecerias Unidas",
    "Compass Diversified Holdings",
    "Compass Minerals International",
    "Compugen Ltd.",
    "Computer Programs and Systems",
    "Computer Task Group",
    "Comstock Holding Companies",
    "Comstock Mining",
    "Comstock Resources",
    "Comtech Telecommunications Corp.",
    "ConAgra Brands",
    "Conatus Pharmaceuticals Inc.",
    "Concert Pharmaceuticals",
    "Concho Resources Inc.",
    "Concord Medical Services Holdings Limited",
    "Concrete Pumping Holdings",
    "Condor Hospitality Trust",
    "Conduent Incorporated",
    "ConforMIS",
    "Conifer Holdings",
    "Conn&#39;s",
    "ConnectOne Bancorp",
    "Connecticut Water Service",
    "ConocoPhillips",
    "Consolidated Communications Holdings",
    "Consolidated Edison Inc",
    "Consolidated Water Co. Ltd.",
    "Consolidated-Tomoka Land Co.",
    "Constellation Brands Inc",
    "Constellation Pharmaceuticals",
    "Constellium SE",
    "Construction Partners",
    "Consumer Portfolio Services",
    "Container Store (The)",
    "Contango Oil & Gas Company",
    "Continental Building Products",
    "Continental Materials Corporation",
    "Continental Resources",
    "ContraFect Corporation",
    "Controladora Vuela Compania de Aviacion",
    "Contura Energy",
    "ConversionPoint Holdings",
    "Conyers Park II Acquisition Corp.",
    "CooTek (Cayman) Inc.",
    "Cool Holdings Inc.",
    "Cooper Tire & Rubber Company",
    "Cooper-Standard Holdings Inc.",
    "Copa Holdings",
    "Copart",
    "CorEnergy Infrastructure Trust",
    "CorMedix Inc.",
    "CorVel Corp.",
    "Corbus Pharmaceuticals Holdings",
    "Corcept Therapeutics Incorporated",
    "Core Laboratories N.V.",
    "Core Molding Technologies Inc",
    "Core-Mark Holding Company",
    "CoreCivic",
    "CoreLogic",
    "CorePoint Lodging Inc.",
    "CoreSite Realty Corporation",
    "Corindus Vascular Robotics",
    "Cornerstone Building Brands",
    "Cornerstone OnDemand",
    "Cornerstone Strategic Return Fund",
    "Cornerstone Strategic Value Fund",
    "Corning Incorporated",
    "Corporacion America Airports SA",
    "Corporate Asset Backed Corp CABCO",
    "Corporate Office Properties Trust",
    "Correvio Pharma Corp.",
    "Corteva",
    "Cortexyme",
    "Cortland Bancorp",
    "Corvus Pharmaceuticals",
    "Cosan Limited",
    "Costamare Inc.",
    "Costco Wholesale Corporation",
    "Cott Corporation",
    "Coty Inc.",
    "CounterPath Corporation",
    "County Bancorp",
    "Coupa Software Incorporated",
    "Cousins Properties Incorporated",
    "Covanta Holding Corporation",
    "Covenant Transportation Group",
    "Covetrus",
    "Covia Holdings Corporation",
    "Cowen Inc.",
    "Cracker Barrel Old Country Store",
    "Craft Brew Alliance",
    "Crane Co.",
    "Crawford & Company",
    "Cray Inc",
    "Creative Realities",
    "Credicorp Ltd.",
    "Credit Acceptance Corporation",
    "Credit Suisse AG",
    "Credit Suisse Asset Management Income Fund",
    "Credit Suisse Group",
    "Credit Suisse High Yield Bond Fund",
    "Cree",
    "Crescent Acquisition Corp",
    "Crescent Point Energy Corporation",
    "Crestwood Equity Partners LP",
    "Cresud S.A.C.I.F. y A.",
    "Crinetics Pharmaceuticals",
    "Criteo S.A.",
    "Crocs",
    "Cronos Group Inc.",
    "Cross Country Healthcare",
    "Cross Timbers Royalty Trust",
    "CrossAmerica Partners LP",
    "CrossFirst Bankshares",
    "CrowdStrike Holdings",
    "Crown Castle International Corporation",
    "Crown Crafts",
    "Crown Holdings",
    "CryoLife",
    "CryoPort",
    "Ctrip.com International",
    "CubeSmart",
    "Cubic Corporation",
    "Cue Biopharma",
    "Cullen/Frost Bankers",
    "Culp",
    "Cumberland Pharmaceuticals Inc.",
    "Cummins Inc.",
    "Cumulus Media Inc.",
    "Curis",
    "Curtiss-Wright Corporation",
    "Cushing Energy Income Fund (The)",
    "Cushing MLP & Infrastructure Total Return Fund",
    "Cushing Renaissance Fund (The)",
    "Cushman & Wakefield plc",
    "Customers Bancorp",
    "Cutera",
    "Cyanotech Corporation",
    "CyberArk Software Ltd.",
    "CyberOptics Corporation",
    "Cyclacel Pharmaceuticals",
    "Cyclerion Therapeutics",
    "CymaBay Therapeutics Inc.",
    "CynergisTek",
    "Cypress Energy Partners",
    "Cypress Semiconductor Corporation",
    "CyrusOne Inc",
    "Cytokinetics",
    "CytomX Therapeutics",
    "Cytosorbents Corporation",
    "D.R. Horton",
    "DAQO New Energy Corp.",
    "DASAN Zhone Solutions",
    "DAVIDsTEA Inc.",
    "DBV Technologies S.A.",
    "DCP Midstream LP",
    "DD3 Acquisition Corp.",
    "DENTSPLY SIRONA Inc.",
    "DERMAdoctor",
    "DFB Healthcare Acquisitions Corp.",
    "DGSE Companies",
    "DHI Group",
    "DHT Holdings",
    "DHX Media Ltd.",
    "DISH Network Corporation",
    "DLH Holdings Corp.",
    "DMC Global Inc.",
    "DNB Financial Corp",
    "DPW Holdings",
    "DRDGOLD Limited",
    "DSP Group",
    "DTE Energy Company",
    "DURECT Corporation",
    "DXC Technology Company",
    "DXP Enterprises",
    "DaVita Inc.",
    "Daily Journal Corp. (S.C.)",
    "Daktronics",
    "Dana Incorporated",
    "Danaher Corporation",
    "Danaos Corporation",
    "Darden Restaurants",
    "Dare Bioscience",
    "DarioHealth Corp.",
    "Darling Ingredients Inc.",
    "Daseke",
    "Data I/O Corporation",
    "Datasea Inc.",
    "Dave & Buster&#39;s Entertainment",
    "Davis Select Financial ETF",
    "Davis Select International ETF",
    "Davis Select U.S. Equity ETF",
    "Davis Select Worldwide ETF",
    "Dawson Geophysical Company",
    "Daxor Corporation",
    "Dean Foods Company",
    "Deciphera Pharmaceuticals",
    "Deckers Outdoor Corporation",
    "Deere & Company",
    "Del Frisco&#39;s Restaurant Group",
    "Del Taco Restaurants",
    "DelMar Pharmaceuticals",
    "Delaware Enhanced Global Dividend",
    "Delaware Investments Colorado Municipal Income Fund",
    "Delaware Investments Dividend & Income Fund",
    "Delaware Investments Florida Insured Municipal Income Fund",
    "Delaware Investments Minnesota Municipal Income Fund II",
    "Delek Logistics Partners",
    "Delek US Holdings",
    "Dell Technologies Inc.",
    "Delphi Technologies PLC",
    "Delta Air Lines",
    "Delta Apparel",
    "Deluxe Corporation",
    "Denali Therapeutics Inc.",
    "Denbury Resources Inc.",
    "Denison Mine Corp",
    "Denny&#39;s Corporation",
    "DermTech",
    "Dermavant Sciences Ltd.",
    "Dermira",
    "Designer Brands Inc.",
    "Despegar.com",
    "Destination Maternity Corporation",
    "Destination XL Group",
    "Deswell Industries",
    "Deutsch Bk Contingent Cap Tr V",
    "Deutsche Bank AG",
    "Devon Energy Corporation",
    "DexCom",
    "DiaMedica Therapeutics Inc.",
    "Diageo plc",
    "Diamond Eagle Acquisition Corp.",
    "Diamond Hill Investment Group",
    "Diamond Offshore Drilling",
    "Diamond S Shipping Inc.",
    "DiamondPeak Holdings Corp.",
    "Diamondback Energy",
    "Diamondrock Hospitality Company",
    "Diana Shipping inc.",
    "Dicerna Pharmaceuticals",
    "Dick&#39;s Sporting Goods Inc",
    "Diebold Nixdorf Incorporated",
    "Diffusion Pharmaceuticals Inc.",
    "Digi International Inc.",
    "Digimarc Corporation",
    "Digirad Corporation",
    "Digital Ally",
    "Digital Realty Trust",
    "Digital Turbine",
    "Dillard&#39;s",
    "Dime Community Bancshares",
    "Dine Brands Global",
    "Diodes Incorporated",
    "Diplomat Pharmacy",
    "Discover Financial Services",
    "Discovery",
    "Diversified Restaurant Holdings",
    "Dividend and Income Fund",
    "DocuSign",
    "Document Security Systems",
    "Dogness (International) Corporation",
    "Dolby Laboratories",
    "Dollar General Corporation",
    "Dollar Tree",
    "Dolphin Entertainment",
    "Dominion Energy",
    "Domino&#39;s Pizza Inc",
    "Domo",
    "Domtar Corporation",
    "Donaldson Company",
    "Donegal Group",
    "Donnelley Financial Solutions",
    "Dorchester Minerals",
    "Dorian LPG Ltd.",
    "Dorman Products",
    "DouYu International Holdings Limited",
    "DoubleLine Income Solutions Fund",
    "DoubleLine Opportunistic Credit Fund",
    "Douglas Dynamics",
    "Douglas Emmett",
    "Dova Pharmaceuticals",
    "Dover Corporation",
    "Dover Motorsports",
    "Dow Inc.",
    "Dr. Reddy&#39;s Laboratories Ltd",
    "Dragon Victory International Limited",
    "Dril-Quip",
    "Drive Shack Inc.",
    "DropCar",
    "Dropbox",
    "DryShips Inc.",
    "DuPont de Nemours",
    "Ducommun Incorporated",
    "Duff & Phelps Global Utility Income Fund Inc.",
    "Duff & Phelps Select MLP and Midstream Energy Fund",
    "Duff & Phelps Utilities Income",
    "Duff & Phelps Utilities Tax-Free Income",
    "Duff & Phelps Utility & Corporate Bond Trust",
    "Duke Energy Corporation",
    "Duke Realty Corporation",
    "Duluth Holdings Inc.",
    "Dunkin&#39; Brands Group",
    "Dunxin Financial Holdings Limited",
    "Dyadic International",
    "Dycom Industries",
    "Dynagas LNG Partners LP",
    "Dynatrace",
    "Dynatronics Corporation",
    "Dynavax Technologies Corporation",
    "Dynex Capital",
    "E*TRADE Financial Corporation",
    "E.I. du Pont de Nemours and Company",
    "E.W. Scripps Company (The)",
    "ECA Marcellus Trust I",
    "EDAP TMS S.A.",
    "EMC Insurance Group Inc.",
    "EMCOR Group",
    "EMCORE Corporation",
    "EMX Royalty Corporation",
    "ENDRA Life Sciences Inc.",
    "ENGlobal Corporation",
    "ENI S.p.A.",
    "ENSERVCO Corporation",
    "EOG Resources",
    "EPAM Systems",
    "EPR Properties",
    "EQM Midstream Partners",
    "EQT Corporation",
    "ESCO Technologies Inc.",
    "ESSA Bancorp",
    "ESSA Pharma Inc.",
    "ETF Series Solutions Trust Vident Core U.S. Bond Strategy Fund",
    "ETF Series Solutions Trust Vident Core US Equity ETF",
    "ETF Series Solutions Trust Vident International Equity Fund",
    "EVI Industries",
    "EVO Payments",
    "EXFO Inc",
    "EZCORP",
    "Eagle Bancorp",
    "Eagle Bancorp Montana",
    "Eagle Bulk Shipping Inc.",
    "Eagle Capital Growth Fund",
    "Eagle Financial Bancorp",
    "Eagle Growth and Income Opportunities Fund",
    "Eagle Materials Inc",
    "Eagle Pharmaceuticals",
    "Eagle Point Credit Company Inc.",
    "Eagle Point Income Company Inc.",
    "Eagleline Acquisition Corp.",
    "Earthstone Energy",
    "East West Bancorp",
    "EastGroup Properties",
    "Easterly Government Properties",
    "Eastern Company (The)",
    "Eastman Chemical Company",
    "Eastman Kodak Company",
    "Eastside Distilling",
    "Eaton Corporation",
    "Eaton Vance California Municipal Bond Fund",
    "Eaton Vance California Municipal Income Trust",
    "Eaton Vance Corporation",
    "Eaton Vance Enhance Equity Income Fund",
    "Eaton Vance Enhanced Equity Income Fund II",
    "Eaton Vance Floating Rate Income Trust",
    "Eaton Vance Floating-Rate 2022 Target Term Trust",
    "Eaton Vance High Income 2021 Target Term Trust",
    "Eaton Vance Limited Duration Income Fund",
    "Eaton Vance Municipal Bond Fund",
    "Eaton Vance Municipal Income 2028 Term Trust",
    "Eaton Vance Municipal Income Trust",
    "Eaton Vance New York Municipal Bond Fund",
    "Eaton Vance New York Municipal Income Trust",
    "Eaton Vance NextShares Trust",
    "Eaton Vance NextShares Trust II",
    "Eaton Vance Risk-Managed Diversified Equity Income Fund",
    "Eaton Vance Senior Floating-Rate Fund",
    "Eaton Vance Senior Income Trust",
    "Eaton Vance Short Diversified Income Fund",
    "Eaton Vance Tax Advantaged Dividend Income Fund",
    "Eaton Vance Tax-Advantage Global Dividend Opp",
    "Eaton Vance Tax-Advantaged Global Dividend Income Fund",
    "Eaton Vance Tax-Managed Buy-Write Income Fund",
    "Eaton Vance Tax-Managed Buy-Write Strategy Fund",
    "Eaton Vance Tax-Managed Diversified Equity Income Fund",
    "Eaton Vance Tax-Managed Global Diversified Equity Income Fund",
    "Eaton vance Floating-Rate Income Plus Fund",
    "Ebix",
    "Echo Global Logistics",
    "EchoStar Corporation",
    "Ecolab Inc.",
    "Ecology and Environment",
    "Ecopetrol S.A.",
    "Edesa Biotech",
    "Edison International",
    "Edison Nation",
    "Editas Medicine",
    "EdtechX Holdings Acquisition Corp.",
    "Educational Development Corporation",
    "Edwards Lifesciences Corporation",
    "Eidos Therapeutics",
    "Eiger BioPharmaceuticals",
    "Ekso Bionics Holdings",
    "El Paso Corporation",
    "El Paso Electric Company",
    "El Pollo Loco Holdings",
    "Elanco Animal Health Incorporated",
    "Elastic N.V.",
    "Elbit Systems Ltd.",
    "Eldorado Gold Corporation",
    "Eldorado Resorts",
    "Electrameccanica Vehicles Corp. Ltd.",
    "Electro-Sensors",
    "Electromed",
    "Electronic Arts Inc.",
    "Element Solutions Inc.",
    "Elevate Credit",
    "Eli Lilly and Company",
    "Ellington Financial Inc.",
    "Ellington Residential Mortgage REIT",
    "Ellomay Capital Ltd.",
    "Ellsworth Growth and Income Fund Ltd.",
    "Elmira Savings Bank NY (The)",
    "Eloxx Pharmaceuticals",
    "Eltek Ltd.",
    "Embotelladora Andina S.A.",
    "Embraer S.A.",
    "Emclaire Financial Corp",
    "Emerald Expositions Events",
    "Emergent Biosolutions",
    "Emerson Electric Company",
    "Emerson Radio Corporation",
    "Emmis Communications Corporation",
    "Empire Resorts",
    "Empire State Realty Trust",
    "Employers Holdings Inc",
    "Empresa Distribuidora Y Comercializadora Norte S.A. (Edenor)",
    "EnLink Midstream",
    "EnPro Industries",
    "Enable Midstream Partners",
    "Enanta Pharmaceuticals",
    "Enbridge Inc",
    "Encana Corporation",
    "Encompass Health Corporation",
    "Encore Capital Group Inc",
    "Encore Wire Corporation",
    "Endava plc",
    "Endeavour Silver Corporation",
    "Endo International plc",
    "Endologix",
    "Endurance International Group Holdings",
    "Enel Americas S.A.",
    "Enel Chile S.A.",
    "Energizer Holdings",
    "Energous Corporation",
    "Energy Focus",
    "Energy Fuels Inc",
    "Energy Hunter Resources",
    "Energy Recovery",
    "Energy Transfer L.P.",
    "Energy Transfer Operating",
    "Enerplus Corporation",
    "Enersys",
    "Enlivex Therapeutics Ltd.",
    "Ennis",
    "Enochian Biosciences",
    "Enova International",
    "Enphase Energy",
    "Enstar Group Limited",
    "Entasis Therapeutics Holdings Inc.",
    "Entegra Financial Corp.",
    "Entegris",
    "Entera Bio Ltd.",
    "Entercom Communications Corp.",
    "Entergy Arkansas",
    "Entergy Corporation",
    "Entergy Louisiana",
    "Entergy Mississippi",
    "Entergy New Orleans",
    "Entergy Texas Inc",
    "Enterprise Bancorp Inc",
    "Enterprise Financial Services Corporation",
    "Enterprise Products Partners L.P.",
    "Entravision Communications Corporation",
    "Entree Resources Ltd.",
    "Envestnet",
    "Envision Solar International",
    "Enviva Partners",
    "Enzo Biochem",
    "Epizyme",
    "Epsilon Energy Ltd.",
    "Equifax",
    "Equillium",
    "Equinix",
    "Equinor ASA",
    "Equitrans Midstream Corporation",
    "Equity Bancshares",
    "Equity Commonwealth",
    "Equity Lifestyle Properties",
    "Equity Residential",
    "Equus Total Return",
    "Era Group",
    "Ericsson",
    "Erie Indemnity Company",
    "Eros International PLC",
    "Erytech Pharma S.A.",
    "Escalade",
    "Esperion Therapeutics",
    "Espey Mfg. & Electronics Corp.",
    "Esquire Financial Holdings",
    "Essent Group Ltd.",
    "Essential Properties Realty Trust",
    "Essex Property Trust",
    "Establishment Labs Holdings Inc.",
    "Estee Lauder Companies",
    "Estre Ambiental",
    "Ethan Allen Interiors Inc.",
    "Eton Pharmaceuticals",
    "Etsy",
    "Euro Tech Holdings Company Limited",
    "EuroDry Ltd.",
    "Euronav NV",
    "Euronet Worldwide",
    "European Equity Fund",
    "Euroseas Ltd.",
    "Evans Bancorp",
    "Evelo Biosciences",
    "Eventbrite",
    "Ever-Glory International Group",
    "EverQuote",
    "Everbridge",
    "Evercore Inc.",
    "Everest Re Group",
    "Evergy",
    "Everi Holdings Inc.",
    "Eversource Energy",
    "Everspin Technologies",
    "Evertec",
    "Evofem Biosciences",
    "Evogene Ltd.",
    "Evoke Pharma",
    "Evolent Health",
    "Evolus",
    "Evolution Petroleum Corporation",
    "Evolving Systems",
    "Evoqua Water Technologies Corp.",
    "Exact Sciences Corporation",
    "Exantas Capital Corp.",
    "Exchange Traded Concepts Trust FLAG-Forensic Accounting Long-S",
    "Exchange Traded Concepts Trust ROBO Global Robotics and Automa",
    "Exela Technologies",
    "Exelixis",
    "Exelon Corporation",
    "Exicure",
    "ExlService Holdings",
    "Expedia Group",
    "Expeditors International of Washington",
    "Experience Investment Corp.",
    "Exponent",
    "Express",
    "Extended Stay America",
    "Exterran Corporation",
    "Extra Space Storage Inc",
    "Extraction Oil & Gas",
    "Extreme Networks",
    "Exxon Mobil Corporation",
    "EyePoint Pharmaceuticals",
    "Eyegate Pharmaceuticals",
    "Eyenovia",
    "F.N.B. Corporation",
    "F5 Networks",
    "FARMMI",
    "FARO Technologies",
    "FAT Brands Inc.",
    "FB Financial Corporation",
    "FBL Financial Group",
    "FFBW",
    "FGL Holdings",
    "FIRST REPUBLIC BANK",
    "FLEX LNG Ltd.",
    "FLIR Systems",
    "FMC Corporation",
    "FNCB Bancorp Inc.",
    "FRONTEO",
    "FRP Holdings",
    "FS Bancorp",
    "FS KKR Capital Corp.",
    "FSB Bancorp",
    "FTE Networks",
    "FTI Consulting",
    "FTS International",
    "FVCBankcorp",
    "Fabrinet",
    "Facebook",
    "FactSet Research Systems Inc.",
    "Fair Isaac Corporation",
    "Falcon Minerals Corporation",
    "Famous Dave&#39;s of America",
    "Fang Holdings Limited",
    "Fanhua Inc.",
    "Far Point Acquisition Corporation",
    "Farfetch Limited",
    "Farmer Brothers Company",
    "Farmers & Merchants Bancorp",
    "Farmers National Banc Corp.",
    "Farmland Partners Inc.",
    "Fastenal Company",
    "Fastly",
    "Fate Therapeutics",
    "Fauquier Bankshares",
    "FedEx Corporation",
    "FedNat Holding Company",
    "Federal Agricultural Mortgage Corporation",
    "Federal Realty Investment Trust",
    "Federal Signal Corporation",
    "Federated Investors",
    "Federated Premier Municipal Income Fund",
    "Fellazo Inc.",
    "Fennec Pharmaceuticals Inc.",
    "Ferrari N.V.",
    "Ferrellgas Partners",
    "Ferro Corporation",
    "Ferroglobe PLC",
    "Fiat Chrysler Automobiles N.V.",
    "FibroGen",
    "Fibrocell Science Inc.",
    "Fidelity D & D Bancorp",
    "Fidelity Nasdaq Composite Index Tracking Stock",
    "Fidelity National Financial",
    "Fidelity National Information Services",
    "Fiduciary/Claymore Energy Infrastructure Fund",
    "Fidus Investment Corporation",
    "Fiesta Restaurant Group",
    "Fifth Third Bancorp",
    "FinTech Acquisition Corp. III",
    "Financial Institutions",
    "Finisar Corporation",
    "Finjan Holdings",
    "FireEye",
    "First American Corporation (The)",
    "First BanCorp.",
    "First Bancorp",
    "First Bank",
    "First Busey Corporation",
    "First Business Financial Services",
    "First Capital",
    "First Choice Bancorp",
    "First Citizens BancShares",
    "First Commonwealth Financial Corporation",
    "First Community Bankshares",
    "First Community Corporation",
    "First Defiance Financial Corp.",
    "First Financial Bancorp.",
    "First Financial Bankshares",
    "First Financial Corporation Indiana",
    "First Financial Northwest",
    "First Foundation Inc.",
    "First Guaranty Bancshares",
    "First Hawaiian",
    "First Horizon National Corporation",
    "First Industrial Realty Trust",
    "First Internet Bancorp",
    "First Interstate BancSystem",
    "First Majestic Silver Corp.",
    "First Merchants Corporation",
    "First Mid Bancshares",
    "First Midwest Bancorp",
    "First National Corporation",
    "First Northwest Bancorp",
    "First Savings Financial Group",
    "First Seacoast Bancorp",
    "First Solar",
    "First Trust",
    "First Trust Alternative Absolute Return Strategy ETF",
    "First Trust Asia Pacific Ex-Japan AlphaDEX Fund",
    "First Trust BICK Index Fund",
    "First Trust Brazil AlphaDEX Fund",
    "First Trust BuyWrite Income ETF",
    "First Trust CEF Income Opportunity ETF",
    "First Trust California Municipal High income ETF",
    "First Trust Canada AlphaDEX Fund",
    "First Trust Capital Strength ETF",
    "First Trust China AlphaDEX Fund",
    "First Trust Cloud Computing ETF",
    "First Trust Developed International Equity Select ETF",
    "First Trust Developed Markets Ex-US AlphaDEX Fund",
    "First Trust Developed Markets ex-US Small Cap AlphaDEX Fund",
    "First Trust Dorsey Wright Dynamic Focus 5 ETF",
    "First Trust Dorsey Wright Focus 5 ETF",
    "First Trust Dorsey Wright International Focus 5 ETF",
    "First Trust Dorsey Wright Momentum & Dividend ETF",
    "First Trust Dorsey Wright Momentum & Low Volatility ETF",
    "First Trust Dorsey Wright Momentum & Value ETF",
    "First Trust Dorsey Wright People&#39;s Portfolio ETF",
    "First Trust DorseyWright DALI 1 ETF",
    "First Trust Dow Jones International Internet ETF",
    "First Trust Dynamic Europe Equity Income Fund",
    "First Trust Emerging Markets AlphaDEX Fund",
    "First Trust Emerging Markets Equity Select ETF",
    "First Trust Emerging Markets Local Currency Bond ETF",
    "First Trust Emerging Markets Small Cap AlphaDEX Fund",
    "First Trust Energy Income and Growth Fund",
    "First Trust Energy Infrastructure Fund",
    "First Trust Enhanced Short Maturity ETF",
    "First Trust Europe AlphaDEX Fund",
    "First Trust Eurozone AlphaDEX ETF",
    "First Trust Germany AlphaDEX Fund",
    "First Trust Global Tactical Commodity Strategy Fund",
    "First Trust Hedged BuyWrite Income ETF",
    "First Trust High Income Long Short Fund",
    "First Trust High Yield Long/Short ETF",
    "First Trust Hong Kong AlphaDEX Fund",
    "First Trust IPOX Europe Equity Opportunities ETF",
    "First Trust India Nifty 50 Equal Weight ETF",
    "First Trust Indxx Global Agriculture ETF",
    "First Trust Indxx Global Natural Resources Income ETF",
    "First Trust Indxx Innovative Transaction & Process ETF",
    "First Trust Indxx NextG ETF",
    "First Trust Intermediate Duration Preferred & Income Fund",
    "First Trust International Equity Opportunities ETF",
    "First Trust Japan AlphaDEX Fund",
    "First Trust Large Cap Core AlphaDEX Fund",
    "First Trust Large Cap Growth AlphaDEX Fund",
    "First Trust Large Cap US Equity Select ETF",
    "First Trust Large Cap Value AlphaDEX Fund",
    "First Trust Latin America AlphaDEX Fund",
    "First Trust Low Duration Opportunities ETF",
    "First Trust Low Duration Strategic Focus ETF",
    "First Trust MLP and Energy Income Fund",
    "First Trust Managed Municipal ETF",
    "First Trust Mega Cap AlphaDEX Fund",
    "First Trust Mid Cap Core AlphaDEX Fund",
    "First Trust Mid Cap Growth AlphaDEX Fund",
    "First Trust Mid Cap US Equity Select ETF",
    "First Trust Mid Cap Value AlphaDEX Fund",
    "First Trust Multi Cap Growth AlphaDEX Fund",
    "First Trust Multi Cap Value AlphaDEX Fund",
    "First Trust Multi-Asset Diversified Income Index Fund",
    "First Trust Municipal CEF Income Opportunity ETF",
    "First Trust Municipal High Income ETF",
    "First Trust NASDAQ ABA Community Bank Index Fund",
    "First Trust NASDAQ Clean Edge Green Energy Index Fund",
    "First Trust NASDAQ Clean Edge Smart Grid Infrastructure Index ",
    "First Trust NASDAQ Cybersecurity ETF",
    "First Trust NASDAQ Global Auto Index Fund",
    "First Trust NASDAQ Technology Dividend Index Fund",
    "First Trust NASDAQ-100 Equal Weighted Index Fund",
    "First Trust NASDAQ-100 Ex-Technology Sector Index Fund",
    "First Trust NASDAQ-100- Technology Index Fund",
    "First Trust Nasdaq Artificial Intelligence and Robotics ETF",
    "First Trust Nasdaq Bank ETF",
    "First Trust Nasdaq Food & Beverage ETF",
    "First Trust Nasdaq Oil & Gas ETF",
    "First Trust Nasdaq Pharmaceuticals ETF",
    "First Trust Nasdaq Retail ETF",
    "First Trust Nasdaq Semiconductor ETF",
    "First Trust Nasdaq Transportation ETF",
    "First Trust New Opportunities MLP & Energy Fund",
    "First Trust RBA American Industrial Renaissance ETF",
    "First Trust Rising Dividend Achievers ETF",
    "First Trust RiverFront Dynamic Asia Pacific ETF",
    "First Trust RiverFront Dynamic Developed International ETF",
    "First Trust RiverFront Dynamic Emerging Markets ETF",
    "First Trust RiverFront Dynamic Europe ETF",
    "First Trust S&P International Dividend Aristocrats ETF",
    "First Trust SMID Cap Rising Dividend Achievers ETF",
    "First Trust SSI Strategic Convertible Securities ETF",
    "First Trust Senior Floating Rate 2022 Target Term Fund",
    "First Trust Senior Floating Rate Income Fund II",
    "First Trust Senior Loan Fund ETF",
    "First Trust Small Cap Core AlphaDEX Fund",
    "First Trust Small Cap Growth AlphaDEX Fund",
    "First Trust Small Cap US Equity Select ETF",
    "First Trust Small Cap Value AlphaDEX Fund",
    "First Trust South Korea AlphaDEX Fund",
    "First Trust Specialty Finance and Financial Opportunities Fund",
    "First Trust Strategic Income ETF",
    "First Trust Switzerland AlphaDEX Fund",
    "First Trust TCW Opportunistic Fixed Income ETF",
    "First Trust Total US Market AlphaDEX ETF",
    "First Trust US Equity Dividend Select ETF",
    "First Trust United Kingdom AlphaDEX Fund",
    "First Trust/Aberdeen Emerging Opportunity Fund",
    "First Trust/Aberdeen Global Opportunity Income Fund",
    "First US Bancshares",
    "First United Corporation",
    "First Western Financial",
    "FirstCash",
    "FirstEnergy Corp.",
    "FirstService Corporation",
    "Firsthand Technology Value Fund",
    "Fiserv",
    "Fitbit",
    "Five Below",
    "Five Point Holdings",
    "Five Prime Therapeutics",
    "Five Star Senior Living Inc.",
    "Five9",
    "Fiverr International Ltd.",
    "Flagstar Bancorp",
    "Flaherty & Crumrine Dynamic Preferred and Income Fund Inc.",
    "Flaherty & Crumrine Preferred and Income Fund Inco",
    "Flaherty & Crumrine Preferred and Income Opportuni",
    "Flaherty & Crumrine Preferred and Income Securitie",
    "Flaherty & Crumrine Total Return Fund Inc",
    "Flanigan&#39;s Enterprises",
    "FleetCor Technologies",
    "Flex Ltd.",
    "FlexShares Credit-Scored US Corporate Bond Index Fund",
    "FlexShares Credit-Scored US Long Corporate Bond Index Fund",
    "FlexShares Disciplined Duration MBS Index Fund",
    "FlexShares Real Assets Allocation Index Fund",
    "FlexShares STOXX Global ESG Impact Index Fund",
    "FlexShares STOXX US ESG Impact Index Fund",
    "FlexShares US Quality Large Cap Index Fund",
    "FlexShopper",
    "Flexible Solutions International Inc.",
    "Flexion Therapeutics",
    "Flexsteel Industries",
    "Floor & Decor Holdings",
    "Flotek Industries",
    "Flowers Foods",
    "Flowr Corporation (The)",
    "Flowserve Corporation",
    "Fluent",
    "Fluidigm Corporation",
    "Fluor Corporation",
    "Flushing Financial Corporation",
    "Flux Power Holdings",
    "Fly Leasing Limited",
    "Foamix Pharmaceuticals Ltd.",
    "Focus Financial Partners Inc.",
    "Fomento Economico Mexicano S.A.B. de C.V.",
    "Fonar Corporation",
    "Foot Locker",
    "Ford Motor Company",
    "ForeScout Technologies",
    "Foresight Autonomous Holdings Ltd.",
    "Foresight Energy LP",
    "Forestar Group Inc",
    "FormFactor",
    "Formula Systems (1985) Ltd.",
    "Forrester Research",
    "Forterra",
    "Fortinet",
    "Fortis Inc.",
    "Fortive Corporation",
    "Fortress Biotech",
    "Fortress Transportation and Infrastructure Investors LLC",
    "Fortuna Silver Mines Inc.",
    "Fortune Brands Home & Security",
    "Forty Seven",
    "Forum Energy Technologies",
    "Forum Merger II Corporation",
    "Forward Air Corporation",
    "Forward Industries",
    "Forward Pharma A/S",
    "Fossil Group",
    "Foundation Building Materials",
    "Four Corners Property Trust",
    "Four Seasons Education (Cayman) Inc.",
    "Fox Corporation",
    "Fox Factory Holding Corp.",
    "Francesca&#39;s Holdings Corporation",
    "Franco-Nevada Corporation",
    "Frank&#39;s International N.V.",
    "Franklin Covey Company",
    "Franklin Electric Co.",
    "Franklin Financial Network",
    "Franklin Financial Services Corporation",
    "Franklin Limited Duration Income Trust",
    "Franklin Resources",
    "Franklin Street Properties Corp.",
    "Franklin Universal Trust",
    "Frankly",
    "Fred&#39;s",
    "Freeport-McMoran",
    "Freightcar America",
    "Frequency Electronics",
    "Fresenius Medical Care Corporation",
    "Fresh Del Monte Produce",
    "Freshpet",
    "Friedman Industries Inc.",
    "Front Yard Residential Corporation",
    "Frontier Communications Corporation",
    "Frontline Ltd.",
    "Fuel Tech",
    "FuelCell Energy",
    "Fulcrum Therapeutics",
    "Fulgent Genetics",
    "Fuling Global Inc.",
    "Full House Resorts",
    "Full Spectrum Inc.",
    "Fulton Financial Corporation",
    "Funko",
    "Futu Holdings Limited",
    "Future FinTech Group Inc.",
    "FutureFuel Corp.",
    "Fuwei Films (Holdings) Co.",
    "G-III Apparel Group",
    "G. Willi-Food International",
    "G1 Therapeutics",
    "GAIN Capital Holdings",
    "GAMCO Global Gold",
    "GAMCO Natural Resources",
    "GATX Corporation",
    "GCI Liberty",
    "GCP Applied Technologies Inc.",
    "GDS Holdings Limited",
    "GEE Group Inc.",
    "GENFIT S.A.",
    "GMS Inc.",
    "GNC Holdings",
    "GOLDEN BULL LIMITED",
    "GP Strategies Corporation",
    "GRAVITY Co.",
    "GS Acquisition Holdings Corp.",
    "GSE Systems",
    "GSI Technology",
    "GSX Techedu Inc.",
    "GTT Communications",
    "GTY Technology Holdings",
    "GW Pharmaceuticals Plc",
    "GWG Holdings",
    "GX Acquisiton Corp.",
    "Gabelli Convertible and Income Securities Fund",
    "Gabelli Equity Trust",
    "Gabelli Global Small and Mid Cap Value Trust (The)",
    "Gabelli Multi-Media Trust Inc. (The)",
    "Gabelli Utility Trust (The)",
    "Gaia",
    "Galapagos NV",
    "Galectin Therapeutics Inc.",
    "Galmed Pharmaceuticals Ltd.",
    "Gamco Investors",
    "Gamestop Corporation",
    "Gamida Cell Ltd.",
    "Gaming and Leisure Properties",
    "Gap",
    "Gardner Denver Holdings",
    "Garmin Ltd.",
    "Garrett Motion Inc.",
    "Garrison Capital Inc.",
    "Gartner",
    "GasLog LP.",
    "GasLog Partners LP",
    "Gates Industrial Corporation plc",
    "Gemphire Therapeutics Inc.",
    "GenMark Diagnostics",
    "GenSight Biologics S.A.",
    "Genco Shipping & Trading Limited ",
    "Gencor Industries Inc.",
    "Generac Holdlings Inc.",
    "General American Investors",
    "General Dynamics Corporation",
    "General Electric Company",
    "General Finance Corporation",
    "General Mills",
    "General Moly",
    "General Motors Company",
    "Genesco Inc.",
    "Genesee & Wyoming",
    "Genesis Energy",
    "Genesis Healthcare",
    "Genetic Technologies Ltd",
    "Genie Energy Ltd.",
    "Genius Brands International",
    "Genmab A/S",
    "Genocea Biosciences",
    "Genomic Health",
    "Genpact Limited",
    "Genprex",
    "Gentex Corporation",
    "Gentherm Inc",
    "Genuine Parts Company",
    "Genworth Financial Inc",
    "Geo Group Inc (The)",
    "Geopark Ltd",
    "Georgia Power Company",
    "Geospace Technologies Corporation",
    "Gerdau S.A.",
    "German American Bancorp",
    "Geron Corporation",
    "Getty Realty Corporation",
    "Gevo",
    "Gibraltar Industries",
    "GigCapital",
    "GigCapital2",
    "GigaMedia Limited",
    "Gilat Satellite Networks Ltd.",
    "Gildan Activewear",
    "Gilead Sciences",
    "Glacier Bancorp",
    "Gladstone Capital Corporation",
    "Gladstone Commercial Corporation",
    "Gladstone Investment Corporation",
    "Gladstone Land Corporation",
    "Glatfelter",
    "Glaukos Corporation",
    "GlaxoSmithKline PLC",
    "Glen Burnie Bancorp",
    "Global Blood Therapeutics",
    "Global Cord Blood Corporation",
    "Global Eagle Entertainment Inc.",
    "Global Indemnity Limited",
    "Global Medical REIT Inc.",
    "Global Net Lease",
    "Global Partners LP",
    "Global Payments Inc.",
    "Global Self Storage",
    "Global Ship Lease",
    "Global Water Resources",
    "Global X Autonomous & Electric Vehicles ETF",
    "Global X Cloud Computing ETF",
    "Global X Conscious Companies ETF",
    "Global X DAX Germany ETF",
    "Global X E-commerce ETF",
    "Global X FinTech ETF",
    "Global X Funds Global X MSCI China Communication Services ETF",
    "Global X Future Analytics Tech ETF",
    "Global X Genomics & Biotechnology ETF",
    "Global X Health & Wellness Thematic ETF",
    "Global X Internet of Things ETF",
    "Global X Longevity Thematic ETF",
    "Global X MSCI SuperDividend EAFE ETF",
    "Global X Millennials Thematic ETF",
    "Global X NASDAQ-100 Covered Call ETF",
    "Global X Robotics & Artificial Intelligence ETF",
    "Global X S&P 500 Catholic Values ETF",
    "Global X Social Media ETF",
    "Global X SuperDividend Alternatives ETF",
    "Global X SuperDividend REIT ETF",
    "Global X YieldCo & Renewable Energy Income ETF",
    "GlobalSCAPE",
    "Globalstar",
    "Globant S.A.",
    "Globe Life Inc.",
    "Globus Maritime Limited",
    "Globus Medical",
    "Glowpoint",
    "Glu Mobile Inc.",
    "GlycoMimetics",
    "GoDaddy Inc.",
    "GoPro",
    "Gogo Inc.",
    "Gol Linhas Aereas Inteligentes S.A.",
    "Golar LNG Limited",
    "Golar LNG Partners LP",
    "Gold Fields Limited",
    "Gold Resource Corporation",
    "Gold Standard Ventures Corporation",
    "Golden Entertainment",
    "Golden Minerals Company",
    "Golden Ocean Group Limited",
    "Golden Star Resources",
    "Goldfield Corporation (The)",
    "Goldman Sachs BDC",
    "Goldman Sachs Group",
    "Goldman Sachs MLP Energy Renaissance Fund",
    "Goldman Sachs MLP Income Opportunities Fund",
    "Golub Capital BDC",
    "Good Times Restaurants Inc.",
    "GoodBulk Ltd.",
    "Goodrich Petroleum Corporation",
    "Goosehead Insurance",
    "Gordon Pointe Acquisition Corp.",
    "Gores Holdings III",
    "Gores Metropoulos",
    "Gorman-Rupp Company (The)",
    "Gossamer Bio",
    "Graco Inc.",
    "Graf Industrial Corp.",
    "GrafTech International Ltd.",
    "Graham Corporation",
    "Graham Holdings Company",
    "Gran Tierra Energy Inc.",
    "Grana y Montero S.A.A.",
    "Grand Canyon Education",
    "Granite Construction Incorporated",
    "Granite Point Mortgage Trust Inc.",
    "Granite Real Estate Inc.",
    "Graphic Packaging Holding Company",
    "Gray Television",
    "Great Ajax Corp.",
    "Great Elm Capital Corp.",
    "Great Elm Capital Group",
    "Great Lakes Dredge & Dock Corporation",
    "Great Panther Mining Limited",
    "Great Southern Bancorp",
    "Great Western Bancorp",
    "Green Brick Partners",
    "Green Dot Corporation",
    "Green Plains",
    "Green Plains Partners LP",
    "GreenSky",
    "GreenTree Hospitality Group Ltd.",
    "Greenbrier Companies",
    "Greene County Bancorp",
    "Greenhill & Co.",
    "Greenland Acquisition Corporation",
    "Greenlane Holdings",
    "Greenlight Reinsurance",
    "Greenpro Capital Corp.",
    "Greif Bros. Corporation",
    "Gridsum Holding Inc.",
    "Griffin Industrial Realty",
    "Griffon Corporation",
    "Grifols",
    "Grindrod Shipping Holdings Ltd.",
    "Gritstone Oncology",
    "Grocery Outlet Holding Corp.",
    "Group 1 Automotive",
    "Groupon",
    "GrubHub Inc.",
    "Grupo Aeroportuario Del Pacifico",
    "Grupo Aeroportuario del Centro Norte S.A.B. de C.V.",
    "Grupo Aeroportuario del Sureste",
    "Grupo Aval Acciones y Valores S.A.",
    "Grupo Financiero Galicia S.A.",
    "Grupo Simec",
    "Grupo Supervielle S.A.",
    "Grupo Televisa S.A.",
    "Guangshen Railway Company Limited",
    "Guaranty Bancshares",
    "Guaranty Federal Bancshares",
    "Guardant Health",
    "Guardion Health Sciences",
    "Guess?",
    "Guggenheim Credit Allocation Fund",
    "Guggenheim Enhanced Equity Income Fund",
    "Guggenheim Strategic Opportunities Fund",
    "Guggenheim Taxable Municipal Managed Duration Trst",
    "Guidewire Software",
    "Gulf Island Fabrication",
    "Gulf Resources",
    "Gulfport Energy Corporation",
    "Gyrodyne",
    "H&E Equipment Services",
    "H&R Block",
    "H. B. Fuller Company",
    "HC2 Holdings",
    "HCA Healthcare",
    "HCI Group",
    "HCP",
    "HD Supply Holdings",
    "HDFC Bank Limited",
    "HEXO Corp.",
    "HF Foods Group Inc.",
    "HL Acquisitions Corp.",
    "HMG/Courtland Properties",
    "HMN Financial",
    "HMS Holdings Corp",
    "HNI Corporation",
    "HOOKIPA Pharma Inc.",
    "HP Inc.",
    "HSBC Holdings plc",
    "HTG Molecular Diagnostics",
    "HUYA Inc.",
    "HV Bancorp",
    "Haemonetics Corporation",
    "Hailiang Education Group Inc.",
    "Hallador Energy Company",
    "Halliburton Company",
    "Hallmark Financial Services",
    "Halozyme Therapeutics",
    "Hamilton Beach Brands Holding Company",
    "Hamilton Lane Incorporated",
    "Hancock Jaffe Laboratories",
    "Hancock Whitney Corporation",
    "Hanesbrands Inc.",
    "Hanger",
    "Hanmi Financial Corporation",
    "Hannon Armstrong Sustainable Infrastructure Capital",
    "HarborOne Bancorp",
    "Harley-Davidson",
    "Harmonic Inc.",
    "Harmony Gold Mining Company Limited",
    "Harpoon Therapeutics",
    "Harrow Health",
    "Harsco Corporation",
    "Harte-Hanks",
    "Hartford Financial Services Group",
    "Harvard Bioscience",
    "Harvest Capital Credit Corporation",
    "Hasbro",
    "Haverty Furniture Companies",
    "Hawaiian Electric Industries",
    "Hawaiian Holdings",
    "Hawkins",
    "Hawthorn Bancshares",
    "Haymaker Acquisition Corp. II",
    "Haynes International",
    "HeadHunter Group PLC",
    "Health Catalyst",
    "Health Insurance Innovations",
    "Health Sciences Acquisitions Corporation",
    "HealthEquity",
    "HealthStream",
    "Healthcare Realty Trust Incorporated",
    "Healthcare Services Group",
    "Healthcare Trust of America",
    "Heartland Express",
    "Heartland Financial USA",
    "Heat Biologics",
    "Hebron Technology Co.",
    "Hecla Mining Company",
    "Heico Corporation",
    "Heidrick & Struggles International",
    "Helen of Troy Limited",
    "Helios Technologies",
    "Helius Medical Technologies",
    "Helix Energy Solutions Group",
    "Helmerich & Payne",
    "Hemisphere Media Group",
    "Hemispherx BioPharma",
    "Hennessy Advisors",
    "Hennessy Capital Acquisition Corp. IV",
    "Henry Schein",
    "Hepion Pharmaceuticals",
    "Herbalife Nutrition Ltd.",
    "Herc Holdings Inc.",
    "Hercules Capital",
    "Heritage Commerce Corp",
    "Heritage Financial Corporation",
    "Heritage Insurance Holdings",
    "Heritage-Crystal Clean",
    "Herman Miller",
    "Hermitage Offshore Services Ltd.",
    "Heron Therapeutics",
    "Hersha Hospitality Trust",
    "Hershey Company (The)",
    "Hertz Global Holdings",
    "Heska Corporation",
    "Hess Corporation",
    "Hess Midstream Partners LP",
    "Hewlett Packard Enterprise Company",
    "Hexcel Corporation",
    "Hexindai Inc.",
    "Hi-Crush Inc.",
    "Hibbett Sports",
    "High Income Securities Fund",
    "HighPoint Resources Corporation",
    "Highland Global Allocation Fund",
    "Highland Income Fund",
    "Highland/iBoxx Senior Loan ETF",
    "Highpower International Inc",
    "Highway Holdings Limited",
    "Highwoods Properties",
    "Hill International",
    "Hill-Rom Holdings Inc",
    "Hillenbrand Inc",
    "Hillman Group Capital Trust",
    "Hilltop Holdings Inc.",
    "Hilton Grand Vacations Inc.",
    "Hilton Worldwide Holdings Inc.",
    "Himax Technologies",
    "Hingham Institution for Savings",
    "HireQuest",
    "Histogenics Corporation",
    "Hoegh LNG Partners LP",
    "Holly Energy Partners",
    "HollyFrontier Corporation",
    "Hollysys Automation Technologies",
    "Hologic",
    "Home BancShares",
    "Home Bancorp",
    "Home Depot",
    "Home Federal Bancorp",
    "HomeStreet",
    "HomeTrust Bancshares",
    "Homology Medicines",
    "Honda Motor Company",
    "Honeywell International Inc.",
    "Hooker Furniture Corporation",
    "Hope Bancorp",
    "Horace Mann Educators Corporation",
    "Horizon Bancorp",
    "Horizon Global Corporation",
    "Horizon Technology Finance Corporation",
    "Horizon Therapeutics Public Limited Company",
    "Hormel Foods Corporation",
    "Hornbeck Offshore Services",
    "Hospitality Properties Trust",
    "Host Hotels & Resorts",
    "Hostess Brands",
    "Hoth Therapeutics",
    "Houghton Mifflin Harcourt Company",
    "Houlihan Lokey",
    "Houston American Energy Corporation",
    "Houston Wire & Cable Company",
    "Hovnanian Enterprises Inc",
    "Howard Bancorp",
    "Howard Hughes Corporation (The)",
    "Huami Corporation",
    "Huaneng Power International",
    "Huazhu Group Limited",
    "Hub Group",
    "HubSpot",
    "Hubbell Inc",
    "Hudbay Minerals Inc.",
    "Hudson Global",
    "Hudson Ltd.",
    "Hudson Pacific Properties",
    "Hudson Technologies",
    "Huitao Technology Co.",
    "Humana Inc.",
    "Hunt Companies Finance Trust",
    "Huntington Bancshares Incorporated",
    "Huntington Ingalls Industries",
    "Huntsman Corporation",
    "Hurco Companies",
    "Huron Consulting Group Inc.",
    "Hutchison China MediTech Limited",
    "Huttig Building Products",
    "Hyatt Hotels Corporation",
    "HyreCar Inc.",
    "Hyster-Yale Materials Handling",
    "I.D. Systems",
    "IAA",
    "IAC/InterActiveCorp",
    "IBERIABANK Corporation",
    "IBEX Holdings Limited",
    "IBO (Listing Market - NYSE Amex Network B F)",
    "ICC Holdings",
    "ICF International",
    "ICICI Bank Limited",
    "ICON plc",
    "ICU Medical",
    "IDACORP",
    "IDEAYA Biosciences",
    "IDEX Corporation",
    "IDEXX Laboratories",
    "IDT Corporation",
    "IEC Electronics Corp.",
    "IES Holdings",
    "IF Bancorp",
    "IHS Markit Ltd.",
    "II-VI Incorporated",
    "IMAC Holdings",
    "IMV Inc.",
    "ING Group",
    "INMODE LTD.",
    "INTL FCStone Inc.",
    "INVESCO MORTGAGE CAPITAL INC",
    "INmune Bio Inc.",
    "IPG Photonics Corporation",
    "IQ Chaikin U.S. Large Cap ETF",
    "IQ Chaikin U.S. Small Cap ETF",
    "IQVIA Holdings",
    "IRIDEX Corporation",
    "IRSA Inversiones Y Representaciones S.A.",
    "IRSA Propiedades Comerciales S.A.",
    "IT Tech Packaging",
    "ITT Inc.",
    "IVERIC bio",
    "IZEA Worldwide",
    "Iamgold Corporation",
    "Icahn Enterprises L.P.",
    "Ichor Holdings",
    "Iconix Brand Group",
    "Ideal Power Inc.",
    "Ideanomics",
    "Identiv",
    "Idera Pharmaceuticals",
    "Ikonics Corporation",
    "Illinois Tool Works Inc.",
    "Illumina",
    "Image Sensing Systems",
    "Imax Corporation",
    "Immersion Corporation",
    "ImmuCell Corporation",
    "Immunic",
    "ImmunoGen",
    "Immunomedics",
    "Immuron Limited",
    "Immutep Limited",
    "Impac Mortgage Holdings",
    "Imperial Oil Limited",
    "Impinj",
    "InVivo Therapeutics Holdings Corp.",
    "Income Opportunity Realty Investors",
    "Incyte Corporation",
    "Independence Contract Drilling",
    "Independence Holding Company",
    "Independence Realty Trust",
    "Independent Bank Corp.",
    "Independent Bank Corporation",
    "Independent Bank Group",
    "India Fund",
    "India Globalization Capital Inc.",
    "Industrial Logistics Properties Trust",
    "Industrial Services of America",
    "Industrias Bachoco",
    "Infinera Corporation",
    "Infinity Pharmaceuticals",
    "InflaRx N.V.",
    "Information Services Group",
    "Infosys Limited",
    "Infrastructure and Energy Alternatives",
    "InfuSystems Holdings",
    "Ingersoll-Rand plc (Ireland)",
    "Ingevity Corporation",
    "Ingles Markets",
    "Ingredion Incorporated",
    "InnSuites Hospitality Trust",
    "InnerWorkings",
    "Innodata Inc.",
    "Innophos Holdings",
    "Innospec Inc.",
    "Innovate Biopharmaceuticals",
    "Innovative Industrial Properties",
    "Innovative Solutions and Support",
    "Innoviva",
    "Inogen",
    "Inovalon Holdings",
    "Inovio Pharmaceuticals",
    "Inphi Corporation",
    "Inpixon ",
    "Inseego Corp.",
    "Insight Enterprises",
    "Insight Select Income Fund",
    "Insignia Systems",
    "Insmed",
    "Insperity",
    "Inspire Medical Systems",
    "InspireMD Inc.",
    "Inspired Entertainment",
    "Installed Building Products",
    "Insteel Industries",
    "Instructure",
    "Insulet Corporation",
    "Insurance Acquisition Corp.",
    "Intec Pharma Ltd.",
    "Integer Holdings Corporation",
    "Integra LifeSciences Holdings Corporation",
    "Integrated Media Technology Limited",
    "Intel Corporation",
    "Intellia Therapeutics",
    "Intellicheck",
    "Intelligent Systems Corporation",
    "Intelsat S.A.",
    "Inter Parfums",
    "InterDigital",
    "InterXion Holding N.V.",
    "Intercept Pharmaceuticals",
    "Intercontinental Exchange Inc.",
    "Intercontinental Hotels Group",
    "Intercorp Financial Services Inc.",
    "Interface",
    "Intermolecular",
    "Internap Corporation",
    "International Bancshares Corporation",
    "International Business Machines Corporation",
    "International Flavors & Fragrances",
    "International Game Technology",
    "International Money Express",
    "International Paper Company",
    "International Seaways",
    "International Speedway Corporation",
    "International Tower Hill Mines Ltd",
    "Internet Gold Golden Lines Ltd.",
    "Interpace Diagnostics Group",
    "Interpublic Group of Companies",
    "Intersect ENT",
    "Interstate Power and Light Company",
    "Intevac",
    "Intra-Cellular Therapies Inc.",
    "Intrepid Potash",
    "Intrexon Corporation",
    "IntriCon Corporation",
    "Intuit Inc.",
    "Intuitive Surgical",
    "Inuvo",
    "Invacare Corporation",
    "Invesco 1-30 Laddered Treasury ETF",
    "Invesco Advantage Municipal Income Trust II",
    "Invesco BLDRS Asia 50 ADR Index Fund",
    "Invesco BLDRS Developed Markets 100 ADR Index Fund",
    "Invesco BLDRS Emerging Markets 50 ADR Index Fund",
    "Invesco BLDRS Europe Select ADR Index Fund",
    "Invesco Bond Fund",
    "Invesco BuyBack Achievers ETF",
    "Invesco California Value Municipal Income Trust",
    "Invesco Credit Opportunities Fund",
    "Invesco DWA Basic Materials Momentum ETF",
    "Invesco DWA Consumer Cyclicals Momentum ETF",
    "Invesco DWA Consumer Staples Momentum ETF",
    "Invesco DWA Developed Markets Momentum ETF",
    "Invesco DWA Emerging Markets Momentum ETF",
    "Invesco DWA Energy Momentum ETF",
    "Invesco DWA Financial Momentum ETF",
    "Invesco DWA Healthcare Momentum ETF",
    "Invesco DWA Industrials Momentum ETF",
    "Invesco DWA Momentum ETF",
    "Invesco DWA NASDAQ Momentum ETF",
    "Invesco DWA SmallCap Momentum ETF",
    "Invesco DWA Tactical Multi-Asset Income ETF",
    "Invesco DWA Tactical Sector Rotation ETF",
    "Invesco DWA Technology Momentum ETF",
    "Invesco DWA Utilities Momentum ETF",
    "Invesco Dividend Achievers ETF",
    "Invesco FTSE International Low Beta Equal Weight ETF",
    "Invesco FTSE RAFI US 1500 Small-Mid ETF",
    "Invesco Global Water ETF",
    "Invesco Golden Dragon China ETF",
    "Invesco High Income 2023 Target Term Fund",
    "Invesco High Income 2024 Target Term Fund",
    "Invesco High Income Trust II",
    "Invesco High Yield Equity Dividend Achievers ETF",
    "Invesco International BuyBack Achievers ETF",
    "Invesco International Dividend Achievers ETF",
    "Invesco KBW Bank ETF",
    "Invesco KBW High Dividend Yield Financial ETF",
    "Invesco KBW Premium Yield Equity REIT ETF",
    "Invesco KBW Property & Casualty Insurance ETF",
    "Invesco KBW Regional Banking ETF",
    "Invesco LadderRite 0-5 Year Corporate Bond ETF",
    "Invesco Mortgage Capital Inc.",
    "Invesco Municipal Income Opportunities Trust",
    "Invesco Municipal Opportunity Trust",
    "Invesco Municipal Trust",
    "Invesco Nasdaq Internet ETF",
    "Invesco Optimum Yield Diversified Commodity Strategy No K-1 ET",
    "Invesco Pennsylvania Value Municipal Income Trust",
    "Invesco Plc",
    "Invesco QQQ Trust",
    "Invesco Quality Municipal Income Trust",
    "Invesco RAFI Strategic Developed ex-US ETF",
    "Invesco RAFI Strategic Developed ex-US Small Company ETF",
    "Invesco RAFI Strategic Emerging Markets ETF",
    "Invesco RAFI Strategic US ETF",
    "Invesco RAFI Strategic US Small Company ETF",
    "Invesco Russell 1000 Low Beta Equal Weight ETF",
    "Invesco S&P SmallCap Consumer Discretionary ETF",
    "Invesco S&P SmallCap Consumer Staples ETF",
    "Invesco S&P SmallCap Energy ETF",
    "Invesco S&P SmallCap Financials ETF",
    "Invesco S&P SmallCap Health Care ETF",
    "Invesco S&P SmallCap Industrials ETF",
    "Invesco S&P SmallCap Information Technology ETF",
    "Invesco S&P SmallCap Materials ETF",
    "Invesco S&P SmallCap Utilities & Communication Services ETF",
    "Invesco Senior Income Trust",
    "Invesco Trust  for Investment Grade New York Municipal",
    "Invesco Trust for Investment Grade Municipals",
    "Invesco Value Municipal Income Trust",
    "Invesco Variable Rate Investment Grade ETF",
    "Invesco Water Resources ETF",
    "Investar Holding Corporation",
    "Investcorp Credit Management BDC",
    "Investors Bancorp",
    "Investors Real Estate Trust",
    "Investors Title Company",
    "Invitae Corporation",
    "Invitation Homes Inc.",
    "Ion Geophysical Corporation",
    "Ionis Pharmaceuticals",
    "Iovance Biotherapeutics",
    "Iridium Communications Inc",
    "Iron Mountain Incorporated",
    "Ironwood Pharmaceuticals",
    "IsoRay",
    "Israel Chemicals Shs",
    "Isramco",
    "Issuer Direct Corporation",
    "Ita? CorpBanca",
    "Itamar Medical Ltd.",
    "Itau Unibanco Banco Holding SA",
    "Iteris",
    "Iterum Therapeutics plc",
    "Itron",
    "Ituran Location and Control Ltd.",
    "Ivy High Income Opportunities Fund",
    "J & J Snack Foods Corp.",
    "J P Morgan Chase & Co",
    "J. Alexander&#39;s Holdings",
    "J. Jill",
    "J. W. Mays",
    "J.B. Hunt Transport Services",
    "J.C. Penney Company",
    "J.M. Smucker Company (The)",
    "JAKKS Pacific",
    "JBG SMITH Properties",
    "JD.com",
    "JELD-WEN Holding",
    "JMP Group LLC",
    "JMU Limited",
    "Jabil Inc.",
    "Jack Henry & Associates",
    "Jack In The Box Inc.",
    "Jacobs Engineering Group Inc.",
    "Jagged Peak Energy Inc.",
    "Jaguar Health",
    "James Hardie Industries plc.",
    "James River Group Holdings",
    "JanOne Inc.",
    "Janus Henderson Group plc",
    "Janus Henderson Small Cap Growth Alpha ETF",
    "Janus Henderson Small/Mid Cap Growth Alpha ETF",
    "Japan Smaller Capitalization Fund Inc",
    "Jason Industries",
    "Jazz Pharmaceuticals plc",
    "Jefferies Financial Group Inc.",
    "Jerash Holdings (US)",
    "Jernigan Capital",
    "JetBlue Airways Corporation",
    "Jewett-Cameron Trading Company",
    "Jianpu Technology Inc.",
    "Jiayin Group Inc.",
    "JinkoSolar Holding Company Limited",
    "John B. Sanfilippo & Son",
    "John Bean Technologies Corporation",
    "John Hancock Financial Opportunities Fund",
    "John Hancock Hedged Equity & Income Fund",
    "John Hancock Income Securities Trust",
    "John Hancock Investors Trust",
    "John Hancock Pfd Income Fund II",
    "John Hancock Preferred Income Fund",
    "John Hancock Preferred Income Fund III",
    "John Hancock Premium Dividend Fund",
    "John Hancock Tax Advantaged Dividend Income Fund",
    "John Hancock Tax-Advantaged Global Shareholder Yield Fund",
    "John Wiley & Sons",
    "Johnson & Johnson",
    "Johnson Controls International plc",
    "Johnson Outdoors Inc.",
    "Jones Lang LaSalle Incorporated",
    "Jounce Therapeutics",
    "Jumei International Holding Limited",
    "Jumia Technologies AG",
    "Juniper Networks",
    "Jupai Holdings Limited",
    "Just Energy Group",
    "K12 Inc",
    "KAR Auction Services",
    "KB Financial Group Inc",
    "KB Home",
    "KBL Merger Corp. IV",
    "KBR",
    "KBS Fashion Group Limited",
    "KKR & Co. Inc.",
    "KKR Income Opportunities Fund",
    "KKR Real Estate Finance Trust Inc.",
    "KLA Corporation ",
    "KLX Energy Services Holdings",
    "KNOT Offshore Partners LP",
    "KT Corporation",
    "KVH Industries",
    "Kadant Inc",
    "Kadmon Holdings",
    "Kaiser Aluminum Corporation",
    "Kaixin Auto Holdings",
    "KalVista Pharmaceuticals",
    "Kala Pharmaceuticals",
    "Kaleido Biosciences",
    "Kamada Ltd.",
    "Kaman Corporation",
    "Kandi Technologies Group",
    "Kansas City Southern",
    "Karuna Therapeutics",
    "Karyopharm Therapeutics Inc.",
    "Kayne Anderson MLP/Midstream Investment Company",
    "Kayne Anderson Midstream Energy Fund",
    "Kazia Therapeutics Limited",
    "Keane Group",
    "Kearny Financial",
    "Kellogg Company",
    "Kelly Services",
    "Kelso Technologies Inc",
    "KemPharm",
    "Kemet Corporation",
    "Kemper Corporation",
    "Kennametal Inc.",
    "Kennedy-Wilson Holdings Inc.",
    "Kenon Holdings Ltd.",
    "Kentucky First Federal Bancorp",
    "Keurig Dr Pepper Inc.",
    "Kewaunee Scientific Corporation",
    "Key Energy Services",
    "Key Tronic Corporation",
    "KeyCorp",
    "Keysight Technologies Inc.",
    "Kezar Life Sciences",
    "Kforce",
    "Kilroy Realty Corporation",
    "Kimball Electronics",
    "Kimball International",
    "Kimbell Royalty Partners",
    "Kimberly-Clark Corporation",
    "Kimco Realty Corporation",
    "Kinder Morgan",
    "Kindred Biosciences",
    "Kingold Jewelry Inc.",
    "Kingstone Companies",
    "Kingsway Financial Services",
    "Kiniksa Pharmaceuticals",
    "Kinross Gold Corporation",
    "Kinsale Capital Group",
    "Kirby Corporation",
    "Kirkland Lake Gold Ltd.",
    "Kirkland&#39;s",
    "Kite Realty Group Trust",
    "Kitov Pharma Ltd.",
    "Knight Transportation",
    "Knoll",
    "Knowles Corporation",
    "Kodiak Sciences Inc",
    "Kohl&#39;s Corporation",
    "Koninklijke Philips N.V.",
    "Kontoor Brands",
    "Kopin Corporation",
    "Koppers Holdings Inc.",
    "Korea Electric Power Corporation",
    "Korea Fund",
    "Korn Ferry ",
    "Kornit Digital Ltd.",
    "Kosmos Energy Ltd.",
    "Koss Corporation",
    "KraneShares Trust KraneShares CSI China Internet ETF",
    "Kraton Corporation",
    "Kratos Defense & Security Solutions",
    "Kroger Company (The)",
    "Kronos Worldwide Inc",
    "Krystal Biotech",
    "Kulicke and Soffa Industries",
    "Kura Oncology",
    "Kura Sushi USA",
    "L Brands",
    "L.B. Foster Company",
    "L.S. Starrett Company (The)",
    "L3Harris Technologies",
    "LAIX Inc.",
    "LATAM Airlines Group S.A.",
    "LCI Industries ",
    "LCNB Corporation",
    "LEAP THERAPEUTICS",
    "LF Capital Acquistion Corp.",
    "LG Display Co.",
    "LGI Homes",
    "LGL Group",
    "LHC Group",
    "LINE Corporation",
    "LKQ Corporation",
    "LM Funding America",
    "LMP Capital and Income Fund Inc.",
    "LPL Financial Holdings Inc.",
    "LRAD Corporation",
    "LSC Communications",
    "LSI Industries Inc.",
    "LTC Properties",
    "La Jolla Pharmaceutical Company",
    "La-Z-Boy Incorporated",
    "Laboratory Corporation of America Holdings",
    "Ladder Capital Corp",
    "Ladenburg Thalmann Financial Services Inc",
    "Ladenburg Thalmann Financial Services Inc.",
    "Lake Shore Bancorp",
    "Lakeland Bancorp",
    "Lakeland Financial Corporation",
    "Lakeland Industries",
    "Lam Research Corporation",
    "Lamar Advertising Company",
    "Lamb Weston Holdings",
    "Lancaster Colony Corporation",
    "Landcadia Holdings II",
    "Landec Corporation",
    "Landmark Bancorp Inc.",
    "Landmark Infrastructure Partners LP",
    "Lands&#39; End",
    "Landstar System",
    "Lannett Co Inc",
    "Lantheus Holdings",
    "Lantronix",
    "Laredo Petroleum",
    "Las Vegas Sands Corp.",
    "Lattice Semiconductor Corporation",
    "Laureate Education",
    "Lawson Products",
    "Lazard Global Total Return and Income Fund",
    "Lazard Ltd.",
    "Lazard World Dividend & Income Fund",
    "Lazydays Holdings",
    "LeMaitre Vascular",
    "Leaf Group Ltd.",
    "Lear Corporation",
    "Lee Enterprises",
    "Legacy Acquisition Corp.",
    "Legacy Housing Corporation",
    "LegacyTexas Financial Group",
    "Legg Mason",
    "Legg Mason Global Infrastructure ETF",
    "Legg Mason Low Volatility High Dividend ETF",
    "Legg Mason Small-Cap Quality Value ETF",
    "Leggett & Platt",
    "Lehman ABS Corporation",
    "Leidos Holdings",
    "Leisure Acquisition Corp.",
    "Leju Holdings Limited",
    "LendingClub Corporation",
    "LendingTree",
    "Lennar Corporation",
    "Lennox International",
    "Leo Holdings Corp.",
    "Level One Bancorp",
    "Levi Strauss & Co",
    "Lexicon Pharmaceuticals",
    "LexinFintech Holdings Ltd.",
    "Lexington Realty Trust",
    "Lianluo Smart Limited",
    "Libbey",
    "Liberty All-Star Equity Fund",
    "Liberty All-Star Growth Fund",
    "Liberty Broadband Corporation",
    "Liberty Global plc",
    "Liberty Latin America Ltd.",
    "Liberty Media Corporation",
    "Liberty Oilfield Services Inc.",
    "Liberty Property Trust",
    "Liberty TripAdvisor Holdings",
    "Life Storage",
    "Lifetime Brands",
    "Lifevantage Corporation",
    "Lifeway Foods",
    "Ligand Pharmaceuticals Incorporated",
    "LightInTheBox Holding Co.",
    "LightPath Technologies",
    "Lightbridge Corporation",
    "Lilis Energy",
    "Limbach Holdings",
    "Limelight Networks",
    "Limestone Bancorp",
    "Limoneira Co",
    "Lincoln Educational Services Corporation",
    "Lincoln Electric Holdings",
    "Lincoln National Corporation",
    "Lindblad Expeditions Holdings Inc. ",
    "Linde plc",
    "Lindsay Corporation",
    "Lineage Cell Therapeutics",
    "Linx S.A.",
    "Lions Gate Entertainment Corporation",
    "Lipocine Inc.",
    "LiqTech International",
    "Liquid Media Group Ltd.",
    "Liquidia Technologies",
    "Liquidity Services",
    "Lithia Motors",
    "Lithium Americas Corp.",
    "Littelfuse",
    "LivaNova PLC",
    "Live Nation Entertainment",
    "Live Oak Bancshares",
    "Live Ventures Incorporated",
    "LivePerson",
    "LiveRamp Holdings",
    "LiveXLive Media",
    "Livent Corporation",
    "Livongo Health",
    "Lloyds Banking Group Plc",
    "Lockheed Martin Corporation",
    "Loews Corporation",
    "LogMein",
    "LogicBio Therapeutics",
    "Logitech International S.A.",
    "Loma Negra Compania Industrial Argentina Sociedad Anonima",
    "Loncar Cancer Immunotherapy ETF",
    "Loncar China BioPharma ETF",
    "Lonestar Resources US Inc.",
    "Longevity Acquisition Corporation",
    "Loop Industries",
    "Loral Space and Communications",
    "Louisiana-Pacific Corporation",
    "Lowe&#39;s Companies",
    "Lsb Industries Inc.",
    "Luby&#39;s",
    "Luckin Coffee Inc.",
    "Lumber Liquidators Holdings",
    "Lumentum Holdings Inc.",
    "Luminex Corporation",
    "Luna Innovations Incorporated",
    "Luokung Technology Corp",
    "Luther Burbank Corporation",
    "Luxfer Holdings PLC",
    "Lydall",
    "Lyft",
    "Lyon William Homes",
    "LyondellBasell Industries NV",
    "M&T Bank Corporation",
    "M.D.C. Holdings",
    "M/I Homes",
    "MACOM Technology Solutions Holdings",
    "MAG Silver Corporation",
    "MAM Software Group",
    "MBIA",
    "MDC Partners Inc.",
    "MDJM LTD",
    "MDU Resources Group",
    "MEDIFAST INC",
    "MEI Pharma",
    "MER Telemanagement Solutions Ltd.",
    "MFA Financial",
    "MFS Charter Income Trust",
    "MFS Government Markets Income Trust",
    "MFS Intermediate Income Trust",
    "MFS Multimarket Income Trust",
    "MFS Municipal Income Trust",
    "MFS Special Value Trust",
    "MGE Energy Inc.",
    "MGIC Investment Corporation",
    "MGM Growth Properties LLC",
    "MGM Resorts International",
    "MGP Ingredients",
    "MICT",
    "MIDSTATES PETROLEUM COMPANY",
    "MIND C.T.I. Ltd.",
    "MISONIX",
    "MKS Instruments",
    "MMA Capital Holdings",
    "MMTec",
    "MOGU Inc.",
    "MPLX LP",
    "MRC Global Inc.",
    "MRI Interventions",
    "MS Structured Asset Corp Saturns GE Cap Corp Series 2002-14",
    "MSA Safety Incorporporated",
    "MSB Financial Corp.",
    "MSC Industrial Direct Company",
    "MSCI Inc",
    "MSG Networks Inc.",
    "MTBC",
    "MTS Systems Corporation",
    "MV Oil Trust",
    "MVB Financial Corp.",
    "MVC Capital",
    "MYOS RENS Technology Inc.",
    "MYR Group",
    "Macatawa Bank Corporation",
    "Macerich Company (The)",
    "Mack-Cali Realty Corporation",
    "Mackinac Financial Corporation",
    "Macquarie First Trust Global",
    "Macquarie Global Infrastructure Total Return Fund Inc.",
    "Macquarie Infrastructure Corporation ",
    "Macro Bank Inc.",
    "MacroGenics",
    "Macy&#39;s Inc",
    "Madison Covered Call & Equity Strategy Fund",
    "Madrigal Pharmaceuticals",
    "Magal Security Systems Ltd.",
    "Magellan Health",
    "Magellan Midstream Partners L.P.",
    "Magenta Therapeutics",
    "Magic Software Enterprises Ltd.",
    "Magna International",
    "MagnaChip Semiconductor Corporation",
    "Magnolia Oil & Gas Corporation",
    "Magyar Bancorp",
    "Maiden Holdings",
    "Main Street Capital Corporation",
    "MainStay MacKay DefinedTerm Municipal Opportunitie",
    "MainStreet Bancshares",
    "Majesco",
    "MakeMyTrip Limited",
    "Malibu Boats",
    "Mallinckrodt plc",
    "Malvern Bancorp",
    "Mammoth Energy Services",
    "ManTech International Corporation",
    "Manchester United Ltd.",
    "Manhattan Associates",
    "Manhattan Bridge Capital",
    "Manitex International",
    "Manitowoc Company",
    "MannKind Corporation",
    "Mannatech",
    "Manning & Napier",
    "ManpowerGroup",
    "Manulife Financial Corp",
    "Marathon Oil Corporation",
    "Marathon Patent Group",
    "Marathon Petroleum Corporation",
    "Marchex",
    "Marcus & Millichap",
    "Marcus Corporation (The)",
    "Marin Software Incorporated",
    "Marine Petroleum Trust",
    "Marine Products Corporation",
    "MarineMax",
    "Marinus Pharmaceuticals",
    "Markel Corporation",
    "Marker Therapeutics",
    "MarketAxess Holdings",
    "Marlin Business Services Corp.",
    "Marriott International",
    "Marriott Vacations Worldwide Corporation",
    "Marrone Bio Innovations",
    "Marsh & McLennan Companies",
    "Marten Transport",
    "Martin Marietta Materials",
    "Martin Midstream Partners L.P.",
    "Marvell Technology Group Ltd.",
    "MasTec",
    "Masco Corporation",
    "Masimo Corporation",
    "Masonite International Corporation",
    "Mastech Digital",
    "MasterCraft Boat Holdings",
    "Mastercard Incorporated",
    "Matador Resources Company",
    "Match Group",
    "Materialise NV",
    "Materion Corporation",
    "Matinas Biopharma Holdings",
    "Matrix Service Company",
    "Matson",
    "Mattel",
    "Matthews International Corporation",
    "Maui Land & Pineapple Company",
    "Maverix Metals Inc.",
    "MaxLinear",
    "Maxar Technologies Inc.",
    "Maxim Integrated Products",
    "Maximus",
    "Mayville Engineering Company",
    "McClatchy Company (The)",
    "McCormick & Company",
    "McDermott International",
    "McDonald&#39;s Corporation",
    "McEwen Mining Inc.",
    "McGrath RentCorp",
    "McKesson Corporation",
    "Mechel PAO",
    "Medalist Diversified REIT",
    "Medallia",
    "Medallion Financial Corp.",
    "MediWound Ltd.",
    "Medical Properties Trust",
    "MediciNova",
    "Medidata Solutions",
    "Medigus Ltd.",
    "Medley Capital Corporation",
    "Medley LLC",
    "Medley Management Inc.",
    "Mednax",
    "Medpace Holdings",
    "Medtronic plc",
    "Megalith Financial Acquisition Corp.",
    "MeiraGTx Holdings plc",
    "Melco Resorts & Entertainment Limited",
    "Melinta Therapeutics",
    "Mellanox Technologies",
    "Menlo Therapeutics Inc.",
    "MercadoLibre",
    "Mercantile Bank Corporation",
    "Mercer International Inc.",
    "Merchants Bancorp",
    "Merck & Company",
    "Mercury General Corporation",
    "Mercury Systems Inc",
    "Meredith Corporation",
    "Mereo BioPharma Group plc",
    "Meridian Bancorp",
    "Meridian Bioscience Inc.",
    "Meridian Corporation",
    "Merit Medical Systems",
    "Meritage Corporation",
    "Meritor",
    "Merrill Lynch & Co.",
    "Merrill Lynch Depositor",
    "Merrimack Pharmaceuticals",
    "Mersana Therapeutics",
    "Merus N.V.",
    "Mesa Air Group",
    "Mesa Laboratories",
    "Mesa Royalty Trust",
    "Mesabi Trust",
    "Mesoblast Limited",
    "MetLife",
    "Meta Financial Group",
    "Methanex Corporation",
    "Methode Electronics",
    "Metropolitan Bank Holding Corp.",
    "Mettler-Toledo International",
    "Mexco Energy Corporation",
    "Mexico Equity and Income Fund",
    "Mexico Fund",
    "MiX Telematics Limited",
    "Micro Focus Intl PLC",
    "MicroStrategy Incorporated",
    "Microbot Medical Inc. ",
    "Microchip Technology Incorporated",
    "Micron Solutions",
    "Micron Technology",
    "Microsoft Corporation",
    "Microvision",
    "Mid Penn Bancorp",
    "Mid-America Apartment Communities",
    "Mid-Con Energy Partners",
    "Mid-Southern Bancorp",
    "MidSouth Bancorp",
    "MidWestOne Financial Group",
    "Midatech Pharma PLC",
    "Middlefield Banc Corp.",
    "Middlesex Water Company",
    "Midland States Bancorp",
    "Milacron Holdings Corp.",
    "Milestone Pharmaceuticals Inc.",
    "Milestone Scientific",
    "Millendo Therapeutics",
    "Miller Industries",
    "Miller/Howard High Income Equity Fund",
    "Millicom International Cellular S.A.",
    "Mimecast Limited",
    "Minerals Technologies Inc.",
    "Minerva Neurosciences",
    "Miragen Therapeutics",
    "Mirati Therapeutics",
    "Mirum Pharmaceuticals",
    "Mistras Group Inc",
    "Mitcham Industries",
    "Mitek Systems",
    "Mitsubishi UFJ Financial Group Inc",
    "Mizuho Financial Group",
    "MoSys",
    "Mobile Mini",
    "Mobile TeleSystems OJSC",
    "MobileIron",
    "Model N",
    "Moderna",
    "Modine Manufacturing Company",
    "Moelis & Company",
    "Mogo Inc.",
    "Mohawk Group Holdings",
    "Mohawk Industries",
    "Molecular Templates",
    "Moleculin Biotech",
    "Molina Healthcare Inc",
    "Molson Coors Brewing  Company",
    "Momenta Pharmaceuticals",
    "Momo Inc.",
    "Monaker Group",
    "Monarch Casino & Resort",
    "Mondelez International",
    "Moneygram International",
    "MongoDB",
    "Monmouth Real Estate Investment Corporation",
    "Monocle Acquisition Corporation",
    "Monolithic Power Systems",
    "Monotype Imaging Holdings Inc.",
    "Monro",
    "Monroe Capital Corporation",
    "Monster Beverage Corporation",
    "Montage Resources Corporation",
    "Moody&#39;s Corporation",
    "Moog Inc.",
    "Morgan Stanley",
    "Morgan Stanley China A Share Fund Inc.",
    "Morgan Stanley Emerging Markets Debt Fund",
    "Morgan Stanley Emerging Markets Domestic Debt Fund",
    "Morgan Stanley India Investment Fund",
    "Morningstar",
    "Morphic Holding",
    "MorphoSys AG",
    "Mosaic Acquisition Corp.",
    "Mosaic Company (The)",
    "Mota Group",
    "Motif Bio plc",
    "Motorcar Parts of America",
    "Motorola Solutions",
    "Motus GI Holdings",
    "Mountain Province Diamonds Inc.",
    "Movado Group Inc.",
    "Moxian",
    "Mr. Cooper Group Inc.",
    "Mudrick Capital Acquisition Corporation",
    "Mueller Industries",
    "Mueller Water Products Inc",
    "MuniVest Fund",
    "MuniYield Arizona Fund",
    "Murphy Oil Corporation",
    "Murphy USA Inc.",
    "Mustang Bio",
    "MutualFirst Financial Inc.",
    "My Size",
    "Myers Industries",
    "Mylan N.V.",
    "MyoKardia",
    "Myomo Inc.",
    "Myovant Sciences Ltd.",
    "Myriad Genetics",
    "NACCO Industries",
    "NAPCO Security Technologies",
    "NASDAQ TEST STOCK",
    "NB Capital Acquisition Corp.",
    "NBT Bancorp Inc.",
    "NCR Corporation",
    "NCS Multistage Holdings",
    "NETGEAR",
    "NF Energy Saving Corporation",
    "NGL ENERGY PARTNERS LP",
    "NGM Biopharmaceuticals",
    "NI Holdings",
    "NIC Inc.",
    "NICE Ltd",
    "NII Holdings",
    "NIO Inc.",
    "NL Industries",
    "NMI Holdings Inc",
    "NN",
    "NOW Inc.",
    "NRC Group Holdings Corp.",
    "NRG Energy",
    "NTN Buzztime",
    "NV5 Global",
    "NVE Corporation",
    "NVIDIA Corporation",
    "NVR",
    "NXP Semiconductors N.V.",
    "NXT-ID Inc.",
    "NYSE Test One",
    "Nabors Industries Ltd.",
    "Nabriva Therapeutics plc",
    "Naked Brand Group Limited",
    "Nam Tai Property Inc.",
    "Nano Dimension Ltd.",
    "NanoString Technologies",
    "NanoVibronix",
    "NanoViricides",
    "Nanometrics Incorporated",
    "NantHealth",
    "NantKwest",
    "Nasdaq",
    "Natera",
    "Nathan&#39;s Famous",
    "National Bank Holdings Corporation",
    "National Bankshares",
    "National Beverage Corp.",
    "National CineMedia",
    "National Energy Services Reunited Corp.",
    "National Fuel Gas Company",
    "National General Holdings Corp",
    "National Grid Transco",
    "National Health Investors",
    "National HealthCare Corporation",
    "National Holdings Corporation",
    "National Instruments Corporation",
    "National Oilwell Varco",
    "National Presto Industries",
    "National Research Corporation",
    "National Retail Properties",
    "National Rural Utilities Cooperative Finance Corporation",
    "National Security Group",
    "National Steel Company",
    "National Storage Affiliates Trust",
    "National Vision Holdings",
    "National Western Life Group",
    "Natural Alternatives International",
    "Natural Gas Services Group",
    "Natural Grocers by Vitamin Cottage",
    "Natural Health Trends Corp.",
    "Natural Resource Partners LP",
    "Nature&#39;s Sunshine Products",
    "Natus Medical Incorporated",
    "Natuzzi",
    "Nautilus Group",
    "Navidea Biopharmaceuticals",
    "Navient Corporation",
    "Navigant Consulting",
    "Navigator Holdings Ltd.",
    "Navios Maritime Acquisition Corporation",
    "Navios Maritime Containers L.P.",
    "Navios Maritime Holdings Inc.",
    "Navios Maritime Partners LP",
    "Navistar International Corporation",
    "Nebula Acquisition Corporation",
    "Neenah",
    "Nektar Therapeutics",
    "Nelnet",
    "Nemaura Medical Inc.",
    "NeoGenomics",
    "NeoPhotonics Corporation",
    "Neogen Corporation",
    "Neoleukin Therapeutics",
    "Neon Therapeutics",
    "Neonode Inc.",
    "Neos Therapeutics",
    "Neovasc Inc.",
    "Nephros",
    "Neptune Wellness Solutions Inc.",
    "Nesco Holdings",
    "Net 1 UEPS Technologies",
    "Net Element",
    "NetApp",
    "NetEase",
    "NetScout Systems",
    "NetSol Technologies Inc.",
    "Netfin Acquisition Corp.",
    "Netflix",
    "Network-1 Technologies",
    "NeuBase Therapeutics",
    "Neuberger Berman California Municipal Fund Inc",
    "Neuberger Berman High Yield Strategies Fund",
    "Neuberger Berman MLP and Energy Income Fund Inc.",
    "Neuberger Berman Municipal Fund Inc.",
    "Neuberger Berman New York Municipal Fund Inc.",
    "Neuberger Berman Real Estate Securities Income Fund",
    "Neuralstem",
    "NeuroMetrix",
    "Neurocrine Biosciences",
    "Neuronetics",
    "Neurotrope",
    "Nevro Corp.",
    "New Age Beverages Corporation",
    "New America High Income Fund",
    "New Concept Energy",
    "New England Realty Associates Limited Partnership",
    "New Fortress Energy LLC",
    "New Frontier Corporation",
    "New Germany Fund",
    "New Gold Inc.",
    "New Home Company Inc. (The)",
    "New Ireland Fund",
    "New Media Investment Group Inc.",
    "New Mountain Finance Corporation",
    "New Oriental Education & Technology Group",
    "New Providence Acquisition Corp.",
    "New Relic",
    "New Residential Investment Corp.",
    "New Senior Investment Group Inc.",
    "New York Community Bancorp",
    "New York Mortgage Trust",
    "New York Times Company (The)",
    "NewJersey Resources Corporation",
    "NewLink Genetics Corporation",
    "NewMarket Corporation",
    "Newater Technology",
    "Newell Brands Inc.",
    "Newmark Group",
    "Newmont Goldcorp Corporation",
    "Newpark Resources",
    "News Corporation",
    "Newtek Business Services Corp.",
    "NexPoint Residential Trust",
    "NexPoint Strategic Opportunities Fund",
    "Nexa Resources S.A.",
    "Nexeon Medsystems",
    "Nexgen Energy Ltd.",
    "Nexstar Media Group",
    "NextCure",
    "NextDecade Corporation",
    "NextEra Energy",
    "NextEra Energy Partners",
    "NextGen Healthcare",
    "NiSource",
    "Niagara Mohawk Holdings",
    "Nicholas Financial",
    "Nicolet Bankshares Inc.",
    "Nielsen N.V.",
    "Nike",
    "Nine Energy Service",
    "Niu Technologies",
    "Noah Holdings Ltd.",
    "Noble Corporation",
    "Noble Energy Inc.",
    "Noble Midstream Partners LP",
    "Nokia Corporation",
    "Nomad Foods Limited",
    "Nomura Holdings Inc ADR",
    "Noodles & Company",
    "Norbord Inc.",
    "Nordic American Tankers Limited",
    "Nordson Corporation",
    "Nordstrom",
    "Norfolk Southern Corporation",
    "Nortech Systems Incorporated",
    "North American Construction Group Ltd.",
    "North European Oil Royality Trust",
    "NorthStar Realty Europe Corp.",
    "NorthWestern Corporation",
    "Northeast Bank",
    "Northern Dynasty Minerals",
    "Northern Oil and Gas",
    "Northern Technologies International Corporation",
    "Northern Trust Corporation",
    "Northfield Bancorp",
    "Northrim BanCorp Inc",
    "Northrop Grumman Corporation",
    "Northwest Bancshares",
    "Northwest Natural Holding Company",
    "Northwest Pipe Company",
    "Norwegian Cruise Line Holdings Ltd.",
    "Norwood Financial Corp.",
    "Nova Lifestyle",
    "Nova Measuring Instruments Ltd.",
    "NovaBay Pharmaceuticals",
    "Novagold Resources Inc.",
    "Novan",
    "Novanta Inc.",
    "Novartis AG",
    "Novavax",
    "Novelion Therapeutics Inc. ",
    "Novo Nordisk A/S",
    "NovoCure Limited",
    "Novus Therapeutics",
    "Nu Skin Enterprises",
    "NuCana plc",
    "NuStar Logistics",
    "NuVasive",
    "Nuance Communications",
    "Nucor Corporation",
    "Nustar Energy L.P.",
    "Nutanix",
    "Nutrien Ltd.",
    "Nuvectra Corporation",
    "Nuveen AMT-Free Municipal Credit Income Fund",
    "Nuveen AMT-Free Municipal Value Fund",
    "Nuveen AMT-Free Quality Municipal Income Fund",
    "Nuveen All Cap Energy MLP Opportunities Fund",
    "Nuveen Arizona Quality Municipal Income Fund",
    "Nuveen California AMT-Free Quality Municipal Income Fund",
    "Nuveen California Municipal Value Fund",
    "Nuveen California Municipal Value Fund 2",
    "Nuveen California Quality Municipal Income Fund",
    "Nuveen Connecticut Quality Municipal Income Fund",
    "Nuveen Core Equity Alpha Fund",
    "Nuveen Credit Opportunities 2022 Target Term Fund",
    "Nuveen Credit Strategies Income Fund",
    "Nuveen Diversified Dividend and Income Fund",
    "Nuveen Dow 30SM Dynamic Overwrite Fund",
    "Nuveen Emerging Markets Debt 2022 Target Term Fund",
    "Nuveen Energy MLP Total Return Fund",
    "Nuveen Enhanced Municipal Value Fund",
    "Nuveen Floating Rate Income Fund",
    "Nuveen Floating Rate Income Opportuntiy Fund",
    "Nuveen Georgia Quality Municipal Income Fund ",
    "Nuveen Global High Income Fund",
    "Nuveen High Income 2020 Target Term Fund",
    "Nuveen High Income 2023 Target Term Fund",
    "Nuveen High Income December 2019 Target Term Fund",
    "Nuveen High Income November 2021 Target Term Fund",
    "Nuveen Insured California Select Tax-Free Income Portfolio",
    "Nuveen Insured New York Select Tax-Free Income Portfolio",
    "Nuveen Intermediate Duration Municipal Term Fund",
    "Nuveen Maryland Quality Municipal Income Fund",
    "Nuveen Massachusetts Municipal Income Fund",
    "Nuveen Michigan Quality Municipal Income Fund",
    "Nuveen Minnesota Quality Municipal Income Fund",
    "Nuveen Missouri Quality Municipal Income Fund",
    "Nuveen Mortgage Opportunity Term Fund",
    "Nuveen Multi-Market Income Fund",
    "Nuveen Municipal 2021 Target Term Fund",
    "Nuveen Municipal Credit Income Fund",
    "Nuveen Municipal High Income Opportunity Fund",
    "Nuveen Municipal Income Fund",
    "Nuveen NASDAQ 100 Dynamic Overwrite Fund",
    "Nuveen New Jersey Municipal Value Fund",
    "Nuveen New Jersey Quality Municipal Income Fund",
    "Nuveen New York AMT-Free Quality Municipal",
    "Nuveen New York Municipal Value Fund",
    "Nuveen New York Municipal Value Fund 2",
    "Nuveen New York Quality Municipal Income Fund",
    "Nuveen North Carolina Quality Municipal Income Fd",
    "Nuveen Ohio Quality Municipal Income Fund",
    "Nuveen Pennsylvania Municipal Value Fund",
    "Nuveen Pennsylvania Quality Municipal Income Fund",
    "Nuveen Preferred & Income Opportunities Fund",
    "Nuveen Preferred & Income Securities Fund",
    "Nuveen Preferred and Income 2022 Term Fund",
    "Nuveen Preferred and Income Term Fund",
    "Nuveen Quality Municipal Income Fund",
    "Nuveen Real Asset Income and Growth Fund",
    "Nuveen Real Estate Fund",
    "Nuveen S&P 500 Buy-Write Income Fund",
    "Nuveen S&P 500 Dynamic Overwrite Fund",
    "Nuveen Select Maturities Municipal Fund",
    "Nuveen Select Tax Free Income Portfolio",
    "Nuveen Select Tax Free Income Portfolio II",
    "Nuveen Select Tax Free Income Portfolio III",
    "Nuveen Senior Income Fund",
    "Nuveen Short Duration Credit Opportunities Fund",
    "Nuveen Tax-Advantaged Dividend Growth Fund",
    "Nuveen Tax-Advantaged Total Return Strategy Fund",
    "Nuveen Taxable Municipal Income Fund",
    "Nuveen Texas Quality Municipal Income Fund",
    "Nuveen Virginia Quality Municipal Income Fund",
    "Nuveenn Intermediate Duration Quality Municipal Term Fund",
    "Nuven Mortgage Opportunity Term Fund 2",
    "Nuverra Environmental Solutions",
    "Nymox Pharmaceutical Corporation",
    "O&#39;Reilly Automotive",
    "O2Micro International Limited",
    "OFG Bancorp",
    "OFS Capital Corporation",
    "OFS Credit Company",
    "OGE Energy Corp",
    "OHA Investment Corporation",
    "OMNOVA Solutions Inc.",
    "ON Semiconductor Corporation",
    "ONE Gas",
    "ONEOK",
    "OP Bancorp",
    "ORBCOMM Inc.",
    "OSI Systems",
    "OTG EXP",
    "OUTFRONT Media Inc.",
    "Oak Valley Bancorp (CA)",
    "Oaktree Acquisition Corp.",
    "Oaktree Capital Group",
    "Oaktree Specialty Lending Corporation",
    "Oaktree Strategic Income Corporation",
    "Oasis Midstream Partners LP",
    "Oasis Petroleum Inc.",
    "Obalon Therapeutics",
    "ObsEva SA",
    "Obsidian Energy Ltd.",
    "Occidental Petroleum Corporation",
    "Ocean Bio-Chem",
    "Ocean Power Technologies",
    "OceanFirst Financial Corp.",
    "Oceaneering International",
    "Oconee Federal Financial Corp.",
    "Ocular Therapeutix",
    "Ocwen Financial Corporation",
    "Odonate Therapeutics",
    "Odyssey Marine Exploration",
    "Office Depot",
    "Office Properties Income Trust",
    "Ohio Valley Banc Corp.",
    "Oi S.A.",
    "Oil States International",
    "Oil-Dri Corporation Of America",
    "Okta",
    "Old Dominion Freight Line",
    "Old Line Bancshares",
    "Old National Bancorp",
    "Old Point Financial Corporation",
    "Old Republic International Corporation",
    "Old Second Bancorp",
    "Olin Corporation",
    "Ollie&#39;s Bargain Outlet Holdings",
    "Olympic Steel",
    "Omega Flex",
    "Omega Healthcare Investors",
    "Omeros Corporation",
    "Omnicell",
    "Omnicom Group Inc.",
    "On Deck Capital",
    "On Track Innovations Ltd",
    "OncoCyte Corporation",
    "OncoSec Medical Incorporated",
    "Oncolytics Biotech Inc.",
    "Onconova Therapeutics",
    "Oncternal Therapeutics",
    "One Liberty Properties",
    "One Stop Systems",
    "OneMain Holdings",
    "OneSmart International Education Group Limited",
    "OneSpaWorld Holdings Limited",
    "OneSpan Inc.",
    "Ooma",
    "OpGen",
    "Open Text Corporation",
    "Opera Limited",
    "Opes Acquisition Corp.",
    "Opiant Pharmaceuticals",
    "Opko Health",
    "Oppenheimer Holdings",
    "OptiNose",
    "Optibase Ltd.",
    "Optical Cable Corporation",
    "OptimizeRx Corporation",
    "OptimumBank Holdings",
    "Option Care Health",
    "Opus Bank",
    "OraSure Technologies",
    "Oracle Corporation",
    "Oragenics Inc.",
    "Oramed Pharmaceuticals Inc.",
    "Orange",
    "Orchard Therapeutics plc",
    "Orchid Island Capital",
    "Organigram Holdings Inc.",
    "Organogenesis Holdings Inc. ",
    "Organovo Holdings",
    "Orgenesis Inc.",
    "Origin Agritech Limited",
    "Origin Bancorp",
    "Orion Energy Systems",
    "Orion Engineered Carbons S.A",
    "Orion Group Holdings",
    "Orisun Acquisition Corp.",
    "Oritani Financial Corp.",
    "Orix Corp Ads",
    "Ormat Technologies",
    "Orrstown Financial Services Inc",
    "OrthoPediatrics Corp.",
    "Orthofix Medical Inc. ",
    "Oshkosh Corporation",
    "Osisko Gold Royalties Ltd",
    "Osmotica Pharmaceuticals plc",
    "Ossen Innovation Co.",
    "Otelco Inc.",
    "Otonomy",
    "Ottawa Bancorp",
    "Otter Tail Corporation",
    "Outlook Therapeutics",
    "Overseas Shipholding Group",
    "Overstock.com",
    "Ovid Therapeutics Inc.",
    "Owens & Minor",
    "Owens Corning Inc",
    "Owens-Illinois",
    "Owl Rock Capital Corporation",
    "Oxbridge Re Holdings Limited",
    "Oxford Immunotec Global PLC",
    "Oxford Industries",
    "Oxford Lane Capital Corp.",
    "Oxford Square Capital Corp.",
    "P & F Industries",
    "P.A.M. Transportation Services",
    "PACCAR Inc.",
    "PAR Technology Corporation",
    "PAVmed Inc.",
    "PB Bancorp",
    "PBF Energy Inc.",
    "PBF Logistics LP",
    "PC Connection",
    "PC-Tel",
    "PCB Bancorp",
    "PCI Media",
    "PCSB Financial Corporation",
    "PDC Energy",
    "PDF Solutions",
    "PDL BioPharma",
    "PDL Community Bancorp",
    "PDS Biotechnology Corporation",
    "PFSweb",
    "PGIM Global High Yield Fund",
    "PGIM High Yield Bond Fund",
    "PGT Innovations",
    "PICO Holdings Inc.",
    "PIMCO California Municipal Income Fund",
    "PIMCO California Municipal Income Fund III",
    "PIMCO Commercial Mortgage Securities Trust",
    "PIMCO Dynamic Credit and Mortgage Income Fund",
    "PIMCO Dynamic Income Fund",
    "PIMCO Energy and Tactical Credit Opportunities Fund",
    "PIMCO Income Strategy Fund",
    "PIMCO Income Strategy Fund II",
    "PIMCO Municipal Income Fund",
    "PIMCO Municipal Income Fund III",
    "PIMCO New York Municipal Income Fund",
    "PIMCO New York Municipal Income Fund III",
    "PIMCO Strategic Income Fund",
    "PJT Partners Inc.",
    "PLDT Inc.",
    "PLUS THERAPEUTICS",
    "PLx Pharma Inc.",
    "PNC Financial Services Group",
    "PNM Resources",
    "POSCO",
    "PPDAI Group Inc.",
    "PPG Industries",
    "PPL Capital Funding",
    "PPL Corporation",
    "PPlus Trust",
    "PQ Group Holdings Inc.",
    "PRA Group",
    "PRA Health Sciences",
    "PRGX Global",
    "PROS Holdings",
    "PS Business Parks",
    "PT Telekomunikasi Indonesia",
    "PTC Inc.",
    "PTC Therapeutics",
    "PUHUI WEALTH INVESTMENT MANAGEMENT CO.",
    "PVH Corp.",
    "PacWest Bancorp",
    "Pacer Cash Cows Fund of Funds ETF",
    "Pacer Emerging Markets Cash Cows 100 ETF",
    "Pacer Military Times Best Employers ETF",
    "Pacific Biosciences of California",
    "Pacific Coast Oil Trust",
    "Pacific Drilling S.A.",
    "Pacific Ethanol",
    "Pacific Gas & Electric Co.",
    "Pacific Mercantile Bancorp",
    "Pacific Premier Bancorp Inc",
    "Pacira BioSciences",
    "Packaging Corporation of America",
    "PagSeguro Digital Ltd.",
    "PagerDuty",
    "Palatin Technologies",
    "Palo Alto Networks",
    "Palomar Holdings",
    "Pampa Energia S.A.",
    "Pan American Silver Corp.",
    "Pangaea Logistics Solutions Ltd.",
    "Panhandle Royalty Company",
    "Papa John&#39;s International",
    "Par Pacific Holdings",
    "Paramount Gold Nevada Corp.",
    "Paramount Group",
    "Paratek Pharmaceuticals",
    "Pareteum Corporation",
    "Paringa Resources Limited",
    "Park Aerospace Corp.",
    "Park City Group",
    "Park Hotels & Resorts Inc.",
    "Park National Corporation",
    "Park-Ohio Holdings Corp.",
    "Parke Bancorp",
    "Parker Drilling Company",
    "Parker-Hannifin Corporation",
    "Parsley Energy",
    "Parsons Corporation",
    "Partner Communications Company Ltd.",
    "PartnerRe Ltd.",
    "Party City Holdco Inc.",
    "Pathfinder Bancorp",
    "Patrick Industries",
    "Patriot National Bancorp Inc.",
    "Patriot Transportation Holding",
    "Pattern Energy Group Inc.",
    "Patterson Companies",
    "Patterson-UTI Energy",
    "PayPal Holdings",
    "Paychex",
    "Paycom Software",
    "Paylocity Holding Corporation",
    "Paysign",
    "Peabody Energy Corporation",
    "Peak Resorts",
    "Peapack-Gladstone Financial Corporation",
    "Pearson",
    "Pebblebrook Hotel Trust",
    "Pedevco Corp.",
    "PeerStream",
    "Pegasystems Inc.",
    "Pembina Pipeline Corp.",
    "Penn National Gaming",
    "Penn Virginia Corporation",
    "PennantPark Floating Rate Capital Ltd.",
    "PennantPark Investment Corporation",
    "Penns Woods Bancorp",
    "Pennsylvania Real Estate Investment Trust",
    "PennyMac Financial Services",
    "PennyMac Mortgage Investment Trust",
    "Pensare Acquisition Corp.",
    "Penske Automotive Group",
    "Pentair plc.",
    "Penumbra",
    "People&#39;s United Financial",
    "People&#39;s Utah Bancorp",
    "Peoples Bancorp Inc.",
    "Peoples Bancorp of North Carolina",
    "Peoples Financial Services Corp. ",
    "Pepsico",
    "Perceptron",
    "Perficient",
    "Performance Food Group Company",
    "Performance Shipping Inc.",
    "Performant Financial Corporation",
    "Perion Network Ltd",
    "PerkinElmer",
    "PermRock Royalty Trust",
    "Perma-Fix Environmental Services",
    "Perma-Pipe International Holdings",
    "Permian Basin Royalty Trust",
    "Permianville Royalty Trust",
    "Perrigo Company",
    "Personalis",
    "Perspecta Inc.",
    "PetIQ",
    "PetMed Express",
    "PetroChina Company Limited",
    "Petroleo Brasileiro S.A.- Petrobras",
    "Pfenex Inc.",
    "Pfizer",
    "PhaseBio Pharmaceuticals",
    "Phibro Animal Health Corporation",
    "Philip Morris International Inc",
    "Phillips 66",
    "Phillips 66 Partners LP",
    "Phio Pharmaceuticals Corp.",
    "Phoenix New Media Limited",
    "Photronics",
    "Phreesia",
    "Phunware",
    "Physicians Realty Trust",
    "Piedmont Lithium Limited",
    "Piedmont Office Realty Trust",
    "Pier 1 Imports",
    "Pieris Pharmaceuticals",
    "Pilgrim&#39;s Pride Corporation",
    "Pimco California Municipal Income Fund II",
    "Pimco Corporate & Income Opportunity Fund",
    "Pimco Corporate & Income Stategy Fund",
    "Pimco Global Stocksplus & Income Fund",
    "Pimco High Income Fund",
    "Pimco Income Opportunity Fund",
    "Pimco Municipal Income Fund II",
    "Pimco New York Municipal Income Fund II",
    "Pinduoduo Inc.",
    "Pingtan Marine Enterprise Ltd.",
    "Pinnacle Financial Partners",
    "Pinnacle West Capital Corporation",
    "Pintec Technology Holdings Limited",
    "Pinterest",
    "Pioneer Bancorp",
    "Pioneer Diversified High Income Trust",
    "Pioneer Floating Rate Trust",
    "Pioneer High Income Trust",
    "Pioneer Municipal High Income Advantage Trust",
    "Pioneer Municipal High Income Trust",
    "Pioneer Natural Resources Company",
    "Pioneer Power Solutions",
    "Piper Jaffray Companies",
    "Pitney Bowes Inc.",
    "Pivotal Acquisition Corp.",
    "Pivotal Investment Corporation II",
    "Pivotal Software",
    "Pixelworks",
    "Plains All American Pipeline",
    "Plains Group Holdings",
    "Planet Fitness",
    "Planet Green Holdings Corp",
    "Plantronics",
    "Platinum Group Metals Ltd.",
    "PlayAGS",
    "Playa Hotels & Resorts N.V.",
    "Plexus Corp.",
    "Plug Power",
    "Plumas Bancorp",
    "Pluralsight",
    "Pluristem Therapeutics",
    "Plymouth Industrial REIT",
    "Pointer Telocation Ltd.",
    "Points International",
    "Polar Power",
    "Polaris Inc.",
    "PolarityTE",
    "PolyOne Corporation",
    "PolyPid Ltd.",
    "Polymet Mining Corp.",
    "Pool Corporation",
    "Pope Resources",
    "Popular",
    "Portland General Electric Company",
    "Portman Ridge Finance Corporation",
    "Portola Pharmaceuticals",
    "Positive Physicians Holdings",
    "Post Holdings",
    "Postal Realty Trust",
    "Potbelly Corporation",
    "PotlatchDeltic Corporation",
    "Powell Industries",
    "Power Integrations",
    "Power REIT",
    "Powerbridge Technologies Co.",
    "Precipio",
    "Precision BioSciences",
    "Precision Drilling Corporation",
    "Predictive Oncology Inc.",
    "Preferred Apartment Communities",
    "Preferred Bank",
    "Preformed Line Products Company",
    "Premier",
    "Premier Financial Bancorp",
    "Presidio",
    "Pressure BioSciences",
    "Prestige Consumer Healthcare Inc.",
    "Pretium Resources",
    "Prevail Therapeutics Inc.",
    "PriceSmart",
    "PrimeEnergy Resources Corporation",
    "Primerica",
    "Primo Water Corporation",
    "Primoris Services Corporation",
    "Principal Contrarian Value Index ETF",
    "Principal Financial Group Inc",
    "Principal Healthcare Innovators Index ETF",
    "Principal International Multi-Factor Core Index ETF",
    "Principal Millennials Index ETF",
    "Principal Price Setters Index ETF",
    "Principal Real Estate Income Fund",
    "Principal Shareholder Yield Index ETF",
    "Principal Sustainable Momentum Index ETF",
    "Principal U.S. Large-Cap Multi-Factor Core Index ETF",
    "Principal U.S. Mega-Cap Multi-Factor Index ETF",
    "Principal U.S. Small-Cap Multi-Factor Index ETF",
    "Principal U.S. Small-MidCap Multi-Factor Core Index ETF",
    "Principia Biopharma Inc.",
    "Priority Income Fund",
    "Priority Technology Holdings",
    "Pro-Dex",
    "ProAssurance Corporation",
    "ProLung",
    "ProPetro Holding Corp.",
    "ProPhase Labs",
    "ProQR Therapeutics N.V.",
    "ProShares Equities for Rising Rates ETF",
    "ProShares Ultra Nasdaq Biotechnology",
    "ProShares UltraPro QQQ",
    "ProShares UltraPro Short NASDAQ Biotechnology",
    "ProShares UltraPro Short QQQ",
    "ProShares UltraShort Nasdaq Biotechnology",
    "ProSight Global",
    "Procter & Gamble Company (The)",
    "Professional Diversity Network",
    "Proficient Alpha Acquisition Corp.",
    "Profire Energy",
    "Progenics Pharmaceuticals Inc.",
    "Progress Software Corporation",
    "Progressive Corporation (The)",
    "Prologis",
    "Proofpoint",
    "Proshares UltraPro Nasdaq Biotechnology",
    "Prospect Capital Corporation",
    "Prosperity Bancshares",
    "Protagonist Therapeutics",
    "Protalix BioTherapeutics",
    "Protective Insurance Corporation",
    "Proteon Therapeutics",
    "Proteostasis Therapeutics",
    "Prothena Corporation plc",
    "Proto Labs",
    "Provention Bio",
    "Provident Bancorp",
    "Provident Financial Holdings",
    "Provident Financial Services",
    "Prudential Bancorp",
    "Prudential Financial",
    "Prudential Public Limited Company",
    "Psychemedics Corporation",
    "Public Service Enterprise Group Incorporated",
    "Public Storage",
    "Pulmatrix",
    "Pulse Biosciences",
    "PulteGroup",
    "Puma Biotechnology Inc",
    "Pure Acquisition Corp.",
    "Pure Cycle Corporation",
    "Pure Storage",
    "Purple Innovation",
    "Putnam Managed Municipal Income Trust",
    "Putnam Master Intermediate Income Trust",
    "Putnam Municipal Opportunities Trust",
    "Putnam Premier Income Trust",
    "Puxin Limited",
    "Puyi Inc.",
    "Pyxis Tankers Inc.",
    "Pyxus International",
    "Pzena Investment Management Inc",
    "Q2 Holdings",
    "QAD Inc.",
    "QCR Holdings",
    "QEP Resources",
    "QIWI plc",
    "QTS Realty Trust",
    "QUALCOMM Incorporated",
    "QVC",
    "Qiagen N.V.",
    "Qorvo",
    "Quad Graphics",
    "Quaker Chemical Corporation",
    "Qualstar Corporation",
    "Qualys",
    "Quanex Building Products Corporation",
    "Quanta Services",
    "Quanterix Corporation",
    "Quarterhill Inc.",
    "Qudian Inc.",
    "Quest Diagnostics Incorporated",
    "Quest Resource Holding Corporation",
    "QuickLogic Corporation",
    "Quidel Corporation",
    "QuinStreet",
    "Quintana Energy Services Inc.",
    "Qumu Corporation",
    "Quorum Health Corporation",
    "Quotient Limited",
    "Quotient Technology Inc.",
    "Qurate Retail",
    "Qutoutiao Inc.",
    "Qwest Corporation",
    "R.R. Donnelley & Sons Company",
    "R1 RCM Inc.",
    "RADA Electronic Industries Ltd.",
    "RAPT Therapeutics",
    "RBB Bancorp",
    "RBC Bearings Incorporated",
    "RCI Hospitality Holdings",
    "RCM Technologies",
    "RE/MAX Holdings",
    "REGENXBIO Inc.",
    "RELX PLC",
    "RENN Fund",
    "REV Group",
    "REX American Resources Corporation",
    "RF Industries",
    "RGC Resources Inc.",
    "RH",
    "RISE Education Cayman Ltd",
    "RLI Corp.",
    "RLJ Lodging Trust",
    "RMG Acquisition Corp.",
    "RMR Real Estate Income Fund",
    "RPC",
    "RPM International Inc.",
    "RPT Realty",
    "RTI Surgical Holdings",
    "RTW Retailwinds",
    "RYB Education",
    "Ra Medical Systems",
    "Ra Pharmaceuticals",
    "RadNet",
    "Radcom Ltd.",
    "Radian Group Inc.",
    "Radiant Logistics",
    "Radius Health",
    "Radware Ltd.",
    "Rafael Holdings",
    "Ralph Lauren Corporation",
    "Ramaco Resources",
    "Rambus",
    "Rand Capital Corporation",
    "Randolph Bancorp",
    "Range Resources Corporation",
    "Ranger Energy Services",
    "Ranpak Holdings Corp",
    "Rapid7",
    "Rattler Midstream LP",
    "Rave Restaurant Group",
    "Raven Industries",
    "Raymond James Financial",
    "Rayonier Advanced Materials Inc.",
    "Rayonier Inc.",
    "Raytheon Company",
    "ReTo Eco-Solutions",
    "ReWalk Robotics Ltd.",
    "Reading International Inc",
    "Ready Capital Corporation",
    "RealNetworks",
    "RealPage",
    "Reality Shares Nasdaq NexGen Economy China ETF",
    "Reality Shares Nasdaq NextGen Economy ETF",
    "Realogy Holdings Corp.",
    "Realty Income Corporation",
    "Reata Pharmaceuticals",
    "Reaves Utility Income Fund",
    "Recon Technology",
    "Recro Pharma",
    "Red Lion Hotels Corporation",
    "Red River Bancshares",
    "Red Robin Gourmet Burgers",
    "Red Rock Resorts",
    "Red Violet",
    "Redfin Corporation",
    "Redhill Biopharma Ltd.",
    "Redwood Trust",
    "Reebonz Holding Limited",
    "Reeds",
    "Regal Beloit Corporation",
    "Regalwood Global Energy Ltd.",
    "Regency Centers Corporation",
    "Regeneron Pharmaceuticals",
    "Regional Health Properties",
    "Regional Management Corp.",
    "Regions Financial Corporation",
    "Regis Corporation",
    "Regulus Therapeutics Inc.",
    "Reinsurance Group of America",
    "Rekor Systems",
    "Reliance Steel & Aluminum Co.",
    "Reliant Bancorp",
    "Reliv&#39; International",
    "Remark Holdings",
    "RenaissanceRe Holdings Ltd.",
    "Renasant Corporation",
    "Renesola Ltd.",
    "Renewable Energy Group",
    "Renren Inc.",
    "Rent-A-Center Inc.",
    "Repay Holdings Corporation",
    "Replay Acquisition Corp.",
    "Repligen Corporation",
    "Replimune Group",
    "Republic Bancorp",
    "Republic First Bancorp",
    "Republic Services",
    "ResMed Inc.",
    "Research Frontiers Incorporated",
    "Resideo Technologies",
    "Resolute Forest Products Inc.",
    "Resonant Inc.",
    "Resources Connection",
    "Restaurant Brands International Inc.",
    "Restoration Robotics",
    "Retail Opportunity Investments Corp.",
    "Retail Properties of America",
    "Retail Value Inc.",
    "Retractable Technologies",
    "Retrophin",
    "Revance Therapeutics",
    "Reven Housing REIT",
    "Revlon",
    "Revolution Lighting Technologies",
    "Revolve Group",
    "Rexahn Pharmaceuticals",
    "Rexford Industrial Realty",
    "Rexnord Corporation",
    "Rhinebeck Bancorp",
    "Rhythm Pharmaceuticals",
    "Ribbon Communications Inc. ",
    "RiceBran Technologies",
    "Richardson Electronics",
    "Richmond Mutual Bancorporation",
    "RigNet",
    "Rigel Pharmaceuticals",
    "Rimini Street",
    "Ring Energy",
    "Ringcentral",
    "Rio Tinto Plc",
    "Riot Blockchain",
    "Ritchie Bros. Auctioneers Incorporated",
    "Rite Aid Corporation",
    "Ritter Pharmaceuticals",
    "RiverNorth Managed Duration Municipal Income Fund",
    "RiverNorth Marketplace Lending Corporation",
    "RiverNorth Opportunistic Municipal Income Fund",
    "RiverNorth Opportunities Fund",
    "RiverNorth/DoubleLine Strategic Opportunity Fund",
    "Riverview Bancorp Inc",
    "Riverview Financial Corporation",
    "Roadrunner Transportation Systems",
    "Roan Resources",
    "Robert Half International Inc.",
    "Rocket Pharmaceuticals",
    "Rockwell Automation",
    "Rockwell Medical",
    "Rocky Brands",
    "Rocky Mountain Chocolate Factory",
    "Rogers Communication",
    "Rogers Corporation",
    "Roku",
    "Rollins",
    "Roper Technologies",
    "Rosehill Resources Inc.",
    "Rosetta Stone",
    "Ross Stores",
    "Royal Bank Of Canada",
    "Royal Bank Scotland plc (The)",
    "Royal Caribbean Cruises Ltd.",
    "Royal Dutch Shell PLC",
    "Royal Gold",
    "Royce Global Value Trust",
    "Royce Micro-Cap Trust",
    "Royce Value Trust",
    "Rubicon Technology",
    "Rubius Therapeutics",
    "Rudolph Technologies",
    "Ruhnn Holding Limited",
    "RumbleOn",
    "Rush Enterprises",
    "Ruth&#39;s Hospitality Group",
    "Ryanair Holdings plc",
    "Ryder System",
    "Ryerson Holding Corporation",
    "Ryman Hospitality Properties",
    "S&P Global Inc.",
    "S&T Bancorp",
    "S&W Seed Company",
    "SAExploration Holdings",
    "SAP SE",
    "SB Financial Group",
    "SB One Bancorp",
    "SBA Communications Corporation",
    "SC Health Corporation",
    "SCIENCE APPLICATIONS INTERNATIONAL CORPORATION",
    "SCWorx Corp.",
    "SCYNEXIS",
    "SEACOR Holdings",
    "SEACOR Marine Holdings Inc.",
    "SEI Investments Company",
    "SELLAS Life Sciences Group",
    "SG Blocks",
    "SGOCO Group",
    "SI-BONE",
    "SIFCO Industries",
    "SIGA Technologies Inc.",
    "SINOPEC Shangai Petrochemical Company",
    "SIRVA",
    "SITE Centers Corp.",
    "SITO Mobile",
    "SJW Group",
    "SK Telecom Co.",
    "SL Green Realty Corp",
    "SLM Corporation",
    "SM Energy Company",
    "SMART Global Holdings",
    "SMTC Corporation",
    "SORL Auto Parts",
    "SP Plus Corporation",
    "SPAR Group",
    "SPDR Dorsey Wright Fixed Income Allocation ETF",
    "SPI Energy Co.",
    "SPS Commerce",
    "SPX Corporation",
    "SPX FLOW",
    "SRAX",
    "SRC Energy Inc.",
    "SS&C Technologies Holdings",
    "SSR Mining Inc.",
    "STAAR Surgical Company",
    "STARWOOD PROPERTY TRUST",
    "STERIS plc",
    "STMicroelectronics N.V.",
    "STORE Capital Corporation",
    "STRATS Trust",
    "SVB Financial Group",
    "SVMK Inc.",
    "Sabine Royalty Trust",
    "Sabra Health Care REIT",
    "Sabre Corporation",
    "Sachem Capital Corp.",
    "Safe Bulkers",
    "Safe-T Group Ltd.",
    "Safeguard Scientifics",
    "Safehold Inc.",
    "Safety Insurance Group",
    "Saga Communications",
    "Sage Therapeutics",
    "Saia",
    "SailPoint Technologies Holdings",
    "Salarius Pharmaceuticals",
    "Salem Media Group",
    "Salesforce.com Inc",
    "Salient Midstream & MLP Fund",
    "Salisbury Bancorp",
    "Sally Beauty Holdings",
    "San Juan Basin Royalty Trust",
    "Sanchez Midstream Partners LP",
    "SandRidge Energy",
    "SandRidge Mississippian Trust I",
    "SandRidge Mississippian Trust II",
    "SandRidge Permian Trust",
    "Sanderson Farms",
    "Sandstorm Gold Ltd",
    "Sandy Spring Bancorp",
    "Sangamo Therapeutics",
    "Sanmina Corporation",
    "Sanofi",
    "Santander Consumer USA Holdings Inc.",
    "Sapiens International Corporation N.V.",
    "Saratoga Investment Corp",
    "Sarepta Therapeutics",
    "Sasol Ltd.",
    "Saul Centers",
    "Savara",
    "ScanSource",
    "Schlumberger N.V.",
    "Schmitt Industries",
    "Schneider National",
    "Schnitzer Steel Industries",
    "Scholar Rock Holding Corporation",
    "Scholastic Corporation",
    "Schultze Special Purpose Acquisition Corp.",
    "Schweitzer-Mauduit International",
    "SciPlay Corporation",
    "Scientific Games Corp",
    "Scorpio Bulkers Inc.",
    "Scorpio Tankers Inc.",
    "Scotts Miracle-Gro Company (The)",
    "Scudder Municiple Income Trust",
    "Scudder Strategic Municiple Income Trust",
    "Scully Royalty Ltd.",
    "Sea Limited",
    "SeaChange International",
    "SeaSpine Holdings Corporation",
    "SeaWorld Entertainment",
    "Seaboard Corporation",
    "Seabridge Gold",
    "Seacoast Banking Corporation of Florida",
    "Seadrill Limited",
    "Seagate Technology PLC",
    "Sealed Air Corporation",
    "Seanergy Maritime Holdings Corp",
    "Sears Hometown and Outlet Stores",
    "Seaspan Corporation",
    "Seattle Genetics",
    "Second Sight Medical Products",
    "Secoo Holding Limited",
    "SecureWorks Corp.",
    "Security National Financial Corporation",
    "Seelos Therapeutics",
    "Select Asset Inc.",
    "Select Bancorp",
    "Select Energy Services",
    "Select Interior Concepts",
    "Select Medical Holdings Corporation",
    "Selecta Biosciences",
    "Selective Insurance Group",
    "Semgroup Corporation",
    "SemiLEDS Corporation",
    "Sempra Energy",
    "Semtech Corporation",
    "Seneca Foods Corp.",
    "SenesTech",
    "Senior Housing Properties Trust",
    "Senmiao Technology Limited",
    "Sensata Technologies Holding plc",
    "Senseonics Holdings",
    "Sensient Technologies Corporation",
    "Sensus Healthcare",
    "Sentinel Energy Services Inc.",
    "Sequans Communications S.A.",
    "Sequential Brands Group",
    "Seres Therapeutics",
    "Seritage Growth Properties",
    "Service Corporation International",
    "ServiceMaster Global Holdings",
    "ServiceNow",
    "ServiceSource International",
    "ServisFirst Bancshares",
    "Servotronics",
    "Sesen Bio",
    "Severn Bancorp Inc",
    "Shake Shack",
    "SharpSpring",
    "Sharps Compliance Corp.",
    "Shaw Communications Inc.",
    "Shell Midstream Partners",
    "Shenandoah Telecommunications Co",
    "Sherwin-Williams Company (The)",
    "ShiftPixy",
    "Shiloh Industries",
    "Shimmick Construction Company",
    "Shineco",
    "Shinhan Financial Group Co Ltd",
    "Ship Finance International Limited",
    "ShockWave Medical",
    "Shoe Carnival",
    "Shopify Inc.",
    "Shore Bancshares Inc",
    "ShotSpotter",
    "Shutterfly",
    "Shutterstock",
    "SiNtx Technologies",
    "Sibanye Gold Limited",
    "Siebert Financial Corp.",
    "Sienna Biopharmaceuticals",
    "Sientra",
    "Sierra Bancorp",
    "Sierra Metals Inc.",
    "Sierra Oncology",
    "Sierra Wireless",
    "Sify Technologies Limited",
    "Sigma Labs",
    "SigmaTron International",
    "Signature Bank",
    "Signet Jewelers Limited",
    "Silgan Holdings Inc.",
    "Silicom Ltd",
    "Silicon Laboratories",
    "Silicon Motion Technology Corporation",
    "Silk Road Medical",
    "Silver Spike Acquisition Corp.",
    "SilverBow Resorces",
    "SilverCrest Metals Inc.",
    "SilverSun Technologies",
    "Silvercorp Metals Inc.",
    "Silvercrest Asset Management Group Inc.",
    "Simmons First National Corporation",
    "Simon Property Group",
    "Simpson Manufacturing Company",
    "Simulations Plus",
    "Sina Corporation",
    "Sinclair Broadcast Group",
    "Sino-Global Shipping America",
    "Sinovac Biotech",
    "Sirius International Insurance Group",
    "Sirius XM Holdings Inc.",
    "SiteOne Landscape Supply",
    "Six Flags Entertainment Corporation New",
    "Skechers U.S.A.",
    "Sky Solar Holdings",
    "SkyWest",
    "Skyline Champion Corporation",
    "Skyworks Solutions",
    "Slack Technologies",
    "Sleep Number Corporation",
    "Smart Sand",
    "SmartFinancial",
    "Smartsheet Inc.",
    "SmileDirectClub",
    "Smith & Nephew SNATS",
    "Smith Micro Software",
    "Snap Inc.",
    "Snap-On Incorporated",
    "So-Young International Inc.",
    "SoFi Gig Economy ETF",
    "Social Capital Hedosophia Holdings Corp.",
    "Sociedad Quimica y Minera S.A.",
    "Socket Mobile",
    "Sogou Inc.",
    "Sohu.com Limited ",
    "Sol-Gel Technologies Ltd.",
    "Solar Capital Ltd.",
    "Solar Senior Capital Ltd.",
    "SolarEdge Technologies",
    "SolarWinds Corporation",
    "Solaris Oilfield Infrastructure",
    "Soleno Therapeutics",
    "Solid Biosciences Inc.",
    "Soligenix",
    "Solitario Zinc Corp.",
    "Soliton",
    "Sonic Automotive",
    "Sonim Technologies",
    "Sonoco Products Company",
    "Sonoma Pharmaceuticals",
    "Sonos",
    "Sony Corp Ord",
    "Sophiris Bio",
    "Sorrento Therapeutics",
    "Sotheby&#39;s",
    "Sotherly Hotels Inc.",
    "Sound Financial Bancorp",
    "Source Capital",
    "South Jersey Industries",
    "South Mountain Merger Corp.",
    "South Plains Financial",
    "South State Corporation",
    "Southern California Edison Company",
    "Southern Company (The)",
    "Southern Copper Corporation",
    "Southern First Bancshares",
    "Southern Missouri Bancorp",
    "Southern National Bancorp of Virginia",
    "Southside Bancshares",
    "Southwest Airlines Company",
    "Southwest Gas Holdings",
    "Southwest Georgia Financial Corporation",
    "Southwestern Energy Company",
    "Spark Energy",
    "Spark Networks",
    "Spark Therapeutics",
    "Spartan Energy Acquisition Corp",
    "Spartan Motors",
    "SpartanNash Company",
    "Special Opportunities Fund Inc.",
    "Spectrum Brands Holdings",
    "Spectrum Pharmaceuticals",
    "Speedway Motorsports",
    "Spero Therapeutics",
    "Sphere 3D Corp.",
    "Spherix Incorporated",
    "Spire Inc.",
    "Spirit Aerosystems Holdings",
    "Spirit Airlines",
    "Spirit MTA REIT",
    "Spirit Realty Capital",
    "Spirit of Texas Bancshares",
    "Splunk Inc.",
    "Spok Holdings",
    "Sportsman&#39;s Warehouse Holdings",
    "Spotify Technology S.A.",
    "Sprague Resources LP",
    "Spring Bank Pharmaceuticals",
    "SpringWorks Therapeutics",
    "Sprint Corporation",
    "Sprott Focus Trust",
    "Sprouts Farmers Market",
    "Square",
    "St. Joe Company (The)",
    "Stabilis Energy",
    "Staffing 360 Solutions",
    "Stag Industrial",
    "Stage Stores",
    "Stamps.com Inc.",
    "Standard AVB Financial Corp.",
    "Standard Diversified Inc.",
    "Standard Motor Products",
    "Standex International Corporation",
    "Stanley Black & Decker",
    "Stantec Inc",
    "Star Bulk Carriers Corp.",
    "Star Group",
    "StarTek",
    "Starbucks Corporation",
    "State Auto Financial Corporation",
    "State Street Corporation",
    "Stealth BioTherapeutics Corp.",
    "StealthGas",
    "Steel Connect",
    "Steel Dynamics",
    "Steel Partners Holdings LP",
    "Steelcase Inc.",
    "Stein Mart",
    "Stellus Capital Investment Corporation",
    "Stemline Therapeutics",
    "Stepan Company",
    "Stereotaxis",
    "Stericycle",
    "Sterling Bancorp",
    "Sterling Construction Company Inc",
    "Steven Madden",
    "Stewardship Financial Corp",
    "Stewart Information Services Corporation",
    "Stifel Financial Corporation",
    "Stitch Fix",
    "Stock Yards Bancorp",
    "Stoke Therapeutics",
    "Stone Harbor Emerging Markets Income Fund",
    "Stone Harbor Emerging Markets Total Income Fund",
    "StoneCastle Financial Corp",
    "StoneCo Ltd.",
    "StoneMor Partners L.P.",
    "Stoneridge",
    "Strata Skin Sciences",
    "Stratasys",
    "Strategic Education",
    "Strategy Shares Nasdaq 7HANDL Index ETF",
    "Strattec Security Corporation",
    "Stratus Properties Inc.",
    "Streamline Health Solutions",
    "Strongbridge Biopharma plc",
    "Stryker Corporation",
    "Studio City International Holdings Limited",
    "Sturm",
    "Suburban Propane Partners",
    "Sumitomo Mitsui Financial Group Inc",
    "Summer Infant",
    "Summit Financial Group",
    "Summit Hotel Properties",
    "Summit Materials",
    "Summit Midstream Partners",
    "Summit State Bank",
    "Summit Therapeutics plc",
    "Summit Wireless Technologies",
    "Sun Communities",
    "Sun Life Financial Inc.",
    "SunCoke Energy",
    "SunLink Health Systems",
    "SunOpta",
    "SunPower Corporation",
    "SunTrust Banks",
    "Suncor Energy  Inc.",
    "Sundance Energy Australia Limited",
    "Sundial Growers Inc.",
    "Sunesis Pharmaceuticals",
    "Sunlands Technology Group",
    "Sunnova Energy International Inc.",
    "Sunoco LP",
    "Sunrun Inc.",
    "Sunstone Hotel Investors",
    "Sunworks",
    "Super League Gaming",
    "SuperCom",
    "Superconductor Technologies Inc.",
    "Superior Drilling Products",
    "Superior Energy Services",
    "Superior Group of Companies",
    "Superior Industries International",
    "Supernus Pharmaceuticals",
    "Surface Oncology",
    "Surgery Partners",
    "Surmodics",
    "Sutro Biopharma",
    "Sutter Rock Capital Corp.",
    "Suzano S.A.",
    "Swiss Helvetia Fund",
    "Switch",
    "Switchback Energy Acquisition Corporation",
    "Sykes Enterprises",
    "Symantec Corporation",
    "Synacor",
    "Synalloy Corporation",
    "Synaptics Incorporated",
    "Synchronoss Technologies",
    "Synchrony Financial",
    "Syndax Pharmaceuticals",
    "Syneos Health",
    "Synlogic",
    "Synnex Corporation",
    "Synopsys",
    "Synovus Financial Corp.",
    "Synthesis Energy Systems",
    "Synthetic Biologics",
    "Synthetic Fixed-Income Securities",
    "Synthorx",
    "Sypris Solutions",
    "Syros Pharmaceuticals",
    "Sysco Corporation",
    "Systemax Inc.",
    "T-Mobile US",
    "T. Rowe Price Group",
    "T2 Biosystems",
    "TAL Education Group",
    "TAT Technologies Ltd.",
    "TC Energy Corporation",
    "TC PipeLines",
    "TCF Financial Corporation",
    "TCG BDC",
    "TCR2 Therapeutics Inc.",
    "TCW Strategic Income Fund",
    "TD Ameritrade Holding Corporation",
    "TDH Holdings",
    "TE Connectivity Ltd.",
    "TEGNA Inc.",
    "TELUS Corporation",
    "TESSCO Technologies Incorporated",
    "TFS Financial Corporation",
    "TG Therapeutics",
    "THL Credit",
    "THL Credit Senior Loan Fund",
    "TIM Participacoes S.A.",
    "TJX Companies",
    "TKK Symphony Acquisition Corporation",
    "TMSR Holding Company Limited",
    "TOP Ships Inc.",
    "TORM plc",
    "TPG Pace Holdings Corp.",
    "TPG RE Finance Trust",
    "TPG Specialty Lending",
    "TPI Composites",
    "TRACON Pharmaceuticals",
    "TRI Pointe Group",
    "TSR",
    "TTEC Holdings",
    "TTM Technologies",
    "Tabula Rasa HealthCare",
    "Tactile Systems Technology",
    "Tailored Brands",
    "Taitron Components Incorporated",
    "Taiwan Fund",
    "Taiwan Liposome Company",
    "Taiwan Semiconductor Manufacturing Company Ltd.",
    "Take-Two Interactive Software",
    "Takeda Pharmaceutical Company Limited",
    "Takung Art Co.",
    "Talend S.A.",
    "Tallgrass Energy",
    "Talos Energy",
    "Tandem Diabetes Care",
    "Tandy Leather Factory",
    "Tanger Factory Outlet Centers",
    "Tantech Holdings Ltd.",
    "Tanzanian Gold Corporation",
    "Taoping Inc.",
    "Tapestry",
    "Tarena International",
    "Targa Resources",
    "Targa Resources Partners LP",
    "Target Corporation",
    "Target Hospitality Corp.",
    "Taro Pharmaceutical Industries Ltd.",
    "Taronis Technologies",
    "Taseko Mines Limited",
    "Tata Motors Ltd",
    "Taubman Centers",
    "Taylor Devices",
    "Taylor Morrison Home Corporation",
    "Team",
    "Tech Data Corporation",
    "TechTarget",
    "Technical Communications Corporation",
    "TechnipFMC plc",
    "Teck Resources Ltd",
    "Tecnoglass Inc.",
    "Tecogen Inc.",
    "Tectonic Financial",
    "Teekay Corporation",
    "Teekay LNG Partners L.P.",
    "Teekay Offshore Partners L.P.",
    "Teekay Tankers Ltd.",
    "Tejon Ranch Co",
    "Tekla Healthcare Investors",
    "Tekla Healthcare Opportunies Fund",
    "Tekla Life Sciences Investors",
    "Tekla World Healthcare Fund",
    "Teladoc Health",
    "Telaria",
    "Telecom Argentina Stet - France Telecom S.A.",
    "Teledyne Technologies Incorporated",
    "Teleflex Incorporated",
    "Telefonica Brasil S.A.",
    "Telefonica SA",
    "Telenav",
    "Telephone and Data Systems",
    "Teligent",
    "Tellurian Inc.",
    "Templeton Dragon Fund",
    "Templeton Emerging Markets Fund",
    "Templeton Emerging Markets Income Fund",
    "Templeton Global Income Fund",
    "Tempur Sealy International",
    "Tenable Holdings",
    "Tenaris S.A.",
    "Tenax Therapeutics",
    "Tencent Music Entertainment Group",
    "Tenet Healthcare Corporation",
    "Tengasco",
    "Tennant Company",
    "Tenneco Inc.",
    "Tennessee Valley Authority",
    "Tenzing Acquisition Corp.",
    "Teradata Corporation",
    "Teradyne",
    "Terex Corporation",
    "Ternium S.A.",
    "TerraForm Power",
    "Terreno Realty Corporation",
    "Territorial Bancorp Inc.",
    "Tesla",
    "Tetra Tech",
    "Tetra Technologies",
    "Tetraphase Pharmaceuticals",
    "Teva Pharmaceutical Industries Limited",
    "Texas Capital Bancshares",
    "Texas Instruments Incorporated",
    "Texas Pacific Land Trust",
    "Texas Roadhouse",
    "Textainer Group Holdings Limited",
    "Textron Inc.",
    "The AES Corporation",
    "The Alkaline Water Company Inc.",
    "The Andersons",
    "The Bancorp",
    "The Bank of Princeton",
    "The Blackstone Group Inc.",
    "The Carlyle Group L.P.",
    "The Central and Eastern Europe Fund",
    "The Charles Schwab Corporation",
    "The Cheesecake Factory Incorporated",
    "The Chefs&#39; Warehouse",
    "The Community Financial Corporation",
    "The Cooper Companies",
    "The Descartes Systems Group Inc.",
    "The Dixie Group",
    "The Ensign Group",
    "The ExOne Company",
    "The First Bancshares",
    "The First of Long Island Corporation",
    "The GDL Fund",
    "The Gabelli Dividend & Income Trust",
    "The Gabelli Global Utility and Income Trust",
    "The Gabelli Go Anywhere Trust",
    "The Gabelli Healthcare & Wellness Trust",
    "The Goodyear Tire & Rubber Company",
    "The Habit Restaurants",
    "The Hackett Group",
    "The Hain Celestial Group",
    "The Hanover Insurance Group",
    "The Herzfeld Caribbean Basin Fund",
    "The Intergroup Corporation",
    "The Joint Corp.",
    "The Kraft Heinz Company",
    "The Long-Term Care ETF",
    "The Lovesac Company",
    "The Madison Square Garden Company",
    "The Medicines Company",
    "The Meet Group",
    "The Michaels Companies",
    "The Middleby Corporation",
    "The ONE Group Hospitality",
    "The Obesity ETF",
    "The Organics ETF",
    "The Peck Company Holdings",
    "The Providence Service Corporation",
    "The RMR Group Inc.",
    "The RealReal",
    "The Rubicon Project",
    "The Simply Good Foods Company",
    "The Stars Group Inc.",
    "The Trade Desk",
    "The Travelers Companies",
    "The Vivaldi Opportunities Fund",
    "The York Water Company",
    "The9 Limited",
    "TherapeuticsMD",
    "Therapix Biosciences Ltd.",
    "Theravance Biopharma",
    "Thermo Fisher Scientific Inc",
    "Thermon Group Holdings",
    "Third Point Reinsurance Ltd.",
    "Thomson Reuters Corp",
    "Thor Industries",
    "Thunder Bridge Acquisition II",
    "TiVo Corporation",
    "Tiberius Acquisition Corporation",
    "Tidewater Inc.",
    "Tiffany & Co.",
    "Tile Shop Hldgs",
    "Tilly&#39;s",
    "Tilray",
    "Timberland Bancorp",
    "Timken Company (The)",
    "TimkenSteel Corporation",
    "Tiptree Inc.",
    "Titan International",
    "Titan Machinery Inc.",
    "Titan Medical Inc.",
    "Titan Pharmaceuticals",
    "Tivity Health",
    "Tiziana Life Sciences plc",
    "Tocagen Inc.",
    "Toll Brothers",
    "Tompkins Financial Corporation",
    "Tonix Pharmaceuticals Holding Corp.",
    "Tootsie Roll Industries",
    "TopBuild Corp.",
    "Torchlight Energy Resources",
    "Toro Company (The)",
    "Toronto Dominion Bank (The)",
    "Tortoise Acquisition Corp.",
    "Tortoise Energy Independence Fund",
    "Tortoise Energy Infrastructure Corporation",
    "Tortoise Essential Assets Income Term Fund",
    "Tortoise Midstream Energy Fund",
    "Tortoise Pipeline & Energy Fund",
    "Tortoise Power and Energy Infrastructure Fund",
    "Total S.A.",
    "Total System Services",
    "Tottenham Acquisition I Limited",
    "ToughBuilt Industries",
    "Tower International",
    "Tower Semiconductor Ltd.",
    "Town Sports International Holdings",
    "Towne Bank",
    "Townsquare Media",
    "Toyota Motor Corp Ltd Ord",
    "Tractor Supply Company",
    "Tradeweb Markets Inc.",
    "Trans World Entertainment Corp.",
    "TransAct Technologies Incorporated",
    "TransAlta Corporation",
    "TransEnterix",
    "TransGlobe Energy Corporation",
    "TransMedics Group",
    "TransUnion",
    "Transatlantic Petroleum Ltd",
    "Transcat",
    "Transcontinental Realty Investors",
    "Transdigm Group Incorporated",
    "Translate Bio",
    "Transocean Ltd.",
    "Transportadora De Gas Sa Ord B",
    "TravelCenters of America Inc. ",
    "Travelzoo",
    "Trecora Resources",
    "Tredegar Corporation",
    "Treehouse Foods",
    "Tremont Mortgage Trust",
    "Trevena",
    "Trevi Therapeutics",
    "Trex Company",
    "Tri Continental Corporation",
    "TriCo Bancshares",
    "TriMas Corporation",
    "TriNet Group",
    "TriState Capital Holdings",
    "Tribune Media Company",
    "Tribune Publishing Company",
    "Tricida",
    "Trident Acquisitions Corp.",
    "Trillium Therapeutics Inc.",
    "Trilogy Metals Inc.",
    "Trimble Inc.",
    "Trine Acquisition Corp.",
    "Trinity Biotech plc",
    "Trinity Industries",
    "Trinity Merger Corp.",
    "Trinity Place Holdings Inc.",
    "Trinseo S.A.",
    "Trio-Tech International",
    "TripAdvisor",
    "Triple-S Management Corporation",
    "TriplePoint Venture Growth BDC Corp.",
    "Triton International Limited",
    "Triumph Bancorp",
    "Triumph Group",
    "Tronox Holdings plc",
    "TrovaGene",
    "TrueBlue",
    "TrueCar",
    "Trupanion",
    "TrustCo Bank Corp NY",
    "Trustmark Corporation",
    "Tsakos Energy Navigation Ltd",
    "TuanChe Limited",
    "Tucows Inc.",
    "Tuesday Morning Corp.",
    "Tufin Software Technologies Ltd.",
    "Tuniu Corporation",
    "Tupperware Brands Corporation",
    "Turkcell Iletisim Hizmetleri AS",
    "Turning Point Brands",
    "Turning Point Therapeutics",
    "Turquoise Hill Resources Ltd.",
    "Turtle Beach Corporation",
    "Tuscan Holdings Corp.",
    "Tuscan Holdings Corp. II",
    "Tutor Perini Corporation",
    "Twelve Seas Investment Company",
    "Twilio Inc.",
    "Twin Disc",
    "Twin River Worldwide Holdings",
    "Twist Bioscience Corporation",
    "Twitter",
    "Two Harbors Investments Corp",
    "Two River Bancorp",
    "Tyler Technologies",
    "Tyme Technologies",
    "Tyson Foods",
    "U S Concrete",
    "U.S. Auto Parts Network",
    "U.S. Bancorp",
    "U.S. Energy Corp.",
    "U.S. Global Investors",
    "U.S. Gold Corp.",
    "U.S. Physical Therapy",
    "U.S. Silica Holdings",
    "U.S. Well Services",
    "U.S. Xpress Enterprises",
    "UBS AG",
    "UDR",
    "UFP Technologies",
    "UGI Corporation",
    "UMB Financial Corporation",
    "UMH Properties",
    "UNITIL Corporation",
    "UNIVERSAL INSURANCE HOLDINGS INC",
    "UP Fintech China-U.S. Internet Titans ETF",
    "UP Fintech Holding Limited",
    "US Ecology",
    "US Foods Holding Corp.",
    "USA Compression Partners",
    "USA Technologies",
    "USA Truck",
    "USANA Health Sciences",
    "USD Partners LP",
    "USLIFE Income Fund",
    "UTStarcom Holdings Corp",
    "Uber Technologies",
    "Ubiquiti Inc.",
    "Ulta Beauty",
    "Ultra Clean Holdings",
    "Ultragenyx Pharmaceutical Inc.",
    "Ultralife Corporation",
    "Ultrapar Participacoes S.A.",
    "Umpqua Holdings Corporation",
    "Under Armour",
    "Unico American Corporation",
    "Unifi",
    "Unifirst Corporation",
    "Unilever NV",
    "Unilever PLC",
    "Union Bankshares",
    "Union Pacific Corporation",
    "Unique Fabricating",
    "Unisys Corporation",
    "Unit Corporation",
    "United Airlines Holdings",
    "United Bancorp",
    "United Bancshares",
    "United Bankshares",
    "United Community Banks",
    "United Community Financial Corp.",
    "United Financial Bancorp",
    "United Fire Group",
    "United Insurance Holdings Corp.",
    "United Microelectronics Corporation",
    "United Natural Foods",
    "United Parcel Service",
    "United Rentals",
    "United Security Bancshares",
    "United States Antimony Corporation",
    "United States Cellular Corporation",
    "United States Lime & Minerals",
    "United States Steel Corporation",
    "United Technologies Corporation",
    "United Therapeutics Corporation",
    "United-Guardian",
    "UnitedHealth Group Incorporated",
    "Uniti Group Inc.",
    "Unity Bancorp",
    "Unity Biotechnology",
    "Univar Solutions Inc.",
    "Universal Corporation",
    "Universal Display Corporation",
    "Universal Electronics Inc.",
    "Universal Forest Products",
    "Universal Health Realty Income Trust",
    "Universal Health Services",
    "Universal Logistics Holdings",
    "Universal Security Instruments",
    "Universal Stainless & Alloy Products",
    "Universal Technical Institute Inc",
    "Univest Financial Corporation",
    "Unum Group",
    "Unum Therapeutics Inc.",
    "Upland Software",
    "Upwork Inc.",
    "Ur Energy Inc",
    "Uranium Energy Corp.",
    "Urban Edge Properties",
    "Urban One",
    "Urban Outfitters",
    "Urban Tea",
    "UroGen Pharma Ltd.",
    "Urovant Sciences Ltd.",
    "Urstadt Biddle Properties Inc.",
    "Usio",
    "Utah Medical Products",
    "Uxin Limited",
    "V.F. Corporation",
    "VAALCO Energy",
    "VALE S.A.",
    "VBI Vaccines",
    "VEON Ltd.",
    "VEREIT Inc.",
    "VICI Properties Inc.",
    "VIVUS",
    "VOC Energy Trust",
    "VOXX International Corporation",
    "VSE Corporation",
    "Vaccinex",
    "Vail Resorts",
    "Valaris plc",
    "Valeritas Holdings",
    "Valero Energy Corporation",
    "Valhi",
    "Validea Market Legends ETF",
    "Valley National Bancorp",
    "Valmont Industries",
    "Valtech SE",
    "Value Line",
    "Valvoline Inc.",
    "VanEck Vectors Biotech ETF",
    "VanEck Vectors Pharmaceutical ETF",
    "Vanda Pharmaceuticals Inc.",
    "Vanguard Emerging Markets Government Bond ETF",
    "Vanguard Global ex-U.S. Real Estate ETF",
    "Vanguard Intermediate-Term Corporate Bond ETF",
    "Vanguard Intermediate-Term Treasury ETF",
    "Vanguard International Dividend Appreciation ETF",
    "Vanguard International High Dividend Yield ETF",
    "Vanguard Long-Term Corporate Bond ETF",
    "Vanguard Long-Treasury ETF",
    "Vanguard Mortgage-Backed Securities ETF",
    "Vanguard Russell 1000 ETF",
    "Vanguard Russell 1000 Growth ETF",
    "Vanguard Russell 1000 Value ETF",
    "Vanguard Russell 2000 ETF",
    "Vanguard Russell 2000 Growth ETF",
    "Vanguard Russell 2000 Value ETF",
    "Vanguard Russell 3000 ETF",
    "Vanguard Short-Term Corporate Bond ETF",
    "Vanguard Short-Term Inflation-Protected Securities Index Fund",
    "Vanguard Short-Term Treasury ETF",
    "Vanguard Total Bond Market ETF",
    "Vanguard Total Corporate Bond ETF",
    "Vanguard Total International Bond ETF",
    "Vanguard Total International Stock ETF",
    "Vanguard Total World Bond ETF",
    "Vapotherm",
    "Varex Imaging Corporation",
    "Varian Medical Systems",
    "Varonis Systems",
    "Vascular Biogenics Ltd.",
    "Vaxart",
    "VectoIQ Acquisition Corp.",
    "Vector Group Ltd.",
    "Vectrus",
    "Vedanta  Limited",
    "Veeco Instruments Inc.",
    "Veeva Systems Inc.",
    "Venator Materials PLC",
    "Ventas",
    "Veoneer",
    "Vera Bradley",
    "Veracyte",
    "Verastem",
    "Verb Technology Company",
    "VeriSign",
    "Vericel Corporation",
    "Vericity",
    "Verint Systems Inc.",
    "Verisk Analytics",
    "Veritex Holdings",
    "Veritiv Corporation",
    "Veritone",
    "Verizon Communications Inc.",
    "Vermilion Energy Inc.",
    "Vermillion",
    "Verona Pharma plc",
    "Verra Mobility Corporation",
    "Verrica Pharmaceuticals Inc.",
    "Verso Corporation",
    "Versum Materials",
    "Vertex Energy",
    "Vertex Pharmaceuticals Incorporated",
    "Vertical Capital Income Fund",
    "Veru Inc.",
    "ViaSat",
    "Viacom Inc.",
    "Viad Corp",
    "Viamet Pharmaceuticals Corp.",
    "Viavi Solutions Inc.",
    "Vicor Corporation",
    "Victory Capital Holdings",
    "VictoryShares Developed Enhanced Volatility Wtd ETF",
    "VictoryShares Dividend Accelerator ETF",
    "VictoryShares Emerging Market High Div Volatility Wtd ETF",
    "VictoryShares Emerging Market Volatility Wtd ETF",
    "VictoryShares International High Div Volatility Wtd ETF",
    "VictoryShares International Volatility Wtd ETF",
    "VictoryShares US 500 Enhanced Volatility Wtd ETF",
    "VictoryShares US 500 Volatility Wtd ETF",
    "VictoryShares US Discovery Enhanced Volatility Wtd ETF",
    "VictoryShares US EQ Income Enhanced Volatility Wtd ETF",
    "VictoryShares US Large Cap High Div Volatility Wtd ETF",
    "VictoryShares US Multi-Factor Minimum Volatility ETF",
    "VictoryShares US Small Cap High Div Volatility Wtd ETF",
    "VictoryShares US Small Cap Volatility Wtd ETF",
    "Viemed Healthcare",
    "ViewRay",
    "Viking Therapeutics",
    "Village Bank and Trust Financial Corp.",
    "Village Farms International",
    "Village Super Market",
    "Vince Holding Corp.",
    "Viomi Technology Co.",
    "Viper Energy Partners LP",
    "Vipshop Holdings Limited",
    "VirTra",
    "Virco Manufacturing Corporation",
    "Virgin Trains USA Inc.",
    "VirnetX Holding Corp",
    "Virtu Financial",
    "Virtus Global Dividend & Income Fund Inc.",
    "Virtus Global Multi-Sector Income Fund",
    "Virtus Investment Partners",
    "Virtus LifeSci Biotech Clinical Trials ETF",
    "Virtus LifeSci Biotech Products ETF",
    "Virtus Total Return Fund Inc.",
    "Virtusa Corporation",
    "Visa Inc.",
    "Vishay Intertechnology",
    "Vishay Precision Group",
    "Vislink Technologies",
    "Vista Gold Corporation",
    "Vista Oil & Gas",
    "Vista Outdoor Inc.",
    "VistaGen Therapeutics",
    "Visteon Corporation",
    "Visterra",
    "Vistra Energy Corp.",
    "Vitamin Shoppe",
    "Viveve Medical",
    "Vivint Solar",
    "VivoPower International PLC",
    "Vmware",
    "Vocera Communications",
    "Vodafone Group Plc",
    "VolitionRX Limited",
    "Volt Information Sciences",
    "Vonage Holdings Corp.",
    "Vornado Realty Trust",
    "Voya Asia Pacific High Dividend Equity Income Fund",
    "Voya Emerging Markets High Income Dividend Equity Fund",
    "Voya Financial",
    "Voya Global Advantage and Premium Opportunity Fund",
    "Voya Global Equity Dividend and Premium Opportunity Fund",
    "Voya Infrastructure",
    "Voya International High Dividend Equity Income Fund",
    "Voya Natural Resources Equity Income Fund",
    "Voya Prime Rate Trust",
    "Voyager Therapeutics",
    "Vulcan Materials Company",
    "Vuzix Corporation",
    "W&T Offshore",
    "W.P. Carey Inc.",
    "W.R. Berkley Corporation",
    "W.R. Grace & Co.",
    "W.W. Grainger",
    "WAVE Life Sciences Ltd.",
    "WD-40 Company",
    "WEC Energy Group",
    "WESCO International",
    "WEX Inc.",
    "WNS (Holdings) Limited",
    "WPP plc",
    "WPX Energy",
    "WSFS Financial Corporation",
    "WVS Financial Corp.",
    "Wabash National Corporation",
    "Wabco Holdings Inc.",
    "Waddell & Reed Financial",
    "Wah Fu Education Group Limited",
    "Wahed FTSE USA Shariah ETF",
    "Waitr Holdings Inc.",
    "Walgreens Boots Alliance",
    "Walker & Dunlop",
    "Walmart Inc.",
    "Walt Disney Company (The)",
    "Wanda Sports Group Company Limited",
    "Warrior Met Coal",
    "Washington Federal",
    "Washington Prime Group Inc.",
    "Washington Real Estate Investment Trust",
    "Washington Trust Bancorp",
    "Waste Connections",
    "Waste Management",
    "Waters Corporation",
    "Waterstone Financial",
    "Watford Holdings Ltd.",
    "Watsco",
    "Watts Water Technologies",
    "Wayfair Inc.",
    "Wayne Farms",
    "Wayside Technology Group",
    "Wealthbridge Acquisition Limited",
    "Webster Financial Corporation",
    "Weibo Corporation",
    "Weidai Ltd.",
    "Weight Watchers International Inc",
    "Weingarten Realty Investors",
    "Weis Markets",
    "Welbilt",
    "WellCare Health Plans",
    "Wellesley Bancorp",
    "Wells Fargo & Company",
    "Wells Fargo Global Dividend Opportunity Fund",
    "Wells Fargo Income Opportunities Fund",
    "Wells Fargo Multi-Sector Income Fund",
    "Wells Fargo Utilities and High Income Fund",
    "Welltower Inc.",
    "Wendy&#39;s Company (The)",
    "Werner Enterprises",
    "WesBanco",
    "Wesco Aircraft Holdings",
    "West Bancorporation",
    "West Pharmaceutical Services",
    "Westamerica Bancorporation",
    "Westell Technologies",
    "Western Alliance Bancorporation",
    "Western Asset Bond Fund",
    "Western Asset Corporate Loan Fund Inc",
    "Western Asset Emerging Markets Debt Fund Inc",
    "Western Asset Global Corporate Defined Opportunity Fund Inc.",
    "Western Asset Global High Income Fund Inc",
    "Western Asset High Income Fund II Inc.",
    "Western Asset High Income Opportunity Fund",
    "Western Asset High Yield Defined Opportunity Fund Inc.",
    "Western Asset Intermediate Muni Fund Inc",
    "Western Asset Investment Grade Defined Opportunity Trust Inc.",
    "Western Asset Investment Grade Income Fund Inc.",
    "Western Asset Managed Municipals Fund",
    "Western Asset Mortgage Capital Corporation",
    "Western Asset Mortgage Defined Opportunity Fund Inc",
    "Western Asset Municipal Defined Opportunity Trust Inc",
    "Western Asset Municipal High Income Fund",
    "Western Asset Municipal Partners Fund",
    "Western Asset Short Duration Income ETF",
    "Western Asset Total Return ETF",
    "Western Asset Variable Rate Strategic Fund Inc.",
    "Western Asset/Claymore U.S Treasury Inflation Prot Secs Fd 2",
    "Western Asset/Claymore U.S. Treasury Inflation Prot Secs Fd",
    "Western Copper and Gold Corporation",
    "Western Digital Corporation",
    "Western Midstream Partners",
    "Western New England Bancorp",
    "Western Union Company (The)",
    "Westinghouse Air Brake Technologies Corporation",
    "Westlake Chemical Corporation",
    "Westlake Chemical Partners LP",
    "Westpac Banking Corporation",
    "Westport Fuel Systems Inc",
    "Westrock Company",
    "Westwater Resources",
    "Westwood Holdings Group Inc",
    "Weyco Group",
    "Weyerhaeuser Company",
    "Wheaton Precious Metals Corp.",
    "Wheeler Real Estate Investment Trust",
    "Whirlpool Corporation",
    "White Mountains Insurance Group",
    "WhiteHorse Finance",
    "Whitestone REIT",
    "Whiting Petroleum Corporation",
    "WideOpenWest",
    "WidePoint Corporation",
    "Wilhelmina International",
    "WillScot Corporation",
    "Willamette Valley Vineyards",
    "Willdan Group",
    "Williams Companies",
    "Williams-Sonoma",
    "Willis Lease Finance Corporation",
    "Willis Towers Watson Public Limited Company",
    "Wingstop Inc.",
    "Winmark Corporation",
    "Winnebago Industries",
    "Wins Finance Holdings Inc.",
    "Wintrust Financial Corporation",
    "Wipro Limited",
    "Wireless Telecom Group",
    "WisdomTree Barclays Negative Duration U.S. Aggregate Bond Fund",
    "WisdomTree China ex-State-Owned Enterprises Fund",
    "WisdomTree Cloud Computing Fund",
    "WisdomTree Emerging Markets Consumer Growth Fund",
    "WisdomTree Emerging Markets Corporate Bond Fund",
    "WisdomTree Emerging Markets Quality Dividend Growth Fund",
    "WisdomTree Germany Hedged Equity Fund",
    "WisdomTree Interest Rate Hedged High Yield Bond Fund",
    "WisdomTree Interest Rate Hedged U.S. Aggregate Bond Fund",
    "WisdomTree Investments",
    "WisdomTree Japan Hedged SmallCap Equity Fund",
    "WisdomTree Middle East Dividend Fund",
    "WisdomTree Negative Duration High Yield Bond Fund",
    "WisdomTree U.S. Quality Dividend Growth Fund",
    "WisdomTree U.S. SmallCap Quality Dividend Growth Fund",
    "Wix.com Ltd.",
    "Wolverine World Wide",
    "Woodward",
    "Woori Bank",
    "Workday",
    "Workhorse Group",
    "Workiva Inc.",
    "World Acceptance Corporation",
    "World Fuel Services Corporation",
    "World Wrestling Entertainment",
    "Worthington Industries",
    "Wrap Technologies",
    "Wright Medical Group N.V.",
    "Wyndham Destinations",
    "Wyndham Hotels & Resorts",
    "Wynn Resorts",
    "X Financial",
    "X4 Pharmaceuticals",
    "XAI Octagon Floating Rate & Alternative Income Term Trust",
    "XBiotech Inc.",
    "XOMA Corporation",
    "XPEL",
    "XPO Logistics",
    "XTL Biopharmaceuticals Ltd.",
    "Xcel Brands",
    "Xcel Energy Inc.",
    "Xencor",
    "Xenetic Biosciences",
    "Xenia Hotels & Resorts",
    "Xenon Pharmaceuticals Inc.",
    "Xeris Pharmaceuticals",
    "Xerox Holdings Corporation",
    "Xilinx",
    "Xinyuan Real Estate Co Ltd",
    "Xperi Corporation",
    "XpresSpa Group",
    "Xtant Medical Holdings",
    "Xunlei Limited",
    "Xylem Inc.",
    "Y-mAbs Therapeutics",
    "YETI Holdings",
    "YPF Sociedad Anonima",
    "YRC Worldwide",
    "YY Inc.",
    "Yamana Gold Inc.",
    "Yandex N.V.",
    "Yatra Online",
    "Yelp Inc.",
    "Yext",
    "Yield10 Bioscience",
    "Yintech Investment Holdings Limited",
    "Yirendai Ltd.",
    "Youngevity International",
    "Yum China Holdings",
    "Yum! Brands",
    "Yuma Energy",
    "Yunji Inc.",
    "ZAGG Inc",
    "ZIOPHARM Oncology Inc",
    "ZK International Group Co.",
    "ZTO Express (Cayman) Inc.",
    "Zafgen",
    "Zai Lab Limited",
    "Zayo Group Holdings",
    "Zealand Pharma A/S",
    "Zebra Technologies Corporation",
    "Zedge",
    "Zendesk",
    "Zillow Group",
    "Zimmer Biomet Holdings",
    "Zion Oil ",
    "Zions Bancorporation N.A.",
    "Zix Corporation",
    "Zoetis Inc.",
    "Zogenix",
    "Zomedica Pharmaceuticals Corp.",
    "Zoom Video Communications",
    "Zosano Pharma Corporation",
    "Zovio Inc.",
    "Zscaler",
    "Zumiez Inc.",
    "Zuora",
    "Zymeworks Inc.",
    "Zynerba Pharmaceuticals",
    "Zynex",
    "Zynga Inc.",
    "aTyr Pharma",
    "argenx SE",
    "bluebird bio",
    "cbdMD",
    "comScore",
    "e.l.f. Beauty",
    "eBay Inc.",
    "eGain Corporation",
    "eHealth",
    "eMagin Corporation",
    "ePlus inc.",
    "eXp World Holdings",
    "electroCore",
    "frontdoor",
    "i3 Verticals",
    "iBio",
    "iClick Interactive Asia Group Limited",
    "iFresh Inc.",
    "iHeartMedia",
    "iMedia Brands",
    "iQIYI",
    "iRadimed Corporation",
    "iRhythm Technologies",
    "iRobot Corporation",
    "iShares 0-5 Year Investment Grade Corporate Bond ETF",
    "iShares 1-3 Year International Treasury Bond ETF",
    "iShares 1-3 Year Treasury Bond ETF",
    "iShares 20+ Year Treasury Bond ETF",
    "iShares 3-7 Year Treasury Bond ETF",
    "iShares 7-10 Year Treasury Bond ETF",
    "iShares Asia 50 ETF",
    "iShares Broad USD Investment Grade Corporate Bond ETF",
    "iShares Commodities Select Strategy ETF",
    "iShares Core 1-5 Year USD Bond ETF",
    "iShares Core MSCI Total International Stock ETF",
    "iShares Core S&P U.S. Growth ETF",
    "iShares Core S&P U.S. Value ETF",
    "iShares Core Total USD Bond Market ETF",
    "iShares Currency Hedged MSCI Germany ETF",
    "iShares ESG 1-5 Year USD Corporate Bond ETF",
    "iShares ESG MSCI EAFE ETF",
    "iShares ESG MSCI EM ETF",
    "iShares ESG MSCI USA ETF",
    "iShares ESG MSCI USA Leaders ETF",
    "iShares ESG USD Corporate Bond ETF",
    "iShares Exponential Technologies ETF",
    "iShares FTSE EPRA/NAREIT Europe Index Fund",
    "iShares FTSE EPRA/NAREIT Global Real Estate ex-U.S. Index Fund",
    "iShares Fallen Angels USD Bond ETF",
    "iShares GNMA Bond ETF",
    "iShares Global Green Bond ETF",
    "iShares Global Infrastructure ETF",
    "iShares Intermediate-Term Corporate Bond ETF",
    "iShares International Treasury Bond ETF",
    "iShares J.P. Morgan USD Emerging Markets Bond ETF",
    "iShares MBS ETF",
    "iShares MSCI ACWI Index Fund",
    "iShares MSCI ACWI ex US Index Fund",
    "iShares MSCI All Country Asia ex Japan Index Fund",
    "iShares MSCI Brazil Small-Cap ETF",
    "iShares MSCI China ETF",
    "iShares MSCI EAFE Small-Cap ETF",
    "iShares MSCI Emerging Markets Asia ETF",
    "iShares MSCI Emerging Markets ex China ETF",
    "iShares MSCI Europe Financials Sector Index Fund",
    "iShares MSCI Europe Small-Cap ETF",
    "iShares MSCI Global Gold Miners ETF",
    "iShares MSCI Global Impact ETF",
    "iShares MSCI Japan Equal Weighted ETF",
    "iShares MSCI Japan Value ETF",
    "iShares MSCI New Zealand ETF",
    "iShares MSCI Qatar ETF",
    "iShares MSCI Turkey ETF",
    "iShares MSCI UAE ETF",
    "iShares Morningstar Mid-Cap ETF",
    "iShares Nasdaq Biotechnology Index Fund",
    "iShares PHLX SOX Semiconductor Sector Index Fund",
    "iShares Preferred and Income Securities ETF",
    "iShares Russell 1000 Pure U.S. Revenue ETF",
    "iShares S&P Emerging Markets Infrastructure Index Fund",
    "iShares S&P Global Clean Energy Index Fund",
    "iShares S&P Global Timber & Forestry Index Fund",
    "iShares S&P India Nifty 50 Index Fund",
    "iShares S&P Small-Cap 600 Growth ETF",
    "iShares Select Dividend ETF",
    "iShares Short Treasury Bond ETF",
    "iShares Short-Term Corporate Bond ETF",
    "iShares iBoxx $ High Yield ex Oil & Gas Corporate Bond ETF",
    "iStar Inc.",
    "icad inc.",
    "inTest Corporation",
    "j2 Global",
    "lululemon athletica inc.",
    "nLIGHT",
    "nVent Electric plc",
    "resTORbio",
    "scPharmaceuticals Inc.",
    "support.com",
    "trivago N.V.",
    "uniQure N.V.",
    "vTv Therapeutics Inc.",
    "voxeljet AG",
]
