import { AIChatModelCard } from '../types/aiModel';

// CometAPI model list based on src/config/modelProviders/cometapi.ts
const cometapiChatModels: AIChatModelCard[] = [
  // GPT-5 series
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 400_000,
    description:
      'GPT-5 is CometAPI’s latest flagship model for cross-domain coding and agent tasks, with major gains in accuracy, speed, reasoning, context awareness, structured thinking, and problem solving.',
    displayName: 'GPT-5-Chat-Latest',
    enabled: true,
    id: 'gpt-5-chat-latest',
    maxOutput: 128_000,
    releasedAt: '2025-08-07',
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 400_000,
    description: 'GPT-5 Mini is a highly cost-effective smart model.',
    displayName: 'GPT-5 Mini',
    enabled: true,
    id: 'gpt-5-mini',
    maxOutput: 128_000,
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 400_000,
    description: 'GPT-5 Nano is the nano variant for lightweight tasks.',
    displayName: 'GPT-5 Nano',
    enabled: true,
    id: 'gpt-5-nano',
    maxOutput: 128_000,
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 400_000,
    description: 'GPT-5',
    displayName: 'GPT-5',
    enabled: true,
    id: 'gpt-5',
    maxOutput: 128_000,
    type: 'chat',
  },

  // GPT-4.1 / 4o series
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 1_047_576,
    description: 'GPT-4.1 provides stronger reasoning and generation.',
    displayName: 'GPT-4.1',
    enabled: true,
    id: 'gpt-4.1',
    maxOutput: 32_768,
    releasedAt: '2025-04-14',
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 1_047_576,
    description:
      'GPT-4.1 mini balances intelligence, speed, and cost, making it attractive for many use cases.',
    displayName: 'GPT-4.1 mini',
    enabled: true,
    id: 'gpt-4.1-mini',
    maxOutput: 32_768,
    releasedAt: '2025-04-14',
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 128_000,
    description: 'GPT-4.1 nano is the lightest variant with fast responses.',
    displayName: 'GPT-4.1 Nano',
    enabled: true,
    id: 'gpt-4.1-nano',
    maxOutput: 16_384,
    releasedAt: '2025-04-14',
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 128_000,
    description: 'A smaller GPT-4o variant with faster response speed.',
    displayName: 'GPT-4o Mini',
    enabled: true,
    id: 'gpt-4o-mini',
    maxOutput: 16_384,
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 128_000,
    description:
      'ChatGPT-4o is a dynamic model updated in real time, combining strong understanding and generation for large-scale use cases like customer support, education, and technical support.',
    displayName: 'ChatGPT-4o',
    enabled: true,
    id: 'chatgpt-4o-latest',
    maxOutput: 16_384,
    type: 'chat',
  },

  // OpenAI o series
  {
    abilities: { vision: true },
    contextWindowTokens: 200_000,
    description:
      'o4-mini is an OpenAI reasoning model with text+image input and text output, suited for complex tasks requiring broad knowledge, with a 200K context window.',
    displayName: 'o4-mini',
    enabled: true,
    id: 'o4-mini-2025-04-16',
    maxOutput: 200_000,
    releasedAt: '2025-4-16',
    type: 'chat',
  },
  {
    abilities: { vision: true },
    contextWindowTokens: 200_000,
    description:
      'o3 Pro is OpenAI’s new reasoning model with text+image input and text output for complex tasks requiring broad knowledge.',
    displayName: 'o3 Pro',
    enabled: true,
    id: 'o3-pro-2025-06-10',
    maxOutput: 200_000,
    releasedAt: '2025-6-10',
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 200_000,
    description:
      'o3 is OpenAI’s new reasoning model with text+image input and text output for complex tasks requiring broad knowledge.',
    displayName: 'o3',
    enabled: true,
    id: 'o3-2025-04-16',
    maxOutput: 200_000,
    releasedAt: '2025-4-16',
    type: 'chat',
  },

  // Anthropic Claude series
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 200_000,
    description:
      'Claude Opus 4.1 is Anthropic’s latest and most capable model for highly complex tasks, excelling in performance, intelligence, fluency, and understanding.',
    displayName: 'Claude Opus 4.1',
    enabled: true,
    id: 'claude-opus-4-1-20250805',
    maxOutput: 32_000,
    releasedAt: '2025-08-05',
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 200_000,
    description:
      'Claude Opus 4.1 Thinking is an advanced variant that can reveal its reasoning process.',
    displayName: 'Claude Opus 4.1 Thinking',
    enabled: true,
    id: 'claude-opus-4-1-20250805-thinking',
    maxOutput: 32_000,
    releasedAt: '2025-08-05',
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 200_000,
    description:
      'Claude Sonnet 4 can produce near-instant responses or extended step-by-step thinking with visible process.',
    displayName: 'Claude Sonnet 4',
    enabled: true,
    id: 'claude-sonnet-4-20250514',
    maxOutput: 64_000,
    releasedAt: '2025-05-23',
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 200_000,
    description:
      'Claude Sonnet 4 Thinking can produce near-instant responses or extended step-by-step thinking with visible process.',
    displayName: 'Claude Sonnet 4 Thinking',
    enabled: true,
    id: 'claude-sonnet-4-20250514-thinking',
    maxOutput: 64_000,
    releasedAt: '2025-05-23',
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 200_000,
    description:
      'Claude 3.7 Sonnet is Anthropic’s latest and most capable model for highly complex tasks, excelling in performance, intelligence, fluency, and understanding.',
    displayName: 'Claude 3.7 Sonnet Latest',
    enabled: true,
    id: 'claude-3-7-sonnet-latest',
    maxOutput: 64_000,
    releasedAt: '2025-08-05',
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 200_000,
    description: 'Claude 3.5 Haiku delivers fast responses for lightweight tasks.',
    displayName: 'Claude 3.5 Haiku',
    enabled: true,
    id: 'claude-3-5-haiku-latest',
    maxOutput: 64_000,
    type: 'chat',
  },

  // Google Gemini series
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 1_114_112,
    description:
      "Gemini 2.5 Pro is Google’s most advanced reasoning model, able to reason over code, math, and STEM problems and analyze large datasets, codebases, and documents with long context.",
    displayName: 'Gemini 2.5 Pro',
    enabled: true,
    id: 'gemini-2.5-pro',
    maxOutput: 65_536,
    releasedAt: '2025-03-25',
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 65_536,
    description:
      "Gemini 2.5 Flash is Google’s fast-response reasoning model, able to reason over code, math, and STEM problems and analyze large datasets, codebases, and documents with long context.",
    displayName: 'Gemini 2.5 flash',
    enabled: true,
    id: 'gemini-2.5-flash',
    maxOutput: 65_536,
    releasedAt: '2025-03-25',
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 1_048_576,
    description: 'Gemini 2.5 Flash optimized for cost efficiency and low latency.',
    displayName: 'Gemini 2.5 Flash-Lite',
    enabled: true,
    id: 'gemini-2.5-flash-lite',
    maxOutput: 8192,
    releasedAt: '2025-06-17',
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 1_000_000,
    description: 'Google’s latest Gemini 2.0 Flash model with a very large context window.',
    displayName: 'Gemini 2.0 Flash',
    enabled: true,
    id: 'gemini-2.0-flash',
    maxOutput: 8192,
    type: 'chat',
  },

  // xAI Grok series
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 131_072,
    description: "xAI’s Grok 4 with strong reasoning capability.",
    displayName: 'Grok 4',
    enabled: true,
    id: 'grok-4-0709',
    maxOutput: 4096,
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 131_072,
    description: "xAI’s Grok 3 with strong reasoning capability.",
    displayName: 'Grok 3',
    enabled: true,
    id: 'grok-3',
    maxOutput: 4096,
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 100_000,
    description: "xAI’s Grok 3 Mini with strong reasoning and fast responses.",
    displayName: 'Grok 3 Mini',
    enabled: true,
    id: 'grok-3-mini',
    maxOutput: 32_000,
    type: 'chat',
  },

  // DeepSeek series
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 128_000,
    displayName: 'deepseek-v3.1',
    enabled: true,
    id: 'deepseek-v3.1',
    maxOutput: 8000,
    type: 'chat',
  },
  {
    abilities: { functionCall: true, vision: true },
    contextWindowTokens: 64_000,
    description:
      'DeepSeek V3 is a latest large language model with strong reasoning, code generation, and multilingual understanding.',
    displayName: 'DeepSeek V3',
    enabled: true,
    id: 'deepseek-v3',
    maxOutput: 64_000,
    type: 'chat',
  },
  {
    abilities: { functionCall: true },
    contextWindowTokens: 64_000,
    description: 'DeepSeek R1 is a reasoning model for complex logical reasoning and math tasks.',
    displayName: 'DeepSeek R1',
    enabled: true,
    id: 'deepseek-r1-0528',
    maxOutput: 64_000,
    releasedAt: '2025-05-28',
    type: 'chat',
  },
  {
    abilities: { functionCall: true },
    contextWindowTokens: 64_000,
    description: 'A DeepSeek reasoning model focused on complex logical reasoning tasks.',
    displayName: 'DeepSeek Reasoner',
    enabled: true,
    id: 'deepseek-reasoner',
    maxOutput: 64_000,
    type: 'chat',
  },
  {
    abilities: { functionCall: true },
    contextWindowTokens: 64_000,
    description: 'A DeepSeek chat model that performs strongly in coding and reasoning.',
    displayName: 'DeepSeek Chat',
    enabled: true,
    id: 'deepseek-chat',
    maxOutput: 64_000,
    type: 'chat',
  },
];

export const allModels = [...cometapiChatModels];

export default allModels;
