import { AIChatModelCard } from '../types/aiModel';

// https://docs.wair.ac.cn/maas/jiage.html

const taichuChatModels: AIChatModelCard[] = [
  {
    abilities: {
      reasoning: true,
    },
    contextWindowTokens: 32_768,
    description:
      'taichu_o1 is a next-gen reasoning model that uses multimodal interaction and reinforcement learning to achieve human-like chain-of-thought, supports complex decision simulation, and exposes reasoning paths while maintaining high-accuracy outputs, suited for strategy analysis and deep thinking.',
    displayName: 'Taichu O1',
    enabled: true,
    id: 'taichu_o1',
    type: 'chat',
  },
  {
    abilities: {
      functionCall: true,
    },
    contextWindowTokens: 32_768,
    description:
      'Trained on massive high-quality data, with stronger text understanding, content creation, and conversational QA.',
    displayName: 'Taichu 2.0',
    enabled: true,
    id: 'taichu_llm',
    pricing: {
      currency: 'CNY',
      units: [
        { name: 'textInput', rate: 2, strategy: 'fixed', unit: 'millionTokens' },
        { name: 'textOutput', rate: 2, strategy: 'fixed', unit: 'millionTokens' },
      ],
    },
    type: 'chat',
  },
  {
    abilities: {
      vision: true,
    },
    contextWindowTokens: 4096,
    description:
      'Combines image understanding, knowledge transfer, and logical attribution, excelling in image-text QA.',
    displayName: 'Taichu 2.0 VL',
    enabled: true,
    id: 'taichu_vl',
    pricing: {
      currency: 'CNY',
      units: [
        { name: 'textInput', rate: 5, strategy: 'fixed', unit: 'millionTokens' },
        { name: 'textOutput', rate: 5, strategy: 'fixed', unit: 'millionTokens' },
      ],
    },
    type: 'chat',
  },
  {
    abilities: {
      reasoning: true,
    },
    contextWindowTokens: 131_072,
    description:
      'DeepSeek-R1 is a reinforcement-learning-driven reasoning model that addresses repetition and readability issues. Before RL, it uses cold-start data to further improve reasoning performance. It matches OpenAI-o1 on math, coding, and reasoning tasks, with carefully designed training improving overall results.',
    displayName: 'DeepSeek R1',
    id: 'deepseek_r1',
    type: 'chat',
  },
  {
    abilities: {
      reasoning: true,
    },
    contextWindowTokens: 131_072,
    description:
      'DeepSeek-R1-Distill-Qwen-14B is distilled from Qwen2.5-14B and fine-tuned on 800K curated samples generated by DeepSeek-R1, delivering strong reasoning.',
    displayName: 'DeepSeek R1 Distill Qwen 14B',
    id: 'deepseek_r1_distill_qwen_14b',
    type: 'chat',
  },
  {
    abilities: {
      reasoning: true,
    },
    contextWindowTokens: 131_072,
    description:
      'DeepSeek-R1-Distill-Qwen-32B is distilled from Qwen2.5-32B and fine-tuned on 800K curated samples generated by DeepSeek-R1, excelling in math, coding, and reasoning.',
    displayName: 'DeepSeek R1 Distill Qwen 32B',
    id: 'deepseek_r1_distill_qwen_32b',
    type: 'chat',
  },
  {
    abilities: {
      reasoning: true,
    },
    contextWindowTokens: 131_072,
    description:
      'DeepSeek-R1-Distill-Llama-70B is distilled from Llama-3.3-70B-Instruct. As part of the DeepSeek-R1 series, it is fine-tuned on DeepSeek-R1-generated samples and performs strongly in math, coding, and reasoning.',
    displayName: 'DeepSeek R1 Distill Llama 70B',
    id: 'deepseek_r1_distill_llama_70b',
    type: 'chat',
  },
  {
    abilities: {
      reasoning: true,
    },
    contextWindowTokens: 32_768,
    description:
      'Mid-sized reasoning model in the Qwen family. Compared with standard instruction-tuned models, QwQ’s thinking and reasoning abilities significantly boost downstream performance, especially on hard problems.',
    displayName: 'QwQ 32B',
    id: 'qwq_32b',
    type: 'chat',
  },
];

export const allModels = [...taichuChatModels];

export default allModels;
