import type { PartialDeep } from 'type-fest';
import { z } from 'zod';

/**
 * The function that the model called.
 */
export interface ToolFunction {
  /**
   * The arguments to call the function with, as generated by the model in JSON
   * format. Note that the model does not always generate valid JSON, and may
   * hallucinate parameters not defined by your function schema. Validate the
   * arguments in your code before calling your function.
   */
  arguments: string;

  /**
   * The name of the function to call.
   */
  name: string;
}

export interface MessageToolCall {
  /**
   * The function that the model called.
   */
  function: ToolFunction;

  /**
   * The ID of the tool call.
   */
  id: string;

  thoughtSignature?: string;
  /**
   * The type of the tool. Currently, only `function` is supported.
   */
  type: 'function' | string;
}

export const MessageToolCallSchema = z.object({
  function: z.object({
    arguments: z.string(),
    name: z.string(),
  }),
  id: z.string(),
  thoughtSignature: z.string().optional(),
  type: z.string(),
});

export type MessageToolCallChunk = PartialDeep<MessageToolCall> & { index: number };
