'use client';

import type { IconType } from '@lobehub/icons';
import { memo } from 'react';

const Icon: IconType = memo(({ size = '1em', style, ...rest }) => {
  return (
    <svg
      fill="currentColor"
      fillRule="evenodd"
      height={size}
      style={{ flex: 'none', lineHeight: 1, ...style }}
      viewBox="0 0 50 50"
      width={size}
      xmlns="http://www.w3.org/2000/svg"
      {...rest}
    >
      <path d="M49.324 7.34c-.94-1.17-2.61-1.32-3.96-1.33-3.929-.01-28.786-.01-32.386 0-3.999.01-5.579 1.27-6.479 5.17C4.409 20.19 2.33 29.21.27 38.23c-.31 1.37-.55 3.11.42 4.33.99 1.24 2.79 1.41 4.249 1.41 5.159.02 26.657.02 32.376 0 3.55-.01 5.469-1.51 6.239-4.88 2.28-9.98 4.309-19.02 6.199-27.64.291-1.3.501-2.95-.429-4.11zM14.758 38.28c-1.2.88-2.34 1.11-3.3-.2-1.07-1.45-.08-2.31 1.02-3.12 3.96-2.89 7.909-5.8 11.839-8.72.55-.41 1.27-.97 1.74-1.32-.61-.69-1.12-1.26-1.53-1.73-2.43-2.73-4.659-5.27-7.069-7.87-1.1-1.19-1.45-2.34-.13-3.52 1.31-1.16 2.6-1.06 3.789.28 3.34 3.72 6.679 7.44 10.069 11.1 1.27 1.37.98 2.3-.42 3.32-5.359 3.89-10.689 7.83-16.008 11.78zM32.246 38h-9.499c-1.13 0-1.75-1-1.75-2s.62-2 1.75-2h9.499c1.13 0 1.75 1 1.75 2s-.62 2-1.75 2z" />
    </svg>
  );
});

export default Icon;
