import { type ConnectionConfig, type DeploymentOption } from '@lobehub/market-types';

export const genServerConfig = (identifier?: string, connection?: ConnectionConfig) => {
  // 检查是否为 HTTP 类型
  if (connection?.url) {
    // HTTP 类型配置
    return JSON.stringify(
      {
        mcpServers: {
          [String(identifier)]: {
            url: connection.url,
          },
        },
      },
      null,
      2,
    );
  }

  // stdio 类型配置
  return JSON.stringify(
    {
      mcpServers: {
        [String(identifier)]: {
          args: connection?.args || [],
          command: connection?.command || {},
        },
      },
    },
    null,
    2,
  );
};

export const getRecommendedDeployment = (deploymentOptions: DeploymentOption[]) =>
  deploymentOptions?.find((item) => item.isRecommended) || deploymentOptions?.[0];

const languageColors: Record<string, string> = {
  'abap': '#e8274b',
  'actionscript': '#882b0f',
  'ada': '#02f88c',
  'agda': '#315665',
  'ags script': '#b9d9ff',
  'alloy': '#64c800',
  'ampl': '#e6efbb',
  'antlr': '#9dc3ff',
  'api blueprint': '#2acca8',
  'apl': '#5a8164',
  'arc': '#aa2afe',
  'arduino': '#bd79d1',
  'asp': '#6a40fd',
  'aspectj': '#a957b0',
  'assembly': '#6e4c13',
  'ats': '#1ac620',
  'autohotkey': '#6594b9',
  'autoit': '#1c3552',
  'blitzmax': '#cd6400',
  'boo': '#d4bec1',
  'brainfuck': '#2f2530',
  'c': '#555555',
  'c sharp': '#178600',
  'chapel': '#8dc63f',
  'cirru': '#ccccff',
  'clarion': '#db901e',
  'clean': '#3f85af',
  'click': '#e4e6f3',
  'clojure': '#db5855',
  'coffeescript': '#244776',
  'coldfusion': '#ed2cd6',
  'coldfusion cfc': '#ed2cd6',
  'common lisp': '#3fb68b',
  'component pascal': '#b0ce4e',
  'cpp': '#f34b7d',
  'crystal': '#776791',
  'css': '#563d7c',
  'd': '#ba595e',
  'dart': '#00b4ab',
  'diff': '#88dddd',
  'dm': '#447265',
  'dogescript': '#cca760',
  'dylan': '#6c616e',
  'e': '#ccce35',
  'eagle': '#814c05',
  'ec': '#913960',
  'ecl': '#8a1267',
  'edn': '#db5855',
  'eiffel': '#946d57',
  'elixir': '#6e4a7e',
  'elm': '#60b5cc',
  'emacs lisp': '#c065db',
  'emberscript': '#fff4f3',
  'erlang': '#b83998',

  'f#': '#b845fc',
  'factor': '#636746',
  'fancy': '#7b9db4',
  'fantom': '#dbded5',
  'flux': '#88ccff',
  'forth': '#341708',
  'fortran': '#4d41b1',
  'freemarker': '#0050b2',
  'frege': '#00cafe',
  'game maker language': '#8fb200',
  'glyph': '#e4cc98',
  'gnuplot': '#f0a9f0',
  'go': '#375eab',
  'golo': '#88562a',
  'gosu': '#82937f',
  'grammatical framework': '#79aa7a',
  'groovy': '#e69f56',
  'handlebars': '#01a9d6',
  'harbour': '#0e60e3',
  'haskell': '#29b544',
  'haxe': '#df7900',
  'html': '#e44b23',
  'hy': '#7790b2',
  'idl': '#a3522f',
  'io': '#a9188d',
  'ioke': '#078193',
  'isabelle': '#fefe00',
  'j': '#9eedff',
  'java': '#b07219',
  'javascript': '#f1e05a',
  'jflex': '#dbca00',
  'jsoniq': '#40d47e',
  'julia': '#a270ba',
  'jupyter notebook': '#da5b0b',
  'kotlin': '#f18e33',
  'krl': '#28431f',
  'lasso': '#999999',
  'latte': '#a8ff97',
  'lex': '#dbca00',
  'lfe': '#004200',
  'livescript': '#499886',
  'lols code': '#cc9900',
  'lookml': '#652b81',
  'lsl': '#3d9970',
  'lua': '#000080',
  'makefile': '#427819',
  'mask': '#f97732',
  'matlab': '#bb92ac',
  'max': '#c4a79c',
  'maxscript': '#00a6a6',
  'mercury': '#ff2b2b',
  'metal': '#8f14e9',
  'mirah': '#c7a938',
  'mtml': '#b7e1f4',
  'ncl': '#28431f',
  'nemerle': '#3d3c6e',
  'nesc': '#94b0c7',
  'netlinx': '#0aa0ff',
  'netlinx+erb': '#747faa',
  'netlogo': '#ff6375',
  'newlisp': '#87aed7',
  'nimrod': '#37775b',
  'nit': '#009917',
  'nix': '#7e7eff',
  'nu': '#c9df40',
  'objective-c': '#438eff',
  'objective-c++': '#6866fb',
  'objective-j': '#ff0c5a',
  'ocaml': '#3be133',
  'omgrofl': '#cabbff',
  'ooc': '#b0b77e',
  'opal': '#f7ede0',
  'oxygene': '#cdd0e3',
  'oz': '#fab738',
  'pan': '#cc0000',
  'papyrus': '#6600cc',
  'parrot': '#f3ca0a',
  'pascal': '#b0ce4e',
  'pawn': '#dbb284',
  'perl': '#0298c3',
  'perl6': '#0000fb',
  'php': '#4f5d95',
  'piglatin': '#fcd7de',
  'pike': '#005390',
  'plsql': '#dad8d8',
  'pogoscript': '#d80074',
  'processing': '#0096d8',
  'prolog': '#74283c',
  'propeller spin': '#7fa2a7',
  'puppet': '#302b6d',
  'pure data': '#91de79',
  'purebasic': '#5a6986',
  'purescript': '#1d222d',
  'python': '#3572a5',
  'qml': '#44a51c',
  'r': '#198ce7',
  'racket': '#22228f',
  'ragel in ruby host': '#9d5200',
  'raml': '#77d9fb',
  'rebol': '#358a5b',
  'red': '#ee0000',
  "ren'py": '#ff7f7f',
  'rouge': '#cc0088',
  'ruby': '#701516',
  'rust': '#dea584',
  'saltstack': '#646464',
  'sas': '#b34936',
  'scala': '#dc322f',
  'scheme': '#1e4aec',
  'self': '#0579aa',
  'shell': '#89e051',
  'shen': '#120f14',
  'slash': '#007eff',
  'slim': '#ff8f77',
  'smalltalk': '#596706',
  'sourcepawn': '#5c7611',
  'sqf': '#3f3f3f',
  'squirrel': '#800000',
  'stan': '#b2011d',
  'standard ml': '#dc566d',
  'supercollider': '#46390b',
  'swift': '#ffac45',
  'systemverilog': '#dae1c2',
  'tcl': '#e4cc98',
  'tex': '#3d6117',
  'turing': '#45f715',
  'typescript': '#2b7489',
  'unified parallel c': '#4e3617',
  'unity3d asset': '#ab69a1',
  'unrealscript': '#a54c4d',
  'vala': '#fbe5cd',
  'verilog': '#b2b7f8',
  'vhdl': '#adb2cb',
  'viml': '#199f4b',
  'visual basic': '#945db7',
  'volt': '#1f1f1f',
  'vue': '#2c3e50',
  'web ontology language': '#9cc9dd',
  'wisp': '#7582d1',
  'x10': '#4b6bef',
  'xbase': '#403a40',
  'xc': '#99da07',
  'xquery': '#5232e7',
  'zephir': '#118f9e',
};

export const getLanguageColor = (lang?: string): string => {
  if (!lang) return '#000000';
  return languageColors[lang.toLowerCase()] || '#000000'; // Default to black if not found
};
