import { businessErrorsLocales } from '@/business/locales/errors';

export default {
  'clerkAuth.loginSuccess.action': 'Continue Session',
  'clerkAuth.loginSuccess.desc':
    "{{greeting}}, it's great to continue serving you. Let's pick up where we left off.",
  'clerkAuth.loginSuccess.title': 'Welcome back, {{nickName}}',
  'error.backHome': 'Back to Home',
  'error.desc': 'Give it a try later, or go back to the known world.',
  'error.retry': 'Reload',
  'error.title': 'Oops, something went wrong..',
  'fetchError.detail': 'Error details',
  'fetchError.title': 'Request failed',
  'import.importConfigFile.description': 'Error reason: {{reason}}',
  'import.importConfigFile.title': 'Import Failed',
  'import.incompatible.description':
    'This file was exported from a higher version. Please try upgrading to the latest version and then re-importing.',
  'import.incompatible.title': 'Current application does not support importing this file',
  'loginRequired.desc': 'You will be redirected to the login page shortly',
  'loginRequired.title': 'Please log in to use this feature',
  'notFound.backHome': 'Back to Home',
  'notFound.check': 'Please check if your URL is correct.',
  'notFound.desc': "We couldn't find the page you were looking for.",
  'notFound.title': 'Entered Unknown Territory?',
  'pluginSettings.desc': 'Complete the following configuration to start using this skill',
  'pluginSettings.title': '{{name}} Skill Settings',
  'response.400':
    'Sorry, the server does not understand your request. Please make sure your request parameters are correct.',
  'response.401':
    'Sorry, the server has rejected your request, possibly due to insufficient permissions or invalid authentication.',
  'response.403':
    'Sorry, the server has rejected your request. You do not have permission to access this content.',
  'response.404':
    'Sorry, the server cannot find the page or resource you requested. Please make sure your URL is correct.',
  'response.405':
    'Sorry, the server does not support the request method you are using. Please make sure your request method is correct.',
  'response.406':
    'Sorry, the server cannot complete the request based on the characteristics of the content you requested',
  'response.407': 'Sorry, you need to authenticate the proxy before continuing with this request',
  'response.408':
    'Sorry, the server timed out while waiting for the request, please check your network connection and try again',
  'response.409':
    'Sorry, the request cannot be processed due to a conflict, possibly because the resource state is incompatible with the request',
  'response.410':
    'Sorry, the resource you requested has been permanently removed and cannot be found',
  'response.411': 'Sorry, the server cannot process the request without a valid content length',
  'response.412':
    "Sorry, your request does not meet the server's conditions and cannot be completed",
  'response.413': 'Sorry, your request data is too large for the server to process',
  'response.414': 'Sorry, the URI of your request is too long for the server to process',
  'response.415': 'Sorry, the server cannot process the media format attached to the request',
  'response.416': 'Sorry, the server cannot satisfy the range of your request',
  'response.417': 'Sorry, the server cannot meet your expectations',
  'response.422':
    'Sorry, your request is in the correct format, but due to semantic errors, it cannot be responded to',
  'response.423': 'Sorry, the resource you requested is locked',
  'response.424':
    'Sorry, the current request cannot be completed due to a previous request failure',
  'response.426': 'Sorry, the server requires your client to upgrade to a higher protocol version',
  'response.428':
    'Sorry, the server requires a precondition, and requests that your request contain the correct conditional header',
  'response.429':
    'Sorry, your request is too frequent and the server is a bit tired. Please try again later.',
  'response.431':
    'Sorry, the header fields of your request are too large for the server to process',
  'response.451': 'Sorry, the server refuses to provide this resource due to legal reasons',
  'response.499':
    'We apologize, your request was unexpectedly interrupted while being processed by the server, possibly due to your cancellation of the operation or an unstable network connection. Please check your network status and try again.',
  'response.500':
    'Sorry, the server seems to be experiencing some difficulties and is temporarily unable to complete your request. Please try again later.',
  'response.501':
    'Sorry, the server does not know how to handle this request yet. Please confirm that your operation is correct.',
  'response.502':
    'Sorry, the server seems to be lost and is temporarily unable to provide service. Please try again later.',
  'response.503':
    'Sorry, the server is currently unable to process your request, possibly due to overload or maintenance. Please try again later.',
  'response.504':
    'Sorry, the server did not receive a response from the upstream server. Please try again later.',
  'response.505':
    'Sorry, the server does not support the HTTP version you are using. Please update and try again.',
  'response.506':
    'Sorry, there is a configuration issue with the server. Please contact the administrator for resolution.',
  'response.507':
    'Sorry, the server has insufficient storage space to process your request. Please try again later.',
  'response.509': "Sorry, the server's bandwidth has been exhausted. Please try again later.",
  'response.510':
    'Sorry, the server does not support the requested extension. Please contact the administrator.',
  'response.520':
    'We apologize, the server encountered an unexpected issue that prevented it from completing your request. Please try again later; we are working to resolve this issue.',
  'response.522':
    'We apologize, the server connection timed out and was unable to respond to your request in a timely manner. This may be due to an unstable network or the server being temporarily inaccessible. Please try again later; we are working to restore service.',
  'response.524':
    'We apologize, the server timed out while waiting for a response, possibly due to a slow reply. Please try again later.',
  'response.AgentRuntimeError':
    'Lobe language model runtime execution error. Please troubleshoot or retry based on the following information.',
  'response.ComfyUIBizError':
    'An error occurred while requesting the ComfyUI service. Please troubleshoot using the information below or try again.',
  'response.ComfyUIEmptyResult':
    'No image was generated by ComfyUI. Please check the model configuration or try again.',
  'response.ComfyUIModelError':
    'Failed to load the ComfyUI model. Please ensure the model file exists.',
  'response.ComfyUIServiceUnavailable':
    'Failed to connect to the ComfyUI service. Please ensure it is running properly and the service URL is correctly configured.',
  'response.ComfyUIUploadFailed':
    'Failed to upload image to ComfyUI. Please check the server connection or try again.',
  'response.ComfyUIWorkflowError':
    'ComfyUI workflow execution failed. Please verify the workflow configuration.',
  'response.ConnectionCheckFailed':
    'The request returned empty. Please check if the API proxy address does not end with `/v1`.',
  'response.CreateMessageError':
    'Sorry, the message could not be sent successfully. Please copy the content and try sending it again. This message will not be retained after refreshing the page.',
  'response.ExceededContextWindow':
    'The current request content exceeds the length that the model can handle. Please reduce the amount of content and try again.',
  'response.FreePlanLimit':
    'You are currently a free user and cannot use this feature. Please upgrade to a paid plan to continue using it.',
  'response.GoogleAIBlockReason.BLOCKLIST':
    'Your content contains prohibited terms. Please review and modify your input, then try again.',
  'response.GoogleAIBlockReason.IMAGE_SAFETY':
    'The generated image was blocked for safety reasons. Please try modifying your image request.',
  'response.GoogleAIBlockReason.LANGUAGE':
    'The language you are using is not supported. Please try again in English or another supported language.',
  'response.GoogleAIBlockReason.OTHER':
    'The content was blocked for an unknown reason. Please try rephrasing your request.',
  'response.GoogleAIBlockReason.PROHIBITED_CONTENT':
    'Your request may contain prohibited content. Please adjust your request to comply with the usage guidelines.',
  'response.GoogleAIBlockReason.RECITATION':
    'Your content was blocked due to potential copyright concerns. Please try using original content or rephrase your request.',
  'response.GoogleAIBlockReason.SAFETY':
    'Your content was blocked for safety policy reasons. Please adjust your request to avoid potentially harmful or inappropriate content.',
  'response.GoogleAIBlockReason.SPII':
    'Your content may contain sensitive personally identifiable information (PII). To protect privacy, please remove any sensitive details and try again.',
  'response.GoogleAIBlockReason.default':
    'Content blocked: {{blockReason}}. Please adjust your request and try again.',
  'response.InsufficientQuota':
    "Sorry, the quota for this key has been reached. Please check if your account balance is sufficient or try again after increasing the key's quota.",
  'response.InvalidAccessCode':
    'Invalid access code or empty. Please enter the correct access code or add a custom API Key.',
  'response.InvalidBedrockCredentials':
    'Bedrock authentication failed. Please check the AccessKeyId/SecretAccessKey and retry.',
  'response.InvalidClerkUser':
    'Sorry, you are not currently logged in. Please log in or register an account to continue.',
  'response.InvalidComfyUIArgs':
    'Invalid ComfyUI configuration. Please check the settings and try again.',
  'response.InvalidGithubToken':
    'The GitHub Personal Access Token is incorrect or empty. Please check your GitHub Personal Access Token and try again.',
  'response.InvalidOllamaArgs':
    'Invalid Ollama configuration, please check Ollama configuration and try again',
  'response.InvalidProviderAPIKey':
    '{{provider}} API Key is incorrect or empty, please check your {{provider}} API Key and try again',
  'response.InvalidVertexCredentials':
    'Vertex authentication failed. Please check your credentials and try again.',
  'response.LocationNotSupportError':
    "We're sorry, your current location does not support this model service. This may be due to regional restrictions or the service not being available. Please confirm if the current location supports using this service, or try using a different location.",
  'response.ModelNotFound':
    'Sorry, the requested model could not be found. It may not exist or you may not have the necessary access permissions. Please try again after changing the API Key or adjusting your access permissions.',
  'response.NoOpenAIAPIKey': 'OpenAI API Key is empty, please add a custom OpenAI API Key',
  'response.OllamaBizError':
    'Error requesting Ollama service, please troubleshoot or retry based on the following information',
  'response.OllamaServiceUnavailable':
    'Ollama service is unavailable. Please check if Ollama is running properly or if the cross-origin configuration of Ollama is set correctly.',
  'response.PermissionDenied':
    'Sorry, you do not have permission to access this service. Please check if your key has the necessary access rights.',
  'response.PluginApiNotFound':
    "Sorry, the API does not exist in the skill's manifest. Please check if your request method matches the skill manifest API",
  'response.PluginApiParamsError':
    'Sorry, the input parameter validation for the skill request failed. Please check if the input parameters match the API description',
  'response.PluginFailToTransformArguments':
    'Sorry, the skill failed to parse the arguments. Please try regenerating the agent message or switch to a more powerful AI model with Tools Calling capability and try again',
  'response.PluginGatewayError':
    'Sorry, there was an error with the skill gateway. Please check if the skill gateway configuration is correct.',
  'response.PluginManifestInvalid':
    "Sorry, the skill's manifest validation failed. Please check if the manifest format is correct",
  'response.PluginManifestNotFound':
    "Sorry, the server could not find the skill's manifest file (manifest.json). Please check if the skill manifest file address is correct",
  'response.PluginMarketIndexInvalid':
    'Sorry, the skill index validation failed. Please check if the index file format is correct',
  'response.PluginMarketIndexNotFound':
    'Sorry, the server could not find the skill index. Please check if the index address is correct',
  'response.PluginMetaInvalid':
    "Sorry, the skill's metadata validation failed. Please check if the skill metadata format is correct",
  'response.PluginMetaNotFound':
    "Sorry, the skill was not found in the index. Please check the skill's configuration information in the index",
  'response.PluginOpenApiInitError':
    'Sorry, the OpenAPI client failed to initialize. Please check if the OpenAPI configuration information is correct.',
  'response.PluginServerError':
    'Skill server request returned an error. Please check your skill manifest file, skill configuration, or server implementation based on the error information below',
  'response.PluginSettingsInvalid':
    'This skill needs to be correctly configured before it can be used. Please check if your configuration is correct',
  'response.ProviderBizError':
    'Error requesting {{provider}} service, please troubleshoot or retry based on the following information',
  'response.QuotaLimitReached':
    "Sorry, the token usage or request count has reached the quota limit for this key. Please increase the key's quota or try again later.",
  'response.ServerAgentRuntimeError':
    'Sorry, the Agent service is currently unavailable. Please try again later or contact us via email for support.',
  'response.StreamChunkError':
    'Error parsing the message chunk of the streaming request. Please check if the current API interface complies with the standard specifications, or contact your API provider for assistance.',
  'response.SubscriptionKeyMismatch':
    'We apologize for the inconvenience. Due to a temporary system malfunction, your current subscription usage is inactive. Please click the button below to restore your subscription, or contact us via email for support.',
  'response.SubscriptionPlanLimit':
    'Your subscription points have been exhausted, and you cannot use this feature. Please upgrade to a higher plan or configure a custom model API to continue using it.',
  'response.SubscriptionPlanLimitUltimate':
    'Your subscription points have been exhausted, and you cannot use this feature. Please top up credits or configure a custom model API to continue using it.',
  'response.SystemTimeNotMatchError':
    'Sorry, your system time does not match the server. Please check your system time and try again.',
  'response.UnknownChatFetchError':
    'Sorry, an unknown request error occurred. Please check the information below or try again.',
  'stt.responseError': 'Service request failed, please check the configuration or try again',
  'supervisor.decisionFailed':
    'The group host is unable to function. Please check your host configuration to ensure the correct model, API Key, and API endpoint are set.',
  'testConnectionFailed': 'Test connection failed: {{error}}',
  'tts.responseError': 'Service request failed, please check the configuration or try again',
  'unlock.addProxyUrl': 'Add OpenAI proxy URL (optional)',
  'unlock.apiKey.description': 'Enter your {{name}} API Key to start the session',
  'unlock.apiKey.imageGenerationDescription': 'Enter your {{name}} API Key to start generating',
  'unlock.apiKey.title': 'Use custom {{name}} API Key',
  'unlock.closeMessage': 'Close message',
  'unlock.comfyui.description': 'Enter valid {{name}} credentials to start generating images.',
  'unlock.comfyui.modifyBaseUrl': 'Edit ComfyUI service URL',
  'unlock.comfyui.title': 'Verify your {{name}} credentials',
  'unlock.confirm': 'Confirm and Retry',
  'unlock.goToSettings': 'Go to Settings',
  'unlock.oauth.description':
    'The administrator has enabled unified login authentication. Click the button below to log in and unlock the application.',
  'unlock.oauth.success': 'Login successful',
  'unlock.oauth.title': 'Log in to your account',
  'unlock.oauth.welcome': 'Welcome!',
  'unlock.password.description':
    'The application encryption has been enabled by the administrator. Enter the application password to unlock the application. The password only needs to be filled in once.',
  'unlock.password.placeholder': 'Please enter password',
  'unlock.password.title': 'Enter Password to Unlock Application',
  'unlock.tabs.apiKey': 'Custom API Key',
  'unlock.tabs.password': 'Password',
  'upload.desc': 'Details: {{detail}}',
  'upload.fileOnlySupportInServerMode':
    'The current deployment mode does not support uploading non-image files. To upload files in {{ext}} format, please switch to server database deployment or use the {{cloud}} service.',
  'upload.networkError':
    "Please check your network connection and ensure that the file storage service's cross-origin configuration is correct.",
  'upload.title': 'File upload failed. Please check your network connection or try again later',
  'upload.unknownError': 'Error reason: {{reason}}',
  'upload.uploadFailed': 'File upload failed.',
  ...businessErrorsLocales,
};
