@journey @P0 @page
Feature: Page 编辑器富文本编辑

  作为用户，我希望能够使用富文本编辑器编写内容，
  以便创建格式丰富的文档

  Background:
    Given 用户已登录系统

  # ============================================
  # 基础文本编辑
  # ============================================

  @PAGE-CONTENT-001
  Scenario: 输入基础文本内容
    Given 用户打开一个文稿编辑器
    When 用户点击编辑器内容区域
    And 用户输入文本 "这是一段测试内容"
    Then 编辑器应该显示输入的文本

  @PAGE-CONTENT-002 @P1
  Scenario: 编辑已有内容
    Given 用户打开一个文稿编辑器
    When 用户在编辑器中输入内容 "原始内容"
    And 用户选中所有内容
    And 用户输入文本 "修改后的内容"
    Then 编辑器应该显示 "修改后的内容"

  # ============================================
  # 斜杠命令
  # ============================================

  @PAGE-SLASH-001 @P1
  Scenario: 使用斜杠命令打开菜单
    Given 用户打开一个文稿编辑器
    When 用户点击编辑器内容区域
    And 用户输入斜杠 "/"
    Then 应该显示斜杠命令菜单

  @PAGE-SLASH-002 @P1
  Scenario: 通过斜杠命令插入一级标题
    Given 用户打开一个文稿编辑器
    When 用户点击编辑器内容区域
    And 用户输入斜杠命令 "/h1"
    And 用户按下 Enter 键
    And 用户输入文本 "一级标题内容"
    Then 编辑器应该包含一级标题

  @PAGE-SLASH-003 @P1
  Scenario: 通过斜杠命令插入无序列表
    Given 用户打开一个文稿编辑器
    When 用户点击编辑器内容区域
    And 用户输入斜杠命令 "/ul"
    And 用户按下 Enter 键
    And 用户输入文本 "列表项一"
    Then 编辑器应该包含无序列表

  @PAGE-SLASH-004 @P2
  Scenario: 通过斜杠命令插入任务列表
    Given 用户打开一个文稿编辑器
    When 用户点击编辑器内容区域
    And 用户输入斜杠命令 "/tl"
    And 用户按下 Enter 键
    And 用户输入文本 "待办事项"
    Then 编辑器应该包含任务列表

  @PAGE-SLASH-005 @P2 @skip
  Scenario: 通过斜杠命令插入代码块
    Given 用户打开一个文稿编辑器
    When 用户点击编辑器内容区域
    And 用户输入斜杠命令 "/codeblock"
    And 用户按下 Enter 键
    Then 编辑器应该包含代码块

  # ============================================
  # 文本格式化
  # ============================================

  @PAGE-FORMAT-001 @P1
  Scenario: 使用快捷键加粗文本
    Given 用户打开一个文稿编辑器
    When 用户在编辑器中输入内容 "加粗文本"
    And 用户选中所有内容
    And 用户按下快捷键 "Meta+B"
    Then 选中的文本应该被加粗

  @PAGE-FORMAT-002 @P2
  Scenario: 使用快捷键斜体文本
    Given 用户打开一个文稿编辑器
    When 用户在编辑器中输入内容 "斜体文本"
    And 用户选中所有内容
    And 用户按下快捷键 "Meta+I"
    Then 选中的文本应该变为斜体
