'use client';

import type { IconType } from '@lobehub/icons';
import { memo } from 'react';

const Icon: IconType = memo(({ size = '1em', style, ...rest }) => {
  return (
    <svg
      fill="currentColor"
      fillRule="evenodd"
      height={size}
      style={{ flex: 'none', lineHeight: 1, ...style }}
      viewBox="0 0 50 50"
      width={size}
      xmlns="http://www.w3.org/2000/svg"
      {...rest}
    >
      <path d="M28.188 0c2.75 6.363-9.86 10.293-11.032 15.594-1.074 4.87 7.492 10.531 7.5 10.531-1.3-2.016-2.258-3.676-3.562-6.813C18.887 14.008 34.535 9.207 28.187 0zm8.375 8.813s-11.063.71-11.626 7.78c-.25 3.15 2.91 4.805 3 7.095.075 1.87-1.875 3.437-1.875 3.437s3.547-.676 4.657-3.531c1.23-3.168-2.399-5.309-2.032-7.844.352-2.426 7.875-6.938 7.875-6.938zM19.186 25.155s-10.125-.144-10.125 2.719c0 2.992 13.254 3.215 22.72 1.375 0 0 2.515-1.73 3.187-2.375-6.203 1.266-20.344 1.406-20.344.313 0-1.008 4.563-2.032 4.563-2.032zm19.47 0c-.993.078-2.063.461-3.032 1.157 2.281-.493 4.219.921 4.219 2.53 0 3.626-5.25 7.032-5.25 7.032s8.125-.922 8.125-6.875c0-2.703-1.88-4.016-4.063-3.844zM16.75 30.72c-1.555 0-3.875 1.218-3.875 2.375 0 2.324 11.688 4.113 20.344.718l-3-1.843c-5.867 1.879-16.672 1.265-13.469-1.25zm1.438 5.218c-2.13 0-3.532 1.286-3.532 2.25 0 2.985 12.715 3.286 17.75.25l-3.187-2.03c-3.762 1.59-13.203 1.831-11.032-.47zm-7.094 2.688c-3.469-.07-5.719 1.488-5.719 2.781 0 6.875 35.5 6.559 35.5-.468 0-1.168-1.348-1.735-1.844-2C41.934 45.656 9.97 45.12 9.97 41.156c0-.902 2.351-1.765 4.531-1.343l-1.844-1.063a12.349 12.349 0 00-1.562-.125zm33.531 4.625c-5.398 5.117-19.078 6.973-32.844 3.813 13.762 5.632 32.778 2.472 32.844-3.813z" />
    </svg>
  );
});

export default Icon;
