import { AlertColor } from '../../@mui/material/Alert';
import { CombinedState } from '../@reduxjs/toolkit/query';
import { ComponentType } from '../react';
import { ConnectedComponent } from '../../react-redux';
import { ConnectedComponent as ConnectedComponent_2 } from '../../../react-redux';
import { Context } from '../../react';
import { Context as Context_2 } from '../../../react';
import { EnhancedStore } from '../@reduxjs/toolkit';
import { FetchBaseQueryError } from '../@reduxjs/toolkit/query';
import { FetchBaseQueryMeta } from '../@reduxjs/toolkit/query';
import { GridComponentOption } from '../../echarts';
import { JSX as JSX_2 } from 'react';
import { MaybePromise } from '../@reduxjs/toolkit/dist/query/tsHelpers';
import { MutationDefinition } from '../@reduxjs/toolkit/query';
import { PaletteMode } from '../@mui/material';
import { QueryDefinition } from '../@reduxjs/toolkit/query';
import { QueryReturnValue } from '../@reduxjs/toolkit/dist/query/baseQueryTypes';
import { ReactNode } from '../../react';
import { ReactReduxContextValue } from '../../react-redux';
import { ReactReduxContextValue as ReactReduxContextValue_2 } from '../../../react-redux';
import { SelectProps } from '../../@mui/material';
import { Store } from '../../redux';
import { Store as Store_2 } from '../../../redux';
import { StoreEnhancer } from '.';
import { SxProps } from '../../@mui/material';
import { Theme } from '../@mui/material';
import { ThunkDispatch } from '../redux-thunk';
import { Tuple } from '../@reduxjs/toolkit';
import { UnknownAction } from '../../redux';
import { UnknownAction as UnknownAction_2 } from '../../../redux';
import { UnknownAction as UnknownAction_3 } from '.';
import { XAXisComponentOption } from '../../echarts';

export declare const baseTabs: ITab[];

export declare const createLocustStore: (preloadedState: Partial<IRootState>) => EnhancedStore<    {
api: CombinedState<    {
getStats: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, IStatsResponse, "api">;
getTasks: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, ISwarmRatios, "api">;
getExceptions: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, ISwarmExceptionsResponse, "api">;
getLogs: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, ILogsResponse, "api">;
startSwarm: MutationDefinition<ISwarmFormInput, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, IStartSwarmResponse, "api">;
updateUserSettings: MutationDefinition<any, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, any, "api">;
}, never, "api">;
logViewer: {
master: string[];
workers: {};
};
notification: {};
swarm: ISwarmState;
theme: {
isDarkMode: boolean;
};
ui: {
totalRps: number;
failRatio: number;
startTime: string;
stats: ISwarmStat[];
errors: ISwarmError[];
exceptions: ISwarmException[];
charts: ICharts;
ratios: ISwarmRatios;
userCount: number;
};
url: {
query: {
[key: string]: string;
} | null;
};
}, UnknownAction_3, Tuple<[StoreEnhancer<    {
dispatch: ThunkDispatch<    {
api: CombinedState<    {
getStats: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, IStatsResponse, "api">;
getTasks: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, ISwarmRatios, "api">;
getExceptions: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, ISwarmExceptionsResponse, "api">;
getLogs: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, ILogsResponse, "api">;
startSwarm: MutationDefinition<ISwarmFormInput, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, IStartSwarmResponse, "api">;
updateUserSettings: MutationDefinition<any, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, any, "api">;
}, never, "api">;
logViewer: {
master: string[];
workers: {};
};
notification: {};
swarm: ISwarmState;
theme: {
isDarkMode: boolean;
};
ui: {
totalRps: number;
failRatio: number;
startTime: string;
stats: ISwarmStat[];
errors: ISwarmError[];
exceptions: ISwarmException[];
charts: ICharts;
ratios: ISwarmRatios;
userCount: number;
};
url: {
query: {
[key: string]: string;
} | null;
};
}, undefined, UnknownAction_3>;
}>, StoreEnhancer]>>;

export declare function DarkLightToggle(): JSX_2.Element;

export declare function EditButton(swarmFormProps: ISwarmFormProps): JSX_2.Element;

declare function ExceptionsTab(): JSX_2.Element;

declare function FailuresTable({ errors }: {
    errors: ISwarmError[];
}): JSX_2.Element;

declare interface IAdvancedOptions extends ICustomInput {
    component?: React.ElementType;
}

declare interface IAuthArgs {
    usernamePasswordCallback?: string;
    error?: string;
    info?: string;
    authProviders?: IAuthProviders[];
    customForm?: {
        inputs: ICustomInput[];
        callbackUrl: string;
        submitButtonText?: string;
    };
}

declare interface IAuthProviders {
    label: string;
    iconUrl: string;
    callbackUrl: string;
}

declare interface IBaseChartType extends ILineChartMarkers, ILineChartTimeAxis {
    [key: string]: any;
}

declare interface ICharts extends ILineChartMarkers {
    currentRps: ((string | number)[] | NullChartValue)[];
    currentFailPerSec: ([string, number] | NullChartValue)[];
    [key: `responseTimePercentile${number}`]: ([string, number | null] | NullChartValue)[];
    totalAvgResponseTime: ([string, number] | NullChartValue)[];
    userCount: ([string, number] | NullChartValue)[];
    time: string[];
}

declare interface IClassRatio {
    [key: string]: {
        ratio: number;
        tasks: IClassRatio;
    };
}

declare interface ICustomInput {
    label: string;
    name: string;
    type?: string;
    choices?: string[] | null;
    defaultValue?: string | number | boolean | null;
    isSecret?: boolean;
    isRequired?: boolean;
}

declare interface IDispatchProps {
    setSwarm: (swarmPayload: Partial<ISwarmState>) => void;
}

export declare interface IExtendedReport {
    href: string;
    title: string;
}

export declare interface IExtendedStat<ExtendedTabKey, StatKey extends string> {
    key: ExtendedTabKey;
    data: IStatData<StatKey>[];
}

declare interface IExtendedStat_2 {
    key: string;
    data: IExtendedStatData[];
}

declare interface IExtendedStatData {
    name: string;
    safeName: string;
    [key: string]: number | string;
}

export declare interface IExtendedTable<ExtendedTabKey, StatKey> {
    key: ExtendedTabKey;
    structure: IExtendedTableStructure<StatKey>[];
}

export declare interface IExtendedTableStructure<StatKey> {
    key: StatKey | 'name' | 'method';
    title: string;
}

declare interface IExtraOptionParameter extends Omit<ICustomInput, 'name' | 'label'> {
    helpText: string | null;
}

declare interface IExtraOptions {
    [key: string]: IExtraOptionParameter;
}

declare interface IHistory {
    currentRps: [string, number];
    currentFailPerSec: [string, number];
    userCount: [string, number];
    currentResponseTimePercentiles: {
        [key: `responseTimePercentile${number}`]: [string, number | null];
    };
    totalAvgResponseTime: [string, number];
    time: string;
}

declare interface ILayout {
    children: ReactNode;
}

declare interface ILine<ChartType> {
    name: string;
    key: keyof ChartType;
    stack?: string;
    areaStyle?: {
        [key: string]: any;
    };
    yAxisIndex?: number;
}

declare interface ILineChart<ChartType> {
    charts: ChartType;
    title: string;
    lines: ILine<ChartType>[];
    colors?: string[];
    chartValueFormatter?: (value?: any) => string | number;
    splitAxis?: boolean;
    yAxisLabels?: string | [string, string];
    grid?: any;
    xAxis?: any;
    scatterplot?: boolean;
}

declare interface ILineChartMarkers {
    markers?: string[];
}

declare interface ILineChartProps<ChartType extends IBaseChartType> extends ILineChart<ChartType> {
    shouldReplaceMergeLines?: boolean;
    xAxis?: XAXisComponentOption;
    grid?: GridComponentOption;
}

declare interface ILineChartTimeAxis {
    time: string[];
}

export declare interface ILocustUi<ExtendedTabKey, StatKeys extends string> {
    extendedTabs?: ITab<ExtendedTabKey>[];
    extendedTables?: IExtendedTable<ExtendedTabKey, StatKeys>[];
    extendedReports?: IExtendedReport[];
    extendedStats?: IExtendedStat<ExtendedTabKey, StatKeys>[];
    tabs?: ITab[];
}

declare interface ILogsResponse {
    master: string[];
    workers: {
        [key: string]: string[];
    };
}

declare interface ILogViewerState extends ILogsResponse {
}

declare interface IModal {
    open: boolean;
    onClose: () => void;
    children?: React.ReactElement | React.ReactElement[];
}

declare interface INotificationState {
    [key: string]: boolean;
}

declare interface IReport {
    locustfile: string;
    showDownloadLink: boolean;
    startTime: string;
    endTime: string;
    duration: string;
    host: string;
    charts: ICharts;
    requestsStatistics: ISwarmStat[];
    failuresStatistics: ISwarmError[];
    responseTimeStatistics: IResponseTime[];
    exceptionsStatistics: ISwarmException[];
    tasks: ISwarmRatios;
}

declare interface IReportTemplateArgs extends Omit<IReport, 'charts'> {
    history: IHistory[];
    isReport?: boolean;
    percentilesToChart: number[];
    percentilesToStatistics: number[];
    profile?: string;
}

declare interface IResponseTime {
    method: string;
    name: string;
    [percentile: string]: string | number;
}

export declare interface IRootState {
    logViewer: ILogViewerState;
    notification: INotificationState;
    swarm: ISwarmState;
    theme: IThemeState;
    ui: IUiState;
    url: IUrlState;
}

declare type ISelect = SelectProps & {
    label: string;
    name: string;
    options: string[];
    multiple?: boolean;
    defaultValue?: string | string[];
    sx?: SxProps;
};

declare interface ISortByFieldOptions<Row> {
    hasTotalRow?: boolean;
    defaultSortKey?: keyof Row;
}

declare interface IStartSwarmResponse {
    success: boolean;
    message: string;
    host: string;
}

export declare type IStatData<StatKey extends string> = {
    [key in StatKey]: string;
} & {
    name: string;
    safeName: string;
};

declare interface IStateProps {
    extendedTabs?: ITab[];
    tabs?: ITab[];
}

declare interface IStatsResponse {
    extendedStats: IExtendedStat_2[];
    state: SwarmState;
    stats: ISwarmStat[];
    errors: ISwarmError[];
    workers: ISwarmWorker[];
    totalRps: number;
    totalFailPerSec: number;
    totalAvgResponseTime: number;
    currentResponseTimePercentiles: {
        [key: `responseTimePercentile${number}`]: number | null;
    };
    failRatio: number;
    userCount: number;
}

declare interface IStatsTable {
    stats: ISwarmStat[];
    tableStructure?: ITableStructure[];
}

declare interface ISwarmError {
    method: 'GET' | 'POST' | 'PUT' | 'DELETE';
    name: string;
    occurrences: number;
}

declare interface ISwarmException {
    count: number;
    msg: string;
    nodes: string;
    traceback: string;
}

declare interface ISwarmExceptionsResponse {
    exceptions: ISwarmException[];
}

declare interface ISwarmForm extends IDispatchProps, Pick<ISwarmState, 'allProfiles' | 'availableShapeClasses' | 'availableUserClasses' | 'extraOptions' | 'hideCommonOptions' | 'shapeUseCommonOptions' | 'host' | 'overrideHostWarning' | 'profile' | 'runTime' | 'showUserclassPicker' | 'spawnRate' | 'numUsers' | 'userCount'>, ISwarmFormProps {
}

declare interface ISwarmFormInput extends Partial<Pick<ISwarmState, 'host' | 'profile' | 'spawnRate' | 'userCount'>> {
    runTime?: string;
    userClasses?: string[];
    shapeClass?: string;
}

declare interface ISwarmFormProps extends Pick<ISwarmState, 'allProfiles'> {
    alert?: {
        level?: AlertColor;
        message: string;
    };
    isDisabled?: boolean;
    isEditSwarm?: boolean;
    onFormChange?: (formData: React.ChangeEvent<HTMLFormElement>) => void;
    onFormSubmit?: (inputData: ISwarmFormInput) => void;
    advancedOptions?: IAdvancedOptions[];
}

declare interface ISwarmMonitor extends Pick<ISwarmState, 'isDistributed' | 'host' | 'state' | 'workerCount'>, Pick<IUiState, 'totalRps' | 'failRatio' | 'userCount'> {
}

declare interface ISwarmRatios {
    perClass: IClassRatio;
    total: IClassRatio;
}

declare interface ISwarmStat {
    avgContentLength: number;
    avgResponseTime: number;
    currentFailPerSec: number;
    currentRps: number;
    maxResponseTime: number;
    medianResponseTime: number;
    method: 'GET' | 'POST' | 'PUT' | 'DELETE';
    minResponseTime: number;
    name: string;
    [key: `responseTimePercentile${number}`]: number;
    numFailures: number;
    numRequests: number;
    safeName: string;
}

declare interface ISwarmState {
    availableShapeClasses: string[];
    availableUserClasses: string[];
    availableUserTasks: {
        [key: string]: string[];
    };
    extraOptions: IExtraOptions;
    extendedTabs?: ITab[];
    extendedTables?: {
        key: string;
        structure: ITableStructure[];
    }[];
    extendedCsvFiles?: {
        href: string;
        title: string;
    }[];
    history: IHistory[];
    host: string;
    isDistributed: boolean;
    hideCommonOptions?: boolean | null;
    shapeUseCommonOptions?: boolean | null;
    locustfile: string;
    numUsers: number | null;
    overrideHostWarning: boolean;
    percentilesToChart: number[];
    percentilesToStatistics: number[];
    runTime?: string | number;
    showUserclassPicker: boolean;
    spawnRate: number | null;
    state: string;
    statsHistoryEnabled: boolean;
    tasks: string;
    userCount: number | string;
    users: {
        [key: string]: ISwarmUser;
    };
    version: string;
    workerCount: number;
    profile?: string;
    allProfiles?: string[];
}

declare interface ISwarmUser {
    fixedCount: number;
    host: string;
    weight: number;
    tasks: string[];
}

declare interface ISwarmWorker {
    cpuUsage: number;
    id: string;
    memoryUsage: number;
    state: (typeof SWARM_STATE)[keyof typeof SWARM_STATE];
    userCount: number;
}

export declare interface ITab<TabType = string> {
    component?: ComponentType;
    key: TabType;
    title: string;
    shouldDisplayTab?: (state: IRootState) => boolean;
}

declare interface ITable<Row> extends ISortByFieldOptions<Row> {
    rows: Row[];
    structure: ITableStructure[];
    children?: React.ReactElement;
    onTableHeadClick?: (event: React.MouseEvent<HTMLElement>) => void;
    currentSortField?: string;
}

declare interface ITableStructure {
    key: string;
    title: string;
    round?: number;
    markdown?: boolean;
}

declare interface ITabs extends IStateProps {
    currentTabIndexFromQuery: number;
    notification: INotificationState;
    setNotification: (payload: INotificationState) => void;
    setUrl: (payload: IUrlState) => void;
    tabs: ITab[];
}

declare interface IThemeState {
    isDarkMode: boolean;
}

declare interface IUiState {
    extendedStats?: IExtendedStat_2[];
    totalRps: number;
    failRatio: number;
    startTime: string;
    stats: ISwarmStat[];
    errors: ISwarmError[];
    workers?: ISwarmWorker[];
    exceptions: ISwarmException[];
    ratios: ISwarmRatios;
    charts: ICharts;
    userCount: number;
}

declare interface IUrlState {
    query: {
        [key: string]: string;
    } | null;
}

export declare interface IWindow {
    templateArgs: IReportTemplateArgs | ISwarmState;
    authArgs: IAuthArgs;
    theme?: PaletteMode;
    baseUrl?: string;
}

export declare function Layout({ children }: ILayout): JSX_2.Element;

export declare function LineChart<ChartType extends IBaseChartType>({ charts, title, lines, colors, chartValueFormatter, splitAxis, yAxisLabels, xAxis, grid, scatterplot, shouldReplaceMergeLines, }: ILineChartProps<ChartType>): JSX_2.Element;

declare function LocustCloudTab(): JSX_2.Element;

export declare const locustStore: EnhancedStore<    {
api: CombinedState<    {
getStats: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, IStatsResponse, "api">;
getTasks: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, ISwarmRatios, "api">;
getExceptions: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, ISwarmExceptionsResponse, "api">;
getLogs: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, ILogsResponse, "api">;
startSwarm: MutationDefinition<ISwarmFormInput, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, IStartSwarmResponse, "api">;
updateUserSettings: MutationDefinition<any, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, any, "api">;
}, never, "api">;
logViewer: {
master: string[];
workers: {};
};
notification: {};
swarm: ISwarmState;
theme: {
isDarkMode: boolean;
};
ui: {
totalRps: number;
failRatio: number;
startTime: string;
stats: ISwarmStat[];
errors: ISwarmError[];
exceptions: ISwarmException[];
charts: ICharts;
ratios: ISwarmRatios;
userCount: number;
};
url: {
query: {
[key: string]: string;
} | null;
};
}, UnknownAction_3, Tuple<[StoreEnhancer<    {
dispatch: ThunkDispatch<    {
api: CombinedState<    {
getStats: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, IStatsResponse, "api">;
getTasks: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, ISwarmRatios, "api">;
getExceptions: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, ISwarmExceptionsResponse, "api">;
getLogs: QueryDefinition<void, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, ILogsResponse, "api">;
startSwarm: MutationDefinition<ISwarmFormInput, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, IStartSwarmResponse, "api">;
updateUserSettings: MutationDefinition<any, (args: any, api: any, extraOptions: any) => MaybePromise<QueryReturnValue<unknown, FetchBaseQueryError, FetchBaseQueryMeta>>, never, any, "api">;
}, never, "api">;
logViewer: {
master: string[];
workers: {};
};
notification: {};
swarm: ISwarmState;
theme: {
isDarkMode: boolean;
};
ui: {
totalRps: number;
failRatio: number;
startTime: string;
stats: ISwarmStat[];
errors: ISwarmError[];
exceptions: ISwarmException[];
charts: ICharts;
ratios: ISwarmRatios;
userCount: number;
};
url: {
query: {
[key: string]: string;
} | null;
};
}, undefined, UnknownAction_3>;
}>, StoreEnhancer]>>;

declare function LocustUi<ExtendedTabKey extends string = string, StatKey extends string = string>({ extendedTabs, extendedTables, extendedReports, extendedStats, tabs, }: ILocustUi<ExtendedTabKey, StatKey>): JSX_2.Element;
export default LocustUi;

export declare function Logo(): JSX_2.Element;

declare function LogViewer(): JSX_2.Element;

export declare function Modal({ open, onClose, children }: IModal): JSX_2.Element;

export declare function Navbar(): JSX_2.Element;

export declare function NewTestButton(swarmFormProps: ISwarmFormProps): JSX_2.Element;

declare interface NullChartValue {
    value: null;
}

export declare const pushQuery: (query: {
    [key: string]: string;
}) => void;

export declare function ResetButton(): JSX_2.Element;

export declare const roundToDecimalPlaces: (n: number, decimalPlaces?: number) => number;

export declare function Select({ label, name, options, multiple, defaultValue, size, sx, ...inputProps }: ISelect): JSX_2.Element;

export declare function StateButtons(): JSX_2.Element | null;

declare function StatsTable({ stats, tableStructure }: IStatsTable): JSX_2.Element;

export declare function StopButton(): JSX_2.Element;

export declare const SWARM_STATE: {
    READY: string;
    RUNNING: string;
    STOPPED: string;
    SPAWNING: string;
    CLEANUP: string;
    STOPPING: string;
    MISSING: string;
};

declare function SwarmCharts({ charts }: {
    charts: ICharts;
}): JSX_2.Element[];

export declare const SwarmForm: ConnectedComponent<typeof SwarmForm_2, {
alert?: {
level?: AlertColor;
message: string;
} | undefined;
isDisabled?: boolean | undefined;
isEditSwarm?: boolean | undefined;
onFormChange?: ((formData: React.ChangeEvent<HTMLFormElement>) => void) | undefined;
onFormSubmit?: ((inputData: ISwarmFormInput) => void) | undefined;
advancedOptions?: IAdvancedOptions[] | undefined;
allProfiles?: string[] | undefined;
context?: Context<ReactReduxContextValue<any, UnknownAction> | null> | undefined;
store?: Store | undefined;
}>;

declare function SwarmForm_2({ allProfiles, availableShapeClasses, availableUserClasses, host, extraOptions, hideCommonOptions, shapeUseCommonOptions, numUsers, userCount, overrideHostWarning, profile, runTime, setSwarm, showUserclassPicker, spawnRate, alert, isDisabled, isEditSwarm, onFormChange, onFormSubmit, advancedOptions, }: ISwarmForm): JSX_2.Element;

export declare const SwarmMonitor: ConnectedComponent_2<typeof SwarmMonitor_2, {
context?: Context_2<ReactReduxContextValue_2<any, UnknownAction_2> | null> | undefined;
store?: Store_2 | undefined;
}>;

declare function SwarmMonitor_2({ isDistributed, state, host, totalRps, failRatio, userCount, workerCount, }: ISwarmMonitor): JSX_2.Element;

declare function SwarmRatiosTab(): JSX_2.Element;

declare type SwarmState = (typeof SWARM_STATE)[keyof typeof SWARM_STATE];

export declare const tabConfig: {
    stats: {
        component: ConnectedComponent<StatsTable, {
        tableStructure?: ITableStructure[] | undefined;
        context?: Context<ReactReduxContextValue<any, UnknownAction> | null> | undefined;
        store?: Store | undefined;
        }>;
        key: string;
        title: string;
    };
    charts: {
        component: ConnectedComponent<SwarmCharts, {
        context?: Context<ReactReduxContextValue<any, UnknownAction> | null> | undefined;
        store?: Store | undefined;
        }>;
        key: string;
        title: string;
    };
    failures: {
        component: ConnectedComponent<FailuresTable, {
        context?: Context<ReactReduxContextValue<any, UnknownAction> | null> | undefined;
        store?: Store | undefined;
        }>;
        key: string;
        title: string;
    };
    exceptions: {
        component: typeof ExceptionsTab;
        key: string;
        title: string;
    };
    ratios: {
        component: typeof SwarmRatiosTab;
        key: string;
        title: string;
    };
    reports: {
        component: ConnectedComponent<({ extendedCsvFiles, statsHistoryEnabled, }: Pick<ISwarmState, "extendedCsvFiles" | "statsHistoryEnabled">) => JSX_2.Element, {
        context?: Context<ReactReduxContextValue<any, UnknownAction> | null> | undefined;
        store?: Store | undefined;
        }>;
        key: string;
        title: string;
    };
    logs: {
        component: typeof LogViewer;
        key: string;
        title: string;
    };
    workers: {
        component: ConnectedComponent<({ workers }: {
        workers?: ISwarmWorker[];
        }) => JSX_2.Element, {
        context?: Context<ReactReduxContextValue<any, UnknownAction> | null> | undefined;
        store?: Store | undefined;
        }>;
        key: string;
        title: string;
        shouldDisplayTab: (state: IRootState) => boolean;
    };
    locustCloud: {
        component: typeof LocustCloudTab;
        key: string;
        title: string;
    };
};

export declare function Table<Row extends Record<string, any> = Record<string, string | number>>({ rows, structure, hasTotalRow, defaultSortKey, }: ITable<Row>): JSX_2.Element;

export declare const Tabs: ConnectedComponent<typeof Tabs_2, {
extendedTabs?: ITab[] | undefined;
tabs?: ITab[] | undefined;
context?: Context<ReactReduxContextValue<any, UnknownAction> | null> | undefined;
store?: Store | undefined;
}>;

declare function Tabs_2({ currentTabIndexFromQuery, notification, setNotification, setUrl, tabs }: ITabs): JSX_2.Element;

export declare function useCreateTheme(): Theme;

export declare function useFetchExceptions(): void;

export declare function useFetchStats(): void;

export declare function useFetchTasks(): void;

export declare function useInterval(callback: () => void, delay: number, { shouldRunInterval, immediate }?: {
    shouldRunInterval?: boolean;
    immediate?: boolean;
}): void;

export declare function useLogViewer(): ILogsResponse | {
    master: never[];
    workers: {};
};

export { }
