# How to submit your tip

To submit a tip to the list, fork the repository and add your tip in a new file in the correct folder (according language).  The name of the file should be `2016-xx-xx-name-of-your-tip`.

Use [this format](POST_TEMPLATE.md) when writing your tip.

### Requirements

- The tip should be readable in less than two minutes
- Adding links to other sites or videos that give more insight is welcome
- Mark JS code with ```js
- Don't mention "JavaScript" in the title (as our tips are about it anyway)
- Use backticks (`) to mark code in the **title** and/or **tip-tldr** fields. _Warning_: Both values must not start with backticks!
- How you can be rewarded: If you have a PayPal, Coinbase or another account, type the url on tip-writer-support. That's all! Now your readers will be able to grab you a beer for your knowledge.

Once your tip is ready, [issue a pull request](https://help.github.com/articles/using-pull-requests/) with this [PR template](PULL_REQUEST_TEMPLATE.md) and your tip will be reviewed (see below).

## Notes

Leave the date and the tip number as **xx**. When the PR is `ready to merge`, we will tell you the correct numbers. Please also [squash](https://davidwalsh.name/squash-commits-git) your commits.

## Tip flow

**Tip proposal** ⇒ **Tip under review** ⇒ **Tip ready to merge**

- When you send a tip, it has to pass the review process and while that happens, its status is `under review`.
- Once the tip is reviewed by 5 people and has been given the reviewer's ship it emote (:shipit:), the tip is `ready to merge`.


We are looking forward to your contribution!
