---
layout: post

title: Hoisting
tip-number: 11
tip-username: squizzleflip
tip-username-profile: https://twitter.com/squizzleflip
tip-tldr: Los pasos para crear módulos en JavaScript y constructores son cada vez más numerosos y complicados, pero ¿qué pasa con los boilerplate en nuevos frameworks?

redirect_from:
  - /es_es/hoisting/

categories:
    - es_ES
    - javascript
---

Comprendiendo [hoisting](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/var#var_hoisting) le ayudará a organizar su scope en una funcion. Sólo recuerde, las declaraciones de variables y definiciones de funciones se izan a la cima. Las definiciones de variables no lo son, incluso si se declara y define una variable en la misma línea. Además, una **declaración** de variable permite que el sistema sepa que existe la variable, mientras que **definición** asigne un valor.

```javascript
function doTheThing() {
  // ReferenceError: notDeclared is not defined
  console.log(notDeclared);

  // Outputs: undefined
  console.log(definedLater);
  var definedLater;

  definedLater = 'I am defined!'
  // Outputs: 'I am defined!'
  console.log(definedLater)

  // Outputs: undefined
  console.log(definedSimulateneously);
  var definedSimulateneously = 'I am defined!'
  // Outputs: 'I am defined!'
  console.log(definedSimulateneously)

  // Outputs: 'I did it!'
  doSomethingElse();

  function doSomethingElse(){
    console.log('I did it!');
  }

  // TypeError: undefined is not a function
  functionVar();

  var functionVar = function(){
    console.log('I did it!');
  }
}
```

Para hacer las cosas más fáciles de leer, declarar todas las variables en la parte superior de su función para que quede claro, que variables que estan en el scope están viniendo. Definir las variables antes que necesite utilizarlas. Definir sus funciones en la parte inferior de su scope para mantenerlos fuera de su camino.