# Awesome Astrophotography [![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)

[Astrophotography](https://en.wikipedia.org/wiki/Astrophotography), also known as astronomical imaging, is the photography or imaging of astronomical objects, celestial events, or areas of the night sky.

Contributions are welcome. Please read the [contributing guideline](CONTRIBUTING.md) if you wish to contribute.

## Contents

- [Articles](#articles)
- [Books](#books)
- [Tutorials](#tutorials)
- [Presentations](#presentations)
- [Software](#software)
  - [Acquisition](#acquisition)
  - [Guiding](#guiding)
  - [Image Processing](#image-processing)
  - [Planetarium](#planetarium)
  - [Planning](#planning)
  - [Other](#other)
- [YouTube Channels](#youtube-channels)
- [Reference](#reference)
- [Astronomy as a Service (AaaS)](#astronomy-as-a-service-aaas)
- [Community](#community)



## Articles

- [An Astrophotographer's Gentle Introduction To Noise](https://skyandtelescope.org/astronomy-blogs/imaging-foundations-richard-wright/astrophotography-gentle-introduction-noise/) - An easy to understand introduction to various sources of noise in astrophotography and how to eliminate them.
- [Autoguiding](https://astrobackyard.com/autoguiding/) - An introduction to auto-guiding.
- [Buyer's Guide to ZWO Astronomy Cameras](https://web.archive.org/web/20250828163126/https://agenaastro.com/articles/zwo-astronomy-cameras-buyers-guide.html) - ZWO has a diverse product line. This guide will help you make the right choice.
- [Cable Management Recommendations](https://pegasusastro.com/cable-management-recommendations/) - Some solid advice on cables in an astrophotography setup.
- [Cameras and Lenses](https://ciechanow.ski/cameras-and-lenses/) - Another interactive guide by Bartosz Ciechanowski, this time about cameras and lenses. A **must-read** for anyone interested in telescopes and photography.
- [Color Spaces](https://ciechanow.ski/color-spaces/) - Understanding color models, spaces, perception, white point, intensity matches and mismatches (and more!) is crucial for astrophotographers. Bartosz Ciechanowski explains it all in this interactive guide.
- [DeepSkyStacker vs PixInsight](https://web.archive.org/web/20230408140244/https://www.lightvortexastronomy.com/image-pre-processing-deepskystacker-vs-pixinsight.html) - A detailed comparison of the pre-processing features.
- [Drift Alignment by Robert Vice (D.A.R.V)](https://www.cloudynights.com/articles/cat/articles/darv-drift-alignment-by-robert-vice-r2760) - Accurate alignment in just a matter of minutes.
- [Flat Fields and Stray Light in Amateur Telescopes](https://diffractionlimited.com/flat-fields-stray-light-amateur-telescopes/) - A great resource to help one identify and resolve flat-fielding issues.
- [Guide Scope vs. Off-Axis Guider: Which is Better for Astrophotography?](https://web.archive.org/web/20240928205001/https://optcorp.com/blogs/deep-sky-imaging/guide-scope-vs-off-axis-guider) - Compares the two guiding options in details.
- [Guide to Focal Reducers for Astronomy](https://web.archive.org/web/20250501171410/https://agenaastro.com/articles/focal-reducers-guide.html) - How focal reducers work, what types are there, and how to use them.
- [Guide to Preprocessing of Raw Data With PixInsight](https://pixinsight.com/forum/index.php?threads/guide-to-preprocessing-of-raw-data-with-pixinsight.11547/) - Mistakes that happen during the pre-processing stages cannot be corrected anymore in post-processing. This guide from Bernd Landmann acquaints fellow astrophotographers with PixInsight's tools needed for recognising and avoiding such mistakes.
- [How to Set the Correct Back Focus](https://web.archive.org/web/20240928205054/https://optcorp.com/blogs/deep-sky-imaging/how-to-set-the-correct-back-focus) - An easy to follow guide on what back focus is and how to set it.
- [Lights and Shadows](https://ciechanow.ski/lights-and-shadows/) - This interactive guide to light by Bartosz Ciechanowski, teaches about travel vectors, irradiance, radiance, angles, luminance, and more.
- [Master PixInsight's Astrophotography Statistics: Analyze, Adjust, Enhance](https://www.kozmosi.io/articles/a-to-z-of-pixinsight-statistics-panel) - Successfully processing astronomical images entails a series of informed decisions. Understanding the data is crucial. This article provides a comprehensive guide to the Statistics process in PixInsight.
- [Mastering Flat Frames: Gain matching](https://www.astroworldcreations.com/blog/understanding-flats-part-1-gain-matching) - This blog series by Willem Jan Drijfhout will take you on a deep dive into the topic of flat frames ([Part 2: Flat Panels compared](https://www.astroworldcreations.com/blog/understanding-flats-part-2-flat-panels-compared), and [Part 3: Bias, Flat-Darks and Conclusions](https://www.astroworldcreations.com/blog/understanding-flats-part3-conclusions)).
- [Optical Glass Types](https://www.stellarvue.com/optical-glass-types/) - What makes a top-tier telescope? This article will clear up some common misconceptions.
- [Selecting a Guide Scope and Autoguiding Camera for Astrophotography](https://web.archive.org/web/20250501171421/https://agenaastro.com/articles/guides/selecting-a-guide-scope-and-autoguiding-camera-for-astrophotography.html) - Choosing the right autoguiding equipment can be challenging. This guide will help with making the right decision.
- [Signal, Noise and Histograms](https://jonrista.com/the-astrophotographers-guide/astrophotography-basics/signal-noise-and-histograms/) - Part of Jon Rista's Astrophotography Basics series, this article provides a great bit of theory around signals, noise and histograms.
- [Sky-Watcher AZ-GTI: The Perfect Mount for Mobile Astrophotography](https://web.archive.org/web/20221205012955/https://milkywayphotographers.com/article/2021/03/11/sky-watcher-az-gti-the-perfect-mount-for-mobile-astrophotography/) - The Sky-Watcher AZ-GTI mount was never meant for astrophotography. Oh, the irony!
- [The Differences between CCD and CMOS Sensors](https://www.atik-cameras.com/news/difference-between-ccd-cmos-sensors/) - One of the best explanations to CCD vs. CMOS camera sensors.
- [The best solution of 55mm back focal length](https://www.zwoastro.com/2024/09/26/the-best-solution-of-55mm-back-focal-length/) - Guidance on how to reach the 55mm back focal length with ASI cameras.


## Books

- [Astrophotography is Easy!: Basics for Beginners](https://www.goodreads.com/book/show/56053741-astrophotography-is-easy)
- [Inside PixInsight](https://www.goodreads.com/book/show/42603255-inside-pixinsight)
- [Mastering PixInsight (and the Art of Astroimage Processing)](https://www.cloudynights.com/topic/735971-mastering-pixinsight-by-rogelio-andreo/)
- [The Astrophotography Manual: A Practical and Scientific Approach to Deep Sky Imaging](https://www.goodreads.com/book/show/37301142-the-astrophotography-manual)
- [The Deep-Sky Imaging Primer](https://www.goodreads.com/book/show/61296649-the-deep-sky-imaging-primer-third-edition)



## Tutorials

- [A Beginner Guide to Night Photography](https://www.scottaspinall.com/beginner-guide-to-night-photography/) - If you're interested in night photography and particularly deepscapes, this guide hits the spot with it's succinctness.
- [Adam Block's PixInsight video series](https://www.adamblockstudios.com/categories/PixInsight) - An extensive collection of video lessons covering both the fundamental and advanced use of PixInsight.
- [Andromeda Galaxy with only a Camera, Lens, & Tripod](https://www.youtube.com/watch?v=pXcRKoxTPVg) - A comprehensive step-by-step guide. Includes a follow-up videos on post-processing the images in different apps.
- [Astrophotography RGB histogram in nine minutes](https://www.youtube.com/watch?v=9rAoJ-VG860) - A lightning explanation of what a histogram is.
- [Capturing Galaxyset](https://www.paulschmitphotography.com/How-To-Guides/Capturing-Galaxyset) - A detailed tutorial on how to plan, execute and post-process a deepscape of the Andromeda galaxy aligned with a mountain in Southern Colorado.
- [Chris White's Guide to Fixing Tilt and Spacing](https://overcastobservatory.com/products/guide-to-tilt-and-spacing-analysis-download-link-in-listing) - Annoying and hard to fix, tilt and spacing can ruin your imaging. This guide will help you eliminate them.
- [Filters for Deep Sky Astrophotography](https://www.youtube.com/playlist?list=PLrzbdmripj1fIXrivZF1BT4BtJMZ6xvWo) - A video series that kicks off with a gentle introduction to filters and closes down comparing the most popular ones.
- [Harry's PixInsight tutorials](https://web.archive.org/web/20220115193835/http://www.harrysastroshed.com/Pixinsighthome.html) - Newcomer friendly, down-to-earth and comprehensive video tutorials.
- [How to Eliminate Star Halos in PixInsight](https://digitalstars.wordpress.com/2019/10/27/tutorial-how-to-eliminate-star-halos-in-pixinsight/) - One of the more challenging issues in astrophotography. Charles Bracken, the author of “The Deep-Sky Imaging Primer”, has you covered.
- [How to Make a Padded Travel Box for Your Telescope](https://www.youtube.com/watch?v=90F_cBiZpH8) - Rig assembly on-site can be tedious. A more comfortable alternative is to assemble at home, then upon arrival at the imaging site, install on the mount.
- [Independent Starless Processing](https://www.nightphotons.com/guides/star-addition) - This article details a simple and effective method to separate, process, and later reintroduce stars into an image without artifacts. It also discusses how to get more naturally looking stars from a narrowband dataset.
- [Light Vortex Astronomy's PixInsight tutorials](https://web.archive.org/web/20230509214425/https://www.lightvortexastronomy.com/tutorials.html) - An extensive collection of tutorials covering both pre- and post-processing workflows.
- [Orion Nebula (M42) with a DSLR, Start to Finish](https://www.youtube.com/watch?v=Qb1ceFM-DkQ) - A complete walk-through. From planning to post-processing.
- [RGB Stars From Narrowband Data](https://aiastro.wordpress.com/2020/06/02/rgb-stars-from-narroband-data/) - Narrowband palettes such as SHO, HOO, etc. produce uncalibrated stars. One way to fix star color is to shoot also in RGB, then blend. In this article, Alberto Ibañez suggests another approach that uses the already acquired narrowband data to achieve the same.
- [Removing Color Artefacts From OSC Images](https://www.astroworldcreations.com/blog/removing-colour-artefacts-from-osc-images) - On his blog, Willem Jan Drijfhout explains how to remove color artefacts from images captured with a One-Shot-Color camera.
- [Stacking Multiple Sessions in DSS - The Correct Way](https://www.youtube.com/watch?v=cmDy80d2krk) - Even though it's from year 2012, this video on stacking multiple imaging sessions is still relevant today.



## Presentations

- [Basic Statistics for Astro Imaging](https://www.youtube.com/watch?v=T_k9B01AeFM) - Having some understanding of statistics is essential in astrophotography. Here, noted astrophotographer and scientist John Hayes teaches the basics.
- [Beauty and the Beholder](https://www.youtube.com/watch?v=SPFsoO0ZWeg) - On the hidden stories in astro-images and how to tell them. A truly inspirational message from famous astrophotographer Adam Block.
- [Deep Sky Astrophotography With CMOS Cameras by Dr Robin Glover](https://www.youtube.com/watch?v=3RH93UvP358) - How long should a sub-exposure be? How much to cool? What gain to use? Dr. Robin Glover of SharpCap talks us through the science behind deep sky astrophotography using modern CMOS imaging sensors.
- [Noise and Astrophotography](https://www.youtube.com/watch?v=1PUTWfWgD0g) - In this presentation, Tim Hutchison from The Astro Imaging Channel talks about the different types of signal and noise that are present in astronomical photos. How noise impacts photography and what we can do against it.



## Software

### Acquisition

- [APT](https://www.astrophotography.app) - The Swiss army knife for your astro imaging sessions.
- [Ekos](https://indilib.org) - An advanced cross-platform (Windows, macOS, Linux) observatory control and automation tool.
- [NINA](https://nighttime-imaging.eu) - Free and very powerful astrophotography imaging suite.
- [Nebulosity](https://github.com/celstark/OpenNebulosity) - Open source, powerful, and easy to use astrophotography software.
- [Sequence Generator Pro](https://www.sequencegeneratorpro.com) - The classic fully automated night sky imaging.
- [Voyager](https://software.starkeeper.it) - User-friendly system integration and astrophotography automation software.

### Guiding

- [MetaGuide](https://smallstarspot.com/metaguide/) - A free guiding software that uses novel centroid methods to reduce the impact of seeing. It also offers comprehensive collimation support than can be of great help for f/4 and faster Newtonian/SCT systems.
- [PHD2](https://openphdguiding.org) - Arguably THE guiding software. Free and open source.

### Image Processing

- [Adobe Photoshop](https://www.adobe.com/products/photoshop.html) - Advanced and very powerful software for post-processing.
- [BlurXTerminator](https://www.rc-astro.com/resources/BlurXTerminator/) - An AI based deconvolution tool. Currently only available as a process module plug-in for PixInsight.
- [DeepSkyStacker](http://deepskystacker.free.fr/english/index.html) - Registering, stacking, and simple post-processing.
- [PixInsight](https://pixinsight.com) - Advanced image processing software platform. Very powerful but the user interface is intimidating.
- [Siril](https://siril.org) - Registering, stacking, and post-processing, specially tailored for noise reduction and improving the signal-to-noise ratio.
- [StarNet++](https://sourceforge.net/projects/starnet/) - A simple program that allows the removal of the stars from astrophotography images.

### Planetarium

- [Cartes du Ciel](https://www.ap-i.net/skychart/doku.php?id=en/start) - Cross-platform and free sky charts.
- [KStars](https://kstars.kde.org) - Part of the free Ekos imaging suite, this cross-platform planetarium will help you image the sky.
- [Stellarium](https://stellarium.org) - Cross-platform and free planetarium with realistic 3D sky. It also has a [web-only alternative](https://stellarium-web.org/).

### Planning

- [12 Deep Sky Objects to Photograph](https://www.nebulaphotos.com/doc/brightLargeDsos.pdf) - A beginner friendly list of objects to photograph with a DSLR camera.
- [Astronomy Tools](https://astronomy.tools/) - A tools suite with various calculators, field of view simulation, star chart, etc.
- [Noise Analysis in Stacked Exposures](https://smallstarspot.com/shiny/StackSNR/) - A web application that assists in finding the optimal sub-exposure time. It takes into account the imaging setup, sky glow, etc.
- [Nova DSO Tracker](https://github.com/mrantonSG/nova_DSO_tracker) - A free and open source, self-hosted web application for astrophotography planning. Features both single and multi-user modes, making it suitable for individuals or entire astronomy clubs.
- [PhotoPills](https://www.photopills.com) - A photography planning mobile app (Android & iOS). It helps you plan your photos ahead of time so you’re always at the right place at the right time to capture the best photo possible.
- [SolarHam](https://www.solarham.com) - Real time Space Weather news and solar and geomagnetic activity data from various sources. All in one location for easy navigation. Indispensable for planning solar imaging sessions.
- [Telescopius](https://telescopius.com) - Free planning and image hosting for astrophotographers.
- [lightpollutionmap.info](https://www.lightpollutionmap.info) - This website uses satellite data to show light pollution related content.

### Other

- [FocusMax](https://ccdware.com/focusmax_overview/) - Accurate, automated and repeatable focusing.
- [Modulation Transfer Function and Image Sampling Analyzer](https://www.rc-astro.com/mtf-analyzer/) - This online tool provides insight into the capabilities of a given imaging system. It computes key values such as plate scale, stellar full-width at half-maximum (FWHM), diffraction limit and presents a graph of the system's modulation transfer function (MTF). Very useful for evaluating the performance of a telescope and camera combination.



## YouTube Channels

- [AstroBackyard](https://www.youtube.com/c/AstroBackyard) - Shoot nebulae, galaxies, and star clusters with Trevor Jones.
- [Cuiv, The Lazy Geek](https://www.youtube.com/channel/UC65vvpQDX5rymeqrYt-Bb1g) - Let's talk astronomy and astrophotography! Tutorials, technical videos, and insights by Cuiv, The Lazy Geek.
- [James Lamb](https://www.youtube.com/@Aero19612) - With his pleasant and down-to-earth narrative, James teaches astrophotography one pixel at a time.
- [Lukomatico](https://www.youtube.com/@lukomatico) - Experiments, comparisons, and processing with PixInsight. Lukomatico has it all.
- [Nebula Photos](https://www.youtube.com/channel/UCO_gBdHekc74feh0bWqKJ1Q) - Tutorials and reviews related to astrophotography by Nico Carver.
- [Patriot Astro](https://www.youtube.com/@PatriotAstro) - Everything N.I.N.A. Complete details with examples.



## Reference

- [Astrobin's Heatmap of the Sky](https://app.astrobin.com/i/e4clel) - An inspiring map showing the parts of the sky that the community on Astrobin photographs the most (or least).
- [Calibration Frames Cheat-Sheet](https://drive.google.com/file/d/1I1deTi8sCFIn_bwQbYiqqxliVLInsGx6/view) ([cached version](assets/docs/calibration-frames-cheatsheet.pdf))
- [Canon EOS DSLR models matrix](https://www.astrophotography.app/EOS.php) - A list of Canon EOS models with useful reference information such as sensor and pixel size, quantum efficiency, shutter life, etc.
- [Digital Camera Database](https://www.digicamdb.com) - A database holding sensor characteristics for a plethora of digital cameras.
- [IDAS filter comparison](https://www.cloudynights.com/topic/797739-idas-filter-comparison-test-report/?p=11487347) - CloudyNights forum member Jim Thompson tests and compares a large selection of IDAS brand filters. ([cached version](assets/docs/idas-test-report.pdf))
- [Low Level Landscape Lighting](http://lowlevellighting.org/) - A method for lighting the landscape for night-scape photography. This is its official site.
- [Messier](https://www.messier-objects.com/) - All objects from the Messier catalogue with lots of background information and images.
- [Nikon DSLR models matrix](https://www.astrophotography.app/nikon.php) - A list of Nikon models with useful reference information such as sensor and pixel size, quantum efficiency, shutter life, etc.
- [Northern Sky Narrowband Survey](https://www.simg.de/nebulae3/index.html) - This survey aims to catalog faint nebulae that have not been previously documented.
- [Online Narrowband RGB Combination Preview Tool](https://web.archive.org/web/20240928205042/https://www.bintel.com.au/narrowband-preview-tool/index.php) - This tool allows you to upload black and white source images (filtered eg. Ha, Sii, Oiii or R, G, B), then shows every possible permutation for the various combinations/palettes.
- [Photons to Photos](https://www.photonstophotos.net) - Interactive charts with sensor data contributed by people around the world.
- [Processing Methods Under PixInsight](https://astro-photographie.fr/traitement_pixinsight.html) - An extensive collection of workflow diagrams for image processing in PixInsight. It covers both one-shot and monochrome cameras. A great resource for beginners and advanced users alike.
- [Rouzastro equipment reviews](https://rouzastro.com/reviews/) - A growing list of equipment reviews. The experiences and results may prove useful for those looking at new gear.
- [Sharpless](http://www.sharplesscatalog.com/sharpless.aspx) - Images of all objects from the Sharpless catalogue each with capture and background information.
- [The 750 Best Deep Sky Objects (Reachable from the Northern Hemisphere)](https://app.astrobin.com/i/8cawy6) - A simplified tool to help astrophotographers easily find targets on any night of the year.



## Astronomy as a Service (AaaS)

- [Pixel Skies](https://www.pixelskiesastro.com) - Custom built remote observatories with hosting options.
- [RoboScopes](https://www.roboscopes.com) - Multi pier remote observatory with reasonable rates for the whole world to use. It offers hourly, syndicates & hosting piers for those who prefer to use their own equipment.
- [Telescope Live](https://app.telescope.live) - Online access to a global network of 10 robotic telescopes with an ever-increasing image archive.



## Community

- [Astrobin](https://www.astrobin.com) - Social image hosting dedicated to astrophotography.
- [Cloudy Nights](https://www.cloudynights.com) - Arguably the largest community forums.
- [Stargazers Lounge](https://stargazerslounge.com) - Small but active UK community forums.

