# Editor features

The **marimo editor** is the browser-based IDE in which you write marimo
notebooks. We've taken a batteries-included approach to designing the editor:
it comes _packed_ with features to make you productive when working
with code and data.

| Guide                                       | Description                                      |
| ------------------------------------------- | ------------------------------------------------ |
| [Overview](overview.md)                     | An overview of editor features and configuration |
| [Understanding dataflow](dataflow.md)       | Visualize and navigate cell dependencies         |
| [Package Management](package_management.md) | Using package managers in marimo                 |
| [AI Completion](ai_completion.md)           | Code with the help of a language model           |
| [Language Server](language_server.md)       | Code intelligence via LSP                        |
| [Hotkeys](hotkeys.md)                       | Our hotkeys                                      |

Highlights include:

- [dataflow tools](dataflow.md) including a variables panel, dependency graph, and minimap for understanding notebook structure
- a data explorer that lets you inspect dataframes and tables at a glance
- smart module autoreloading that tells you which cells need to be rerun
- code completion
- [GitHub Copilot](ai_completion.md#github-copilot)
- language-model assisted coding
- [language server protocol](language_server.md) (LSP) for diagnostics and code intelligence
- [vim keybindings](overview.md#vim-keybindings)
- live documentation preiews as you type

and much more.
