# Publishing notebooks to the web

You can publish marimo notebooks to the web as interactive editable notebooks,
readonly web apps, or [static documents](../exporting.md). Thanks to
[WebAssembly](../wasm.md), you can even share executable notebooks on GitHub
Pages or other static sites without paying for backend infrastrcture. This
makes it easy to share your work with colleagues, embed executable notebooks in
web documentation or educational websites, and more.

This guide provides an overview of the various ways to publish marimo notebooks.

!!! tip "Share cloud-hosted notebooks with molab"

    For a turn-key sharing experience, use [molab](https://molab.marimo.io/notebooks),
    our free cloud-hosted marimo notebook


| Guide                                                 | Description                                                  |
| ----------------------------------------------------- | ------------------------------------------------------------ |
| [Embedding](embedding.md)                             | An overview of embedding notebooks in other sites            |
| [From GitHub](from_github.md)                         | Share links to executable notebooks hosted on GitHub         |
| [From code snippets](from_code_snippets.md)           | Convert code snippets in Markdown or HTML to interactive notebooks |
| [GitHub Pages](github_pages.md)                       | Publish interactive notebooks on GitHub Pages                |
| [Cloudflare](cloudflare.md)                           | Publish interactive notebooks on Cloudflare                  |
| [Self-host WebAssembly notebooks](self_host_wasm.md)  | Self-hosting interactive WebAssembly (HTML export) notebooks |
| [Online playground](playground.md)                    | Share links to notebooks using our online playground         |
| [View notebooks on GitHub](view_outputs_on_github.md) | Viewing notebook outputs on GitHub                           |
| [Deploy on a backend](deploy.md)                      | Deploying notebooks on backends                              |
| [With Quarto](quarto.md)                              | Publish reactive websites with Quarto from markdown          |
