# Cycles

You're probably on this page because you just saw an error like this one:

<div align="center">
<figure>
<img src="/_static/docs_cycles_error.png" width="700px"/>
</figure>
</div>

marimo raises this error when a cell is involved in a cycle on variables. In
this example, the first cell declares `a` and reads `b`, while the second cell
declares `b` and reads `a`.

## Why can't I have cycles?

marimo parses your cells to understand the order in which they run:
run a cell, and cells that refer to its defined variables need to run afterward.
With a cycle, the execution order becomes ambiguous, while also introducing
an infinite loop.

**What do I get in return?**

By accepting this constraint on variables, marimo makes your notebooks:

- **reproducible**, with a well-defined execution order, no hidden state, and no hidden bugs;
- **executable** as a script;
- **interactive** with UI elements that work without callbacks;
- **shareable as a web app**, with far better performance than streamlit.

As a bonus, you'll find that you end up with cleaner, reusable code.

**How do I read the error message?** In the error message, each line says which
cell defines a variable and which cell reads a variable. For example, `cell-0
-> a` means `cell-0` defines `a`, and `a -> cell-1` means `cell-1` reads `a`.
Similarly, `cell-1 -> b` means `cell-1` defines `b`, and `b -> cell-0` means
`cell-0` reads `b`. This creates the cycle from `cell-0 -> cell-1 -> cell-0`.

## How do I fix this error?

Cycles usually indicate that your notebook has a bug. Still, you can
fix the error by merging the cells involved in the cycle into a single cell:

```python
a = 0
b = 1
a = b
b = a
```
